# Правила работы с [ZenHub](https://app.zenhub.com/)

## Имеющиеся инструменты и общее описание
ZenHub - онлайн инструмент для организации работы с задачами из GitHub репозитория, построенный по принципам канбан доски, в соответствии с методологией Agile.
Доски ZenHub создаются для каждого репозитория, которому есть доступ в GitHub. 
Задачи (Issues) полностью интегрированы с репозиторием в GitHub. Задачи, созданные в ZenHub также создаются в GitHub. 

К инструментам ZenHub можно отнести следующие:
* Pipeline - колонки канбан доски, которые служат для разбиения этапов работы над задачами (стандартный пример из 3х Pipelines: To Do, Work In Progress, Done)
* Issue - задача, созданная в репозитории или в ZenHub. Обладает свойствами:
    - Labels - ярлыки, помогающие классифицировать задачи, для каждой задачи можно поставить один или несколько ярлыков
    - Milestones - фазы проекта, позволяет соотносить задачи с фазами в которых они должны быть реализованы.
    - Estimates - оценка трудоемкости задачи (измеряется в story points). 
*Без данного показателя невозможно использовать диаграммы ZenHub*
    - Assignees - исполнители задачи.
    - Dependencies - зависимости. Позволяет определить те задачи, которые зависят от исполнения других.


## Практика использования ZenHub в проектах bootcamp

### Pipelines
Используется 5 колонок (pipelines):
* Backlog - задачи, которые планируются к выполнению в будущем
* Current sprint - задачи, которые запланированы к выполнению в текущем спринте (обычно длина спринта - 1 месяц)
* In Progress - задачи, находящиеся в работе (обязательно должен быть назначен исполнитель по задаче (assigner)
* Review/QA - задачи, находящиеся на проверке/тестировании
* Closed - исполненные задачи
![image](https://imageshack.com/a/img924/8473/iiiE30.jpg)

### Labels
В настоящее время используются следующие ярлыки:
* Epic - системообразующие задачи, которые могут быть декомпозированы на более мелкие задачи (декомпозированные задачи связываются с родительской epic)
* Bug - ошибки в системе. Задачи с данным лейблом имеют наивысший приоритет и должны быть взяты в работу первыми.
* Good-first-issue - задачи для разработчиков с минимальным опытом
* Feature - новая функциональность
* Bots - задачи, связанные с созданием ботов, автоматизирующих рутинный функционал
* Cucumber - создание bdd тестов на языке Cucumber
* Front-end - задачи связанные с фронтэнд разработкой
* Infrastructure - задачи, которые создают основу для работы системы
* Needs-clarification - задачи, требующие дополнительного описания
* Operations - задачи, необходимые для обеспечения работы системы
* Refactoring - задачи, связанные с корректировкой ранее написанного кода
* Technical - технические 
* To-estimate - задачи, по которым требуется определить их трудозатратность
* WIP - задачи, находящиеся в работе

### Estimates 
Для оценки трудозатратности используются единица измерения “story point”. В проектах bootcamp один story point соотносится с двумя рабочими днями участника проекта, что примерно равняется 6 часам+2. Оценку трудозатратности производит участник команды, создавший задачу (как правило Product Owner, Project Manager). Оценка трудозатратности может быть пересмотрена по соглашению автора задачи и исполнителя.
Порядок взятия задач в работу
Порядок работы с задачами на проектах bootcamp описан [здесь](https://github.com/howtohireme/wiki/wiki/Workflow)

## Отчеты ZenHub
ZenHub позволяет получать сводную информацию о выполнении задач в виде отчетов, предусмотренных в методологии Agile:
### Burndown (график “сгорания задач”). 
Данный отчет позволяет понять насколько команда успешно выполняет задачи в течение спринта (phase). По оси Х  - время спринта, по оси Y - общие трудозатраты (story points) невыполненных задач спринта. Серая пунктирная линия показывает идеальный график выполнения запланированных в текущем спринте задач. Синий график показывает реальное выполнение задач. Также в отчете приведено количество выполненных и оставшихся задач (справа) и трудозатраты выполненных и оставшихся задач (слева).
![image](https://imageshack.com/a/img923/1189/Jg3R5E.jpg)

### Velocity
Данный отчет показывает производительность команды в разрезе спринтов, а также среднюю производительность. Производительность измеряется в количестве story points выполненных задач. Текущий спринт выделен бирюзовым цветом, прошедшие - серым. Синяя линяя - средняя производительность по спринтам. В текущем спринте отображается общее количество запланированных story points. В прошедших - количество story points выполненных задач.
![image](https://imageshack.com/a/img923/3761/NaTJcK.jpg)

### Release report
В настоящее время не используется.
## Дополнительное описание ZenHub
Также информацию о работе с ZenHub можно найти [здесь](https://app.zenhub.com/dashboard/tutorials)
