## Contribution guidelines

### Setup
If you want to contribute to our project, then first of all you need to run it locally.
Choose between [traditional local setup](https://github.com/symbiod/symbiod/blob/master/docs/getting_started.md#to-run-the-application-natively) and [Vagrant](https://github.com/symbiod/symbiod/blob/master/vagrant/README.md).

### Choose task
We recommend all newcomers to first pick tasks with `good-first-issue`, that can be found [here](https://github.com/symbiod/symbiod/issues?q=is%3Aopen+is%3Aissue+label%3A%22good+first+issue%22).
They are relatively small, straighforward and allow you to get started with the project and explore our codebase.

### Checklist before merge
When you have done some changes, and want to share them with us - ensure that all development process requirements are satisfied:

* Keep your commits atomic. One commit - one change.
* Squash commits before merging master.
* Follow estabslished for this repository linters rules.
* Make sure that all CI checks pass.
* Get 2 approvals from Bootcamp team members before merge.
* Make sure that your branch does not have conflicts with master.
* Remove your branch after merge.
