export default {
  modules: [
    {
      source: "src/extract/add-validations.js",
      dependencies: [],
      orphan: false,
      valid: true,
    },
    {
      source: "src/extract/clear-caches.js",
      dependencies: [],
      orphan: false,
      valid: true,
    },
    {
      source: "src/extract/gather-initial-sources.js",
      dependencies: [],
      orphan: false,
      valid: true,
    },
    {
      source: "src/extract/get-dependencies.js",
      dependencies: [
        {
          resolved: "src/utl/array-util.js",
          coreModule: false,
          followable: true,
          couldNotResolve: false,
          dependencyTypes: ["local"],
          module: "../utl/array-util",
          moduleSystem: "cjs",
          dynamic: false,
          exoticallyRequired: false,
          matchesDoNotFollow: false,
          circular: false,
          valid: true,
        },
      ],
      orphan: false,
      valid: true,
    },
    {
      source: "src/utl/array-util.js",
      dependencies: [],
      orphan: false,
      reachable: [
        {
          value: true,
          asDefinedInRule: "some-via-rule",
        },
      ],
      valid: false,
      rules: [
        {
          severity: "error",
          name: "some-via-rule",
        },
      ],
    },
    {
      source: "src/extract/index.js",
      dependencies: [
        {
          resolved: "src/extract/add-validations.js",
          coreModule: false,
          followable: true,
          couldNotResolve: false,
          dependencyTypes: ["local"],
          module: "./add-validations",
          moduleSystem: "cjs",
          dynamic: false,
          exoticallyRequired: false,
          matchesDoNotFollow: false,
          circular: false,
          valid: true,
        },
        {
          resolved: "src/extract/clear-caches.js",
          coreModule: false,
          followable: true,
          couldNotResolve: false,
          dependencyTypes: ["local"],
          module: "./clear-caches",
          moduleSystem: "cjs",
          dynamic: false,
          exoticallyRequired: false,
          matchesDoNotFollow: false,
          circular: false,
          valid: true,
        },
        {
          resolved: "src/extract/gather-initial-sources.js",
          coreModule: false,
          followable: true,
          couldNotResolve: false,
          dependencyTypes: ["local"],
          module: "./gather-initial-sources",
          moduleSystem: "cjs",
          dynamic: false,
          exoticallyRequired: false,
          matchesDoNotFollow: false,
          circular: false,
          valid: true,
        },
        {
          resolved: "src/extract/get-dependencies.js",
          coreModule: false,
          followable: true,
          couldNotResolve: false,
          dependencyTypes: ["local"],
          module: "./get-dependencies",
          moduleSystem: "cjs",
          dynamic: false,
          exoticallyRequired: false,
          matchesDoNotFollow: false,
          circular: false,
          valid: true,
        },
        {
          resolved: "src/extract/summarize.js",
          coreModule: false,
          followable: true,
          couldNotResolve: false,
          dependencyTypes: ["local"],
          module: "./summarize",
          moduleSystem: "cjs",
          dynamic: false,
          exoticallyRequired: false,
          matchesDoNotFollow: false,
          circular: false,
          valid: true,
        },
      ],
      orphan: false,
      reaches: [
        {
          asDefinedInRule: "some-via-rule",
          modules: [
            {
              source: "src/utl/array-util.js",
            },
            {
              source: "src/utl/find-rule-by-name.js",
            },
          ],
        },
      ],
      valid: false,
      rules: [
        {
          severity: "error",
          name: "some-via-rule",
        },
      ],
    },
    {
      source: "src/extract/summarize.js",
      dependencies: [
        {
          resolved: "src/utl/find-rule-by-name.js",
          coreModule: false,
          followable: true,
          couldNotResolve: false,
          dependencyTypes: ["local"],
          module: "../utl/find-rule-by-name",
          moduleSystem: "cjs",
          dynamic: false,
          exoticallyRequired: false,
          matchesDoNotFollow: false,
          circular: false,
          valid: true,
        },
      ],
      orphan: false,
      valid: true,
    },
    {
      source: "src/utl/find-rule-by-name.js",
      dependencies: [],
      orphan: false,
      reachable: [
        {
          value: true,
          asDefinedInRule: "some-via-rule",
        },
      ],
      valid: false,
      rules: [
        {
          severity: "error",
          name: "some-via-rule",
        },
      ],
    },
  ],
  summary: {
    violations: [
      {
        type: "reachability",
        from: "src/extract/index.js",
        to: "src/utl/array-util.js",
        rule: {
          severity: "error",
          name: "some-via-rule",
        },
        via: [
          { name: "via-one", dependencyTypes: [] },
          { name: "via-two", dependencyTypes: [] },
        ],
      },
      {
        type: "reachability",
        from: "src/extract/index.js",
        to: "src/utl/find-rule-by-name.js",
        rule: {
          severity: "error",
          name: "some-via-rule",
        },
        via: [
          { name: "via-one", dependencyTypes: [] },
          { name: "via-two", dependencyTypes: [] },
        ],
      },
      {
        type: "module",
        from: "src/utl/array-util.js",
        to: "src/utl/array-util.js",
        rule: {
          severity: "error",
          name: "some-via-rule",
        },
      },
      {
        type: "module",
        from: "src/utl/find-rule-by-name.js",
        to: "src/utl/find-rule-by-name.js",
        rule: {
          severity: "error",
          name: "some-via-rule",
        },
      },
    ],
    error: 4,
    warn: 0,
    info: 0,
    totalCruised: 8,
    totalDependenciesCruised: 7,
    optionsUsed: {
      combinedDependencies: false,
      exclude: {
        path: "^src/extract/[^/]+/[^.]+\\.js$",
      },
      externalModuleResolutionStrategy: "node_modules",
      includeOnly: "^src/(utl|extract/[^.]+\\.js$)",
      moduleSystems: ["amd", "cjs", "es6"],
      outputTo: "-",
      outputType: "json",
      preserveSymlinks: false,
      rulesFile: "tmp-reachable.js",
      tsPreCompilationDeps: false,
      exoticRequireStrings: [],
      args: "src",
    },
    ruleSetUsed: {
      forbidden: [
        {
          name: "some-via-rule",
          severity: "error",
          from: {
            path: "^src/extract/index\\.js$",
          },
          to: {
            path: "^src/utl",
            reachable: true,
          },
        },
      ],
    },
  },
};
