export default {
  modules: [
    {
      source: "src/cache/cache.mjs",
      dependencies: [
        {
          dynamic: false,
          module: "./content-strategy.mjs",
          moduleSystem: "es6",
          exoticallyRequired: false,
          resolved: "src/cache/content-strategy.mjs",
          coreModule: false,
          followable: true,
          couldNotResolve: false,
          dependencyTypes: ["local"],
          matchesDoNotFollow: false,
          circular: false,
          valid: true,
        },
        {
          dynamic: false,
          module: "./metadata-strategy.mjs",
          moduleSystem: "es6",
          exoticallyRequired: false,
          resolved: "src/cache/metadata-strategy.mjs",
          coreModule: false,
          followable: true,
          couldNotResolve: false,
          dependencyTypes: ["local"],
          matchesDoNotFollow: false,
          circular: false,
          valid: true,
        },
        {
          dynamic: false,
          module: "./options-compatible.mjs",
          moduleSystem: "es6",
          exoticallyRequired: false,
          resolved: "src/cache/options-compatible.mjs",
          coreModule: false,
          followable: true,
          couldNotResolve: false,
          dependencyTypes: ["local"],
          matchesDoNotFollow: false,
          circular: false,
          valid: true,
        },
        {
          dynamic: false,
          module: "#extract/transpile/meta.mjs",
          moduleSystem: "es6",
          exoticallyRequired: false,
          resolved: "src/extract/transpile/meta.mjs",
          coreModule: false,
          followable: true,
          couldNotResolve: false,
          dependencyTypes: ["aliased", "aliased-subpath-import", "local"],
          matchesDoNotFollow: false,
          circular: false,
          valid: true,
        },
        {
          dynamic: false,
          module: "#utl/bus.mjs",
          moduleSystem: "es6",
          exoticallyRequired: false,
          resolved: "src/utl/bus.mjs",
          coreModule: false,
          followable: true,
          couldNotResolve: false,
          dependencyTypes: ["aliased", "aliased-subpath-import", "local"],
          matchesDoNotFollow: false,
          circular: false,
          valid: true,
        },
        {
          dynamic: false,
          module: "fs/promises",
          moduleSystem: "es6",
          exoticallyRequired: false,
          protocol: "node:",
          resolved: "fs/promises",
          coreModule: true,
          followable: false,
          couldNotResolve: false,
          dependencyTypes: ["core"],
          matchesDoNotFollow: false,
          circular: false,
          valid: true,
        },
        {
          dynamic: false,
          module: "path",
          moduleSystem: "es6",
          exoticallyRequired: false,
          protocol: "node:",
          resolved: "path",
          coreModule: true,
          followable: false,
          couldNotResolve: false,
          dependencyTypes: ["core"],
          matchesDoNotFollow: false,
          circular: false,
          valid: true,
        },
      ],
      dependents: [],
      orphan: false,
      valid: true,
      matchesHighlight: false,
    },
    {
      source: "fs/promises",
      followable: false,
      coreModule: true,
      couldNotResolve: false,
      matchesDoNotFollow: false,
      dependencyTypes: ["core"],
      dependencies: [],
      dependents: ["src/cache/cache.mjs", "src/cache/helpers.mjs"],
      orphan: false,
      valid: true,
      matchesHighlight: false,
    },
    {
      source: "path",
      followable: false,
      coreModule: true,
      couldNotResolve: false,
      matchesDoNotFollow: false,
      dependencyTypes: ["core"],
      dependencies: [],
      dependents: [
        "src/cache/cache.mjs",
        "src/cache/helpers.mjs",
        "src/utl/find-all-files.mjs",
        "src/utl/path-to-posix.mjs",
      ],
      orphan: false,
      valid: true,
      matchesHighlight: false,
    },
    {
      source: "src/cache/content-strategy.mjs",
      dependencies: [
        {
          dynamic: false,
          module: "./find-content-changes.mjs",
          moduleSystem: "es6",
          exoticallyRequired: false,
          resolved: "src/cache/find-content-changes.mjs",
          coreModule: false,
          followable: true,
          couldNotResolve: false,
          dependencyTypes: ["local"],
          matchesDoNotFollow: false,
          circular: false,
          valid: true,
        },
        {
          dynamic: false,
          module: "./helpers.mjs",
          moduleSystem: "es6",
          exoticallyRequired: false,
          resolved: "src/cache/helpers.mjs",
          coreModule: false,
          followable: true,
          couldNotResolve: false,
          dependencyTypes: ["local"],
          matchesDoNotFollow: false,
          circular: false,
          valid: true,
        },
        {
          dynamic: false,
          module: "path/posix",
          moduleSystem: "es6",
          exoticallyRequired: false,
          protocol: "node:",
          resolved: "path/posix",
          coreModule: true,
          followable: false,
          couldNotResolve: false,
          dependencyTypes: ["core"],
          matchesDoNotFollow: false,
          circular: false,
          valid: true,
        },
        {
          dynamic: false,
          module: "util",
          moduleSystem: "es6",
          exoticallyRequired: false,
          protocol: "node:",
          resolved: "util",
          coreModule: true,
          followable: false,
          couldNotResolve: false,
          dependencyTypes: ["core"],
          matchesDoNotFollow: false,
          circular: false,
          valid: true,
        },
      ],
      dependents: ["src/cache/cache.mjs"],
      orphan: false,
      valid: true,
      matchesHighlight: false,
    },
    {
      source: "path/posix",
      followable: false,
      coreModule: true,
      couldNotResolve: false,
      matchesDoNotFollow: false,
      dependencyTypes: ["core"],
      dependencies: [],
      dependents: [
        "src/cache/content-strategy.mjs",
        "src/cache/find-content-changes.mjs",
        "src/extract/transpile/try-import-available.mjs",
      ],
      orphan: false,
      valid: true,
      matchesHighlight: false,
    },
    {
      source: "util",
      followable: false,
      coreModule: true,
      couldNotResolve: false,
      matchesDoNotFollow: false,
      dependencyTypes: ["core"],
      dependencies: [],
      dependents: [
        "src/cache/content-strategy.mjs",
        "src/cache/metadata-strategy.mjs",
        "src/cache/options-compatible.mjs",
      ],
      orphan: false,
      valid: true,
      matchesHighlight: false,
    },
    {
      source: "src/cache/find-content-changes.mjs",
      dependencies: [
        {
          dynamic: false,
          module: "./helpers.mjs",
          moduleSystem: "es6",
          exoticallyRequired: false,
          resolved: "src/cache/helpers.mjs",
          coreModule: false,
          followable: true,
          couldNotResolve: false,
          dependencyTypes: ["local"],
          matchesDoNotFollow: false,
          circular: false,
          valid: true,
        },
        {
          dynamic: false,
          module: "#utl/bus.mjs",
          moduleSystem: "es6",
          exoticallyRequired: false,
          resolved: "src/utl/bus.mjs",
          coreModule: false,
          followable: true,
          couldNotResolve: false,
          dependencyTypes: ["aliased", "aliased-subpath-import", "local"],
          matchesDoNotFollow: false,
          circular: false,
          valid: true,
        },
        {
          dynamic: false,
          module: "#utl/find-all-files.mjs",
          moduleSystem: "es6",
          exoticallyRequired: false,
          resolved: "src/utl/find-all-files.mjs",
          coreModule: false,
          followable: true,
          couldNotResolve: false,
          dependencyTypes: ["aliased", "aliased-subpath-import", "local"],
          matchesDoNotFollow: false,
          circular: false,
          valid: true,
        },
        {
          dynamic: false,
          module: "path/posix",
          moduleSystem: "es6",
          exoticallyRequired: false,
          protocol: "node:",
          resolved: "path/posix",
          coreModule: true,
          followable: false,
          couldNotResolve: false,
          dependencyTypes: ["core"],
          matchesDoNotFollow: false,
          circular: false,
          valid: true,
        },
      ],
      dependents: ["src/cache/content-strategy.mjs"],
      orphan: false,
      valid: true,
      matchesHighlight: false,
    },
    {
      source: "src/cache/helpers.mjs",
      dependencies: [
        {
          dynamic: false,
          module: "#graph-utl/match-facade.mjs",
          moduleSystem: "es6",
          exoticallyRequired: false,
          resolved: "src/graph-utl/match-facade.mjs",
          coreModule: false,
          followable: true,
          couldNotResolve: false,
          dependencyTypes: ["aliased", "aliased-subpath-import", "local"],
          matchesDoNotFollow: false,
          circular: false,
          valid: true,
        },
        {
          dynamic: false,
          module: "crypto",
          moduleSystem: "es6",
          exoticallyRequired: false,
          protocol: "node:",
          resolved: "crypto",
          coreModule: true,
          followable: false,
          couldNotResolve: false,
          dependencyTypes: ["core"],
          matchesDoNotFollow: false,
          circular: false,
          valid: true,
        },
        {
          dynamic: false,
          module: "fs",
          moduleSystem: "es6",
          exoticallyRequired: false,
          protocol: "node:",
          resolved: "fs",
          coreModule: true,
          followable: false,
          couldNotResolve: false,
          dependencyTypes: ["core"],
          matchesDoNotFollow: false,
          circular: false,
          valid: true,
        },
        {
          dynamic: false,
          module: "fs/promises",
          moduleSystem: "es6",
          exoticallyRequired: false,
          protocol: "node:",
          resolved: "fs/promises",
          coreModule: true,
          followable: false,
          couldNotResolve: false,
          dependencyTypes: ["core"],
          matchesDoNotFollow: false,
          circular: false,
          valid: true,
        },
        {
          dynamic: false,
          module: "lodash/memoize.js",
          moduleSystem: "es6",
          exoticallyRequired: false,
          resolved: "node_modules/lodash/memoize.js",
          coreModule: false,
          followable: false,
          couldNotResolve: false,
          license: "MIT",
          dependencyTypes: ["npm"],
          matchesDoNotFollow: true,
          circular: false,
          valid: true,
        },
        {
          dynamic: false,
          module: "path",
          moduleSystem: "es6",
          exoticallyRequired: false,
          protocol: "node:",
          resolved: "path",
          coreModule: true,
          followable: false,
          couldNotResolve: false,
          dependencyTypes: ["core"],
          matchesDoNotFollow: false,
          circular: false,
          valid: true,
        },
      ],
      dependents: [
        "src/cache/content-strategy.mjs",
        "src/cache/find-content-changes.mjs",
        "src/cache/metadata-strategy.mjs",
      ],
      orphan: false,
      valid: true,
      matchesHighlight: false,
    },
    {
      source: "crypto",
      followable: false,
      coreModule: true,
      couldNotResolve: false,
      matchesDoNotFollow: false,
      dependencyTypes: ["core"],
      dependencies: [],
      dependents: ["src/cache/helpers.mjs"],
      orphan: false,
      valid: true,
      matchesHighlight: false,
    },
    {
      source: "fs",
      followable: false,
      coreModule: true,
      couldNotResolve: false,
      matchesDoNotFollow: false,
      dependencyTypes: ["core"],
      dependencies: [],
      dependents: ["src/cache/helpers.mjs", "src/utl/find-all-files.mjs"],
      orphan: false,
      valid: true,
      matchesHighlight: false,
    },
    {
      source: "node_modules/lodash/memoize.js",
      followable: false,
      coreModule: false,
      couldNotResolve: false,
      matchesDoNotFollow: true,
      dependencyTypes: ["npm"],
      dependencies: [],
      dependents: ["src/cache/helpers.mjs"],
      orphan: false,
      valid: true,
      matchesHighlight: false,
    },
    {
      source: "src/graph-utl/match-facade.mjs",
      dependencies: [],
      dependents: ["src/cache/helpers.mjs"],
      orphan: false,
      valid: true,
      matchesHighlight: false,
    },
    {
      source: "src/utl/bus.mjs",
      dependencies: [
        {
          dynamic: false,
          module: "events",
          moduleSystem: "es6",
          exoticallyRequired: false,
          protocol: "node:",
          resolved: "events",
          coreModule: true,
          followable: false,
          couldNotResolve: false,
          dependencyTypes: ["core"],
          matchesDoNotFollow: false,
          circular: false,
          valid: true,
        },
      ],
      dependents: [
        "src/cache/cache.mjs",
        "src/cache/find-content-changes.mjs",
        "src/cache/metadata-strategy.mjs",
      ],
      orphan: false,
      valid: true,
      matchesHighlight: false,
    },
    {
      source: "events",
      followable: false,
      coreModule: true,
      couldNotResolve: false,
      matchesDoNotFollow: false,
      dependencyTypes: ["core"],
      dependencies: [],
      dependents: ["src/utl/bus.mjs"],
      orphan: false,
      valid: true,
      matchesHighlight: false,
    },
    {
      source: "src/utl/find-all-files.mjs",
      dependencies: [
        {
          dynamic: false,
          module: "./path-to-posix.mjs",
          moduleSystem: "es6",
          exoticallyRequired: false,
          resolved: "src/utl/path-to-posix.mjs",
          coreModule: false,
          followable: true,
          couldNotResolve: false,
          dependencyTypes: ["local"],
          matchesDoNotFollow: false,
          circular: false,
          valid: true,
        },
        {
          dynamic: false,
          module: "fs",
          moduleSystem: "es6",
          exoticallyRequired: false,
          protocol: "node:",
          resolved: "fs",
          coreModule: true,
          followable: false,
          couldNotResolve: false,
          dependencyTypes: ["core"],
          matchesDoNotFollow: false,
          circular: false,
          valid: true,
        },
        {
          dynamic: false,
          module: "ignore",
          moduleSystem: "es6",
          exoticallyRequired: false,
          resolved: "node_modules/ignore/index.js",
          coreModule: false,
          followable: false,
          couldNotResolve: false,
          license: "MIT",
          dependencyTypes: ["npm"],
          matchesDoNotFollow: true,
          circular: false,
          valid: true,
        },
        {
          dynamic: false,
          module: "path",
          moduleSystem: "es6",
          exoticallyRequired: false,
          protocol: "node:",
          resolved: "path",
          coreModule: true,
          followable: false,
          couldNotResolve: false,
          dependencyTypes: ["core"],
          matchesDoNotFollow: false,
          circular: false,
          valid: true,
        },
      ],
      dependents: ["src/cache/find-content-changes.mjs"],
      orphan: false,
      valid: false,
      rules: [
        {
          severity: "info",
          name: "utl-module-not-shared-enough",
        },
      ],
      matchesHighlight: false,
    },
    {
      source: "node_modules/ignore/index.js",
      followable: false,
      coreModule: false,
      couldNotResolve: false,
      matchesDoNotFollow: true,
      dependencyTypes: ["npm"],
      dependencies: [],
      dependents: ["src/utl/find-all-files.mjs"],
      orphan: false,
      valid: true,
      matchesHighlight: false,
    },
    {
      source: "src/utl/path-to-posix.mjs",
      dependencies: [
        {
          dynamic: false,
          module: "path",
          moduleSystem: "es6",
          exoticallyRequired: false,
          protocol: "node:",
          resolved: "path",
          coreModule: true,
          followable: false,
          couldNotResolve: false,
          dependencyTypes: ["core"],
          matchesDoNotFollow: false,
          circular: false,
          valid: true,
        },
      ],
      dependents: ["src/utl/find-all-files.mjs"],
      orphan: false,
      valid: false,
      rules: [
        {
          severity: "info",
          name: "utl-module-not-shared-enough",
        },
      ],
      matchesHighlight: false,
    },
    {
      source: "src/cache/metadata-strategy.mjs",
      dependencies: [
        {
          dynamic: false,
          module: "./helpers.mjs",
          moduleSystem: "es6",
          exoticallyRequired: false,
          resolved: "src/cache/helpers.mjs",
          coreModule: false,
          followable: true,
          couldNotResolve: false,
          dependencyTypes: ["local"],
          matchesDoNotFollow: false,
          circular: false,
          valid: true,
        },
        {
          dynamic: false,
          module: "#utl/bus.mjs",
          moduleSystem: "es6",
          exoticallyRequired: false,
          resolved: "src/utl/bus.mjs",
          coreModule: false,
          followable: true,
          couldNotResolve: false,
          dependencyTypes: ["aliased", "aliased-subpath-import", "local"],
          matchesDoNotFollow: false,
          circular: false,
          valid: true,
        },
        {
          dynamic: false,
          module: "util",
          moduleSystem: "es6",
          exoticallyRequired: false,
          protocol: "node:",
          resolved: "util",
          coreModule: true,
          followable: false,
          couldNotResolve: false,
          dependencyTypes: ["core"],
          matchesDoNotFollow: false,
          circular: false,
          valid: true,
        },
        {
          dynamic: false,
          module: "watskeburt",
          moduleSystem: "es6",
          exoticallyRequired: false,
          resolved: "node_modules/watskeburt/dist/main.js",
          coreModule: false,
          followable: false,
          couldNotResolve: false,
          license: "MIT",
          dependencyTypes: ["npm"],
          matchesDoNotFollow: true,
          circular: false,
          valid: true,
        },
      ],
      dependents: ["src/cache/cache.mjs"],
      orphan: false,
      valid: true,
      matchesHighlight: true,
    },
    {
      source: "node_modules/watskeburt/dist/main.js",
      followable: false,
      coreModule: false,
      couldNotResolve: false,
      matchesDoNotFollow: true,
      dependencyTypes: ["npm"],
      dependencies: [],
      dependents: ["src/cache/metadata-strategy.mjs"],
      orphan: false,
      valid: true,
      matchesHighlight: false,
    },
    {
      source: "src/cache/options-compatible.mjs",
      dependencies: [
        {
          dynamic: false,
          module: "util",
          moduleSystem: "es6",
          exoticallyRequired: false,
          protocol: "node:",
          resolved: "util",
          coreModule: true,
          followable: false,
          couldNotResolve: false,
          dependencyTypes: ["core"],
          matchesDoNotFollow: false,
          circular: false,
          valid: true,
        },
      ],
      dependents: ["src/cache/cache.mjs"],
      orphan: false,
      valid: true,
      matchesHighlight: false,
    },
    {
      source: "src/extract/transpile/meta.mjs",
      dependencies: [
        {
          dynamic: false,
          module: "./try-import-available.mjs",
          moduleSystem: "es6",
          exoticallyRequired: false,
          resolved: "src/extract/transpile/try-import-available.mjs",
          coreModule: false,
          followable: true,
          couldNotResolve: false,
          dependencyTypes: ["local"],
          matchesDoNotFollow: false,
          circular: false,
          valid: true,
        },
        {
          dynamic: false,
          module: "#meta.cjs",
          moduleSystem: "es6",
          exoticallyRequired: false,
          resolved: "src/meta.js",
          coreModule: false,
          followable: true,
          couldNotResolve: false,
          dependencyTypes: ["aliased", "aliased-subpath-import", "local"],
          matchesDoNotFollow: false,
          circular: false,
          valid: true,
        },
      ],
      dependents: ["src/cache/cache.mjs"],
      orphan: false,
      valid: true,
      matchesHighlight: false,
    },
    {
      source: "src/extract/transpile/try-import-available.mjs",
      dependencies: [
        {
          dynamic: false,
          module: "module",
          moduleSystem: "es6",
          exoticallyRequired: false,
          protocol: "node:",
          resolved: "module",
          coreModule: true,
          followable: false,
          couldNotResolve: false,
          dependencyTypes: ["core"],
          matchesDoNotFollow: false,
          circular: false,
          valid: true,
        },
        {
          dynamic: false,
          module: "path/posix",
          moduleSystem: "es6",
          exoticallyRequired: false,
          protocol: "node:",
          resolved: "path/posix",
          coreModule: true,
          followable: false,
          couldNotResolve: false,
          dependencyTypes: ["core"],
          matchesDoNotFollow: false,
          circular: false,
          valid: true,
        },
        {
          dynamic: false,
          module: "semver",
          moduleSystem: "es6",
          exoticallyRequired: false,
          resolved: "node_modules/semver/index.js",
          coreModule: false,
          followable: false,
          couldNotResolve: false,
          license: "ISC",
          dependencyTypes: ["npm"],
          matchesDoNotFollow: true,
          circular: false,
          valid: true,
        },
      ],
      dependents: ["src/extract/transpile/meta.mjs"],
      orphan: false,
      valid: true,
      matchesHighlight: false,
    },
    {
      source: "module",
      followable: false,
      coreModule: true,
      couldNotResolve: false,
      matchesDoNotFollow: false,
      dependencyTypes: ["core"],
      dependencies: [],
      dependents: ["src/extract/transpile/try-import-available.mjs"],
      orphan: false,
      valid: true,
      matchesHighlight: false,
    },
    {
      source: "node_modules/semver/index.js",
      followable: false,
      coreModule: false,
      couldNotResolve: false,
      matchesDoNotFollow: true,
      dependencyTypes: ["npm"],
      dependencies: [],
      dependents: ["src/extract/transpile/try-import-available.mjs"],
      orphan: false,
      valid: true,
      matchesHighlight: false,
    },
    {
      source: "src/meta.js",
      dependencies: [],
      dependents: ["src/extract/transpile/meta.mjs"],
      orphan: false,
      valid: true,
      matchesHighlight: false,
    },
  ],
  summary: {
    violations: [
      {
        type: "module",
        from: "src/utl/find-all-files.mjs",
        to: "src/utl/find-all-files.mjs",
        rule: {
          severity: "info",
          name: "utl-module-not-shared-enough",
        },
      },
      {
        type: "module",
        from: "src/utl/path-to-posix.mjs",
        to: "src/utl/path-to-posix.mjs",
        rule: {
          severity: "info",
          name: "utl-module-not-shared-enough",
        },
      },
    ],
    error: 0,
    warn: 0,
    info: 2,
    ignore: 0,
    totalCruised: 25,
    totalDependenciesCruised: 37,
    optionsUsed: {
      baseDir: "/Users/sander/prg/js/dependency-cruiser",
      cache: {
        folder: "node_modules/.cache/dependency-cruiser",
        strategy: "metadata",
      },
      combinedDependencies: false,
      doNotFollow: {
        path: "node_modules",
        dependencyTypes: [
          "npm",
          "npm-dev",
          "npm-optional",
          "npm-peer",
          "npm-bundled",
          "npm-no-pkg",
        ],
      },
      enhancedResolveOptions: {
        exportsFields: ["exports"],
        conditionNames: ["import", "require"],
        extensions: [".js", ".mjs", ".d.ts"],
      },
      exclude: {
        path: "mocks|fixtures|test/integration|src/cli/tools/svg-in-html-snippets/script.snippet.js",
      },
      exoticRequireStrings: [
        "tryRequire",
        "tryImport",
        "requireJSON",
        "proxyquire.load",
      ],
      externalModuleResolutionStrategy: "node_modules",
      metrics: false,
      moduleSystems: ["cjs", "es6"],
      outputTo: "-",
      outputType: "json",
      prefix: "https://github.com/sverweij/dependency-cruiser/blob/main/",
      preserveSymlinks: false,
      reporterOptions: {
        archi: {
          collapsePattern:
            "^(src|test)/[^/]+|^bin/|node_modules/(@[^/]+/[^/]+|[^/]+)",
        },
        dot: {
          collapsePattern: "^src/report/[^/]+|^src/enrich/derive/[^/]+",
          filters: {
            includeOnly: {
              path: "^(src|bin)",
            },
            exclude: {
              path: "^src/meta\\.js$|^src/utl/bus.+",
            },
          },
          theme: {
            replace: false,
            graph: {
              splines: "ortho",
            },
            modules: [
              {
                criteria: {
                  matchesFocus: true,
                },
                attributes: {
                  fillcolor: "lime",
                  penwidth: 2,
                },
              },
              {
                criteria: {
                  matchesReaches: true,
                },
                attributes: {
                  fillcolor: "lime",
                  penwidth: 2,
                },
              },
              {
                criteria: {
                  matchesHighlight: true,
                },
                attributes: {
                  fillcolor: "yellow",
                  penwidth: 2,
                },
              },
              {
                criteria: {
                  source: "^src/cli",
                },
                attributes: {
                  fillcolor: "#ccccff",
                },
              },
              {
                criteria: {
                  source: "^src/config-utl",
                },
                attributes: {
                  fillcolor: "#99ffff",
                },
              },
              {
                criteria: {
                  source: "^src/report",
                },
                attributes: {
                  fillcolor: "#ffccff",
                },
              },
              {
                criteria: {
                  source: "^src/extract",
                },
                attributes: {
                  fillcolor: "#ccffcc",
                },
              },
              {
                criteria: {
                  source: "^src/enrich",
                },
                attributes: {
                  fillcolor: "#77eeaa",
                },
              },
              {
                criteria: {
                  source: "^src/validate",
                },
                attributes: {
                  fillcolor: "#ccccff",
                },
              },
              {
                criteria: {
                  source: "^src/main",
                },
                attributes: {
                  fillcolor: "#ffcccc",
                },
              },
              {
                criteria: {
                  source: "^src/utl",
                },
                attributes: {
                  fillcolor: "#cccccc",
                },
              },
              {
                criteria: {
                  source: "^src/graph-utl",
                },
                attributes: {
                  fillcolor: "#ffcccc",
                },
              },
              {
                criteria: {
                  source: "^src/meta\\.js$|\\.schema\\.mjs$",
                },
                attributes: {
                  style: "filled",
                },
              },
              {
                criteria: {
                  source: "\\.json$",
                },
                attributes: {
                  shape: "cylinder",
                },
              },
            ],
            dependencies: [
              {
                criteria: {
                  "rules[0].severity": "error",
                },
                attributes: {
                  fontcolor: "red",
                  color: "red",
                },
              },
              {
                criteria: {
                  "rules[0].severity": "warn",
                },
                attributes: {
                  fontcolor: "orange",
                  color: "orange",
                },
              },
              {
                criteria: {
                  "rules[0].severity": "info",
                },
                attributes: {
                  fontcolor: "blue",
                  color: "blue",
                },
              },
              {
                criteria: {
                  valid: false,
                },
                attributes: {
                  fontcolor: "red",
                  color: "red",
                },
              },
              {
                criteria: {
                  resolved: "^src/cli",
                },
                attributes: {
                  color: "#0000ff77",
                },
              },
              {
                criteria: {
                  resolved: "^src/config-utl",
                },
                attributes: {
                  color: "#22999977",
                },
              },
              {
                criteria: {
                  resolved: "^src/report",
                },
                attributes: {
                  color: "#ff00ff77",
                },
              },
              {
                criteria: {
                  resolved: "^src/extract",
                },
                attributes: {
                  color: "#00770077",
                },
              },
              {
                criteria: {
                  resolved: "^src/enrich",
                },
                attributes: {
                  color: "#00776677",
                },
              },
              {
                criteria: {
                  resolved: "^src/validate",
                },
                attributes: {
                  color: "#0000ff77",
                },
              },
              {
                criteria: {
                  resolved: "^src/main",
                },
                attributes: {
                  color: "#77000077",
                },
              },
              {
                criteria: {
                  resolved: "^src/utl",
                },
                attributes: {
                  color: "#aaaaaa77",
                },
              },
              {
                criteria: {
                  resolved: "^src/graph-utl",
                },
                attributes: {
                  color: "#77000077",
                },
              },
            ],
          },
        },
        metrics: {
          orderBy: "name",
          hideModules: true,
          hideFolders: false,
        },
        text: {
          highlightFocused: true,
        },
        anon: {
          wordlist: [
            "aap",
            "noot",
            "mies",
            "wim",
            "zus",
            "jet",
            "teun",
            "vuur",
            "gijs",
            "lam",
            "kees",
            "bok",
            "weide",
            "does",
            "hok",
            "duif",
            "schapen",
            "raam",
            "roos",
            "neef",
            "fik",
            "gat",
            "wiel",
            "zes",
            "juk",
            "schop",
            "voet",
            "neus",
            "muur",
            "bijl",
            "ei",
            "ui",
          ],
        },
      },
      rulesFile: ".dependency-cruiser.json",
      tsPreCompilationDeps: true,
      args: "src/cache",
    },
    ruleSetUsed: {
      forbidden: [
        {
          name: "not-to-unresolvable",
          comment:
            "This module tried to depend on something that can't be resolved to disk. Revise yer code",
          severity: "error",
          from: {},
          to: {
            couldNotResolve: true,
            exoticallyRequired: false,
          },
        },
        {
          name: "no-orphans",
          comment:
            "This is an orphan module - it's likely not used (anymore?). Either use it or remove it. If it's logical this module is an orphan (i.e. it's a config file), add an exception for it in your dependency-cruiser configuration. By default this rule does not scrutinize dotfiles (e.g. .eslintrc.js), TypeScript declaration files (.d.ts/ .d.cts/ .d.mts), tsconfig.json and some of the babel and webpack configs.",
          severity: "error",
          from: {
            orphan: true,
            pathNot: [
              "(^|/)\\.[^/]+\\.(js|cjs|mjs|ts|json)$",
              "\\.d\\.ts$",
              "(^|/)tsconfig\\.json$",
              "(^|/)(babel|webpack)\\.config\\.(js|cjs|mjs|ts|json)$",
              "-reporter-plugin\\.mjs$",
              "\\.schema\\.json$",
              "^tools/istanbul-json-summary-to-markdown\\.mjs$",
              "^src/report/json\\.mjs",
              "^src/report/identity\\.mjs",
              "^src/report/null\\.mjs",
            ],
          },
          to: {},
        },
        {
          name: "cli-to-main-only",
          comment:
            "This cli module depends on something not in the public interface - which means it either doesn't belong in cli, or the main public interface needs to be expanded.",
          severity: "error",
          from: {
            path: "(^src/cli/)",
          },
          to: {
            pathNot: [
              "^src/(main|utl|config-utl)/",
              "node_modules/",
              "^os$",
              "^fs(/promises)?$",
              "^path$",
              "^url$",
              "$1",
              "^src/meta\\.js$",
              "^src/extract/transpile/meta\\.mjs$",
            ],
          },
        },
        {
          name: "report-stays-in-report",
          comment:
            "This reporting module depends directly on a non-reporting one that is not a utility. That is odd as reporting modules should only read dependency cruiser output json.",
          severity: "error",
          from: {
            path: "(^src/report/)",
          },
          to: {
            pathNot: [
              "$1",
              "node_modules/",
              "^os$",
              "^path$",
              "^path/posix$",
              "^src/meta\\.js$",
              "^src/graph-utl",
              "^src/utl",
            ],
          },
        },
        {
          name: "extract-to-utl-only",
          comment:
            "This extraction module depends on something outside extraction that is not a utility. Which is odd, given the goal of the extraction step.",
          severity: "error",
          from: {
            path: "(^src/extract/)",
          },
          to: {
            pathNot: [
              "$1",
              "node_modules/",
              "^(path|path/posix|fs|module|os)$",
              "^src/meta\\.js$",
              "^types/",
              "^src/graph-utl",
              "^src/utl",
            ],
            exoticallyRequired: false,
          },
        },
        {
          name: "not-to-json",
          comment:
            "We don't want to depend on .json modules as long as they're still impractical to work with in ecmascript modules",
          from: {
            path: "^src/",
          },
          to: {
            path: "\\.json$",
          },
        },
        {
          name: "bin-to-cli-only",
          comment:
            "This module in the bin/ folder depends on something not in the cli interface. This means it either contains code that doesn't belong in bin/, or the thing it depends upon should be put in the cli interface. ",
          severity: "error",
          from: {
            path: "(^bin/)",
          },
          to: {
            pathNot: ["^src/cli", "node_modules/", "^src/meta\\.js$", "^os$"],
          },
        },
        {
          name: "restrict-fs-access",
          comment:
            "This module depends on a the node 'fs' module, and it resides in a spot where that is not allowed.",
          severity: "error",
          from: {
            pathNot: [
              "^src/(main/resolve-options/normalize\\.mjs|extract/parse|extract/resolve|extract/gather-initial-sources\\.mjs|config-utl|cli|cache|utl/find-all-files\\.mjs)",
              "^test",
              "^tools",
            ],
          },
          to: {
            path: "^fs$",
          },
        },
        {
          name: "no-inter-module-test",
          comment:
            "This test depends on something in the test tree that is neither a utility, nor a mock nor a fixture.",
          severity: "error",
          from: {
            path: "(^test/[^\\/]+/)[^\\.]+\\.spec\\.js",
          },
          to: {
            path: "^test/[^\\/]+/.+",
            pathNot: ["utl", "$1.+\\.json$"],
          },
        },
        {
          name: "prefer-lodash-individuals",
          comment:
            "This module directly depends on 'lodash' as a whole. Preferably don't include lodash as a whole, but use individual lodash packages instead e.g. 'lodash/get' - this keeps the download of the package small(er)",
          severity: "info",
          from: {},
          to: {
            path: "lodash\\.js$",
          },
        },
        {
          name: "no-dep-on-test",
          comment:
            "This module depends on a spec files. A spec file should have a single responsibility (testing whether a module function correctly). If there's something in a spec that's of use, factor it out into (e.g.) a separate utility/ helper or mock",
          severity: "error",
          from: {
            path: "^(src|bin)",
          },
          to: {
            path: "^test|\\.spec\\.js$",
          },
        },
        {
          name: "no-external-to-here",
          comment:
            "Apparently something outside of the src/ test/ and bin/ points to something inside them. That's incredibly odd and might denote a security problem.",
          severity: "error",
          from: {
            pathNot: "^(src|test|bin)",
          },
          to: {
            path: "^(src|test)",
          },
        },
        {
          name: "not-to-dev-dep",
          severity: "error",
          comment:
            "In production code do not depend on external ('npm') modules not declared in your package.json's dependencies - otherwise a production only install (i.e. 'npm ci') will break. If this rule triggers on something that's only used during development, adapt the 'from' of the rule in the dependency-cruiser configuration.",
          from: {
            path: "^(bin|src)",
          },
          to: {
            dependencyTypes: ["npm-dev"],
            exoticallyRequired: false,
          },
        },
        {
          name: "only-known-exotic",
          severity: "error",
          comment:
            "The only 'exotic' requires allowed are tryRequire and requireJSON",
          from: {},
          to: {
            exoticRequireNot:
              "^(tryRequire|tryImport|requireJSON|proxyquire\\.load)$",
            exoticallyRequired: true,
          },
        },
        {
          name: "optional-deps-used",
          severity: "error",
          comment:
            "This module uses an external dependency that in package.json shows up as an optional dependency. In dependency-cruiser optional dependencies donot make sense - and are hence forbidden. Either make it a regular dependency (if it's production code) or a dev one (if it's for development only)",
          from: {},
          to: {
            dependencyTypes: ["npm-optional"],
          },
        },
        {
          name: "peer-deps-used",
          comment:
            "This module uses an external dependency that in package.json shows up as a peer dependency. In dependency-cruiser peer dependencies donot make sense - and are hence forbidden. Either make it a regular dependency (if it's production code) or a dev one (if it's for development only)",
          severity: "error",
          from: {},
          to: {
            dependencyTypes: ["npm-peer"],
          },
        },
        {
          name: "no-unvetted-license",
          comment:
            "This module uses an external dependency that has license that's not vetted. The license itself might be OK, but bigcorp legal departments might get jittery over anything other than MIT (or ISC).",
          severity: "error",
          from: {},
          to: {
            licenseNot: "MIT|ISC|Apache-2\\.0",
          },
        },
        {
          name: "not-unreachable-from-cli",
          severity: "error",
          comment:
            "This module in the src/ tree is not reachable from the cli - and is likely dead wood. Either use it or remove it. If a module is flagged for which it's logical it is not reachable from cli (i.e. a configuration file), add it to the pathNot in the 'to' of this rule.",
          from: {
            path: "^bin/",
          },
          to: {
            path: "^src",
            pathNot: ["\\.schema\\.json$", "\\.d\\.ts$", "^src/report/"],
            reachable: false,
          },
        },
        {
          name: "not-unreachable-from-test",
          comment:
            "This module in src is not reachable by any test. Please provide a test that covers this (poor man's test coverage - this task is better suited for a proper test coverage tool :-) )",
          severity: "warn",
          from: {
            path: "\\.spec\\.m?js$",
          },
          to: {
            path: "^src",
            pathNot: ["\\.schema\\.json$", "\\.d\\.ts$", "^src/report/"],
            reachable: false,
          },
        },
        {
          name: "not-reachable-from-folder-index",
          comment:
            "(sample rule to demo reachable rules with capturing groups)",
          severity: "info",
          from: {
            path: "^src/([^/]+)/index\\.js$",
          },
          to: {
            path: ["^src/$1/"],
            pathNot: "\\.d\\.ts$",
            reachable: false,
          },
        },
        {
          name: "utl-module-not-shared-enough",
          comment: "(sample rule to demo rules based on dependents)",
          severity: "info",
          from: {
            path: "^src",
          },
          module: {
            path: "^src/utl",
            numberOfDependentsLessThan: 3,
          },
        },
        {
          name: "no-circular",
          comment:
            "This dependency is part of a circular relationship. You might want to revise your solution (i.e. use dependency inversion, make sure the modules have a single responsibility) ",
          severity: "error",
          from: {},
          to: {
            circular: true,
          },
        },
        {
          name: "no-deprecated-core",
          comment:
            "This module depends on a node core module that has been deprecated. Find an alternative - these are bound to exist - node doesn't deprecate lightly.",
          severity: "error",
          from: {},
          to: {
            dependencyTypes: ["core"],
            path: "^(punycode|domain|constants|sys|_linklist|_stream_wrap)$",
          },
        },
        {
          name: "no-duplicate-dep-types",
          comment:
            'Likely this module depends on an external (\'npm\') package that occurs more than once in your package.json i.e. bot as a devDependencies and in dependencies. This will cause maintenance problems later on. If it\'s intentional, you can disable this rule by adding this override as a rule in the \'forbidden\' section of your dependency-cruiser configuration: {"name": "no-duplicate-dep-types", "severity": "ignore"}',
          severity: "error",
          from: {},
          to: {
            moreThanOneDependencyType: true,
            dependencyTypesNot: ["type-only"],
          },
        },
        {
          name: "no-non-package-json",
          severity: "error",
          comment:
            "This module depends on an npm package that isn't in the 'dependencies' section of your package.json. That's problematic as the package either (1) won't be available on live (2 - worse) will be available on live with an non-guaranteed version. Fix it by adding the package to the dependencies in your package.json.",
          from: {},
          to: {
            dependencyTypes: ["npm-no-pkg", "npm-unknown"],
          },
        },
        {
          name: "not-to-deprecated",
          comment:
            "This module uses a (version of an) npm module that has been deprecated. Either upgrade to a later version of that module, or find an alternative. Deprecated modules are a security risk.",
          severity: "error",
          from: {},
          to: {
            dependencyTypes: ["deprecated"],
          },
        },
      ],
    },
  },
  revisionData: {
    SHA1: "e95e9f481df42643f2b2a119d1773caa8a49e82e",
    changes: [
      {
        type: "modified",
        name: "src/report/d2.mjs",
        checksum: "aeaxFY//FK1eGFfWGhzAwMndvfw=",
      },
      {
        type: "modified",
        name: "test/report/d2/d2.spec.mjs",
        checksum: "/Y0t37YrfoM4O9Hn/nwA/S+bM3A=",
      },
    ],
  },
};
