# Contribution Guidelines

Thank you for your interest in contributing to our project. Whether it's a bug report, new feature, correction, or additional
documentation, we greatly value feedback and contributions from our community.

Please read through this document before submitting any issues or pull requests to ensure we have all the necessary
information to effectively respond to your bug report or contribution.


## Reporting Bugs/Feature Requests

We welcome you to use the [GitHub issue tracker](https://github.com/HabanaAI/gohlml/issues) to report bugs or suggest features.

When filing an issue, please check existing open, or recently closed, issues to make sure somebody else hasn't already
reported the issue. Please try to include as much information as you can. Details like these are incredibly useful:

* A reproducible test case or series of steps
* The version of our code being used
* Any modifications you've made relevant to the bug
* Anything unusual about your environment or deployment


## Contributing Workflow (via Pull Requests)
Contributions via pull requests are much appreciated. Before sending us a pull request, please ensure that:

1. You are working against the latest source on the *master* branch.
2. You check existing open, and recently merged, pull requests to make sure someone else hasn't addressed the problem already.
3. You open an issue to discuss any significant work

To send us a pull request, please:

1. Fork the repository (See: [fork guide](https://help.github.com/articles/fork-a-repo/))
2. Clone the repository locally:
    ```bash
    git clone git@github.com:YOUR-USERNAME/gohlml.git
    ```
2. Modify the source. Please focus on the specific change you are contributing. (If you also reformat all the code, it will be hard for us to focus on your change.)
4. Commit to your fork using clear commit messages.
5. Send us a pull request (See: [pull request guide](https://help.github.com/articles/creating-a-pull-request/)), answering any default questions in the pull request interface.
6. Pay attention to any automated CI failures reported in the pull request, and stay involved in the conversation.
