// Code generated by bpf2go; DO NOT EDIT.
//go:build mips || mips64 || ppc64 || s390x

package bpftest

import (
	"bytes"
	_ "embed"
	"fmt"
	"io"

	"github.com/cilium/ebpf"
)

type testProcessMetricsT struct {
	CgroupId       uint64
	Pid            uint64
	ProcessRunTime uint64
	CpuCycles      uint64
	CpuInstr       uint64
	CacheMiss      uint64
	PageCacheHit   uint64
	VecNr          [10]uint16
	Comm           [16]int8
	_              [4]byte
}

// loadTest returns the embedded CollectionSpec for test.
func loadTest() (*ebpf.CollectionSpec, error) {
	reader := bytes.NewReader(_TestBytes)
	spec, err := ebpf.LoadCollectionSpecFromReader(reader)
	if err != nil {
		return nil, fmt.Errorf("can't load test: %w", err)
	}

	return spec, err
}

// loadTestObjects loads test and converts it into a struct.
//
// The following types are suitable as obj argument:
//
//	*testObjects
//	*testPrograms
//	*testMaps
//
// See ebpf.CollectionSpec.LoadAndAssign documentation for details.
func loadTestObjects(obj interface{}, opts *ebpf.CollectionOptions) error {
	spec, err := loadTest()
	if err != nil {
		return err
	}

	return spec.LoadAndAssign(obj, opts)
}

// testSpecs contains maps and programs before they are loaded into the kernel.
//
// It can be passed ebpf.CollectionSpec.Assign.
type testSpecs struct {
	testProgramSpecs
	testMapSpecs
}

// testSpecs contains programs before they are loaded into the kernel.
//
// It can be passed ebpf.CollectionSpec.Assign.
type testProgramSpecs struct {
	TestKeplerSchedSwitchTrace       *ebpf.ProgramSpec `ebpf:"test_kepler_sched_switch_trace"`
	TestKeplerWritePageTrace         *ebpf.ProgramSpec `ebpf:"test_kepler_write_page_trace"`
	TestRegisterNewProcessIfNotExist *ebpf.ProgramSpec `ebpf:"test_register_new_process_if_not_exist"`
}

// testMapSpecs contains maps before they are loaded into the kernel.
//
// It can be passed ebpf.CollectionSpec.Assign.
type testMapSpecs struct {
	CacheMiss                  *ebpf.MapSpec `ebpf:"cache_miss"`
	CacheMissEventReader       *ebpf.MapSpec `ebpf:"cache_miss_event_reader"`
	CpuCycles                  *ebpf.MapSpec `ebpf:"cpu_cycles"`
	CpuCyclesEventReader       *ebpf.MapSpec `ebpf:"cpu_cycles_event_reader"`
	CpuInstructions            *ebpf.MapSpec `ebpf:"cpu_instructions"`
	CpuInstructionsEventReader *ebpf.MapSpec `ebpf:"cpu_instructions_event_reader"`
	PidTimeMap                 *ebpf.MapSpec `ebpf:"pid_time_map"`
	Processes                  *ebpf.MapSpec `ebpf:"processes"`
}

// testObjects contains all objects after they have been loaded into the kernel.
//
// It can be passed to loadTestObjects or ebpf.CollectionSpec.LoadAndAssign.
type testObjects struct {
	testPrograms
	testMaps
}

func (o *testObjects) Close() error {
	return _TestClose(
		&o.testPrograms,
		&o.testMaps,
	)
}

// testMaps contains all maps after they have been loaded into the kernel.
//
// It can be passed to loadTestObjects or ebpf.CollectionSpec.LoadAndAssign.
type testMaps struct {
	CacheMiss                  *ebpf.Map `ebpf:"cache_miss"`
	CacheMissEventReader       *ebpf.Map `ebpf:"cache_miss_event_reader"`
	CpuCycles                  *ebpf.Map `ebpf:"cpu_cycles"`
	CpuCyclesEventReader       *ebpf.Map `ebpf:"cpu_cycles_event_reader"`
	CpuInstructions            *ebpf.Map `ebpf:"cpu_instructions"`
	CpuInstructionsEventReader *ebpf.Map `ebpf:"cpu_instructions_event_reader"`
	PidTimeMap                 *ebpf.Map `ebpf:"pid_time_map"`
	Processes                  *ebpf.Map `ebpf:"processes"`
}

func (m *testMaps) Close() error {
	return _TestClose(
		m.CacheMiss,
		m.CacheMissEventReader,
		m.CpuCycles,
		m.CpuCyclesEventReader,
		m.CpuInstructions,
		m.CpuInstructionsEventReader,
		m.PidTimeMap,
		m.Processes,
	)
}

// testPrograms contains all programs after they have been loaded into the kernel.
//
// It can be passed to loadTestObjects or ebpf.CollectionSpec.LoadAndAssign.
type testPrograms struct {
	TestKeplerSchedSwitchTrace       *ebpf.Program `ebpf:"test_kepler_sched_switch_trace"`
	TestKeplerWritePageTrace         *ebpf.Program `ebpf:"test_kepler_write_page_trace"`
	TestRegisterNewProcessIfNotExist *ebpf.Program `ebpf:"test_register_new_process_if_not_exist"`
}

func (p *testPrograms) Close() error {
	return _TestClose(
		p.TestKeplerSchedSwitchTrace,
		p.TestKeplerWritePageTrace,
		p.TestRegisterNewProcessIfNotExist,
	)
}

func _TestClose(closers ...io.Closer) error {
	for _, closer := range closers {
		if err := closer.Close(); err != nil {
			return err
		}
	}
	return nil
}

// Do not access this directly.
//
//go:embed test_bpfeb.o
var _TestBytes []byte
