---
title: enhancement-idea
authors:
  - TBD
reviewers:
  - TBD
approvers:
  - TBD
creation-date: yyyy-mm-dd
last-updated: yyyy-mm-dd
tracking-links: # link to related GitHub issues
  - TBD
---

To get started with this template:

1. **Make a copy of this template.** Copy this template into the enhancements
   directory and name the file appropriately.
1. **Fill out all applicable sections.**
1. **Create a PR.** Assign it to those with expertise to sponsor the process.
1. **Merge after reaching consensus.** Merge when there is consensus that the
   design is complete and all reviewer questions have been answered so that work
   can begin. Come back and update the document if important details (API field
   names, workflow, etc.) change during code review.

Start by filling out the header with the metadata for this enhancement.

# Enhancement Idea

This is the title of the enhancement. Keep it simple and descriptive. A good
title can help communicate what the enhancement is and should be considered as
part of any review.

The `Metadata` section above is intended to support the creation of tooling
around the enhancement process.

## Summary

The `Summary` section is incredibly important for producing high quality
user-focused documentation such as release notes or a development roadmap. It
should be possible to collect this information before implementation begins in
order to avoid requiring implementers to split their attention between writing
release notes and implementing the feature itself.

A good summary is no more than one paragraph in length. More detail should go
into the following sections.

## Motivation

This section is for explicitly listing the motivation, goals and non-goals of
this proposal. Describe why the change is important and the benefits to users.

### Goals

Summarize the specific goals of the proposal. How will we know that this has
succeeded? A good goal describes something a user wants from their perspective,
and does not include the implementation details from the proposal.

### Non-Goals

What is out of scope for this proposal? Listing non-goals helps to focus
discussion and make progress. Highlight anything that is being deferred to a
later phase of implementation that may call for its own enhancement.

## Proposal

This is where we get down to the nitty gritty of what the proposal actually is.
Describe clearly what will be changed, including all of the components that need
to be modified and how they will be different. Include the reason for each
choice in the design and implementation that is proposed here, and expand on
reasons for not choosing alternatives in the Alternatives section at the end of
the document.

### Workflow Description

Explain how the user will use the feature. Be detailed and explicit. Describe
all of the actors, their roles, and the APIs or interfaces involved. Define a
starting state and then list the steps that the user would need to go through to
trigger the feature described in the enhancement.

### Implementation Details/Notes/Constraints \[optional\]

What are the caveats to the implementation? What are some important details that
didn't come across above. Go in to as much detail as necessary here. This might
be a good place to talk about core concepts and how they relate.

### Risks and Mitigations

What are the risks of this proposal and how do we mitigate. Think broadly. For
example, consider both security and how this will impact the larger ecosystem.

How will security be reviewed and by whom?

How will UX be reviewed and by whom?

Consider including folks that also work outside your immediate sub-project.

### Drawbacks

The idea is to find the best form of an argument why this enhancement should
_not_ be implemented.

What trade-offs (technical/efficiency cost, user experience, flexibility,
supportability, etc) must be made in order to implement this? What are the
reasons we might not want to undertake this proposal, and how do we overcome
them?

Does this proposal implement a behavior that's new/unique/novel? Is it poorly
aligned with existing user expectations? Will it be a significant maintenance
burden? Is it likely to be superseded by something else in the near future?

## Design Details

### Open Questions \[optional\]

This is where to call out areas of the design that require closure before
deciding to implement the design. For instance,

> 1. This requires exposing previously private resources which contain sensitive
>    information. Can we do this?

### Test Plan

**Note:** _Section not required until targeted at a release._

Consider the following in developing a test plan for this enhancement:

- Will there be e2e and integration tests, in addition to unit tests?
- How will it be tested in isolation vs with other components?
- What additional testing is necessary to support managed OpenShift
  service-based offerings?

No need to outline all of the test cases, just the general strategy. Anything
that would count as tricky in the implementation and anything particularly
challenging to test should be called out.

All code is expected to have adequate tests (eventually with coverage
expectations).

## Implementation History

Major milestones in the life cycle of a proposal should be tracked in
`Implementation History`.

## Alternatives

Similar to the `Drawbacks` section the `Alternatives` section is used to
highlight and record other possible approaches to delivering the value proposed
by an enhancement.

## Infrastructure Needed \[optional\]

Use this section if you need things from the project. Examples include a new
subproject, repos requested, github details, and/or testing infrastructure.

Listing these here allows the community to get the process for these resources
started right away.
