# Governance

## Leadership Election

Qualified new maintainers are approved via consensus by the group of existing
maintainers.

## Technical Committee

Technical committee provides technical oversight for the overall architectural
design and project development.

Responsibilities include:

- Oversee the overall direction of the Kepler project.
- Provide guidance for the project maintainers and the onboarding process for
  new maintainers.
- Actively engage in the technical committee meetings.

The current list of technical committee members is published and updated in
[Contributors.md](Contributors.md).

### Becoming a Technical Committee Member

Proficient in one or more of the following areas:

- Developing and maintaining Kepler core
- Developing and maintaining Kepler deployment and integration (including
  Operator)
- Developing and maintaining Kepler model server and models
- Developing and maintaining test suites
- Developing and maintaining CI infra
- Maintaining documentation.

## Responsibilities

### Maintainer's Responsibilities

Responsibilities include:

- Strong commitment to the project
- Participate in design and technical discussions
- Contribute non-trivial pull requests
- Actively attend the community meetings
- Perform code reviews on other's pull requests
- Regularly triage GitHub issues.
- Make sure that ongoing PRs are moving forward at the right pace or closing
  them
- Monitor Kepler Slack (delayed response is perfectly acceptable), particularly
  for the area of your expertise

### Reviewer's Responsibilities

Responsibilities include:

- Perform code reviews on other's pull requests
- Regularly triage GitHub issues.
- Make sure that ongoing PRs are moving forward at the right pace or closing
  them
- Monitor Kepler Slack (delayed response is perfectly acceptable), particularly
  for the area of your expertise

## Advisory Committee

Advisory committee provides guidance for the overall direction of the Kepler
project, including but not limited to:

- Project roadmap
- Project governance
- Project releases
- Project marketing

Members of the advisory committee are expected to be active in the Kepler
community and attend the advisory committee meetings. Members are expected to
serve for a term of one year, with the option to renew for additional terms.
Members are invited and approved by the Kepler maintainers.
