import {ChangeDetectorRef, NgZone, OnDestroy, Pipe, PipeTransform} from '@angular/core';
import {VARS} from '../../app-constants.service';

@Pipe({
  name: 'timeAgo',
  pure: false
})
export class TimeAgoPipe implements PipeTransform, OnDestroy {
  constructor(private changeDetectorRef: ChangeDetectorRef, private ngZone: NgZone) {}
  private timer: number;
  private static getSecondsUntilUpdate(seconds: number) {
    const min = 60;
    const hr = min * 60;
    const day = hr * 24;
    if (seconds < min) { // less than 1 min, update every 2 secs
      return 2;
    } else if (seconds < hr) { // less than an hour, update every 30 secs
      return 30;
    } else if (seconds < day) { // less then a day, update every 5 mins
      return 300;
    } else { // update every hour
      return 3600;
    }
  }
  transform(value: string, ...args: any[]) {
    this.removeTimer();
    const d = new Date(value);
    const now = new Date(new Date().toLocaleString(VARS.APP_TIMEZONE_LOCALES, { timeZone: VARS.APP_TIMEZONE.toString() }));
    const seconds = Math.round(Math.abs((now.getTime() - d.getTime()) / 1000));
    const timeToUpdate = (Number.isNaN(seconds)) ? 1000 : TimeAgoPipe.getSecondsUntilUpdate(seconds) * 1000;
    this.timer = this.ngZone.runOutsideAngular(() => {
      if (typeof window !== 'undefined') {
        return window.setTimeout(() => {
          this.ngZone.run(() => this.changeDetectorRef.markForCheck());
        }, timeToUpdate);
      }
      return null;
    });
    const minutes = Math.round(Math.abs(seconds / 60));
    const hours = Math.round(Math.abs(minutes / 60));
    const days = Math.round(Math.abs(hours / 24));
    const months = Math.round(Math.abs(days / 30.416));
    const years = Math.round(Math.abs(days / 365));
    if (Number.isNaN(seconds)) {
      return '';
    } else if (seconds <= 45) {
      return 'a few seconds ago';
    } else if (seconds <= 90) {
      return 'a minute ago';
    } else if (minutes <= 45) {
      return minutes + ' minutes ago';
    } else if (minutes <= 90) {
      return 'an hour ago';
    } else if (hours <= 22) {
      return hours + ' hours ago';
    } else if (hours <= 36) {
      return 'a day ago';
    } else if (days <= 25) {
      return days + ' days ago';
    } else if (days <= 45) {
      return 'a month ago';
    } else if (days <= 345) {
      return months + ' months ago';
    } else if (days <= 545) {
      return 'a year ago';
    } else { // (days > 545)
      return years + ' years ago';
    }
  }
  ngOnDestroy(): void {
    this.removeTimer();
  }
  private removeTimer() {
    if (this.timer) {
      window.clearTimeout(this.timer);
      this.timer = null;
    }
  }
  /*transform(d: any): string {

    // const currentDate = new Date(new Date().toUTCString());
    const currentDate = new Date(new Date().toLocaleString('en-US', {timeZone: 'US/Pacific'}));
    const date = new Date(d);

    const year = currentDate.getFullYear() - date.getFullYear();
    const month = currentDate.getMonth() - date.getMonth();
    const day = currentDate.getDate() - date.getDate();
    const hour = currentDate.getHours() - date.getHours();
    const minute = currentDate.getMinutes() - date.getMinutes();
    const second = currentDate.getSeconds() - date.getSeconds();

    const createdSecond = (year * 31556926) + (month * 2629746) + (day * 86400) + (hour * 3600) + (minute * 60) + second;

    if (createdSecond >= 31556926) {
      const yearAgo = Math.floor(createdSecond / 31556926);
      return yearAgo > 1 ? yearAgo + ' years ago' : yearAgo + ' year ago';
    } else if (createdSecond >= 2629746) {
      const monthAgo = Math.floor(createdSecond / 2629746);
      return monthAgo > 1 ? monthAgo + ' months ago' : monthAgo + ' month ago';
    } else if (createdSecond >= 86400) {
      const dayAgo = Math.floor(createdSecond / 86400);
      return dayAgo > 1 ? dayAgo + ' days ago' : dayAgo + ' day ago';
    } else if (createdSecond >= 3600) {
      const hourAgo = Math.floor(createdSecond / 3600);
      return hourAgo > 1 ? hourAgo + ' hours ago' : hourAgo + ' hour ago';
    } else if (createdSecond >= 60) {
      const minuteAgo = Math.floor(createdSecond / 60);
      return minuteAgo > 1 ? minuteAgo + ' minutes ago' : minuteAgo + ' minute ago';
    } else if (createdSecond < 60) {
      return createdSecond > 1 ? createdSecond + ' seconds ago' : createdSecond + ' second ago';
    } else if (createdSecond < 0) {
      return '0 second ago';
    }
  }*/
}
