# Contributing to the OneSignal Cordova SDK

:+1::tada: First off, thanks for taking the time to contribute! :tada::+1:

### How to Contribute
We love the open source community and enjoy the support and contributions of many of our users. We ask that any potential contributors to the SDK Follow the following guidelines:

If your proposed contribution is a small bug fix, please feel free to create your own fork of the repository and create a pull request.

If your contribution would _break_ or _change_ the functionality of the SDK, please reach out to us before you put in a lot of effort into a change we may not be able to use. We try our best to make sure that the SDK remains stable so that developers do not have to continually change their code, however some breaking changes _are_ desirable, so please get in touch to discuss your idea before you put in a lot of effort.

#### Before Submitting A Bug Report
Before creating bug reports, please check this list of steps to follow.

1. Make sure that you are actually encountering an _issue_ and not a _question_. If you simply have a question about the SDK, we would be more than happy to assist you in our Support section on the web (https://www.onesignal.com - click the Message button at the bottom right)
2. Please make sure to [include as many details as possible](#how-do-i-submit-a-good-bug-report)

> **Note:** If you find a **Closed** issue that seems like it is the same thing that you're experiencing, open a new issue and include a link to the original issue in the body of your new one.


#### How Do I Submit a Good Bug Report
* **Use a clear and descriptive title** for the issue to identify the problem.
* **Include Reproducibility** It is nearly always a good idea to include steps to reproduct the issue. If you cannot reliably reproduce the issue yourself, that's ok, but reproducible steps help best.
* **Describe your environment**, tell us what version of the Cordova/Ionic/PhoneGap SDK you are using, what packages/dependencies you are using, what version of iOS/Android the issue occurs on, etc.
* **Include a Stack Trace** If your issue involves a crash/exception, ***PLEASE*** post the stack trace to help us identify the root issue.
* **Include an Example Project** This isn't required, but if you want your issue fixed quickly, it's often a good idea to include an example project as a zip and include it with the issue. You can also download the Demo project ([Cordova demo](https://github.com/OneSignal/OneSignal-Cordova-Example), [Ionic demo](https://github.com/OneSignal/OneSignal-Ionic-Example)) and set up an example project with this code as a starting point.
