# superduper Code of Conduct

## Conduct

We are dedicated to fostering a friendly, safe, and inclusive environment for everyone, irrespective of their experience level, gender identity and expression, sexual orientation, disability, personal appearance, body size, race, ethnicity, age, religion, nationality, or any other similar characteristic.

- Please refrain from using overtly sexual aliases or nicknames that might compromise the friendly and welcoming atmosphere.
- Be kind and courteous; there's no place for mean or rude behavior.
- Respect diverse opinions and acknowledge that every design or implementation choice involves trade-offs and costs. There is seldom a single right answer.
- Keep unstructured critique to a minimum. If you have concrete ideas to experiment with, consider creating a fork and testing them out.
- Insults, demeaning language, or harassment of any kind will result in exclusion from interaction. We do not tolerate behavior that marginalizes individuals in socially marginalized groups.
- Private harassment is also unacceptable. If you feel harassed or uncomfortable, please contact one of the channel ops or any member of the Superduper moderation team immediately. We care about creating a safe community and will support you, whether you're a regular contributor or a newcomer.
- Spamming, trolling, flaming, baiting, or any other attention-seeking behavior is not welcome.

**Contact the Moderation Team: [EMAIL THE MODERATION TEAM](mailto:hello@superduperdb.com)**

## Moderation

These policies outline how we uphold the standards of conduct in our community:

- Remarks that violate the Superduper standards of conduct, including hateful, hurtful, oppressive, or exclusionary remarks, are strictly prohibited.
- Moderators will respond to such remarks with a warning.
- If the warning is disregarded, the user will be "kicked" from the communication channel to cool off.
- Continued disruptive behavior may result in a ban, i.e., indefinite exclusion.
- Moderators may, at their discretion, unban a user for a first offense if a genuine apology is offered to the offended party.
- If you believe a ban was unjustified, address the issue with the responsible moderator in private. Complaints about bans in-channel are not allowed.
- Moderators are held to a higher standard than other community members. In case a moderator creates an inappropriate situation, they should expect less leeway than others.

In the Superduper community, we go the extra step to look out for each other. Strive not only to be technically proficient but also to be your best self. Avoid flirting with offensive or sensitive issues, especially if they're off-topic, to prevent unnecessary conflicts, hurt feelings, and damaged trust.

If someone raises concerns about something you said or did, resist the urge to be defensive. Stop the behavior in question and apologize. Even if you believe you were misunderstood or unfairly accused, consider that there might be room for better communication. Remember, it's your responsibility to make your fellow Superduper community members comfortable.

The enforcement policies mentioned above apply to all official Superduper venues, including [Slack channels](https://join.slack.com/t/superduper-public/shared_invite/zt-1yodhtx8y-KxzECued5QBtT6JFnsSNrQ), GitHub repositories under the Superduper organization, and all forums under Superduper, Inc.

Adapted with inspiration from the [Rust Code of Conduct](https://github.com/rust-lang/rust/blob/master/CODE_OF_CONDUCT.md), the [Node.js Policy on Trolling](https://blog.izs.me/2012/08/policy-on-trolling/), and the [Contributor Covenant v1.3.0](https://www.contributor-covenant.org/version/1/3/0/code-of-conduct/).
