# 值得学习的小型项目
在国内外的各大 Rust 论坛上，以下问题非常常见: 

- 作为 Rust 新手，有哪些项目值得推荐学习?
- 求推荐代码优雅的小型项目
- 有哪些值得推荐的简单、易读的项目

这些问题的答案往往只有一个，那就是实践：做一些优秀的练习题，然后阅读一些小而美的 Rust 项目。

这个恰恰跟本书的目标吻合，因此，我们决定收集一些优秀的资源，并在 _Rust语言实战_ 中呈现给大家。

### 1. Ripgrep

以上的问题通常都会伴随着 [`ripgrep`](https://github.com/BurntSushi/ripgrep) 的推荐, 虽然我不认为它是一个小型项目，但是依然非常推荐大家学习，当然，首先你得做好深挖的准备和耐心。

### 2. 教程：构建一个文本编辑器

该教程 [`https://www.flenker.blog/hecto/`](https://www.flenker.blog/hecto/) 将带领我们从零开始构建一个文本编辑器.

### 3. Ncspot

[Ncspot](https://github.com/hrkfdn/ncspot) 是一个终端访问的 Spotify 客户端，小巧、简单、良好的代码组织以及异步编程，值得学习.

### 4. 命令行 Rust

[这个项目](https://github.com/kyclark/command-line-rust) 是书本 `Command-Line Rust(O'Reily)` 的配套项目，可以帮助大家理解该如何更好的编写命令行程序，例如 `head`, `cat`, `ls`。

### 5. 在 PNG 中隐藏你的秘密

[这本书](https://jrdngr.github.io/pngme_book/) 将带领大家编写一个命令行程序，功能是在 PNG 文件中隐藏一些秘密信息，首要目标是让我们熟悉 Rust 代码。

### 6. 使用 Rust 写一个小型 OS

[这个博客系列](https://os.phil-opp.com) 会带领大家使用 Rust 语言创建一个小型的操作系统。其中每一篇文章都是一个小的教程并包含完整的代码。

你也可以在[以下地址](https://github.com/phil-opp/blog_os)找到完整的源代码。

### 7. CodeCrafters.io: 写一个你自己的 Git， Docker，SQLite 或 Redis

在 [CodeCrafters](https://codecrafters.io/for/rust) 上，你可以从头开始重新创建您最喜欢的开发人员工具。这是一种掌握 Rust 的实践、最低限度指导的方法，同时欣赏我们每天使用的流行技术的内部结构和文档。

### 8. mini-redis
[mini-redis](https://github.com/tokio-rs/mini-redis) 是一个不完整的 Redis 客户端、服务器实现，由 tokio 官方出品，代码质量非常高，而且有详细的注释，非常适合学习 Rust 和异步编程。

### 9. 使用 Rust 写一个解析器

[这本开源书](https://rust-hosted-langs.github.io/book/) 是一个使用 Rust 语言实现编译型语言的教程。

### 10. Rust编写推箱子游戏教程
[sokoban](https://sokoban.iolivia.me/zh_cn/c01-00-intro) 是一个使用 Rust 语言实现 sokoban 游戏的教程。虽然社区已停止活跃（ Initial Commits on Sep 3, 2019，GitHub 仓库最后一条 commit 是 last year ），但是项目是完善的 release v0.1.0，拿来练手是个不错的选择。

**To be continued...**
