<div align="center">
    <img  src="https://github.com/sunface/rust-by-practice/blob/master/en/assets/header.jpg?raw=true">
</div>
    
<p align="center">Practice Rust with challenging examples, exercises and projects</p>
    
<div align="center">

[![Stars Count](https://img.shields.io/github/stars/sunface/rust-by-practice?style=flat)](https://github.com/sunface/rust-by-practice/stargazers) [![Forks Count](https://img.shields.io/github/forks/sunface/rust-by-practice.svg?style=flat)](https://github.com/naaive/orange/network/members)
[![LICENSE](https://img.shields.io/badge/license-mit-green?style=flat)](https://github.com/sunface/rust-by-practice/blob/master/LICENSE)
</div>

This book was designed for easily diving into and getting skilled with Rust, and it's very easy to use: All you need to do is to make each exercise compile without ERRORS and Panics !


## Reading online

- [English](https://practice.rs)
- [简体中文](https://zh.practice.rs)


## Running locally

We use [mdbook](https://rust-lang.github.io/mdBook/) building our exercises. You can run locally with below steps:
```shell
$ git clone git@github.com:sunface/rust-by-practice.git
$ cargo install mdbook
$ cd rust-by-practice && mdbook serve en/ 
```

## Features

Part of our examples and exercises are borrowed from [Rust By Example](https://github.com/rust-lang/rust-by-example), thanks for your great works!

Although they are so awesome, we have our own secret weapons :)

- There are three parts in each chapter: examples, exercises and practices

- Besides examples, we have `a lot of exercises`, you can Read, Edit and Run them ONLINE

- Covering nearly all aspects of Rust, such as async/await, threads, sync primitives, optimizing, standard libraries, tool chain, data structures and algorithms etc.

- Every exercise has its own solutions

- The overall difficulties are a bit higher and from easy to super hard: easy 🌟 medium 🌟🌟 hard 🌟🌟🌟 super hard 🌟🌟🌟🌟

**What we want to do is to fill the gap between learning and getting started with real projects!**
