# Small projects with Elegant code base
Following questions come up weekly in online Rust discussions: 

- I just finished reading The Book, what should I do next ?
- What projects would you recommend to a Rust beginner?
- Looking for small projects with an elegant code base
- Codes that is easy to read and learn

The answers to these questions are always **Practice**: doing some exercises, and then reading some small and excellent Rust projects.

This is precisely the goal of this book, so, collecting relative resourses and representing in _Rust By Practice_ seems not a bad idea.

### 1. Ripgrep

Answers for above questions usually came with [`ripgrep`](https://github.com/BurntSushi/ripgrep), though I don't think it is a **small** project, but yes, go for it if you are not afraid to delve deep a bit.

### 2. Building a text editor
Tutorial [`https://www.flenker.blog/hecto/`](https://www.flenker.blog/hecto/) will lead you to build a text editor from scratch.

### 3. Ncspot
[Ncspot](https://github.com/hrkfdn/ncspot), a terminal Spotify client. Small, simple, well organized and async, it's good for learning.

### 4. Command Line Rust
[This project](https://github.com/kyclark/command-line-rust) is for the book `Command-Line Rust(O'Reily)`, it will show you how to write small CLIs (clones of `head`, `cat`, `ls`).

### 5. pngme book
[This book](https://jrdngr.github.io/pngme_book/) will guide you to make a command line program that lets you hide secret messages in PNG files.  The primary goal here is to get you writing code. The secondary goal is to get you reading documentation.

### 6. Writing an OS in Rust

[This blog series](https://os.phil-opp.com) creates a small operating system in the Rust programming language. Each post is a small tutorial and includes all needed code, so you can follow along if you like. The source code is also available in the corresponding [Github repository](https://github.com/phil-opp/blog_os).


### 7. CodeCrafters.io: Build your own Git, Docker, SQLite, or Redis

On [CodeCrafters](https://codecrafters.io/for/rust), you can recreate your favorite developer tools from scratch. It's a hands-on, minimally-guided approach to master Rust, while appreciating the internals and documentation of popular technology that we use every day.

### 8. mini-redis
[mini-redis](https://github.com/tokio-rs/mini-redis) is an incomplete Redis client and server implementation using tokio, it has decent code base and detail explanations, very suitable for learning Rust and asynchronous programming.

### 9. Writing Interpreters in Rust

[This online book](https://rust-hosted-langs.github.io/book/) will walk through the basics of interpreted language implementation in Rust with a focus on the challenges that are specific to using Rust.

---


**To be continued...**
