# Summary

- [Rust By Practice](why-exercise.md)
- [Small projects with Elegant code](elegant-code-base.md)
- [Variables](variables.md)
- [Basic Types](basic-types/intro.md)
  - [Numbers](basic-types/numbers.md)
  - [Char, Bool and Unit](basic-types/char-bool-unit.md)
  - [Statements and Expressions](basic-types/statements-expressions.md)
  - [Functions](basic-types/functions.md)
- [Ownership and Borrowing](ownership/intro.md)
  - [Ownership](ownership/ownership.md)
  - [Reference and Borrowing](ownership/borrowing.md)
- [Compound Types](compound-types/intro.md)
  - [string](compound-types/string.md)
  - [Array](compound-types/array.md)
  - [Slice](compound-types/slice.md)
  - [Tuple](compound-types/tuple.md)
  - [Struct](compound-types/struct.md)
  - [Enum](compound-types/enum.md)
- [Flow Control](flow-control.md)
- [Pattern Match](pattern-match/intro.md)
  - [match, matches! and if let](pattern-match/match-iflet.md)
  - [Patterns](pattern-match/patterns.md)
- [Method & Associated function](method.md)
- [Generics and Traits](generics-traits/intro.md)
  - [Generics](generics-traits/generics.md)
  - [Const Generics](generics-traits/const-generics.md)
  - [Traits](generics-traits/traits.md)
  - [Trait Object](generics-traits/trait-object.md)
  - [Advanced Traits](generics-traits/advanced-traits.md)
- [Collection Types](collections/intro.md)
  - [String](collections/string.md)
  - [Vector](collections/vector.md)
  - [HashMap](collections/hashmap.md)
- [Type Conversion](type-conversions/intro.md)
  - [as](type-conversions/as.md)
  - [From/Into](type-conversions/from-into.md)
  - [Others](type-conversions/others.md)
- [Result and panic](result-panic/intro.md)
  - [panic!](result-panic/panic.md)
  - [Result and ?](result-panic/result.md)
- [Crate and Module](crate-module/intro.md)
  - [Package and Crate](crate-module/crate.md)
  - [Module](crate-module/module.md)
  - [Advanced use and pub](crate-module/use-pub.md)
- [Comments and Docs](comments-docs.md)
- [Formatted output](formatted-output/intro.md)
  - [println! and format!](formatted-output/println.md)
  - [Debug and Display](formatted-output/debug-display.md)
  - [formating](formatted-output/formatting.md)
- [Lifetime](lifetime/intro.md)
  - [basic](lifetime/basic.md)
  - [&'static and T: 'static](lifetime/static.md)
  - [advanced](lifetime/advance.md)
- [Functional programing](functional-programing/intro.md)
  - [Closure](functional-programing/closure.md)
  - [Iterator](functional-programing/iterator.md)
- [newtype and DST](newtype-sized.md)
- [Smart pointers TODO](smart-pointers/intro.md)
  - [Box](smart-pointers/box.md)
  - [Deref](smart-pointers/deref.md)
  - [Drop](smart-pointers/drop.md)
  - [Rc and Arc](smart-pointers/rc-arc.md)
  - [Cell and RefCell](smart-pointers/cell-refcell.md)
- [Weak and Circle reference TODO](weak.md)
- [Self referential TODO](self-referential.md)
- [Threads TODO](threads/intro.md)
  - [Basic using](threads/basic-using.md)
  - [Message passing](threads/message-passing.md)
  - [Sync](threads/sync.md)
  - [Atomic](threads/atomic.md)
  - [Send and Sync](threads/send-sync.md)
- [Global variables TODO](global-variables.md)
- [Errors TODO](errors.md)
- [Unsafe doing](unsafe/intro.md)
  - [Inline assembly](unsafe/inline-asm.md)
- [Macro TODO](macro.md)
- [Tests TODO](tests/intro.md)
  - [Write Tests](tests/write-tests.md)
  - [Benchmark](tests/benchmark.md)
  - [Unit and Integration](tests/unit-integration.md)
  - [Assertions](tests/assertions.md)
- [Async/Await TODO](async/intro.md)
  - [async and await!](async/async-await.md)
  - [Future](async/future.md)
  - [Pin and Unpin](async/pin-unpin.md)
  - [Stream](async/stream.md)
  
- [Standard Library TODO](std/intro.md)
  - [String](std/String.md)

- [Fighting with Compiler](fight-compiler/intro.md)
  - [Borrowing](fight-compiler/borrowing.md)