# Generated by Django 4.1.6 on 2023-02-19 22:16

from django.conf import settings
import django.contrib.auth.models
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('auth', '0012_alter_user_first_name_max_length'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='ArxivPaper',
            fields=[
                ('id', models.AutoField(primary_key=True, serialize=False)),
                ('arxiv_id', models.CharField(max_length=20, unique=True)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('updated', models.DateTimeField(auto_now=True)),
                ('title', models.CharField(blank=True, max_length=400, null=True)),
                ('abstract', models.TextField(blank=True, null=True)),
                ('summary', models.TextField(blank=True, null=True)),
                ('notes', models.TextField(blank=True, null=True)),
                ('longer_summary', models.TextField(blank=True, null=True)),
                ('blog', models.TextField(blank=True, null=True)),
                ('link_doi', models.URLField(blank=True, null=True)),
                ('link_homepage', models.URLField(blank=True, null=True)),
                ('published_arxiv', models.DateField(blank=True, null=True)),
                ('journal_ref', models.CharField(blank=True, max_length=200, null=True)),
                ('comments', models.TextField(blank=True, null=True)),
                ('license', models.CharField(blank=True, max_length=400, null=True)),
                ('category', models.CharField(blank=True, max_length=50, null=True)),
                ('updated_arxiv', models.DateField(blank=True, null=True)),
                ('total_votes', models.IntegerField(default=0)),
            ],
        ),
        migrations.CreateModel(
            name='Author',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=200)),
                ('affiliation', models.CharField(blank=True, max_length=300, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='CustomUser',
            fields=[
                ('user_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'user',
                'verbose_name_plural': 'users',
                'abstract': False,
            },
            bases=('auth.user',),
            managers=[
                ('objects', django.contrib.auth.models.UserManager()),
            ],
        ),
        migrations.CreateModel(
            name='Vote',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('vote', models.SmallIntegerField(choices=[(1, 'Up'), (-1, 'Down')])),
                ('ip_address', models.TextField(blank=True, null=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('active', models.BooleanField(default=True)),
                ('paper', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='summarizer.arxivpaper')),
            ],
        ),
        migrations.CreateModel(
            name='PaperHistory',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('arxiv_id', models.CharField(max_length=20)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('updated', models.DateTimeField(auto_now=True)),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='PapereAuthor',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('author_order', models.PositiveSmallIntegerField()),
                ('author', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='summarizer.author')),
                ('paper', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='summarizer.arxivpaper')),
            ],
            options={
                'ordering': ['author_order'],
                'unique_together': {('author', 'paper')},
            },
        ),
        migrations.AddField(
            model_name='arxivpaper',
            name='authors',
            field=models.ManyToManyField(blank=True, through='summarizer.PapereAuthor', to='summarizer.author'),
        ),
    ]
