import styled from 'styled-components';

const Svg = styled.svg`
  width: inherit;
  height: inherit;
`;

export const AutodeskLogo = () => (
  <Svg viewBox="0 0 973.66 166.09">
    <path
      d="M256.66,47.42l-16.44,38.4h33ZM307,123.92H289.16l-9.74-23.16H234l-9.87,23.16H206.9l42.23-96.65h15.61Z"
      fill="#fff"
    />
    <path d="M462.57,123.92h-17V43.58H415.12V28h79.25l-6.53,15.63H462.57Z" fill="#fff" />
    <path d="M785.43,43.58H734V68H767V83.08H734v25.51h51.42v15.33h-68.4V28h68.38Z" fill="#fff" />
    <path d="M905.93,123.93H889.85V28h16.08Z" fill="#fff" />
    <path
      d="M837.55,41.8c-9.8,0-18.14,3-18.18,9.47,0,7.62,4.73,10.26,22.78,16.14,20,6.55,30.55,13.22,30.44,29.45-.11,18.29-14.24,28.72-34.89,28.72-14.61,0-27.71-4.74-37.7-13.52L806.22,97c9.06,7.6,20,13,31.92,13,10.39,0,17.78-5,17.78-12.49,0-6.26-3.62-10.43-21.13-16C814.71,75,802.57,68.13,802.68,51.77s15.37-25.52,34.56-25.42,30,7.11,31.63,8.06l-6,13.69a51.85,51.85,0,0,0-25.29-6.3"
      fill="#fff"
    />
    <path d="M926.66,74.41l43-46.46H949l-43.1,46.46,47.37,49.53h20.86Z" fill="#fff" />
    <path
      d="M546.35,110.09c-18.86,0-32.63-15.28-32.63-34.14S527.49,41.8,546.35,41.8,579,57.09,579,76s-13.78,34.14-32.64,34.14m0-83.79A49.64,49.64,0,1,0,596,76,49.64,49.64,0,0,0,546.35,26.3"
      fill="#fff"
    />
    <path
      d="M650.16,108.57l-19.38,0v-65h19.46c18.85,0,32.55,13.36,32.55,32.21S669,108.57,650.16,108.57m0-80.61H613.75v96h36.41c27.4,0,49.63-20.7,49.63-48.11S677.56,28,650.16,28"
      fill="#fff"
    />
    <path
      d="M396.59,81.4c0,28.61-16.79,44-41.14,44s-41.12-15.43-41.12-44V28h17V83.42c0,16.79,9.85,26.65,24.12,26.65s24.15-9.86,24.15-26.65V28h17Z"
      fill="#fff"
    />
    <path
      d="M33.08,166.59c-4.72,0-7.18-1.79-9.54-5.93L2,120.74A9.92,9.92,0,0,1,.5,114.86l33.85,1.5,7.74,7.74H110L53.62,159C50.87,160.65,40.42,166.59,33.08,166.59Z"
      fill="#fff"
    />
    <path
      d="M42.13,124.1H12.85C4,124.1.5,119.48.5,114.86c0-2.92.94-4.51,2.24-7.75L45.41,5.25l.45-.89.59-.92,1.23-1.2,1.81-1L52.1.7l4.49.12,29.65,11-10,31.62Z"
      fill="#fff"
    />
    <path
      d="M128.09,166.58,60.75,7.15c-1.16-2.72-3-6.22-7.84-6.22-4.3,0-6.35,2.08-7.5,4.32C46,3.64,47.81.5,53.06.5H99.54a7.35,7.35,0,0,1,7.28,4.83l68.1,161.25Z"
      fill="#fff"
    />
  </Svg>
);

export const DoorDashLogo = () => (
  <Svg viewBox="0 0 470 70">
    <path d="M95.64 13.38A25.24 25.24 0 0 0 73.27 0H2.43A2.44 2.44 0 0 0 .72 4.16l15.43 15.52a7.26 7.26 0 0 0 5.15 2.14h49.94a6.44 6.44 0 1 1 .13 12.88H36.94a2.44 2.44 0 0 0-1.72 4.16l15.44 15.53a7.25 7.25 0 0 0 5.15 2.14h15.57c20.26 0 35.58-21.66 24.26-43.16" />
    <path d="M118.62 16.66v24.72h6.32A12.21 12.21 0 0 0 137 29a12 12 0 0 0-12.06-12.34zm6.32-7.75c11.78 0 20.69 8.9 20.69 20.09s-8.91 20.14-20.69 20.14H111a1 1 0 0 1-1-1V9.95a1 1 0 0 1 1-1zM176 42.24A13.22 13.22 0 1 0 162.82 29 13.24 13.24 0 0 0 176 42.24M176 8c12.4 0 21.88 9.53 21.88 21S188.4 50 176 50s-21.8-9.48-21.8-21S163.68 8 176 8M228 42.24A13.22 13.22 0 1 0 214.75 29 13.24 13.24 0 0 0 228 42.24M228 8c12.36 0 21.84 9.48 21.84 21S240.32 50 228 50s-21.88-9.48-21.88-21S215.6 8 228 8M278.75 16.66h-8.91V27.3h8.91a5.22 5.22 0 0 0 5.46-5.17 5.28 5.28 0 0 0-5.46-5.46m-17.53-6.72a1 1 0 0 1 1-1H279c8 0 13.79 5.86 13.79 13.22a13 13 0 0 1-7.18 11.78l7.74 13.68a1 1 0 0 1-.91 1.56h-6.79a1 1 0 0 1-.91-.54l-7.46-13.54h-7.47v13a1 1 0 0 1-1 1h-6.54a1 1 0 0 1-1-1zM315.26 16.85v24.72h6.32a12.21 12.21 0 0 0 12.07-12.36 12 12 0 0 0-12.07-12.36zm6.32-7.76c11.78 0 20.69 8.91 20.69 20.12s-8.91 20.12-20.69 20.12h-13.9a1 1 0 0 1-1-1V10.14a1 1 0 0 1 1-1zM368.56 18.92l-4.89 13.22h9.77zm-7.76 20.69l-3.2 8.8a1 1 0 0 1-1 .69h-6.94a1 1 0 0 1-1-1.42l15-38.15a1 1 0 0 1 1-.66h7.77a1 1 0 0 1 1 .66l15 38.15a1 1 0 0 1-1 1.42h-6.94a1 1 0 0 1-1-.69l-3.2-8.8zM396.48 19.78c0-6.32 5.46-11.78 14.08-11.78a17.84 17.84 0 0 1 12.51 4.71 1 1 0 0 1 0 1.47L419.22 18a1 1 0 0 1-1.42 0 10.12 10.12 0 0 0-6.67-2.63c-3.45 0-6 2-6 4.31 0 7.47 20.38 3.16 20.38 17.53C425.5 44.49 420 50 410.27 50a20.41 20.41 0 0 1-14.54-5.84 1 1 0 0 1 0-1.47l3.72-3.72a1 1 0 0 1 1.45 0 12.85 12.85 0 0 0 8.79 3.58c4.31 0 7.15-2.3 7.15-5.18 0-7.47-20.37-3.16-20.37-17.53M462.47 9.9V25h-17.25V9.9a1 1 0 0 0-1-1h-6.54a1 1 0 0 0-1 1v38.15a1 1 0 0 0 1 1h6.54a1 1 0 0 0 1-1V32.71h17.24v15.34a1 1 0 0 0 1 1H470a1 1 0 0 0 1-1V9.9a1 1 0 0 0-1-1h-6.54a1 1 0 0 0-.99 1z" />
  </Svg>
);

export const BloombergLogo = () => (
  <Svg viewBox="115 -9.6 257.8 47.6">
    <path d="M115-9.6h18.9c3.6 0 6.3.9 8.3 2.4 2.2 1.8 3.4 4.4 3.4 7.6 0 3.7-1.5 6-4.5 7.4V8c4 1.3 6.3 4.9 6.3 9.2 0 4.1-1.6 7.3-4.2 9.3-2.2 1.6-5 2.3-8.8 2.3H115V-9.6zm17 15c2 0 3.5-1.1 3.5-3.4 0-2.2-1.5-3.3-3.6-3.3h-6.5v6.6h6.6zm.9 14.9c2.3 0 4-1.4 4-3.9 0-2.7-1.8-3.9-4-3.9h-7.4v7.9h7.4zm16.2-29.9h9.9v38.5h-9.9V-9.6zM161 15.2C161 6.5 166.6.7 175.3.7s14.2 5.9 14.2 14.5c0 8.7-5.5 14.5-14.2 14.5S161 23.9 161 15.2zm18.6 0c0-4.8-1.5-7.8-4.5-7.8s-4.4 3-4.4 7.8 1.4 7.9 4.4 7.9c3-.1 4.5-3.1 4.5-7.9zm11 0c0-8.7 5.6-14.5 14.3-14.5S219 6.5 219 15.2s-5.5 14.5-14.2 14.5c-8.6 0-14.2-5.8-14.2-14.5zm18.6 0c0-4.8-1.5-7.8-4.5-7.8s-4.4 3-4.4 7.8 1.4 7.9 4.4 7.9c3-.1 4.5-3.1 4.5-7.9zM221 1.4h9.2v4.1h.2c1.8-3.2 4.3-4.9 8.3-4.9 3.5 0 6.1 1.7 7.4 4.7h.2c2.2-3.6 5.1-4.7 8.5-4.7 6.4 0 9.1 4.7 9.1 11v17.2h-9.6V13.3c0-2.8-.9-4.6-3.3-4.6s-3.6 2.2-3.6 5.2v14.9h-9.6V13.3c0-2.8-.9-4.6-3.3-4.6s-3.6 2.2-3.6 5.2v14.9H221V1.4zm55 23.8h-.1v3.6h-9.2V-9.6h9.6V4.2h.2c1.8-2.4 4.3-3.7 7.8-3.7 6.9 0 10.9 6.2 10.9 14.5 0 9.3-4.3 14.7-11.5 14.7-3 0-6.1-1.4-7.7-4.5zm9.3-10.3c0-4.4-1.6-7.3-4.5-7.3-3 0-4.8 2.9-4.8 7.3s1.9 7.3 4.8 7.3 4.5-2.8 4.5-7.3zm11 .2c0-8.6 5.7-14.5 13.9-14.5 4.1 0 7.2 1.3 9.6 3.6 3.2 3.1 4.6 7.9 4.5 13.5h-18.4c.4 3.4 2 5.2 4.9 5.2 1.7 0 3.2-.8 3.8-2.6h9.3c-1.6 6.3-6.5 9.4-13.4 9.4-8.5-.1-14.2-5.9-14.2-14.6zm9.6-2.9h8.8c-.2-3.3-2-5-4.3-5-2.7-.1-4.2 1.8-4.5 5zm29.3-6.1h.2c2-3.8 4.6-5.3 7.9-5.3.8 0 1.3.1 1.6.3v8.4h-.2c-5.7-1-9 1.7-9 7.9v11.5H326V1.4h9.2v4.7zm10.7 22.8h9.3c.4 1.2 1.6 2.3 3.9 2.3 3.1 0 4.2-1.9 4.2-4.8v-2h-.2c-1.5 1.8-3.6 3.1-6.6 3.1-5.9 0-11.1-4.4-11.1-13 0-7.9 4.2-14 10.6-14 3.7 0 5.9 1.5 7.4 3.8h.2v-3h9.2v23.8c0 4.4-1.5 7.8-3.8 9.8-2.4 2.1-5.8 3-9.7 3-7.4.1-12.5-2.9-13.4-9zm17.8-14.8c0-3.4-1.6-6.2-4.4-6.2-2.7 0-4.4 2.4-4.4 6.2 0 3.7 1.7 6.3 4.4 6.3s4.4-2.7 4.4-6.3z" />
  </Svg>
);

export const AtlassianLogo = () => (
  <Svg viewBox="0 0 540 67">
    <g fill="#0052CC">
      <path d="M19.64,30.56a1.88,1.88,0,0,0-3.2.35L.21,63.36a1.94,1.94,0,0,0,1.74,2.81h22.6a1.87,1.87,0,0,0,1.74-1.07C31.15,55,28.2,39.7,19.64,30.56Z" />
      <path d="M31.55,1A42.81,42.81,0,0,0,29,43.3L39.95,65.1a1.94,1.94,0,0,0,1.74,1.07h22.6A1.94,1.94,0,0,0,66,63.36L34.85,1A1.83,1.83,0,0,0,31.55,1Z" />
      <path d="M296.64,27.06c0,8,3.73,14.42,18.31,17.23,8.7,1.82,10.52,3.23,10.52,6.13s-1.82,4.64-8,4.64a44.89,44.89,0,0,1-21.13-5.72V62.44c4.39,2.15,10.19,4.56,21,4.56,15.25,0,21.3-6.79,21.3-16.9m0,0c0-9.53-5.05-14-19.31-17.07-7.87-1.74-9.78-3.48-9.78-6,0-3.15,2.82-4.47,8-4.47,6.3,0,12.51,1.91,18.4,4.56V14.63a41.58,41.58,0,0,0-18-3.73c-14.09,0-21.38,6.13-21.38,16.16" />
      <polygon points="492.52 11.73 492.52 66.17 504.12 66.17 504.12 24.66 509.01 35.68 525.42 66.17 540 66.17 540 11.73 528.4 11.73 528.4 46.87 524.01 36.67 510.83 11.73 492.52 11.73" />
      <rect x="406.06" y="11.73" width="12.68" height="54.44" />
      <path d="M391.43,50.1c0-9.53-5.05-14-19.31-17.07-7.87-1.74-9.78-3.48-9.78-6,0-3.15,2.82-4.47,8-4.47,6.3,0,12.51,1.91,18.4,4.56V14.63a41.58,41.58,0,0,0-18-3.73c-14.09,0-21.38,6.13-21.38,16.16,0,8,3.73,14.42,18.31,17.23,8.7,1.82,10.52,3.23,10.52,6.13s-1.82,4.64-8,4.64a44.89,44.89,0,0,1-21.13-5.72V62.44c4.39,2.15,10.19,4.56,21,4.56,15.25,0,21.3-6.79,21.3-16.9" />
      <polygon points="198.16 11.73 198.16 66.17 224.22 66.17 228.32 54.41 210.92 54.41 210.92 11.73 198.16 11.73" />
      <polygon points="146.67 11.73 146.67 23.5 160.76 23.5 160.76 66.17 173.52 66.17 173.52 23.5 188.6 23.5 188.6 11.73 146.67 11.73" />
      <path d="M128.17,11.73H111.45l-19,54.44H107L109.66,57A36,36,0,0,0,130,57l2.69,9.17h14.5Zm-8.36,35.46a24.76,24.76,0,0,1-7-1l7-23.77,7,23.77A24.76,24.76,0,0,1,119.81,47.19Z" />
      <path d="M269.14,11.73H252.42l-19,54.44h14.5L250.63,57a36,36,0,0,0,20.3,0l2.69,9.17h14.5Zm-8.36,35.46a24.76,24.76,0,0,1-7-1l7-23.77,7,23.77A24.76,24.76,0,0,1,260.78,47.19Z" />
      <path d="M464.42,11.73H447.7l-19,54.44h14.5L445.91,57a36,36,0,0,0,20.3,0l2.69,9.17h14.5Zm-8.36,35.46a24.76,24.76,0,0,1-7-1l7-23.77,7,23.77A24.76,24.76,0,0,1,456.06,47.19Z" />
    </g>
  </Svg>
);

export const RedditLogo = () => (
  <Svg viewBox="0 0 82 30">
    <defs>
      <clipPath id="a">
        <path d="M0 792h612V0H0v792z" />
      </clipPath>
    </defs>
    <g clipPath="url(#a)" transform="matrix(.98784 0 0 -.98784 -273.4 399.012)">
      <path d="M280.7 392.42c0 .44.12.8.4 1.05.26.26.58.4.96.4.4 0 .72-.13 1-.4.27-.25.4-.6.4-1.05v-1.45h.07c.42.74.97 1.4 1.66 2 .68.6 1.4.9 2.15.94.42 0 .8-.13 1.12-.4.32-.28.5-.63.5-1.04 0-.48-.18-.83-.5-1.06-.35-.23-.83-.42-1.47-.6-.63-.15-1.05-.3-1.24-.4-1.53-.82-2.3-2.24-2.3-4.25v-8.28c0-.46-.12-.8-.38-1.07-.26-.25-.58-.38-.96-.38-.4 0-.74.14-1 .4-.3.27-.43.64-.43 1.12v14.48z" />
      <path
        fill="none"
        stroke="#000"
        strokeWidth=".76"
        d="M280.7 392.42c0 .44.12.8.4 1.05.26.26.58.4.96.4.4 0 .72-.13 1-.4.27-.25.4-.6.4-1.05v-1.45h.07c.42.74.97 1.4 1.66 2 .68.6 1.4.9 2.15.94.42 0 .8-.13 1.12-.4.32-.28.5-.63.5-1.04 0-.48-.18-.83-.5-1.06-.35-.23-.83-.42-1.47-.6-.63-.15-1.05-.3-1.24-.4-1.53-.82-2.3-2.24-2.3-4.25v-8.28c0-.46-.12-.8-.38-1.07-.26-.25-.58-.38-.96-.38-.4 0-.74.14-1 .4-.3.27-.43.64-.43 1.12v14.48z"
      />
      <path d="M292.5 386.2h9.4c-.02 1.58-.43 2.84-1.24 3.8-.8.95-1.9 1.44-3.3 1.47-1.43 0-2.58-.46-3.45-1.38-.86-.93-1.33-2.23-1.4-3.9m-2.83-.88c.06 1.46.4 2.84 1 4.15.6 1.3 1.47 2.37 2.6 3.2 1.12.8 2.44 1.22 3.96 1.24 1.47 0 2.78-.4 3.93-1.18 1.14-.8 2.02-1.85 2.64-3.16.63-1.3.94-2.68.94-4.1 0-.93-.53-1.4-1.57-1.4H292.5c.03-1.12.27-2.08.74-2.87.46-.8 1.1-1.37 1.87-1.76.8-.4 1.65-.58 2.6-.58 1.67 0 3.2.6 4.6 1.77.48.35.83.52 1.06.52.3 0 .55-.12.73-.35.17-.23.25-.52.25-.85 0-.35-.14-.7-.4-1.03-.64-.66-1.53-1.25-2.68-1.75-1.16-.5-2.4-.75-3.73-.75-1.4 0-2.6.26-3.63.8-1 .5-1.84 1.2-2.47 2.08-.63.87-1.08 1.8-1.37 2.8-.3 1-.44 2.03-.46 3.06l.05.1c0 .04.02.05.02.06" />
      <path
        fill="none"
        stroke="#000"
        strokeWidth=".76"
        d="M292.5 386.2h9.4c-.02 1.58-.43 2.84-1.24 3.8-.8.95-1.9 1.44-3.3 1.47-1.43 0-2.58-.46-3.45-1.38-.86-.93-1.33-2.23-1.4-3.9zm-2.83-.88c.06 1.46.4 2.84 1 4.15.6 1.3 1.47 2.37 2.6 3.2 1.12.8 2.44 1.22 3.96 1.24 1.47 0 2.78-.4 3.93-1.18 1.14-.8 2.02-1.85 2.64-3.16.63-1.3.94-2.68.94-4.1 0-.93-.53-1.4-1.57-1.4H292.5c.03-1.12.27-2.08.74-2.87.46-.8 1.1-1.37 1.87-1.76.8-.4 1.65-.58 2.6-.58 1.67 0 3.2.6 4.6 1.77.48.35.83.52 1.06.52.3 0 .55-.12.73-.35.17-.23.25-.52.25-.85 0-.35-.14-.7-.4-1.03-.64-.66-1.53-1.25-2.68-1.75-1.16-.5-2.4-.75-3.73-.75-1.4 0-2.6.26-3.63.8-1 .5-1.84 1.2-2.47 2.08-.63.87-1.08 1.8-1.37 2.8-.3 1-.44 2.03-.46 3.06l.05.1c0 .04.02.05.02.06z"
      />
      <path d="M309.5 385.22c0-1.74.36-3.22 1.1-4.44.76-1.22 1.88-1.86 3.36-1.92 1.18 0 2.14.3 2.87.92.73.6 1.26 1.4 1.57 2.34.32.95.5 1.96.5 3.03 0 1.24-.2 2.34-.6 3.3-.4.97-.95 1.7-1.66 2.24-.72.5-1.52.77-2.42.77-1.07 0-1.95-.3-2.66-.93-.7-.63-1.22-1.42-1.54-2.36-.33-.95-.5-1.94-.53-2.96m9.1 6.38v8.42c0 .44.13.78.4 1.03.28.26.6.38.97.38.4 0 .76-.12 1.03-.37.28-.26.4-.62.4-1.1v-22.1c0-.44-.13-.8-.4-1.05-.3-.25-.63-.38-1.03-.38-.35 0-.67.13-.95.4-.3.24-.43.57-.43.98v.93h-.07c-.3-.62-.8-1.15-1.5-1.6-.68-.43-1.6-.67-2.78-.7-1.5 0-2.83.36-3.97 1.1-1.13.73-2 1.76-2.64 3.07-.62 1.32-.95 2.8-.97 4.48 0 1.2.17 2.34.52 3.42.34 1.08.84 2.02 1.47 2.83.64.8 1.4 1.44 2.3 1.9.9.45 1.87.68 2.93.68 1.92 0 3.46-.76 4.63-2.3h.06z" />
      <path
        fill="none"
        stroke="#000"
        strokeWidth=".76"
        d="M309.5 385.22c0-1.74.36-3.22 1.1-4.44.76-1.22 1.88-1.86 3.36-1.92 1.18 0 2.14.3 2.87.92.73.6 1.26 1.4 1.57 2.34.32.95.5 1.96.5 3.03 0 1.24-.2 2.34-.6 3.3-.4.97-.95 1.7-1.66 2.24-.72.5-1.52.77-2.42.77-1.07 0-1.95-.3-2.66-.93-.7-.63-1.22-1.42-1.54-2.36-.33-.95-.5-1.94-.53-2.96zm9.1 6.38v8.42c0 .44.13.78.4 1.03.28.26.6.38.97.38.4 0 .76-.12 1.03-.37.28-.26.4-.62.4-1.1v-22.1c0-.44-.13-.8-.4-1.05-.3-.25-.63-.38-1.03-.38-.35 0-.67.13-.95.4-.3.24-.43.57-.43.98v.93h-.07c-.3-.62-.8-1.15-1.5-1.6-.68-.43-1.6-.67-2.78-.7-1.5 0-2.83.36-3.97 1.1-1.13.73-2 1.76-2.64 3.07-.62 1.32-.95 2.8-.97 4.48 0 1.2.17 2.34.52 3.42.34 1.08.84 2.02 1.47 2.83.64.8 1.4 1.44 2.3 1.9.9.45 1.87.68 2.93.68 1.92 0 3.46-.76 4.63-2.3h.06z"
      />
      <path d="M327.35 385.22c0-1.74.37-3.22 1.12-4.44.75-1.22 1.86-1.86 3.35-1.92 1.18 0 2.14.3 2.87.92.73.6 1.25 1.4 1.56 2.34.32.95.5 1.96.5 3.03 0 1.24-.2 2.34-.6 3.3-.4.97-.95 1.7-1.66 2.24-.72.5-1.52.77-2.42.77-1.07 0-1.95-.3-2.66-.93-.7-.63-1.22-1.42-1.54-2.36-.33-.95-.5-1.94-.53-2.96m9.1 6.38v8.42c0 .44.14.78.4 1.03.3.26.6.38.98.38.4 0 .76-.12 1.03-.37.28-.26.4-.62.4-1.1v-22.1c0-.44-.13-.8-.4-1.05-.3-.25-.63-.38-1.03-.38-.35 0-.67.13-.95.4-.3.24-.43.57-.43.98v.93h-.06c-.32-.62-.8-1.15-1.5-1.6-.7-.43-1.62-.67-2.8-.7-1.5 0-2.82.36-3.96 1.1-1.13.73-2 1.76-2.64 3.07-.62 1.32-.95 2.8-.97 4.48 0 1.2.17 2.34.52 3.42s.84 2.02 1.48 2.83c.64.8 1.4 1.44 2.3 1.9.9.45 1.87.68 2.93.68 1.92 0 3.46-.76 4.63-2.3h.05z" />
      <path
        fill="none"
        stroke="#000"
        strokeWidth=".76"
        d="M327.35 385.22c0-1.74.37-3.22 1.12-4.44.75-1.22 1.86-1.86 3.35-1.92 1.18 0 2.14.3 2.87.92.73.6 1.25 1.4 1.56 2.34.32.95.5 1.96.5 3.03 0 1.24-.2 2.34-.6 3.3-.4.97-.95 1.7-1.66 2.24-.72.5-1.52.77-2.42.77-1.07 0-1.95-.3-2.66-.93-.7-.63-1.22-1.42-1.54-2.36-.33-.95-.5-1.94-.53-2.96zm9.1 6.38v8.42c0 .44.14.78.4 1.03.3.26.6.38.98.38.4 0 .76-.12 1.03-.37.28-.26.4-.62.4-1.1v-22.1c0-.44-.13-.8-.4-1.05-.3-.25-.63-.38-1.03-.38-.35 0-.67.13-.95.4-.3.24-.43.57-.43.98v.93h-.06c-.32-.62-.8-1.15-1.5-1.6-.7-.43-1.62-.67-2.8-.7-1.5 0-2.82.36-3.96 1.1-1.13.73-2 1.76-2.64 3.07-.62 1.32-.95 2.8-.97 4.48 0 1.2.17 2.34.52 3.42s.84 2.02 1.48 2.83c.64.8 1.4 1.44 2.3 1.9.9.45 1.87.68 2.93.68 1.92 0 3.46-.76 4.63-2.3h.05z"
      />
      <path d="M351.75 391.3h-1.25c-.4 0-.72.1-.96.34-.24.23-.38.5-.42.84.08.84.54 1.26 1.38 1.26h1.25v3.8c0 .43.13.75.4.98.26.23.6.34.98.34.4 0 .75-.1 1.03-.34.27-.24.4-.58.4-1.04v-3.74h1.25c.44 0 .77-.12 1-.35.22-.24.33-.54.33-.92 0-.32-.1-.6-.33-.83-.22-.23-.5-.35-.85-.35h-1.38v-13.5c0-.42-.15-.76-.44-1-.3-.25-.65-.38-1.07-.38-.37 0-.68.13-.93.37s-.38.6-.38 1.07v13.43z" />
      <path
        fill="none"
        stroke="#000"
        strokeWidth=".76"
        d="M351.75 391.3h-1.25c-.4 0-.72.1-.96.34-.24.23-.38.5-.42.84.08.84.54 1.26 1.38 1.26h1.25v3.8c0 .43.13.75.4.98.26.23.6.34.98.34.4 0 .75-.1 1.03-.34.27-.24.4-.58.4-1.04v-3.74h1.25c.44 0 .77-.12 1-.35.22-.24.33-.54.33-.92 0-.32-.1-.6-.33-.83-.22-.23-.5-.35-.85-.35h-1.38v-13.5c0-.42-.15-.76-.44-1-.3-.25-.65-.38-1.07-.38-.37 0-.68.13-.93.37s-.38.6-.38 1.07v13.43z"
      />
      <path
        fill="#fff"
        d="M346.86 398.5c0-1.27-1.03-2.3-2.3-2.3-1.28 0-2.32 1.03-2.32 2.3 0 1.28 1.04 2.32 2.3 2.32 1.3 0 2.32-1.04 2.32-2.3"
      />
      <path
        fill="none"
        stroke="#000"
        strokeWidth="2.02"
        d="M346.86 398.5c0-1.27-1.03-2.3-2.3-2.3-1.28 0-2.32 1.03-2.32 2.3 0 1.28 1.04 2.32 2.3 2.32 1.3 0 2.32-1.04 2.32-2.3z"
      />
      <path fill="none" stroke="#000" strokeWidth="4.25" d="M344.56 392.57v-14.8" strokeLinecap="round" />
    </g>
  </Svg>
);

export const RevolutLogo = () => (
  <Svg viewBox="0 0 551.000000 125.000000">
    <g fill="#000000" stroke="none" transform="translate(0.000000,125.000000) scale(0.100000,-0.100000)">
      <path d="M0 635 l0 -615 120 0 120 0 0 250 0 251 92 -3 92 -3 141 -247 140 -247 138 -1 c75 0 137 2 137 5 0 3 -64 117 -141 253 -78 136 -143 250 -145 253 -2 4 22 19 54 35 73 36 147 105 179 167 44 88 46 243 4 325 -44 85 -146 157 -259 181 -32 7 -173 11 -362 11 l-310 0 0 -615z m637 385 c55 -25 83 -70 83 -135 0 -60 -25 -106 -72 -132 -28 -15 -63 -19 -220 -21 l-188 -4 0 156 0 156 178 0 c153 0 183 -3 219 -20z" />
      <path d="M3820 625 l0 -605 115 0 115 0 0 605 0 605 -115 0 -115 0 0 -605z" />
      <path d="M5092 663 c3 -466 3 -468 26 -515 26 -53 88 -113 138 -134 22 -9 72 -14 144 -14 l110 0 0 100 0 100 -64 0 c-49 0 -69 5 -90 21 l-26 20 0 235 0 234 90 0 90 0 0 95 0 95 -90 0 -90 0 0 115 0 115 -121 0 -120 0 3 -467z" />
      <path d="M1288 901 c-81 -27 -136 -61 -195 -123 -60 -65 -88 -115 -108 -200 -54 -228 45 -447 245 -542 62 -30 70 -31 195 -31 112 0 138 3 188 24 70 28 163 110 200 178 l26 49 -80 47 c-44 26 -84 47 -88 47 -4 0 -21 -20 -39 -44 -40 -58 -94 -93 -160 -106 -59 -11 -101 -5 -152 21 -60 30 -120 109 -120 159 0 20 4 20 330 20 l330 0 0 84 c0 192 -89 334 -255 407 -71 32 -236 37 -317 10z m270 -195 c26 -18 51 -47 67 -80 l26 -51 -222 -3 c-122 -1 -224 0 -227 3 -14 14 58 103 108 133 51 31 60 33 131 30 64 -3 82 -7 117 -32z" />
      <path d="M3101 905 c-129 -36 -248 -131 -297 -238 -35 -78 -50 -198 -35 -289 39 -237 214 -378 470 -378 150 0 250 36 347 123 56 51 94 115 119 201 21 73 16 237 -9 306 -41 113 -150 218 -273 262 -76 28 -244 34 -322 13z m244 -224 c140 -62 186 -249 92 -373 -67 -88 -208 -121 -303 -71 -52 28 -108 90 -124 138 -20 60 -8 167 23 214 71 107 194 143 312 92z" />
      <path d="M1853 886 c3 -7 83 -205 178 -440 l173 -427 109 3 109 3 169 415 c93 228 172 425 175 438 l6 23 -122 -3 -123 -3 -106 -282 c-58 -155 -109 -279 -112 -275 -4 4 -53 132 -110 285 l-104 277 -124 0 c-100 0 -122 -3 -118 -14z" />
      <path d="M4170 627 c0 -154 5 -299 11 -332 22 -122 87 -206 198 -259 64 -30 71 -31 201 -31 127 0 139 2 195 28 111 52 182 143 204 262 6 33 11 178 11 332 l0 273 -114 0 -115 0 -3 -272 c-3 -261 -4 -275 -26 -315 -32 -60 -86 -86 -167 -81 -72 4 -113 29 -141 85 -17 34 -19 68 -22 311 l-3 272 -115 0 -114 0 0 -273z" />
    </g>
  </Svg>
);

export const GiphyLogo = () => (
  <Svg viewBox="0 0 164 35">
    <g fillRule="evenodd" clipRule="evenodd">
      <path d="M0 3h4v29H0z" />
      <path d="M24 11h4v21h-4z" />
      <path d="M0 31h28v4H0z" />
      <path d="M0 0h16v4H0z" />
      <path d="M24 8V4h-4V0h-4v12h12V8" />
      <path d="M24 16v-4h4M16 0v4h-4" />
    </g>
    <g>
      <path d="M59.1 12c-2-1.9-4.4-2.4-6.2-2.4-4.4 0-7.3 2.6-7.3 8 0 3.5 1.8 7.8 7.3 7.8 1.4 0 3.7-.3 5.2-1.4v-3.5h-6.9v-6h13.3v12.1c-1.7 3.5-6.4 5.3-11.7 5.3-10.7 0-14.8-7.2-14.8-14.3 0-7.1 4.7-14.4 14.9-14.4 3.8 0 7.1.8 10.7 4.4L59.1 12zM68.2 31.2V4h7.6v27.2h-7.6zM88.3 23.8v7.3h-7.7V4h13.2c7.3 0 10.9 4.6 10.9 9.9 0 5.6-3.6 9.9-10.9 9.9h-5.5zm0-6.5h5.5c2.1 0 3.2-1.6 3.2-3.3 0-1.8-1.1-3.4-3.2-3.4h-5.5v6.7zM125 31.2V20.9h-9.8v10.3h-7.7V4h7.7v10.3h9.8V4h7.6v27.2H125zM149.2 13.3l5.9-9.3h8.7v.3l-10.8 16v10.8h-7.7V20.3L135 4.3V4h8.7l5.5 9.3z" />
    </g>
  </Svg>
);

export const GitHubLogo = () => (
  <Svg viewBox="0 0 4810 1440">
    <g fill="#fff">
      <path d="M583 1255 c-174 -47 -276 -160 -319 -353 -13 -57 -15 -110 -12 -240 4 -149 8 -176 32 -247 48 -142 125 -229 244 -277 51 -20 74 -23 227 -23 134 0 182 4 225 17 89 29 86 22 61 133 -13 53 -28 98 -35 101 -7 3 -41 -2 -77 -11 -35 -8 -96 -15 -135 -15 -206 0 -294 106 -294 355 0 233 82 345 252 345 112 0 108 4 108 -116 l0 -104 -80 0 -80 0 0 -110 0 -110 200 0 200 0 0 295 0 295 -48 24 c-82 42 -159 56 -293 55 -73 0 -146 -6 -176 -14z" />
      <path d="M1796 1256 c-57 -21 -88 -47 -116 -97 -24 -42 -25 -52 -28 -251 l-3 -207 -62 -3 -62 -3 -3 -78 c-3 -86 -5 -84 86 -107 l42 -11 0 -109 0 -110 120 0 120 0 0 105 0 104 83 3 82 3 3 103 3 102 -86 0 -86 0 3 165 c4 196 3 195 105 204 l68 6 3 81 c2 64 -1 84 -13 94 -24 20 -210 24 -259 6z" />
      <path d="M3200 1259 c-50 -15 -97 -54 -123 -102 -21 -40 -22 -53 -25 -349 l-3 -308 125 0 126 0 0 259 c0 250 1 259 22 286 19 25 26 27 72 23 28 -2 65 -11 81 -19 l30 -14 3 -268 2 -267 120 0 120 0 0 375 0 375 -84 0 c-74 0 -85 -2 -91 -19 -5 -18 -9 -17 -68 8 -51 21 -80 26 -167 28 -58 1 -121 -3 -140 -8z" />
      <path d="M4131 1250 c-29 -11 -60 -25 -68 -31 -12 -10 -16 -10 -24 2 -5 8 -9 17 -9 22 0 4 -40 7 -90 7 l-90 0 0 -550 0 -551 123 3 122 3 3 177 c1 98 4 178 6 178 2 0 23 -7 47 -16 27 -10 78 -17 129 -18 138 -2 211 45 267 169 15 34 18 68 18 220 -1 165 -3 185 -24 240 -28 72 -90 135 -148 153 -63 19 -199 15 -262 -8z m152 -200 c63 -50 63 -281 0 -345 -21 -20 -36 -25 -75 -25 -27 0 -64 7 -83 14 l-35 15 0 164 0 165 38 15 c54 23 124 21 155 -3z" />
      <path d="M1217 1244 c-4 -4 -7 -173 -7 -375 0 -325 2 -368 16 -373 23 -9 207 -7 222 2 9 7 12 89 10 378 l-3 369 -116 3 c-63 1 -118 -1 -122 -4z" />
      <path d="M2155 1238 c-3 -7 -4 -254 -3 -548 l3 -535 123 -3 122 -3 0 206 0 205 155 0 155 0 0 -205 0 -205 125 0 125 0 -2 548 -3 547 -122 3 -123 3 0 -236 0 -235 -155 0 -155 0 0 235 0 235 -120 0 c-87 0 -122 -3 -125 -12z" />
      <path d="M1295 440 c-53 -16 -88 -62 -92 -122 -5 -64 18 -106 70 -131 97 -46 197 16 197 122 0 94 -85 157 -175 131z" />
    </g>
  </Svg>
);

export const GizmodoLogo = () => (
  <Svg width="225" height="33" viewBox="0 0 225 33">
    <path
      fill="#000"
      fillRule="evenodd"
      d="M36.87 29.06V3.92c0-1.3.3-2.29.88-2.94A2.89 2.89 0 0 1 40 0c.95 0 1.72.32 2.31.97.59.64.88 1.63.88 2.95v25.14c0 1.32-.3 2.3-.88 2.96A3 3 0 0 1 40 33c-.91 0-1.66-.33-2.25-1-.6-.65-.89-1.64-.89-2.94zm172 3.94c-8.9 0-16.13-7.4-16.13-16.49 0-9.1 7.23-16.49 16.13-16.49 8.9 0 16.13 7.4 16.13 16.49 0 9.1-7.24 16.49-16.13 16.49zm0-26.3c-5.3 0-9.6 4.4-9.6 9.81s4.3 9.81 9.6 9.81 9.6-4.4 9.6-9.81-4.3-9.81-9.6-9.81zM136.44 33c-8.89 0-16.13-7.4-16.13-16.49 0-9.1 7.24-16.49 16.13-16.49 8.9 0 16.14 7.4 16.14 16.49 0 9.1-7.24 16.49-16.13 16.49zm0-26.3c-5.29 0-9.6 4.4-9.6 9.81s4.31 9.81 9.6 9.81c5.3 0 9.6-4.4 9.6-9.81s-4.3-9.81-9.6-9.81zm51.13 9.8c0-3.64-1.17-7.01-3.13-9.74A16.02 16.02 0 0 0 171.91.01l-.48-.01-8.1.01c-1.38 0-2.38.32-3 .97-.62.64-.93 1.68-.93 3.12v24.8c0 1.44.3 2.48.93 3.12.62.65 1.62.97 3 .97h8.58a16.02 16.02 0 0 0 12.53-6.75 16.67 16.67 0 0 0 3.13-9.74zm-15 9.74a39 39 0 0 1-2.52.06h-4.23V6.7h4.23c.9 0 1.75 0 2.53.06a9.57 9.57 0 0 1 6.76 4.18 9.91 9.91 0 0 1 1.7 5.54v.04a10 10 0 0 1-1.7 5.54 9.58 9.58 0 0 1-6.77 4.18zM111.18.14a2.74 2.74 0 0 0-3.13 1.17L98.3 16.46 88.59 1.31A2.75 2.75 0 0 0 85.44.15a2.91 2.91 0 0 0-1.98 2.8v26.91a2.86 2.86 0 0 0 2.8 2.93c1.54 0 2.8-1.31 2.8-2.93V12.55l6.9 10.75.02.02v.02a3.37 3.37 0 0 0 .16.23l.08.07.11.14.12.1.08.09.17.13.05.04.2.12.05.03.15.08c.28.13.58.22.88.25h.18l.1.01h.1l.17-.01c.3-.03.6-.12.89-.25l.15-.08.05-.03.19-.12.05-.04.17-.13.1-.09.1-.1.12-.14a2.2 2.2 0 0 0 .2-.27l.03-.03v-.02l.02-.02 6.9-10.75v17.31a2.86 2.86 0 0 0 2.8 2.93c1.55 0 2.8-1.31 2.8-2.93V2.94c0-1.28-.8-2.42-1.98-2.8zM73.95 32H53.02a3.1 3.1 0 0 1-2.78-1.8 3.67 3.67 0 0 1 .43-3.77l17.11-20.3H53.64c-1.54 0-2.8-1.37-2.8-3.05 0-1.7 1.26-2.72 2.8-2.72h19.07c1.1 0 2.24.18 3.23 1.3.91 1.01.87 3.2-.15 4.52l-16.53 19.7h14.68c1.54 0 2.67 1.37 2.67 3.06S75.48 32 73.94 32zm-57.92 1c-4.65 0-8.86-1.88-11.86-5.3C1.52 24.7 0 20.73 0 16.82 0 4.57 9.97 0 16.25 0c6.18 0 10.71 3.1 10.9 3.23a3.2 3.2 0 0 1 .83 4.35 2.97 2.97 0 0 1-4.2.87 14.83 14.83 0 0 0-7.53-2.17c-3.94 0-9.37 2.65-9.37 10.54 0 4.49 3.27 9.78 9.25 9.78 3.37 0 5.74-.92 7.12-1.81v-4.67h-4.67a3.09 3.09 0 0 1-3.03-3.14 3.09 3.09 0 0 1 3.03-3.14h7.7c1.68 0 3.04 1.4 3.04 3.14v9.34a3.2 3.2 0 0 1-.93 2.25C26.36 30.61 21.9 33 16.02 33z"
    ></path>
  </Svg>
);

export const TargetLogo = () => (
  <Svg viewBox="0 0 286.5 63">
    <path
      fill="#EB2D2D"
      d="M31.5 42C37.3 42 42 37.6 42 31.8c0-5.8-4.7-10.5-10.5-10.5S21 26 21 31.7 25.8 42 31.6 42zm0 10c11 0 20-9 20-20 0-11.2-9-20.3-20-20.3s-20 9-20 20.2c0 11 9 20 20 20zM1.2 32c0-17 13.6-30.4 30.3-30.4C48.3 1.6 61.8 15 61.8 32 61.8 48.5 48.3 62 31.5 62 14.8 62.2 1.2 48.6 1.2 32z"
    />
    <path d="M71.7 10h34.5V19h-12v35H84v-35h-12v-8.7M158.2 19h-9.7v8.6h8.7c3 0 5.4-1.4 5.4-4.4 0-3.2-2-4.3-4.4-4.3zm-19.7-9H159c11.6 0 13.2 8 13.2 12.7 0 6.8-5.8 10.2-6.3 10.3 0 0 5 2 5 7.7v8c0 3.4 2 4.3 2.4 5H165c-4-.4-4-3.5-3.8-5.4v-7c0-1.7-.7-3.6-4.2-3.6h-8.5v16h-10V10.2zM216.8 10V54h31.4v-9H227V35h18v-8.2h-18v-8h21.2v-8.7h-31.4M249.7 19h12.5v34.8h10.3v-35H285v-8.7h-35.3v9M117 25.5l-3.6 11.3h7.7l-4-11.3zM111.4 10h11.2L137.7 54H127l-3.3-9h-13l-2.8 9H97L111.4 10zM213.2 29.4h-18.8V38h9c0 1.6.2 3.4-2 5.8-.6 1-3 2.7-6.5 2.7-3 0-5-.8-6.8-2.3-4-3.4-5-9.6-5-13 0-4 1.7-14.3 12-14.7 0 0 6.7-.5 8.4 7.7h9.5c0-4-5-15.8-18-16-4.4 0-10 1.5-15 6.2-3.3 3.4-6.3 9.2-6.3 17.3 0 8.8 3.2 14.5 6 17.6 5.3 5.5 10.6 6 13.3 6 2 0 6.3-.4 11.6-4l1.5 2.5h7.2V29.4zM277.3 51h.5c.4 0 .6-.2.6-.5 0-.4-.3-.4-.6-.4h-.5v1zm-.6-1.4h1c1 0 1.3.2 1.3 1 0 .5-.3.7-.8.7l1 1.4h-.8l-.7-1.3h-.4v1.3h-.6v-3zm1 3.7c1.2 0 2-1 2-2 0-1.4-.8-2.3-2-2.3-1 0-2 1-2 2.2 0 1.2 1 2 2 2zm0-5c1.6 0 3 1.2 3 3 0 1.5-1.4 2.6-3 2.6-1.4 0-2.8-1.2-2.8-2.8 0-1.7 1.3-2.8 2.8-2.8z" />
  </Svg>
);

export const EuroVisionLogo = () => (
  <Svg viewBox="0 0 138.8 44">
    <path d="M117.9 26.8c-1.8 0-2.9-2.2-2.8-4.4.2-4.1 3.6-8.1 3.6-8.1.8.7 3.1 4.6 2.9 7.5 0 2.8-1.8 5.1-3.7 5zm2.3-13.7c.8-1 1.3-1.6 1.2-2.2-.1-.6-2.2-1.1-3.3-.2-2.8-2.2-2.2.4-1.8 1-3.3 2.4-5.7 8.7-3.9 13.6 1.9 4.8 7.3 5.3 10.2 2 2.6-3 2.1-8.5-2.3-14.3M24.2 42.8l.9-1.1m-.9 1.1l.9-1.1m-.9 1.1l.9-1.1m-.9 1.1l.9-1.1c.7.6 1.3.8 2.2.8.6 0 1-.3 1-.7 0-.4-.3-.6-1.5-.9-1.4-.3-2.4-.7-2.4-2.2 0-1.3 1.1-2.1 2.6-2.1 1.1 0 1.9.3 2.7.9l-.8 1.2c-.7-.4-1.3-.7-1.9-.7s-.9.3-.9.6v.1c0 .4.2.6 1.5.9 1.4.4 2.2.9 2.2 2.2 0 1.4-1.1 2.2-2.6 2.2-1.1-.1-2.3-.5-3-1.2m13.2-2.6c0-1.3-.9-2.3-2.2-2.3s-2.2 1-2.2 2.2c0 1.3.9 2.2 2.2 2.2s2.2-.9 2.2-2.2v.1zm-6.1 0c0-2.1 1.7-3.9 3.9-3.9s3.9 1.7 3.9 3.8c0 2.1-1.7 3.8-3.9 3.8s-3.9-1.7-3.9-3.7m9.6-3.7h1.4l3.3 4.4v-4.4h1.7v7.2h-1.4l-3.5-4.6v4.6h-1.6c.1 0 .1-7.2.1-7.2zm8.3 3.6c0-2.1 1.7-3.9 3.9-3.9 1.3 0 2.1.4 2.8 1.1l-1 1.1c-.6-.4-1.1-.7-1.9-.7-1.1 0-2.1 1-2.1 2.2 0 1.3.9 2.3 2.2 2.3.6 0 1.1-.2 1.4-.4v-1.1H53v-1h3.1v3.1c-.7.6-1.8 1.1-3.1 1.1-2.2 0-3.9-1.6-3.9-3.7m12.5.1c0-2.1 1.7-3.9 3.9-3.9 1.3 0 2.1.6 2.8 1.2l-1 1.1c-.6-.6-1.1-.8-1.8-.8-1.3 0-2.2 1-2.2 2.2 0 1.3.9 2.2 2.2 2.2.8 0 1.3-.3 1.8-.8l1 1.1c-.7.7-1.5 1.2-2.9 1.2-2.1.1-3.7-1.5-3.8-3.5m14.2-.1c0-1.3-.9-2.3-2.2-2.3s-2.1 1-2.1 2.2c0 1.3.9 2.2 2.2 2.2 1.2 0 2.1-.9 2.1-2.2v.1zm-6 0c0-2.1 1.7-3.9 3.9-3.9s3.8 1.7 3.8 3.8c0 2.1-1.7 3.8-3.9 3.8s-3.8-1.7-3.8-3.7m9.4-3.7h1.5l3.3 4.4v-4.4h1.7v7.2h-1.4l-3.4-4.6v4.6h-1.7v-7.2zm10.2 1.6h-2.1v-1.4h6v1.4h-2.2v5.7h-1.7v-5.7zm5.7-1.4h5.4v1.4h-3.9v1.4h3.4v1.4h-3.3v1.7h3.9V44H95v-7.3h.1zm7.1 6.1l.9-1.1c.6.6 1.3.9 2.1.9.7 0 1.1-.3 1.1-.7 0-.4-.3-.6-1.5-.9-1.4-.3-2.4-.7-2.4-2.2 0-1.3 1.1-2.1 2.5-2.1 1 0 1.9.3 2.6.9l-.8 1.2c-.7-.4-1.3-.7-1.9-.7-.7 0-1 .3-1 .6v.1c0 .4.3.6 1.6.9 1.5.4 2.2.9 2.2 2.2 0 1.4-1 2.2-2.6 2.2-1.1 0-2.2-.4-3.1-1.1m9.3-4.9H109v-1.4h6v1.4h-2.2v5.7h-1.6v-5.7zM13.4 3.5C7.1 3.1-.1 8.3.2 15.2c0 .7.6 1.3 1.4 1.3h3.9S0 20.9 0 26.1c0 2.8 2.1 6.1 6.4 6.1 6.1 0 10.7-5 10.7-9.2 0-.4-.4-.8-1.1-.1-.9 1.1-6 6.4-11 6.4-1.7 0-3.2-.9-3.2-3 .1-2.6 4.2-7.6 11.4-9.7 1.8-.6 1.9-3-.3-3.1-2.2-.1-9.8.7-10.3.7s-.6-.1-.4-.6c.3-.7 3.1-5.6 11.4-6.5 2.8-.2 2.6-3.5 0-3.7m9.2 8.2c0-1.7-2.5-2.8-3.4-.3-1.8 4.4-2.4 18.1 3.6 18.1 2.6 0 6-5.8 6-11.3 0-4.7-1.9-7.8-2.3-8.3-.4-.6-.9-.2-.9.8.1 1.1.4 10.6-2.6 13.9-1.1 1.3-2.1 0-2.2-1.3-.3-3.7 1.7-9.3 1.7-11.7m27.4 14.8c-1.7 0-2.6-2.2-2.6-4.6 0-4.2 3-7.9 3-7.9.7 1.1 2.8 4.1 2.8 7 0 3-1.6 5.5-3.2 5.5zm1.3-13.8s.9-1.3.4-2.1c-.7-.8-2.8-1.1-4.6 1.1-2.6 2.8-4.3 8.9-2.4 13.9 1.8 4.8 7 5.2 9.4 1.6 2.1-3.3 1.5-8.7-2.8-14.5m-16.8 4.8l.3-3.8s4.2-1.1 5.6-1c1.3.1 1.6.7.9 1.7-1.6 2.2-5.1 3.1-6.8 3.1zm9 12.5c-1.9-2.4-4.1-7.3-7.4-10.4 3.4-.2 7.8-2.9 7.8-5.8 0-2.1-2.2-3.7-5.1-3.7-2.9 0-6.1 1-7.3 1.7-1.6 1-.4 3.2 1.1 2.6 0 0-.6 2.6-.7 3.9-1.1 0-1.4.2-1.3.4 0 .3.6.6 1.1 1.2-.2 1.7-.6 8.8-.4 9.4 0 .6.4.7 1 0 .4-.6 1.5-1.9 1.9-7.3.6.6 2.1 2.5 3.9 4.9 2.8 3.5 3.6 3.7 4.7 4.1.6.2 1.2-.1.8-.7m44.4-19.5c.1 3.7-3.2 9.6-3.3 13.9-.2 3.2.3 4.4.6 5 .3.3.9.4 1.1-.4.6-2.4 3.9-8.6 4.3-13.6.2-3.1-.7-5-1.8-5.3-.6-.3-.9-.2-.9.4m12.2-.7c-4.6 0-7.9 1.7-7.9 5.4 0 2.2 1.7 3.9 4.4 4.3 1.5.3 3.1.4 3.6.6 1 .4-1.4 1.6-5.2 4.1-2.6 1.7-4.4 3.6-5.4 5.6-.4.6.1 1.3.8.8 1.4-1 4.4-2.6 7.4-4.2 2.8-1.6 5.4-3.3 5.4-5.4 0-1.9-1.4-2.7-2.6-2.8-1.9-.2-6.1 0-6.1-2.4 0-.9 1.1-2.1 5-2.1 3 0 2.8-3.6.3-3.6m6 .5c1.6 2.9-1 10.7-1 13.7 0 2.9.3 4 1.1 5 .4.4.9.2 1-.4.3-2.6 3.1-9.7 3.3-13.1.2-4.2-1.9-5.8-3.2-5.9-.6.1-1.5.2-1.2.7m1.2-4c0 2.8 4.4 3.2 4.4-.2 0-2.9-2.4-5.4-2.9-5.8-.8-.6-1.8-.6-1.7.6.7 2.1.2 4.5.2 5.4m31.4 22.8c-.6-3.7.2-8.5.2-13 0-3.3-2.8-5.2-4.4-5.2-2.2 0-3.6 1-3.6 1l.1-1.9c0-.4-.4-.4-1.1 0-3.4 2.1-3.9 8.2-3.9 12.5 0 4.3.7 5.8.7 6.4.1.6.8.7 1.1.2 1.8-3.6 2-10 2.6-13.7.9-1.1 4.4-1.4 4.6 1.4.1 2.8-.2 10.1 2.8 12.6.4.4 1 .3.9-.3M59.1 14.2c.1-6.9 3.7-9.1 5.6-9.1 2.8 0 3.9 2.1 4.1 3 .2 1 1.2 1.7 1.6.2.3-1.5 3.6-6.1 7.4-6.1 3.6 0 4.8 3.7 4.7 6.9-.3 8.6-11.4 15.4-12.8 19.8-1.4-2.6-10.7-6.3-10.6-14.7zM79.1.1c-3.3 0-7.1 2.4-9.4 6.3-.6-1.4-2.8-3-5.6-3C62 3.4 56 6.1 56 14.7 56 25.8 67.1 28 69.4 31.5c.2.2.7.4.8-.2C72 25.9 86 19.9 86 9.1 86.2 3 82.3 0 78.9 0" />
  </Svg>
);

export const ArtsyLogo = () => (
  <Svg viewBox="0 0 10400 3610">
    <g>
      <path d="M40 1810 l0 -1760 5160 0 5160 0 0 1760 0 1760 -5160 0 -5160 0 0 -1760z m5680 1195 l0 -235 165 0 165 0 0 235 0 235 1995 0 1995 0 0 -1435 0 -1435 -4835 0 -4835 0 0 1435 0 1435 2675 0 2675 0 0 -235z" />
      <path d="M6805 2374 c-97 -21 -165 -56 -224 -115 -63 -64 -84 -108 -89 -186 l-4 -63 125 0 125 0 6 32 c9 47 74 103 136 118 96 23 225 -3 277 -55 28 -28 33 -40 33 -78 0 -84 -55 -126 -223 -171 -147 -39 -304 -103 -347 -143 -21 -18 -45 -49 -54 -68 -59 -123 -34 -309 51 -386 72 -66 224 -119 339 -119 218 0 367 96 408 261 9 36 16 71 16 77 0 9 -34 12 -120 12 l-120 0 -11 -27 c-34 -92 -165 -127 -287 -78 -43 18 -65 49 -65 95 0 71 42 101 198 139 345 85 446 175 449 401 1 73 -3 93 -27 145 -34 73 -56 97 -127 140 -129 77 -308 104 -465 69z" />
      <path d="M1419 2348 c5 -13 63 -165 129 -338 67 -173 150 -389 185 -480 35 -91 81 -209 102 -262 l37 -98 138 0 137 0 143 378 c150 396 176 464 259 680 28 73 51 134 51 137 0 3 -60 5 -134 5 l-133 0 -43 -122 c-23 -68 -49 -144 -58 -170 l-16 -48 -206 0 -206 0 -58 170 -58 170 -139 0 -139 0 9 -22z m695 -605 c-14 -38 -44 -117 -66 -176 l-41 -108 -63 173 c-35 95 -64 174 -64 176 0 1 58 2 130 2 l130 0 -26 -67z" />
      <path d="M3020 1770 l0 -600 316 0 c368 0 417 7 514 72 109 72 155 168 155 318 -1 77 -5 105 -23 145 -51 112 -124 181 -226 213 l-55 17 42 52 c126 154 297 372 297 377 0 3 -69 6 -153 6 l-152 0 -45 -57 c-25 -31 -81 -102 -125 -158 -44 -56 -125 -158 -180 -228 l-100 -127 -3 285 -2 285 -130 0 -130 0 0 -600z m663 -74 c47 -23 69 -65 69 -126 0 -60 -18 -98 -61 -127 -32 -22 -43 -23 -222 -23 l-189 0 0 151 0 150 183 -3 c154 -3 188 -6 220 -22z" />
      <path d="M4860 1895 l0 -475 -210 0 -210 0 0 -125 0 -125 560 0 560 0 0 125 0 125 -210 0 -210 0 0 475 0 475 -140 0 -140 0 0 -475z" />
      <path d="M8250 2148 l0 -223 -225 -369 c-124 -203 -225 -373 -225 -378 0 -4 65 -8 144 -8 l144 0 142 245 c79 135 147 244 151 243 5 -2 73 -111 151 -243 l144 -240 147 -3 c81 -1 147 0 147 2 0 3 -57 99 -127 213 -69 115 -173 285 -230 379 l-103 171 0 216 0 217 -130 0 -130 0 0 -222z" />
    </g>
    <g>
      <path d="M360 1805 l0 -1445 4843 2 4842 3 3 1443 2 1442 -2005 0 -2005 0 0 -235 0 -235 -162 -3 -163 -3 168 -2 167 -2 0 235 0 235 1995 0 1995 0 0 -1435 0 -1435 -4835 0 -4835 0 0 1435 0 1435 2678 3 2677 2 -2682 3 -2683 2 0 -1445z" />
      <path d="M6913 2383 c26 -2 68 -2 95 0 26 2 4 3 -48 3 -52 0 -74 -1 -47 -3z" />
      <path d="M1544 2360 l139 -5 20 -58 c10 -32 21 -56 23 -54 2 2 -6 31 -17 65 l-21 62 -141 -2 -142 -2 139 -6z" />
      <path d="M2370 2363 c108 -7 230 -7 230 0 0 4 -62 6 -137 5 -76 -1 -118 -3 -93 -5z" />
      <path d="M3020 1770 l0 -600 328 2 327 3 -322 2 -323 3 0 590 0 590 120 0 120 0 2 -292 3 -291 59 74 c33 41 76 94 95 118 20 25 31 42 26 39 -6 -4 -47 -52 -90 -107 l-80 -101 -3 285 -2 285 -130 0 -130 0 0 -600z" />
      <path d="M3719 2351 c-8 -10 -36 -47 -64 -82 -27 -35 -43 -59 -35 -52 8 6 38 41 65 77 l50 65 148 1 148 0 -62 -77 c-34 -43 -69 -86 -77 -95 -8 -10 -12 -18 -9 -18 7 0 157 185 157 194 0 3 -69 6 -154 6 -139 0 -155 -2 -167 -19z" />
      <path d="M4993 2363 l137 -4 0 -474 0 -475 218 2 217 3 -212 2 -213 3 0 475 0 475 -142 -2 -143 -2 138 -3z" />
      <path d="M8250 2149 c0 -134 -4 -229 -11 -242 -10 -21 -10 -21 5 -3 13 17 16 56 16 238 l0 217 128 4 127 3 -132 2 -133 2 0 -221z" />
      <path d="M2316 2324 c-4 -14 -5 -28 -3 -31 3 -2 8 8 11 23 4 14 5 28 3 31 -3 2 -8 -8 -11 -23z" />
      <path d="M6659 2321 c-62 -39 -149 -130 -149 -156 0 -4 13 10 29 31 40 54 88 98 141 128 25 14 40 26 34 26 -5 0 -30 -13 -55 -29z" />
      <path d="M7310 2273 c14 -12 36 -35 48 -50 14 -17 20 -20 14 -8 -10 20 -44 53 -72 70 -9 6 -4 0 10 -12z" />
      <path d="M2541 2234 c-12 -31 -20 -59 -18 -61 2 -2 14 22 26 53 12 31 20 59 18 61 -2 2 -14 -22 -26 -53z" />
      <path d="M3563 2153 c-21 -27 -54 -68 -72 -93 l-33 -45 32 35 c44 50 122 150 117 150 -3 0 -23 -21 -44 -47z" />
      <path d="M6928 2173 c12 -2 32 -2 45 0 12 2 2 4 -23 4 -25 0 -35 -2 -22 -4z" />
      <path d="M6835 2155 c-16 -8 -37 -20 -46 -27 -25 -20 -59 -80 -59 -103 1 -11 7 -2 15 20 17 48 73 100 123 113 20 6 28 10 17 11 -11 0 -33 -6 -50 -14z" />
      <path d="M7115 2138 c11 -6 30 -20 43 -31 12 -11 22 -16 22 -10 0 12 -61 53 -76 53 -5 0 0 -6 11 -12z" />
      <path d="M2236 2094 c-9 -26 -16 -52 -15 -58 0 -6 9 13 20 43 10 30 17 56 15 58 -2 2 -11 -17 -20 -43z" />
      <path d="M1772 2105 c0 -5 6 -26 13 -45 7 -19 14 -28 14 -20 0 8 -6 29 -14 45 -7 17 -13 26 -13 20z" />
      <path d="M2488 2095 c-3 -11 -9 -29 -13 -40 -3 -11 1 -7 10 8 9 16 15 33 12 40 -2 6 -6 3 -9 -8z" />
      <path d="M1526 2070 c3 -14 11 -32 16 -40 6 -10 7 -7 2 10 -3 14 -11 32 -16 40 -6 10 -7 7 -2 -10z" />
      <path d="M7423 2025 c0 -27 2 -38 4 -22 2 15 2 37 0 50 -2 12 -4 0 -4 -28z" />
      <path d="M3741 1996 c-28 -35 -51 -67 -51 -70 0 -3 10 -6 23 -5 18 0 19 2 5 7 -15 6 -13 11 13 42 41 49 71 90 66 90 -3 0 -28 -29 -56 -64z" />
      <path d="M7193 2025 c0 -22 2 -30 4 -17 2 12 2 30 0 40 -3 9 -5 -1 -4 -23z" />
      <path d="M7162 1948 c-13 -16 -40 -37 -60 -48 -21 -10 -33 -19 -29 -20 25 -1 129 82 116 94 -2 2 -15 -10 -27 -26z" />
      <path d="M1576 1940 c3 -14 11 -32 16 -40 6 -10 7 -7 2 10 -3 14 -11 32 -16 40 -6 10 -7 7 -2 -10z" />
      <path d="M8510 1926 c0 -10 40 -76 46 -76 3 0 -2 12 -10 28 -22 40 -36 58 -36 48z" />
      <path d="M3780 1903 c8 -3 24 -10 35 -15 20 -9 20 -9 1 6 -11 9 -27 16 -35 15 -14 0 -14 -1 -1 -6z" />
      <path d="M3840 1877 c0 -3 18 -20 40 -37 22 -17 40 -29 40 -27 0 3 -18 20 -40 37 -22 17 -40 29 -40 27z" />
      <path d="M7379 1848 c-7 -18 -34 -53 -59 -78 -38 -38 -39 -41 -10 -19 35 26 98 115 88 124 -3 3 -11 -9 -19 -27z" />
      <path d="M8214 1868 c-4 -7 -14 -24 -22 -38 -14 -24 -13 -24 3 -5 20 24 37 55 31 55 -3 0 -8 -6 -12 -12z" />
      <path d="M8569 1825 c5 -11 17 -29 26 -40 l16 -20 -10 20 c-5 11 -17 29 -26 40 l-16 20 10 -20z" />
      <path d="M8159 1778 c-7 -13 -19 -34 -27 -48 -14 -24 -13 -24 3 -5 20 24 48 75 41 75 -3 0 -11 -10 -17 -22z" />
      <path d="M2361 1759 c-6 -18 -9 -34 -7 -36 2 -2 9 10 15 28 6 18 9 34 7 36 -2 2 -9 -10 -15 -28z" />
      <path d="M6669 1750 c-36 -19 -109 -95 -109 -113 0 -5 15 11 33 35 18 24 55 55 82 70 28 15 46 27 40 27 -5 0 -26 -9 -46 -19z" />
      <path d="M1651 1748 c-1 -12 31 -89 35 -85 3 2 -4 24 -15 48 -11 24 -20 41 -20 37z" />
      <path d="M3270 1570 l0 -160 193 2 192 3 -187 2 -188 3 0 150 0 150 173 3 172 3 -177 2 -178 2 0 -160z" />
      <path d="M7220 1704 c-25 -14 -34 -22 -20 -18 25 7 70 33 70 40 0 5 1 6 -50 -22z" />
      <path d="M2331 1679 c-6 -18 -9 -34 -7 -36 2 -2 9 10 15 28 6 18 9 34 7 36 -2 2 -9 -10 -15 -28z" />
      <path d="M3713 1677 c15 -14 27 -32 27 -38 0 -7 3 -10 6 -7 9 10 -15 47 -39 59 -18 10 -17 7 6 -14z" />
      <path d="M8367 1667 c-3 -7 3 -13 13 -13 10 0 16 6 13 13 -3 7 -9 13 -13 13 -4 0 -10 -6 -13 -13z" />
      <path d="M7065 1650 c-13 -5 -14 -9 -5 -9 8 0 24 4 35 9 13 5 14 9 5 9 -8 0 -24 -4 -35 -9z" />
      <path d="M8044 1588 c-21 -35 -44 -73 -52 -85 -8 -13 -12 -23 -9 -23 3 0 22 28 43 63 21 34 44 72 52 85 8 12 12 22 9 22 -3 0 -22 -28 -43 -62z" />
      <path d="M8347 1633 c-2 -5 -17 -30 -32 -58 -16 -27 -24 -45 -18 -40 14 14 66 105 60 105 -3 0 -8 -3 -10 -7z" />
      <path d="M6945 1620 c-13 -5 -14 -9 -5 -9 8 0 24 4 35 9 13 5 14 9 5 9 -8 0 -24 -4 -35 -9z" />
      <path d="M4003 1555 c0 -38 2 -53 4 -32 2 20 2 52 0 70 -2 17 -4 1 -4 -38z" />
      <path d="M8722 1574 c13 -22 31 -52 41 -65 10 -13 8 -6 -5 17 -13 22 -31 52 -41 65 -10 13 -8 6 5 -17z" />
      <path d="M1952 1588 c3 -7 13 -37 23 -66 9 -29 19 -52 21 -49 5 5 -36 127 -43 127 -3 0 -3 -6 -1 -12z" />
      <path d="M8455 1543 c29 -50 45 -72 45 -61 0 9 -62 108 -67 108 -3 0 7 -21 22 -47z" />
      <path d="M6812 1573 c-7 -2 -17 -14 -23 -26 -9 -19 -8 -20 3 -7 8 8 20 21 28 28 15 13 13 14 -8 5z" />
      <path d="M6533 1490 c0 -25 2 -35 4 -22 2 12 2 32 0 45 -2 12 -4 2 -4 -23z" />
      <path d="M8277 1513 c-2 -5 -17 -30 -32 -58 -16 -27 -24 -45 -18 -40 14 14 66 105 60 105 -3 0 -8 -3 -10 -7z" />
      <path d="M2251 1469 c-6 -18 -9 -34 -7 -36 2 -2 9 10 15 28 6 18 9 34 7 36 -2 2 -9 -10 -15 -28z" />
      <path d="M7129 1463 c-14 -38 -38 -63 -74 -79 -18 -8 -23 -13 -13 -14 24 0 87 57 94 86 6 24 8 24 119 24 100 0 114 -2 118 -17 4 -14 5 -12 6 5 1 22 -1 22 -119 22 l-120 0 -11 -27z" />
      <path d="M3724 1469 c-3 -6 -20 -19 -38 -30 -17 -10 -25 -19 -19 -19 13 0 83 59 71 60 -4 0 -10 -5 -14 -11z" />
      <path d="M8780 1478 c0 -7 45 -77 57 -88 10 -9 -25 54 -41 75 -8 11 -16 17 -16 13z" />
      <path d="M8512 1450 c8 -14 27 -46 42 -72 15 -27 30 -48 33 -48 6 0 -49 96 -71 123 l-18 22 14 -25z" />
      <path d="M4543 1413 c59 -2 155 -2 215 0 59 1 10 3 -108 3 -118 0 -167 -2 -107 -3z" />
      <path d="M1796 1370 c3 -14 11 -32 16 -40 6 -10 7 -7 2 10 -3 14 -11 32 -16 40 -6 10 -7 7 -2 -10z" />
      <path d="M7909 1368 c-7 -13 -19 -34 -27 -48 -14 -24 -13 -24 3 -5 20 24 48 75 41 75 -3 0 -11 -10 -17 -22z" />
      <path d="M3928 1323 c-21 -30 -33 -51 -28 -48 13 8 73 95 68 100 -1 1 -20 -22 -40 -52z" />
      <path d="M8862 1344 c13 -22 31 -52 41 -65 10 -13 8 -6 -5 17 -13 22 -31 52 -41 65 -10 13 -8 6 5 -17z" />
      <path d="M7341 1354 c-2 -30 -68 -107 -119 -139 -31 -19 -52 -35 -48 -35 43 0 185 142 173 172 -3 7 -6 8 -6 2z" />
      <path d="M8165 1320 c-9 -16 -13 -30 -11 -30 3 0 12 14 21 30 9 17 13 30 11 30 -3 0 -12 -13 -21 -30z" />
      <path d="M6570 1318 c0 -12 62 -78 84 -89 11 -6 7 1 -11 15 -17 15 -41 39 -52 54 -11 15 -21 24 -21 20z" />
      <path d="M8125 1250 c-9 -16 -13 -30 -11 -30 3 0 12 14 21 30 9 17 13 30 11 30 -3 0 -12 -13 -21 -30z" />
      <path d="M3800 1220 c-19 -11 -31 -19 -27 -20 11 0 67 29 67 35 0 7 -1 7 -40 -15z" />
      <path d="M7816 1215 c-9 -13 -16 -29 -16 -35 0 -6 52 -10 145 -10 140 0 145 1 155 23 10 20 10 20 -3 5 -12 -16 -33 -18 -151 -18 -75 0 -136 2 -136 5 0 3 7 17 16 30 9 14 14 25 11 25 -2 0 -12 -11 -21 -25z" />
      <path d="M8662 1200 c15 -25 18 -25 162 -28 136 -2 168 3 134 24 -7 4 -8 3 -4 -4 5 -9 -29 -12 -132 -12 -133 0 -140 1 -157 23 -17 22 -17 22 -3 -3z" />
      <path d="M6726 1191 c5 -5 23 -12 39 -16 30 -6 30 -6 -4 10 -38 17 -49 19 -35 6z" />
      <path d="M1938 1173 c39 -2 105 -2 145 0 39 1 7 3 -73 3 -80 0 -112 -2 -72 -3z" />
      <path d="M4718 1173 c155 -2 409 -2 565 0 155 1 28 2 -283 2 -311 0 -438 -1 -282 -2z" />
      <path d="M7120 1170 c-21 -7 -21 -8 -5 -9 11 0 27 4 35 9 18 11 5 11 -30 0z" />
      <path d="M6918 1143 c23 -2 61 -2 85 0 23 2 4 4 -43 4 -47 0 -66 -2 -42 -4z" />
    </g>
    <g>
      <path d="M362 1808 l3 -1443 2 1437 3 1438 2678 3 2677 2 -2682 3 -2683 2 2 -1442z" />
      <path d="M6042 3008 l3 -243 2 237 3 238 1998 3 1997 2 -2002 3 -2003 2 2 -242z" />
      <path d="M7003 2383 c9 -2 25 -2 35 0 9 3 1 5 -18 5 -19 0 -27 -2 -17 -5z" />
      <path d="M3025 1770 c0 -333 1 -469 2 -303 2 167 2 439 0 605 -1 167 -2 31 -2 -302z" />
      <path d="M3270 2075 c0 -164 3 -296 6 -293 6 7 5 580 -1 587 -3 2 -5 -130 -5 -294z" />
      <path d="M5135 1890 l0 -475 213 0 212 -1 -210 3 -210 3 -3 473 -2 472 0 -475z" />
      <path d="M8254 2150 c0 -124 2 -174 3 -112 2 61 2 163 0 225 -1 61 -3 11 -3 -113z" />
      <path d="M3670 2290 c-17 -22 -29 -40 -27 -40 3 0 20 18 37 40 17 22 29 40 27 40 -3 0 -20 -18 -37 -40z" />
      <path d="M7310 2277 c0 -2 15 -16 33 -33 l32 -29 -29 33 c-28 30 -36 37 -36 29z" />
      <path d="M6792 2123 c-24 -24 -24 -25 -2 -8 42 33 44 35 37 35 -4 0 -19 -12 -35 -27z" />
      <path d="M7121 2138 c2 -2 18 -14 34 -28 l30 -25 -24 28 c-14 15 -29 27 -34 27 -6 0 -8 -1 -6 -2z" />
      <path d="M7423 2025 c0 -27 2 -38 4 -22 2 15 2 37 0 50 -2 12 -4 0 -4 -28z" />
      <path d="M3760 2018 c-19 -24 -26 -37 -17 -29 19 15 61 71 54 71 -2 0 -19 -19 -37 -42z" />
      <path d="M3270 1570 l0 -160 183 2 182 3 -177 2 -178 3 0 150 0 150 163 3 162 3 -167 2 -168 2 0 -160z" />
      <path d="M6533 1490 c0 -25 2 -35 4 -22 2 12 2 32 0 45 -2 12 -4 2 -4 -23z" />
      <path d="M4543 1413 c59 -2 155 -2 215 0 59 1 10 3 -108 3 -118 0 -167 -2 -107 -3z" />
      <path d="M6918 1143 c23 -2 61 -2 85 0 23 2 4 4 -43 4 -47 0 -66 -2 -42 -4z" />
    </g>
  </Svg>
);

export const IdeoLogo = () => (
  <Svg viewBox="0 0 283 65">
    <path d="M104.5 2.6h-29v59.6H104c18.5-.2 31.2-13.2 31.2-30 0-16.4-12.5-29-30.7-29.6zM104 52H86V13h18.2c11.7.2 19.4 8.4 19.4 19.5 0 11.2-7.8 19.3-19.6 19.5zM59.6 13V2.7H0V13h24.5v39H0v10.5h59.6V51.8H35.2V13zm148.8 0V2.7h-60.2v59.7h60.2V51.8H159v-14h38.5V27H159V13zm42.3-13c-18 0-32.8 14.5-32.8 32.4s14.4 32.4 32.5 32.4c18 0 32.8-14.5 32.8-32.4S268.8 0 250.7 0zm0 53.7c-11.8 0-21.5-9.5-21.5-21.2s9.6-21.2 21.5-21.2c11.8 0 21.5 9.5 21.5 21.2s-9.7 21.2-21.5 21.2z" />
  </Svg>
);

export const HuffpostLogo = () => (
  <Svg viewBox="0 0 513.5 80">
    <path
      fill="#FFF"
      d="M71.6 68h18.2l10-56H81.3L78 32H62l3.6-20H47.3l-9.8 56h18.2l3.7-21h15.8l-3.6 21zM110 12l-5.5 31.2c-.5 2.5-.7 4.8-.7 7 0 16.6 14.5 19 23 19 18.3 0 26-6 29-22.3l6-35h-18.2l-5.2 29c-1.7 9-2.8 14-9.7 14-4.4 0-6.6-2.7-6.6-7.5 0-2 .8-4 1-7l5.6-29h-18zm148.5 56h18.3l2.6-14.4h8.6c16 0 24.7-8.6 24.7-24.3 0-11-7.7-17.3-21-17.3h-23.3l-10 56zM287 39.8h-5.4l2.4-13.2h5c4 0 6 2 6 5.7.2 4.6-3 7.5-8 7.5zm61-29c-19.8 0-31.7 13-31.7 34.4 0 15 9.5 24 25.3 24 20 0 31.8-13 31.8-34.4 0-15-9.4-24-25.3-24zm-5.2 44c-4.7 0-7.5-3.5-7.5-9.2 0-2.2.2-4 .6-6.2 1-7.3 3.2-14 11-14 4.4 0 7.2 3.3 7.2 9 0 2.2-.2 4-.6 6.2-1.6 7.3-4 14-11.3 14zM437 68h18l7.3-41H476l2.7-15H432l-2.6 15H444l-7 41zm-30.3-35.3c-5.8-1.8-8-2.6-8-5.3 0-1.8 1-4 4.5-4 2.6 0 4.7 1.6 5.6 3.7l16-4c-1.8-8-8.6-12-20.3-12-22 0-23.8 15-23.8 19.5 0 9.3 5 15 15.4 17.8 3 .8 6 1.7 6 4.8 0 2.6-1.3 4-4.4 4-3 0-6-1.7-7-4.6l-16 4.4c2 8.4 9.7 13.2 22 13.2 9.4 0 25-2.6 25-19.5 0-8.4-4.7-14-14.5-17zM27.4 68l9.8-56H7v56h20.4zm459.2-56l-9.8 56H507V12h-20.4zm-314.2 0l-9.8 56h18.2l3-16.5H199l2.6-14h-15.3L188 27h21.4l2.7-15m8.6 0l-9.8 56H229l3-16.5h15l2.5-14h-15.3L236 27h21.4l2.6-15"
    />
  </Svg>
);

export const CoinbaseLogo = () => (
  <Svg viewBox="0 0 122 28">
    <path
      fillRule="evenodd"
      d="M10.3 24c1 0 1.8-.3 2.7-.6l1.7 2.6c-1.6.8-3 1.2-5 1.2-5 0-8.7-3.4-8.7-8.8s4-8.8 8.8-8.8c1.8 0 3.2.4 4.6 1l-1.6 2.8c-1-.3-1.7-.4-2.6-.4-3 0-5.4 2-5.4 5.4 0 3.4 2.3 5.5 5.5 5.5zm13-14.4c5 0 8.7 3.6 8.7 8.8 0 5.2-3.7 8.8-8.7 8.8-5 0-8.7-3.6-8.7-8.8 0-5.2 3.7-8.8 8.7-8.8zm0 3.2c-2.8 0-5 2.2-5 5.6 0 3.4 2.2 5.6 5 5.6 3 0 5-2.2 5-5.6 0-3.4-2-5.6-5-5.6zm11 14V10h3.8v16.8h-3.6zm-.4-22c0-1.3 1-2.3 2.2-2.3 1.3 0 2.4 1 2.4 2.3 0 1.4-1 2.4-2.4 2.4-1.2 0-2.3-1-2.3-2.4zm7.4 6.3c2.3-1 5.2-1.4 7.7-1.4 4.4 0 7 1.6 7 6.4v10.8h-3.6V16.3c0-2.4-1.5-3.3-3.6-3.3-1.3 0-2.7.2-3.7.5v13.3h-3.6V11zm18-10H63v9.5c.8-.5 2.4-1 4-1 4.7 0 8.4 3.2 8.4 8.6 0 5.5-3.7 9.2-10 9.2-2.3 0-4.4-.5-6-1V1zM63 23.6c.7.3 1.7.4 2.6.4 3.5 0 6-2 6-5.8 0-3.3-2.4-5.2-5.2-5.2-1.5 0-2.6.4-3.4.8v9.8zm23.2-8c0-2-1.4-2.7-3.2-2.7-2 0-3.5.5-5 1.2V11c1.6-1 3.5-1.4 5.6-1.4 3.7 0 6.3 1.5 6.3 5.7v11.2c-1.7.4-4 .7-6 .7-4.2 0-7.4-1.4-7.4-5.2 0-3.4 3-5 7.8-5h1.8v-1.5zm0 3.8h-1.6c-2.6 0-4.3.8-4.3 2.5s1.6 2.3 4 2.3h2v-5zm6.4 3c1.6 1 3.4 1.8 5 1.8 1.8 0 3-.6 3-2 0-1.3-1-1.8-3.2-2.4-3.5-.8-5-2.2-5-5 0-3.5 2.6-5.2 6-5.2 2 0 3.4.4 4.8 1.3v3.4c-1.5-1-3-1.7-4.7-1.7-1.6 0-2.5.8-2.5 2 0 1 .7 1.5 2.7 2 3.8 1 5.5 2.3 5.5 5.4 0 3.6-2.7 5.2-6.4 5.2-2 0-4-.5-5.2-1.4v-3.5zm16.7-3c.2 3 2.8 4.6 5.4 4.6 2.4 0 4-.6 5.7-1.7v3.3c-1.5 1-3.8 1.6-6 1.6-5.2 0-8.7-3.3-8.7-8.7 0-5.3 3.5-9 8-9 5 0 7.3 3.3 7.3 8v1.8h-11.7zm8.2-2.6c0-2.6-1.4-4-3.8-4-2.2 0-3.8 1.5-4.3 4h8z"
    />
  </Svg>
);

export const CoinMarketCapLogo = () => (
  <Svg viewBox="0 0 239 41">
    <g fill="#17181B" fillRule="evenodd">
      <path d="M35.124 24.5c-.715.452-1.557.508-2.197.147-.813-.459-1.26-1.534-1.26-3.029v-4.473c0-2.16-.854-3.697-2.282-4.112-2.42-.705-4.24 2.256-4.924 3.368l-4.268 6.92v-8.458c-.048-1.946-.68-3.11-1.88-3.461-.794-.232-1.982-.139-3.136 1.627L5.615 28.383A16.869 16.869 0 0 1 3.671 20.5c0-9.249 7.412-16.773 16.522-16.773S36.714 11.251 36.714 20.5c0 .016.004.03.005.045 0 .016-.003.03-.002.046.086 1.791-.494 3.216-1.593 3.91zm5.261-3.999V20.5v-.046l-.001-.046C40.333 9.144 31.296 0 20.192 0 9.059 0 0 9.196 0 20.5 0 31.803 9.059 41 20.193 41c5.109 0 9.985-1.942 13.728-5.467.744-.7.788-1.879.098-2.633a1.817 1.817 0 0 0-2.594-.1 16.331 16.331 0 0 1-11.232 4.473c-4.878 0-9.267-2.159-12.294-5.583l8.623-13.846v6.383c0 3.066 1.189 4.057 2.186 4.347.998.29 2.523.092 4.124-2.508l4.743-7.689c.152-.248.292-.462.42-.647v3.888c0 2.866 1.148 5.158 3.149 6.287 1.804 1.018 4.072.926 5.92-.24 2.24-1.415 3.447-4.022 3.321-7.164zM68.498 13.497c.485.295.905.951.905 1.542 0 .951-.808 1.738-1.713 1.738-.226 0-.452-.065-.646-.131-1.067-.787-2.424-1.312-3.846-1.312-3.36 0-5.687 2.755-5.687 6.166 0 3.412 2.327 6.134 5.687 6.134 1.68 0 3.167-.689 4.298-1.738a1.745 1.745 0 0 1 1.002-.328c.905 0 1.616.721 1.616 1.64 0 .59-.356 1.115-.808 1.41-1.616 1.378-3.813 2.296-6.075 2.296-5.17 0-9.372-4.264-9.372-9.512s4.201-9.512 9.372-9.512c1.939 0 3.78.59 5.267 1.607zm9.454 3.969c3.522 0 6.495 2.985 6.495 6.658 0 3.674-2.973 6.79-6.495 6.79-3.684 0-6.754-3.116-6.754-6.79 0-3.673 3.07-6.658 6.754-6.658zm-.033 10.168c1.552 0 2.876-1.476 2.876-3.477 0-2-1.324-3.247-2.876-3.247-1.68 0-3.07 1.214-3.07 3.247 0 2.001 1.39 3.477 3.07 3.477zm8.743 1.246V19.5c0-1.017.808-1.87 1.81-1.87s1.842.853 1.842 1.87v9.38c0 1.017-.84 1.87-1.842 1.87-1.002 0-1.81-.853-1.81-1.87zm-.29-14.792c0-1.214.936-2.198 2.1-2.198 1.195 0 2.165.984 2.165 2.198 0 1.18-.97 2.132-2.165 2.132-1.164 0-2.1-.952-2.1-2.132zm10.94 9.708v5.084c0 1.017-.84 1.87-1.843 1.87-1.001 0-1.81-.853-1.81-1.87v-9.807c0-.787.647-1.443 1.423-1.443.775 0 1.39.656 1.39 1.443 1.486-1.377 2.778-1.607 4.006-1.607 3.652 0 5.268 2.755 5.268 5.871v5.543c0 1.017-.84 1.87-1.842 1.87-1.002 0-1.81-.853-1.81-1.87v-5.084c0-1.607-.194-2.952-2.488-2.952-1.616 0-2.295 1.345-2.295 2.952zm20.311 1.936c-.42 0-.71-.197-.937-.46l-4.266-4.624v8.232c0 1.017-.84 1.87-1.842 1.87-1.002 0-1.81-.853-1.81-1.87V12.58a.714.714 0 0 1 .68-.46c.322 0 .58.263.775.46l6.786 7.642c.194.23.452.361.582.361.129 0 .387-.131.581-.36l6.787-7.643c.194-.197.452-.46.775-.46s.582.197.679.46V28.88c0 1.017-.808 1.87-1.81 1.87s-1.842-.853-1.842-1.87v-8.232l-4.265 4.624c-.227.263-.518.46-.873.46zm17.565 1.902c1.648 0 3.037-1.476 3.037-3.477 0-2-1.421-3.313-3.037-3.313-1.616 0-2.909 1.345-2.909 3.313 0 1.935 1.293 3.477 2.909 3.477zm3.878 1.673L139 28.88c-.71 1.41-2.973 2.034-4.427 2.034-3.426 0-5.946-3.116-5.946-6.79 0-3.673 2.585-6.658 6.14-6.658.614 0 2.65.164 4.233 2.034l.065-.427c0-.787.614-1.443 1.39-1.443.775 0 1.421.656 1.421 1.443v10.234c0 .787-.646 1.443-1.422 1.443-.775 0-1.39-.656-1.39-1.443zm12.943-8.463h-.387c-2.295.132-2.747 1.444-2.747 2.952v5.084c0 1.017-.84 1.87-1.842 1.87-1.002 0-1.81-.853-1.81-1.87v-9.807c0-.787.646-1.443 1.422-1.443.776 0 1.39.656 1.39 1.443 1.357-1.279 2.456-1.541 3.587-1.607h.355c.873 0 1.68.754 1.68 1.706 0 .885-.775 1.672-1.648 1.672zm14.075 7.184c.162.262.259.557.259.885 0 .951-.873 1.837-1.81 1.837-.646 0-1.196-.492-1.616-1.017l-4.2-4.887v4.034c0 1.017-.841 1.87-1.843 1.87s-1.81-.853-1.81-1.87V13.99c0-1.018.808-1.87 1.81-1.87s1.842.852 1.842 1.87v9.282l4.201-4.658c.42-.492.937-.984 1.584-.984.905 0 1.745.853 1.745 1.804 0 .295-.065.59-.227.853l-3.328 3.64 3.393 4.1zm7.16-7.118c-1.002 0-2.618.525-2.618 2.066h5.267c0-1.574-1.68-2.066-2.65-2.066zm4.782 4.395h-7.4c0 2.198 2.1 2.526 3.037 2.526.68 0 1.649-.131 2.392-.46.226-.163.614-.295.937-.295.808 0 1.486.69 1.486 1.51 0 .557-.355 1.049-.807 1.311-1.131.82-2.586 1.017-3.975 1.017-3.684 0-6.754-2-6.754-6.626 0-3.64 1.874-6.822 6.237-6.822 3.522 0 6.204 2.296 6.269 6.396 0 .787-.646 1.443-1.422 1.443zm10.165 5.609h-1.002c-2.78 0-4.395-1.214-4.395-5.576v-4.494h-.937c-.873 0-1.648-.787-1.648-1.672 0-.952.775-1.706 1.648-1.706h.937v-3.477c0-1.017.808-1.87 1.81-1.87 1.001 0 1.842.853 1.842 1.87v3.477h1.518c.873 0 1.649.754 1.649 1.706 0 .885-.776 1.672-1.649 1.672h-1.518v3.772c0 2.493.129 3.018 1.228 3.018h.517c.872 0 1.615.722 1.615 1.64 0 .886-.743 1.64-1.615 1.64zm17.694-17.417c.484.295.905.951.905 1.542 0 .951-.808 1.738-1.713 1.738-.226 0-.453-.065-.646-.131-1.067-.787-2.424-1.312-3.846-1.312-3.36 0-5.688 2.755-5.688 6.166 0 3.412 2.327 6.134 5.688 6.134 1.68 0 3.167-.689 4.298-1.738a1.745 1.745 0 0 1 1.002-.328c.905 0 1.615.721 1.615 1.64 0 .59-.355 1.115-.807 1.41-1.616 1.378-3.814 2.296-6.076 2.296-5.17 0-9.371-4.264-9.371-9.512s4.2-9.512 9.371-9.512c1.94 0 3.781.59 5.268 1.607zm9.26 14.137c1.648 0 3.037-1.476 3.037-3.477 0-2-1.422-3.313-3.038-3.313-1.615 0-2.908 1.345-2.908 3.313 0 1.935 1.293 3.477 2.908 3.477zm3.877 1.673l-.064-.427c-.711 1.41-2.973 2.034-4.428 2.034-3.425 0-5.946-3.116-5.946-6.79 0-3.673 2.586-6.658 6.14-6.658.614 0 2.65.164 4.234 2.034l.064-.427c0-.787.614-1.443 1.39-1.443.775 0 1.422.656 1.422 1.443v10.234c0 .787-.647 1.443-1.422 1.443-.776 0-1.39-.656-1.39-1.443zm12.847-1.673c1.616 0 2.908-1.542 2.908-3.477 0-1.968-1.292-3.313-2.908-3.313-1.616 0-3.038 1.312-3.038 3.313 0 2.001 1.39 3.477 3.038 3.477zm-3.038 2.198v4.657c0 1.017-.84 1.87-1.842 1.87-1.001 0-1.81-.853-1.81-1.87V19.073c0-.787.647-1.443 1.423-1.443.775 0 1.39.656 1.39 1.574 1.356-1.41 3.037-1.738 4.297-1.738 3.555 0 6.14 2.985 6.14 6.658 0 3.674-2.52 6.79-5.946 6.79-1.066 0-2.65-.328-3.652-1.082z" />
    </g>
  </Svg>
);

export const PatreonLogo = () => (
  <Svg viewBox="0 20 305 60">
    <path
      fill="#FFF"
      fillRule="evenodd"
      d="M284 104V0h8v104h-8zm-42-69h7v33h-7l-12-22v22h-8V35h8l12 21V35zm-50-1c11 0 17 8 17 17s-6 17-17 17-18-8-18-17 7-17 18-17zm10 17c0-5-4-10-10-10s-10 5-10 10c0 6 4 11 10 11s10-5 10-11zM69 41v-6h22v6h-7v27h-8V41h-7zm81 7h12v6h-12v8h12v6h-20V35h20v6h-12v7zm-33-13c7 0 12 5 12 12 0 4-2 8-7 10l7 11h-9l-6-9h-3v9h-8V35h14zm4 12c0-3-2-6-5-6h-5v11h5c3 0 5-2 5-5zM54 64H42l-1 4h-8l11-33h7l12 33h-8l-1-4zm-6-20l-4 14h8l-4-14zm-34-9c7 0 12 5 12 12 0 6-5 12-12 12H8v9H0V35h14zm4 12c0-3-2-6-5-6H8v11h5c3 0 5-2 5-5z"
    />
  </Svg>
);

export const Auth0Logo = () => (
  <Svg viewBox="0 0 600 216.56">
    <path
      fill="#FFF"
      fillRule="evenodd"
      d="M297.82 119.34h-26.17a.61.61 0 0 1-.49-.24.6.6 0 0 1-.1-.53l13.08-45.11a.61.61 0 0 1 1.18 0l13.08 45.11a.6.6 0 0 1-.1.53.61.61 0 0 1-.48.24zM310 158.41h17L301.08 69a17.06 17.06 0 0 0-32.69 0l-25.93 89.42h17.05l7.49-25.89a.61.61 0 0 1 .59-.44h34.26a.61.61 0 0 1 .59.44zm95.82-51.35h10a.61.61 0 0 1 .61.61v35.27a16.93 16.93 0 0 0 17 16.81 35 35 0 0 0 10-1.44v-11.59c-1.88.16-4 .27-5.57.27a5 5 0 0 1-5-5v-34.33a.61.61 0 0 1 .61-.61h10V94.31h-10a.61.61 0 0 1-.61-.61V72.53h-16.49V93.7a.61.61 0 0 1-.61.61h-10zm94.53 51.35h16.35v-44.27A21.31 21.31 0 0 0 495.29 93a35.79 35.79 0 0 0-19 5.89.62.62 0 0 1-.63 0 .61.61 0 0 1-.32-.53V58.14h-16.43v100.27h16.39v-47.93a.6.6 0 0 1 .33-.54c3.08-1.57 9.16-4.21 15.25-4.21a9.41 9.41 0 0 1 6.66 2.73 9.2 9.2 0 0 1 2.76 6.54v43.37zm-164.18-64.1v44.27a21.31 21.31 0 0 0 21.41 21.17 35.77 35.77 0 0 0 20.94-7.22.62.62 0 0 1 .56-.1.61.61 0 0 1 .4.4l1.73 5.59H394V94.31h-16.43v47.94a.61.61 0 0 1-.33.54c-3.08 1.57-9.16 4.21-15.25 4.21a9.38 9.38 0 0 1-9.42-9.31V94.31zM564.61 147c-5 0-9-2.82-12.17-8.62-3.81-7-5.91-17.69-5.91-30.09s2.1-23.09 5.91-30.09c3.15-5.8 7.13-8.62 12.17-8.62s9 2.82 12.17 8.62c3.81 7 5.91 17.69 5.91 30.09s-2.1 23.09-5.91 30.09c-3.15 5.79-7.13 8.62-12.17 8.62zm0-90.18c-10.54 0-19.46 4.91-25.78 14.2s-9.61 22.12-9.61 37.27 3.32 28 9.61 37.27 15.24 14.2 25.78 14.2 19.46-4.91 25.78-14.2 9.61-22.14 9.61-37.28-3.32-28-9.61-37.27-15.24-14.2-25.78-14.2z"
    />
    <path
      fill="#FFF"
      d="M189 66.92L167.22 0H96.85l21.75 66.92zM96.85 0H26.49L4.75 66.92h70.36zM4.75 66.92zm0 0A96.85 96.85 0 0 0 39.93 175.2l21.74-66.92zm184.21 0L132 108.28l21.74 66.92A96.85 96.85 0 0 0 189 66.92zM39.93 175.2l56.93 41.36 56.92-41.36-56.93-41.36z"
    />
  </Svg>
);

export const BBCLogo = () => (
  <Svg viewBox="0 0 80 45.71">
    <g fill="#FFF">
      <path d="M42.56 10.78c0 .4-.13.8-.48 1.1-.35.31-.96.55-1.98.55h-2.03V9.16H40c.91 0 1.55.19 1.96.48.4.28.58.66.59 1.14M40.9 6.87c.39-.28.57-.66.57-1.24 0-.4-.11-.74-.4-1-.29-.25-.78-.43-1.56-.43h-1.44v3.1h.98c.86 0 1.47-.16 1.86-.43" />
      <path d="M44.75 11.02c0-1.51-1-2.66-2.6-3.1.43-.22.77-.5 1.02-.82.34-.45.5-1 .5-1.63 0-.77-.3-1.57-.96-2.16a4.38 4.38 0 0 0-3.02-.98h-3.77V14.3h4.42c1.58 0 2.68-.43 3.4-1.06a2.95 2.95 0 0 0 1.01-2.22m4.2 5.6H31.29V0h17.66zM20.56 6.87c.37-.28.56-.66.56-1.24 0-.4-.12-.74-.4-1-.29-.25-.78-.43-1.56-.43h-1.44v3.1h.98c.86 0 1.47-.16 1.86-.43M21.62 9.64a3.39 3.39 0 0 0-1.96-.48h-1.94v3.27h2.03c1.01 0 1.62-.24 1.98-.55.35-.3.47-.7.48-1.1 0-.48-.19-.86-.6-1.14" />
      <path d="M24.4 11.02c0-1.51-1-2.66-2.6-3.1.43-.22.77-.5 1.02-.82.34-.45.5-1 .5-1.63 0-.77-.3-1.57-.96-2.16a4.38 4.38 0 0 0-3.02-.98h-3.77V14.3H20c1.58 0 2.68-.43 3.4-1.06a2.95 2.95 0 0 0 1.01-2.22m4.2 5.6H10.94V0H28.6zM65.8 11.1l-.29.17a8.24 8.24 0 0 1-4.2 1.28c-2.9 0-4.8-1.72-4.81-4.22 0-2.44 2-4.24 4.73-4.25 1.4 0 2.66.36 4.16 1.18l.28.16V3.19l-.12-.05c-1.7-.67-3-.96-4.3-.96-2 0-3.74.66-4.98 1.78a5.86 5.86 0 0 0-.33 8.46 6.92 6.92 0 0 0 5.2 2.04c1.97 0 3.32-.44 4.55-1.04l.1-.06zm3.5 5.52H51.64V0H69.3z" />
      <path d="M15.51 25.86h2.67v19.62h-2.42L2.64 30.37v15.11H0V25.86h2.28L15.5 41.1zM23.24 25.86h11.13v2.5h-8.32v5.98h8.04v2.52h-8.04v6.1h8.59v2.5h-11.4zM64.36 25.86h2.8l-7.94 19.71h-.61l-6.42-15.96-6.48 15.96h-.6l-7.92-19.71h2.83l5.41 13.53 5.45-13.53h2.65L59 39.39zM74.77 37.26l-2.13-1.3a9.7 9.7 0 0 1-2.86-2.41c-.57-.8-.85-1.7-.85-2.73 0-1.55.54-2.8 1.6-3.77a6 6 0 0 1 4.19-1.45c1.64 0 3.14.47 4.5 1.39v3.18a6.5 6.5 0 0 0-4.56-2.04c-.92 0-1.67.22-2.26.64-.59.43-.89.97-.89 1.63 0 .59.22 1.14.66 1.65a8.17 8.17 0 0 0 2.1 1.62l2.14 1.27c2.4 1.43 3.59 3.25 3.59 5.46a5 5 0 0 1-1.58 3.83 5.78 5.78 0 0 1-4.11 1.48c-1.94 0-3.7-.6-5.3-1.79v-3.57c1.52 1.93 3.28 2.89 5.27 2.89a3.3 3.3 0 0 0 2.2-.74c.59-.49.88-1.1.88-1.84 0-1.2-.86-2.33-2.59-3.4" />
    </g>
  </Svg>
);

export const CasperLogo = () => (
  <Svg viewBox="0 0 96 30.4">
    <path d="M30 6.4c-4.6 0-8.1 3.3-8.1 8s3.5 8 8.1 8c2.2 0 3.9-1 4.6-1.8v1.6h3.6V6.6h-3.6v1.6c-.7-.8-2.5-1.8-4.6-1.8m.1 12.7c-2.7 0-4.7-2.1-4.7-4.7s2.1-4.7 4.7-4.7 4.6 2.1 4.6 4.7-2 4.7-4.6 4.7M61 6.4c-2.1 0-3.7.8-4.7 1.8V6.6h-3.5v23.8l3.5-.4v-9.5c1 1.1 2.7 1.8 4.7 1.8 4.8 0 8-3.1 8-8 0-4.8-3.2-7.9-8-7.9m-.1 12.7c-2.8 0-4.6-2-4.6-4.7s1.8-4.7 4.6-4.7 4.7 2 4.7 4.7c-.1 2.7-1.9 4.7-4.7 4.7M96 6.4c-2.2 0-3.4.8-4.1 1.8V6.6h-3.5v15.6h3.5v-8.6c0-2.3 1.6-3.9 3.8-3.9h.3V6.4zm-17.6 0c-4.6 0-8.2 3.6-8.2 8s3.6 8 8.2 8c3.8 0 6.9-2.1 7.9-4.9h-4.2c-.5 1-1.8 1.7-3.7 1.7-2.3 0-4.1-1.6-4.5-3.6h12.5c.1-.4.1-.8.1-1.2 0-4.4-3.6-8-8.1-8m-4.3 6.1c.5-1.6 2.2-2.9 4.3-2.9 2 0 3.8 1.3 4.3 2.9h-8.6zm-28.4-3c-.7 0-1.5.3-1.5 1.2 0 1 1 1.3 2.9 2 2.6 1 3.9 2.2 3.9 4.6 0 2.5-2.1 5.1-5.7 5.1s-5.5-2.7-5.6-4.9h3.4c.2 1 1 1.8 2.2 1.8 1.3 0 2.1-.9 2.1-1.9 0-.7-.3-1.5-2.5-2.1-2.4-.6-4.1-1.9-4.1-4.5 0-2.4 2.1-4.3 4.8-4.3 2.4 0 3.9 1.7 4.6 2.8l-2.9 1.3c-.4-.8-1-1.1-1.6-1.1" />
    <path d="M11.3 0C4.9 0 0 5 0 11.2c0 6.2 4.9 11.2 11.3 11.2 4.1 0 7.9-2.2 9.6-5.3l-3.3-1.8a6.91 6.91 0 0 1-6.3 3.6c-2 0-4-.8-5.3-2.2a7.9 7.9 0 0 1-2.2-5.4c0-2 .8-3.9 2.2-5.4 1.3-1.4 3.2-2.2 5.3-2.2 2.2 0 3.5.7 4.4 1.4 1 .7 2 1.4 3.7 1.4 3.1 0 4.5-2.5 4.8-3.8L20.7 2c0 .1-.3 1.1-1.3 1.1-.5 0-.8-.2-1.5-.7-1.3-1.2-3-2.4-6.6-2.4" />
  </Svg>
);

export const MoleskineLogo = () => (
  <Svg viewBox="0 0 507 44">
    <path d="M9.945 1.53L6.885 7.36h-.073L3.752 1.53C3.497 1.056 3.024.73 2.477.73H0v.546c.328 0 .656.146.656.474v8.27c0 .4-.255.546-.656.546v.546h3.534v-.546c-.547 0-.875-.146-.875-.547v-6.01h.146l3.862 7.14h.328l3.934-7.14h.146v6.01c0 .4-.328.547-.875.547v.546h3.68v-.546c-.328 0-.656-.146-.656-.547v-8.27c0-.4.255-.473.656-.473V.729h-2.477c-.729 0-1.24.327-1.458.801M29.909 9.29c0 1.348-1.13 2.55-2.55 2.55h-6.74c-1.348 0-2.55-1.13-2.55-2.55V2.55C18.07 1.202 19.2 0 20.62 0h6.703c1.348 0 2.55 1.13 2.55 2.55v6.74M29.909 25.392c0 1.348-1.13 2.55-2.55 2.55h-6.74c-1.348 0-2.55-1.13-2.55-2.55v-6.813c0-1.348 1.13-2.55 2.55-2.55h6.703c1.348 0 2.55 1.13 2.55 2.55v6.813M46.557 9.29c0 1.348-1.129 2.55-2.55 2.55h-6.74c-1.347 0-2.55-1.13-2.55-2.55V2.55c0-1.348 1.13-2.55 2.55-2.55h6.74c1.348 0 2.55 1.13 2.55 2.55v6.74M13.151 25.392c0 1.348-1.13 2.55-2.55 2.55h-6.74c-1.347 0-2.55-1.13-2.55-2.55v-6.813c0-1.348 1.13-2.55 2.55-2.55h6.704c1.348 0 2.55 1.13 2.55 2.55l.036 6.813M46.557 25.392c0 1.348-1.129 2.55-2.55 2.55h-6.74c-1.347 0-2.55-1.13-2.55-2.55v-6.813c0-1.348 1.13-2.55 2.55-2.55h6.74c1.348 0 2.55 1.13 2.55 2.55v6.813M46.557 41.42c0 1.349-1.129 2.55-2.55 2.55h-6.74c-1.347 0-2.55-1.128-2.55-2.55v-6.739c0-1.348 1.13-2.55 2.55-2.55h6.74c1.348 0 2.55 1.13 2.55 2.55v6.74M29.909 41.42c0 1.349-1.13 2.55-2.55 2.55h-6.74c-1.348 0-2.55-1.128-2.55-2.55v-6.739c0-1.348 1.13-2.55 2.55-2.55h6.703c1.348 0 2.55 1.13 2.55 2.55v6.74M13.151 41.42c0 1.349-1.13 2.55-2.55 2.55h-6.74c-1.347 0-2.55-1.128-2.55-2.55v-6.739c0-1.348 1.13-2.55 2.55-2.55h6.704c1.348 0 2.55 1.13 2.55 2.55l.036 6.74" />
    <path d="M113.307.597v2.388c-1.344 0-2.687.597-2.687 1.94v33.881c0 1.642 1.045 2.239 2.687 2.239v2.239H98.232v-2.24c2.239 0 3.582-.596 3.582-2.238V14.478h-.597l-16.12 28.806h-1.343L68.381 14.179h-.597v24.627c0 1.642 1.045 2.239 3.582 2.239v2.239H56.89v-2.24c1.343 0 2.686-.596 2.686-2.238V4.926c0-1.642-1.044-1.94-2.686-1.94V.745h10.149c2.239 0 4.328 1.344 5.224 3.284l12.537 24.03h.299L97.934 4.03c1.044-1.94 2.985-3.284 5.223-3.284l10.15-.149M130.023 21.94c0 9.851 7.612 14.18 16.717 14.18 8.805 0 16.716-4.329 16.716-14.18 0-9.85-7.612-14.179-16.716-14.179-9.105.15-16.717 4.329-16.717 14.18m42.687 0c0 15.82-13.135 21.94-25.97 21.94s-25.97-6.27-25.97-21.94C120.77 6.118 133.903 0 146.74 0s25.97 6.269 25.97 21.94M188.53.597c1.94 0 3.284 1.642 3.284 3.284v31.94h22.687c2.686 0 4.627-1.343 4.627-3.284h2.238v10.896h-41.343v-2.239c1.343 0 2.687-.597 2.687-2.239V4.925c0-1.641-1.045-1.94-2.687-1.94V.746l8.508-.149M261.366 24.925h-21.641v10.896h24.03c3.582 0 4.925-1.045 4.925-2.985h2.239v10.448h-42.985v-2.24c1.343 0 2.686-.596 2.686-2.238V4.926c0-1.642-1.045-1.94-2.686-1.94V.745h42.686v9.702h-2.239c0-1.94-1.343-2.985-4.925-2.985h-23.582v10.149h21.642l-.15 7.313M298.83 36.418c3.581 0 13.133-.299 13.133-5.224s-5.522-4.328-11.194-4.925l-4.626-.597c-8.806-1.344-17.463-2.24-17.463-11.791 0-7.91 6.268-13.732 19.701-13.732 11.791 0 21.344 5.523 21.344 5.523l-4.926 9.253-1.94-.597c0-1.343 0-2.238-1.343-3.283-3.284-2.687-10.896-3.582-13.135-3.582-6.268 0-10.895 1.94-10.895 5.224 0 2.985 2.239 3.88 5.97 4.328l7.612 1.045c9.254 1.343 19.403 1.641 19.403 12.09 0 11.79-12.836 14.178-22.388 14.178-13.135 0-20.746-5.522-20.746-5.522l3.283-8.507 1.642.597c0 1.343.298 2.238 1.94 3.283 4.18.896 11.045 2.239 14.627 2.239M340.62 22.388L363.904.746h10.895v2.24c-1.642 0-2.686.596-4.328 1.94l-14.776 13.432 12.836 16.418c3.283 4.328 3.88 5.224 7.164 6.269v2.239h-8.21c-2.686 0-4.626-1.344-5.97-3.284l-12.387-15.672-8.806 8.21v6.268c0 1.642 1.044 2.239 3.582 2.239v2.239H328.53v-2.24c1.343 0 2.686-.596 2.686-2.238V4.926c0-1.642-1.045-1.94-2.686-1.94V.745h8.507c1.94 0 3.284 1.642 3.284 3.284v18.358M394.053 38.806c0 1.642 1.045 2.239 2.687 2.239v2.239h-14.478v-2.24c1.343 0 2.686-.596 2.686-2.238V4.926c0-1.642-1.343-1.94-2.686-1.94V.745h8.507c1.94 0 3.284 1.642 3.284 3.284v34.776M416.143 13.433v25.373c0 1.642 1.044 2.239 3.582 2.239v2.239h-14.777v-2.24c1.642 0 2.687-.596 2.687-2.238V4.926c0-1.642-1.045-1.94-2.687-1.94V.745h7.165c3.283 0 5.522 1.344 7.612 3.284l24.626 25.224V5.224c0-1.642-1.044-2.239-3.582-2.239V.746h14.776v2.24c-1.641 0-2.686.596-2.686 1.94v33.88c0 1.642 1.045 2.239 2.686 2.239v2.239h-6.268c-3.284 0-5.523-1.344-7.612-3.284l-25.522-26.567M497.486 24.925h-21.642v10.896h24.03c3.582 0 4.925-1.045 4.925-2.985h2.239v10.448h-43.284v-2.24c1.344 0 2.687-.596 2.687-2.238V4.926c0-1.642-1.045-1.94-2.687-1.94V.745h42.687v9.702h-2.239c0-1.94-1.343-2.985-4.925-2.985h-23.284v10.149h21.642v7.313" />
  </Svg>
);

export const AirBnBLogo = () => (
  <Svg viewBox="0 0 486.667 151.88">
    <path
      fill="#FFF"
      d="M131.216 122.994c-1.064 7.905-6.385 14.747-13.835 17.788-3.649 1.52-7.601 1.975-11.554 1.52-3.801-.457-7.602-1.673-11.555-3.953-5.473-3.04-10.946-7.754-17.331-14.747 10.034-12.315 16.115-23.565 18.395-33.6 1.065-4.712 1.217-8.969.76-12.922-.607-3.8-1.976-7.297-4.104-10.338C87.28 59.9 79.373 55.948 70.556 55.948c-8.819 0-16.724 4.104-21.437 10.794-2.128 3.04-3.497 6.537-4.105 10.338-.608 3.953-.456 8.362.76 12.923 2.28 10.034 8.514 21.436 18.396 33.751-6.233 6.994-11.859 11.706-17.331 14.747-3.953 2.28-7.754 3.496-11.555 3.952a24.324 24.324 0 0 1-11.554-1.52c-7.45-3.04-12.771-9.882-13.835-17.787-.456-3.8-.152-7.602 1.368-11.859.456-1.52 1.216-3.04 1.977-4.865 1.064-2.432 2.28-5.017 3.496-7.601l.152-.305c10.49-22.652 21.74-45.761 33.447-68.261l.456-.913c1.217-2.28 2.433-4.713 3.65-6.993 1.215-2.433 2.584-4.713 4.256-6.69 3.193-3.648 7.45-5.624 12.162-5.624 4.713 0 8.97 1.976 12.163 5.624 1.672 1.977 3.04 4.257 4.257 6.69 1.216 2.28 2.432 4.713 3.649 6.993l.456.913a2017.108 2017.108 0 0 1 33.295 68.414v.152c1.216 2.432 2.28 5.169 3.496 7.601.761 1.825 1.52 3.345 1.977 4.865 1.216 3.953 1.673 7.754 1.064 11.707zm-60.66-7.146C62.346 105.51 57.025 95.78 55.2 87.571c-.76-3.497-.913-6.538-.457-9.275.304-2.432 1.216-4.56 2.433-6.385 2.888-4.105 7.753-6.69 13.379-6.69 5.625 0 10.642 2.433 13.378 6.69 1.217 1.824 2.129 3.953 2.433 6.385.456 2.737.304 5.93-.457 9.275-1.824 8.057-7.145 17.787-15.354 28.277zm68.565-7.905c-.76-1.825-1.52-3.801-2.28-5.473-1.216-2.737-2.432-5.322-3.497-7.754l-.151-.152c-10.49-22.805-21.74-45.914-33.6-68.718l-.456-.913c-1.216-2.28-2.432-4.713-3.648-7.145-1.52-2.736-3.041-5.625-5.473-8.363C85.15 3.344 78.157 0 70.707 0c-7.601 0-14.442 3.344-19.46 9.121-2.28 2.738-3.952 5.626-5.472 8.363-1.217 2.432-2.433 4.865-3.65 7.145l-.456.912C29.963 48.346 18.56 71.455 8.07 94.26l-.152.304c-1.064 2.432-2.28 5.017-3.497 7.753-.76 1.673-1.52 3.497-2.28 5.473-1.976 5.626-2.584 10.947-1.824 16.42 1.672 11.402 9.274 20.98 19.764 25.238 3.953 1.672 8.058 2.432 12.314 2.432 1.217 0 2.737-.152 3.953-.304 5.017-.608 10.186-2.281 15.204-5.17 6.233-3.497 12.162-8.512 18.852-15.81 6.689 7.298 12.77 12.313 18.851 15.81 5.017 2.889 10.187 4.562 15.203 5.17 1.217.152 2.737.304 3.953.304 4.257 0 8.514-.76 12.315-2.432 10.642-4.258 18.091-13.988 19.765-25.238 1.216-5.321.608-10.642-1.37-16.267zm151.576-53.516c4.41 0 6.69.76 6.69.76V68.72s-12.163-4.106-19.764 4.56v39.985h-14.595V55.948h12.315c1.216 0 2.128 1.064 2.128 2.128v2.433c2.737-3.193 8.665-6.082 13.226-6.082zm39.528 46.37c-5.624 0-10.033-2.888-12.314-6.233V74.19c2.281-3.04 7.146-6.233 12.314-6.233 9.731 0 17.18 6.081 17.18 16.42 0 10.338-7.449 16.42-17.18 16.42zm2.434-46.37c-10.035 0-14.747 6.082-14.747 6.082V28.43h-14.596v84.682h12.315c1.216 0 2.128-1.065 2.128-2.129V108.4s4.713 6.233 14.748 6.233c16.57 0 29.493-12.77 29.493-30.103.152-17.33-12.77-30.102-29.341-30.102zM420.38 79.21v34.055h-14.596V80.88c0-9.426-3.04-13.227-11.249-13.227-4.41 0-8.97 2.28-11.859 5.625v39.833h-14.596V55.948h11.555c1.216 0 2.13 1.064 2.13 2.128v2.433c4.255-4.41 9.88-6.082 15.506-6.082 6.385 0 11.707 1.825 15.963 5.473 5.169 4.258 7.146 9.73 7.146 19.309zm34.511 21.588c-5.625 0-10.035-2.888-12.315-6.233V74.19c2.28-3.04 7.146-6.233 12.315-6.233 9.73 0 17.18 6.081 17.18 16.42 0 10.338-7.45 16.42-17.18 16.42zm2.432-46.37c-10.033 0-14.747 6.082-14.747 6.082V28.43h-14.594v84.682h12.314c1.216 0 2.128-1.065 2.128-2.129V108.4s4.714 6.233 14.747 6.233c16.572 0 29.495-12.77 29.495-30.103 0-17.33-12.923-30.102-29.343-30.102zm-218.013 1.52h14.594v57.165h-14.594zm-23.566 38.769c-2.28 3.345-6.841 6.233-12.314 6.233-9.73 0-17.179-6.081-17.179-16.42 0-10.338 7.45-16.419 17.179-16.419 5.321 0 10.186 3.04 12.314 6.234zm0-36.64v2.433s-4.712-6.082-14.746-6.082c-16.572 0-29.495 12.62-29.495 30.102 0 17.332 12.77 30.103 29.495 30.103 10.186 0 14.746-6.233 14.746-6.233v2.584c0 1.216.914 2.129 2.13 2.129h12.314V55.948h-12.314c-1.216 0-2.13 1.064-2.13 2.128zm40.746-19.916a9.863 9.863 0 0 1-9.883 9.882 9.862 9.862 0 0 1-9.881-9.882c0-5.473 4.256-9.882 9.881-9.882 5.625.152 9.883 4.56 9.883 9.882"
    />
  </Svg>
);

export const SesameLogo = () => (
  <Svg viewBox="0 0 96 18">
    <path
      d="M27.805 12.321c0 1.882-1.658 3.188-4.055 3.188-2.24 0-3.763-1.129-4.323-2.546l1.254-.73c.404 1.129 1.569 1.86 3.07 1.86 1.321 0 2.576-.466 2.576-1.772 0-2.744-6.542-1.173-6.542-5.245 0-1.771 1.59-3.166 3.831-3.166 1.837 0 3.27.886 3.92 2.258l-1.232.708c-.47-1.128-1.613-1.55-2.688-1.55-1.165 0-2.352.554-2.352 1.75 0 2.744 6.541 1.173 6.541 5.245m2.979-3.298h8.356c-.314-2.434-2.106-3.696-4.032-3.696-2.353 0-4.033 1.527-4.324 3.696zm9.88.73c0 .222-.023.466-.046.687h-9.834c.314 2.258 2.083 3.652 4.458 3.652 1.77 0 3.002-.819 3.607-1.881l1.299.752c-.94 1.506-2.666 2.546-4.928 2.546-3.54 0-5.96-2.457-5.96-5.8 0-3.253 2.375-5.799 5.848-5.799 3.427 0 5.555 2.811 5.555 5.844zm9.609 2.568c0 1.882-1.658 3.188-4.055 3.188-2.24 0-3.763-1.129-4.323-2.546l1.254-.73c.404 1.129 1.569 1.86 3.07 1.86 1.321 0 2.576-.466 2.576-1.772 0-2.744-6.542-1.173-6.542-5.245 0-1.771 1.59-3.166 3.831-3.166 1.837 0 3.27.886 3.92 2.258l-1.232.708c-.47-1.128-1.613-1.55-2.688-1.55-1.165 0-2.352.554-2.352 1.75 0 2.744 6.541 1.173 6.541 5.245m11.76-2.611c0-2.457-1.926-4.383-4.413-4.383-2.486 0-4.413 1.926-4.413 4.382 0 2.458 1.927 4.383 4.413 4.383 2.487 0 4.413-1.925 4.413-4.383zm1.48-5.534v11.067h-1.48v-2.169c-.94 1.483-2.531 2.435-4.525 2.435a5.764 5.764 0 0 1-5.78-5.8 5.765 5.765 0 0 1 5.78-5.799c1.994 0 3.585.952 4.525 2.435v-2.17h1.48zm22.533 4.847h8.356c-.314-2.434-2.106-3.696-4.033-3.696-2.352 0-4.032 1.527-4.323 3.696zm9.88.73c0 .222-.023.466-.046.687h-9.834c.313 2.258 2.083 3.652 4.458 3.652 1.77 0 3.002-.819 3.607-1.881l1.299.752c-.941 1.506-2.666 2.546-4.929 2.546-3.539 0-5.958-2.457-5.958-5.8 0-3.253 2.374-5.799 5.846-5.799 3.428 0 5.556 2.811 5.556 5.844zM77.993 3.91h-.133a4.348 4.348 0 0 0-3.157 1.349c-.16.168-.337.405-.44.63a2.386 2.386 0 0 0-.439-.631 4.348 4.348 0 0 0-3.156-1.348h-.133c-2.395 0-4.336 1.918-4.336 4.284v7.05h1.479V8.198c0-1.596 1.308-2.89 2.923-2.89s2.953 1.294 2.953 2.89v7.044h1.418V8.196c.002-1.594 1.34-2.886 2.955-2.886 1.614 0 2.923 1.293 2.923 2.889v7.044h1.479V8.194c0-2.366-1.942-4.284-4.336-4.284"
      fill="#fff"
    />
    <path
      d="M13.563 1.198A4.112 4.112 0 0 0 10.628.112a4.087 4.087 0 0 0-2.852 1.284l-.171.181 1.19 1.264.072-.07c.047-.047.116-.114.218-.21.406-.387.927-.66 1.49-.705a2.342 2.342 0 0 1 1.787.613c.94.867.991 2.328.116 3.256l-3.107 3.3a.864.864 0 0 0 0 1.19.89.89 0 0 0 1.29 0l3.103-3.304a4.016 4.016 0 0 0-.2-5.713"
      fill="#fff"
    />
    <path
      d="M2.844 2.467c-.94.87-.992 2.33-.116 3.26l4.782 5.051a4.14 4.14 0 0 1 1.14 3.008 4.147 4.147 0 0 1-1.351 2.92l-.113.104a4.234 4.234 0 0 1-2.89 1.126c-.056 0-.112 0-.165-.003a4.23 4.23 0 0 1-2.963-1.349A4.143 4.143 0 0 1 .05 13.56a4.136 4.136 0 0 1 1.136-2.677c.025-.026.121-.116.242-.227a.888.888 0 0 1 1.255.05.863.863 0 0 1-.048 1.218 6.124 6.124 0 0 0-.244.235 2.425 2.425 0 0 0-.582 1.476 2.415 2.415 0 0 0 .656 1.77c.45.487 1.065.766 1.734.793a2.473 2.473 0 0 0 1.788-.66l.115-.101a2.441 2.441 0 0 0 .123-3.473L1.444 6.911a4.012 4.012 0 0 1 .2-5.713A4.1 4.1 0 0 1 4.578.114a4.074 4.074 0 0 1 2.85 1.283l.176.18L8.796 2.84l-.027.026-1.165 1.135-1.516-1.477h-.003a2.327 2.327 0 0 0-1.567-.675 2.328 2.328 0 0 0-1.674.618"
      fill="#fff"
    />
  </Svg>
);

export const TinderLogo = () => (
  <Svg viewBox="0 0 519 123">
    <g fill="#FFF" fillRule="evenodd">
      <path d="M31.5 49.6C55 41.5 59 20.4 56 1c0-.7.6-1.2 1.2-1C79.7 11 105 35 105 71c0 27.6-21.4 52-52.5 52a50 50 0 0 1-28.2-92.7c.6-.4 1.4 0 1.4.7.3 3.7 1.3 13 5.4 18.6h.4zM171.2 101.1l1.7-2 5.3 16.8-.7.7c-4 3.7-10 5.6-17.7 5.6h-.3c-7 0-12.5-2-16.3-5.7-3.8-3.8-5.8-9.5-5.8-16.7V54h-13.5V35.5h13.5V13.2h20.8v22.3h16.5V54h-16.6v41.3c0 1.9.5 8 6.3 8 3 0 5.8-1.1 6.8-2.3zm11 19.2V35.6H203v84.7h-20.8zM192.5 1A12.5 12.5 0 1 1 180 13.6C180 6.8 185.7 1 192.5 1zm66.4 32.5c18 0 27.9 9.8 27.9 27.7v59H266v-54c-.4-9.6-5-14-14.8-14-8.8 0-15.9 5.4-19.5 10v58h-20.8V35.7h20.8v9c6-5.8 15.6-11 27.2-11zM356 44.4V4.6h20.8v115.8H356v-8.8a34.3 34.3 0 0 1-24.7 10.7c-22.7 0-37.9-17.8-37.9-44.3 0-26.6 15.2-44.4 37.9-44.4A34 34 0 0 1 356 44.4zm0 17.9a25.6 25.6 0 0 0-19.6-10c-12.9 0-21.5 10.3-21.5 25.7 0 15.3 8.6 25.6 21.5 25.6 7.5 0 15.7-4 19.6-9.8V62.3zm69.4-28.7c24.6 0 41.7 19 41.7 46v5.7h-62.9c2.1 11.9 11.5 19.5 24.3 19.5 8.1 0 17-3.5 22.1-8.6L452 95l9.9 14.2-1 .9a48.6 48.6 0 0 1-34.1 12.2c-26 0-44.3-18.3-44.3-44.4a42.8 42.8 0 0 1 43-44.3zm-21.3 36h42.7c-1.2-12.7-11.7-18.5-21.4-18.5-14.6 0-20.1 11-21.3 18.6zm113.3-36h1.5v21l-1.8-.3c-1.5-.3-3.4-.5-5.3-.5-6.7 0-16 4.7-19.5 9.7v56.7h-20.8V35.6h20.9V45c6.9-7.2 16-11.4 25-11.4z" />
    </g>
  </Svg>
);

export const LegoLogo = () => (
  <Svg viewBox="0 0 800 376.483">
    <path d="M337.413 0c-29.758 0-71.598 1.542-103.174 28.357-7.274-14.887-22.099-26.553-63.03-26.553-37.679 0-68.439 17.8-88.596 50.901C55.722 95.717-1.422 219.896.027 287.72c1.079 51.055 39.374 86.222 94.837 87.547 33.318.786 61.72-6.35 83.373-20.712 19.587 14.1 44.614 21.713 72.446 21.713 33.287 0 63.321-8.737 85.605-24.41 20.157 15.981 46.586 24.626 76.544 24.626 38.85 0 74.944-13.392 104.101-38.927 19.895 25.366 53.952 38.574 95.33 38.574 77.485 0 117.722-47.682 147.804-109.664 11.234-23.162 32.362-81.03 36.246-112.267 4.73-38.28 9.355-74.495-16.458-110.463-18.339-25.474-49.546-42.579-96.964-42.579-35.861 0-67.917 9.693-93.514 30.99C567.447 10.466 535.98.618 493.662.618c-33.149 0-60.918 7.551-85.144 22.083C390.935 8.754 370.3 0 337.413 0zm-.005 21.455c31.392 0 57.376 11.729 68.302 29.466 20.99-17.845 51.24-29.187 87.563-29.187 37.14 0 64.801 9.091 82.015 28.555 3.837 4.3 6.535 7.582 10.095 15.01 21.004-24.888 52.087-42.72 97.071-42.72 77.855 0 98.228 50.887 95.654 98.984-1.54 28.925-10.787 63.322-17.722 83.957-30.79 91.524-67.792 149.36-151.919 149.36-38.419 0-73.602-14.993-87.456-52.703-25.243 32.023-63.938 52.873-107.997 53.089-33.672.17-59.871-11.742-76.545-32.176-19.772 21.821-53.228 31.79-86.5 31.79-29.85 0-54.8-10.401-71.15-28.17-18.247 18.37-46.896 28.172-83.435 27.309-46.787-1.125-72.924-29.205-73.74-68.117C20.348 225.6 77.754 101.1 101.471 63.25c16.335-26.83 39.003-39.975 69.13-39.975 16.567 0 33.551 2.896 44.046 13.992 8.63 9.154 10.047 17.276 10.679 32.656 26.46-42.673 71.135-48.468 112.081-48.468z" />
    <path
      fillRule="evenodd"
      d="M688.187 119.56c-.863 22.207-33.457 111.126-45.03 130.744-5.009 8.476-10.665 15.503-20.866 15.503-8.862 0-12.853-6.303-13.084-13.515-.647-20.05 36.184-120.635 48.744-136.97 5.625-8.645 11.866-10.017 18.97-9.94 10.464.139 11.528 7.675 11.266 14.178m59.377 36.277c-7.412 36.831-24.056 80.413-42.117 112.914-29.481 52.997-65.264 60.425-96.517 60.04-31.253-.386-66.513-11.928-66.76-60.133-.184-34.597 14.718-83.48 27.416-115.503C591.67 95.088 614.262 47.746 685.644 48.594c83.249.986 68.393 75.019 61.92 107.243M483.24 104.18c-12.051 0-19.941 7.628-25.782 15.873-12.914 18.108-40.885 90.723-45.23 120.573-2.975 20.42 5.825 24.565 15.487 24.565 15.457 0 32.81-16.35 38.727-43.366 0 0-29.465-.678-21.313-26.83 7.875-25.335 22.824-30.837 47.635-31.854 48.882-1.988 44.044 34.104 40.13 53.337-12.668 62.505-57.159 112.698-120.08 112.698-43.043 0-69.811-23.794-69.811-67.73 0-31.33 15.534-80.444 27.816-109.185 26.229-61.21 53.706-104.037 123.702-104.037 41.978 0 75.096 15.087 70.226 54.415-3.529 28.91-18 45.862-44.244 47.896-7.35.555-37.386-.2-27.431-28.602 3.498-9.94 4.916-17.753-9.832-17.753M264.239 212.41c-2.897 7.782-8.337 24.148-12.73 41.439 14.286-3.545 24.997-6.057 43.35-5.564 20.96.463 34.305 9.139 34.305 26.414 0 41.979-46.355 54.308-78.517 54.308-35.29 0-66.328-20.127-66.328-58.746 0-45.23 24.565-113.9 47.557-159.624 28.325-56.14 57.19-63.584 106.95-63.584 21.868 0 47.08 9.354 47.08 29.989 0 28.633-24.272 39.528-48.297 40.9-10.264.57-26.075 1.186-35.537.493 0 0-7.983 12.205-16.49 33.903 44.537-6.256 63.4 3.853 55.88 29.589-10.171 34.813-40.3 37.109-77.223 30.482m-141.794 40.238c43.55-7.567 54.492 8.198 53.136 22.761-4.13 43.612-44.182 53.414-78.933 52.566-25.197-.57-47.881-12.144-48.529-41.393-1.078-51.225 51.148-169.703 75.728-208.969 11.358-18.662 25.181-27.862 47.25-27.862 20.912 0 26.105 10.74 25.797 23.578-.817 34.304-56.264 138.573-74.449 179.319"
    />
  </Svg>
);

export const TicketmasterLogo = () => (
  <Svg viewBox="0 0 202.208 29.846">
    <g fill="currentColor" fillRule="evenodd">
      <path d="M126.524 26.009c3.762 0 4.928-2.7 5.717-5.95h-1.768c-2.445 0-6.507.431-6.507 3.836 0 1.41 1.279 2.114 2.558 2.114zm4.928.274h-.076c-1.73 2.27-3.46 3.563-6.244 3.563-3.497 0-5.978-2.037-5.978-5.754 0-6.655 7.144-7.164 11.884-7.164h1.767c.15-.55.15-1.135.15-1.723 0-2.034-2.105-2.622-3.873-2.622-2.22 0-4.364.588-6.357 1.566l.714-4.188c2.144-.783 4.326-1.214 6.583-1.214 3.874 0 7.522 1.487 7.522 6.223 0 2.7-1.918 10.61-2.369 14.406h-4.25zM.79 9.199h3.648l.865-4.15 5.417-1.84-1.242 5.99h4.514l-.79 3.836H8.688l-1.843 8.807a8.68 8.68 0 0 0-.225 1.956c0 1.215.79 1.958 1.918 1.958.904 0 1.806-.196 2.446-.47l-.866 4.07c-.866.197-1.843.471-2.708.471-3.423 0-5.83-1.409-5.83-5.285 0-1.565.3-3.091.64-4.695l1.428-6.812H0l.79-3.836M17.905.509h5.04l-1.053 5.01h-5.04zm-1.844 8.69h5.041l-4.137 20.158h-5.04L16.06 9.199zm20.262 4.619c-.978-.666-2.294-1.018-3.686-1.018-4.025 0-6.282 3.914-6.282 7.712 0 2.62.828 5.244 4.288 5.244 1.242 0 2.784-.353 4.1-1.018l-.564 4.15c-1.542.782-3.197.94-4.852.94-5.003 0-8.238-3.484-8.238-8.69 0-7.046 4.477-12.408 11.435-12.408 1.88 0 3.686.352 5.04.782l-1.24 4.306M41.85 0h5.041l-3.348 16.519h.076l7.034-7.32h6.545l-9.291 9.199 5.83 10.959h-5.68l-5.002-10.685h-.076l-2.181 10.685H35.87L41.85 0m33.516 9.199h3.649l.865-4.15 5.416-1.84-1.24 5.99h4.513l-.79 3.836h-4.515l-1.842 8.807a8.645 8.645 0 0 0-.226 1.956c0 1.215.79 1.958 1.919 1.958.902 0 1.806-.196 2.444-.47l-.865 4.07c-.865.197-1.843.471-2.708.471-3.422 0-5.83-1.409-5.83-5.285 0-1.565.301-3.091.64-4.695l1.429-6.812h-3.649l.79-3.836" />
      <path d="M73.68 16.402c0-5.129-3.16-7.672-7.936-7.672-6.357 0-11.021 6.028-11.021 12.29 0 5.99 3.761 8.807 9.328 8.807 2.068 0 4.213-.508 6.169-1.134l.64-4.15c-1.882.9-3.876 1.448-5.944 1.448-3.224 0-5.108-1.192-5.35-4.361h-.004c-.008-.184-.025-.364-.025-.557l.002-.112-.001-.059h.003a11.24 11.24 0 0 1 .82-3.998c.968-2.566 2.337-4.338 5.307-4.338 2.107 0 3.198 1.212 3.198 3.365 0 .47-.038.9-.113 1.37h-6.896c-.448 1.584-.527 2.646-.536 3.601h11.87c.3-1.487.49-2.974.49-4.5m17.062-4.972c.15-.782.3-1.605.414-2.231h4.702l-.451 2.7h.074c1.355-2.074 3.573-3.17 5.943-3.17 2.295 0 4.664 1.41 4.927 3.837h.076c1.279-2.624 4.1-3.836 6.808-3.836 2.896 0 5.378 2.465 5.378 5.519 0 1.8-.45 3.836-.864 5.48l-2.031 9.628h-5.041l2.031-9.825c.263-1.213.64-3.092.64-4.305 0-1.487-1.09-2.427-2.37-2.427-3.498 0-4.363 4.227-5.003 6.968l-1.993 9.589h-5.04l2.03-9.825c.264-1.213.64-3.092.64-4.305 0-1.487-1.09-2.427-2.369-2.427-3.423 0-4.364 4.266-5.003 6.968l-1.993 9.589h-5.04l3.535-17.927m58.411 1.136c-1.504 0-3.384.43-3.384 2.034 0 2.544 6.544 3.485 6.544 8.417 0 5.245-4.4 6.81-8.726 6.81-2.031 0-4.063-.312-5.906-1.213l1.091-4.188c1.43.821 2.858 1.565 4.815 1.565 1.693 0 3.46-.588 3.46-2.23 0-3.25-6.544-3.564-6.544-8.612 0-4.736 4.4-6.42 8.388-6.42 1.842 0 3.723.353 4.717.62l-1.092 3.954c-.542-.306-1.933-.737-3.363-.737zm6.582-3.367h3.65l.864-4.15 5.417-1.84-1.241 5.99h4.513l-.79 3.836h-4.514l-1.843 8.807a8.65 8.65 0 0 0-.225 1.956c0 1.215.79 1.958 1.918 1.958.902 0 1.806-.196 2.444-.47l-.863 4.07c-.866.197-1.844.471-2.71.471-3.423 0-5.83-1.409-5.83-5.285 0-1.565.302-3.091.64-4.695l1.43-6.812h-3.649l.79-3.836m34.171 2.701c.15-.861.301-1.761.452-2.701h4.815l-.678 3.798h.076c.904-2.193 3.385-4.267 5.717-4.267.64 0 1.317.038 1.918.195l-1.052 5.128a6.163 6.163 0 0 0-1.918-.313c-3.574 0-5.304 3.326-5.943 6.576l-1.806 9.04h-5.04l3.46-17.456m-3.499 4.502c0-5.129-3.159-7.672-7.936-7.672-6.356 0-11.021 6.028-11.021 12.29 0 5.99 3.761 8.807 9.329 8.807 2.068 0 4.213-.508 6.168-1.134l.64-4.15c-1.881.9-3.874 1.448-5.943 1.448-3.225 0-5.108-1.192-5.35-4.361h-.005c-.008-.184-.025-.364-.025-.557l.003-.112-.002-.059h.004c.022-1.38.313-2.742.82-3.998.967-2.566 2.337-4.338 5.306-4.338 2.106 0 3.198 1.212 3.198 3.365 0 .47-.038.9-.112 1.37h-6.898c-.446 1.584-.525 2.646-.534 3.601h11.87c.3-1.487.489-2.974.489-4.5" />
    </g>
  </Svg>
);

export const VolkswagenLogo = () => (
  <Svg viewBox="0 0 56 56">
    <path d="M28 52.7C14.5 52.7 3.4 41.5 3.4 28c0-2.8.5-5.5 1.4-8.1l14.4 28c.2.4.4.7.9.7s.7-.3.9-.7L27.7 33c.1-.2.2-.3.3-.3.2 0 .2.2.3.3l6.8 14.9c.2.4.4.7.9.7s.7-.3.9-.7l14.4-28c.9 2.5 1.4 5.2 1.4 8.1-.1 13.5-11.2 24.7-24.7 24.7zm0-31.1c-.2 0-.2-.2-.3-.3L20 4.7c2.5-.9 5.2-1.4 8-1.4s5.5.5 8 1.4l-7.7 16.6c-.1.1-.1.3-.3.3zm-8.1 18c-.2 0-.2-.2-.3-.3L7 15.1c2.2-3.6 5.4-6.6 9.1-8.7L25 25.6c.2.4.4.5.7.5h4.6c.3 0 .5-.1.7-.5l8.8-19.2c3.7 2.1 6.9 5.1 9.1 8.7L36.4 39.3c-.1.2-.2.3-.3.3-.2 0-.2-.2-.3-.3L31 28.7c-.2-.4-.4-.5-.7-.5h-4.6c-.3 0-.5.1-.7.5l-4.8 10.6c-.1.1-.1.3-.3.3zM28 56c15.5 0 28-12.5 28-28S43.5 0 28 0 0 12.5 0 28s12.5 28 28 28z"></path>
  </Svg>
);

export const TypeformLogo = () => (
  <Svg viewBox="0 0 165.7 40">
    <path d="M0 5.8v3.9h8.3V32h4.1V9.7h8.3V5.8zM21.3 13.1L29.6 32 26 39.7h4.6l12.3-26.6h-4.5L31.9 27l-6.1-13.9zM55.6 12.8c-2.3 0-4.4 1.2-5.1 2.5v-2.2h-3.9v26.6h3.9v-9.8c.9 1.4 2.9 2.4 5.1 2.4 5.6 0 8.5-3.8 8.5-9.8-.1-6.1-3-9.7-8.5-9.7zm2.9 14.4c-.9 1.1-2.1 1.7-3.5 1.7s-2.6-.6-3.5-1.7c-.9-1.2-1.4-2.7-1.4-4.6 0-1.9.4-3.5 1.4-4.6.9-1.2 2.1-1.7 3.5-1.7s2.6.6 3.5 1.7c.9 1.1 1.4 2.7 1.4 4.6 0 1.9-.5 3.4-1.4 4.6zM76.3 12.8c-6.2 0-8.8 5.3-8.8 9.8s2.6 9.8 8.8 9.8c4.2 0 6.4-1.6 8.3-5.3l-3.3-1.3c-.9 2-2.9 3.2-5 3.2-3 0-4.7-2.3-4.7-5.2H85V22c0-4.3-2.7-9.2-8.7-9.2zm-4.7 7.6c.5-2.4 2.1-4.1 4.6-4.1 2.7 0 4.2 1.8 4.6 4.1h-9.2zM88.2 13.1v3.5h2.4V32h3.9V16.6h4.2v-3.5h-4.2v-1.2c0-2 .9-3 2.6-3 .8 0 1.5.2 2.2.5l.8-3.3c-.9-.5-1.9-.7-3.1-.7-3.9 0-6.3 2.2-6.3 6.7v1h-2.5zM117.3 15.6c-1.7-1.9-3.9-2.8-6.8-2.8-2.8 0-5.1.9-6.8 2.8-1.7 1.9-2.5 4.2-2.5 6.9s.8 5.1 2.5 6.9c1.7 1.9 4 2.8 6.8 2.8s5.1-.9 6.8-2.8c1.7-1.9 2.6-4.2 2.6-6.9s-.9-5-2.6-6.9zM114.4 27c-.9 1.2-2.2 1.8-3.8 1.8-1.6 0-2.9-.6-3.8-1.8-.9-1.2-1.4-2.7-1.4-4.5 0-1.7.5-3.2 1.4-4.4.9-1.2 2.2-1.9 3.8-1.9 1.6 0 2.9.6 3.8 1.9.9 1.2 1.4 2.7 1.4 4.4-.1 1.8-.5 3.3-1.4 4.5zM123.6 13.1V32h3.9v-7c0-2.8.5-5 1.5-6.5s2.2-2.3 3.6-2.3c.9 0 1.6.2 2.2.6l.7-3.6c-.8-.3-1.5-.5-2.4-.5-2.1 0-4.4 1.2-5.6 3.5V13h-3.9zM139.5 13.1V32h3.9v-7.2c0-5.4 1.9-8.6 4.4-8.6 1.7 0 2.8 1.1 2.8 3.1V32h3.9v-7.6c0-5 2-8.2 4.4-8.2 1.7 0 2.8 1.1 2.8 3.1V32h3.9V18.5c0-3.4-2-5.7-5.4-5.7-2.4 0-4.6 1.4-5.9 3.9-.6-2.4-2.7-3.9-5.2-3.9-2.3 0-4.2 1.2-5.7 3.5v-3.2h-3.9" />
  </Svg>
);

export const VogueLogo = () => (
  <Svg viewBox="0 0 948 250">
    <path d="M377.651 89.431c1.056 4.008 13.003 52.856-7.91 97.701-2.042 4.373-25.775 61.692-90.24 61.868-64.465-.176-88.198-57.495-90.24-61.868-20.917-44.845-8.966-93.693-7.91-97.7C207.03.763 279.265 2 279.265 2h.465s72.241-1.237 97.92 87.43zm-53.917 123.642c1.616-3.991 14.797-30.378 14.823-87.538.022-57.156-13.254-83.539-14.866-87.534C311.427.747 280.079 3.63 280.079 3.63h-1.156S247.57.747 235.311 38c-1.616 3.995-14.797 30.378-14.823 87.534-.022 57.16 13.255 83.547 14.87 87.538 12.26 37.25 43.609 34.372 43.609 34.372h1.155s31.353 2.878 43.612-34.372zm582.039 16.843c40.893-25.07 41.71-74.582 41.71-74.582H948v88.552H777.084v-1.695h18.321V6.6h-31.862v171.824c0 73.958-60.254 71.566-70.257 71.566-78.314 0-81.421-50.088-81.421-71.919V6.747H593V5.052h79.135v1.72h-18.86v189.06c0 14.366 3.168 21.156 5.015 25.333 13.715 27.944 39.62 25.987 42.653 25.987 48.307 0 60.753-37.147 60.753-72.431V6.764h-18.991V5h198.103v76.256h-.743c0-22.85-16.045-43.558-18.708-47.086-17.718-26.636-52.618-27.608-52.618-27.608h-31.976v113.794c28.908 0 35.04-7.577 37.434-9.401 21.05-17.106 17.053-39.96 17.053-39.96h1.599v101.467h-1.734c0-27.686-17.583-39.294-22.241-43.097-10.66-8.747-32.11-7.18-32.11-7.18v119.959h26.378c26.109-1.313 40.632-11.058 42.63-12.228zM113.853 248L21.006 6.691H0V5h82.123l-.013 1.73H62.219l69.289 174.57L183.389 6.76h-19.148V5.013H204V6.76h-18.766L113.853 248zM533.4 10.767C556.728 16.125 564.475 0 564.475 0v85.641c-8.64-38.701-32.744-63.88-34.862-66.357-11.242-12.638-22.745-16.678-35.572-16.678-28.54.652-37.398 28.145-39.381 32.575-11.904 29.446-12.035 77.009-12.035 81.173-1.058 47.171 7.804 81.314 9.255 86.912 7.673 29.446 20.632 36.873 22.75 38.435 17.559 10.553 37.515 3.293 39.907 2.477 26.584-10.942 25.921-41.693 25.921-41.693v-53.813h-17.851v-1.958H596v1.825h-16.13v96.03c-12.697-21.761-38.087-9.118-42.714-7.165-25.264 11.986-33.595 11.08-36.771 11.338-32.37 2.73-54.853-17.07-56.7-18.632-40.47-34.013-44.702-81.83-44.968-85.736-5.29-57.462 20.366-92.257 21.556-94.21C453.867 2.348 485.71.914 491.265.653c15.468-1.306 36.583 9.023 42.135 10.114z" />
  </Svg>
);

export const InVisionLogo = () => (
  <Svg viewBox="0 0 127.9 44">
    <path d="M2.8 0C1.2 0 0 1.2 0 2.8v38.5C0 42.8 1.2 44 2.8 44h38.5c1.5 0 2.8-1.2 2.8-2.8V2.8C44 1.2 42.8 0 41.2 0H2.8zm11 8.2c1.5 0 2.8 1.2 2.8 2.8s-1.2 2.8-2.8 2.8S11 12.5 11 11s1.2-2.8 2.8-2.8zm15.8 7.1c2.3 0 4.2 1.7 4.2 5 0 .9-.1 1.9-.4 2.8l-1.2 4.4c-.1.5-.2.8-.2 1.2 0 .8.3 1.2.8 1.2s1.3-.4 2.1-2.8l1.6.7c-1 3.5-2.7 4.9-4.9 4.9-2.5 0-3.8-1.6-3.8-3.7 0-.6.1-1.3.3-1.9l1.2-4.5c.1-.5.2-1 .2-1.4 0-1.5-.8-2.3-2.2-2.3-1.7 0-2.9 1.3-3.5 3.8l-2.4 9.9h-4.1l.7-3.1c-1.2 2.1-2.9 3.4-5 3.4-2.5 0-3.7-1.5-3.7-3.8 0-.6.1-1.3.2-1.9l1.9-8H8.7l.9-3.4h7l-2.8 11.4c-.2.7-.3 1.3-.3 1.8 0 .7.3.9.9 1.1.3.1 3 0 4.4-3.3l1.8-7.6h-3l.9-3.4h6.3l-.8 3.9c1.2-2.3 3.4-4.4 5.6-4.4z" />
    <path d="M84.8 32.4h4V15.7h-4v16.7zm36.9-17.1c-2.7 0-4.3 1.4-5.4 2.9v-2.6h-4v16.7h4v-9.4c0-2.6 1.6-4.1 3.9-4.1 2.4 0 3.7 1.5 3.7 4.1v9.5h4V21.7c0-3.9-2.3-6.4-6.2-6.4zm-21 14.1c-3.1 0-5.3-2.4-5.3-5.4 0-2.9 2-5.3 5.2-5.3 3.1 0 5.3 2.4 5.3 5.4 0 2.9-2 5.3-5.2 5.3zm0-14.1c-5.3 0-9.3 4-9.3 8.8 0 4.8 3.9 8.7 9.2 8.7 5.4 0 9.3-4 9.3-8.7 0-4.9-3.9-8.8-9.2-8.8zM51.4 27.9l-4.7-12.3h-4.3l7.1 16.8h3.6l7.1-16.8H56l-4.6 12.3zm25.4-5.4c-2-.6-3.9-1.1-3.9-2.3v-.1c0-1 .9-1.7 2.4-1.7.8 0 1.6.2 2.5.5l.2.1c.6.2 2.3.4 3.8-1.7-1.8-1.2-4.2-1.9-6.4-1.9-3.5 0-6.2 1.9-6.2 5.1v.1c0 3.2 2.9 4.2 5.4 4.9 2 .6 3.9 1 3.9 2.3v.1c0 1.1-1 1.8-2.7 1.8-1.1 0-2.4-.3-3.6-.9-.4-.1-2.2-.8-3.8 1.4 2.2 1.6 4.9 2.5 7.3 2.5 3.6 0 6.4-1.7 6.4-5.3v-.1c.1-2.9-2.8-4-5.3-4.8zm-14.5 9.9h4V15.7h-4v16.7z" />
  </Svg>
);

export const XingLogo = () => (
  <Svg viewBox="0 0 141.68695 56.054741">
    <g fill="currentColor" transform="translate(-194.8708,-324.33481)">
      <path
        transform="translate(194.8708,324.33481)"
        d="M 112.1875,7.53125 C 111.85625,7.5312501 111.5775,7.6475 111.4375,7.875 C 111.2925,8.1100001 111.315,8.4125 111.46875,8.71875 L 115.1875,15.15625 C 115.19375,15.16875 115.19375,15.17625 115.1875,15.1875 L 109.34375,25.5 C 109.19125,25.803751 109.19875,26.10875 109.34375,26.34375 C 109.48375,26.569999 109.73125,26.71875 110.0625,26.71875 L 115.5625,26.71875 C 116.385,26.71875 116.78125,26.16375 117.0625,25.65625 C 117.0625,25.65625 122.7775,15.54875 123,15.15625 C 122.9775,15.12 119.21875,8.5625 119.21875,8.5625 C 118.945,8.0750002 118.53125,7.53125 117.6875,7.53125 L 112.1875,7.53125 z M 87.96875,19.5625 C 79.433754,19.562501 74.75,24.5425 74.75,33.5625 L 74.75,43.0625 C 74.749997,51.677498 78.85125,56.0625 86.96875,56.0625 C 93.532499,56.062499 98.8475,53.49625 99.21875,53.3125 L 99.21875,36.25 C 99.218749,35.720001 98.8425,35.34375 98.3125,35.34375 L 87.4375,35.34375 C 86.9075,35.343748 86.53125,35.72 86.53125,36.25 L 86.53125,40.625 C 86.53125,41.155 86.9075,41.53125 87.4375,41.53125 L 92.5,41.53125 C 92.521246,41.531249 92.53125,41.54125 92.53125,41.5625 L 92.53125,48.9375 C 92.531248,48.953749 92.51375,48.96375 92.5,48.96875 C 92.476248,48.978749 90.115,49.875 87.1875,49.875 C 83.32,49.875 81.4375,47.475 81.4375,42.5625 L 81.4375,33.5625 C 81.437498,31.008749 81.94,29.13125 82.96875,27.84375 C 84.095,26.435 85.7975,25.75 88.21875,25.75 L 89.28125,25.75 C 92.796248,25.75 95.51125,26.535 97.25,27.09375 C 97.520001,27.18 97.7675,27.135 97.9375,27 C 98.111247,26.8625 98.21875,26.62875 98.21875,26.34375 L 98.21875,22.15625 C 98.218752,21.682501 97.98625,21.41625 97.28125,21.0625 C 96.382502,20.6125 93.82375,19.5625 89.40625,19.5625 L 87.96875,19.5625 z M 1.15625,20.03125 C 0.90375,20.03125 0.70750002,20.12875 0.59375,20.3125 C 0.47,20.51125 0.47124999,20.786249 0.59375,21.03125 L 9.53125,37.3125 C 9.5375,37.32375 9.5375002,37.363751 9.53125,37.375 L 0.09375,54.46875 C -0.03,54.715 -0.029999997,54.98875 0.09375,55.1875 C 0.20625,55.37125 0.40375,55.468751 0.65625,55.46875 L 6.75,55.46875 C 7.4475,55.46875 7.6962501,55.077501 7.96875,54.53125 L 14.21875,43.03125 C 14.225,43.01875 14.23625,43.000001 14.25,43 C 14.265,43 14.275,43.01875 14.28125,43.03125 C 14.28125,43.03125 20.56125,54.53 20.5625,54.53125 C 20.83375,55.07625 21.052501,55.468751 21.75,55.46875 L 27.875,55.46875 C 28.1275,55.46875 28.324999,55.37125 28.4375,55.1875 C 28.5,55.0875 28.531251,54.965001 28.53125,54.84375 C 28.53125,54.72125 28.498749,54.5925 28.4375,54.46875 C 28.43625,54.46625 18.96875,37.375001 18.96875,37.375 C 18.965,37.36875 18.968751,37.35 18.96875,37.34375 C 18.96875,37.3375 18.965,37.317498 18.96875,37.3125 L 27.9375,21.03125 C 27.99875,20.9075 28.031251,20.778751 28.03125,20.65625 C 28.03125,20.535 27.998749,20.41125 27.9375,20.3125 C 27.82375,20.12875 27.626249,20.03125 27.375,20.03125 L 21.25,20.03125 C 20.5525,20.03125 20.30375,20.42375 20.03125,20.96875 L 14.28125,31.65625 C 14.275,31.6675 14.265,31.687501 14.25,31.6875 C 14.23625,31.6875 14.225,31.667499 14.21875,31.65625 C 14.21875,31.65625 8.4700004,20.96875 8.46875,20.96875 C 8.24125,20.51125 8.0012498,20.03125 7.25,20.03125 L 1.15625,20.03125 z M 32.96875,20.03125 C 32.44,20.03125 32.062501,20.40875 32.0625,20.9375 L 32.0625,54.5625 C 32.0625,55.09125 32.439999,55.468749 32.96875,55.46875 L 37.8125,55.46875 C 38.34125,55.46875 38.718751,55.09125 38.71875,54.5625 L 38.71875,20.9375 C 38.71875,20.40875 38.341249,20.03125 37.8125,20.03125 L 32.96875,20.03125 z M 45.90625,20.03125 C 45.3775,20.03125 44.968748,20.40875 44.96875,20.9375 L 44.96875,54.5625 C 44.96875,55.09125 45.3775,55.468749 45.90625,55.46875 L 50.75,55.46875 C 51.27875,55.46875 51.656251,55.09125 51.65625,54.5625 L 51.65625,34.28125 C 51.65625,34.26375 51.67125,34.253749 51.6875,34.25 C 51.70375,34.245 51.711251,34.26625 51.71875,34.28125 C 51.71875,34.28125 62.218748,54.529998 62.21875,54.53125 C 62.435,54.96375 62.771251,55.468749 63.4375,55.46875 L 68.5,55.46875 C 69.02875,55.46875 69.406248,55.09125 69.40625,54.5625 L 69.40625,20.9375 C 69.40625,20.40875 69.028746,20.03125 68.5,20.03125 L 63.65625,20.03125 C 63.1275,20.03125 62.749998,20.40875 62.75,20.9375 L 62.75,41.1875 C 62.75,41.205 62.735,41.215002 62.71875,41.21875 C 62.7025,41.22375 62.664999,41.233751 62.65625,41.21875 C 62.65625,41.21875 52.15625,20.969999 52.15625,20.96875 C 51.92625,20.5125 51.688749,20.03125 50.9375,20.03125 L 45.90625,20.03125 z "
      />
      <path d="M 330.16424,324.33481 C 329.34299,324.33481 328.98674,324.85231 328.69174,325.38231 C 328.69174,325.38231 316.84299,346.39481 316.45299,347.08481 C 316.47299,347.12231 324.26799,361.42231 324.26799,361.42231 C 324.54049,361.90981 324.96174,362.46981 325.80424,362.46981 L 331.29799,362.46981 C 331.62924,362.46981 331.88799,362.34481 332.02799,362.11856 C 332.17424,361.88356 332.17049,361.57356 332.01674,361.26856 L 324.26299,347.10231 C 324.25549,347.09106 324.25549,347.07731 324.26299,347.06606 L 336.44049,325.53481 C 336.59299,325.23106 336.59674,324.92106 336.45174,324.68606 C 336.31174,324.45981 336.05174,324.33481 335.72049,324.33481 L 330.16424,324.33481 z " />
    </g>
  </Svg>
);

export const MagicLeapLogo = () => (
  <Svg viewBox="0 0 400 196.94989106753812">
    <g fill="currentColor" fillRule="evenodd">
      <path d="M104.909 54.028 C 86.070 55.501,69.383 69.034,64.823 86.536 C 64.619 87.320,64.402 87.584,62.668 89.163 C 54.899 96.240,48.509 106.047,44.985 116.302 C 44.326 118.222,43.370 121.481,43.466 121.481 C 43.490 121.481,44.681 121.096,46.112 120.625 C 51.960 118.701,65.847 115.200,66.123 115.581 C 66.148 115.615,66.840 117.015,67.660 118.693 C 78.728 141.313,105.566 150.506,128.201 139.429 C 137.403 134.926,145.228 126.838,149.295 117.628 C 149.734 116.632,150.159 115.749,150.238 115.667 C 150.662 115.227,163.967 118.521,170.184 120.605 C 171.615 121.085,172.822 121.441,172.866 121.396 C 173.102 121.161,171.108 115.134,169.724 111.895 C 166.176 103.598,161.319 96.589,154.523 89.963 L 151.781 87.290 151.357 85.867 C 145.421 65.921,125.698 52.402,104.909 54.028 M87.653 72.251 C 95.533 74.108,97.454 85.518,90.985 92.044 C 82.008 101.099,70.368 90.181,76.448 78.408 C 78.800 73.855,83.500 71.272,87.653 72.251 M132.532 72.327 C 140.991 74.490,144.556 86.601,138.545 92.757 C 133.087 98.349,123.931 94.476,121.823 85.684 C 119.905 77.686,125.619 70.559,132.532 72.327 " />
      <path d="M319.111 45.301 C 316.935 45.738,315.428 47.868,315.722 50.088 C 316.428 55.410,324.271 54.870,324.250 49.500 C 324.240 46.783,321.771 44.766,319.111 45.301 M205.280 59.429 C 200.778 60.573,197.255 63.973,195.880 68.500 C 195.492 69.779,195.483 69.996,195.424 79.695 L 195.363 89.586 198.765 89.586 L 202.167 89.586 202.217 80.044 L 202.266 70.501 202.775 69.465 C 205.327 64.267,212.858 64.871,214.454 70.402 C 214.687 71.208,214.728 72.706,214.728 80.467 L 214.728 89.586 218.122 89.586 L 221.516 89.586 221.564 80.044 L 221.612 70.501 222.071 69.522 C 224.356 64.650,231.020 64.643,233.416 69.509 L 233.987 70.667 234.038 80.127 L 234.088 89.586 237.393 89.586 L 240.697 89.586 240.697 79.854 C 240.697 68.006,240.607 67.476,238.016 64.029 C 233.667 58.243,224.312 57.379,219.345 62.305 L 218.110 63.529 216.985 62.397 C 214.256 59.648,209.331 58.400,205.280 59.429 M258.214 59.801 C 249.870 61.004,244.521 68.741,245.936 77.560 C 247.729 88.737,261.039 93.613,269.325 86.127 L 269.993 85.523 270.552 86.039 C 274.142 89.350,274.653 89.760,275.186 89.760 L 275.730 89.760 275.730 81.326 C 275.730 72.049,275.656 71.171,274.671 68.702 C 272.194 62.494,265.319 58.776,258.214 59.801 M293.344 59.797 C 282.706 61.174,277.151 73.319,282.771 82.910 C 287.137 90.359,299.135 92.167,303.639 86.055 L 304.183 85.316 304.084 88.017 C 303.884 93.490,301.837 96.626,297.772 97.685 C 294.184 98.619,289.684 96.740,288.465 93.798 C 288.176 93.100,288.143 93.103,286.077 93.959 C 285.131 94.351,283.788 94.908,283.093 95.196 L 281.828 95.719 282.450 96.902 C 288.453 108.325,306.319 106.300,310.094 93.769 C 310.629 91.995,310.816 73.824,310.325 71.400 C 308.744 63.594,301.619 58.726,293.344 59.797 M316.863 74.684 L 316.863 89.760 320.000 89.760 L 323.137 89.760 323.137 74.684 L 323.137 59.608 320.000 59.608 L 316.863 59.608 316.863 74.684 M341.274 59.797 C 325.282 61.867,323.910 84.997,339.521 89.347 C 341.136 89.797,345.920 89.797,347.538 89.347 C 351.123 88.351,354.123 86.272,356.049 83.449 L 356.609 82.627 356.213 82.379 C 355.995 82.242,354.683 81.483,353.297 80.692 L 350.778 79.254 350.340 79.845 C 346.306 85.292,338.068 84.187,335.837 77.899 C 335.259 76.269,335.256 73.262,335.832 71.590 C 337.983 65.347,346.503 64.273,350.426 69.751 L 350.763 70.221 353.638 68.578 C 355.220 67.674,356.491 66.844,356.463 66.733 C 356.342 66.263,355.224 64.843,354.144 63.791 C 350.933 60.660,346.128 59.169,341.274 59.797 M263.545 66.555 C 271.341 69.238,270.892 80.966,262.912 83.045 C 256.716 84.659,251.429 78.974,252.986 72.371 C 254.098 67.657,258.962 64.977,263.545 66.555 M297.801 66.473 C 305.926 68.637,305.926 80.906,297.801 83.069 C 291.385 84.778,286.027 79.003,287.756 72.243 C 288.887 67.820,293.312 65.278,297.801 66.473 M195.423 114.641 C 195.473 127.987,195.504 129.327,195.786 130.277 C 197.128 134.811,200.663 137.556,205.701 137.976 L 207.059 138.089 207.059 134.848 L 207.059 131.606 206.405 131.504 C 204.329 131.180,203.244 130.476,202.556 129.008 L 202.092 128.017 202.044 114.031 L 201.996 100.044 198.682 100.044 L 195.368 100.044 195.423 114.641 M222.890 108.577 C 214.108 110.176,208.608 118.671,210.788 127.265 C 213.604 138.366,227.373 142.345,235.773 134.487 C 236.723 133.598,238.431 131.484,238.431 131.197 C 238.431 131.149,237.065 130.544,235.395 129.853 L 232.358 128.596 231.691 129.337 C 227.415 134.087,218.763 132.171,217.249 126.138 L 217.130 125.664 228.731 125.664 L 240.333 125.664 240.453 125.026 C 240.847 122.921,240.061 118.910,238.766 116.420 C 235.871 110.856,229.004 107.464,222.890 108.577 M255.599 108.943 C 244.565 111.720,240.855 126.422,249.131 134.576 C 254.132 139.504,262.620 139.921,267.528 135.480 L 268.588 134.520 271.087 136.541 C 273.111 138.179,273.691 138.562,274.143 138.562 L 274.702 138.562 274.641 129.542 C 274.572 119.288,274.611 119.618,273.084 116.443 C 270.254 110.561,262.457 107.216,255.599 108.943 M292.300 108.764 C 287.703 109.724,283.899 112.582,282.003 116.501 C 280.426 119.758,280.543 118.198,280.481 136.863 L 280.426 153.377 283.568 153.377 L 286.710 153.377 286.710 144.015 L 286.710 134.652 287.625 135.542 C 292.027 139.820,300.100 139.602,305.484 135.059 C 312.252 129.349,312.055 117.356,305.103 111.781 C 301.938 109.243,296.331 107.922,292.300 108.764 M227.435 114.952 C 229.941 115.543,233.356 118.420,233.375 119.956 C 233.376 120.028,229.847 120.087,225.534 120.087 C 219.375 120.087,217.691 120.040,217.692 119.869 C 217.693 119.749,217.932 119.236,218.223 118.728 C 220.015 115.603,223.733 114.080,227.435 114.952 M261.939 115.225 C 270.020 117.047,270.099 129.747,262.042 131.846 C 256.724 133.231,252.029 129.702,251.730 124.096 C 251.402 117.929,256.043 113.896,261.939 115.225 M297.597 115.300 C 302.067 116.464,304.520 121.027,303.348 125.997 C 301.415 134.199,289.673 134.277,287.582 126.101 C 285.857 119.357,291.171 113.626,297.597 115.300 " />
    </g>
  </Svg>
);

export const BlueTomatoLogo = () => (
  <Svg viewBox="0 0 496.1 144.4">
    <path
      fillRule="evenodd"
      clipRule="evenodd"
      d="M161.3 63.9h10.2v12.3c1-1 2.2-1.8 3.4-2.3 1.3-.5 2.7-.8 4.3-.8 3.2 0 5.9 1.1 8 3.4 2.1 2.2 3.2 5.5 3.2 9.7 0 2.8-.5 5.3-1.4 7.4-1 2.1-2.3 3.7-4 4.8-1.7 1-3.6 1.6-5.6 1.6-1.8 0-3.4-.4-4.9-1.1-1.1-.6-2.3-1.7-3.6-3.3v3.8h-9.5V63.9zm10.2 22.5c0 2.2.4 3.8 1.3 4.8s1.9 1.5 3.3 1.5c1.2 0 2.2-.5 3-1.5.8-1 1.2-2.6 1.2-4.9 0-2-.4-3.5-1.2-4.5-.8-1-1.8-1.4-2.9-1.4-1.4 0-2.5.5-3.4 1.5-.9 1-1.3 2.5-1.3 4.5"
    />
    <path d="M194.6 63.9h10.1v35.5h-10.1zM238.5 99.3H229v-4.2c-1.4 1.7-2.8 2.9-4.3 3.7-1.4.7-3.2 1.1-5.3 1.1-2.8 0-5-.8-6.6-2.4-1.6-1.6-2.4-4.1-2.4-7.5V73.6h10.2v14.1c0 1.6.3 2.8.9 3.4.6.7 1.5 1 2.6 1 1.2 0 2.2-.5 3-1.4.8-.9 1.2-2.5 1.2-4.9V73.6h10.1v25.7z" />
    <path
      fillRule="evenodd"
      clipRule="evenodd"
      d="M272.4 88.9h-20.3c.2 1.6.6 2.8 1.3 3.5 1 1.1 2.3 1.7 3.8 1.7 1 0 1.9-.2 2.8-.7.5-.3 1.1-.8 1.8-1.6l10 .9c-1.5 2.6-3.4 4.4-5.5 5.6-2.2 1.1-5.2 1.7-9.3 1.7-3.5 0-6.2-.5-8.3-1.4-2-1-3.7-2.5-5-4.6-1.3-2.1-2-4.6-2-7.4 0-4 1.3-7.3 4-9.8 2.7-2.5 6.3-3.7 11-3.7 3.8 0 6.8.6 9 1.7s3.9 2.7 5 4.8c1.1 2.1 1.7 4.9 1.7 8.3v1zm-10.3-4.7c-.2-1.9-.7-3.3-1.6-4.1-.8-.8-2-1.2-3.4-1.2-1.6 0-2.9.6-3.9 1.9-.6.8-1 1.9-1.2 3.5h10.1z"
    />
    <path d="M275.1 82.6h14.7v7.6h-14.7zM306.2 63.8v9.9h5.6v7.2h-5.6V90c0 1.1.1 1.8.3 2.2.3.5.9.8 1.7.8.7 0 1.8-.2 3.1-.6l.7 6.8c-2.5.5-4.8.8-7 .8-2.5 0-4.4-.3-5.6-.9-1.2-.6-2.1-1.6-2.7-2.9-.6-1.3-.8-3.4-.8-6.2v-9.1h-3.7v-7.2h3.7v-9.9h10.3z" />
    <path
      fillRule="evenodd"
      clipRule="evenodd"
      d="M315.4 86.6c0-3.9 1.4-7.1 4.1-9.7 2.7-2.6 6.4-3.8 11-3.8 5.3 0 9.3 1.5 12 4.5 2.2 2.4 3.3 5.4 3.3 8.9 0 4-1.4 7.2-4.1 9.7-2.7 2.5-6.4 3.8-11.2 3.8-4.2 0-7.7-1-10.3-3.1-3.2-2.7-4.8-6.1-4.8-10.3m10.1-.1c0 2.3.5 4 1.4 5.1 1 1.1 2.2 1.6 3.6 1.6 1.5 0 2.7-.5 3.6-1.6.9-1.1 1.4-2.8 1.4-5.2 0-2.2-.5-3.9-1.4-5-.9-1.1-2.1-1.6-3.5-1.6-1.5 0-2.7.6-3.7 1.7-.9 1.1-1.4 2.8-1.4 5"
    />
    <path d="M350.7 73.6h9.4v3.8c1.4-1.6 2.7-2.7 4.1-3.3 1.4-.7 3.1-1 5-1 2.1 0 3.8.4 5 1.1 1.2.7 2.2 1.8 3 3.2 1.6-1.7 3-2.8 4.4-3.4 1.3-.6 2.9-.9 4.8-.9 2.8 0 5 .8 6.6 2.5 1.6 1.6 2.4 4.2 2.4 7.7v16.1h-10.1V84.7c0-1.2-.2-2-.7-2.6-.7-.9-1.5-1.3-2.5-1.3-1.2 0-2.2.4-2.9 1.3-.7.8-1.1 2.2-1.1 4v13.3H368V85.2c0-1.1-.1-1.9-.2-2.3-.2-.6-.6-1.2-1.1-1.5-.5-.4-1.2-.6-1.9-.6-1.2 0-2.1.4-2.9 1.3-.7.9-1.1 2.3-1.1 4.2v13.1h-10.1V73.6z" />
    <path
      fillRule="evenodd"
      clipRule="evenodd"
      d="M410.7 82l-9.7-1c.4-1.6.9-2.9 1.6-3.9.7-1 1.7-1.8 3-2.5.9-.5 2.2-.9 3.8-1.2 1.6-.3 3.4-.4 5.3-.4 3 0 5.5.2 7.3.5 1.8.3 3.4 1 4.6 2.1.9.7 1.5 1.8 2 3.1s.7 2.6.7 3.8v11.4c0 1.2.1 2.2.2 2.9.2.7.5 1.5 1 2.6H421c-.4-.7-.6-1.2-.7-1.5-.1-.4-.2-.9-.4-1.6-1.3 1.2-2.6 2.1-4 2.7-1.8.7-3.9 1.1-6.2 1.1-3.1 0-5.5-.7-7.2-2.1-1.6-1.4-2.4-3.2-2.4-5.3 0-2 .6-3.6 1.8-4.8 1.2-1.3 3.3-2.2 6.5-2.8 3.8-.7 6.3-1.3 7.4-1.5 1.1-.3 2.3-.7 3.6-1.2 0-1.2-.3-2.1-.8-2.5-.5-.5-1.4-.7-2.7-.7-1.7 0-2.9.3-3.7.8-.5.1-1.1.9-1.5 2m8.8 5.1c-1.4.5-2.8.9-4.4 1.3-2.1.5-3.4 1.1-3.9 1.6-.6.5-.8 1.1-.8 1.8 0 .8.3 1.4.8 1.9.6.5 1.4.7 2.5.7s2.2-.3 3.1-.8c1-.5 1.7-1.2 2.1-1.9.4-.8.6-1.8.6-3v-1.6z"
    />
    <path d="M446.8 63.8v9.9h5.6v7.2h-5.6V90c0 1.1.1 1.8.3 2.2.3.5.9.8 1.7.8.7 0 1.8-.2 3.1-.6l.7 6.8c-2.5.5-4.8.8-7 .8-2.5 0-4.4-.3-5.6-.9-1.2-.6-2.1-1.6-2.7-2.9-.6-1.3-.8-3.4-.8-6.2v-9.1h-3.7v-7.2h3.7v-9.9h10.3z" />
    <path
      fillRule="evenodd"
      clipRule="evenodd"
      d="M456 86.6c0-3.9 1.4-7.1 4.1-9.7 2.7-2.6 6.4-3.8 11-3.8 5.3 0 9.3 1.5 12 4.5 2.2 2.4 3.3 5.4 3.3 8.9 0 4-1.3 7.2-4.1 9.7-2.7 2.5-6.4 3.8-11.2 3.8-4.2 0-7.7-1-10.3-3.1-3.2-2.7-4.8-6.1-4.8-10.3m10.1-.1c0 2.3.5 4 1.4 5.1 1 1.1 2.2 1.6 3.6 1.6 1.5 0 2.7-.5 3.6-1.6.9-1.1 1.4-2.8 1.4-5.2 0-2.2-.5-3.9-1.4-5-.9-1.1-2.1-1.6-3.5-1.6-1.5 0-2.7.6-3.7 1.7-.9 1.1-1.4 2.8-1.4 5"
    />
    <path d="M101.5 32.9c3-2 9.7-4.3 9.7-4.3-11.3-1.6-18.5.2-18.5.2 5-6.6 26.4-10.5 26.4-10.5-23.7-1.1-35.7 9.8-35.7 9.8.7-6.6 11.3-20 11.3-20-14.5 9.7-16.9 19.8-16.9 19.8S75.3 17.8 60.9 8.1c0 0 10.6 13.4 11.3 20 0 0-11.9-11-35.7-9.8 0 0 21.4 3.9 26.4 10.5 0 0-7.2-1.8-18.5-.2 0 0 6.8 2.3 9.7 4.4C27.2 40.3 7.9 59.8 7.9 82.7c0 29.2 31.3 52.9 70 52.9s70-23.7 70-52.9c0-22.9-19.3-42.5-46.4-49.8zm-23.6 85.8c-31 0-56.1-18.4-56.1-41 0-18.8 17.4-34.7 41-39.5l-11.2 9.6s7.2-3.6 12.2-4.7c3.7-.8 6.3-1.9 10-2.4 2.9 2.9 11.1 11.9 11.1 19.7 1.1-8.6-1-16.6-1.9-19.4 3.2.5 5.7 1.5 9 2.3 4.9 1.1 12.2 4.7 12.2 4.7l-11.6-9.7c7.1 1.4 13.6 3.8 19.2 6.9-.7.3-1.2.7-1.7 1.3-2.1 2.9.1 7.9 5 11.2 4.7 3.2 10.1 3.6 12.3.9 4.2 5.7 6.6 12.3 6.6 19.3 0 22.5-25.1 40.8-56.1 40.8z" />
  </Svg>
);

export const VimeoLogo = () => (
  <Svg viewBox="0 0 1101.307 311.36">
    <path d="M246.197 146.496c-1.1 23.987-17.845 56.83-50.236 98.515-33.489 43.541-61.822 65.314-85.001 65.314-14.353 0-26.508-13.255-36.431-39.779l-19.881-72.925c-7.371-26.509-15.274-39.778-23.728-39.778-1.842 0-8.292 3.88-19.33 11.605L0 154.513a3118.324 3118.324 0 0 0 35.947-32.068c16.21-14.013 28.383-21.384 36.496-22.128 19.169-1.841 30.969 11.267 35.398 39.326 4.784 30.273 8.096 49.103 9.956 56.473 5.528 25.117 11.605 37.663 18.248 37.663 5.155 0 12.898-8.148 23.227-24.44 10.31-16.294 15.84-28.69 16.583-37.208 1.47-14.062-4.058-21.11-16.583-21.11-5.9 0-11.977 1.358-18.232 4.042 12.105-39.664 35.235-58.931 69.372-57.832 25.31.744 37.24 17.165 35.785 49.265" />
    <path d="M350.108 27.503c-.37 9.181-4.977 17.989-13.835 26.428-9.956 9.534-21.756 14.304-35.397 14.304-21.012 0-31.163-9.166-30.419-27.511.355-9.536 5.98-18.716 16.859-27.525 10.877-8.792 22.95-13.206 36.237-13.206 7.742 0 14.191 3.039 19.363 9.084 5.156 6.062 7.55 12.203 7.192 18.426zm48.119 196.688c-10.328 19.525-24.52 37.21-42.59 53.048-24.714 21.369-49.41 32.053-74.108 32.053-11.444 0-20.204-3.685-26.281-11.058-6.077-7.37-8.937-16.937-8.567-28.738.356-12.152 4.138-30.95 11.33-56.377 7.193-25.424 10.798-39.064 10.798-40.908 0-9.57-3.33-14.368-9.957-14.368-2.213 0-8.485 3.88-18.813 11.605l-12.72-14.935c11.798-10.684 23.597-21.368 35.397-32.068 15.855-14.013 27.653-21.384 35.413-22.128 12.155-1.097 21.092 2.474 26.814 10.75 5.705 8.274 7.824 19.008 6.369 32.229-4.801 22.419-9.973 50.881-15.501 85.404-.372 15.808 5.349 23.696 17.149 23.696 5.156 0 14.368-5.447 27.655-16.372 11.056-9.084 20.09-17.635 27.105-25.65l10.507 13.817" />
    <path d="M743.625 224.19c-10.329 19.526-24.52 37.21-42.59 53.049-24.712 21.369-49.412 32.053-74.107 32.053-23.988 0-35.592-13.255-34.85-39.796.355-11.799 2.667-25.973 6.902-42.556 4.236-16.584 6.548-29.483 6.919-38.694.372-13.998-3.88-21.013-12.77-21.013-9.616 0-21.076 11.443-34.394 34.298-14.062 23.97-21.659 47.197-22.759 69.68-.743 15.871.81 28.042 4.656 36.513-25.732.744-43.756-3.507-54.036-12.721-9.212-8.114-13.43-21.56-12.687-40.376.355-11.799 2.166-23.598 5.43-35.396 3.249-11.8 5.058-22.306 5.43-31.536.744-13.64-4.25-20.462-14.95-20.462-9.246 0-19.218 10.522-29.918 31.534-10.7 21.013-16.614 42.961-17.714 65.817-.744 20.657.581 35.025 3.96 43.14-25.312.744-43.286-4.592-53.922-16.004-8.824-9.55-12.848-24.065-12.105-43.558.356-9.553 2.036-22.887 5.075-39.988 3.038-17.1 4.736-30.42 5.092-39.986.726-6.612-.938-9.927-4.979-9.927-2.215 0-8.485 3.735-18.813 11.187l-13.27-14.935c1.843-1.454 13.447-12.154 34.847-32.068 15.484-14.369 25.99-21.74 31.517-22.112 9.587-.742 17.328 3.218 23.228 11.882 5.899 8.664 8.858 18.716 8.858 30.144 0 3.685-.372 7.192-1.099 10.506 5.527-8.47 11.976-15.857 19.363-22.129 16.954-14.739 35.946-23.048 56.96-24.89 18.07-1.471 30.969 2.763 38.728 12.72 6.254 8.114 9.196 19.735 8.84 34.847a776.118 776.118 0 0 0 8.309-7.192c8.47-9.956 16.761-17.876 24.875-23.776 13.641-9.957 27.849-15.484 42.589-16.6 17.697-1.47 30.419 2.748 38.161 12.672 6.626 8.082 9.584 19.655 8.858 34.703-.374 10.295-2.86 25.264-7.468 44.917-4.623 19.655-6.919 30.937-6.919 33.878-.37 7.726.373 13.045 2.215 15.986 1.844 2.94 6.256 4.395 13.272 4.395 5.156 0 14.366-5.447 27.653-16.372 11.057-9.084 20.09-17.635 27.107-25.65l10.506 13.817" />
    <path d="M825.475 165.876c.356-9.892-3.686-14.855-12.155-14.855-11.055 0-22.273 7.614-33.684 22.839-11.41 15.225-17.31 29.804-17.667 43.737-.209 0-.209 2.392 0 7.16 18.038-6.594 33.684-16.678 46.939-30.258 10.667-11.732 16.193-21.286 16.567-28.623zm125.554 57.75c-10.701 17.683-31.71 35.349-63.052 53.015-39.084 22.467-78.73 33.684-118.912 33.684-29.869 0-51.269-9.957-64.168-29.851-9.213-13.643-13.642-29.857-13.269-48.669.356-29.853 13.643-58.236 39.825-85.164 28.755-29.481 62.682-44.238 101.764-44.238 36.14 0 55.31 14.724 57.523 44.141 1.47 18.748-8.857 38.064-30.967 57.93-23.614 21.707-53.306 35.494-89.058 41.375 6.626 9.197 16.581 13.79 29.868 13.79 26.54 0 55.488-6.742 86.844-20.254 22.482-9.486 40.182-19.348 53.096-29.562l10.506 13.802" />
    <path d="M1038.668 184.464c.373-9.972-1.016-19.123-4.152-27.43-3.137-8.307-7.661-12.478-13.545-12.478-18.814 0-34.299 10.167-46.451 30.484-10.345 16.634-15.875 34.363-16.601 53.192-.371 9.245 1.292 17.376 4.977 24.39 4.041 8.131 9.763 12.186 17.15 12.186 16.583 0 30.791-9.776 42.59-29.367 9.955-16.26 15.29-33.248 16.032-50.977zm62.504 2.086c-1.485 33.875-14.013 63.149-37.61 87.812-23.598 24.665-52.92 36.998-87.945 36.998-29.126 0-51.253-9.392-66.366-28.173-11.055-13.982-17.15-31.47-18.247-52.447-1.859-31.665 9.568-60.76 34.296-87.267 26.541-29.449 59.901-44.173 100.099-44.173 25.797 0 45.34 8.664 58.624 25.957 12.542 15.84 18.249 36.27 17.149 61.293" />
  </Svg>
);

export const ShpockLogo = () => (
  <Svg viewBox="0 0 500 242.81">
    <path d="M604.3-285.79c-.1-.2-.1-.4-.1-.5 0 .1.1.3.1.5zm-.1-.5c0-.2 0-.3.1-.5 0 .1-.1.3-.1.5zm.1-.5c.1-.2.2-.3.3-.5-.1.2-.2.3-.3.5zm318.1 43.4c.5-1 .8-1.9 1.1-2.8-.9.5-.8 2-1.1 2.8zm-359 108.2h-5.2c-.1 0 2.1.5 5.2 0zM65.249 68.771c8.12-3.424 14.576 1.468 13.5 10.272-.391 3.522-1.565 6.946-3.033 10.174-.88 1.859-1.76 3.815-2.25 5.87-.391 1.859-.782 4.109 1.174 5.38 1.957 1.37 4.207 1.566 6.457.392 2.152-1.174 3.326-2.935 4.206-5.087 2.642-6.848 4.11-14.088 4.5-21.327.49-8.902-4.01-14.87-12.521-17.511-15.75-4.891-32.87 4.402-39.23 21.424-5.478 14.479-2.836 28.762 1.566 42.947 3.522 11.25 8.217 22.207 9.587 34.142.783 6.652-.978 7.924-7.24 5.674-8.902-3.13-17.217-7.435-26.413-9.783-6.163-1.565-11.935-2.348-15.555 4.5v2.935c7.338 3.228 15.653 4.109 22.5 8.902 6.066 4.305 13.208 6.261 20.35 7.533 10.369 1.859 16.63-1.957 19.37-11.544 1.369-5.087 1.662-10.174.977-15.457-1.37-9.88-4.304-19.272-7.924-28.467-3.032-7.729-5.087-15.653-5.87-24.066-.978-11.25 5.675-22.5 15.849-26.903zm433.573 58.697c-5.576-2.348-6.163-1.663-11.054 5.576-4.99 7.24-9.979 14.479-15.653 21.229-8.315 9.88-14.576 9.196-19.957-2.348-4.108-8.902-5.87-18.49-8.12-27.979-1.075-4.304.392-6.554 3.62-8.804 3.718-2.642 7.044-5.772 10.664-8.511 8.902-6.848 17.902-13.599 26.707-20.446 1.174-.88 3.13-1.957 2.152-3.914-.783-1.565-2.641-1.663-4.305-1.76-4.793-.392-9.293.39-13.598 2.739-9.685 5.38-18.587 11.935-27.49 18.587-5.771 4.304-11.445 8.805-18.293 14.087 6.26-20.446 12.326-39.327 19.663-57.816 5.577-13.892 10.566-27.979 20.055-39.914 3.033-3.815 2.837-5.478-1.174-8.022-2.054-1.272-4.304-2.152-6.848-2.152-8.804.098-12.228 6.261-15.065 13.109-12.718 31.403-23.283 63.588-34.142 95.676-2.837 8.413-6.163 16.337-12.229 22.99-9.391 10.369-18.783 20.934-32.38 26.022-5.87 2.152-12.327 4.206-17.61-.098-5.576-4.5-4.794-11.348-3.717-17.707 3.228-18.294 11.445-34.436 22.207-49.305 3.228-4.403 6.358-9.196 11.543-11.642 1.468-.685 3.229-1.663 4.5-.587 1.174.978.196 2.74-.293 4.109-2.25 6.456-4.598 12.815-6.652 19.272-2.055 6.75-.979 10.272 3.521 12.718 4.696 2.543 9.588 1.467 13.696-3.718 4.892-6.065 8.12-13.011 9.392-20.642 2.348-13.696.098-17.51-12.62-23.38-.783-.294-1.467-.783-2.152-1.077-10.174-4.108-19.664-3.424-28.273 3.816-3.913 3.228-7.043 7.239-10.174 11.152-6.554 8.315-15.065 14.479-22.99 21.327-2.25 1.956-5.184 3.326-8.51 3.521-.098-1.271-.098-2.347-.294-3.424-1.076-7.239-2.445-15.163-9.685-18-7.239-2.837-14.967-4.99-22.598-6.457-7.924-1.467-13.598 4.403-18.294 10.175-6.26 7.532-12.13 15.652-15.261 24.848-3.424 10.076-11.348 12.717-20.348 15.554 1.37-4.402 2.739-8.217 3.62-12.13 2.64-11.544 4.402-23.088-.392-34.436-5.967-14.087-19.37-17.022-30.522-6.652-3.913 3.718-7.337 7.826-11.055 11.74-.391.293-.88.684-1.272.978l.294-1.957c2.25-9.49 6.554-18.294 9.391-27.587 1.077-3.424 1.468-6.36-2.347-8.316-3.62-1.858-7.044-2.25-9.979 1.565-3.326 4.305-5.576 9.098-7.533 14.088-8.315 21.62-14.967 43.827-20.641 66.23-.88 3.423-.783 7.63-3.522 9.88-5.968 4.99-12.522 9.196-20.25 11.446-2.544.782-3.033-.49-2.25-2.446.782-1.956 1.76-3.815 2.836-5.674 4.794-8.12 9.783-16.044 13.892-24.555 4.5-9.49 7.826-19.174 7.435-29.935-.294-7.142-3.62-11.348-10.468-13.403-4.304-1.271-8.706-1.271-13.01-.39-4.794.977-9.49 2.25-14.48 3.423 10.37-25.435 21.62-49.892 34.045-73.762 2.348-4.5 5.674-8.805 2.935-14.38h-6.848c-2.935 1.956-5.87 3.912-8.316 6.651-5.967 6.555-10.37 14.185-14.185 22.11-17.609 36-34.24 72.392-47.544 110.252-2.935 8.413-5.674 16.924-7.044 25.728-.782 5.479 1.37 8.511 6.75 9.881 6.653 1.663 7.729 1.076 10.077-5.283.978-2.739 1.76-5.576 2.64-8.315 4.892-16.142 9.882-32.283 20.251-45.98 5.479-7.238 11.838-13.402 21.229-15.358 4.794-.978 7.24 1.174 6.75 5.967-.196 2.055-.685 4.207-1.467 6.163-2.25 5.381-4.794 10.664-7.044 16.044-5.087 11.74-11.152 23.088-14.576 35.414-1.566 5.576 1.076 9.49 6.554 11.055 5.087 1.467 9.685 0 14.087-2.25 4.696-2.446 9.098-5.479 13.696-8.316.587 1.565.196 2.935-.195 4.402-4.794 18.294-9.294 36.784-12.914 55.371-1.565 7.728-2.64 15.261 6.555 19.272h5.087c1.565-.293 3.424-.782 5.283-1.76 2.837-2.055 3.032-4.305.587-7.24-1.566-1.957-1.076-4.304-.685-6.554 2.348-14.87 6.163-29.447 9.685-44.12 1.663-7.045 3.717-14.088 5.576-21.425 7.337 8.217 15.652 11.25 25.827 8.804 8.902-2.054 15.163-7.826 20.935-14.38.978-1.077 1.565-2.74 3.13-3.033 7.142-1.272 14.088-3.62 21.522-5.478v5.282c.196 11.055 7.533 20.25 18.294 22.207 11.446 2.055 21.914-.587 30.914-8.315 10.663-9.196 16.729-21.327 21.424-34.338.587-1.76.587-4.304 2.935-4.696 5.087-.88 9.49-3.521 14.674-6.26-3.13 8.902-4.989 17.12-5.576 25.826-.685 11.446 4.598 21.033 15.163 25.337 15.36 6.164 29.936 3.131 43.632-5.184 3.326-2.055 6.456-4.403 10.565-7.142-.88 3.033-1.565 4.99-2.054 7.044-1.076 4.402.489 7.435 4.891 9.293 3.815 1.566 7.24 1.272 9.685-2.739 1.663-2.837 2.837-5.772 3.718-8.902 1.956-6.555 4.108-13.011 5.967-19.468 1.174-4.01 3.62-6.652 7.044-8.804 2.25-1.37 3.13-1.272 4.01 1.271 2.544 7.044 5.773 13.696 9.294 20.349 10.174 19.37 28.273 18.098 41.088 8.804 10.663-7.728 17.61-18.49 23.674-29.935 0 0 0-.098.098-.098.294-.783.196-2.25 1.076-2.74 1.566-5.478-.489-6.847-.587-6.945zM197.61 152.12c-3.913 5.38-9.587 7.728-16.337 6.554-6.555-1.174-9.587-6.75-7.337-12.913 5.967-16.142 13.99-31.012 25.044-44.218 1.956-2.348 4.206-4.598 6.75-6.261 5.282-3.522 8.51-2.153 9.685 4.01.293 1.468.489 2.837.587 4.011-1.663 18.196-7.924 34.338-18.392 48.817zm98.61-38.74c-1.369 15.848-7.923 29.544-18.098 41.674-.684.88-1.565 1.664-2.445 2.446-3.62 3.522-7.826 5.968-12.718 3.913-5.087-2.152-3.913-7.239-4.01-12.717 1.76-15.946 9.88-29.838 21.62-41.87.488-.49.977-.783 1.564-1.175 3.229-2.348 6.848-4.598 10.762-2.25 3.62 2.055 3.717 6.261 3.326 9.979z" />
  </Svg>
);

export const KiwiComLogo = () => (
  <Svg viewBox="0 0 278 138">
    <g fill="#FFF">
      <path d="M120.447,57.027 C120.587,56.673 120.729,56.108 120.729,55.755 C120.729,53.848 119.246,52.929 117.692,52.929 C116.35,52.929 115.502,53.565 115.007,55.049 L108.791,74.052 L101.656,54.907 C101.232,53.707 100.456,52.929 98.971,52.929 C97.488,52.929 96.711,53.706 96.288,54.907 L89.223,74.052 L83.007,55.049 C82.512,53.566 81.664,52.929 80.322,52.929 C78.768,52.929 77.285,53.848 77.285,55.755 C77.285,56.108 77.425,56.673 77.567,57.027 L86.256,82.811 C86.539,83.941 87.456,84.719 89.011,84.719 C90.565,84.719 91.413,83.871 91.837,82.74 L98.971,63.172 L106.177,82.74 C106.601,83.94 107.519,84.719 109.003,84.719 C110.487,84.719 111.334,84.013 111.758,82.811 L120.447,57.027 Z M55.67,78.823 L45.39,68.605 L55.67,58.388 C56.968,57.088 57.07,55.09 55.67,53.692 C54.271,52.293 52.273,52.392 50.975,53.692 L38.467,66.2 C37.8260254,66.8343989 37.4723235,67.703299 37.488,68.605 C37.4722063,69.5067228 37.8259263,70.3756673 38.467,71.01 L50.975,83.517 C52.273,84.817 54.271,84.917 55.67,83.517 C57.068,82.12 56.968,80.122 55.67,78.823 Z M35.913,81.16 L35.913,56.01 C35.913,54.174 34.501,52.69 32.593,52.69 C30.685,52.69 29.273,54.174 29.273,56.01 L29.273,81.16 C29.273,82.995 30.614,84.479 32.593,84.479 C34.571,84.479 35.913,82.995 35.913,81.159 L35.913,81.16 Z M64.018,56.25 L64.018,81.397 C64.018,83.234 65.361,84.719 67.338,84.719 C69.318,84.719 70.66,83.234 70.66,81.397 L70.66,56.25 C70.66,54.413 69.246,52.93 67.339,52.93 C65.432,52.93 64.019,54.413 64.019,56.25 L64.018,56.25 Z M127.468,56.25 L127.468,81.397 C127.468,83.234 128.81,84.719 130.788,84.719 C132.766,84.719 134.108,83.234 134.108,81.397 L134.108,56.25 C134.108,54.413 132.695,52.93 130.788,52.93 C128.881,52.93 127.468,54.413 127.468,56.25 Z M127.468,56.25 L127.468,81.397 C127.468,83.234 128.81,84.719 130.788,84.719 C132.766,84.719 134.108,83.234 134.108,81.397 L134.108,56.25 C134.108,54.413 132.695,52.93 130.788,52.93 C128.881,52.93 127.468,54.413 127.468,56.25 Z M127.468,56.25 L127.468,81.397 C127.468,83.234 128.81,84.719 130.788,84.719 C132.766,84.719 134.108,83.234 134.108,81.397 L134.108,56.25 C134.108,54.413 132.695,52.93 130.788,52.93 C128.881,52.93 127.468,54.413 127.468,56.25 Z M194.668,58.71 C197.643,58.71 199.378,59.846 201.039,61.112 C201.702,61.57 202.351,61.792 203.021,61.792 C204.633,61.792 205.85,60.556 205.85,58.918 C205.85,58.154 205.54,57.472 204.903,56.834 C202.533,54.381 198.707,52.917 194.668,52.917 C185.508,52.917 179.109,59.407 179.109,68.699 C179.109,77.992 185.507,84.482 194.669,84.482 C198.707,84.482 202.527,83.023 204.886,80.581 C205.534,79.931 205.85,79.245 205.85,78.481 C205.85,76.843 204.633,75.607 203.02,75.607 C202.349,75.607 201.686,75.84 200.991,76.321 C199.422,77.519 197.641,78.689 194.668,78.689 C189.181,78.689 185.348,74.581 185.348,68.699 C185.348,62.817 189.181,58.71 194.668,58.71 Z M225.582,52.917 C216.662,52.917 209.934,59.702 209.934,68.699 C209.934,77.697 216.661,84.482 225.582,84.482 C234.502,84.482 241.229,77.697 241.229,68.699 C241.229,59.702 234.503,52.917 225.582,52.917 Z M225.582,78.845 C219.392,78.845 216.154,73.741 216.154,68.699 C216.154,62.039 220.897,58.554 225.582,58.554 C231.774,58.554 235.014,63.658 235.014,68.699 C235.014,75.36 230.269,78.845 225.582,78.845 Z M275.009,53.095 C273.859,53.095 272.849,53.776 272.306,54.915 L262.635,75.165 L262.55,74.987 L252.857,54.875 C252.188,53.661 251.322,53.095 250.13,53.095 C249.353208,53.0866072 248.605812,53.3916186 248.056693,53.9411137 C247.507574,54.4906088 247.203075,55.2382139 247.212,56.015 L247.212,81.339 C247.212,82.946 248.548,84.303 250.13,84.303 C251.736,84.303 253.093,82.946 253.093,81.339 L253.093,67.883 L260.073,82.675 C260.631,83.785 261.446,84.303 262.637,84.303 C263.772,84.303 264.708,83.704 265.206,82.66 L272.09,67.886 L272.09,81.385 C272.09,82.994 273.4,84.303 275.009,84.303 C276.67,84.303 277.971,83.021 277.971,81.385 L277.971,56.059 C277.971,54.287 276.781,53.096 275.009,53.096 L275.009,53.095 Z" />
      <path d="M149.934,97.876 C149.080291,97.2425519 148.045049,96.9013288 146.982,96.903 C145.40053,96.9058143 143.913546,97.6563522 142.972,98.927 C136.728,107.387 127.912,114.48 117.476,119.438 C106.625,124.598 94.222,127.323 81.572,127.323 C62.271,127.323 44.169,121.116 30.602,109.843 C24.089,104.439 18.987,98.165 15.437,91.197 C11.804,84.062 9.961,76.493 9.959,68.701 C9.961,60.909 11.804,53.339 15.437,46.202 C20.78,35.711 29.687,26.754 41.196,20.3 C53.123,13.61 67.092,10.074 81.598,10.074 C94.246,10.074 106.679,12.814 117.554,17.998 C128.012,22.982 136.833,30.105 143.064,38.598 C144.005215,39.8744294 145.496077,40.6287651 147.082,40.631 C148.140716,40.6327674 149.172015,40.2944929 150.024,39.666 C152.237513,38.0368268 152.714808,34.9234522 151.091,32.706 C143.885,22.891 133.771,14.696 121.839,9.008 C109.635,3.191 95.72,0.117 81.6,0.116 C59.978,0.12 39.608,7.144 24.24,19.893 C16.68,26.17 10.733,33.5 6.564,41.682 C2.207,50.227 -0.002,59.317 -4.31772694e-15,68.7 C-0.002,78.083 2.207,87.172 6.564,95.717 C12.812,107.97 23.104,118.367 36.325,125.783 C49.737,133.304 65.392,137.281 81.598,137.282 C95.681,137.282 109.566,134.222 121.751,128.432 C133.66,122.77 143.768,114.612 150.984,104.84 C152.613705,102.625808 152.144036,99.5103362 149.934,97.875" />
      <path d="M157.898,63.215 C154.871032,63.2188577 152.418306,65.6720311 152.415,68.699 C152.418306,71.7259689 154.871032,74.1791423 157.898,74.183 C160.924968,74.1791423 163.377694,71.7259689 163.381,68.699 C163.377694,65.6720311 160.924968,63.2188577 157.898,63.215" />
    </g>
  </Svg>
);

export const JaneLogo = () => (
  <Svg viewBox="0 0 408 78">
    <g fill="none" fillRule="evenodd">
      <path
        fill="#FF8188"
        d="M32 6.83c0 3.768 3.064 6.832 6.83 6.832 3.768 0 6.832-3.064 6.832-6.83 0-3.768-3.064-6.832-6.83-6.832A6.838 6.838 0 0 0 32 6.83zM9.44 16.27c0 3.767 3.063 6.83 6.83 6.83s6.83-3.063 6.83-6.83-3.063-6.83-6.83-6.83-6.83 3.063-6.83 6.83zM0 38.83c0 3.768 3.064 6.832 6.83 6.832 3.768 0 6.832-3.064 6.832-6.83 0-3.768-3.064-6.832-6.83-6.832A6.838 6.838 0 0 0 0 38.83zm54.56-22.56a6.837 6.837 0 0 0 6.83 6.83c3.768 0 6.832-3.063 6.832-6.83s-3.064-6.83-6.83-6.83a6.836 6.836 0 0 0-6.83 6.83zM64 38.83c0 3.768 3.064 6.832 6.83 6.832 3.768 0 6.832-3.064 6.832-6.83 0-3.768-3.064-6.832-6.83-6.832A6.838 6.838 0 0 0 64 38.83zM32 70.888a6.837 6.837 0 0 0 6.83 6.83c3.768 0 6.832-3.063 6.832-6.83s-3.064-6.83-6.83-6.83A6.838 6.838 0 0 0 32 70.888zm22.56-9.44a6.837 6.837 0 0 0 6.83 6.83c3.768 0 6.832-3.063 6.832-6.83s-3.064-6.83-6.83-6.83a6.836 6.836 0 0 0-6.83 6.83zm-45.12 0c0 3.767 3.063 6.83 6.83 6.83s6.83-3.063 6.83-6.83-3.063-6.83-6.83-6.83-6.83 3.063-6.83 6.83z"
      />
      <path
        fill="#061B2B"
        d="M106.153 64.05c-.213-.32-.424-.955-.424-1.485 0-1.486 1.272-2.758 2.756-2.758 1.167 0 1.91.742 2.227 1.272 4.35 6.682 9.23 10.182 17.29 10.182 9.122 0 16.123-6.895 16.123-19.835V3.755c0-1.484 1.273-2.758 2.757-2.758 1.485 0 2.758 1.274 2.758 2.758v47.248c0 8.59-2.65 15.168-6.787 19.304-3.925 3.926-9.228 5.94-15.168 5.94-10.288 0-17.077-5.092-21.532-12.197m118.375-15.648c-.435-.946-17.68-38.9-18.04-39.706-.38-.85-1.067-.85-1.465.007-.24.52-17.64 38.587-18.138 39.707-.464 1.046-.41 1.638.875 1.638h35.866c1.342 0 1.337-.7.902-1.646m-54.195 23.815l31.715-68.733c.742-1.59 1.803-2.65 3.71-2.65h.214c1.91 0 2.97 1.06 3.713 2.65l31.608 68.52c.32.637.424 1.168.424 1.7 0 1.377-1.167 2.544-2.65 2.544-1.274 0-2.228-.954-2.76-2.122 0 0-7.547-16.585-7.95-17.456-.405-.87-.718-1.636-2.374-1.636H185.43c-1.57 0-1.943.734-2.366 1.633-.424.898-7.958 17.565-7.958 17.565-.53 1.274-1.378 2.016-2.65 2.016-1.38 0-2.548-1.06-2.548-2.333 0-.425.107-1.062.425-1.698M265.03 3.673c0-1.485 1.272-2.76 2.757-2.76h.848c1.167 0 2.016.638 2.758 1.593 0 0 41.916 53.426 48.78 62.237.625.803 1.285.812 1.285-.004V3.46c0-1.485 1.167-2.65 2.652-2.65s2.652 1.165 2.652 2.65v70.35c0 1.27-.955 2.332-2.228 2.332h-.424c-1.06 0-1.91-.742-2.758-1.803 0 0-48.98-62.466-49.74-63.413-.625-.782-1.28-.782-1.28.004v62.667a2.624 2.624 0 0 1-2.65 2.65 2.626 2.626 0 0 1-2.653-2.65V3.673zm89.03 69.816l-.09-69.824c0-1.485 1.274-2.758 2.758-2.758h47.944c1.38 0 2.546 1.167 2.546 2.546 0 1.378-1.166 2.545-2.546 2.545H361.2c-.918 0-1.628.825-1.628 1.635l.005 26.554c0 .976.764 1.62 1.623 1.646.858.024 38.788 0 38.788 0 1.38 0 2.547 1.166 2.547 2.546 0 1.378-1.167 2.544-2.547 2.544h-38.79c-.893 0-1.62.83-1.62 1.64v26.94c0 .965.69 1.65 1.62 1.65h44.094c1.38 0 2.546 1.167 2.546 2.546 0 1.38-1.166 2.545-2.546 2.545h-48.474c-1.485 0-2.758-1.273-2.758-2.758"
      />
    </g>
  </Svg>
);

export const UnderArmourLogo = () => (
  <Svg viewBox="0 0 300 175.12">
    <path
      d="M221.15,66.48c24.35-10.71,40.25-26.8,41.12-44.65,0,0-6.43-4.95-27.19-12.59A151.68,151.68,0,0,0,203,1L203,40.77c0,5.94-2.38,12-6.88,17.37a193.57,193.57,0,0,0-45-5.2h0a193.43,193.43,0,0,0-45,5.21c-4.5-5.37-6.89-11.44-6.89-17.38L99.29,1A151.84,151.84,0,0,0,67.16,9.24C46.4,16.88,40,21.83,40,21.83c.86,17.86,16.77,34,41.15,44.66C56.77,77.2,40.87,93.29,40,111.13c0,0,6.42,5,27.18,12.59A151.09,151.09,0,0,0,99.32,132L99.26,92.2c0-5.94,2.38-12,6.89-17.38a191.88,191.88,0,0,0,45,5.2h0a192.32,192.32,0,0,0,45-5.21c4.5,5.37,6.89,11.45,6.89,17.39L203,132a151.09,151.09,0,0,0,32.13-8.24c20.76-7.63,27.18-12.59,27.18-12.59-.86-17.85-16.77-33.94-41.14-44.65m-70,9h-.47c-14.42,0-26.18-3.53-34.8-8.93,8.62-5.41,20.39-8.94,34.83-8.94h.92c14.43,0,26.18,3.53,34.8,8.92-8.62,5.41-20.38,9-34.83,9"
      fill="#fff"
    />
    <path
      d="M8.11,176c-7,0-7.11-5.33-7.11-7.38V159c0-.59-.05-1.37,1.2-1.37H5.81c1.17,0,1.09.83,1.09,1.37v9.69c0,.69.13,2.54,2.67,2.54h6.06a2.33,2.33,0,0,0,2.63-2.54V159c0-.54-.07-1.37,1.1-1.37H23c1.32,0,1.2.83,1.2,1.37v9.69c0,2.05-.12,7.38-7.13,7.38"
      fill="#fff"
    />
    <path
      d="M41.56,174.85c-2.46-3.32-6-7.5-9.57-11.92v11.8c0,.51.13,1.29-1.1,1.29H27.52c-1.22,0-1.07-.78-1.07-1.29V159c0-.53-.06-1.37,1.07-1.37h6.57c1.86,0,4.5,3.74,6.23,6.21,1.34,1.88,3.81,4.71,5.47,6.83V159c0-.53-.08-1.37,1.15-1.37h3.65c1.18,0,1.11.84,1.11,1.37V176H45c-1.45,0-2.08.1-3.4-1.17"
      fill="#fff"
    />
    <path
      d="M69.32,171.17c3,0,2.74-2.83,2.74-4.13,0-4.35-1.22-4.52-3.17-4.52H59.61v8.65ZM53.91,176V157.61H70.19c1,0,7.65-.11,7.65,6.89,0,7.16.78,11.53-7.51,11.53H61.56l-1.91-3.86V176"
      fill="#fff"
    />
    <path
      d="M84.22,157.73h15c1.27,0,1.1.83,1.1,2.37s.19,2.24-1.1,2.24H87.36c-.31,0-1.38-.17-1.38.95s-.22,1.57,1,1.57H97.43s1.51,2.88,1.68,3.37.22.86-.7.86H87.56l-1.68-3.28v4.84c0,1.12,1,.9,1.29.9H99.48c1.22,0,1.12.85,1.12,2.24s.1,2.32-1.12,2.32H83.9c-1.3,0-3.83-.39-3.83-4.44V161.51c0-1,.56-3.78,4.15-3.78"
      fill="#fff"
    />
    <path
      d="M117.42,162.47h-7.3c-1.21,0-1.17.42-1.17.79v3.29h7.52c3.64,0,3.64-.91,3.64-1.86,0-1.9-.14-2.22-2.69-2.22m-13.06-4.86h16.41c2.2,0,5.39,0,5.39,5.91,0,3.88-.82,4.07-2.58,5.27,3,.52,2.56,4.3,2.56,6.25,0,1-.36,1-.66,1h-4.81c-1,0-.76-1.58-.76-2.41,0-2.28-1.27-2.18-1.76-2.18h-7.08c-.68-1.17-2-3.81-2-3.81v7.64c0,.67-.66.76-.9.76h-4.83c.26,0-.5,0-.5-.61V159.2a1.47,1.47,0,0,1,1.52-1.59"
      fill="#fff"
    />
    <path
      d="M152.46,162.83l-3,5.52.27.27h5.64l.3-.27c-.2-.42-2.64-5-2.89-5.55l-.29,0m1.95-5.1c1.2,0,2.37.54,3.64,3,.86,1.76,6.82,12.52,8.06,14.78v.61H159.9l-1.78-3.23h-7.54L149,169.18c-.47.76-3,5.5-3.82,6.94h-6.22v-.39c1.26-2.39,9.93-18,9.93-18"
      fill="#fff"
    />
    <path
      d="M182.38,162.47h-7.3c-1.22,0-1.17.42-1.17.79v3.29h7.52c3.64,0,3.64-.91,3.64-1.86,0-1.9-.14-2.22-2.69-2.22m-13.06-4.86h16.41c2.2,0,5.39,0,5.39,5.91,0,3.88-.82,4.07-2.58,5.27,3,.52,2.56,4.3,2.56,6.25,0,1-.37,1-.66,1h-4.81c-1,0-.76-1.58-.76-2.41,0-2.28-1.27-2.18-1.76-2.18H176c-.68-1.17-2-3.81-2-3.81v7.64c0,.67-.66.76-.9.76h-4.84c.27,0-.48,0-.48-.61V159.2a1.46,1.46,0,0,1,1.51-1.59"
      fill="#fff"
    />
    <path
      d="M205.46,176c-1.22-2.29-4.62-8.62-6.92-12.77v11.48c0,.51.07,1.29-1.09,1.29h-3.32c-1.25,0-1.15-.78-1.15-1.29V159c0-.54-.07-1.34,1.15-1.34h5.74c.85,0,2.07-.2,3.44,2.54,1,2.19,3.2,6.74,4.69,9.15a101.61,101.61,0,0,0,4.79-9.15c1.34-2.74,2.53-2.54,3.48-2.54H222c1.17,0,1,.8,1,1.34v15.78c0,.51.17,1.29-1,1.29h-3.35c-1.22,0-1.12-.78-1.12-1.29V163.25c-2.32,4.15-5.69,10.48-7,12.77"
      fill="#fff"
    />
    <path
      d="M241.35,171.33c2.77,0,2.66-2.85,2.66-4.76,0-1.71.39-4.4-3.19-4.4h-6.09c-3.56,0-3.15,2.69-3.15,4.4,0,1.91-.17,4.76,2.59,4.76Zm-10.94,4.74c-5.44,0-5.2-5.84-5.2-9.62,0-3.47-.39-8.89,6.42-8.94h12.09c6.84,0,6.4,5.49,6.4,8.94,0,3.78.27,9.62-5.26,9.62"
      fill="#fff"
    />
    <path
      d="M259.22,176c-7,0-7.11-5.33-7.11-7.38V159c0-.59-.05-1.37,1.2-1.37h3.62c1.16,0,1.09.83,1.09,1.37v9.69c0,.69.12,2.54,2.67,2.54h6.05a2.34,2.34,0,0,0,2.64-2.54V159c0-.54-.08-1.37,1.09-1.37h3.64c1.32,0,1.2.83,1.2,1.37v9.69c0,2.05-.12,7.38-7.13,7.38"
      fill="#fff"
    />
    <path
      d="M292.25,162.47H285c-1.22,0-1.17.42-1.17.79v3.29h7.52c3.64,0,3.64-.91,3.64-1.86,0-1.9-.14-2.22-2.69-2.22m-13.07-4.86H295.6c2.2,0,5.4,0,5.4,5.91,0,3.88-.83,4.07-2.59,5.27,2.95.52,2.56,4.3,2.56,6.25,0,1-.36,1-.66,1H295.5c-1,0-.76-1.58-.76-2.41,0-2.28-1.27-2.18-1.75-2.18H285.9c-.68-1.17-2-3.81-2-3.81v7.64c0,.67-.66.76-.9.76h-4.83c.26,0-.49,0-.49-.61V159.2a1.46,1.46,0,0,1,1.5-1.59"
      fill="#fff"
    />
  </Svg>
);

export const GoogleLogo = () => (
  <Svg viewBox="0 0 272 92">
    <g fill="#FFF">
      <path d="M115.75 47.18c0 12.77-9.99 22.18-22.25 22.18s-22.25-9.41-22.25-22.18C71.25 34.32 81.24 25 93.5 25s22.25 9.32 22.25 22.18zm-9.74 0c0-7.98-5.79-13.44-12.51-13.44S80.99 39.2 80.99 47.18c0 7.9 5.79 13.44 12.51 13.44s12.51-5.55 12.51-13.44z" />
      <path d="M163.75 47.18c0 12.77-9.99 22.18-22.25 22.18s-22.25-9.41-22.25-22.18c0-12.85 9.99-22.18 22.25-22.18s22.25 9.32 22.25 22.18zm-9.74 0c0-7.98-5.79-13.44-12.51-13.44s-12.51 5.46-12.51 13.44c0 7.9 5.79 13.44 12.51 13.44s12.51-5.55 12.51-13.44z" />
      <path d="M209.75 26.34v39.82c0 16.38-9.66 23.07-21.08 23.07-10.75 0-17.22-7.19-19.66-13.07l8.48-3.53c1.51 3.61 5.21 7.87 11.17 7.87 7.31 0 11.84-4.51 11.84-13v-3.19h-.34c-2.18 2.69-6.38 5.04-11.68 5.04-11.09 0-21.25-9.66-21.25-22.09 0-12.52 10.16-22.26 21.25-22.26 5.29 0 9.49 2.35 11.68 4.96h.34v-3.61h9.25zm-8.56 20.92c0-7.81-5.21-13.52-11.84-13.52-6.72 0-12.35 5.71-12.35 13.52 0 7.73 5.63 13.36 12.35 13.36 6.63 0 11.84-5.63 11.84-13.36z" />
      <path d="M225 3v65h-9.5V3h9.5z" />
      <path d="M262.02 54.48l7.56 5.04c-2.44 3.61-8.32 9.83-18.48 9.83-12.6 0-22.01-9.74-22.01-22.18 0-13.19 9.49-22.18 20.92-22.18 11.51 0 17.14 9.16 18.98 14.11l1.01 2.52-29.65 12.28c2.27 4.45 5.8 6.72 10.75 6.72 4.96 0 8.4-2.44 10.92-6.14zm-23.27-7.98l19.82-8.23c-1.09-2.77-4.37-4.7-8.23-4.7-4.95 0-11.84 4.37-11.59 12.93z" />
      <path d="M35.29 41.41V32H67c.31 1.64.47 3.58.47 5.68 0 7.06-1.93 15.79-8.15 22.01-6.05 6.3-13.78 9.66-24.02 9.66C16.32 69.35.36 53.89.36 34.91.36 15.93 16.32.47 35.3.47c10.5 0 17.98 4.12 23.6 9.49l-6.64 6.64c-4.03-3.78-9.49-6.72-16.97-6.72-13.86 0-24.7 11.17-24.7 25.03 0 13.86 10.84 25.03 24.7 25.03 8.99 0 14.11-3.61 17.39-6.89 2.66-2.66 4.41-6.46 5.1-11.65l-22.49.01z" />
    </g>
  </Svg>
);

export const GeniusLogo = () => (
  <Svg viewBox="0 0 700 94">
    <g>
      <path
        d="M156.1,0.1c0.1,0.6,0.4,1.2,0.4,1.8c0,22.7,0,45.4,0,68.1c0,1.8,0.1,3.6,0.6,5.3c1.2,4.3,4.8,6.8,9.7,6.9
        c4.3,0.1,8.5,0,12.8,0c10.2,0,20.3,0,30.5,0c1.7,0,1.8,0.1,1.7,1.9c-0.2,5.9-4.1,9.7-10,9.7c-15.4,0-30.8,0-46.2,0
        c-7.6,0-12.6-4.9-12.6-12.6c-0.1-22.7,0-45.4,0-68.1c0-7.3,4.3-12.1,10.4-12.8c0.1,0,0.2-0.1,0.3-0.2
        C154.5,0.1,155.3,0.1,156.1,0.1z"
      />
      <path
        d="M515.1,0.1c1.2,0.2,1.5,1,1.5,2.2c0,14.3-0.1,28.7,0,43c0.1,17.8,12,32.8,29.1,36.6c8.1,1.8,16.1,0.9,23.6-2.7
        c0.4-0.2,0.9-0.5,1.3-0.6c0.4-0.1,0.9,0.1,1.3,0.1c-0.1,0.4,0,1-0.2,1.3c-2.1,2-4,4.3-6.3,6c-24.7,18.1-57.3,2.5-61.6-24.7
        c-0.4-2.8-0.7-5.6-0.7-8.4c-0.1-13.7,0-27.4,0-41.1c0-5.9,2.9-9.9,8.6-11.6c0.1,0,0.1-0.1,0.2-0.2C512.8,0.1,513.9,0.1,515.1,0.1z"
      />
      <path
        d="M0.1,44.4c0.4-2.4,0.7-4.8,1.2-7.2C3.1,29,7,22,12.6,15.8c0.3-0.3,0.9-0.7,1.3-0.6c0.9,0.2,0.6,1,0.4,1.6
        c-1.5,3.8-2.5,7.8-2.8,11.9C9.7,47.2,16.1,62.2,31,73.4c13.5,10.1,28.3,11.8,44.1,6.7c0.5-0.2,1-0.4,1.5-0.5c0.4,0,0.8,0.2,1.2,0.2
        c-0.1,0.4-0.1,1-0.3,1.2c-1,1-2.1,2-3.2,2.9C47.6,105.2,7.7,90.5,1,57c-0.4-1.9-0.6-3.8-0.9-5.7C0.1,49,0.1,46.7,0.1,44.4z"
      />
      <path
        d="M432.1,0.1c1.3,0.2,1.5,1.1,1.5,2.3c0,23.4,0,46.8,0,70.2c0,3.3,0.8,6.1,3.5,8.1c0.8,0.6,1.9,1.1,2.8,1.5
        c0.7,0.3,1,0.6,1,1.4c-0.1,5.3-4.5,9.9-9.7,10.2c-5.5,0.4-10.3-3.5-11-8.8c-0.2-1.1-0.2-2.2-0.2-3.2c0-23.4,0-46.7,0-70.1
        c0-6.2,2.7-9.8,8.6-11.4c0.1,0,0.1-0.1,0.2-0.1C429.9,0.1,431,0.1,432.1,0.1z"
      />
      <path
        d="M288.3,0.1c1.5,0.2,1.7,1.1,1.7,2.5c-0.1,23.2-0.1,46.4,0,69.6c0,1.4,0,2.8,0.4,4c0.8,2.9,2.8,4.9,5.7,5.9
        c0.9,0.3,1.2,0.7,1.2,1.7c-0.3,5.5-4.7,9.9-10.1,10c-5.7,0.1-10.4-4.1-10.7-9.8c-0.1-2.5-0.1-5-0.1-7.6c0-21.7,0-43.5,0-65.2
        c0-5.1,2.7-9.1,7.1-10.6c0.6-0.2,1.2-0.4,1.8-0.6C286.2,0.1,287.2,0.1,288.3,0.1z"
      />
      <path
        d="M571,0.1c1.2,0.2,1.5,1,1.5,2.2c-0.1,13.8,0,27.5-0.1,41.3c0,3.2-0.2,6.5-1,9.5c-1.9,7-6.7,11.2-13.6,13.1
        c-1.2,0.3-1.8-0.3-1.3-1.4c2.5-5,2.4-10.5,2.4-15.9c0-12.5,0-24.9,0-37.4c0-4.6,1.9-8.2,6-10.5c0.8-0.5,1.8-0.7,2.7-1.1
        C568.7,0.1,569.9,0.1,571,0.1z"
      />
      <path
        d="M346.8,0.1c1.8,0.6,1.8,0.6,1.8,2.7c0,16.7-0.1,33.4-0.1,50.1c0,0.3,0.1,0.7,0,1c-0.1,0.3-0.3,0.7-0.5,0.7
        c-0.3,0.1-0.7-0.1-0.9-0.3c-0.2-0.1-0.3-0.5-0.5-0.7c-3.7-6.2-7.5-12.5-11.2-18.7c-0.3-0.5-0.5-1.2-0.5-1.8c0-7.3,0-14.6,0-21.9
        c0-5.6,3.1-9.5,8.5-10.9c0.1,0,0.2-0.1,0.3-0.2C344.7,0.1,345.8,0.1,346.8,0.1z"
      />
      <path
        d="M684.2,66.6c-0.2-0.3-0.6-0.6-0.7-1c-0.7-3.3-2.5-5.7-5.7-6.7c-3.6-1.1-7.3-2-11-2.7c-5.9-1.2-11.9-2.1-17.5-4.6
        c-8.7-3.9-14.3-10.3-16.2-19.8c-2.4-12,4.4-24.6,15.7-29.2c0.3-0.1,0.6-0.3,0.9-0.3c0.8-0.2,1.2,0.3,1,1.1
        c-0.1,0.3-0.2,0.5-0.4,0.7c-6.8,10.5-5.5,27.5,9.7,35.3c5,2.6,10.4,3.8,15.9,4.8c3.9,0.7,7.7,1.4,11.5,2.4c1.9,0.5,3.7,1.4,5.3,2.5
        c4,2.8,4.8,8.1,1.8,12.1C692.3,64.6,688.6,65.9,684.2,66.6z"
      />
      <path
        d="M306.7,36c0-4.5,0-9.1,0-13.6c0-0.6,0.2-1.6,0.6-1.8c1-0.5,1.2,0.6,1.6,1.2c10.1,17.3,20.3,34.7,30.4,52.1
        c3.3,5.7,8,8.6,14.6,8.4c1.2,0,1.4,0.4,1,1.6c-3.7,10.6-17.6,13.5-25.2,5.2c-1.2-1.3-2.2-2.8-3.1-4.3
        c-6.5-10.9-12.9-21.8-19.3-32.7c-0.3-0.6-0.5-1.3-0.5-2C306.6,45.4,306.7,40.7,306.7,36z"
      />
      <path
        d="M666,94.1c-10.8-0.3-20.7-3.1-29.3-9.9c-2.5-2-4.7-4.2-5.6-7.4c-1.9-7.5,4.7-14.7,12-13.1c0.8,0.2,1.2,0.5,1.3,1.4
        c0.4,3.2,2,5.7,4.7,7.6c6.6,4.8,13.8,8.2,22,9.3c9.5,1.2,18.8,0.4,27.7-3.7c0.4-0.2,0.9,0,1.3-0.1c-0.1,0.5-0.1,1.1-0.4,1.4
        c-6.3,7.1-14.1,11.5-23.4,13.2C672.9,93.5,669.4,93.7,666,94.1z"
      />
      <path
        d="M78.5,20.5c0,1.6,0,3.2,0,4.8c0,0.9-0.3,1.3-1.2,1.2c-3.2,0-6.5,0-9.7,0c-0.5,0-1-0.3-1.3-0.6c-6.2-6.1-13.7-8.8-22.3-8.2
        c-2.5,0.2-5,1-7.5,1.5c-0.5,0.1-1.1,0-1.7-0.1c0.1-0.5,0.1-1.2,0.4-1.6c5-6.6,11.2-11.1,19.7-11.9c9-0.8,16.5,2.2,22.8,8.6
        c0.4,0.4,0.7,1.2,0.7,1.8C78.5,17.5,78.5,19,78.5,20.5z"
      />
      <path
        d="M679,5.7c5.1-0.1,10.9,1.9,16,5.7c1.3,0.9,2.8,1.5,4.1,2.4c0.4,0.3,0.8,0.9,0.8,1.4c0.3,7.5-8.1,12.8-14.7,9.3
        c-0.9-0.5-1.7-1-2.5-1.6c-5.2-4-11-5.9-17.5-5.7c-1.8,0.1-2-0.2-1.8-2c0.2-3.2,1.8-5.5,4.5-7.2C670.4,6.5,673.8,5.7,679,5.7z"
      />
      <path
        d="M78.4,52.3c0,0.9-0.1,1.8,0,2.8c0.1,1.4-0.4,2.3-1.5,3.1c-3.2,2.3-6.7,3.7-10.5,4.7c-1.2,0.3-1.5,0-1.5-1.3
        c0,0,0-0.1,0-0.1c0-3.4,0.4-3-3.1-3c-2.3,0-4.6,0.1-6.8-0.1c-5.3-0.5-9.3-5.2-9.3-10.6c0-5.4,4-9.9,9.3-10.5
        c0.9-0.1,1.4,0.2,1.5,1.2c0.4,5,4.9,9.2,10,9.3c3.5,0.1,6.9,0,10.4,0c1.4,0,1.6,0.2,1.6,1.6C78.4,50.3,78.4,51.3,78.4,52.3z"
      />
      <path
        d="M189,19.9c-4.6,0-9.2,0-13.9,0c-1.4,0-1.5-0.1-1.5-1.6c0-2.8,0-5.7,0-8.5c0-1,0.4-1.4,1.3-1.4c11.9,0,23.8,0,35.7,0
        c1,0,1.3,0.5,1.3,1.4c-0.1,6.2-3.8,10-10,10.1c-0.1,0-0.2,0-0.2,0C197.4,19.9,193.2,19.9,189,19.9z"
      />
      <path
        d="M191.6,45.3c5.5,0,11,0,16.5,0c1.5,0,1.6,0.1,1.6,1.7c-0.2,6.2-3.9,9.8-10.1,9.9c-8.2,0-16.3,0-24.5,0
        c-1.5,0-1.6-0.1-1.6-1.6c0-2.8,0-5.5,0-8.3c0-1.6,0.1-1.7,1.7-1.7C180.7,45.3,186.2,45.3,191.6,45.3z"
      />
    </g>
  </Svg>
);

export const EurostarLogo = () => (
  <Svg viewBox="0 0 652 161.8">
    <path
      fill="#FBDD10"
      d="M199 160.7l.5-49 32.5.3-.1 6.4-25-.2-.1 13.4 21.9.2-.1 6.6-21.9-.2-.1 16.1 26.4.2-.1 6.5-33.9-.3zm47-18.7l.3-29.9 7.5.1-.3 29.1c-.1 8 3.3 14.2 13.9 14.3 10.2.1 13.3-5.6 13.3-14l.3-29.1 7.5.1-.3 29.9c-.1 11.5-6.6 19.8-21.7 19.7-14.7-.2-20.6-9.5-20.5-20.2zm56.7 19.6l.4-49 13.9.1c13.3.1 20.4 4.8 20.3 14.4-.1 5.8-3.5 10.6-9.9 13.2l14.9 20.8v.8l-8.3-.1-13-18.4-10.6-.1-.2 18.4-7.5-.1zm20.6-24.7c3.4-1.8 6.4-4.5 6.5-9.5.1-6.1-3.3-8.1-12.8-8.2l-6.4-.1-.2 17.6 12.9.2zm24.5.7c.1-13 9-25.2 25.6-25s25.2 12.5 25.1 25.5c-.1 13.1-8.9 25.2-25.5 25-16.7-.2-25.3-12.5-25.2-25.5zm42.8.3c.1-10.7-5.8-18.8-17.2-18.9-11.4-.1-17.5 7.9-17.6 18.6s5.8 18.8 17.3 18.9c11.3.1 17.4-7.9 17.5-18.6zm16.7 22.4l.1-7h.8c4.5 2 10.2 3.6 15.1 3.6 8.7.1 12.9-2.6 13-7.2 0-4.6-3.5-6.7-8.7-8.5l-7.9-2.7c-7-2.5-10.5-6.7-10.4-12.7.1-8.4 8.1-13 19.4-12.9 4.6 0 11.3 1.3 14.4 2.9l-.1 6.5h-.8c-4.4-1.7-10.1-2.7-13.6-2.8-7.3-.1-11.7 1.3-11.8 6 0 4.2 3.3 5.6 7.1 6.9l7.5 2.8c7.1 2.5 12.4 6.2 12.4 14.3-.1 8.8-8.1 14.1-20.6 14-6 0-11.4-1.2-15.9-3.2zm61.7 2.9l.4-42.6-17.3-.2.1-6.4 42 .4-.1 6.4-17.1-.2-.4 42.6H469zm24.9.2v-.8l19.3-48 9.5.1 17.3 48.4v.8l-7.9-.1-4.5-13.1-21.4-.2-5.1 13-7.2-.1zm31.4-19.2l-7.9-22.7-8.7 22.6 16.6.1zm25.9 19.7l.5-49 14 .1c13.3.1 20.4 4.8 20.3 14.4-.1 5.8-3.5 10.6-9.9 13.2l15 20.8v.8l-8.4-.1-13.1-18.5-10.5-.1-.2 18.4h-7.7zm20.7-24.7c3.4-1.8 6.4-4.5 6.5-9.5.1-6.1-3.3-8.1-12.8-8.2l-6.4-.1-.2 17.7 12.9.1zm27.5-11.6l.1-10.2h-3.4v-2.1l9.5.1v2.1h-3.4l-.1 10.2-2.7-.1zm18.8.2l.1-8.2-3.2 5h-1.3l-3.1-5-.1 8.1H608l.1-12.3h3l3.6 5.9 3.7-5.8h2.6l-.1 12.3h-2.7z"
    />
    <path
      fill="#25B5C9"
      d="M193.1 50.1c3-3.8 5.6-8.2 7.4-12.6.4-1.1.6-2.3.8-3.4.2-1.3.3-2.6.3-3.9.2-16.5-15.8-30.1-35.5-30.2h-3.8c-25.8-.2-43.7 15.6-53.7 25.2-20.7 20-34.4 46-38.2 74.9-5.1 1.9-10.1 3.7-15.3 5.2-4.6 1.4-9.3 2.7-14.1 3.7-4.1.9-8.3 1.6-12.6 1.8-2 .1-4.1.2-6.1 0-.9-.1-1.3 1.9-1.3 2.5 0 3.3 3.8 8.1 14.4 8.2 8.4.1 20.7-2.5 33.9-6.3V114c-.1 14.5 3.1 27.7 9.4 35.6 4.1 5.2 12 7.3 18.4 7.9 8.2.8 16.6-.7 24.5-3.3 16.7-5.5 31.8-14.5 45.9-24.8 1.9-1.4 3.8-2.9 5.7-4.3 1.3-1 2.6-2.1 3.9-3.1 1.5-1.2 4-3.3 5.4-4.6.6-.6 1.2-1.2 1.7-1.8.7-.9 1-2.1 1-3.3 0-.5 0-1.1-.3-1.5-.1-.2-.2-.3-.4-.4-.3-.2-.5 0-.8.1-1.3.6-2.7 1.3-4 2-1.4.8-2.9 1.5-4.4 2.2-1.4.6-2.7 1.4-4.1 2-2.5 1.1-5 2.4-7.5 3.5-1.2.6-2.5 1.2-3.8 1.7-8.5 3.7-17 7.4-25.8 10.2-9.1 2.9-23.2 6.8-29.2-3.6-2.3-4-2.4-9-2.3-13.5 0-3.7.3-7.4.8-11.1 5.6-2 11.2-4.2 16.7-6.3 10-4 20.2-7.9 30.6-11.9 5.6-2.1 11-4.4 16.8-6.3 5-1.6 9.9-3.2 14.9-4.7 5.6-1.8 11.1-3.1 16.9-4 11.9-1.7 23.6-1.4 35.5.4 5.3.8 10.6 1.9 15.9 3.1 10.2 2.4 20.2 5.5 30.1 8.6 16 4.9 31.5 7.4 48 9 2.7.3 5.4.4 8.1.5 14.6.4 29.4-1.7 43.4-5.7 8.4-2.4 16.5-5.8 24.3-9.8.4-.2.9-.5 1.3-.7 2.2-1.2 4.4-2.5 6.5-3.9 3.3-2.2 6.4-4.6 9.4-7.1 1.5-1.3 2.9-2.6 4.3-4 1.2-1.2 2.7-2.4 3.2-4 .3-1 .1-1.8-.1-2.8-.1-.5-.4-.9-.9-.7-1.6.7-3 1.6-4.6 2.3-3.2 1.6-6.4 3-9.7 4.4-7 2.9-14.3 5.2-21.6 6.5-20.5 3.9-42.7 5.2-63.5 2.4-20.7-2.8-40.8-9-61.3-13.1-6.3-1.2-12.7-2.4-19.1-3.3-6.5-.9-13-1.6-19.5-1.9s-13-.3-19.5.2c-6.4.5-12.7 1.6-19.1 2.2-.1 0-.3 0-.4-.1-.1-.2 0-.4.2-.5 1.3-.7 2.1-1.6 2.9-2.6m-22.6 3.1c-12.1 11.1-22 14.1-37 20.7-8.8 3.8-17.8 7.7-26.7 11.5 4.9-14.9 12.6-29.1 22-42 4.8-6.6 8.9-10.2 15.3-15.4 8.1-6.5 22.2-13 30.9-3.7 3.7 3.9 4.8 9.3 4.1 14.5-1.1 6.4-3.7 9.9-8.6 14.4"
    />
  </Svg>
);

export const ChangeOrgLogo = () => (
  <Svg viewBox="0 0 640 126">
    <g fill="#ED2D23">
      <path
        d="M184,94.2c-6.5,3.3-10.6,5.5-18.2,5.5c-14.5,0-23.9-10.2-23.9-23.5c0-15,12.4-24,26.8-24H184v-2.5
			c0-7.1-4.9-10.8-10.6-10.8c-7.6,0-15.8,2.8-19.7,4.2c-0.6,0.2-1.3,0.2-1.8-0.1c-0.6-0.3-1-0.8-1.2-1.4L147,29.8
			c-0.4-1.1,0.2-2.4,1.3-2.8c4.2-1.7,14.4-5.6,22.9-5.6c21.8,0,32.4,8.9,32.4,29.7v45.5c0,1.3-1,2.3-2.3,2.3h-14.1
			c-1,0-1.9-0.6-2.2-1.6L184,94.2z M184,66.7h-12.5c-6,0-9.7,3.7-9.7,8.2c0,4.5,3.3,7.2,9.2,7.2c6.4,0,10.7-3,13.1-5.5V66.7z"
      />
      <path
        d="M233.2,98.9c1.3,0,2.3-1,2.3-2.3V44.8c4.3-3.1,8.9-5.2,13.7-5.2c5.3,0,8,4,8,11.3v45.7c0,1.3,1,2.3,2.3,2.3
			h15c1.3,0,2.3-1,2.3-2.3V48.2c0-16.2-8.6-26.8-23.4-26.8c-6.3,0-12,1.7-18,5.5l-0.9-3.1c-0.3-1-1.2-1.7-2.2-1.7h-14.2
			c-1.3,0-2.3,1-2.3,2.3v72.2c0,1.3,1,2.3,2.3,2.3H233.2z"
      />
      <path
        d="M426.8,88.8c0-5.8,4.7-10.6,10.7-10.6c6.2,0,10.9,4.8,10.9,10.6c0,6-4.1,11.3-10.7,11.3
			C431.5,100,426.8,94.9,426.8,88.8z"
      />
      <path
        d="M487.7,21.4c-17,0-30.5,9.6-30.5,28.2v22c0,18.6,13.5,28.2,30.5,28.2c17,0,30.5-9.6,30.5-28.2v-22
			C518.2,31,504.7,21.4,487.7,21.4z M498.5,70.8c0,6-4.9,10.8-10.8,10.8c-6,0-10.8-4.8-10.8-10.8V50.5c0-6,4.9-10.8,10.8-10.8
			c6,0,10.8,4.8,10.8,10.8V70.8z"
      />
      <path
        d="M391.2,21.4c-17,0-30.5,9.6-30.5,28.2v22c0,18.6,13.5,28.2,30.5,28.2c7.8,0,17.8-1.2,22.1-1.8
			c1.2-0.2,2.1-1.2,2-2.4l-0.5-13c0-0.6-0.3-1.2-0.8-1.7c-0.5-0.4-1.1-0.6-1.8-0.5c-4.1,0.5-12.7,1.3-21,1.3c-6,0-10.8-4.8-10.8-10.8
			v-1.5h39c1.3,0,2.3-1,2.3-2.3V49.6C421.7,31,408.2,21.4,391.2,21.4z M380.4,53.9v-3.4c0-6,4.8-10.8,10.8-10.8
			c6,0,10.8,4.8,10.8,10.8v3.4H380.4z"
      />
      <path
        d="M332.7,22.1c-1,0-1.9,0.6-2.2,1.6l-1,3.1c-5.9-3.8-11.5-5.5-17.8-5.5c-14.8,0-23.4,10.6-23.4,26.8v21.7
			c0,16.2,8.6,26.8,23.4,26.8c6.3,0,12-1.7,18-5.5v5.4c0,6-4.9,10.8-10.8,10.8c-8.3,0-16.9-0.8-21-1.3c-0.6-0.1-1.3,0.1-1.8,0.5
			c-0.5,0.4-0.8,1-0.8,1.7l-0.5,13c0,1.2,0.8,2.2,2,2.4c4.3,0.6,14.3,1.8,22.1,1.8c17,0,30.5-9.6,30.5-28.2v-1.8V77.9V24.5
			c0-1.3-1-2.3-2.3-2.3H332.7z M315.9,78.4c-5.3,0-8-4-8-11.3V50.9c0-7.3,2.7-11.3,8-11.3c4.8,0,9.4,2.1,13.7,5.2v28.3
			C325.3,76.3,320.7,78.4,315.9,78.4z"
      />
      <path
        d="M623.4,22.1c-1,0-1.9,0.6-2.2,1.6l-1,3.1c-5.9-3.8-11.5-5.5-17.8-5.5c-14.8,0-23.4,10.6-23.4,26.8v21.7
			c0,16.2,8.6,26.8,23.4,26.8c6.3,0,12-1.7,18-5.5v5.4c0,6-4.9,10.8-10.8,10.8c-8.3,0-16.9-0.8-21-1.3c-0.6-0.1-1.3,0.1-1.8,0.5
			c-0.5,0.4-0.8,1-0.8,1.7l-0.5,13c0,1.2,0.8,2.2,2,2.4c4.3,0.6,14.3,1.8,22.1,1.8c17,0,30.5-9.6,30.5-28.2v-1.8V77.9V24.5
			c0-1.3-1-2.3-2.3-2.3H623.4z M606.6,78.4c-5.3,0-8-4-8-11.3V50.9c0-7.3,2.7-11.3,8-11.3c4.8,0,9.4,2.1,13.7,5.2v28.3
			C616,76.3,611.5,78.4,606.6,78.4z"
      />
      <path
        d="M572.2,23.8c0-0.6-0.2-1.3-0.7-1.7c-0.5-0.5-1.1-0.7-1.7-0.7c-8,0.3-12.6,2.1-20.4,7.4l-1.1-4.9
			c-0.2-1.1-1.2-1.8-2.3-1.8h-14.1c-1.3,0-2.3,1-2.3,2.3v72.2c0,1.3,1,2.3,2.3,2.3h15c1.3,0,2.3-1,2.3-2.3V47.2
			c6.4-4.5,11.4-6.8,20-7.1c1.2,0,2.2-1,2.2-2.2L572.2,23.8z"
      />
      <path
        d="M108.7,21.4c-6.3,0-12,1.7-18,5.5V2.3c0-1.3-1-2.3-2.3-2.3h-15c-1.3,0-2.3,1-2.3,2.3v19.8v18.1v56.4
			c0,1.3,1,2.3,2.3,2.3h15c1.3,0,2.3-1,2.3-2.3V44.8c4.3-3.1,8.9-5.2,13.7-5.2c5.3,0,8,4,8,11.3v45.7c0,1.3,1,2.3,2.3,2.3h15
			c1.3,0,2.3-1,2.3-2.3V48.2C132.1,31.9,123.5,21.4,108.7,21.4z"
      />
      <path
        d="M61,72.2c0-0.4-0.2-0.9-0.6-1.2c-0.4-0.4-1-0.6-1.5-0.6H43.4c-1,0-1.9,0.7-2.1,1.7c-0.1,0.3-0.2,1-0.2,1
			c-1,4.9-5.4,8.6-10.6,8.6c-6,0-10.8-4.8-10.8-10.8V50.5c0-6,4.9-10.8,10.8-10.8c4.7,0,8.7,3,10.2,7.1c0.2,0.7,0.4,1.4,0.5,2.2
			c0,0.2,0.1,0.4,0.1,0.6c0.1,0.6,0.5,1.1,1,1.4c0.3,0.2,0.7,0.3,1.1,0.3h15.5c0.4,0,0.8-0.1,1.1-0.3c0.2-0.1,0.3-0.2,0.4-0.3
			c0.4-0.4,0.6-0.9,0.6-1.4c0,0,0-0.2,0-0.2c-0.3-18.2-13.7-27.6-30.5-27.6c0,0-0.1,0-0.1,0C13.4,21.4,0,31,0,49.6v22
			c0,18.6,13.5,28.2,30.5,28.2c5.9,0,11.4-1.2,16-3.4c3-1.5,5.7-3.4,7.8-5.8c3.8-4.2,6.3-9.9,6.6-17C61,73.3,61,72.3,61,72.2z"
      />
    </g>
  </Svg>
);

export const SeatGeekLogo = () => (
  <Svg viewBox="0 0 586 120">
    <path
      d="M325.466 36.644c13.769 0 24.614 1.333 24.614 1.333l-4.01-20.778c-4.318-.197-12.214-.444-24.651-.444-27.144 0-46.367 15.953-46.367 43.405 0 23.517 11.154 43.862 42.752 43.862 19.728 0 32.289-1.295 32.301-1.295l-.012-51.277c-6.268.05-28.193.172-32.894.197-1.184 4.664-2.369 9.513-3.553 14.164 0 0 9.562.037 13.917.037 0 5.614.013 11.536.013 17.15-2.258-.062-5.676-.185-7.934-.185-13.547 0-20.049-8.39-20.049-24.479 0-14.694 10.722-21.69 25.873-21.69ZM585.848 120l-40.592-62.616L582.061 0c-9.933 1.444-31.783 4.207-31.783 4.207l-30.142 48.6V6.847s-18.766 1.79-27.28 2.53v100.716c8.316.579 18.964 1.826 27.267 2.504V65.083l30.488 50.179c10.129.963 35.237 4.738 35.237 4.738ZM388.205 66.12c6.218 0 12.424.012 18.643.012V50.759c-6.219.086-12.425.173-18.643.247V35.398c17.619-.679 29.586-1.086 29.586-1.098l-3.763-19.766s-21.776 1.086-50.845 1.913v86.576c10.118.16 43.467 1.554 54.732 2.097l3.8-19.876c-12.72-.445-22.394-.901-33.498-1.197-.012-5.91-.012-11.993-.012-17.927ZM452.819 66.687c5.775.025 11.561.26 17.335.296V49.87c-5.774.111-11.56.223-17.335.321V32.647c10.08-.519 19.038-1.148 29.772-1.777a9074.805 9074.805 0 0 0-3.788-20.383c-16.977 1.296-33.991 2.357-50.968 3.418l.024 91.783c15.954.728 38.878 2.467 54.781 3.689l3.961-20.358c-11.376-.678-25.182-1.863-33.757-2.258-.025-6.379-.025-13.707-.025-20.074ZM158.742 14.571l-26.021 71.61-31.117 1.802c0-6.317.062-15.83.062-22.147 5.799-.074 11.523-.21 17.335-.272V49.02c-5.775-.099-11.561-.197-17.335-.308V30.35c21.209 1.235 36.138 1.987 36.138 1.975-1.283-6.502-4.146-20.37-4.146-20.37-19.778-1.21-33.078-2.135-56.977-4.158v21.406h.012c0 26.379-.012 54.942-.012 81.32 26.009-2.208 46.922-3.775 73.584-5.194l5.762-16.73c9.155-.321 18.063-.74 27.119-1l5.009 16.089 24.997-.79-31.116-87.353c-3.813-.148-19.285-.777-23.294-.975Zm2.862 57.89 8.809-25.515 7.884 25.207c-5.576.074-11.116.222-16.693.308ZM271.141 17.483c-22.862-.111-44.441-.444-67.884-1.184l-3.837 19.63c9.069.197 16.188.32 25.256.456 0 21.9-.012 44.368-.012 66.268 8.34-.148 16.693-.272 25.034-.37l.111-65.59c9.118.087 16.113.185 25.231.21l-3.899-19.42ZM68.587 84.368c0-31.82-43.602-38.396-43.602-51.302 0-13.35 24.096-11.129 37.717-1.456L63.8 7.07C60.987 6.169 49.6 2.38 36.003 2.38 16.78 2.381 0 12.906 0 33.547c0 31.697 43.973 37.051 43.973 53.264 0 16.582-29.143 8.056-43.973-6.38v27.971s10.895 9.204 32.572 9.204c23.887.013 36.015-15.99 36.015-33.238Z"
      fill="#fff"
    />
  </Svg>
);

export const TruliaLogo = () => (
  <Svg viewBox="0 0 198.96 50.44">
    <path d="M147.71 11a5.51 5.51 0 1 0-5.5-5.51 5.51 5.51 0 0 0 5.5 5.51zm4.99 29.56V14.64h-15.5v9.28h6.22v25.92h15.49v-9.28h-6.21zm-26.49 0V2.54h-15.49v9.28h6.21v28.74h-6.21v9.28h21.7v-9.28h-6.21zM60.25 14.52h-2.81a12.17 12.17 0 0 0-10.75 5.39l-1.89-5.27h-9.11v9.28H40v25.92h9.28V31.72a8.16 8.16 0 0 1 8.16-8.16h2.81zm42.98 18.35V14.64H94V33.2a8.29 8.29 0 0 1-16.58 0V14.64h-9.33v18.23a17.57 17.57 0 0 0 35.14 0zM27.6 23.92v-9.28H15.49V3.28H6.22v11.36H0v9.28h6.22v8.92a17.56 17.56 0 0 0 17.56 17.57A17.74 17.74 0 0 0 27.6 50v-9.17a9.28 9.28 0 0 1-3.18.56 8.78 8.78 0 0 1-8.93-8.61v-8.86zm162.09-9.28v3.5a13.08 13.08 0 0 0-9.14-4h-.72c-9.17 0-16.6 8.12-16.6 18.15s7.43 18.19 16.6 18.15h.72a13.08 13.08 0 0 0 9.14-4v3.5H199v-35.3zm-8.81 26.82a9.06 9.06 0 0 1-8.88-9.23 8.85 8.85 0 1 1 17.69 0 9 9 0 0 1-8.81 9.23z"></path>
  </Svg>
);

export const BirchboxLogo = () => (
  <Svg viewBox="0 0 535.3 61">
    <path d="M497.332 30.524l19.021-19.021 19.021 19.02-19.02 19.022zM44.8 30.1c6.8-6.1 7.4-16.5 1.3-23.3-3.1-3.4-7.6-5.4-12.3-5.4H0v58.2h34.7c9.1 0 16.5-7.4 16.5-16.4 0-5.1-2.3-9.9-6.4-13.1M7.7 9.1h26.1c4.8 0 8.8 3.9 8.8 8.8s-3.9 8.8-8.8 8.8H7.7V9.1zm27 42.8h-27V34.4h27c4.8 0 8.8 3.9 8.8 8.8s-3.9 8.7-8.8 8.7m306.1-21.8c6.8-6.1 7.4-16.5 1.3-23.3-3.1-3.5-7.6-5.5-12.3-5.5H296v58.2h34.7c9.1 0 16.5-7.4 16.5-16.5 0-4.9-2.3-9.7-6.4-12.9m-37.1-21h26.1c4.8 0 8.8 3.9 8.8 8.8s-3.9 8.8-8.8 8.8h-26.1V9.1zm27 42.8h-27V34.4h27c4.8 0 8.8 3.9 8.8 8.8s-3.9 8.7-8.8 8.7M68.1 1.4h7.7v58.2h-7.7V1.4zM391.8 0c-16.9 0-30.5 13.7-30.5 30.5 0 16.9 13.7 30.5 30.5 30.5s30.5-13.7 30.5-30.5S408.6 0 391.8 0m0 53.3c-12.6 0-22.8-10.2-22.8-22.8s10.2-22.8 22.8-22.8c12.6 0 22.8 10.2 22.8 22.8-.1 12.6-10.3 22.8-22.8 22.8m-231-22.8c0 12.6 10.2 22.8 22.8 22.8 7.5 0 14.6-3.7 18.8-9.9l2.2-3.2 6.4 4.4-2.2 3.2c-9.5 13.9-28.5 17.5-42.4 7.9s-17.5-28.5-7.9-42.4C168-.6 187-4.2 200.9 5.4c3.1 2.1 5.8 4.8 7.9 7.9l2.2 3.2-6.4 4.4-2.2-3.2c-7.1-10.4-21.3-13.1-31.7-6-6.2 4.2-9.9 11.3-9.9 18.8M269.2 1.4h7.7v58.2h-7.7V35.5h-35.4v24.1h-7.7V1.4h7.7v26.4h35.4V1.4zm-143.7 33c9.1 0 16.5-7.4 16.5-16.5s-7.4-16.5-16.5-16.5H94.7v58.2h7.7V34.4h9.8l20.1 25.2h9.9l-20.1-25.2h3.4zm-23.1-7.8V9.1h23.1c4.8 0 8.8 3.9 8.8 8.8s-3.9 8.8-8.8 8.8h-23.1zm359.4 3.1l24.5 29.9h-10l-19.5-23.8-19.5 23.8h-10l24.5-29.9-23.1-28.3h10l18.2 22.2L475 1.4h10l-23.2 28.3z" />
  </Svg>
);

export const CultureTripLogo = () => (
  <Svg viewBox="0 0 575 98">
    <g fill="#fff" fillRule="evenodd">
      <path
        d="M48.781 6.446c-.283 0-.565.003-.847.009-12.964.339-23.406 11.01-23.406 24.078 0 5.242 1.68 10.099 4.53 14.058a30.073 30.073 0 0 1 19.512-7.165h19.456V6.446H48.781zM29.058 53.655a23.987 23.987 0 0 0-4.53 14.059c0 13.066 10.439 23.736 23.4 24.078.284.006.568.009.853.009h19.245V60.82H48.57a30.073 30.073 0 0 1-19.512-7.165zm-6.967 28.679a30.137 30.137 0 0 1-3.763-14.62 30.176 30.176 0 0 1 6.382-18.591 30.171 30.171 0 0 1-6.382-18.59c0-5.327 1.38-10.336 3.801-14.689C12.422 23.656 6.2 35.634 6.2 49.037c0 13.441 6.205 25.452 15.891 33.297zM48.57.247h25.657v43.378H48.57a23.912 23.912 0 0 0-15.272 5.498 23.906 23.906 0 0 0 15.272 5.498h25.657V98H48.57c-.263 0-.525-.003-.786-.01C21.344 97.455 0 75.701 0 49.037 0 22.466 21.348.787 47.79.257c.259-.007.519-.01.78-.01zm515.586 49.537c0-10.415-7.165-15.384-14.332-15.384-7.262 0-14.525 5.065-14.525 15.289 0 10.415 7.359 15.67 14.62 15.67 7.262 0 14.237-5.255 14.237-15.575zm10.511.096c0 16.339-11.562 25.13-23.41 25.13-5.637 0-11.753-2.102-15.958-6.88v26.06h-10.606V25.801h10.416v6.593c3.44-4.587 9.173-7.453 15.957-7.453 11.275 0 23.601 8.313 23.601 24.939zM509.831 3.346c-4.3 0-7.549 3.249-7.549 7.549 0 4.299 3.249 7.549 7.549 7.549 4.299 0 7.644-3.25 7.644-7.549 0-4.3-3.345-7.549-7.644-7.549zm-5.256 70.613h10.606V25.801h-10.606v48.158zM479.733 31.63v-5.829h-10.414v48.158h10.606V47.301c0-8.314 4.491-11.562 9.842-11.562 2.006 0 4.108.382 6.115 1.242l2.389-10.702c-1.815-.669-4.109-1.147-6.307-1.147-4.682 0-9.65 1.816-12.231 6.498zm-27.325 34.112c-3.727 0-6.784-2.006-6.784-7.358V35.547h14.237v-9.746h-14.237V13.475h-10.511v12.326h-10.415v9.746h10.415v23.411c0 11.083 7.644 16.052 15.862 16.052 3.917 0 8.122-1.146 11.657-3.248l-3.823-7.836c-2.102 1.051-4.299 1.816-6.401 1.816zm-57.066-19.971c-.191-7.93-5.733-11.752-11.849-11.752-6.211 0-12.039 3.917-12.899 11.752h24.748zm10.606 2.771c0 1.625 0 3.536-.382 6.02H370.88c1.625 7.549 7.74 10.511 13.951 10.511 5.255 0 10.224-2.102 13.569-6.784l6.784 6.593c-5.352 6.784-12.708 10.128-20.735 10.128-12.517 0-25.035-8.886-25.035-25.417 0-16.434 12.04-25.034 24.557-25.034 11.753 0 21.977 7.739 21.977 23.983zM339.612 31.63v-5.829h-10.415v48.158h10.606V47.301c0-8.314 4.491-11.562 9.842-11.562 2.006 0 4.108.382 6.115 1.242l2.389-10.702c-1.815-.669-4.109-1.147-6.307-1.147-4.682 0-9.651 1.816-12.23 6.498zm-30.564 18.728c0 9.364-5.925 14.141-12.04 14.141-5.447 0-9.46-3.726-9.46-11.083V25.801h-10.511v30.29c0 13.187 9.269 18.919 17.965 18.919 6.306 0 10.988-2.771 14.237-7.452v6.401h10.415V25.801h-10.606v24.557zm-49.112 15.384c-3.727 0-6.785-2.006-6.785-7.358V35.547h14.429v-9.746h-14.429V13.475h-10.51v12.326h-9.257v9.746h9.257v23.411c0 11.083 7.644 16.052 15.862 16.052 3.917 0 8.121-1.146 11.657-3.248l-3.822-7.836c-2.102 1.051-4.3 1.816-6.402 1.816zm-29.88 0c-3.44 0-6.116-1.911-6.116-7.358V13.475h-10.606v45.483c0 11.466 7.167 16.052 15.002 16.052 3.153 0 6.402-.764 9.365-2.197l-3.441-7.931c-1.433.573-2.866.86-4.204.86zm-36.872-15.384c0 9.364-5.924 14.141-12.039 14.141-5.447 0-9.46-3.726-9.46-11.083V25.801h-10.51v30.29c0 13.187 9.268 18.919 17.963 18.919 6.306 0 10.989-2.771 14.237-7.452v6.401h10.416V25.801h-10.607v24.557zm-44.925 6.02l7.74 5.351c-4.491 8.6-13.282 13.281-22.073 13.281-12.135 0-24.174-8.791-24.174-25.226 0-16.721 12.23-25.225 24.556-25.225 7.358 0 14.811 3.057 19.684 9.555l-7.071 6.689c-2.962-4.587-7.644-6.498-12.135-6.498-7.262 0-14.619 5.16-14.619 15.384 0 10.033 7.262 15.288 14.428 15.288 4.586 0 10.415-2.197 13.664-8.599z"
        id="a"
      />
    </g>
  </Svg>
);

export const EddieBauerLogo = () => (
  <Svg viewBox="0 0 571 91.5">
    <path
      fill="#231f20"
      fillRule="evenodd"
      d="M118.3 0l-8.8.8a55.8 55.8 0 00-14.2 3.5c-2.3 1-2.3 1-6.5 3.4l-2.3 1.6a42 42 0 00-6 6.7c-.5.9-1 1.8-1.4 3-.4.9-.7 1.8-.9 2.9V26l1 4 .7 1.2-.1.7-.4.2a81 81 0 00-4.9.1l-7.7 1-7 2.1c-2 1-2 1-2.5 1.1-3 1.6-3.4 2-3.8 2.1L50 41.1l-2.4 2-3.2 3.1v.4l-1.9 2.1c-1.7 2.8-1.7 2.8-3.1 5.5L38 57.3c-.7 2.6-.7 2.6-1 4.7l-.1 4.2c-.4.9-.4.9-1 1.5-12 4.6-13 5-19.8 7.4C8 77.9 8 77.9 1.6 79.8l-1.1.8-.5 1v2.2l.7 1.6c1.3.7 1.3.7 2 .9h1.6l1.4-.3c13-4.2 14.8-5 19-6.3l14-5.5H40l2.3 2.2.7.4.7.8h.3l.9.8 4.4 2.3 4.7 1.4c2 .4 2 .4 5.4.7h6c3.3-.3 3.3-.3 7.2-1l7.2-2.1 5.4-2.1 5.5-2.5 8.5-4.6c.3 0 .3 0 .7.3 1 1.7 1 1.7 1.3 2.5l2.3 3 1.3 1c1.5 1 1.5 1 2.5 1.3l1.5.3c2.5 0 2.5 0 5.3-.3l5.2-1.4c4-1.6 4-1.6 4.6-1.7l6.5-3.2 4.7-2.6 1.7-1c.4 0 .4 0 1 .5a2783.1 2783.1 0 003.3 4l2.2 1.2c2 .7 2 .7 3.5 1 3.7.2 3.7.2 5.7 0 1.1-.1 2.4-.4 3.6-.7 4.6-1.3 4.6-1.3 7.2-2.3h1.4l1.5 2 1.7 1.7 2 1.1c1.3.4 1.3.4 2.2.5l6-.1 6-1.5c1-.2 1.9-.6 2.9-1 4.2-2.1 4.6-2.5 7-3.7.8 0 .8 0 1.2.2 1.1 1.3 1.1 1.3 1.3 1.8 1.5 1.5 1.5 1.5 2.3 2 .4.2 1.4 1 3 1.6l2.3.6h2.8l3.8-1 4.8-3.1 2.2-2h.8l.7.4c.4.7 1 1.4 1.6 2 2 1.9 2 1.9 3 2.6l3.2 1c1.5 0 3.1 0 4.8.2l2.5-.3c5-1.4 5-1.4 8-2.5h.8l2.5 1.4 3 1 3.4.6c2.1 0 2.1 0 4.8-.3l4.6-1.5 5-2.7 3.2-2.3c0-.2.3-.4.5-.6 0 0 .3 0 .4-.2l.6-.6.7-.4c.8-.9 4.3-4.2 7.8-8l2.6-2.6.4-.7 1.5-1.4.6-.9c15-16.4 15-16.4 17.7-19.1l.6-.4 3.7-3.5.6-.4c.8-.9.8-.9 3.6-3.2h.3l.4-.5 5-3.5c3-1.5 3-1.5 5-2.3h3.5l1.2.9.8 1.1v1.3c0 .3-.3.6-.5.8l-3.1 2.6a4 4 0 00-.6.7s-.3 0-.5.2l-7.6 7c-6.7 6.6-7.7 7.8-8.5 8.6-.9 1.1-2.5 3-3.2 3.5 0 0 0 .3-.2.5l-.8.7c-.3.6-.8 1-1.2 1.7-.4.3-.4.3-3 3.5v.4l-1 1c-1 1.6-2 3.2-3.2 4.8-1 1.7-2 3.5-2.9 5.4l-.7 1.6-1 3.8v2.8c0 .4.3 1 .5 1.4.7 1 .7 1 1.3 1.3l2 .5h2l1.8-.3 5.5-2 4.3-2.7 1-.8a8 8 0 001-.8l4-3.3 4.1-4.3c1.7-2.1 3.4-4.2 5.3-6.3.1-.5 1-1.5 1.5-2.3l.7-.9.1-.4.8-.8c3.3-5 3.4-5.5 5-8l.5-.1h.9c.1.3.3.4.5.6l1.2.7 1.6.4h4.3l5.5-.7 4.2-.7 1.6.1 1.7 1.3 1.2 1.8.7 2.7v4.5l-.5 1-1.2.9c-6.7 1.3-6.7 1.3-12.8 2.7l-9.2 2.8-6.7 2.9c-3.5 1.8-4 2.3-4.9 2.8-1 .8-1 .8-2 2l-.8 1.2-.6 2.3V79l.8 2.7 1.8 2.7 1.2 1.2c.5.2.5.2 2 1.5 1 .4 2.3 1.3 5.4 2.7l5 1.4a25.3 25.3 0 007.6 0c3.1-.7 3.1-.7 5.2-1.4 1.2-.6 2.1-.8 3.4-1.6l.8-.3c3.3-2.1 3.3-2.1 4.9-3.3l3-2.7 2-2.2c.3-.6 1.2-1.5 3-4l1.5-2.8 2.1-5.3 1-4.3.4-.2c1.7-.4 1.7-.4 4.7-.8l5-.2 4.6.4.7.4v1c-.2.8-.6 1.5-1 2.3 0 .5-.2 1-.4 1.6v2.4l.8 2.6c.5.8.9 1.2 1 1.6.7.7.7.7 2 1.6.8.2 1.6.6 2.4 1l1.9.4h2.3l4-.8 2-.6 5.1-2.6c.9-.8 1.4-1 4.4-3.6l.2-.2.9-.4h.7l.5.5 1 2.1 1.3 1.7L413 75c.4 0 .8.2 1.2.4h2l2.2-.2 2.1-.8 2.8-1.5 2.8-2 1.9-1.5h1l.5.7c.7 1.5 1.5 2.5 1.5 2.9l1.9 1.8 1 .6c2 .6 2 .6 3.3.8h1.5c2-.3 2-.3 3.7-.8l3.2-1.6L448 72l3.5-3.1h1c.6 1.4.6 1.4 1.4 2.7l1.3 1.7h.5l.9.8 2.6 1.3 3 .6c1.9.2 1.9.2 4.4.2 3-.3 3-.3 6.1-1l2.1-.8h1.4c1.2.2 1.2.2 3 1l4.2.6h4.9l3.6-.6 3-1 3.8-2c.7-.7 1.5-1.2 2.4-1.8l4.2-4a420 420 0 005.1-6.8c2-3 2-3 2.6-4.2l.9-.6c.5 0 .5 0 2.4.7l1.7 1.3v2.5c-.2 1-.2 1-2.3 6l-.4 1.4v1.3l.4 1.3.8 1.4c2 2.4 2 2.4 3.1 3.4l2 1.4 1.3.5h3l6.7-2 3.1-1.5 9.8-5 11-6.2 5.6-2.8 2.3-.9h1.8l1 1v2l-.6 2.4.1.5.5.1 1-.7 2.1-4.2.7-2.4v-3.2l-.8-2c-.2-.5-.5-.9-.8-1.2l-1-.9c-.6 0-1.1-.3-1.7-.5h-3l-2.7.7-2.9 1c-5.7 3-5.7 3-6.1 3l-7.8 4.6c-5.1 3-5.1 3-7.6 4.8L531 66l-2.4 1-2.1.6h-2l-1-.4-.5-.5-.3-1V65c.2-.7.3-1.4.6-2l.8-1.2 2.1-5.4v-2.7l-.9-1.7-1.5-1.4-1.7-.8-2.5-.9-1.2-.6c-.9-.8-1.4-1-1.6-1.3l-2.6-1.6-1.4-.4h-1.4l-1.3.4L508 47l-1.3 2.3c-.2.9-.2.9-.2 2.5l1 2v1.3l-2.5 4.2c-2.3 2.6-2.3 2.6-4.4 4.6-.9.7-1.7 1.4-2.7 2-.4.1-1.4.9-4 2.2-1.8.8-1.8.8-4.1 1.5l-2.1.3h-1.5c-.1 0-.3 0-.5-.2 0-.1 0-.4.2-.7l1.2-.9 4.7-4.3c.4-.6.9-1 1.2-1.7l.5-.4 1.8-2.8 1.7-4v-2.7l-1.5-3.6a227 227 0 00-1.9-2.5l-1.7-1.1-1.1-.3-3.2.1-3 .8c-1.8.6-1.8.6-3.9 1.7l-2.7 1.9c-1 .9-1.5 1.2-3.3 3.3l-1.6 2c-.1.4-.9 1.5-2 3.6-.2 1-.6 2-1 3.1l-.3 2.1.1 3.6.6 1.7v1l-.6.8-1.2.6c-1.3.2-1.3.2-4 .2l-1.7-.4-2.3-1.4-.9-1.5-.4-1.2v-5l1-3.4v-.9l-.4-.7c-.6-.4-.6-.4-2.7-1.2h-2.7l-.6.4-.9 1-1.3 2.6c-2 2.7-2 2.7-2.2 3.3l-3.3 3.2-1.5 1-2.4 1-1.9.3h-1.8l-1.3-.3-1.6-1.2-.6-1.4V63l1.1-3.2c.8-1.3.8-1.3 1.2-2.6l-.1-1.2a10 10 0 00-1.1-.6c-.5 0-1-.2-1.6-.4h-2.1l-1 .4-1.2 1-1.6 2.6-4.4 5.1-2.1 1.6-3.2 1.5h-2.7l-1.3-.4-1.4-.9-1.2-1.5v-2l2.7-4.5c0-.5.3-1 .5-1.5v-2l-.5-1.4-2.6-2.5-1.3-.7-3-.9h-4.1l-3.6.7-3.2 1-4.4 2.1-5.9 3.8a1402.6 1402.6 0 00-20.7.3l-.6-.3c-.4-.9-.4-.9-1-3.3l-1.5-3.3-1.5-2.3c-2.8-2.7-2.8-2.7-3-3.2l.1-.6c1.7-.9 5-2.2 7.9-3.7.4-.3 1.2-.6 2.2-1.4.7-.3.7-.3 3.9-2.4l.8-.8h.4l6-5.2 4-4.3c1.3-2 1.3-2 1.6-2.1l1.6-2.8 1.8-3.8.9-3.7V10l-.8-2.5-1.1-2.1c-2.2-1.9-2.2-1.9-3.5-2.6-1.7-.7-1.7-.7-3.1-1l-2.7-.4c-3.4.2-3.4.2-5.6.5l-5 1.4-5 1.8c-6.1 2.8-6.1 2.8-11.5 5.6l-5.4 3c-9.4 5.8-9.4 5.8-10 6h-1.5l-.8-.4-2-1.8-2.4-1c-1.3-.4-1.3-.4-4.3-.5l-4 .6-2.7 1c-2.7 1.5-2.7 1.5-7 4.2-.2.3-2 1.6-2.4 2l-.4.2-.7.7-.4.1c-.5.6-2.4 2.1-4 3.8a177.8 177.8 0 00-12.1 12.2l-.2.5-1.8 1.7-.1.4-2.9 3-.4.6-1.3 1.2-3.5 4-1.2 1.2-.4.7-6.2 6.6-.7.3-1.4 1.6-.7.4-.7.8c-2.4 1.8-2.4 1.8-2.6 2.1l-.4.1c-.8.8-.8.8-3.5 2.5L261 70l-2.5 1-2.3.6h-3l-1.4-.7c-.2-.5-.2-.5-.2-1.2l1.4-1.2 4-2.9 4.4-4.2s0-.3.2-.4l.5-.5 2.3-4 .3-1.3v-3l-.3-1.4-.7-1.9-1.7-2.5-1.7-1.4-1.6-.8c-.6 0-1.1-.2-1.7-.3h-1.6c-.8 0-1.6.1-2.3.3l-2.2.7-2.9 1.4-2.1 1.5c-.9.8-1.3 1.1-3.2 3.2l-2.1 2.6-1.3 2.1-1.7 4.6-.4 2.3.2 3 1.2 3.3v1.3c-.5.5-.5.5-1.6 1l-3.3.7-3.4-.1-1.7-.7-1.5-1-.9-2c0-.7 0-1.4-.2-2l.4-1.8 1.7-2.8c2.6-2.2 2.6-2.2 3-2.7.5-.1.5-.1.9-.5l.5-1.2v-.8l-.6-1.5c-1-1-1-1-2.4-1.8-.3 0-.7-.2-1-.4h-1.1l-1 .4-2.9 2.5v.4c-1.1 1.1-1.4 1.7-1.7 2-1 1.5-1.9 3.2-2.8 5-.3.2-.8 1-2.5 3.1l-3.8 3.2-2.8 1h-3.7l-1.8-.7L203 68l-.7-1.3v-1.3l.4-1c2.2-1.7 4-3.4 5-4.3l4.4-4.7L213 54c.6-.5 1-1.3 1.5-1.5.7-1.2 1.6-2.1 4.5-6.2l4.4-7.1v-.6l.8-1.3 1.3-4v-3.1c-.2-.7-.2-.7-.8-1.5-.6-.6-.6-.6-1.3-1l-1.2-.4h-1.6l-2.1.4-2 .7-3.8 1.9c-1.2 1-1.7 1.1-1.9 1.4l-1 .7c-4 3.6-4 3.6-6.1 5.7l-3.3 4c-.2.4-1.6 2.3-3.5 5.5-1.4 3-2.1 4.8-2.9 6.2l-.4.2c-1.7 0-4.2-.2-10.3-.2l-7.1 1-3.4 1.1-2.3 1-3 2.2-1.8 1.9-1.6 3a26 26 0 01-.6 2l-.8 1.3-1.4.7-3.2 1-3.3.6h-3l-1.7-.3-1.6-.8-1.4-1-1-1.5-.1-1.8c0-.3.3-.7.4-1l4-3c1.2-1 1.9-1.3 2.3-1.8 2-1.6 2-1.6 3.9-3.5l.5-.2 1.7-1.8.6-.3 6.8-7.1 2.4-2.7c.3-.6 1.2-1.5 1.3-2 .2 0 .2 0 2-2.7l1.2-3v-2.9l-.8-1.6-1.2-1c-.3 0-.7-.2-1-.4h-3.6l-4 1.1-4.6 2.1a415 415 0 00-5 3.3c-1 .9-1.6 1.2-2 1.7l-.6.3c-.8 1-4.2 4.2-6.6 6.7-.3.5-.9 1-1.2 1.6-.3.2-.3.2-2.7 3.7-.1.4-.1.4-2.1 3.8-.3 1-.3 1-1.4 3.2l-.7.6h-.8c-1.5-.4-3-1-4.7-1.4l-5.8-1.2c-7-.1-7-.1-8.7 0-3.5.7-3.5.7-5.8 1.4l-1.8.7-2.6 1.4-1 .7-3.3 3a71 71 0 01-2.5 3.2l-1.4 1-7.7 4c-1 .3-2.3 1-4.1 1.8l-6.6 2.4-3.7 1-5.3 1h-5.2l-3.8-.7-3.4-1.5-2.6-2c0-.5 0-.5-.8-1.8l-.2-1.1c.2-.6.2-.6.6-1 .2-.3.5-.5 1-.7 6.9-3.2 8.7-3.9 9.4-4.2 3.3-1.4 4.8-2.1 5.8-2.4l6.8-3c.2 0 .4 0 .6-.2l6.5-3 .6-.1 13-6c1.8-1 3.7-1.9 5.7-2.8 12.6-6.5 13.5-7.1 16.3-8.4 10-5.7 10-5.7 11-6.1l7.4-4.8c4.2-3.2 4.4-3.5 5-3.8l.8-.8.3-.1c2-2 2-2 4.1-4.5l1.5-2.7.3-1.2v-2.1l-.3-1-1-1.7-2.7-2.5a20 20 0 00-3.3-1.9c-.8-.4-1.5-.8-5.7-2-1.5-.5-3-.9-4.6-1.1-5.3-.8-5.3-.8-8-.9h-6.7zm5.9 6.3l-6.1.8a39 39 0 00-9.7 2.5l-3 1.2c-1.8.8-3.6 1.9-5.4 3-.9.5-1.8 1-2.6 1.7-2.2 2-4 4-4.4 4.5-.5.5-.9 1.2-1.3 1.9l-1 2.3-.3 1.2V29l.3 1.5c.2.7.6 1.3 1 2l1.6 1.9c1.4 1 1.4 1 3.3 2l5 1.7h3.2l2.1-.6c1.5-.8 1.5-.8 2.5-1l9.3-4.9c.4-.4 1.9-1 2.3-1.4.8-.3 3.4-2 5-2.8l3.8-2.5c1.3-.6 4.9-3 5.7-3.6.2-.2.8-.5 4.6-4 .7-.6 1.3-1.4 1.8-2.2.2-.4.5-1 .6-1.6.2-.8.1-1.6 0-2.3l-.3-.9c-.3-.2-.2-.3-.5-.6-.7-.7-1-1-2.2-1.6a14 14 0 00-2.8-1c-1.3-.3-2.7-.6-4.2-.7-2.8-.2-5.5 0-8.3 0zm246 2.1l-2.8.8-5.2 2L355 15l-2.3 1.4-7.3 4.4-2.2 1.6c-1.4.8-1.6 1.1-4.2 2.8l-1.4 1.3h-.3s0 .3-.2.4l-.3.1-.5 1.4-.7 3.7c-1 3.4-1 3.4-2 6.1v1c.1.3.1.3.6.3l1.4-.9 3.4-1.1h5.8c1.3.2 2.7.6 4 1l2.7 1.2h2.4l1.1-.2 2-1 4.3-3.1c2.2-2 2.9-2.3 3.4-3l2.3-2.1.7-.4 4.5-5.2c.4-.8 1-1.5 3.2-5.5.2-1 .6-1.9 1-3l.3-1.6v-3.4l-.3-.9-1.2-1.2-1.7-.5c-1 0-2 0-3.2-.2zm-136 21l-1.5.7-.7.6v1.2l4.3 4.4 2 3.3v.4l.5.5h1.7l.7-.5.7-1.2v-1.2l-.7-2.2-1.4-2.6a30 30 0 00-1.6-2c-1-.8-1-.8-2-1.2-.6 0-1.3 0-2-.2zm-18.6 4.4c-.4.4-1.1.7-1.8 1.2-.2.3-.6.4-1.5 1.4l-.4.1c-1.6 2-1.6 2-2.1 2.3-.3.6-.8 1-1.2 1.6l-.3.2c-2.1 3.3-2.6 4.2-3 4.6l-2.5 5.2a62 62 0 01-1 4v2.2l.3.3h.6l1-.5V56l.8-.5L208 52l1.2-1.7L211 48c2.1-3 2.2-3.3 3-4.2l1.2-2c.7-1.2 1.4-2.4 2-3.8l.7-1.9v-1.7c0-.1 0-.3-.2-.5-.6 0-1.3 0-2-.2zm-51.8.4l-1 .2c-.9.5-1.8 1-2.9 1.4-.6.6-1 .7-3.9 2.8l-2 2c-.3.1-.7.7-1.6 1.5-1.8 2.2-1.8 2.2-2 2.7l-.4.2-2.3 3.5-1.4 2.7-1 2.8v2.2l.2.4 1-.1c1.8-1.4 2.1-1.8 2.8-2.2l2-2 .7-.3 2-2.1c1.5-1.5 1.6-1.7 2.2-2.1l1.4-1.5.1-.3 1.3-1.2 3.5-4.4 2.4-4v-1.7l-1-.5zM326 35.5l-2.8 2.2-.1.3c-1 .8-1.5 1.4-2 1.6l-3.4 3.2c-1.1 1-2 2-2.5 2.3-.4.6-3.7 3.8-4.2 4.2-.4.6-.9 1-3.7 4.1-.5.5-1 1.2-2 2.1l-.6 1h-.3l-.1.5c-.5.5-.5.5-.8.6-.9 1.4-1.2 1.6-1.3 2l-2 2.3-.1.6-1.8 2.7-.9 2v1.6l.3.4c1.8-.1 1.8-.1 2.4-.3 2.2-1.4 2.2-1.4 6.2-4.5 3.6-3.6 4.2-4 4.6-4.6l1.9-1.8 4.5-5.4 2.6-3.5 4.2-6.8c.7-1.3 1.4-2.7 2-4.2l.5-1.4v-1c-.2 0-.4 0-.6-.2zm-244.5 2s-4.4.8-7 1.5l-3.7 1.4-2.8 1.4-4.9 3.1a136 136 0 00-4 3.6l-1.7 2c-.7 1.3-.7 1.3-1.3 1.9-.2.5-.7 1.2-2.1 4.5-.3 1.5-.3 1.5-.3 2.7.2.4.2.4.6.7L56 60c.2-.2 1.3-.5 4-1.5.2-.2 10.5-4.4 10.7-4.6 1.3-.6 2-.7 6.8-2.8.6-.4 8-3.5 9-4 .2-.2.6-.3 1-.4l3.2-1.6 4-1.7 1-.8V41l-2.3-1.4c-1.6-.7-1.6-.7-3.8-1.4l-3.1-.6-5-.1zm405.3 12.8l-3 1.1-3 2.5c-1.6 1.8-1.6 1.8-2.4 3l-.6 1.5-.6 2.4V63l.4 1.2c.3.5.5 1 1 1.5h1l2.2-1.8c1.8-1.9 2.4-2.3 2.7-2.8l1-1 2.1-2.7 1-2 .3-1.3v-2.2l-.3-1c-.5-.3-.5-.3-1.8-.6zm-233 .5l-3.2 1.7-1.7 1.4-2.2 2.7c-.4.8-.8 1.2-1 2-.3.3-.3.3-.8 2.4v3c.1.5.4 1 .7 1.6l.4.4h2l2.5-1.6 5.1-3.8 1.5-1.5c.6-.8 1.1-1.7 1.8-2.5 0-.3.2-.6.4-1V53l-1.4-1.5c-.3 0-.7-.2-1.1-.4-1 0-2 0-3-.2zm147.8 4l-2.7.8-4.2 2.1c-2.2 1.7-2.2 1.7-4 3.5-.4.7-.8 1-1 1.5l-.4.2-1 2.3v2.5l.9 1.4 1 .3h3.5l1.4-.3 3.2-1.5 3.4-2.3.1-.3 1.5-1.3c.5-.6 1.3-1.4 2.7-3.3l1-2.5v-1c-.2-.7-.2-.7-.7-1.4-.4 0-.9-.3-1.3-.5-1 0-2.2 0-3.4-.2zM187.8 58l-4.8.8-2.3.7-3 1.6-2 1.8-1.2 2c-.2.8-.2.8-.2 2.6l.4 1.2 1 1.6 2 1 1.9.5h2.6l3.3-.7 3.4-1.4 2.4-1.8.7-.8.6-1.6c.2-4.4.2-4.4 0-6.8-.4-.4-.4-.4-1-.6l-3.8-.1zm-67.6 1.6l-1.3.2-3.1 1c-1.4 1.1-1.4 1.1-2 1.3-1 1-1 1-1.8 2.2l-.5 1V68c.8 1.2.8 1.2 1.6 2 1 .7 1 .7 2 1l1.4.4h3.9c1.7-.3 1.7-.3 3.5-.9.2-.2.9-.3 2.3-1l.9-.3c4.4-2.5 4.7-2.9 6-3.7 1-.7 1-.7 1.5-1.4 0-1.1 0-1.1-.2-1.6l-3-1.3-6.4-1.4h-4.8zm229.2 6.1l-11 2.5-6.8 2.1-4.6 2.1-1.7 1.2-.9 1-.3.8.1 2.8 1 3 .9 1.2 1.3 1.5c.5 0 .5 0 2.2 1l3.7.1 1.3-.3
       1.9-.8c3.3-2.5 3.5-2.8 4-3l3.1-3.3c1.6-2.2 3-4.4 4.7-6.6l2-4v-1l-1-.3"
    />
  </Svg>
);

export const BlockchainLogo = () => (
  <Svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 397.4 43.7">
    <path d="M151.7 29.7c-2.1 2.2-5.1 3.6-8.3 3.6-6.3 0-11.5-5.2-11.5-11.5s5.2-11.5 11.5-11.5c2.9 0 5.6 1.1 7.6 2.9.6.5 1.7 1.6 1.7 1.6l7-7.5c-4-4.5-9.8-7.3-16.3-7.3-12 0-21.8 9.7-21.8 21.8 0 12 9.7 21.8 21.8 21.8 6.8 0 12.9-3 16.8-8l-7-7.5C153.1 28.2 152.2 29.2 151.7 29.7zM234.5 29.7c-2.1 2.2-5.1 3.6-8.3 3.6-6.3 0-11.5-5.2-11.5-11.5s5.2-11.5 11.5-11.5c2.9 0 5.6 1.1 7.6 2.9.6.5 1.7 1.6 1.7 1.6l7-7.5c-4-4.5-9.8-7.3-16.3-7.3-12 0-21.8 9.7-21.8 21.8 0 12 9.7 21.8 21.8 21.8 6.8 0 12.9-3 16.8-8l-7-7.5C236 28.2 235 29.2 234.5 29.7zM29.5 20.9c3.7-1.6 6.4-4.5 6.4-9.3v-.1c0-2.9-1-5.1-2.7-6.8C30.7 2.3 27 .9 21.8.9H0v41.8h21.9c10 0 15.8-4.4 15.8-11.5v-.1C37.7 25.5 34.5 22.6 29.5 20.9zM11.7 10.2h7.5c3.5 0 5.2 1.4 5.2 3.6v.1c0 2.5-1.9 3.6-5.5 3.6h-7.3L11.7 10.2 11.7 10.2zM26.2 29.6c0 2.5-2 3.8-5.6 3.8h-9v-7.7h8.8C24.3 25.7 26.1 27.3 26.2 29.6L26.2 29.6 26.2 29.6z" />
    <polygon points="54.6,0.9 42.9,0.9 42.9,42.7 73.4,42.7 73.4,32.7 54.6,32.7" />
    <polygon points="273.3,16.8 258.4,16.8 258.4,1.1 246.7,1.1 246.7,43 258.4,43 258.4,27.1 273.3,27.1 273.3,43 284.9,43 284.9,1.2 273.3,1.2" />
    <path d="M317.7,0.8h-11.2L288.7,43h12.2l3-7.5H320l3,7.5h12.4L317.7,0.8z M307.2,26.5l4.7-11.9l4.7,11.9 C316.6,26.5,307.2,26.5,307.2,26.5z" />
    <rect x="339.1" y="1.2" width="11.6" height="41.9" />
    <polygon points="385.8,1.2 385.8,23.3 368.5,1.2 357.5,1.2 357.5,43 369.2,43 369.2,20.1 387.1,43 397.4,43 397.4,1.2" />
    <polygon points="205.4,1 191.6,1 191.6,1 191.6,1 177.2,18 177.2,1 165.6,1 165.6,42.9 177.2,42.9 177.2,32.1 181.5,27.4 193.2,42.9 193.2,42.9 193.2,42.9 207,42.9 189.1,19" />
    <path d="M96.6,0c-12,0-21.8,9.7-21.8,21.8c0,12,9.7,21.8,21.8,21.8c12,0,21.8-9.7,21.8-21.8C118.4,9.8,108.7,0,96.6,0z M96.6,33.3c-6.3,0-11.5-5.2-11.5-11.5s5.2-11.5,11.5-11.5c6.3,0,11.5,5.2,11.5,11.5S102.9,33.3,96.6,33.3z" />
  </Svg>
);

export const SmartLogo = () => (
  <Svg viewBox="0 0 749 164" fill="none">
    <path
      fillRule="evenodd"
      clipRule="evenodd"
      d="M109.593 30.8537C125.507 41.1661 148.434 73.3379 154.592 91.1005C148.434 108.912 125.507 141.003 109.593 151.338V30.8537Z"
      fill="white"
    />
    <path
      fillRule="evenodd"
      clipRule="evenodd"
      d="M75.5369 53.7002C83.8524 53.7002 94.4702 57.0026 102.799 62.9578V26.7024C94.5057 21.5412 84.3959 18.5124 72.5659 18.5124C32.4418 18.5124 0 51.0119 0 91.1005C0 131.225 32.4418 163.599 72.5659 163.599C84.3959 163.599 94.5057 160.686 102.799 155.499V119.144C94.4702 125.099 83.8524 128.501 75.5369 128.501C52.9636 128.501 36.3681 112.008 36.3681 91.1005C36.3681 70.0933 52.9636 53.7002 75.5369 53.7002ZM615.232 81.3898V155.499H640.606V82.8432C640.606 72.6562 648.922 64.4981 658.938 64.4981H670.659V40.2817L657.668 40.2463C634.744 40.4844 616.161 58.5106 615.232 81.3898ZM727.559 131.202C717.497 131.202 709.284 122.896 709.272 112.857C709.272 112.857 709.272 66.9164 709.272 64.3759C711.712 64.3759 737.324 64.3759 737.324 64.3759V40.1435C737.324 40.1435 711.712 40.1435 709.272 40.1435C709.272 37.7865 709.272 17.3448 709.272 17.3448H683.772V114.253C684.701 137.167 703.451 155.158 726.266 155.431L739.276 155.4V131.202H727.559ZM422.635 37.9889C410.02 37.9889 398.042 43.7641 390.171 53.4044C382.331 43.7641 370.237 37.9889 357.591 37.9889C335.458 37.9889 317.116 55.2887 315.923 77.3989L315.913 155.499H341.471V80.573C341.471 70.0933 349.333 62.0029 359.382 62.0029C367.674 62.0029 377.443 67.6205 377.443 83.5473V155.499H402.885V83.4764C402.885 68.7076 412.178 62.0029 420.831 62.0029C431.529 62.0029 438.845 69.5916 438.845 80.573V155.499H464.29V77.4666C462.997 55.2887 444.768 37.9889 422.635 37.9889ZM539.068 38.2624C506.128 38.2624 480.284 64.3181 480.284 97.7474C480.284 132.643 505.208 157.904 539.534 157.904C552.863 157.904 564.809 152.959 572.352 144.656V155.49H597.784V98.2134C597.784 63.4114 573.008 38.2624 539.068 38.2624ZM539.409 133.459C520.328 133.459 504.89 117.497 504.89 98.1106C504.89 78.7015 520.328 62.7874 539.409 62.7874C558.355 62.7874 573.78 78.7015 573.78 98.1106C573.78 118.861 559.67 133.459 539.409 133.459ZM256.608 86.5633C231.958 83.705 227.044 79.2932 227.044 72.5662C227.044 61.9352 243.154 60.5526 250.267 60.5526C262.448 60.5526 274.497 65.328 283.095 72.7012L299.305 56.514C292.829 51.16 277.297 38.227 246.476 38.227C216.063 38.227 199.683 56.6717 199.683 74.0966C199.683 94.7087 215.678 106.461 248.643 110.034C262.506 111.555 272.966 113.481 272.966 123.125C272.966 140.891 228.408 139.109 210.516 119.337L192.857 137.122C194.522 139.016 215.269 158.12 246.386 158.12C283.526 158.12 300.36 139.926 300.36 122.922C300.36 101.571 286.488 90.0106 256.608 86.5633ZM741.237 17.8884C740.604 16.6181 739.559 14.361 738.517 13.6697C739.765 13.3384 741.125 11.9427 741.125 10.0038C741.125 9.52795 740.851 6.17102 736.928 6.17102H729.317V8.22224H731.243V17.8884H729.317V19.9623H735.6V17.8884H733.501V14.1006H735.52C737.279 14.7565 738.369 16.8658 739.729 19.9623H742.964V17.8884H741.237ZM733.501 8.22224H736.838C738.629 8.22224 738.832 9.43795 738.832 10.0488C738.832 11.3092 737.71 12.0586 736.044 12.0586H733.501V8.22224ZM735.806 0C728.59 0 722.725 5.85248 722.725 13.078C722.725 20.2936 728.59 26.1461 735.806 26.1461C743.019 26.1461 748.874 20.2936 748.874 13.078C748.874 5.85248 743.019 0 735.806 0ZM735.806 23.6732C729.951 23.6732 725.198 18.9301 725.198 13.078C725.198 7.21276 729.951 2.46012 735.806 2.46012C741.668 2.46012 746.411 7.21276 746.411 13.078C746.411 18.9301 741.668 23.6732 735.806 23.6732Z"
      fill="white"
    />
  </Svg>
);

export const SpotifyLogo = () => (
  <Svg viewBox="0 0 63 20">
    <g fillRule="evenodd">
      <path d="M61.842 9.506a1.02 1.02 0 0 1-1.023-1.024c0-.562.453-1.03 1.029-1.03a1.02 1.02 0 0 1 1.023 1.024 1.03 1.03 0 0 1-1.029 1.03m.006-1.952a.915.915 0 0 0-.922.928c0 .51.394.921.916.921a.916.916 0 0 0 .922-.927.908.908 0 0 0-.916-.922m.226 1.027l.29.406h-.244l-.26-.372h-.225v.372h-.204V7.912h.48c.249 0 .413.128.413.343 0 .176-.102.284-.25.326m-.172-.485h-.267v.34h.267c.133 0 .212-.065.212-.17 0-.11-.08-.17-.212-.17m-12.804-3.52a1.043 1.043 0 1 0-.001 2.086 1.043 1.043 0 0 0 0-2.087m.72 2.89h-1.454a.107.107 0 0 0-.106.107v6.346c0 .06.047.107.106.107h1.455a.107.107 0 0 0 .107-.107V7.572a.107.107 0 0 0-.107-.107m3.233.006v-.2c0-.592.227-.856.736-.856.303 0 .546.06.82.152a.106.106 0 0 0 .14-.102V5.24a.107.107 0 0 0-.076-.102 3.993 3.993 0 0 0-1.21-.174c-1.343 0-2.053.757-2.053 2.188v.308h-.699a.107.107 0 0 0-.107.106v1.257c0 .059.048.107.107.107h.699v4.99c0 .058.047.106.106.106h1.455a.107.107 0 0 0 .106-.107v-4.99h1.358l2.081 4.99c-.236.523-.468.628-.785.628-.257 0-.527-.077-.803-.228a.109.109 0 0 0-.084-.008.106.106 0 0 0-.063.058l-.493 1.081a.106.106 0 0 0 .045.138c.515.279.98.398 1.554.398 1.074 0 1.668-.5 2.191-1.847L60.6 7.617a.106.106 0 0 0-.099-.146h-1.514a.107.107 0 0 0-.1.072l-1.552 4.431-1.7-4.434a.106.106 0 0 0-.099-.069h-2.485m-5.577-.006h-1.6V5.828a.106.106 0 0 0-.107-.106h-1.455a.107.107 0 0 0-.106.106v1.637h-.7a.106.106 0 0 0-.106.107v1.25c0 .059.048.107.106.107h.7v3.234c0 1.308.65 1.97 1.934 1.97.522 0 .954-.107 1.362-.338a.106.106 0 0 0 .054-.093v-1.19a.106.106 0 0 0-.154-.096c-.28.141-.551.206-.854.206-.467 0-.675-.211-.675-.686V8.929h1.6a.106.106 0 0 0 .107-.107v-1.25a.106.106 0 0 0-.106-.107m-7.671-.133c-1.96 0-3.497 1.51-3.497 3.437 0 1.907 1.526 3.4 3.473 3.4 1.967 0 3.508-1.504 3.508-3.424 0-1.914-1.53-3.413-3.484-3.413m0 5.362c-1.043 0-1.83-.838-1.83-1.95 0-1.115.76-1.924 1.806-1.924 1.05 0 1.84.838 1.84 1.95 0 1.115-.763 1.924-1.816 1.924m-7.014-5.362c-.82 0-1.492.323-2.046.984v-.744a.107.107 0 0 0-.106-.107h-1.455a.107.107 0 0 0-.106.107v8.27c0 .058.048.106.106.106h1.455a.107.107 0 0 0 .106-.106v-2.61c.555.621 1.227.925 2.046.925 1.522 0 3.063-1.172 3.063-3.412s-1.54-3.413-3.063-3.413m1.372 3.413c0 1.14-.703 1.937-1.709 1.937-.995 0-1.745-.833-1.745-1.937s.75-1.937 1.745-1.937c.99 0 1.71.814 1.71 1.937m-8.437-1.81c-1.624-.388-1.913-.66-1.913-1.231 0-.54.508-.903 1.264-.903.732 0 1.459.275 2.22.843a.107.107 0 0 0 .15-.023l.794-1.119a.107.107 0 0 0-.02-.144c-.906-.728-1.927-1.081-3.12-1.081-1.755 0-2.98 1.052-2.98 2.559 0 1.615 1.057 2.187 2.884 2.628 1.554.358 1.817.658 1.817 1.195 0 .594-.53.963-1.385.963-.948 0-1.721-.32-2.587-1.068a.11.11 0 0 0-.078-.026.105.105 0 0 0-.073.038l-.89 1.058a.105.105 0 0 0 .011.148 5.303 5.303 0 0 0 3.581 1.373c1.89 0 3.112-1.033 3.112-2.631 0-1.351-.807-2.098-2.787-2.58M9.507.305a9.41 9.41 0 1 0 0 18.82 9.41 9.41 0 0 0 0-18.82m4.316 13.572a.586.586 0 0 1-.807.195c-2.21-1.35-4.99-1.655-8.266-.907a.586.586 0 1 1-.261-1.143c3.584-.82 6.659-.467 9.139 1.049.276.169.363.53.195.806m1.15-2.562a.734.734 0 0 1-1.008.242c-2.529-1.555-6.385-2.005-9.377-1.097a.735.735 0 0 1-.426-1.404c3.418-1.037 7.666-.534 10.57 1.25a.734.734 0 0 1 .242 1.01m.1-2.669C12.04 6.846 7.036 6.68 4.141 7.56a.88.88 0 1 1-.511-1.684c3.323-1.01 8.849-.814 12.34 1.258a.88.88 0 0 1-.898 1.514" />
    </g>
  </Svg>
);

export const BraveLogo = () => (
  <Svg viewBox="0 0 461.99 142.7">
    <defs>
      <linearGradient
        id="prefix__linear-gradient"
        x1={168.37}
        y1={199.9}
        x2={289.96}
        y2={199.9}
        gradientUnits="userSpaceOnUse"
      >
        <stop offset={0} stopColor="#f1562b" />
        <stop offset={0.3} stopColor="#f1542b" />
        <stop offset={0.41} stopColor="#f04d2a" />
        <stop offset={0.49} stopColor="#ef4229" />
        <stop offset={0.5} stopColor="#ef4029" />
        <stop offset={0.56} stopColor="#e83e28" />
        <stop offset={0.67} stopColor="#e13c26" />
        <stop offset={1} stopColor="#df3c26" />
      </linearGradient>
    </defs>
    <path
      fill="#fff"
      d="M320.92 205.1V157h4.6a6.78 6.78 0 016.78 6.78v21.39c7.37-6.58 13.65-9.21 22-9.38 16-.33 30 11.58 31.28 27.56 1.58 19.1-12.31 33.47-30.4 33.47-19.85 0-34.26-12.32-34.26-31.72zm11.2 3.78c1.12 9.94 10.62 18.15 20.63 18.31 13 .2 21.93-8.3 21.93-20.89s-8.68-20.9-21.37-20.9c-13.55 0-22.73 9.85-21.19 23.48zM404.6 177v8.57c7.16-8 11.42-10.09 19.8-10.09a46.18 46.18 0 017.29.59v11.38a29.47 29.47 0 00-7.9-1.06c-6.07 0-11.17 2-14.94 5.75-3.28 3.29-4.25 5.87-4.25 11v31.69h-11.78V177zM434.48 196.12c.61-5.63 1.7-8.68 4.13-11.62 4.86-6 13.61-9 26-9 9.84 0 17 1.53 22 4.81 4.13 2.7 5.83 6.69 5.83 13.73v25.7c0 5.63 1.46 7.63 5.47 7.51a25 25 0 002.67-.24v7.75a17.53 17.53 0 01-6.2.94c-7.41 0-10.81-2.23-13.11-8.68-7.29 6.69-14.82 9.51-25.63 9.51-14.45 0-23.32-6.57-23.32-17.25a15.19 15.19 0 019.11-14.08c4.37-1.88 7-2.46 19.56-3.76 10.69-1.06 12.51-1.29 15.55-2.23 3.28-1.06 4.74-2.81 4.74-5.75 0-6.22-5.22-9-16.16-9-10.34 0-15.66 2-17.8 7.28a7 7 0 01-6.51 4.46zm46.77 9.88a115.67 115.67 0 01-23 4.23c-10.57 1.06-13.85 3-13.85 8.33 0 5.87 4.86 8.92 14.45 8.92 7.9 0 13.85-2 18.1-5.87 3.4-3.17 4.25-5.4 4.25-10.92zM529.08 234.84h-3a7 7 0 01-6.3-3.91L494.26 177h7.08a10.41 10.41 0 019.57 6.13l17 38.82L545.46 183a10.41 10.41 0 019.53-6h6.43l-26.07 54a7 7 0 01-6.27 3.84zM569.41 209.26c1.21 11.15 10 18.07 23 18.07 7.38 0 12.88-2.19 16.35-6.58a10.53 10.53 0 018.25-4h6.85c-6 13.15-16.64 19.6-32.55 19.6-19.92 0-33.28-12.09-33.28-30.16s13.73-30.75 33.53-30.75c14.33 0 25.87 6.45 30.49 17.25 2.06 4.93 2.92 9.39 2.92 16.54zm43.48-8.92c-2.67-10.21-10.57-16-21.5-16s-18.83 5.75-21.62 16z"
      transform="translate(-168.37 -128.55)"
    />
    <path
      d="M290 174.71l-4.4-11.95 3.06-6.86a2.35 2.35 0 00-.48-2.61l-8.32-8.41a13.43 13.43 0 00-14-3.25l-2.33.81-12.71-13.77-21.56-.12h-.14l-21.7.17-12.7 13.88-2.26-.8a13.47 13.47 0 00-14.09 3.28l-8.47 8.57a1.87 1.87 0 00-.38 2.08l3.19 7.12-4.38 11.94 2.83 10.77 12.91 49.08a25 25 0 009.67 14s15.67 11.05 31.13 21.09a6.9 6.9 0 008.61 0c17.37-11.38 31.11-21.13 31.11-21.13a25 25 0 009.66-14l12.84-49.1z"
      transform="translate(-168.37 -128.55)"
      fill="url(#prefix__linear-gradient)"
    />
    <path
      fill="#fff"
      d="M232.72 217a18.42 18.42 0 00-2.54-.92h-1.53a18.42 18.42 0 00-2.54.92l-3.85 1.6c-1.22.51-3.18 1.42-4.35 2l-7.08 3.69a1.35 1.35 0 00-.17 2.5l6.15 4.34c1.08.76 2.78 2.1 3.78 3l1.73 1.49c1 .86 2.63 2.29 3.62 3.17l1.64 1.45a2.82 2.82 0 003.61 0l1.72-1.5 3.62-3.16 1.74-1.52c1-.87 2.69-2.21 3.77-3l6.15-4.4a1.34 1.34 0 00-.19-2.49l-7.07-3.59c-1.18-.6-3.14-1.5-4.37-2z"
      transform="translate(-168.37 -128.55)"
    />
    <path
      fill="#fff"
      d="M276.32 177.38l.2-.64a16.84 16.8  <<0 00-.16-2.56 21.57 21.57 0 00-2.28-4.3l-4-5.87c-.74-1.1-2-2.84-2.85-3.87l-5.36-6.71a18.74 18.74 0 00-1.59-1.86h-.11s-1.08.19-2.38.44l-8.19 1.58-3.59.69a9.33 9.33 0 01-3.51-.51l-6.47-2.09c-1.26-.41-3.34-1-4.63-1.28a19.35 19.35 0 00-4.09 0c-1.29.3-3.37.88-4.63 1.29l-6.47 2.1a9.33 9.33 0 01-3.51.51l-3.59-.68-8.2-1.57c-1.3-.25-2.37-.45-2.38-.44h-.11a18.74 18.74 0 00-1.59 1.86l-5.35 6.71c-.82 1-2.11 2.78-2.85 3.87l-4 5.87a31.45 31.45 0 00-1.89 3.15 14.32 14.32 0 00-.54 3.72l.2.64a9.49 9.49 0 00.37 1.21c.83 1 2.25 2.66 3.16 3.63l14 14.88a4 4 0 01.71 4l-2.29 5.43a7.05 7.05 0 00-.11 4.47l.46 1.26a12.15 12.15 0 003.73 5.23l2.2 1.79a4.16 4.16 0 004 .48l7.82-3.73a19.88 19.88 0 004-2.65l6.26-5.65a2.51 2.51 0 00.13-3.6l-14.13-9.52a2.74 2.74 0 01-.86-3.47l5.48-10.3a5.35 5.35 0 00.27-4.09 6.25 6.25 0 00-3.11-2.82l-17.18-6.49c-1.24-.47-1.17-1 .14-1.08l10.09-1a15.57 15.57 0 014.71.42l8.78 2.45a2.69 2.69 0 011.88 3l-3.45 18.84a9.74 9.74 0 00-.17 3.18c.14.45 1.32 1 2.61 1.32l5.35 1.14a13 13 0 004.7 0l4.81-1.09c1.29-.29 2.46-.9 2.61-1.35a9.73 9.73 0 00-.18-3.18l-3.47-18.84a2.69 2.69 0 011.88-3l8.78-2.46a15.56 15.56 0 014.71-.42l10.09.94c1.32.12 1.38.61.15 1.08l-17.17 6.51a6.25 6.25 0 00-3.11 2.82 5.36 5.36 0 00.27 4.09l5.49 10.3a2.74 2.74 0 01-.86 3.47l-14.12 9.54a2.51 2.51 0 00.13 3.6l6.27 5.65a19.88 19.88 0 004 2.64l7.82 3.72a4.16 4.16 0 004-.49l2.2-1.8a12.14 12.14 0 003.73-5.24l.46-1.26a7.05 7.05 0 00-.11-4.47l-2.3-5.43a4 4 0 01.71-4l14-14.9c.91-1 2.32-2.6 3.15-3.63a9.49 9.49 0 00.43-1.18z"
      transform="translate(-168.37 -128.55)"
    />
    <path
      d="M630.36 177.72a4.91 4.91 0 11-4.89-4.78 4.8 4.8 0 014.89 4.78zm-8.59 0a3.7 3.7 0 003.73 3.82 3.66 3.66 0 003.64-3.79 3.69 3.69 0 10-7.37 0zm2.94 2.51h-1.11v-4.78a9.64 9.64 0 011.84-.15 3 3 0 011.66.35 1.33 1.33 0 01.46 1 1.23 1.23 0 01-1 1.11v.06a1.41 1.41 0 01.87 1.16 3.61 3.61 0 00.35 1.19h-1.2a4.15 4.15 0 01-.38-1.16c-.09-.52-.38-.76-1-.76h-.52zm0-2.71h.52c.61 0 1.11-.2 1.11-.7s-.32-.73-1-.73a2.6 2.6 0 00-.61.06z"
      transform="translate(-168.37 -128.55)"
      fill="#77777a"
    />
  </Svg>
);

export const LyftLogo = () => (
  <Svg viewBox="0 0 72 50">
    <g fill="#ED2D23">
      <path d="M.023.888h10.912v28.716c0 4.544 2.12 7.251 3.796 8.411-1.775 1.547-7.198 2.901-11.24-.386C1.106 35.69.022 32.504.022 29.507V.888z" />
      <path d="M68.218 24.742v-3.018h3.328V11.137H67.89C66.488 4.781 60.717.018 53.815.018c-7.95 0-14.396 6.32-14.396 14.116v24.724c2.265.312 4.964-.04 7.26-1.906 2.384-1.938 3.467-5.124 3.467-8.122v-.91h5.45V17.333h-5.45v-3.199h.013c0-1.98 1.637-3.585 3.656-3.585 2.02 0 3.662 1.605 3.662 3.585v10.608c0 7.796 6.453 14.116 14.403 14.116V28.326c-2.019 0-3.662-1.605-3.662-3.584" />
      <path d="M26.89 11.137v15.537c0 .883-.746 1.597-1.667 1.597-.92 0-1.667-.714-1.667-1.597V11.137H12.759V29.41c0 3.288 1.137 7.445 6.31 8.799 5.18 1.355 8.185-1.45 8.185-1.45-.274 1.848-2.049 3.201-4.909 3.491-2.164.22-4.93-.483-6.31-1.063v9.681c3.517 1.017 7.236 1.345 10.877.653 6.606-1.257 10.775-6.671 10.775-13.874v-24.51H26.891z" />
    </g>
  </Svg>
);

export const DisneyPlusLogo = () => (
  <Svg viewBox="400 200 1120 680">
    <path
      d="M1174.8 624.7c-14.4 3.3-52.3 5.2-52.3 5.2l-4.8 15s18.9-1.6 32.7-.2c0 0 4.5-.5 5 5.1.2 5.2-.4 10.8-.4 10.8s-.3 3.4-5.1 4.2c-5.2.9-40.8 2.2-40.8 2.2l-5.8 19.5s-2.1 4.5 2.7 3.2c4.5-1.2 41.8-8.2 46.7-7.2 5.2 1.3 11 8.2 9.3 14.6-2 7.8-39.2 31.6-61.9 29.9 0 0-11.9.8-22-15.3-9.4-15.3 3.6-44.4 3.6-44.4s-5.9-13.6-1.6-18.1c0 0 2.6-2.3 10-2.9l9.1-18.9s-10.4.7-16.6-6.9c-5.8-7.3-6.2-10.6-1.8-12.6 4.7-2.3 48-10.2 77.8-9.2 0 0 10.4-1 19.3 17-.1 0 4.3 7.3-3.1 9zm-112.1 72.6c-3.8 9-13.9 18.6-26.4 12.6-12.4-6-32.1-46.3-32.1-46.3s-7.5-15-8.9-14.7c0 0-1.6-2.9-2.6 13.5s.2 48.3-6.3 53.3c-6.2 5-13.7 3-17.6-2.9-3.5-5.8-5-19.6-3.1-43.8 2.3-24.2 7.9-50 15.1-58.1 7.2-8 13-2.2 15.2-.1 0 0 9.6 8.7 25.5 34.3l2.8 4.7s14.4 24.2 15.9 24.1c0 0 1.2 1.1 2.2.3 1.5-.4.9-8.2.9-8.2s-3-26.3-16.1-70.9c0 0-2-5.6-.6-10.8 1.3-5.3 6.6-2.8 6.6-2.8s20.4 10.2 30.2 43.4c9.7 33.5 3.1 63.4-.7 72.4zM962.5 612c-1.7 3.4-2.7 8.3-11.3 9.6 0 0-82.3 5.6-86.2 11.4 0 0-2.9 3.4 1.6 4.4 4.5.9 23.1 3.4 32.1 3.9 9.6.1 42 .4 53.6 14.9 0 0 6.9 6.9 6.6 22.5-.3 16-3.1 21.6-9.3 27.4-6.5 5.4-62.3 30.4-98.3-8 0 0-16.6-18.5 5.7-32.5 0 0 16.1-9.7 57 1.7 0 0 12.4 4.5 11.8 9-.7 4.8-10.2 9.9-24 9.6-13.4-.4-23.2-6.8-21.3-5.8 1.8.7-14.4-7.8-19.4-2-5 5.3-3.8 8.6 1.1 11.9 12.5 7.1 60.8 4.6 75.2-11.4 0 0 5.7-6.5-3-11.8-8.7-5-33.6-8-43.3-8.5-9.3-.5-43.9.1-48.9-9.1 0 0-5-6.2.5-23.8 5.8-18.4 46.1-25.5 63.5-27.1 0 0 47.9-1.7 56.7 8.1-.1 0 1.1 2.3-.4 5.6zm-136 107.9c-5.8 4.3-18.1 2.4-21.6-2.4-3.5-4.3-4.7-21.4-4-48.2.7-27.1 1.3-60.7 7.1-66 6.2-5.4 10-.7 12.4 3 2.6 3.6 5.7 7.6 6.4 16.1.6 8.5 2.6 53.1 2.6 53.1s2.6 40.2-2.9 44.4zM839 576.1c-16.9 5.6-28.5 3.7-38.3-.5-4.3 7.5-6.8 9.8-10.1 10.3-4.8.5-9.1-7.2-9.9-9.7-.8-1.9-3.1-5.1-.3-12.7-9.6-8.6-10.3-20.2-8.7-28 2.4-9 18.6-43.2 67.9-47.2 0 0 24.1-1.8 28.2 11.1h.7s23.4.1 22.9 20.9c-.3 20.9-26 46.9-52.4 55.8zm-46-46.3c-5 8-5.2 12.8-2.9 16.1 5.7-8.7 16.1-22.4 31.4-32.8-11.8 1-21.7 6.1-28.5 16.7zm68.1-13.4c-15.5 2.3-39.5 23.1-50.9 40.1 17.5 3.2 48.4 2 62.1-25.9-.1 0 6.5-17.3-11.2-14.2zm420.8 161.1c-9.3 16.2-35.4 50-70.2 42.1-11.5 27.9-21.1 56-26.6 98.2 0 0-1.2 8.2-8 5.3-6.7-2.4-17.9-13.6-20.1-29.1-2.4-20.4 6.7-54.9 25.2-94.4-5.4-8.8-9.1-21.4-5.9-39.3 0 0 4.7-33.2 38-63.2 0 0 4-3.5 6.3-2.4 2.6 1.1 1.4 11.9-.7 17.1-2.1 5.2-17 31-17 31s-9.3 17.4-6.7 31.1c17.5-26.9 57.3-81.2 82-64.1 8.3 5.9 12.1 18.8 12.1 32.7-.1 12.3-3 25.3-8.4 35zm-7.2-42.6s-1.4-10.7-11.8 1.1c-9 9.9-25.2 28.6-38.3 53.9 13.7-1.5 26.9-9 30.9-12.8 6.5-5.8 21.6-21.4 19.2-42.2zm-485.5 13.6c-1.9 24.2-11.2 64.9-77.1 85-43.5 13.1-84.6 6.8-107 1.1-.5 8.9-1.5 12.7-2.9 14.2-1.9 1.9-16.1 10.1-23.9-1.5-3.5-5.5-5.3-15.5-6.3-24.4-50.4-23.2-73.6-56.6-74.5-58.1-1.1-1.1-12.6-13.1-1.1-27.8 10.8-13.3 46.1-26.6 77.9-32 1.1-27.2 4.3-47.7 8.1-57.1 4.6-10.9 10.4-1.1 15.4 6.3 4.2 5.5 6.7 29.2 6.9 48.1 20.8-1 33.1.5 56.3 4.7 30.2 5.5 50.4 20.9 48.6 38.4-1.3 17.2-17.1 24.3-23.1 24.8-6.3.5-16.1-4-16.1-4-6.7-3.2-.5-6 7.6-9.5 8.8-4.3 6.8-8.7 6.8-8.7-3.3-9.6-42.5-16.3-81.5-16.3-.2 21.5.9 57.2 1.4 78 27.3 5.2 47.7 4.2 47.7 4.2s99.6-2.8 102.6-66.4c3.1-63.7-99.3-124.8-175-144.2-75.6-19.8-118.4-6-122.1-4.1-4 2-.3 2.6-.3 2.6s4.1.6 11.2 3c7.5 2.4 1.7 6.3 1.7 6.3-12.9 4.1-27.4 1.5-30.2-4.4-2.8-5.9 1.9-11.2 7.3-18.8 5.4-8 11.3-7.7 11.3-7.7 93.5-32.4 207.4 26.2 207.4 26.2C773 560.5 791.2 623.9 789.2 648.5zM507 645.2c-10.6 5.2-3.3 12.7-3.3 12.7 19.9 21.4 44.4 34.8 67.7 43.1 2.7-36.9 2.3-49.9 2.6-68.5-36.4 2.5-57.4 8.3-67 12.7zm972.9-7.6v13.2c0 2.9-2.3 5.2-5.2 5.2h-62.9c0 3.3.1 6.2.1 8.9 0 19.5-.8 35.4-2.7 53.3-.3 2.7-2.5 4.7-5.1 4.7h-13.6c-1.4 0-2.7-.6-3.6-1.6-.9-1-1.4-2.4-1.2-3.8 1.9-17.8 2.8-33.5 2.8-52.6 0-2.8 0-5.7-.1-8.9h-62.2c-2.9 0-5.2-2.3-5.2-5.2v-13.2c0-2.9 2.3-5.2 5.2-5.2h61.3c-1.3-21.5-3.9-42.2-8.1-63.2-.2-1.3.1-2.6.9-3.6s2-1.6 3.3-1.6h14.7c2.3 0 4.2 1.6 4.7 3.9 4.1 21.7 6.7 42.8 8 64.5h63.7c2.8 0 5.2 2.4 5.2 5.2z"
      fill="#fff"
    />
    <path
      d="M1394.3 532.9c-32.5-79.9-87.4-148-158.8-197-73.1-50.1-158.8-76.6-247.8-76.6-147.2 0-283.8 73.1-365.3 195.6-.9 1.3-1.1 3-.6 4.5.5 1.6 1.7 2.7 3.2 3.2l11.4 3.9c.7.2 1.4.3 2 .3 2.1 0 4.1-1.1 5.3-2.8 37.4-55 88-100.7 146.4-132.3 60.3-32.6 128.6-49.9 197.5-49.9 83.3 0 163.6 24.6 232.4 71 67.1 45.3 119.2 108.6 150.7 182.9.9 2.2 3.1 3.7 5.5 3.7h13.6c1.6 0 3.1-.8 3.9-2.1 1-1.3 1.2-2.9.6-4.4zm-755.9-69.5c-.3 0-.6-.1-.9-.2.3.1.6.2.9.2zm735 74.2c.3.2.6.4.9.5-.3-.2-.6-.3-.9-.5z"
      fill="#fff"
    />
  </Svg>
);

export const FramerLogo = () => (
  <Svg viewBox="0 0 32 48">
    <path d="M 16 48 L 0 32 L 0 16 L 16 16 L 32 32 L 16 32 Z M 32 0 L 32 16 L 16 16 L 0 0 Z" fill="currentColor"></path>
  </Svg>
);

export const PricelineLogo = () => (
  <Svg viewBox="0 0 87 22">
    <path
      d="M78.7 10c0-.4-.1-1-.6-1.6a2.4 2.4 0 00-3.4.1c-.4.5-.5 1-.6 1.6h4.6zm3.3 4.3a9 9 0 01-1.3 1.7c-1 1-2.5 1.7-4.3 1.7-3.4 0-5.8-2.2-5.8-6 0-2.8 1.4-6.3 5.9-6.3.6 0 2.6 0 4 1.6 1.5 1.6 1.6 3.9 1.7 5.2H74c0 1.4.8 2.8 2.6 2.8 1.9 0 2.5-1.2 3-2l2.4 1.3zM62.6 6.8c.3-.4.6-.6 1.2-1 .5-.1 1.2-.3 2-.3.7 0 1.5 0 2 .4 1.3.7 1.6 1.7 1.6 3.5v7.8H66V9c-.3-.6-.9-.8-1.5-.8-1.8 0-1.8 1.4-1.8 2.8v6.2h-3.4V5.8h3.4v1zm-5.5-4c0 1-.8 1.9-1.8 1.9s-1.8-.8-1.8-1.9c0-1 .8-1.8 1.8-1.8s1.8.8 1.8 1.8zm-3.4 3H57v11.4h-3.3V5.7zm-2.3-5v16.4H48V.8h3.4zM43 10c0-.5-.1-1.2-.6-1.7a2.4 2.4 0 00-3.4.1c-.4.5-.5 1-.6 1.6H43zm3.4 4.2A9 9 0 0145 16c-1 1-2.5 1.7-4.3 1.7-3.4 0-5.8-2.2-5.8-6C35 9 36.4 5.4 41 5.4c.6 0 2.6 0 4 1.6 1.6 1.6 1.6 3.9 1.7 5.2h-8.2c0 1.4.8 2.8 2.6 2.8 1.9 0 2.5-1.2 3-2l2.5 1.3zm-13.2-.6l-.3.4c-.7.8-1.5.8-1.7.8-1.8 0-2.5-1.9-2.5-3.4 0-1.4.6-3.5 2.4-3.5.5 0 1 .2 1.2.4.5.3.7.7.9 1 .4-.9.8-1.8 1.5-2.5A5.5 5.5 0 0031 5.4c-3.8 0-5.7 2.9-5.7 6.2 0 4.7 3.5 6 5.7 6a5.6 5.6 0 003.7-1.4 5.3 5.3 0 01-1.4-2.5zM24 2.8c0 1-.8 1.9-1.8 1.9s-1.8-.8-1.8-1.9c0-1 .8-1.8 1.8-1.8s1.8.8 1.8 1.8zm-3.5 3h3.3v11.4h-3.3V5.7zm-4.7 1.1c.7-.6 1.5-1.1 3.3-1.3v3l-1.1.2c-1.6.3-2.1.5-2.1 2v6.4h-3.4V5.7h3.3V7zM5.6 8a2 2 0 00-1.7.9c-.5.6-.7 1.6-.7 2.7 0 1.5.4 2.4.8 2.9.4.4 1 .6 1.5.6C7.2 15 8 13.2 8 11.4 7.9 10 7.5 8.3 6 8h-.5zM3 6.9c0-.2.2-.3.3-.4.6-.6 1.6-1 2.9-1 2.8 0 5 2.1 5 6 0 2.3-1.1 6-5 6-1.3 0-2-.5-2.8-1v4.7H0V5.8h3v1zM84.5 2a2.5 2.5 0 012.2 1.2c.2.4.3.8.3 1.3 0 .4-.1.9-.3 1.2a2.5 2.5 0 01-4.4 0c-.2-.3-.3-.7-.3-1.2 0-.4.1-.9.3-1.2A2.5 2.5 0 0184.5 2zm0 4.4c.3 0 .7-.1 1-.3a2 2 0 00.9-1.6 1.8 1.8 0 00-1-1.6c-.2-.2-.5-.3-.9-.3a1.8 1.8 0 00-1.6 1c-.2.2-.3.6-.3 1a1.9 1.9 0 001.9 1.8zm1-2.3v.4c-.1.2-.2.3-.4.3l.5.8H85l-.3-.7H84v.7h-.5V3.3h1c.3 0 .5 0 .7.2.2.1.3.3.3.6zm-1.4.4h.5l.3-.1v-.7H84v.7z"
      fill="currentColor"
    />
  </Svg>
);

export const TheOnionLogo = () => (
  <Svg x="0px" y="0px" viewBox="0 0 600.08142 91.020386" width="600.08142" height="91.020386">
    <g fill="#FFF">
      <path d="m 36.881439,65.4 c 5.3,0.9 22.4,-3 28.2,-23.4 5.9,-21 2.9,-16.8 -14.3,1.1 -9.2,9.6 -16.6,21.8 -13.9,22.3 z m 15,13.3 c 18.6,-6.7 18.3,-30.9 15.3,-24.1 -3,6.6 -5,12 -11.5,15.7 -5.1,2.9 -8.7,3.3 -15,3.1 -5.2,-0.1 -10,-4.4 -11.5,2.1 -1.6,7.2 15.8,5.6 22.7,3.2 z m -15.7,-31.5 c 14.3,-19.8 35.5,-26.9 33.1,-29.4 -2.9,-2.9 -15.7,1.1 -15.7,1.1 -19.8,7 -41.4,20.1 -42.8,36.4 -0.5,4.8 0.9,13.8 7,17.5 4.1,2.5 11.3,-15.8 18.4,-25.6 z m -13.9,-17.5 c 7.9,-5.8 23.1,-10.6 19.8,-10.5 -11,0.3 -33.3999999,9.4 -34.4999999,23.4 -0.3,4.5 6.7999999,-7.1 14.6999999,-12.9 z M 2.7814391,82.4 c -1.3,-1.9 3.8,-2.9 4.8,-5 4.5999999,-8.9 -3.6,-5.2 -7.09999998,-25.5 C -6.2185609,13.5 59.081439,13.5 67.781439,12 c 8,-1.4 -0.1,-12 6.1,-12 2.1,0 0,5.5 2.1,6.3 2.2,0.9 3.5,-5 5.7,-3.1 3,2.6 -2.9,4.9 -1.3,6.5 1.2,1.2 3.9,-1 4.9,0.5 1.6,2.5 -2.8,4.1 -6.7,4.8 -14.4,2.5 16.5,65.7 -33.6,74.4 -13.2,2.5 -19.4,-9.2 -29.2,-3.5 -2.4,1.4 -4.2,6.8 -5.7,4.6 -0.8999999,-1.4 1.5,-3.6 0,-4.5 -0.9999999,-0.6 -2.4999999,2 -3.5999999,1.1 -0.8,-0.8 0.4,-2.1 -0.5,-3.1 -0.7,-1.3 -2.3,-0.3 -3.2,-1.6 z" />
      <path d="m 115.58144,86.3 c -13.4,0 -15.800001,-10.2 -15.800001,-20.2 V 55.2 l -7.2,0.3 V 42.4 l 7.2,0.2 v -17 l 16.400001,-1.7 v 18.7 l 10.6,-0.3 v 13.1 l -10.7,-0.4 v 10.6 c 0,4.8 1.4,6.5 4.8,6.5 1.7,0 4.1,-0.4 5.2,-1.2 l 3.6,11.4 c -1.7,1.3 -4.5,4 -14.1,4 m 36.1,-41.1 c 0,0 6.7,-4.2 17.1,-4.2 7.9,0 11.9,7.1 11.9,14.9 v 29.5 h -16.4 v -20 c 0,-7.3 0,-12.2 -5.9,-12.2 -3.1,0 -6.8,2.3 -6.8,2.3 v 29.9 h -16.4 V 16.6 l 16.4,-1.3 0.1,29.9 m 68.9,12.5 c -0.9,-4.3 -4.5,-7 -9,-7 -7.9,0 -10.5,6.5 -9.8,8.3 h 18.5 c 0.5,0 0.4,-0.9 0.3,-1.3 z m -9.3,29.7 c -15.9,0 -24.7,-10.3 -24.7,-25.3 0,-13.3 10.5,-22 25.2,-22 13,0 22.1,8.6 22.1,22.3 v 5.7 h -32.3 c 0,5.1 5.8,7.8 10.2,7.8 4.5,0 6.8,-1.3 9.1,-3.3 l 9.6,6.7 c -1.8,2 -7.7,8.1 -19.2,8.1 z m 74,-23.5 c 6.4,0 12.3,-5.6 12.3,-13.4 0,-6.4 -5.9,-11.8 -12.3,-11.8 -6.5,0 -12.4,5.4 -12.4,11.7 0,7.9 5.9,13.4 12.4,13.5 z m 0,23.6 c -19.9,0 -34.9,-15.5 -34.9,-37.1 0,-20.3 17.1,-34.8 34.9,-34.8 17.8,0 34.9,14.5 34.9,34.8 0,21.6 -15,37.1 -34.9,37.1 z m 85.1,-41.7 V 18.1 l 22.3,-1.5 V 87 l -43.3,-30 v 28.2 h -22.4 V 14.7 l 43.4,31.1 m 31.7,39.4 h 22.5 V 18.1 h -22.5 m 64.5,45.8 c 6.4,0 12.3,-5.6 12.3,-13.4 0,-6.4 -5.9,-11.8 -12.3,-11.8 -6.5,0 -12.4,5.4 -12.4,11.8 0,7.8 5.9,13.4 12.4,13.4 z m 0,23.7 c -19.9,0 -34.9,-15.5 -34.9,-37.1 0,-20.3 17.1,-34.8 34.9,-34.8 17.8,0 34.9,14.5 34.9,34.8 0,21.6 -15,37 -34.9,37.1 z m 85.1,-69.5 22.4,-1.5 V 87 l -43.3,-30 v 28.2 h -22.4 V 14.7 l 43.3,31.2" />
      <path d="m 591.38144,22.6 c 1.3,0 3.4,0.2 3.4,-1.7 0,-1.4 -1.3,-1.6 -2.4,-1.6 h -2.7 v 3.4 c 0,-0.1 1.7,-0.1 1.7,-0.1 z m 4.5,5.2 h -1.4 l -2.7,-4.4 h -2.1 v 4.4 h -1.2 v -9.4 h 4.1 c 0.8,0 1.6,0 2.3,0.4 0.8,0.4 1.1,1.2 1.1,2.1 0,1.9 -1.3,2.5 -2.9,2.5 z m 3.1,-4.7 c 0,-4.2 -3.3,-7.4 -7.4,-7.4 -4,0 -7.4,3.3 -7.4,7.4 0,4.1 3.4,7.4 7.4,7.4 4.1,0 7.4,-3.2 7.4,-7.4 z m -15.7,0 c 0,-4.7 3.7,-8.4 8.4,-8.4 4.7,0 8.4,3.7 8.4,8.4 0,4.7 -3.7,8.4 -8.4,8.4 -4.7,0 -8.4,-3.7 -8.4,-8.4 z" />
    </g>
  </Svg>
);

export const StreamLogo = () => (
  <Svg viewBox="0 0 117 21">
    <g fill="none">
      <path
        d="M48.812,16.8999705 C48.9800008,16.7506364 49.1293327,16.5826381 49.26,16.3959705 C49.3906673,16.2093029 49.456,15.9946383 49.456,15.7519705 C49.456,15.4533023 49.3486677,15.2013048 49.134,14.9959705 C48.9193323,14.7906361 48.6580015,14.6179712 48.35,14.4779705 C48.0419985,14.3379698 47.7200017,14.2306375 47.384,14.1559705 C47.0479983,14.0813034 46.7680011,14.0159707 46.544,13.9599705 C45.9279969,13.8106364 45.349336,13.6286382 44.808,13.4139705 C44.266664,13.1993027 43.7953353,12.937972 43.394,12.6299705 C42.9926647,12.3219689 42.6753345,11.9579726 42.442,11.5379705 C42.2086655,11.1179684 42.092,10.61864 42.092,10.0399705 C42.092,9.49863443 42.2226654,8.98997285 42.484,8.51397047 C42.7453346,8.03796809 43.0953311,7.61797229 43.534,7.25397047 C43.9726689,6.88996865 44.4859971,6.60063821 45.074,6.38597047 C45.6620029,6.17130273 46.2826634,6.06397047 46.936,6.06397047 C47.5146696,6.06397047 48.0653307,6.14796963 48.588,6.31597047 C49.1106693,6.48397131 49.5819979,6.71263569 50.002,7.00197047 C50.4220021,7.29130525 50.7766652,7.64130175 51.066,8.05197047 C51.3553348,8.46263919 51.5466662,8.91996795 51.64,9.42397047 L49.204,10.0119705 C49.0919994,9.56396823 48.8493352,9.19063863 48.476,8.89197047 C48.1026648,8.59330231 47.5893366,8.44397047 46.936,8.44397047 C46.7119989,8.44397047 46.4786679,8.47663681 46.236,8.54197047 C45.9933321,8.60730413 45.7693344,8.70530315 45.564,8.83597047 C45.3586656,8.96663779 45.1860007,9.12530287 45.046,9.31197047 C44.9059993,9.49863807 44.836,9.71330259 44.836,9.95597047 C44.836,10.2173051 44.9153325,10.4413029 45.074,10.6279705 C45.2326675,10.8146381 45.4239989,10.9686365 45.648,11.0899705 C45.8720011,11.2113044 46.1146654,11.3093034 46.376,11.3839705 C46.6373346,11.4586375 46.8799989,11.5239702 47.104,11.5799705 C48.0933383,11.8226383 48.9146634,12.0839691 49.568,12.3639705 C50.2213366,12.6439719 50.743998,12.9519688 51.136,13.2879705 C51.528002,13.6239721 51.8033325,13.9926351 51.962,14.3939705 C52.1206675,14.7953058 52.2,15.2479679 52.2,15.7519705 C52.2,16.3493068 52.064668,16.9093012 51.794,17.4319705 C51.523332,17.9546397 51.1500024,18.4073019 50.674,18.7899705 C50.1979976,19.172639 49.62867,19.4713027 48.966,19.6859705 C48.30333,19.9006382 47.5893372,20.0079705 46.824,20.0079705 C45.6666609,20.0079705 44.6353379,19.7233066 43.73,19.1539705 C42.8246621,18.5846343 42.2133349,17.8239752 41.896,16.8719705 L44.192,15.8359705 C44.4906682,16.4893071 44.873331,16.932636 45.34,17.1659705 C45.806669,17.399305 46.3386637,17.5159705 46.936,17.5159705 C47.6826704,17.5159705 48.3079975,17.3106392 48.812,16.8999705 L48.812,16.8999705 Z M61.088,19.6719705 C60.3226628,19.9333051 59.5666704,20.0919702 58.82,20.1479705 C58.0733296,20.2039707 57.4013363,20.0966385 56.804,19.8259705 C56.2066637,19.5553024 55.7213352,19.0793072 55.348,18.3979705 C54.9746648,17.7166337 54.788,16.7599766 54.788,15.5279705 L54.7880001,9.31320194 L52.5623779,9.31320194 L52.5623779,6.35635399 C52.5623779,6.35635399 52.7583618,6.35635418 53.1705322,6.35635418 C53.8978882,6.35635418 54.5468567,6.17865017 55.0048218,5.44015545 C55.199034,5.12697728 55.2242967,4.80662153 55.2478638,3.93826317 L55.2478638,2.91287254 L57.5796509,2.91287254 L57.5796509,6.35635399 L60.3285522,6.35635399 L60.3285522,9.31320194 L57.5796509,9.31320194 L57.504,15.9479705 C57.504,16.3959727 57.5553328,16.7506358 57.658,17.0119705 C57.7606672,17.2733051 57.9333321,17.4693031 58.176,17.5999705 C58.4186679,17.7306378 58.735998,17.7959705 59.128,17.7959705 C59.5200019,17.7959705 59.9959972,17.7586375 60.556,17.6839705 L61.088,19.6719705 Z M69.676,8.77997047 C69.5453327,8.72397019 69.4146673,8.66797075 69.284,8.61197047 C69.1719994,8.57463695 69.0413341,8.53730399 68.892,8.49997047 C68.7426659,8.46263695 68.5840008,8.44397047 68.416,8.44397047 C67.8746639,8.44397047 67.370669,8.53263625 66.904,8.70997047 C66.437331,8.88730469 66.0360017,9.12530231 65.7,9.42397047 C65.3639983,9.72263863 65.098001,10.0726351 64.902,10.4739705 C64.705999,10.8753058 64.608,11.2999682 64.608,11.7479705 L64.58,20 L61.864,20 L61.864,6.28797047 L64.02,6.28797047 L64.58,7.77197047 C64.9533352,7.23063443 65.4433303,6.79663877 66.05,6.46997047 C66.6566697,6.14330217 67.4173287,5.97997047 68.332,5.97997047 C68.9293363,5.97997047 69.6106628,6.06396963 70.376,6.23197047 L69.676,8.77997047 Z M76.724,20.0359705 C75.7533284,20.0359705 74.8433375,19.8539723 73.994,19.4899705 C73.1446624,19.1259686 72.4026698,18.6266403 71.768,17.9919705 C71.1333301,17.3573006 70.6340018,16.6106414 70.27,15.7519705 C69.9059981,14.8932995 69.724,13.978642 69.724,13.0079705 C69.724,12.0372989 69.8966649,11.1226414 70.242,10.2639705 C70.587335,9.40529951 71.053997,8.65864031 71.642,8.02397047 C72.2300029,7.38930063 72.915996,6.88997229 73.7,6.52597047 C74.4840039,6.16196865 75.3239955,5.97997047 76.22,5.97997047 C77.1346712,5.97997047 77.9793294,6.13863555 78.754,6.45597047 C79.5286705,6.77330539 80.2006638,7.26796711 80.77,7.93997047 C81.3393361,8.61197383 81.782665,9.46596529 82.1,10.5019705 C82.4173349,11.5379756 82.576,12.7746299 82.576,14.2119705 L72.608,14.2119705 C72.7386673,14.6973062 72.9439986,15.1499684 73.224,15.5699705 C73.5040014,15.9899726 73.8353314,16.3539689 74.218,16.6619705 C74.6006685,16.969972 75.0299976,17.2079696 75.506,17.3759705 C75.9820023,17.5439713 76.4813307,17.6279705 77.004,17.6279705 C77.7133368,17.6279705 78.3713303,17.4973051 78.978,17.2359705 C79.5846697,16.9746358 80.1026645,16.6293059 80.532,16.1999705 L82.212,17.8799705 C81.5586634,18.5333071 80.7606713,19.0559685 79.818,19.4479705 C78.8753286,19.8399724 77.8440056,20.0359705 76.724,20.0359705 L76.724,20.0359705 Z M76.22,8.44397047 C75.7906645,8.44397047 75.3846685,8.52796963 75.002,8.69597047 C74.6193314,8.86397131 74.2646683,9.09730231 73.938,9.39597047 C73.6113317,9.69463863 73.3313345,10.0493017 73.098,10.4599705 C72.8646655,10.8706392 72.6920005,11.3186347 72.58,11.8039705 L79.664,11.8039705 C79.6266664,11.3559682 79.5240008,10.9266392 79.356,10.5159705 C79.1879991,10.1053017 78.9546681,9.74597201 78.656,9.43797047 C78.3573318,9.12996893 78.0073353,8.88730469 77.606,8.70997047 C77.2046646,8.53263625 76.7426692,8.44397047 76.22,8.44397047 L76.22,8.44397047 Z M97.12,6.28797047 L97.12,20 L94.824,20 L94.404,18.1599705 C93.937331,18.7759735 93.3400036,19.2426355 92.612,19.5599705 C91.8839963,19.8773054 91.1466704,20.0359705 90.4,20.0359705 C89.466662,20.0359705 88.594004,19.8539723 87.782,19.4899705 C86.9699959,19.1259686 86.2606697,18.6266403 85.654,17.9919705 C85.0473303,17.3573006 84.5666684,16.6106414 84.212,15.7519705 C83.8573315,14.8932995 83.68,13.978642 83.68,13.0079705 C83.68,12.0372989 83.8573315,11.1226414 84.212,10.2639705 C84.5666684,9.40529951 85.0473303,8.65864031 85.654,8.02397047 C86.2606697,7.38930063 86.9699959,6.88997229 87.782,6.52597047 C88.594004,6.16196865 89.466662,5.97997047 90.4,5.97997047 C91.1466704,5.97997047 91.8653298,6.12463569 92.556,6.41397047 C93.2466701,6.70330525 93.8626639,7.15596739 94.404,7.77197047 L94.824,6.28797047 L97.12,6.28797047 Z M90.4,17.6279705 C90.941336,17.6279705 91.4546642,17.5066383 91.94,17.2639705 C92.4253357,17.0213026 92.8453315,16.6899726 93.2,16.2699705 C93.5546684,15.8499684 93.8346656,15.3599733 94.04,14.7999705 C94.2453343,14.2399677 94.348,13.6426403 94.348,13.0079705 C94.348,12.3733006 94.2453343,11.7759733 94.04,11.2159705 C93.8346656,10.6559677 93.5546684,10.1659726 93.2,9.74597047 C92.8453315,9.32596837 92.4253357,8.99463835 91.94,8.75197047 C91.4546642,8.50930259 90.941336,8.38797047 90.4,8.38797047 C89.8586639,8.38797047 89.3453357,8.50930259 88.86,8.75197047 C88.3746642,8.99463835 87.9546684,9.32596837 87.6,9.74597047 C87.2453315,10.1659726 86.9653343,10.6559677 86.76,11.2159705 C86.5546656,11.7759733 86.452,12.3733006 86.452,13.0079705 C86.452,13.6426403 86.5546656,14.2399677 86.76,14.7999705 C86.9653343,15.3599733 87.2453315,15.8499684 87.6,16.2699705 C87.9546684,16.6899726 88.3746642,17.0213026 88.86,17.2639705 C89.3453357,17.5066383 89.8586639,17.6279705 90.4,17.6279705 L90.4,17.6279705 Z M101.808,20 L99.0919999,20 L99.0919999,6.28797047 L101.248,6.28797047 L101.808,7.43597047 C102.144002,7.04396851 102.545331,6.70330525 103.012,6.41397047 C103.478669,6.12463569 104.047997,5.97997047 104.72,5.97997047 C104.981335,5.97997047 105.275332,6.01263681 105.602,6.07797047 C105.928668,6.14330413 106.264665,6.25530301 106.61,6.41397047 C106.955335,6.57263793 107.286665,6.78730245 107.604,7.05797047 C107.921335,7.32863849 108.191999,7.67863499 108.416,8.10797047 C108.733335,7.52930091 109.213997,7.02997257 109.858,6.60997047 C110.502003,6.18996837 111.187996,5.97997047 111.916,5.97997047 C112.401336,5.97997047 112.914664,6.05463639 113.456,6.20397047 C113.997336,6.35330455 114.501331,6.63330175 114.968,7.04397047 C115.434669,7.45463919 115.817332,8.02396683 116.116,8.75197047 C116.414668,9.47997411 116.564,10.4226313 116.564,11.5799705 L116.564,20 L114.016,20 L114.016,11.5519705 C114.016,10.3946313 113.778002,9.58730609 113.302,9.12997047 C112.825998,8.67263485 112.196004,8.44397047 111.412,8.44397047 C110.814664,8.44397047 110.292002,8.69596795 109.844,9.19997047 C109.395998,9.70397299 109.172,10.4972984 109.172,11.5799705 L109.172,20 L106.624,20 L106.624,11.5519705 C106.624,10.3946313 106.386002,9.58730609 105.91,9.12997047 C105.433998,8.67263485 104.804004,8.44397047 104.02,8.44397047 C103.459997,8.44397047 102.970002,8.65863499 102.55,9.08797047 C102.129998,9.51730595 101.882667,10.1892992 101.808,11.1039705 L101.808,20 Z"
        fill="#2A3754"
      ></path>
      <path
        d="M26.1491984,6.42806971 L38.9522984,5.52046971 C39.7973984,5.46056971 40.3294984,6.41296971 39.8353984,7.10116971 L30.8790984,19.5763697 C30.6912984,19.8379697 30.3888984,19.9931697 30.0667984,19.9931697 L9.98229842,19.9931697 C9.66069842,19.9931697 9.35869842,19.8384697 9.17069842,19.5773697 L0.190598415,7.10216971 C-0.304701585,6.41406971 0.227398415,5.46036971 1.07319842,5.52046971 L13.8372984,6.42816971 L19.2889984,0.333269706 C19.6884984,-0.113330294 20.3884984,-0.110730294 20.7846984,0.338969706 L26.1491984,6.42806971 Z M28.8303984,18.0152734 L20.5212984,14.9099734 L20.5212984,18.0152734 L28.8303984,18.0152734 Z M19.5212984,18.0152734 L19.5212984,14.9099734 L11.2121984,18.0152734 L19.5212984,18.0152734 Z M18.5624984,14.1681697 L10.0729984,17.3371697 L3.82739842,8.65556971 L18.5624984,14.1681697 Z M21.4627984,14.1681697 L29.9522984,17.3371697 L36.1978984,8.65556971 L21.4627984,14.1681697 Z M19.5292984,13.4435697 L19.5292984,2.99476971 L12.5878984,10.8305697 L19.5292984,13.4435697 Z M20.5212984,13.4435697 L20.5212984,2.99606971 L27.4627984,10.8305697 L20.5212984,13.4435697 Z M10.5522984,10.1082697 L12.1493984,8.31366971 L4.34669842,7.75446971 L10.5522984,10.1082697 Z M29.4148984,10.1082697 L27.8178984,8.31366971 L35.6205984,7.75446971 L29.4148984,10.1082697 Z"
        fill="#2F7DEB"
      ></path>
    </g>
  </Svg>
);

export const TaskadeLogo = () => (
  <Svg viewBox="0 0 873.000000 878.000000">
    <g transform="translate(0.000000,878.000000) scale(0.100000,-0.100000)" stroke="none">
      <path d="M4295 8714 c-146 -22 -267 -62 -375 -125 l-66 -37 -84 25 c-160 47 -389 43 -548 -11 -141 -48 -244 -111 -354 -214 l-69 -66 -112 -2 c-178 -3 -328 -45 -480 -135 -93 -54 -259 -220 -307 -307 -19 -34 -40 -69 -45 -78 -6 -8 -39 -21 -75 -30 -95 -21 -185 -58 -275 -111 -113 -65 -264 -219 -328 -333 -42 -76 -107 -247 -107 -284 0 -7 -37 -34 -82 -60 -165 -92 -301 -235 -383 -401 -64 -130 -86 -217 -92 -365 l-5 -125 -77 -80 c-121 -125 -188 -239 -238 -402 -24 -79 -26 -105 -27 -248 -1 -140 2 -170 23 -242 l23 -83 -31 -48 c-50 -78 -100 -195 -123 -289 -31 -124 -31 -312 0 -437 22 -88 83 -231 121 -284 l19 -28 -25 -84 c-35 -116 -43 -319 -18 -441 35 -175 120 -339 240 -464 l67 -70 3 -120 c9 -339 195 -652 477 -800 l56 -29 17 -71 c83 -348 344 -614 686 -700 63 -16 68 -19 85 -58 82 -182 286 -370 483 -446 115 -45 190 -60 320 -68 l114 -6 66 -67 c236 -238 590 -332 915 -241 l68 19 44 -30 c64 -43 184 -96 272 -120 112 -31 363 -31 475 0 74 20 212 81 269 118 25 17 29 17 100 -4 316 -96 660 -14 907 214 l76 71 130 6 c202 8 368 63 519 171 105 75 232 221 289 331 13 26 25 33 84 47 158 37 303 113 419 221 146 136 232 282 284 485 10 38 17 45 68 71 74 37 163 104 231 172 163 164 253 375 267 624 l7 110 72 75 c128 132 213 290 251 463 30 136 18 366 -26 481 -9 25 -6 35 29 90 48 76 92 179 117 271 26 97 27 351 1 443 -24 88 -64 185 -104 254 l-34 58 27 108 c37 143 39 322 6 456 -40 161 -129 321 -241 436 l-58 59 -6 133 c-6 144 -30 249 -86 373 -75 166 -225 325 -390 417 l-59 32 -16 76 c-30 139 -112 294 -220 417 -102 115 -286 226 -441 266 -77 20 -85 24 -100 56 -53 112 -165 249 -267 327 -155 120 -331 183 -530 191 l-127 6 -40 47 c-54 64 -185 161 -274 204 -40 19 -112 47 -162 62 -80 24 -106 27 -245 28 -131 1 -168 -2 -241 -22 l-86 -23 -65 40 c-87 53 -171 87 -271 111 -80 20 -252 33 -312 24z m247 -483 c114 -39 209 -120 267 -228 36 -66 57 -67 124 -6 154 140 357 172 536 85 119 -58 221 -185 256 -317 21 -83 39 -91 104 -50 67 42 152 65 240 65 276 0 481 -211 481 -496 0 -48 4 -66 15 -70 8 -3 56 2 106 12 115 22 199 11 304 -40 208 -102 306 -320 248 -557 -21 -90 -17 -95 95 -102 149 -9 269 -72 357 -189 67 -90 88 -154 89 -273 1 -112 -15 -177 -66 -259 -40 -66 -33 -90 29 -105 238 -60 402 -298 366 -532 -15 -96 -60 -186 -132 -263 -34 -36 -61 -67 -61 -70 0 -20 19 -40 54 -58 60 -30 167 -143 198 -209 35 -72 48 -128 48 -209 0 -81 -13 -137 -48 -209 -32 -67 -139 -179 -202 -211 -77 -39 -78 -51 -4 -131 152 -166 172 -398 49 -584 -66 -99 -180 -178 -295 -204 -68 -15 -75 -32 -40 -100 61 -118 81 -220 61 -326 -43 -229 -246 -395 -482 -395 -89 0 -96 -9 -75 -93 57 -229 -48 -453 -259 -554 -66 -31 -89 -37 -169 -41 -67 -3 -107 0 -148 12 -65 19 -94 20 -103 5 -4 -6 -9 -43 -11 -83 -11 -224 -149 -396 -361 -451 -119 -31 -229 -15 -356 53 -83 45 -93 41 -122 -54 -59 -193 -215 -319 -419 -340 -127 -13 -265 38 -371 138 -36 33 -70 58 -77 56 -7 -3 -35 -38 -63 -79 -94 -136 -218 -208 -376 -217 -183 -10 -341 77 -437 238 -22 36 -47 67 -56 68 -10 2 -38 -16 -65 -41 -119 -111 -256 -158 -405 -136 -203 28 -350 169 -406 387 -9 35 -15 42 -36 42 -13 0 -48 -13 -77 -30 -99 -56 -224 -73 -332 -45 -222 57 -361 230 -369 459 -2 45 -4 84 -5 87 -3 16 -36 17 -88 4 -243 -63 -489 67 -575 304 -28 77 -30 225 -4 300 l19 55 -22 17 c-12 10 -28 16 -35 13 -27 -10 -171 17 -225 42 -160 73 -266 217 -285 389 -10 81 13 188 59 273 51 97 48 110 -35 132 -206 54 -350 243 -350 459 0 134 46 244 139 336 68 66 67 84 -7 129 -169 102 -263 294 -235 477 22 141 103 260 235 345 84 54 87 71 20 136 -82 81 -132 204 -132 328 0 129 49 242 144 335 67 65 128 100 220 125 82 23 88 36 49 107 -44 82 -63 155 -63 244 0 137 49 248 154 347 88 84 188 122 317 122 86 0 105 11 96 57 -29 153 -30 164 -18 235 46 287 348 476 612 382 52 -18 54 -18 73 2 11 11 16 35 16 77 0 157 86 311 221 398 148 95 362 96 502 3 23 -15 49 -24 65 -22 22 2 29 11 40 48 45 155 136 265 268 327 66 30 93 37 165 41 146 8 260 -33 370 -135 31 -29 64 -53 73 -53 8 0 36 31 61 69 81 122 178 190 320 221 58 13 171 4 237 -19z" />
      <path d="M3125 5102 c-47 -90 -164 -200 -265 -250 -123 -61 -192 -75 -325 -70 -127 6 -203 28 -305 88 -82 48 -176 142 -221 219 -19 33 -36 60 -39 60 -3 0 -25 -31 -50 -71 -60 -95 -154 -179 -254 -228 -113 -55 -179 -70 -317 -70 l-118 0 -30 -37 c-39 -47 -62 -96 -68 -144 -8 -54 2 -84 42 -128 65 -72 207 -116 407 -128 l106 -6 5 -681 c4 -757 6 -775 73 -976 224 -670 978 -1130 2074 -1267 208 -26 802 -26 1010 0 1099 137 1860 603 2079 1273 63 194 64 212 69 967 l3 687 57 0 c75 0 204 16 275 35 225 59 291 192 174 353 l-37 50 -143 4 c-108 4 -157 10 -207 26 -141 46 -280 157 -356 284 l-40 66 -29 -56 c-46 -89 -166 -202 -267 -251 -122 -60 -190 -74 -323 -68 -128 5 -208 28 -304 84 -82 48 -179 145 -228 227 l-39 64 -29 -56 c-47 -90 -164 -201 -265 -250 -123 -61 -192 -75 -325 -70 -124 5 -215 31 -312 90 -75 44 -173 144 -220 222 l-39 64 -29 -56 c-47 -90 -164 -201 -265 -250 -47 -23 -112 -49 -145 -57 -76 -19 -222 -19 -305 1 -172 40 -339 168 -416 317 -13 26 -25 47 -27 47 -1 0 -15 -26 -32 -58z m-446 -2013 c59 -25 124 -91 154 -157 33 -72 30 -200 -5 -267 -33 -63 -80 -108 -143 -137 -73 -34 -219 -32 -289 2 -253 123 -205 510 71 580 55 14 155 4 212 -21z m3639 -4 c61 -33 92 -66 130 -139 36 -71 38 -186 3 -263 -27 -61 -93 -126 -159 -156 -66 -30 -217 -31 -283 -1 -127 58 -190 183 -167 330 11 72 38 125 91 176 68 67 133 88 252 84 67 -2 89 -7 133 -31z" />
    </g>
  </Svg>
);

export const RiotGamesLogo = () => (
  <Svg width="600" height="305.41" version="1.1" viewBox="0 0 600 305.41" xmlns="http://www.w3.org/2000/svg">
    <g fill="#d22a36">
      <path d="m404.82 290.61-.39225-11.291 39.032-.46128.35814-12.305-39.851-.49538-.39793-11.431 52.503-1.2291.43285-13.5h-70.833l-2.1115 65.51h74.251l-.52138-13.525zm-353.18-24.086-.83372 12.256 19.699.65862-.24932 12.442-41.232-1.209 1.7963-35.938 56.692-1.3121-.81934-13.525h-73.228l-6.5665 65.51h83.436l-2.1631-39.519zm516.81 5.0681-54.116-9.1478.2347-7.0907 51.77-1.931-1.3064-13.525h-66.547l-3.4036 33.955 55.016 9.566.24932 6.2399-57.242 2.2232-1.4038 13.525h80.115z" />
      <path d="m347.63 305.41-6.5664-65.51h-18.851l-27.082 31.228-27.085-31.228h-18.851l-6.5664 65.51h22.146l2.1201-42.499 28.237 28.973 28.231-28.973 2.1258 42.499z" />
      <path d="m254.55 0h-44.324l-4.0338 202.59h53.552z" />
      <path d="m391.89 158.52-48.907 1.5786-1.6215-119.15 51.151 1.5499zm42.862-158.43h-138.19l-5.3804 202.5h153.38z" />
      <path d="m600 44.336-4.9363-44.335h-136.15l1.1517 39.493 43.547 1.507 4.4635 161.59h53.66l-16.052-160.14z" />
      <path d="m73.64 41.444 42.711-1.4296 4.8675 40.364-49.297 23.286zm49.899 161.15h58.167l-37.909-90.925 30.251-16.528-20.668-95.139h-148.48l-4.8875 43.905 33.216-1.1088-16.018 159.8h51.984l1.4067-50.939 37.456-20.462z" />
      <path d="m151.82 275.89 4.5037-21.433 21.625-.97698 4.518 21.507zm37.044 29.526h22.424l-17.743-65.513h-52.615l-17.74 65.513h22.424l3.4723-16.528 36.402.47021z" />
    </g>
  </Svg>
);

export const WazirXLogo = () => (
  <Svg
    version="1.0"
    xmlns="http://www.w3.org/2000/svg"
    width="1024.000000pt"
    height="1024.000000pt"
    viewBox="0 0 1024.000000 1024.000000"
    preserveAspectRatio="xMidYMid meet"
  >
    <g transform="translate(0.000000,1024.000000) scale(0.100000,-0.100000)" fill="#000000" stroke="none">
      <path
        d="M905 10228 c-122 -13 -241 -45 -342 -93 -115 -54 -170 -91 -257 -174
-170 -163 -267 -373 -296 -643 -14 -135 -14 -8261 0 -8396 15 -139 45 -253 95
-359 54 -115 91 -170 174 -257 163 -170 373 -267 643 -296 135 -14 8261 -14
8396 0 199 22 378 86 516 184 71 51 178 159 225 229 89 131 150 310 171 499
14 135 14 8261 0 8396 -22 199 -86 378 -184 516 -51 71 -159 178 -229 225
-131 89 -310 150 -499 171 -122 13 -8295 12 -8413 -2z m5015 -3247 c621 -928
750 -1125 739 -1136 -8 -6 -782 -602 -1721 -1324 l-1707 -1311 -474 2 -475 3
824 1420 c1589 2737 2036 3497 2049 3483 7 -7 351 -519 765 -1137z m-3430
-639 c415 -294 761 -540 769 -547 11 -11 -85 -183 -589 -1052 -717 -1236 -674
-1164 -677 -1138 -6 42 -283 3251 -283 3268 0 12 4 16 13 11 6 -4 352 -248
767 -542z m6167 436 c-3 -29 -74 -843 -158 -1808 -83 -965 -153 -1756 -154
-1758 -1 -1 -991 -1 -2200 0 l-2197 3 2348 1807 c1292 994 2353 1807 2358
1807 5 1 6 -23 3 -51z m-309 -4206 l2 -222 -3172 2 -3173 3 -3 210 c-1 115 0
215 2 222 4 11 610 13 3173 11 l3168 -3 3 -223z"
      />
    </g>
  </Svg>
);

export const IMDbLogo = () => (
  <Svg viewBox="0 0 460 231.86">
    <g>
      <path
        d="m460 19.93c-1.2461-10.211-8.8242-18.344-18.473-19.93h-422.87c-10.566 1.7344-18.656 11.328-18.656 22.887v185.8c0 12.801 9.8945 23.176 22.113 23.176h415.96c11.25 0 20.539-8.8086 21.93-20.207z"
        fill="none"
      />
      <path d="m55.48 46.594h36.504v140.52h-36.504z" fill="#FFF" stroke="#FFF" />
      <path d="m160.96 111.32c-3.1367-21.418-4.8828-33.32-5.2266-35.695-1.5273-11.465-2.9805-21.441-4.375-29.953h-47.328v140.52h31.977l0.11328-92.785 13.453 92.785h22.777l12.762-94.848 0.11719 94.848h31.875v-140.52h-47.691z" />
      <path d="m277.37 74.902c0.40234 1.793 0.60937 5.8594 0.60937 12.211v54.48c0 9.3516-0.60937 15.078-1.8164 17.191-1.2148 2.1094-4.4492 3.1602-9.6875 3.1602v-92.242c3.9766 0 6.6875 0.42578 8.1289 1.2578 1.4375 0.83984 2.3672 2.1523 2.7656 3.9414zm16.488 109.86c4.3438-0.95312 7.9922-2.6328 10.953-5.0273 2.9531-2.3984 5.0234-5.7188 6.207-9.9648 1.1914-4.2422 1.8945-12.664 1.8945-25.266v-49.344c0-13.297-0.51953-22.207-1.3242-26.734-0.81641-4.5391-2.8438-8.6562-6.082-12.355-3.2461-3.6953-7.9844-6.3516-14.207-7.9648-6.2344-1.6172-16.395-2.4336-34.066-2.4336h-27.23v140.52h44.223c10.191-0.32031 16.738-0.79297 19.633-1.4297z" />
      <path d="m371.81 163.76c-0.67188 1.7812-3.6172 2.6875-5.8398 2.6875-2.1758 0-3.625-0.86328-4.3594-2.6016-0.73828-1.7266-1.0977-5.6719-1.0977-11.848v-37.137c0-6.3984 0.32031-10.391 0.96875-11.984 0.64062-1.5742 2.0469-2.375 4.2227-2.375 2.2266 0 5.207 0.90234 5.9766 2.7188 0.76172 1.8164 1.1445 5.6992 1.1445 11.641v36.008c-0.23047 7.4023-0.56641 11.695-1.0156 12.891zm-46.465 21.207h32.863c1.3672-5.3672 2.1211-8.3516 2.2734-8.9531 2.9766 3.6016 6.2461 6.3047 9.8398 8.0977 3.5742 1.7969 8.9258 2.6953 13.07 2.6953 5.7695 0 10.746-1.5117 14.945-4.543 4.1914-3.0273 6.8633-6.6094 8-10.73 1.1367-4.1289 1.7031-10.398 1.7031-18.832v-39.422c0-8.4805-0.19141-14.016-0.56641-16.617-0.375-2.6016-1.4961-5.25-3.3594-7.9609-1.8672-2.7109-4.5781-4.8164-8.1289-6.3203-3.5508-1.5039-7.7461-2.2539-12.578-2.2539-4.1992 0-9.5742 0.83984-13.16 2.4961-3.5742 1.6562-6.8203 4.168-9.7344 7.5352v-45.711h-35.168z" />
    </g>
  </Svg>
);

export const UnrealEngineLogo = () => (
  <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 340.98505 49.379997" height="49.379997" width="340.98505">
    <defs id="defs6">
      <clipPath id="clipPath18" clipPathUnits="userSpaceOnUse">
        <path
          id="path16"
          d="m 28.972,40.776 c -3.686,-4.222 -2.987,-7.708 -2.987,-7.708 v 0 c 0,0 1.017,2.399 3.464,4.925 v 0 c 1.158,1.198 2.025,1.597 2.616,1.599 v 0 c 0.657,0.002 0.975,-0.49 0.975,-0.927 v 0 -8.572 c 0,-0.845 -0.546,-1.029 -1.049,-1.02 v 0 c -0.429,0.008 -0.827,0.157 -0.827,0.157 v 0 c 2.511,-3.646 8.517,-4.158 8.517,-4.158 v 0 l 2.638,2.815 0.062,-0.054 2.417,-2.057 c 4.417,2.623 6.546,7.484 6.546,7.484 v 0 c -1.971,-2.085 -3.227,-2.571 -3.972,-2.566 v 0 c -0.662,0.002 -0.922,0.391 -0.922,0.391 v 0 c -0.036,0.18 -0.097,2.788 -0.119,5.397 v 0 c -0.022,2.704 -0.003,5.409 0.132,5.417 v 0 c 0.764,1.43 3.197,4.314 3.197,4.314 v 0 c -4.545,-0.895 -7.023,-3.87 -7.023,-3.87 v 0 c -0.731,0.576 -2.225,0.48 -2.225,0.48 v 0 c 0.699,-0.384 1.398,-1.503 1.398,-2.431 v 0 -9.115 c 0,0 -1.525,-1.343 -2.701,-1.343 v 0 c -0.695,0 -1.124,0.38 -1.358,0.691 v 0 c -0.162,0.215 -0.231,0.396 -0.231,0.396 v 0 11.258 c -0.144,-0.104 -0.349,-0.19 -0.56,-0.19 v 0 c -0.25,0.001 -0.508,0.126 -0.684,0.494 v 0 c -0.132,0.278 -0.217,0.692 -0.217,1.296 v 0 c 0,2.078 2.351,3.454 2.351,3.454 v 0 c -2.987,-0.8 -5.752,-2.335 -9.438,-6.557"
        />
      </clipPath>
      <clipPath id="clipPath28" clipPathUnits="userSpaceOnUse">
        <path
          id="path26"
          d="m 21.007,36.104 c 0,-10.227 8.247,-18.518 18.419,-18.518 v 0 c 10.172,0 18.419,8.291 18.419,18.518 v 0 c 0,10.227 -8.247,18.517 -18.419,18.517 v 0 c -10.172,0 -18.419,-8.29 -18.419,-18.517 m 5.968,-12.518 c -3.326,3.344 -5.157,7.789 -5.157,12.518 v 0 c 0,4.728 1.831,9.174 5.157,12.518 v 0 c 3.325,3.343 7.748,5.185 12.451,5.185 v 0 c 4.703,0 9.125,-1.842 12.451,-5.185 v 0 c 3.325,-3.344 5.157,-7.79 5.157,-12.518 v 0 c 0,-4.729 -1.832,-9.174 -5.157,-12.518 v 0 C 48.551,20.243 44.129,18.401 39.426,18.401 v 0 c -4.703,0 -9.126,1.842 -12.451,5.185"
        />
      </clipPath>
      <clipPath id="clipPath38" clipPathUnits="userSpaceOnUse">
        <path
          id="path36"
          d="M 79.438,42.199 V 35.17 c 0,-0.427 -0.016,-0.799 -0.045,-1.114 v 0 C 79.362,33.741 79.3,33.475 79.205,33.258 v 0 C 79.112,33.04 78.977,32.863 78.801,32.725 v 0 c -0.176,-0.138 -0.409,-0.243 -0.7,-0.316 v 0 C 77.81,32.335 77.452,32.285 77.028,32.257 v 0 C 76.604,32.23 76.097,32.216 75.509,32.216 v 0 h -0.318 c -0.588,0 -1.094,0.012 -1.519,0.036 v 0 c -0.425,0.025 -0.782,0.076 -1.073,0.152 v 0 c -0.29,0.077 -0.524,0.182 -0.7,0.316 v 0 c -0.175,0.135 -0.31,0.313 -0.405,0.533 v 0 c -0.093,0.22 -0.155,0.486 -0.186,0.798 v 0 c -0.031,0.312 -0.045,0.685 -0.045,1.119 v 0 7.029 H 67.497 V 33.95 c 0,-0.636 0.046,-1.193 0.137,-1.67 v 0 c 0.091,-0.477 0.248,-0.888 0.468,-1.234 v 0 c 0.222,-0.345 0.518,-0.633 0.892,-0.863 v 0 c 0.373,-0.228 0.842,-0.411 1.409,-0.545 v 0 c 0.567,-0.135 1.242,-0.23 2.024,-0.284 v 0 c 0.782,-0.055 1.691,-0.083 2.727,-0.083 v 0 h 0.392 c 1.048,0 1.966,0.028 2.755,0.083 v 0 c 0.788,0.054 1.466,0.149 2.032,0.284 v 0 c 0.567,0.134 1.035,0.317 1.405,0.545 v 0 c 0.37,0.23 0.664,0.518 0.883,0.863 v 0 c 0.218,0.346 0.369,0.759 0.454,1.239 v 0 c 0.085,0.479 0.127,1.035 0.127,1.665 v 0 8.249 z"
        />
      </clipPath>
      <clipPath id="clipPath52" clipPathUnits="userSpaceOnUse">
        <path
          id="path50"
          d="M 105.173,42.199 V 29.417 h 3.728 v 3.552 h 3.765 c 0.582,0 1.083,-0.011 1.505,-0.033 v 0 c 0.421,-0.021 0.776,-0.063 1.064,-0.124 v 0 c 0.288,-0.061 0.519,-0.148 0.696,-0.261 v 0 c 0.175,-0.113 0.312,-0.263 0.409,-0.45 v 0 c 0.097,-0.186 0.161,-0.414 0.19,-0.683 v 0 c 0.031,-0.27 0.046,-0.59 0.046,-0.964 v 0 -1.037 h 3.72 v 1.955 c 0,0.563 -0.031,1.024 -0.091,1.385 v 0 c -0.061,0.361 -0.173,0.654 -0.337,0.877 v 0 c -0.164,0.223 -0.389,0.391 -0.677,0.504 v 0 c -0.288,0.113 -0.656,0.207 -1.105,0.281 v 0 0.073 c 0.406,0.091 0.748,0.225 1.027,0.403 v 0 c 0.279,0.178 0.507,0.402 0.682,0.675 v 0 c 0.176,0.272 0.304,0.596 0.382,0.972 v 0 c 0.079,0.376 0.119,0.815 0.119,1.317 v 0 0.45 c 0,0.734 -0.075,1.35 -0.223,1.848 v 0 c -0.149,0.499 -0.417,0.899 -0.805,1.202 v 0 c -0.388,0.303 -0.919,0.519 -1.591,0.647 v 0 c -0.673,0.128 -1.531,0.193 -2.574,0.193 v 0 z m 3.728,-2.826 h 4.693 c 0.642,0 1.156,-0.02 1.541,-0.06 v 0 c 0.385,-0.04 0.679,-0.119 0.882,-0.239 v 0 c 0.203,-0.118 0.335,-0.29 0.395,-0.513 v 0 c 0.061,-0.224 0.091,-0.515 0.091,-0.876 v 0 -0.221 c 0,-0.367 -0.03,-0.662 -0.091,-0.885 v 0 c -0.06,-0.224 -0.191,-0.398 -0.39,-0.523 v 0 c -0.201,-0.125 -0.493,-0.208 -0.878,-0.248 v 0 c -0.385,-0.039 -0.902,-0.059 -1.55,-0.059 v 0 h -4.693 z"
        />
      </clipPath>
      <clipPath id="clipPath82" clipPathUnits="userSpaceOnUse">
        <path
          id="path80"
          d="m 224.688,42.458 c -1.212,0 -2.261,-0.028 -3.149,-0.085 v 0 c -0.889,-0.057 -1.643,-0.168 -2.264,-0.335 v 0 c -0.621,-0.167 -1.126,-0.399 -1.514,-0.698 v 0 c -0.389,-0.299 -0.691,-0.691 -0.909,-1.175 v 0 c -0.217,-0.484 -0.364,-1.074 -0.442,-1.769 v 0 c -0.078,-0.695 -0.117,-1.518 -0.117,-2.467 v 0 -0.387 c 0,-0.944 0.038,-1.761 0.113,-2.449 v 0 c 0.074,-0.689 0.219,-1.275 0.433,-1.76 v 0 c 0.214,-0.485 0.515,-0.877 0.903,-1.179 v 0 c 0.388,-0.302 0.893,-0.538 1.514,-0.708 v 0 c 0.621,-0.17 1.376,-0.284 2.265,-0.344 v 0 c 0.887,-0.06 1.943,-0.09 3.167,-0.09 v 0 h 0.586 c 1.037,0 1.946,0.028 2.726,0.085 v 0 c 0.779,0.056 1.448,0.152 2.007,0.287 v 0 c 0.559,0.136 1.02,0.318 1.383,0.548 v 0 c 0.364,0.23 0.652,0.519 0.867,0.868 v 0 c 0.215,0.349 0.363,0.765 0.447,1.245 v 0 c 0.085,0.482 0.126,1.04 0.126,1.675 v 0 2.944 h -8.757 v -2.557 h 5.059 v -0.368 c 0,-0.233 -0.016,-0.435 -0.047,-0.608 v 0 c -0.03,-0.174 -0.094,-0.324 -0.191,-0.454 v 0 c -0.096,-0.128 -0.232,-0.236 -0.409,-0.32 v 0 c -0.178,-0.085 -0.413,-0.151 -0.708,-0.198 v 0 c -0.295,-0.048 -0.658,-0.082 -1.089,-0.104 v 0 c -0.431,-0.022 -0.944,-0.033 -1.54,-0.033 v 0 h -0.325 c -0.733,0 -1.358,0.013 -1.876,0.038 v 0 c -0.517,0.025 -0.948,0.08 -1.293,0.165 v 0 c -0.345,0.085 -0.618,0.206 -0.819,0.363 v 0 c -0.202,0.158 -0.353,0.369 -0.452,0.637 v 0 c -0.099,0.268 -0.163,0.596 -0.191,0.986 v 0 c -0.028,0.39 -0.041,0.858 -0.041,1.406 v 0 0.236 c 0,0.559 0.013,1.04 0.041,1.439 v 0 c 0.028,0.399 0.092,0.734 0.191,1.005 v 0 c 0.099,0.27 0.25,0.484 0.452,0.642 v 0 c 0.201,0.156 0.474,0.278 0.819,0.363 v 0 c 0.344,0.085 0.775,0.14 1.293,0.165 v 0 c 0.518,0.025 1.143,0.038 1.876,0.038 v 0 h 0.325 c 0.807,0 1.457,-0.026 1.95,-0.076 v 0 c 0.493,-0.05 0.876,-0.137 1.149,-0.259 v 0 c 0.273,-0.124 0.456,-0.287 0.549,-0.492 v 0 c 0.094,-0.204 0.14,-0.457 0.14,-0.758 v 0 -0.161 h 3.745 v 0.51 c 0,0.579 -0.04,1.084 -0.121,1.518 v 0 c -0.081,0.435 -0.225,0.807 -0.434,1.119 v 0 c -0.208,0.311 -0.49,0.567 -0.848,0.768 v 0 c -0.356,0.202 -0.81,0.361 -1.359,0.478 v 0 c -0.55,0.116 -1.207,0.196 -1.971,0.24 v 0 c -0.764,0.044 -1.655,0.066 -2.674,0.066 v 0 z"
        />
      </clipPath>
    </defs>
    <g transform="matrix(1.3333333,0,0,-1.3333333,-28.009333,72.827998)" id="g10">
      <g id="g12">
        <g clipPath="url(#clipPath18)" id="g14">
          <path
            id="path20"
            style={{ fill: '#2e2e2c', fillOpacity: 1, fillRule: 'nonzero', stroke: 'none' }}
            d="M 24.947,48.318 H 52.329 V 24.088 H 24.947 Z"
          />
        </g>
      </g>
      <g id="g22">
        <g clipPath="url(#clipPath28)" id="g24">
          <path
            id="path30"
            style={{ fill: '#2e2e2c', fillOpacity: 1, fillRule: 'nonzero', stroke: 'none' }}
            d="M 20.022,55.606 H 58.83 V 16.601 H 20.022 Z"
          />
        </g>
      </g>
      <g id="g32">
        <g clipPath="url(#clipPath38)" id="g34">
          <path
            id="path40"
            style={{ fill: '#2e2e2c', fillOpacity: 1, fillRule: 'nonzero', stroke: 'none' }}
            d="M 66.513,43.184 H 84.188 V 28.286 H 66.513 Z"
          />
        </g>
      </g>
      <g transform="translate(98.8794,42.1992)" id="g42">
        <path
          id="path44"
          style={{ fill: '#2e2e2c', fillOpacity: 1, fillRule: 'nonzero', stroke: 'none' }}
          d="M 0,0 V -9.571 H -0.072 L -7.393,0 h -5.719 v -12.782 h 3.692 v 9.561 h 0.073 l 7.41,-9.561 h 5.63 L 3.693,0 Z"
        />
      </g>
      <g id="g46">
        <g clipPath="url(#clipPath52)" id="g48">
          <path
            id="path54"
            style={{ fill: '#2e2e2c', fillOpacity: 1, fillRule: 'nonzero', stroke: 'none' }}
            d="m 104.188,43.184 h 17.093 V 28.433 h -17.093 z"
          />
        </g>
      </g>
      <g transform="translate(122.751,42.1992)" id="g56">
        <path
          id="path58"
          style={{ fill: '#2e2e2c', fillOpacity: 1, fillRule: 'nonzero', stroke: 'none' }}
          d="m 0,0 v -12.782 h 13.913 v 2.909 H 3.729 v 2.202 h 9.438 v 2.67 H 3.729 v 2.175 h 9.966 V 0 Z"
        />
      </g>
      <g transform="translate(144.3573,42.1992)" id="g60">
        <path
          id="path62"
          style={{ fill: '#2e2e2c', fillOpacity: 1, fillRule: 'nonzero', stroke: 'none' }}
          d="m 0,0 -6.875,-12.782 h 4.028 l 1.156,2.294 h 7.984 l 1.173,-2.294 h 4.065 L 4.62,0 Z m 2.237,-2.688 h 0.091 l 2.61,-5.129 h -5.293 z"
        />
      </g>
      <g transform="translate(157.2615,42.1992)" id="g64">
        <path
          id="path66"
          style={{ fill: '#2e2e2c', fillOpacity: 1, fillRule: 'nonzero', stroke: 'none' }}
          d="m 0,0 v -12.782 h 12.331 v 2.973 H 3.765 V 0 Z"
        />
      </g>
      <g transform="translate(179.5617,42.4575)" id="g68">
        <path
          id="path70"
          style={{ fill: '#2e2e2c', fillOpacity: 1, fillRule: 'nonzero', stroke: 'none' }}
          d="m 0,0 v -13.174 h 14.368 v 2.998 H 3.85 v 2.27 h 9.747 v 2.752 H 3.85 v 2.242 H 14.142 V 0 Z"
        />
      </g>
      <g transform="translate(209.6361,42.4575)" id="g72">
        <path
          id="path74"
          style={{ fill: '#2e2e2c', fillOpacity: 1, fillRule: 'nonzero', stroke: 'none' }}
          d="M 0,0 V -9.864 H -0.076 L -7.633,0 h -5.906 v -13.174 h 3.813 v 9.855 h 0.074 L -2,-13.174 H 3.811 V 0 Z"
        />
      </g>
      <g id="g76">
        <g clipPath="url(#clipPath82)" id="g78">
          <path
            id="path84"
            style={{ fill: '#2e2e2c', fillOpacity: 1, fillRule: 'nonzero', stroke: 'none' }}
            d="m 215.309,43.443 h 18.506 V 28.027 h -18.506 z"
          />
        </g>
      </g>
      <g transform="translate(255.6144,42.1866)" id="g86">
        <path
          id="path88"
          style={{ fill: '#2e2e2c', fillOpacity: 1, fillRule: 'nonzero', stroke: 'none' }}
          d="M 0,0 V -9.763 H -0.075 L -7.574,0 h -5.858 v -13.039 h 3.781 v 9.753 h 0.075 l 7.592,-9.753 H 3.782 V 0 Z"
        />
      </g>
      <g transform="translate(262.5138,42.1866)" id="g90">
        <path
          id="path92"
          style={{ fill: '#2e2e2c', fillOpacity: 1, fillRule: 'nonzero', stroke: 'none' }}
          d="m 0,0 v -13.039 h 14.232 v 2.967 H 3.814 v 2.246 h 9.655 v 2.725 H 3.814 v 2.217 H 14.008 V 0 Z"
        />
      </g>
      <path
        id="path94"
        style={{ fill: '#2e2e2c', fillOpacity: 1, fillRule: 'nonzero', stroke: 'none' }}
        d="m 235.405,29.147 h 3.931 v 13.039 h -3.931 z"
      />
    </g>
  </svg>
);

export const SmallPdfLogo = () => (
  <svg xmlns="http://www.w3.org/2000/svg" width="120" height="42" viewBox="0 0 120 42">
    <polygon fill="#FF46FB" points="18 25 27 25 27 34 18 34" />
    <polygon fill="#CA41FC" points="9 25 18 25 18 34 9 34" />
    <polygon fill="#8B48FE" points="0 25 9 25 9 34 0 34" />
    <polygon fill="#81E650" points="27 16 27 25 18 25 18 16" />
    <polygon fill="#00D267" points="18 16 18 25 9 25 9 16" />
    <polygon fill="#00C0FF" points="9 16 9 25 0 25 0 16" />
    <polygon fill="#FFD200" points="18 7 27 7 27 16 18 16" />
    <polygon fill="#FF8E00" points="9 7 18 7 18 16 9 16" />
    <polygon fill="#FF5400" points="0 7 9 7 9 16 0 16" />
    <path
      fill="#212121"
      d="M119,13.162345 C118.878082,13.1354566 118.735845,13.1083991 118.573289,13.0811725 C118.42394,13.0542841 118.251223,13.033991 118.055139,13.0202931 C117.858547,13.0069335 117.645191,13 117.415072,13 C116.683567,13 116.066867,13.1014656 115.565989,13.3043968 C115.064603,13.5073281 114.654656,13.7882187 114.336654,14.1465614 C114.018145,14.5052424 113.788025,14.9212514 113.645788,15.3945885 C113.503551,15.8682638 113.432432,16.3755919 113.432432,16.9165727 L113.432432,17.4441939 L112.091339,17.4441939 L112.091339,20.0011274 L113.432432,20.0011274 L113.432432,27.4284104 L116.927402,27.4284104 L116.927402,20.0011274 L118.634247,20.0011274 L118.634247,17.4441939 L116.927402,17.4441939 L116.927402,17.1397971 C116.927402,16.7070462 117.045763,16.3990981 117.282995,16.21646 C117.519718,16.0338219 117.801144,15.9425028 118.126258,15.9425028 C118.261383,15.9425028 118.380253,15.9494363 118.48185,15.9627959 C118.583448,15.9764938 118.674887,15.9900225 118.756165,16.0033822 C118.837443,16.01708 118.918722,16.0306088 119,16.0439684 L119,13.162345 L119,13.162345 Z M103.770637,21.1882751 C103.899327,20.8838782 104.055111,20.6371477 104.237987,20.4475761 C104.420863,20.2583427 104.620673,20.1228861 104.837415,20.0417136 C105.053988,19.9605411 105.257184,19.9199549 105.447003,19.9199549 C105.677291,19.9199549 105.951606,19.9605411 106.269946,20.0417136 C106.588117,20.1228861 106.849054,20.2583427 107.05225,20.4475761 L107.05225,24.059752 C106.862432,24.3438557 106.628756,24.5366404 106.351225,24.638106 C106.073523,24.7395716 105.799209,24.7903044 105.528281,24.7903044 C105.284446,24.7903044 105.047384,24.7465051 104.817095,24.6583991 C104.586637,24.5706313 104.380224,24.4319617 104.197348,24.2423901 C104.014472,24.0531567 103.865292,23.7994927 103.750317,23.481398 C103.635173,23.1636415 103.5776,22.77469 103.5776,22.3145434 C103.5776,21.8680947 103.641777,21.4926719 103.770637,21.1882751 L103.770637,21.1882751 Z M100.367105,24.6685457 C100.61094,25.3316234 100.939271,25.886133 101.352605,26.3325817 C101.76577,26.7790304 102.249885,27.113867 102.805456,27.3370913 C103.360858,27.5603157 103.95673,27.6719278 104.59358,27.6719278 C105.040611,27.6719278 105.521339,27.5669109 106.036271,27.3573844 C106.551034,27.1478579 106.984349,26.8671364 107.336725,26.5152198 L107.336725,27.4284104 L110.506581,27.4284104 L110.506581,13.3043968 L107.011611,13.3043968 L107.011611,17.9109357 C106.699875,17.5999436 106.361384,17.3767193 105.995632,17.2412627 C105.629879,17.1061443 105.162528,17.0383315 104.59358,17.0383315 C104.078648,17.0383315 103.550338,17.1499436 103.008652,17.373168 C102.466796,17.5963923 101.972353,17.9312289 101.525322,18.3776776 C101.078291,18.8241263 100.712538,19.3789741 100.428064,20.0417136 C100.14359,20.7047914 100.001353,21.4759301 100.001353,22.3551297 C100.001353,23.2346674 100.12327,24.0058061 100.367105,24.6685457 L100.367105,24.6685457 Z M92.1380099,20.6505073 C92.3681293,20.3801015 92.6256801,20.190699 92.9101544,20.0822999 C93.1946286,19.974239 93.4721603,19.9199549 93.7432575,19.9199549 C93.9870926,19.9199549 94.2207679,19.9605411 94.4442834,20.0417136 C94.6677989,20.1228861 94.8640523,20.2547914 95.0335515,20.4374295 C95.2027121,20.6200676 95.3415626,20.860372 95.4501031,21.1578354 C95.5583049,21.455637 95.6126598,21.8141488 95.6126598,22.2333709 C95.6126598,22.7204059 95.5481451,23.1262683 95.4196237,23.4509583 C95.2907637,23.7756483 95.1315935,24.0394589 94.9421134,24.2423901 C94.7522945,24.4453213 94.5423254,24.5873732 94.3122061,24.6685457 C94.081748,24.7497182 93.8651751,24.7903044 93.6619792,24.7903044 C93.4315212,24.7903044 93.1707531,24.7497182 92.879675,24.6685457 C92.5882582,24.5873732 92.3412058,24.4522548 92.1380099,24.2626832 L92.1380099,20.6505073 L92.1380099,20.6505073 Z M92.1786491,26.7993236 C92.5171396,27.1377114 92.8862788,27.367531 93.2860668,27.4892897 C93.685516,27.6110485 94.0952944,27.6719278 94.515402,27.6719278 C95.0570884,27.6719278 95.6057173,27.5603157 96.1612888,27.3370913 C96.7165216,27.113867 97.2179074,26.7758174 97.6649384,26.3224352 C98.1119694,25.8693912 98.477722,25.2976325 98.7621963,24.6076663 C99.0466706,23.9177001 99.1889077,23.1129087 99.1889077,22.1927847 C99.1889077,21.3541714 99.073594,20.6134724 98.8434746,19.9706877 C98.6130166,19.3282413 98.298063,18.7904735 97.8986137,18.3573844 C97.4988258,17.9246336 97.0314752,17.5963923 96.496562,17.373168 C95.9613101,17.1499436 95.3957482,17.0383315 94.7998762,17.0383315 C94.2849439,17.0383315 93.7600212,17.1433484 93.225108,17.3528749 C92.6898561,17.5627396 92.2326654,17.8434611 91.8535357,18.1950395 L91.8535357,17.2818489 L88.6836796,17.2818489 L88.6836796,31 L92.1786491,31 L92.1786491,26.7993236 L92.1786491,26.7993236 Z M82.831807,27.4284104 L86.3267765,27.4284104 L86.3267765,13.3043968 L82.831807,13.3043968 L82.831807,27.4284104 Z M76.9797651,27.4284104 L80.4747346,27.4284104 L80.4747346,13.3043968 L76.9797651,13.3043968 L76.9797651,27.4284104 Z M64.5140352,24.6685457 C64.7509278,25.3316234 65.0760412,25.886133 65.4893756,26.3325817 C65.9023712,26.7790304 66.3834375,27.113867 66.9320664,27.3370913 C67.4806954,27.5603157 68.0731808,27.6719278 68.7100306,27.6719278 C69.1570616,27.6719278 69.6377892,27.5704622 70.1527215,27.367531 C70.6673151,27.1645998 71.1007997,26.8874295 71.4531752,26.535513 L71.4531752,27.4284104 L74.6230313,27.4284104 L74.6230313,17.2818489 L71.4938144,17.2818489 L71.4938144,18.2559188 C71.1007997,17.8094701 70.6740883,17.4949267 70.2136802,17.3122886 C69.7529335,17.1296505 69.2789791,17.0383315 68.7913089,17.0383315 C68.2763767,17.0383315 67.7448501,17.1499436 67.1962211,17.373168 C66.6475922,17.5963923 66.1497622,17.9312289 65.7027313,18.3776776 C65.2557003,18.8241263 64.8863917,19.3789741 64.5953136,20.0417136 C64.3038968,20.7047914 64.1584424,21.4759301 64.1584424,22.3551297 C64.1584424,23.2346674 64.276804,24.0058061 64.5140352,24.6685457 L64.5140352,24.6685457 Z M67.9175666,21.1882751 C68.0394841,20.8838782 68.191881,20.6371477 68.3747573,20.4475761 C68.5576337,20.2583427 68.753887,20.1228861 68.9640255,20.0417136 C69.1738252,19.9605411 69.3736345,19.9199549 69.5634534,19.9199549 C69.7935727,19.9199549 70.0678872,19.9573281 70.3863968,20.0315671 C70.7045677,20.1061443 70.9655051,20.2515784 71.168701,20.4678692 L71.168701,24.059752 C70.9788821,24.3438557 70.7452069,24.5366404 70.4676751,24.638106 C70.1898047,24.7395716 69.9154903,24.7903044 69.6447317,24.7903044 C69.4008966,24.7903044 69.1672214,24.7465051 68.9437059,24.6583991 C68.7201904,24.5706313 68.5169945,24.4319617 68.3341182,24.2423901 C68.1512419,24.0531567 68.0054488,23.7994927 67.897247,23.481398 C67.7887065,23.1636415 67.7346903,22.77469 67.7346903,22.3145434 C67.7346903,21.8680947 67.795649,21.4926719 67.9175666,21.1882751 L67.9175666,21.1882751 Z M47.3338218,27.4284104 L50.8287913,27.4284104 L50.8287913,20.7722661 C50.9778017,20.515389 51.1708378,20.3226043 51.4078996,20.1939121 C51.6447922,20.0655581 51.8718636,20.0011274 52.0886059,20.0011274 C52.4677356,20.0011274 52.7591524,20.102593 52.9623483,20.3055242 C53.1655442,20.5084555 53.2671421,20.934611 53.2671421,21.583991 L53.2671421,27.4284104 L56.7621116,27.4284104 L56.7621116,20.7722661 C56.911122,20.515389 57.1041581,20.3226043 57.3412199,20.1939121 C57.5781125,20.0655581 57.8051839,20.0011274 58.0219262,20.0011274 C58.4010559,20.0011274 58.6924727,20.102593 58.8956686,20.3055242 C59.0988645,20.5084555 59.2004624,20.934611 59.2004624,21.583991 L59.2004624,27.4284104 L62.6954319,27.4284104 L62.6954319,21.0157835 C62.6954319,19.7442503 62.4243347,18.7632469 61.8826483,18.0732807 C61.3407926,17.3833145 60.5142933,17.0383315 59.4036583,17.0383315 C58.7127923,17.0383315 58.1099778,17.2006764 57.5952148,17.5253664 C57.0802825,17.8500564 56.6672869,18.2290304 56.3557198,18.6617813 C55.7867713,17.5796505 54.824808,17.0383315 53.470338,17.0383315 C52.779472,17.0383315 52.1902039,17.1873168 51.7025337,17.4847802 C51.2148635,17.7825817 50.8152449,18.1275648 50.5036779,18.5197294 L50.4223995,18.5197294 L50.300482,17.2818489 L47.3338218,17.2818489 L47.3338218,27.4284104 L47.3338218,27.4284104 Z M35,26.0281849 C35.3520369,26.3395152 35.7787483,26.6166855 36.2801342,26.8602029 C36.7134494,27.0631342 37.2519186,27.2493236 37.8955416,27.4182638 C38.5388259,27.5872041 39.3008106,27.6719278 40.1814955,27.6719278 C41.1295737,27.6719278 41.9594596,27.5533822 42.6706452,27.3167982 C43.3818309,27.0802142 43.971099,26.7587373 44.4384496,26.3528749 C44.9058002,25.9470124 45.2544505,25.4736753 45.4849085,24.9323563 C45.7150278,24.3913754 45.8303415,23.8162345 45.8303415,23.2074408 C45.8303415,22.0710259 45.5084453,21.1816798 44.865161,20.5388952 C44.221538,19.8964487 43.344409,19.4126268 42.2337741,19.0879369 C41.6241864,18.9122322 41.1060368,18.7632469 40.6793254,18.6414882 C40.252614,18.5197294 39.907181,18.401522 39.6430263,18.2863585 C39.3788717,18.1715333 39.1890528,18.0497745 39.0740778,17.9210823 C38.9587641,17.7927283 38.9013613,17.6337655 38.9013613,17.4441939 C38.9013613,17.0926156 39.063918,16.8049605 39.3890315,16.5817362 C39.7141449,16.3585118 40.1611759,16.2468997 40.7301244,16.2468997 C41.1228005,16.2468997 41.5190325,16.3214769 41.9188204,16.470124 C42.3182697,16.6191094 42.6874089,16.7814543 43.0262381,16.957159 C43.4189142,17.173788 43.7983825,17.4105411 44.1641351,17.6674183 L45.708424,14.5422773 C45.261393,14.2581736 44.7737228,14.0012965 44.2454135,13.7711387 C43.7983825,13.5819053 43.2732904,13.4058625 42.6706452,13.2435175 C42.0676614,13.0811725 41.4209905,13 40.7301244,13 C39.8360624,13 39.0537582,13.12531 38.3832117,13.3754228 C37.7126653,13.6258737 37.1538765,13.9573281 36.7068456,14.3697858 C36.2598146,14.7825817 35.9245413,15.2560879 35.7010259,15.7903044 C35.4775104,16.3248591 35.3657526,16.8759865 35.3657526,17.4441939 C35.3657526,18.5131342 35.646671,19.3821871 36.2090156,20.0518602 C36.7710216,20.7215333 37.5668722,21.2121195 38.5965674,21.5231116 C39.2874335,21.7260428 39.8665418,21.8919391 40.3338924,22.0202931 C40.801243,22.1489853 41.1771554,22.2739572 41.4616296,22.3957159 C41.7461039,22.5174746 41.9492998,22.6427847 42.0712173,22.7711387 C42.1931349,22.8998309 42.2540937,23.065389 42.2540937,23.2683202 C42.2540937,23.606708 42.0575016,23.8840474 41.6648255,24.1003382 C41.2718108,24.3169673 40.7435015,24.4250282 40.0798975,24.4250282 C39.6462436,24.4250282 39.229692,24.3438557 38.8302427,24.1815107 C38.4304548,24.0191657 38.074862,23.8365276 37.7634642,23.6335964 C37.3977116,23.4037768 37.0453361,23.1399662 36.7068456,22.8421646 L35,26.0281849 L35,26.0281849 Z"
    />
  </svg>
);

export const OverWatchLeagueLogo = () => (
  <svg width="100px" height="60px" viewBox="0 0 100 60" version="1.1" xmlns="http://www.w3.org/2000/svg">
    <g id="Symbols" stroke="none" strokeWidth="1" fill="none" fillRule="evenodd">
      <g id="Nav/Logo-Small" fillRule="nonzero">
        <g id="Group" transform="translate(7.000000, 6.000000)">
          <path
            d="M2.13162821e-14,45.77 L2.13162821e-14,2.23 C0.00511729901,1.01603724 0.976328679,0.0270868382 2.19,0 L40.54,0 C40.3300545,0.494460137 39.9300254,0.883677639 39.43,1.08 C38.9910188,1.24803701 38.5396652,1.38177143 38.08,1.48 C37.6931334,1.56888819 37.3123546,1.6824538 36.94,1.82 C36.5564903,1.94098217 36.1951346,2.1233486 35.87,2.36 C35.6923624,2.5124923 35.5314565,2.68345486 35.39,2.87 C35.2775661,3.01699993 35.174047,3.17060887 35.08,3.33 C35.0039563,3.42563042 34.9338257,3.52581702 34.87,3.63 C35.0912075,2.93189962 35.1959421,2.20213574 35.18,1.47 C35.12,1.86 34.18,2.73 33.65,3.19 C33.0330432,3.63516408 32.6801148,4.35979366 32.71,5.12 C32.6088096,5.14340286 32.5112559,5.18040599 32.42,5.23 C32,5.55 31.79,5.72 31.32,5.6 C31.165823,5.54315904 31.0155057,5.47635139 30.87,5.4 L30.7,5.31 C30.9638282,5.73055224 31.3325854,6.07518516 31.77,6.31 C31.8646915,6.36118036 31.9467029,6.43294037 32.01,6.52 L31.63,7.32 C31.4683254,7.69244694 31.5059519,8.12138838 31.73,8.46 C31.89,8.71 32.24,9.32 32.24,9.32 L32.4,9.48 C32.342883,9.21387921 32.3160458,8.94215251 32.32,8.67 C32.3417682,8.3217842 32.5586368,8.0158446 32.88,7.88 C32.88,7.96 32.88,8.09 32.88,8.27 C32.8687487,8.45360798 32.895998,8.63754065 32.96,8.81 C33.0052236,8.91092413 33.0587404,9.00792332 33.12,9.1 C33.2352637,9.35347318 33.2006116,9.64994082 33.03,9.87 C32.9550622,9.97959159 32.8678279,10.0802465 32.77,10.17 C32.67,10.26 32.61,10.29 32.58,10.41 C32.6648837,10.4769216 32.7592496,10.530845 32.86,10.57 L33.26,10.73 C33.45,10.8 33.69,10.89 33.69,11.09 C33.6764811,11.17718 33.6252743,11.2539902 33.55,11.3 L32.96,11.58 C32.8591864,11.6470572 32.7520002,11.7039999 32.64,11.75 C32.4644073,11.8099388 32.2836328,11.8534586 32.1,11.88 C31.2401806,12.0576538 30.3672699,12.1646773 29.49,12.2 C29.187494,12.225563 28.8843067,12.1593497 28.62,12.01 C27.8657899,11.5960502 27.0081439,11.4085486 26.15,11.47 C25.4071746,11.5560921 24.6760967,11.7237705 23.97,11.97 C23.4765545,12.1321256 22.9593029,12.2098824 22.44,12.2 C22.2000007,12.2229187 21.9588237,12.1704889 21.75,12.05 C21.75,12.05 21.58,12 21,12 C20.7569294,11.9840085 20.5130706,11.9840085 20.27,12 C20.2240974,12.0784598 20.1704999,12.1521564 20.11,12.22 C20.0226186,12.1873254 19.9414537,12.1399792 19.87,12.08 C19.5743429,11.8870149 19.2210402,11.8022223 18.87,11.84 C18.7174281,11.8616109 18.5625719,11.8616109 18.41,11.84 C18.466762,11.6573226 18.5069248,11.469896 18.53,11.28 C18.554927,11.1698113 18.5251348,11.0543663 18.45,10.97 C18.34,10.77 18.15,10.48 18.15,10.48 C18.15,10.48 18.15,10.39 17.99,10.36 C17.8345675,10.3106826 17.6914007,10.228873 17.57,10.12 C17.3692046,9.92000861 17.0929813,9.81460765 16.81,9.83 C16.6826861,9.85187964 16.5520395,9.81921799 16.45,9.74 C16.2373516,9.63501932 15.9844061,9.65418185 15.79,9.79 C15.5167057,9.91064406 15.2179156,9.96215958 14.92,9.94 L9.29,10.08 C9.18615268,10.0998756 9.07896915,10.0703078 9,10 C8.8850179,9.91162972 8.7249821,9.91162972 8.61,10 C8.61,10.21 8.61,10.73 8.61,10.73 L8,10.73 C8,10.73 7.85,10.37 7.35,10.56 C7.35505662,10.6465929 7.35505662,10.7334071 7.35,10.82 L7.35,10.91 C7.24496538,10.9134629 7.14079705,10.9302642 7.04,10.96 C7.01486383,11.2427758 7.01486383,11.5272242 7.04,11.81 L7.35,11.87 L7.42,12.42 C7.56129788,12.6211225 7.79432328,12.7376352 8.04,12.73 C8.27,12.73 8.52,12.67 8.7,12.95 C8.99356867,13.4344057 9.32812707,13.8927507 9.7,14.32 C9.94,14.54 10.25,14.97 12.17,15.32 C12.8301257,15.439548 13.499172,15.5031074 14.17,15.51 C14.27,15.61 14.91,16.37 14.91,16.37 C14.91,16.37 15,16.58 15.45,16.66 C16.270058,16.8629721 17.1015506,17.0165812 17.94,17.12 C18.21,17.12 18.3,17.19 18.55,16.98 C18.7422141,16.8543269 18.8811322,16.6619788 18.94,16.44 L18.94,16.2 L19.04,16.13 C19.4686787,15.8527064 19.8558669,15.516021 20.19,15.13 C20.2188287,15.2165665 20.2556542,15.300261 20.3,15.38 C20.3,15.43 20.36,15.57 20.79,15.58 C21.5005403,15.5755241 22.2023769,15.736433 22.84,16.05 C23.1574347,16.2018211 23.4479287,16.4044914 23.7,16.65 C24.225946,17.1610732 24.9179466,17.4662632 25.65,17.51 C26.65,17.6 27.65,17.67 28.1,17.72 C28.4389521,17.7685418 28.7847252,17.7235913 29.1,17.59 C29.3690703,17.5280744 29.5647676,17.2956838 29.58,17.02 C29.58,16.87 29.58,16.61 29.58,16.56 L29.58,16.36 C29.6742501,16.3294318 29.7757499,16.3294318 29.87,16.36 L32.39,17.26 C32.39,17.26 32.63,17.26 32.54,16.86 C32.45,16.46 32.45,16.24 32.45,16.24 C32.4119888,16.168878 32.4259197,16.0811538 32.4840941,16.0253064 C32.5422685,15.9694589 32.630488,15.9591187 32.7,16 C32.9873496,16.0028205 33.2731,16.0431617 33.55,16.12 C34.0406018,16.1934176 34.5393982,16.1934176 35.03,16.12 L35.49,15.98 L35.49,15.98 C35.83,15.87 35.87,15.81 35.98,15.88 C36.0873619,16.1567585 36.1317693,16.453946 36.11,16.75 C36.1143477,16.9822784 36.207369,17.2040985 36.37,17.37 L37.93,19.02 L38.42,19.55 C38.5899584,19.7440887 38.8322169,19.8597943 39.09,19.87 C39.2955178,19.9023614 39.4991454,19.9457575 39.7,20 C39.9721771,20.0662733 40.2590092,20.034403 40.51,19.91 C40.7449318,19.7868501 41.020959,19.7686905 41.27,19.86 L43.55,20.36 L43.67,20.63 L43.67,20.76 C43.67,20.76 43.81,21.16 43.88,21.3 L44.46,22.4 C44.46,22.4 44.05,22.62 43.11,23.02 C39.5691552,24.6020422 36.4488787,26.9927699 34,30 L33.94,30.07 L33.94,30.07 C33.3735862,30.7152302 32.9781734,31.4923023 32.79,32.33 C32.815566,32.601368 32.9277601,32.857311 33.11,33.06 C33.4,33.43 33.65,33.82 33.97,33.94 C34.29,34.06 34.16,34.11 35.28,34.14 L36.69,34.14 C37.1052904,34.1415946 37.5189381,34.0877868 37.92,33.98 L39.19,33.64 C39.42,33.58 39.7,33.5 40.4,33.25 C42.4639783,32.4583991 44.673404,32.1174383 46.88,32.25 L47.01,32.45 C47.01,32.45 47.07,32.58 47.43,32.65 C48.325197,32.9321229 49.1869578,33.3110294 50,33.78 C50.2806694,33.9585835 50.5362576,34.1738157 50.76,34.42 C50.98,34.68 51.31,35 51.82,35.62 C51.82,35.62 52.18,36.06 52.42,36.42 C52.586705,36.6659323 52.7704913,36.8998421 52.97,37.12 C53.0748324,37.2253311 53.141671,37.3625262 53.16,37.51 C53.1855913,37.7206047 53.2847591,37.9153987 53.44,38.06 C53.64,38.26 53.81,38.49 54.07,38.18 C54.12,38.05 54.15,38.12 54.15,37.32 C54.15,36.76 54.15,36.39 54.26,36.32 C54.3987194,36.1072605 54.4422245,35.8462301 54.38,35.6 C54.4013722,35.3376218 54.2463369,35.0928292 54,35 C54.0855145,34.6611636 54.0352772,34.3023256 53.86,34 C53.7784024,33.8932138 53.6541861,33.8274523 53.52,33.82 C53.4202861,33.4719879 53.1711664,33.1862329 52.84,33.04 C52.56,32.86 52.37,32.79 51.95,31.99 C51.95,31.99 51.77,31.58 51.68,31.3 C51.68,31.3 51.95,31.06 51.93,30.21 C52.19,30.36 52.44,30.5 52.71,30.63 L54.4,31.49 C55.7479574,32.177769 57.1706729,32.7079318 58.64,33.07 L59.36,33.22 C59.5208048,33.2397684 59.6712771,33.3097555 59.79,33.42 C60.1395502,33.7382429 60.5104119,34.0322594 60.9,34.3 C61.3944865,34.5753092 61.9321259,34.7646665 62.49,34.86 C62.987454,34.9029146 63.4724762,35.0385851 63.92,35.26 C63.92,35.26 66.24,36.45 67.09,36.84 C68.2638904,37.4351874 69.399437,38.103156 70.49,38.84 C70.49,38.84 71.4,39.4 71.7,39.6 C71.9750449,39.812694 72.2387407,40.0396727 72.49,40.28 C72.98,40.7 73.85,41.49 73.85,41.49 L74.01,41.68 L73.57,41.68 L73.5,42.28 C73.5,42.28 74.5,42.93 75.15,43.45 C75.7694231,43.9352058 76.3449737,44.473948 76.87,45.06 C77.14,45.31 77.81,45.95 78.23,46.33 C78.23,46.33 78.65,46.74 78.52,46.88 C78.1845586,47.1645639 77.967097,47.5638378 77.91,48 L2.19,48 C0.976328679,47.9729132 0.00511729901,46.9839628 2.13162821e-14,45.77"
            id="Shape"
            fill="#081418"
          ></path>
          <polygon id="Shape" fill="#FFFFFF" points="39.68 3.43 39.67 3.43 39.67 3.43"></polygon>
          <path
            d="M16.27,15.19 L15.75,15.06 C15.5986169,15.0335628 15.4609229,14.9558893 15.36,14.84 C15.153538,14.704745 14.998564,14.5039833 14.92,14.27 C14.85,13.97 14.78,13.72 14.78,13.72 C14.9254745,13.6935537 15.0745255,13.6935537 15.22,13.72 L15.45,13.72 C15.5017945,13.8746818 15.5723184,14.0224461 15.66,14.16 C15.7880189,14.2854635 15.8899732,14.4349964 15.96,14.6 C15.9835682,14.7074518 16.0393916,14.8051426 16.12,14.88 C16.2161301,14.9291856 16.2718524,15.0326699 16.26,15.14 C16.2621803,15.1699604 16.2621803,15.2000396 16.26,15.23"
            id="Shape"
            fill="#081418"
          ></path>
          <path
            d="M48.33,29.32 C48.19,29.46 48.13,29.56 47.95,29.76 C46.9129104,29.8039463 45.8740621,29.7805638 44.84,29.69 C44.84,29.49 44.99,29.5 45.28,29.41 C46.2192025,29.0801485 47.1290627,28.6720494 48,28.19 C48.4,27.93 48.6,27.83 48.6,27.83 L48.84,27.95 L48.84,28.07 L48.69,28.27 C48.5410669,28.4014229 48.4570412,28.5913941 48.46,28.79 C48.4988377,28.9805356 48.4429296,29.1780778 48.31,29.32"
            id="Shape"
            fill="#081418"
          ></path>
          <path
            d="M86.14,45.77 C86.14,47.001595 85.141595,48 83.91,48 L80.23,48 C80.3921812,47.9241288 80.5254794,47.7978463 80.61,47.64 C80.7993182,47.146985 80.9302108,46.6334832 81,46.11 C80.9820357,45.9371474 80.8956024,45.7786864 80.76,45.67 C80.3443263,45.4306683 79.9993317,45.0856737 79.76,44.67 L79.46,44 C79.6709955,43.7472694 79.7589131,43.4139152 79.7,43.09 C79.6561941,42.8301474 79.5858252,42.5754788 79.49,42.33 C79.3233201,41.6891909 79.0196779,41.0921416 78.6,40.58 C78.5200771,40.4990708 78.455678,40.4041668 78.41,40.3 C78.41,40.25 78.41,40.21 78.19,40.1 C77.9711324,39.974898 77.72199,39.9126124 77.47,39.92 C77.3,40.14 77.1,40.36 77.1,40.36 L76.65,40.3 C76.55,40.3 76.47,40.24 76.17,40.44 L75.89,40.62 L75.74,40.52 C74.9877431,39.9429016 74.2760641,39.314753 73.61,38.64 C72.08,37.14 70.75,35.52 70.75,35.52 C70.2864504,34.9068332 69.7784122,34.3286055 69.23,33.79 C68.4732693,33.1591416 67.6274666,32.6435726 66.72,32.26 C66.45,32.14 66.47,32.06 63.41,31.58 C62.8676517,31.4281055 62.3790153,31.1266066 62,30.71 C61.39,30.07 59.57,28.71 58.53,27.71 C58.53,27.71 57.19,26.57 56.15,25.66 C54.23,24.03 53.28,23.37 53.28,23.37 C52.7948559,22.8424343 52.4719794,22.1862659 52.35,21.48 C52.1560709,20.7522935 51.8158077,20.0717672 51.35,19.48 C50.7420271,18.8490505 50.0320898,18.3250492 49.25,17.93 C48.9146813,17.7520231 48.6023668,17.5337388 48.32,17.28 C48.3376122,17.0870678 48.3376122,16.8929322 48.32,16.7 C48.32,16.28 48.21,15.45 48.17,15.36 L47.71,15.06 L47.71,14.58 L48.04,14.32 C48.13,14.23 48.22,14.24 48.19,13.88 C48.16,13.52 48.19,13.13 48.19,13.13 C48.19,13.13 48.19,12.9 47.93,12.54 L46,9.94 L45.66,9.5 C45.5635542,9.36054038 45.4091146,9.2722892 45.24,9.26 L44.62,9.09 C44.4848195,9.06164585 44.3440416,9.07924307 44.22,9.14 C44.0817699,9.1940913 43.9282301,9.1940913 43.79,9.14 C43.59,9.14 43.12,8.96 43.12,8.96 C43.12,8.96 42.75,8.46 42.64,8.3 C42.5728037,8.21014282 42.4876714,8.13522642 42.39,8.08 L41.78,7.7 L40.45,8.08 L40.29,8.08 L40.2,8.08 L40,7.27 L40.74,6.71 C40.74,6.71 41.19,6.38 41.52,6.08 L41.94,5.67 C41.4655235,5.68972109 40.9902364,5.66629145 40.52,5.6 C40.4760998,5.5889993 40.4351407,5.56851974 40.4,5.54 L40.56,5.37 C42.2,3.77 42.35,2.8 42.4,2.51 C42.0430937,2.82195175 41.6071438,3.02954693 41.14,3.11 L40.28,3.26 C41.0821112,2.36173442 41.5330721,1.20414987 41.55,0 L83.91,0 C85.141595,8.8817842e-16 86.14,0.998405008 86.14,2.23 L86.14,45.77 Z"
            id="Shape"
            fill="#F89C2D"
          ></path>
        </g>
      </g>
    </g>
  </svg>
);

export const PageXlLogo = () => (
  <svg height="250pt" viewBox="0 0 850 250" width="850pt" xmlns="http://www.w3.org/2000/svg">
    <g fill="#2f343b">
      <path
        d="m281.163 165.5c-4.08 0-7.95-.5-11.61-1.5s-7.08-2.35-10.26-4.05-6.09-3.7-8.73-6-4.92-4.75-6.84-7.35v49.35h-6.12v-109.95h5.76v16.2c1.92-2.5 4.2-4.825 6.84-6.975s5.55-4 8.73-5.55 6.48-2.75 9.9-3.6 6.93-1.275 10.53-1.275c6.6 0 12.66 1.15 18.18 3.45s10.26 5.35 14.22 9.15 7.05 8.125 9.27 12.975 3.33 9.775 3.33 14.775c0 5.4-1.05 10.55-3.15 15.45s-5.04 9.175-8.82 12.825-8.31 6.575-13.59 8.775-11.16 3.3-17.64 3.3zm-.9-4.8c5.76 0 10.98-1.025 15.66-3.075s8.64-4.75 11.88-8.1 5.76-7.15 7.56-11.4 2.7-8.575 2.7-12.975c0-4.6-1.02-9.05-3.06-13.35s-4.83-8.1-8.37-11.4-7.71-5.925-12.51-7.875-9.96-2.925-15.48-2.925c-3.48 0-7.2.625-11.16 1.875s-7.65 2.9-11.07 4.95-6.3 4.425-8.64 7.125-3.69 5.55-4.05 8.55v26.85c1.56 3 3.6 5.825 6.12 8.475s5.37 4.95 8.55 6.9 6.63 3.5 10.35 4.65 7.56 1.725 11.52 1.725z"
        opacity=".810484"
      />
      <path
        d="m369.363 165.5c-4.32 0-8.34-.625-12.06-1.875s-6.96-2.95-9.72-5.1-4.92-4.675-6.48-7.575-2.34-6.05-2.34-9.45c0-3.3.96-6.325 2.88-9.075s4.59-5.125 8.01-7.125 7.5-3.55 12.24-4.65 9.99-1.65 15.75-1.65c5.16 0 10.44.35 15.84 1.05s10.2 1.75 14.4 3.15v-8.4c0-7.8-2.67-14.025-8.01-18.675s-12.51-6.975-21.51-6.975c-4.56 0-9.39.825-14.49 2.475s-10.29 4.025-15.57 7.125l-2.88-3.75c12.12-6.8 23.22-10.2 33.3-10.2 10.92 0 19.53 2.7 25.83 8.1s9.45 12.8 9.45 22.2v40.8c0 2.2 1.08 3.3 3.24 3.3v4.8c-.36.1-.84.15-1.44.15-2.04 0-3.81-.625-5.31-1.875s-2.25-2.775-2.25-4.575v-6.9c-4.2 4.7-9.75 8.325-16.65 10.875s-14.31 3.825-22.23 3.825zm.9-4.35c7.56 0 14.46-1.175 20.7-3.525s10.92-5.525 14.04-9.525c1.92-2.1 2.88-4.1 2.88-6v-14.7c-9.24-3-19.2-4.5-29.88-4.5-9.96 0-17.97 1.675-24.03 5.025s-9.09 7.825-9.09 13.425c0 2.8.66 5.4 1.98 7.8s3.09 4.5 5.31 6.3 4.89 3.2 8.01 4.2 6.48 1.5 10.08 1.5z"
        opacity=".810484"
      />
      <path
        d="m480.783 165.35c-6.48 0-12.45-1.15-17.91-3.45s-10.17-5.325-14.13-9.075-7.05-8.025-9.27-12.825-3.33-9.7-3.33-14.7c0-5.3 1.05-10.375 3.15-15.225s5.07-9.15 8.91-12.9 8.43-6.75 13.77-9 11.19-3.375 17.55-3.375c4.2 0 8.1.5 11.7 1.5s6.96 2.35 10.08 4.05 6 3.7 8.64 6 5.04 4.75 7.2 7.35v-17.7h5.76v80.4c0 5.3-1.17 9.875-3.51 13.725s-5.49 7.075-9.45 9.675-8.52 4.525-13.68 5.775-10.5 1.875-16.02 1.875-10.41-.45-14.67-1.35-8.01-2.15-11.25-3.75-6.09-3.525-8.55-5.775-4.59-4.725-6.39-7.425l4.5-2.1c3.84 5.6 9 9.65 15.48 12.15s13.44 3.75 20.88 3.75c4.92 0 9.6-.55 14.04-1.65s8.31-2.775 11.61-5.025 5.94-5.025 7.92-8.325 2.97-7.15 2.97-11.55v-18.3c-1.92 2.6-4.23 4.95-6.93 7.05s-5.61 3.9-8.73 5.4-6.42 2.675-9.9 3.525-6.96 1.275-10.44 1.275zm1.08-4.65c4.2 0 8.31-.675 12.33-2.025s7.65-3.1 10.89-5.25 5.91-4.55 8.01-7.2 3.33-5.325 3.69-8.025v-26.85c-1.44-3.1-3.45-6-6.03-8.7s-5.49-5-8.73-6.9-6.72-3.4-10.44-4.5-7.5-1.65-11.34-1.65c-6 0-11.34 1.05-16.02 3.15s-8.64 4.85-11.88 8.25-5.73 7.225-7.47 11.475-2.61 8.525-2.61 12.825c0 4.7 1.02 9.175 3.06 13.425s4.86 8 8.46 11.25 7.8 5.85 12.6 7.8 9.96 2.925 15.48 2.925z"
        opacity=".810484"
      />
      <path
        d="m590.943 165.5c-6.36 0-12.3-1.075-17.82-3.225s-10.35-5.1-14.49-8.85-7.38-8.1-9.72-13.05-3.51-10.225-3.51-15.825c0-5.5 1.14-10.65 3.42-15.45s5.46-9 9.54-12.6 8.82-6.45 14.22-8.55 11.28-3.15 17.64-3.15 12.3 1.05 17.82 3.15 10.32 4.975 14.4 8.625 7.32 7.925 9.72 12.825 3.6 10.1 3.6 15.6c0 .2-.03.6-.09 1.2s-.09.95-.09 1.05h-83.88c.36 4.8 1.68 9.275 3.96 13.425s5.19 7.725 8.73 10.725 7.59 5.375 12.15 7.125 9.42 2.625 14.58 2.625c3.48 0 6.87-.375 10.17-1.125s6.39-1.825 9.27-3.225 5.4-3.075 7.56-5.025 3.9-4.075 5.22-6.375l5.58 1.2c-1.32 2.7-3.27 5.225-5.85 7.575s-5.55 4.35-8.91 6-7.02 2.95-10.98 3.9-8.04 1.425-12.24 1.425zm38.7-42.6c-.36-4.9-1.62-9.4-3.78-13.5s-5.01-7.65-8.55-10.65-7.59-5.325-12.15-6.975-9.48-2.475-14.76-2.475-10.2.85-14.76 2.55-8.58 4.05-12.06 7.05-6.27 6.55-8.37 10.65-3.33 8.55-3.69 13.35z"
        opacity=".810484"
      />
    </g>
    <path
      d="m52.1714 88.9154 66.2976 32.0126c1.725.823 4.036 1.254 6.309 1.254s4.585-.431 6.309-1.254l66.297-32.0126c3.488-1.6848 3.488-4.4276 0-6.1125l-66.297-32.0128c-1.724-.8228-4.036-1.2538-6.309-1.2538s-4.584.431-6.309 1.2538l-66.2976 32.0128c-3.4872 1.6849-3.4872 4.4277 0 6.1125z"
      fill="#ff00b2"
    />
    <path
      d="m197.384 121.712s-12.107-5.838-13.713-6.622c-1.607-.784-2.038-.745-3.723.039s-48.901 23.588-48.901 23.588c-1.763.823-4.036 1.254-6.308 1.254-2.273 0-4.585-.431-6.309-1.254 0 0-45.9617-22.177-48.1167-23.235-2.3511-1.137-3.0171-1.137-5.133-.118-2.1944 1.058-13.0873 6.309-13.0873 6.309-3.4872 1.685-3.4872 4.427 0 6.112l66.298 32.013c1.724.823 4.036 1.254 6.309 1.254 2.272 0 4.584-.431 6.308-1.254l66.298-32.013c3.566-1.645 3.566-4.388.078-6.073z"
      fill="#cd008f"
    />
    <path
      d="m197.384 160.621s-12.107-5.838-13.713-6.622c-1.607-.784-2.038-.745-3.723.039s-48.861 23.628-48.861 23.628c-1.764.822-4.036 1.253-6.309 1.253s-4.584-.431-6.309-1.253c0 0-45.9616-22.178-48.1166-23.236-2.351-1.136-3.017-1.136-5.1329-.118-2.1944 1.058-13.0873 6.309-13.0873 6.309-3.4872 1.685-3.4872 4.428 0 6.112l66.2978 32.013c1.724.862 4.036 1.254 6.309 1.254 2.272 0 4.584-.431 6.308-1.254l66.298-32.013c3.527-1.684 3.527-4.427.039-6.112z"
      fill="#9a006b"
    />
    <g fill="#2f343b">
      <path
        d="m673.64 85.4 20.16 24.6 1.62 2.7 1.62-2.7 20.16-24.6h24.84l-33.48 39.45 34.02 39.15h-24.84l-20.7-24.45-1.62-2.55-1.62 2.55-20.7 24.45h-24.84l34.2-39.15-33.66-39.45z"
        opacity=".810484"
      />
      <path
        d="m753.56 54.5h24.12v83.4c0 6.1 3.3 9.15 9.9 9.15 1.32 0 2.85-.2 4.59-.6s3.39-.85 4.95-1.35l3.24 16.05c-3.24 1.3-7.02 2.3-11.34 3s-8.22 1.05-11.7 1.05c-7.56 0-13.41-1.675-17.55-5.025s-6.21-8.125-6.21-14.325z"
        opacity=".810484"
      />
    </g>
  </svg>
);

export const HomelyLogo = () => (
  <svg
    version="1.0"
    xmlns="http://www.w3.org/2000/svg"
    width="3032.000000pt"
    height="880.000000pt"
    viewBox="0 0 3032.000000 880.000000"
    preserveAspectRatio="xMidYMid meet"
  >
    <g transform="translate(0.000000,880.000000) scale(0.100000,-0.100000)" fill="#000000" stroke="none">
      <path
        d="M3855 6549 c-27 -4 -73 -21 -102 -36 -59 -31 -1539 -1347 -1650
-1467 -73 -79 -132 -189 -160 -301 -17 -65 -18 -141 -18 -1060 0 -1109 -5
-1038 73 -1140 40 -53 120 -107 187 -128 31 -9 428 -12 1735 -12 1307 0 1704
3 1735 12 67 21 147 75 187 128 78 102 73 31 73 1140 0 919 -1 995 -18 1060
-28 109 -87 221 -157 298 -50 54 -1135 1031 -1538 1384 -125 110 -220 144
-347 122z m-866 -2348 c206 -178 442 -293 694 -337 121 -22 352 -22 474 0 252
44 488 159 695 338 32 27 62 48 66 46 5 -1 82 -79 172 -173 l163 -169 -49 -44
c-381 -340 -795 -502 -1284 -502 -489 0 -903 162 -1284 502 l-49 43 164 172
c90 95 168 172 173 173 4 0 34 -22 65 -49z"
      />
      <path
        d="M6790 4620 l0 -1420 320 0 319 0 3 673 c3 671 3 672 26 728 61 151
211 227 391 198 113 -18 189 -76 234 -179 43 -98 47 -161 47 -809 l0 -611 315
0 315 0 0 723 c0 770 -4 840 -50 978 -85 251 -239 400 -486 471 -67 19 -104
23 -234 23 -135 0 -165 -3 -230 -23 -136 -43 -241 -114 -308 -207 l-21 -30 -1
453 0 452 -320 0 -320 0 0 -1420z"
      />
      <path
        d="M17790 4620 l0 -1420 320 0 320 0 0 1420 0 1420 -320 0 -320 0 0
-1420z"
      />
      <path
        d="M10120 5393 c-338 -35 -602 -170 -796 -406 -186 -228 -272 -523 -243
-835 24 -262 124 -483 303 -670 209 -218 468 -329 796 -339 599 -20 1066 353
1166 931 24 136 15 369 -20 494 -85 306 -266 538 -537 686 -197 108 -454 161
-669 139z m256 -613 c79 -28 144 -71 209 -142 199 -215 193 -550 -14 -757
-103 -104 -213 -151 -351 -151 -138 0 -248 47 -352 152 -109 109 -158 229
-158 390 0 362 339 620 666 508z"
      />
      <path
        d="M12735 5393 c-171 -24 -331 -115 -416 -240 -16 -23 -34 -43 -39 -43
-6 0 -10 47 -10 110 l0 110 -295 0 -295 0 0 -1065 0 -1065 320 0 320 0 0 633
c0 674 2 703 50 798 30 57 82 111 132 136 85 43 220 49 310 14 42 -16 111 -84
136 -135 49 -96 52 -152 52 -822 l0 -624 315 0 315 0 0 593 c0 370 4 626 11
682 27 218 138 326 338 328 111 2 165 -17 227 -77 62 -61 89 -128 104 -254 5
-48 10 -350 10 -679 l0 -593 315 0 315 0 0 708 c0 396 -5 740 -10 782 -61 471
-358 728 -815 707 -134 -6 -202 -23 -321 -82 -102 -50 -216 -147 -275 -234
-19 -28 -37 -51 -42 -51 -4 0 -24 26 -44 58 -20 31 -69 89 -109 129 -124 123
-286 185 -477 182 -51 -1 -105 -4 -122 -6z"
      />
      <path
        d="M16164 5385 c-156 -30 -344 -111 -463 -201 -230 -174 -396 -445 -445
-729 -89 -508 177 -1009 649 -1222 283 -128 623 -129 902 -3 170 77 351 234
463 401 53 80 130 218 130 234 0 3 -144 5 -320 5 l-320 0 -63 -64 c-98 -100
-187 -136 -337 -136 -239 0 -428 137 -486 353 l-12 47 798 0 798 0 7 32 c11
49 8 249 -5 336 -62 403 -320 735 -685 881 -55 22 -134 47 -175 56 -101 22
-343 28 -436 10z m359 -545 c80 -25 173 -84 220 -141 35 -44 97 -162 97 -186
0 -10 -104 -13 -486 -13 l-485 0 6 23 c49 167 193 297 369 334 77 16 196 9
279 -17z"
      />
      <path
        d="M18620 5326 c0 -3 176 -454 391 -1003 214 -549 390 -1005 391 -1013
1 -8 -70 -186 -157 -395 -86 -209 -161 -390 -166 -403 l-9 -22 337 2 336 3
532 1418 533 1417 -337 0 -337 0 -18 -57 c-78 -254 -390 -1183 -395 -1178 -3
4 -101 282 -217 618 l-210 612 -337 3 c-185 1 -337 0 -337 -2z"
      />
      <path
        d="M21382 4120 c-104 -27 -167 -64 -247 -145 -116 -115 -165 -236 -165
-401 0 -163 51 -287 164 -400 110 -110 240 -164 396 -164 248 0 462 149 540
375 l19 55 -165 0 c-99 0 -164 -4 -164 -10 0 -18 -64 -81 -102 -101 -89 -46
-214 -30 -287 36 -88 80 -112 230 -56 341 67 130 214 177 344 109 30 -15 101
-89 101 -105 0 -6 62 -10 164 -10 l165 0 -18 53 c-37 108 -85 178 -172 252
-136 116 -339 161 -517 115z"
      />
      <path
        d="M22653 4129 c-270 -45 -463 -275 -463 -551 0 -165 52 -292 164 -403
120 -120 264 -172 441 -162 153 9 266 59 370 162 82 81 118 143 145 251 106
412 -233 774 -657 703z m212 -313 c168 -77 200 -316 61 -444 -99 -91 -237 -89
-337 5 -58 55 -84 116 -83 198 0 106 67 211 158 251 50 22 143 17 201 -10z"
      />
      <path
        d="M23987 4129 c-61 -14 -112 -45 -156 -95 l-41 -47 0 57 0 56 -145 0
-145 0 0 -530 0 -530 155 0 155 0 0 305 c0 181 4 324 11 355 19 91 80 140 171
140 70 0 113 -26 141 -88 21 -45 22 -63 25 -379 l4 -333 153 0 154 0 3 338 c3
314 4 340 23 377 30 59 75 85 149 85 77 0 120 -24 146 -83 18 -39 20 -68 20
-379 l0 -338 161 0 161 0 -5 388 c-4 409 -7 434 -55 529 -89 174 -352 237
-537 129 -24 -15 -65 -51 -92 -80 l-47 -54 -34 49 c-78 111 -229 163 -375 128z"
      />
      <path
        d="M26278 4124 c-90 -21 -176 -70 -244 -138 -220 -220 -220 -614 0 -831
103 -102 211 -145 362 -145 120 0 201 28 267 91 28 27 52 49 54 49 2 0 3 -25
3 -55 l0 -55 155 0 155 0 0 530 0 530 -155 0 -155 0 0 -56 0 -56 -40 40 c-93
96 -249 134 -402 96z m289 -310 c93 -44 147 -133 147 -244 0 -241 -283 -359
-453 -189 -76 75 -98 203 -52 304 65 146 211 198 358 129z"
      />
      <path
        d="M27243 3723 c4 -400 7 -425 56 -521 66 -128 213 -201 387 -190 102 6
166 35 208 96 l31 44 3 -56 3 -56 149 0 150 0 0 530 0 530 -154 0 -154 0 -4
-327 c-3 -316 -4 -330 -25 -373 -28 -56 -76 -89 -140 -97 -88 -10 -156 29
-182 106 -7 23 -11 144 -11 362 l0 329 -161 0 -161 0 5 -377z"
      />
      <path d="M20460 3200 l0 -160 165 0 165 0 0 160 0 160 -165 0 -165 0 0 -160z" />
      <path d="M25360 3200 l0 -160 165 0 165 0 0 160 0 160 -165 0 -165 0 0 -160z" />
    </g>
  </svg>
);

export const WishLogo = () => (
  <svg width="85" height="30" viewBox="0 0 143 48" xmlns="http://www.w3.org/2000/svg">
    <g fill="#2fb7ec" fillRule="evenodd">
      <path d="M71.04 10.045c-.867-1.022-1.192-2.273-.974-3.757.217-1.48.91-2.734 2.076-3.755C73.309 1.51 74.629 1 76.105 1c1.475 0 2.647.511 3.513 1.533.868 1.02 1.192 2.274.975 3.755-.218 1.484-.91 2.735-2.076 3.757-1.168 1.02-2.49 1.532-3.964 1.532-1.476 0-2.647-.511-3.514-1.532M59.272 15.146c-1.732 0-3.343 1.411-3.582 3.134l-1.76 12.833c-.194 1.398-.864 2.61-2.008 3.638-1.145 1.028-2.435 1.542-3.865 1.542-1.392 0-2.52-.503-3.381-1.511-.864-1.007-1.195-2.23-.997-3.669l1.062-7.788c.032-1.554-1.134-2.77-2.742-2.77h-4.21c-1.608 0-3.112 1.216-3.508 2.77l-1.097 7.788c-.198 1.44-.87 2.662-2.012 3.669-1.142 1.008-2.409 1.511-3.799 1.511-1.392 0-2.528-.514-3.408-1.542-.881-1.027-1.224-2.24-1.031-3.638l2.358-17.028c.25-1.658-.732-3.39-2.23-4.093 0 0-17.758-7.402-18.915-7.878-1.172-.48-2.5.596-2.954 2.39L.108 8.787c-.455 1.794.57 3.834 2.275 4.533l11.901 4.926-1.783 12.867c-.598 4.315.413 8.007 3.038 11.069 2.624 3.064 6.084 4.594 10.382 4.594 3.967 0 7.59-1.335 10.865-4.008 2.616 2.673 5.89 4.008 9.818 4.008 4.297 0 8.181-1.53 11.654-4.594 3.472-3.062 5.508-6.754 6.106-11.069 0 0 1.865-13.579 1.899-13.816.162-1.184-1.12-2.15-2.851-2.15h-4.14zM76.717 15h-3.72c-1.557 0-3.005 1.267-3.22 2.815 0 0-3.747 26.755-3.764 26.886-.147 1.063 1.005 1.933 2.561 1.933h3.72c1.556 0 3.004-1.267 3.218-2.815l3.765-26.886C79.424 15.87 78.272 15 76.717 15M140.49 18.517c-2.133-2.517-5.02-3.776-8.663-3.776-3.644 0-7.046.798-10.4 3.693l2.375-16.463C123.952.887 122.776 0 121.19 0h-3.795c-1.589 0-3.067 1.292-3.284 2.873l-6.097 41.94c-.15 1.083 1.025 1.971 2.613 1.971h3.795c1.559 0 3.008-1.246 3.268-2.787h.005l1.91-13.08c.386-2.643 1.4-4.647 3.044-6.01 1.643-1.364 3.436-2.046 5.375-2.046 3.92 0 5.503 2.602 4.744 7.804l-2.035 14.108c-.15 1.084 1.026 1.971 2.614 1.971h3.793c1.59 0 3.066-1.292 3.286-2.873l2.345-15.283c.612-4.196-.148-7.554-2.28-10.071M105.235 23.153l1.775-2.266c.752-.96.77-2.437.045-3.447-.318-.547-1.242-1.078-2.086-1.534l-.095-.052c-2.67-1.448-5.294-1.994-8.772-1.824-3.778.185-7.002 1.3-9.581 3.315-2.6 2.03-4.07 4.601-4.366 7.64-.301 3.084.74 5.386 3.091 6.843 1.117.706 2.138 1.244 3.034 1.6.89.357 2.2.775 3.895 1.245 1.646.459 2.9.98 3.724 1.543.756.52 1.094 1.077 1.032 1.703-.063.654-.401 1.183-1.031 1.616-.655.45-1.53.706-2.598.758-2.888.141-5.605-.533-8.075-2.004l-1.833-1.015a1.853 1.853 0 0 0-.99-.224 1.938 1.938 0 0 0-1.444.742l-2.636 3.494c-.27.358-.376.787-.3 1.207.073.408.308.76.664.998.863.68 1.76 1.273 2.668 1.764a19.146 19.146 0 0 0 3.8 1.579c2.49.736 4.961 1.05 7.34.934 3.586-.176 6.684-1.306 9.21-3.36 2.543-2.067 3.99-4.755 4.307-7.989.321-3.282-.62-5.61-2.798-6.922-1.116-.662-2.102-1.152-2.932-1.456-.825-.3-2.22-.724-4.147-1.258-1.904-.526-3.27-1.008-4.063-1.43-.698-.372-.992-.87-.924-1.567.127-1.307 1.47-2.032 3.988-2.154 2.025-.1 4.057.368 6.029 1.383.405.223.852.49 1.26.752.507.283.897.396 1.269.377.548-.026 1.023-.331 1.54-.99z"></path>
    </g>
  </svg>
);

export const DeadspinLogo = () => (
  <svg xmlns="http://www.w3.org/2000/svg" width="254" height="33" viewBox="0 0 254 33">
    <path
      fill="#249D9D"
      fillRule="evenodd"
      d="M253.73 11.23l-3.3 21.68c-.22.03-.75.09-1.46.09-1.6 0-4.53-.3-6.32-2.37-1.39-1.6-1.86-3.98-1.4-7.06 1.15-7.7 1.62-10.7 1.8-11.8l.07-.54h10.61zm-34.8-.13l-3.3 21.82c-.19.03-.7.08-1.38.08-1.62 0-4.62-.3-6.38-2.34-1.27-1.45-1.72-3.56-1.32-6.27 1.33-9.19 1.8-12.65 1.9-13.26h5.23l-.05-.03h5.3zm15.17.13l-3.16 21.72H220.9l3.13-21.72h10.06zM196.6.17c2.59 0 4.72.98 6.18 2.83a10.47 10.47 0 0 1 2.02 6.95h-28.58L177.4.17h19.2zm48.75-.04c3.12 0 5.44.91 6.9 2.71 1.85 2.3 1.85 5.42 1.68 7.08h-29.87V.13h21.29zM220.6 0l-1.47 9.79h-5.47c-2.05 0-3.35-.9-3.8-1.51-2.24-3-1.57-7.57-1.45-8.28h12.2zm-15.9 11.27c-.69 5.31-4.43 10.38-10.82 10.38h-8.81l-.06.62c-.04.46-.13 1.3-.34 2.78-1.3 7.5-9.66 7.93-11.08 7.95h-.13l2.62-21.73h28.62zM173.47 0c-.05 6.99-4.25 9.53-7.38 10.45h-22.6v-.01C143.86.62 153.5.03 154.16 0h19.3zm-9.08 11.77l.5.23c2.6 1.22 5.58 4 4.92 10.3v.13c-.97 9.94-10.2 10.56-12.25 10.57h-.08a9 9 0 0 1-.48-.01h-16.58c.05-6.93 4.7-9.44 8.04-10.34h12.12v-1.31h-10.64l-.46-.2c-2.6-1.12-5.72-3.66-5.98-9.37h20.89zM119 12l-1.66 10.88h8.5L127.49 12h10.28l-1.54 11.77c-.06.36-1.62 9.22-10.55 9.22h-19.25s-.53-.03-.87-.43c-.25-.3-.33-.72-.25-1.28L107.88 12H119zM129.31.77c3.16 0 5.5.91 6.97 2.71 1.94 2.38 1.85 5.68 1.7 7.16h-30V.77h21.33zM92.17.31c3.83 0 6.64 1.07 8.34 3.18 1.83 2.26 1.97 5.15 1.85 6.84H72.32C73.24.97 83.08.33 83.52.31h8.65zm10 11.4v.04L101.1 22.5c-.05.43-1.26 10.5-10.57 10.5-.43 0-.88-.02-1.34-.07l1.46-10.91h-20l1.59-10.24v-.17h29.96l-.02.1zm-39.34-.38h2.42c.06.03.18.1.29.26.22.32.25.87.1 1.58-.14.69-1.57 6.67-7.5 8.47H45.61v1.31H57.5l.26.1c1.5.52 2.7 1.31 3.6 2.34 1.44 1.66 2 3.92 1.66 6.71-.1.52-.95.9-2.09.9H42.3a7.32 7.32 0 0 1-4.63-2.78c-1.6-2.1-2.08-5.1-1.44-8.93.79-5.4 1.54-9.39 1.66-9.96h24.94zM80.51 23.3l-1.23 9.69H68.95l1.5-9.7h10.06zM23.87.47c3.1 0 5.42.9 6.89 2.7 2.33 2.83 1.77 7.04 1.63 7.88H2.66V.47h21.2zM68.12.14c-.04 5.7-2.91 8.46-5.4 9.8H37.9V.13h30.22zM30.75 23.69c0 .08-1.6 9.31-10.48 9.31H1.13c.01 0-.5-.03-.84-.43-.25-.3-.34-.74-.26-1.3.2-1.39 1.68-12.79 2.47-18.81h11.04L11.98 22.8h8.46l1.54-10.34H32.2l-1.45 11.23z"
    ></path>
  </svg>
);

export const MiuiLogo = () => (
  <svg viewBox="0 0 256.8 92.1" fill="#4B4B4B">
    <path d="M85.2,0l-38,48.3L9.1,0H0v89.7h9V15l38.2,48.7l38.2-48.8v74.9h9V0H85.2z" />
    <path
      d="M228.1,0h0.2l0,0H220l0,0l0,0h-0.1v52.6c0,17.1-13.8,30.9-30.9,30.9h0c-17.1,0-30.9-13.8-30.9-30.9V0.2h-8.8
	l0,0l0,0l0,0l0,0v52.5c0,21.8,17.7,39.4,39.4,39.4h0c21.8,0,39.4-17.6,39.4-39.4L228.3,0H228.1z"
    />
    <polygon points="117.1,0 117.1,89.8 125.4,89.8 125.4,0 " />
    <polygon points="248.5,0 248.5,89.8 256.8,89.8 256.8,0 " />
  </svg>
);

export const JimdoLogo = () => (
  <svg viewBox="0 0 543 117">
    <g fill="none" fillRule="evenodd">
      <path
        d="M140.653 114.788h-29.064a1.417 1.417 0 01-1.417-1.417V2.819c0-.782.634-1.417 1.417-1.417h29.064c.783 0 1.417.635 1.417 1.417V113.37c0 .782-.634 1.417-1.417 1.417M56.19 1.457c-.783 0-1.417.635-1.417 1.417V58.15h.013c0 14.504-11.757 26.262-26.26 26.262a26.13 26.13 0 01-11.939-2.872c-.674-.345-1.502-.074-1.88.582L.191 107.262a1.421 1.421 0 00.535 1.954 57.835 57.835 0 0027.054 7.076c32.387.408 58.89-26.637 58.89-59.027V2.875c0-.783-.634-1.418-1.417-1.418H56.19zM175.355 2.396a4.704 4.704 0 00-7.594 3.709V113.37c0 .783.634 1.418 1.417 1.418h29.043c.783 0 1.417-.635 1.417-1.418V65.324l24.816-24.646-49.1-38.282z"
        fill="#00828C"
      ></path>
      <path
        d="M355.35 83.691v-.014h-16.544V32.576h16.543v-.03c13.836.72 24.828 11.893 24.828 25.573 0 13.679-10.992 24.853-24.828 25.572m0-82.241l-47.025-.033c-.782 0-1.417.635-1.417 1.417v106.284a5.67 5.67 0 005.67 5.67l42.772.015v-.015c31.436-.738 56.693-25.817 56.693-56.669 0-30.852-25.257-55.932-56.693-56.669M484.282 84.355c-14.495 0-26.245-11.75-26.245-26.245 0-14.495 11.75-26.246 26.245-26.246 14.495 0 26.245 11.751 26.245 26.246s-11.75 26.245-26.245 26.245m0-84.355c-32.093 0-58.11 26.016-58.11 58.11 0 32.093 26.017 58.11 58.11 58.11 32.094 0 58.11-26.017 58.11-58.11 0-32.094-26.016-58.11-58.11-58.11M276.444 1.402h-.65c-.626 0-1.236.208-1.732.592l-49.608 38.684 24.815 24.645v48.047c0 .783.635 1.418 1.418 1.418h29.042c.783 0 1.418-.635 1.418-1.418V6.105a4.703 4.703 0 00-4.703-4.703"
        fill="#006678"
      ></path>
      <path
        d="M199.638 65.323l23.815 23.735a1.418 1.418 0 002 0l23.816-23.735-24.816-24.646-24.815 24.646z"
        fill="#005469"
      ></path>
    </g>
  </svg>
);

export const RedBullLogo = () => (
  <Svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 237 48">
    <path
      d="M49.92 11.03l-.31.15c-1.08.76-1.34 1.74-1.24 1.82l2.02-1.15c2.86-1.2 7-2.63 8.37-2.82-.05 0-5.56.3-8.84 2m17.77-.48c-2.38-.48-4.83-.6-7.25-.34-5.62.58-8.32 1.4-9.68 1.94l-3.01 1.07-.72.77 2.2-.2 2.38-.91c.87-.3 1.85-.59 3.02-.86 5.52-1.32 14.24-1.14 13.06-1.47m18.13 11.3c-.16-1.86-.52-3.7-1.07-5.49l-.36-1.02a25.77 25.77 0 00-2.78-5.25C80.15 8.16 78.58 6 72.22 4.15c6.05 1.47 6.5 2.22 7.29 2.75l-.93-.9C73.98 2.6 66.75.99 59.6 2.33 64.06.88 71.39 1.06 75.97 3.9 71.13.87 67.6.48 64.16.2c-.53-.03-1.14-.06-1.83-.06-6.17 0-13.63 3.1-17.47 6.6-.34.3-.63.58-.88.84-1.19 1.39-.4 2.34.17 2.66.2.11-.04 2.15.14 2.27.62.41 2.8-2.14 3.79-2.58a36.03 36.03 0 0121.3-2.36c7.83 2.2 11.2 5.9 11.4 6.19.22.28 1.52 1.6 1.49 2.14a.27.27 0 01-.29.03 6.4 6.4 0 01-.62-.59.4.4 0 01-.11-.07 18.34 18.34 0 00-4.43-2.9c-2.4-1.02-5.15-1.3-7.51-1.94 2.7 1.07 5.54 1.4 8.07 2.84 3.02 1.7 5.19 4.74 5.22 4.76 2.04 2.67 2.99 6.02 2.66 9.36 0 .08.02.16.01.24l.01.05v.02c-.07.68-.19 1.37-.34 2.04-.09.38-.22.8-.36 1.3l.03-.03a22.6 22.6 0 001.21-9.16M73.72 10l.26.01c.1-.18-1.26-.7-1.76-.82-.69-.21-1.39-.38-2.1-.51.02 0-.23.09 1.25.57.37.12.11.5 2.34.75"
      fill="currentcolor"
    />
    <path d="M80.97 21.63c-.17-.08-.34-.14-.5-.2l.5.2" fill="currentcolor" />
    <path
      d="M85.26 27.39c.33-3.34-.62-6.69-2.66-9.36-.03-.02-2.2-3.06-5.22-4.76-2.53-1.44-5.37-1.77-8.07-2.84 2.36.64 5.12.92 7.5 1.94a18.31 18.31 0 014.44 2.9l.1.07c.2.21.41.4.63.6.1.04.2.03.29-.04.03-.54-1.27-1.86-1.48-2.14-.22-.29-3.11-4.7-10.95-6.91-9.84-1.9-18.2 1.49-21.76 3.08-1 .51-1.5 2.4-1.22 2.63.23.2 1.24-.32 2.75-1.38l.3-.15c3.29-1.7 8.8-2 8.85-2-1.37.2-5.5 1.61-8.37 2.82l-1.2.5-.67.66 2.24-.86c1.36-.54 4.06-1.36 9.68-1.94 2.42-.26 4.87-.14 7.25.34 1.18.33-7.54.15-13.06 1.47-1.17.27-2.15.56-3.02.86l-3.47 1c.36.37 2.25 2.76 2.78 3.44l.94.54c.1.11.9.4.98.52l1.1-.52c.18.23-1 .8-.85 1 .24.28.95-1 2.16-1.76 7.03-3.6 12.54-3.7 15.15-3.64.46.03.91.1 1.36.22.39.2-2.87.35-2.08.59.7.2 2.51-.27 2.7-.3.07 0 .14-.01.2-.04a.48.48 0 01.23-.03c.7-.01 1.38.02 2.07.1 1.87.45.12.69-.53.54a4.83 4.83 0 00-.97.02c-.24.06-.72.11-.95.17-.35.08-1.02.17-1.36.23-.2.03-2.4-.03-2.06.26.08.01 1.7.1 1.95.23.27.03.53.03.8.02.19-.03.38-.04.57-.03.1 0 .2-.03.28-.09.13-.06.27-.1.42-.08.12 0 .32.06.28.15-.35.84-.95.75-2.04.67-.63-.06-1.27-.07-1.9-.03-1.27.1-2.61.67-2.84.47-.16-.13 1.48-.77 1.03-.86-.74-.12-6.5 1.93-6.81 2.73h.03c-.05.12.02.15.13.19.3.06 1.51-.38 1.81-.4.36.02.47-.17.82-.17.27 0 1.23-.48 1.5-.48.5 0 .7.25 1.21.14.41-.1.93-.04 1.33-.18.4-.11.79-.27 1.18-.37.1-.03.19-.05.28-.09l.4-.07c.1 0 .77.28.73.36.9.52 1.14.94 1.9.98h.31l.53-.1.69-.12a4.8 4.8 0 011 0c.3 0 .59.1.88.14.35.05-.06.28-.19.35a7.8 7.8 0 01-1.31.65c-.28.14-.58.2-.89.2-.16 0-.33.02-.49.07-.1.04-.2.07-.32.09l-.3-.01a3.54 3.54 0 00-.43 0l-.17.05-.14-.01c-.1-.01-.2 0-.3.03a.56.56 0 01-.23.08h-.12a.66.66 0 00-.32.03 1.94 1.94 0 01-.86.12c-.02.02-2.05.14-2.07.16-.16.07-.33.13-.5.18-.35.17-.72.32-1.09.46-.09.03-.14.01-.22.03l-.71.2-.31.24c-.14.1-.3.16-.46.2-.13.02-.25.07-.38.09a.6.6 0 00-.27.17c-.09.06-.2.04-.29.09-.18.1-2.67.93-2.86 1.03l-.24.1c-.12.06-.23.14-.34.22a.55.55 0 00-.05.4h-.02.02v.05c.22.06.45.07.67.02.08 0 .17-.02.25-.05.12-.03.22-.03.34-.04a2.14 2.14 0 00.7-.28c2.69-.6 7.16-2.46 11.6-2.76.05 0 4.68-.2 7.79 1.24.92.43 5.23 2.84 3.5 9.72v.06h-.01l.13-.35.01-.05-.02.02c.14-.48.27-.91.36-1.3a19.68 19.68 0 00.34-2.03v-.07c0-.08-.03-.16-.02-.24M70.13 8.68c.7.13 1.4.3 2.09.51.5.13 1.86.64 1.76.82l-.27-.01c-2.23-.25-1.97-.63-2.34-.75-1.48-.48-1.23-.57-1.24-.57m-1.53 9.65l.2-.1c-.85.02-1.7.18-2.5.46-.45.16-.87.38-1.26.65-.1.18.13.29.17.3.67.13.71-.09 3.39-1.3"
      fill="currentcolor"
    />
    <path d="M73.47 30.59a.9.9 0 01.86.04c.82-1.04 1.68-1.44 2.42-2.56l.7-1.1c.62-1.12.68-2.2.9-3.04l-.14.24c-.05.05-.34 1.33-1.01 1.33-.22 0-.76-.1-.69-.36-.5 1.73-2.03 2.5-2.69 3.93.66.31-.43 1.02-.35 1.52z" />
    <path d="M50.8 35.76a.2.2 0 01.04 0l.03-.01a.3.3 0 00-.06.01z" fill="url(#a)" />
    <path
      d="M78.15 39.35a142.47 142.47 0 01-3.5 2.3c-3.72 2.36-7.66 4.41-12.24 5.2-.4.07-.8.12-1.21.17h-.01c3.53-.28 5.55-.54 8.91-2.15 2.97-1.43 6.46-4.17 8.05-5.52z"
      fill="url(#b)"
    />
    <path
      d="M48.57 37.75c.29.2.59.37.9.53 2.55 1.36 6.26 2.08 4.46 1.25-3.78-2.13-1.04-.72 2.27.06a24.37 24.37 0 007.44.64c3.93-1.52 7.27-3.7 9.14-5.77-.37.25-.76.47-1.16.66-.05.02-3.81 1.1 1.1-2.43 3.71-2.66 6.35-6.2 7.34-10.68.07-.22.18-.43.32-.62l.39.15c-.3 1.43-.63 2.63-1.04 4.03.37-.46.58-.6.94-1.05-.85 3.28-2.87 5.48-5.07 7.91-.59.66.86-.04-.4 1.32.3-.33.23-.15.47-.03 1-1.26 2.62-1.33 3.53-2.7 2.37-3.62 3.2-5.63 3.77-7.9l.05.06v-.03a7.45 7.45 0 00-1.96-1.51 10.11 10.11 0 00-3.29-.98 36.1 36.1 0 00-.65-.1c-1.59 3.77-1.81 6.39-5.32 8.47-3.9 2.54-1.46 1.89-1.42 1.87.3-.12.59-.28.86-.46-1.5 2.42-4.15 3.96-7.3 4.65-.07.23-1.16.2-1.35.36-.15.21-.39.34-.65.35.11.33-.65.45-.87.75-.3.4.26.57-.41.6l-.54-.28c-2.42 0-3.42-.73-4.2-1.42l-1.61.04c-.26.19-1.09.18-1.66.42a.69.69 0 01-.37-.13c-.24-.12-.51-.24-.62 0-.13.28-.63.02-.84-.02-.12.06-.9.41-.72.44-.9-.15-.59.13-1.44.42l-.82.03c-.2.06-.1.58.73 1.1zm25.25-8.68c.66-1.43 2.19-2.2 2.69-3.93-.07.26.47.36.69.36.67 0 .96-1.28 1-1.33l.16-.24c-.23.84-.29 1.92-.91 3.05l-.7 1.09c-.74 1.12-1.6 1.52-2.42 2.56a.9.9 0 00-.86-.04c-.08-.5 1-1.2.35-1.52z"
      fill="url(#c)"
    />
    <path
      d="M68.2 42.5a565.9 565.9 0 00-5.08 1.35c-1.8.5-3.74 1.2-9.21.69h-.1c-.78.1-1.58.13-2.38.07-.78-.05-2.17-.27-2.15-.26.03 0 .3.11.53.2h-.02s.7-.1 3.16.4c.97.2 1.93.25 2.93.37h.06c.73.1 1.47.12 2.2.1 1.81-.1 3.6-.4 5.33-.9 2.88-.82 4.98-1.9 4.72-2.01z"
      fill="url(#d)"
    />
    <path
      d="M84.87 27.84l-.01-.12-.03-.36v-.11a9.15 9.15 0 00-.06-.36l-.01-.09a8.58 8.58 0 00-.08-.4l-.05-.21-.05-.18a15 15 0 00-.11-.37l-.1-.24a5.99 5.99 0 00-.14-.35c0-.02 0-.04-.02-.06l-.13-.27a7.07 7.07 0 00-1.11-1.6c-.58 2.27-1.4 4.28-3.77 7.9-.91 1.37-2.53 1.44-3.53 2.7-.24-.12-.17-.3-.48.03 1.27-1.36-.18-.66.41-1.32 2.2-2.43 4.22-4.63 5.07-7.91-.36.45-.57.59-.94 1.05.41-1.4.73-2.6 1.04-4.03l-.39-.15c-.14.19-.25.4-.32.62-1 4.48-3.63 8.02-7.34 10.68-4.91 3.52-1.15 2.45-1.1 2.43.4-.19.8-.4 1.16-.66-1.87 2.08-5.2 4.25-9.14 5.77-6.64 2.56-14.97 3.26-20.82-1.5 1.28 1.29 2.7 2.45 4.21 3.45-.88-.15-1.5-.83-2.34-1.1.02.04 2.02 2.65 8.02 3.34l1.2.12c5.47.5 7.41-.2 9.2-.7a760.7 760.7 0 015.08-1.33c.26.1-1.84 1.19-4.72 2-1.73.5-3.52.81-5.32.9-.74.03-1.48 0-2.2-.08h-.07c-1-.13-1.96-.18-2.93-.38-2.47-.5-3.16-.4-3.16-.4s.37.2 3.77 1.42c-.21.08-1.22.21-5.4-1.58.04.03 5.01 2.4 7.85 2.68 2.14.21 4.29.14 6.4-.22 4.58-.79 8.52-2.84 12.24-5.2 1.31-.82 2.6-1.69 3.87-2.54l-.02.1.27.04c-.05.14-.05.14-.75.98 1.52-1.23 2.3-3.15 3.93-4.31-.12.3-.27.59-.46.85l-.15.22a22.09 22.09 0 01-2.83 3.35l-.1.1-.32.28a27.6 27.6 0 01-12.6 6.63c.43-.05.87-.14 1.3-.26-.77.22-.8.24-1.12.35l1.25-.24c-.61.3-1.32.44-3.03.8 6.16-1.07 11.28-3.68 15.03-7.58.17-.17 1.18-1.26 1.51-1.66a20.11 20.11 0 003.63-6.04c.17-.47.32-.95.43-1.45.04-.14.08-.28.1-.42.16-.92.17-.92.24-1.46v-.03a11.12 11.12 0 00.05-1.03v-.1l-.01-.4z"
      fill="url(#e)"
    />
    <path
      d="M62.68 33.8a3.88 3.88 0 01-1.4-1.49c-.13-.2-.24-.43-.35-.64l-.14-.24a6.11 6.11 0 00-.77-1.12l-.28-.3-.24-.27a.94.94 0 01-.14-.22c-1.24-3.17-1.53-4.96-1.98-8.1-.23-1.63-1.22-2.94-2.83-4.9l-.67-.84-.5-.66c-.4-.52-.84-1.01-1.3-1.48l-1.55-1.31-1.72-1.45a33.4 33.4 0 00-2.56-1.92 6.7 6.7 0 00-3.8-1.22 5.27 5.27 0 00-2.69.67c-.92.66-1.91 1.22-2.96 1.66-.7.3-1.43.53-2.35.83l-.95.32c-.87.3-1.66.8-2.31 1.45l-.36.35a8.5 8.5 0 01-.37.35c-.16.16-.35.3-.55.39-.26.07-.52.11-.79.12l-.58.03-.42.02c-1.2.07-2.16.74-2.78 1.25-.33.27-.62.54-.92.8l-.13.13c-.28.26-.57.5-.88.72-.85.55-1.65.63-2.54.72-.48.04-.95.1-1.42.2-.6.12-1.18.31-1.74.58-.72.35-1.42.77-2.08 1.24l-1.03.74-.88.64c-1.33.93-2.47 1.55-3.7 1.55-1.22 0-2.09-.71-2.2-1.82-.11-.97.39-1.95 1.4-2.77l.55-.45c.41-.33.8-.64 1.14-.94.48-.4.91-.83 1.3-1.3a3.6 3.6 0 00.62-3.33c-.3-1.18-1.2-1.98-2.76-2.44A13 13 0 008.42 9l-.18-.04a3.71 3.71 0 01-.44-.07 2.03 2.03 0 01-.36-.09 30.21 30.21 0 01-3.06-1.85l-.15-.1-.1.15c-.34.48-.6.86-.8 2.54-.22 1.85 1.3 4.11 3.93 4.52.15.02.27.13.3.28.04.14 0 .3-.12.38-2.78 2.19-3.37 3.13-3.51 5.58a5.5 5.5 0 001.46 4.1 6.21 6.21 0 004.67 1.8 10.92 10.92 0 001.68-.14c.2 0 .36.15.37.34.14 1.71.44 3.1.83 3.71.1.16.07.36-.06.48-.16.14-.35.24-.55.31a7.1 7.1 0 01-2.38.38c-.56 0-.98.39-1.31 1.21-.11.27-.2.56-.28.83l-.03.08-.13.39c-.03.1-.07.19-.12.28-.13.22-.3.43-.5.6a.37.37 0 01-.25.09h-.07a.38.38 0 01-.26-.2 1.87 1.87 0 00-1.28-.92h-.07a3.47 3.47 0 00-2.87 2.07.37.37 0 01-.3.23l-.07.01c-.61.02-1.15.42-1.35.99-.1.26-.16.52-.2.8l-.05.18c-.03.2-.07.43-.13.63-.04.16-.1.32-.19.47l-.12.22-.1.15c-.17.32-.21.7-.1 1.05.08.26.27.46.52.57.26.13.54.23.83.3.42.1.85.17 1.29.19.08 0 .16-.03.24-.07l.17-.12a.38.38 0 01.3-.08l.28.05.8.16h.04l.75.15.3.06.2.01c1.17-.06 1.66-.51 1.99-.95.09-.12.18-.26.26-.4l.13-.22.1-.17c.1-.16.19-.31.3-.46.06-.1.18-.15.3-.15l.1.01.38.09.62.07h.23c1.11 0 1.94-.61 2.62-1.2l.23-.19.3-.26c.17-.14.33-.27.51-.38.26-.2.57-.32.9-.33h.06a31.66 31.66 0 013.2.37c.5-.03 1-.16 1.45-.39.47-.22.93-.47 1.38-.75.12-.08.25-.14.38-.2l.04-.01.44-.21a3 3 0 001.02-.8c.27-.4.5-.83.7-1.27l.28-.57.48-.98c.07-.13.2-.2.34-.2h.1c.58-.02 1.15-.08 1.71-.17l.7-.1c.52-.09.95-.16 1.28-.17.08 0 .3.01.59.04l.67.04a32.24 32.24 0 003.02.04 5.6 5.6 0 001.65-.34c.1 0 .2.04.26.1.18.19.38.37.58.55.12.1.16.25.11.4a.37.37 0 01-.32.25l-.22.02a1.4 1.4 0 00-.89.41.36.36 0 01-.3.14.42.42 0 01-.14-.02 1.2 1.2 0 00-.47-.1h-.48c-.6 0-1.2.03-1.8.12-.36.04-.7.15-1 .3a.79.79 0 00-.46.74c.04.7 1.03 2.6 1.7 3.27.32.2.69.3 1.06.27h.19c.14 0 .26.07.33.2.69 1.35 1.88 2.27 2.97 2.27h.07c1.04-.05 3.84-1.06 5.8-1.99l.08-.02.2-.04.4-.05.2-.02c.43-.03.86-.13 1.28-.3.33-.16.81-.78 1.22-1.58.06-.12.2-.2.33-.2h.03c.16.02.28.12.33.27.04.15.1.3.17.43.34.63.94.95 1.78.94h.14c.6-.05 1.2-.18 1.77-.4l.31-.1c.44-.16.89-.29 1.35-.38a3.4 3.4 0 01.8-.04l.53.04.36.02c.17.02.35.03.54.03.44.01.87-.07 1.27-.25.43-.19.83-.42 1.2-.7l.1-.08a.4.4 0 01.22-.07c.09 0 .17.04.24.1a6.95 6.95 0 004.65 1.74h.24c.46.02.91-.17 1.22-.52.16-.2.2-.47.14-.71a.37.37 0 01.3-.47c.33-.05.65-.19.91-.4a1 1 0 00.34-.68c0-.15-.06-.3-.17-.4-.34-.3-.73-.54-1.14-.73m-16.54-2.88c-.25.32-.63.41-.98 1.03-.7-.28-.82-1.2-.95-1.6.56-.1 1.87-.35 2.56-.45-.27.3-.48.64-.63 1.02"
      fill="currentcolor"
    />
    <path
      d="M61.78 34.24c-1.28-.75-1.79-2.16-2.58-3.27-.28-.4-.77-.67-1.03-1.07-.92-2.5-1.7-5-1.95-7.85a8.31 8.31 0 00-.72-2.1c-1.16-1.87-2.66-3.58-4.1-5.3l-.41-.42-5.07-4.2c-.63-.43-1.31-.8-2.03-1.08a5.13 5.13 0 00-3.56.13c-1.09.58-2.07 1.41-3.22 1.8-1.66.75-3.54.9-4.97 2.18-.84.72-1.54 1.85-2.78 1.66a5.3 5.3 0 00-3.67 1.31c-.94.85-1.83 1.86-3.05 2.1-1.07.45-2.37.23-3.46.64-1.72.43-3.1 1.8-4.56 2.85-1.47.85-2.88 1.77-4.72 1.73-1.24-.1-2.3-.9-2.73-2.07a3.45 3.45 0 011.08-3.59c1.09-1.3 2.82-2.07 3.67-3.57.45-.9.37-2-.21-2.82-1.14-1.17-2.76-1.21-4.23-1.57-.94-.26-1.67-.98-2.5-1.43-.3.48-.44 1.05-.39 1.62a3.88 3.88 0 002.48 3.03c.75.32 1.6.09 2.37.25.24.1.4.3.45.54 0 .22-.1.42-.25.58-1.2 1-2.46 1.96-3.46 3.2-1.07 1.15-1.19 3.18-.63 4.63a4.98 4.98 0 004.01 2.97c1.22.2 2.3-.13 3.42-.37a.4.4 0 01.27.24c.11.98-.04 1.85.18 2.75.2.76.46 1.5.77 2.22a.97.97 0 01-.2.8c-.6.43-1.25.8-1.94 1.09l-1.66.1-.32.15c-.62.73-.64 1.48-1.02 2.3-.51.84-1.45 1.25-2.24 1.74a5.3 5.3 0 01-.9 1.16c-.28.22-.62.35-.98.36-.57.66-.7 1.58-.85 2.48.94.09 1.92.6 2.84.09.79-.37.96-1.33 1.55-1.91.47-.51 1.18-.13 1.74-.02.83.04 1.43-.56 2.13-.84.49-.32.89-.88 1.4-1.2.99-.47 2.35-.21 3.38-.02.8.2 1.63.1 2.37-.23.66-.41 1.28-.93 2.02-1.1.66-.34.99-1.09 1.26-1.7.22-.58.77-1.03.73-1.7-.17-.14-.37-.47-.62-.44-.32.44-.56.91-.92 1.35-1.54 2.1-2.76 2.3-5.89 2.3a7.29 7.29 0 00-6.02 2.45.3.3 0 01-.34-.07c0-.3.09-.61.26-.87 1.42-2.03 3.65-2.5 6-2.55a9.06 9.06 0 003.58-.86 5.43 5.43 0 002.56-2.78c.27-1.34.38-2.8.72-4.08.11-.14.29-.2.46-.18.18.02.33.13.4.29-.24 1.32-.67 2.88-.15 4.16 1.02 1.35 2.92.62 4.31.55 1.34-.08 2.68-.06 4 .07.69-.02 1.2.15 1.73-.28.15-.25.2-.53.16-.81-.04-.39-.36-.62 0-.94a.48.48 0 01.51.08c.2.53.28 1.1.62 1.58a8.18 8.18 0 002.63 2.05c.9.62 1.64 1.49 1.7 2.58.01.56-.5.94-.93 1.2-.72.41-1.54.61-2.37.57-1.13-.55-1.43-1.74-2.18-2.62-.38-.43-.96-.5-1.53-.47-.6.03-1.21.12-1.8.28a.6.6 0 00-.17.52c.39.7.81 1.38 1.24 2.08.5.3 1.18-.17 1.6.36.37.57.6 1.22 1.16 1.65.56.5 1.35.65 2.05.39 1.6-.45 3.15-1.06 4.63-1.8h.5c.59-.06 1.25-.03 1.67-.48.46-.65.87-1.34 1.22-2.05.36-.49.2-1.23.04-1.77a10.12 10.12 0 01-1.52-2.93c-.36-.1-.68-.32-1.09-.3-.19.09-.46.05-.57.26l1.69 3.33c.14.3.2.64.17.97a4.36 4.36 0 01-1.17 1.9c-.1.06-.24.12-.32-.02.19-.73.53-1.52.49-2.35l-1.65-2.97c-.2-.4-.53-.77-.51-1.24.02-.2.16-.38.36-.45.72-.23 1.6-.2 2.15-.77.73-1.13.88-2.24 1.07-3.59.07-.13.2-.22.34-.25.14.01.27.1.34.21a5.54 5.54 0 01-.94 4.12.36.36 0 00.07.45c.81.25 1.67 0 2.35-.37.83-.03 1.66-.13 2.47-.32.1.04.16.12.18.21a4.08 4.08 0 00-.99 2.03c-.64.67-1.55 1.25-1.62 2.2.11.48.52.03.8.08.12.01.21.12.2.25l-.63.94c-.34.55.06 1.2.06 1.72.2.42.65.68 1.11.65.97-.04 1.82-.41 2.67-.71A5.8 5.8 0 0153 35.8c1-.06 1.75-.73 2.5-1.39.4.05.78.25 1.04.58a5.49 5.49 0 004.34 1.72l.14-.08a.25.25 0 00-.06-.38l-1-.52c-.7-.45-1.58-1.04-1.82-1.83a9.6 9.6 0 00-1.02-2.16c-.15-.34-.5-.62-.64-.96a.16.16 0 01.15-.09c1.1.38 1.77 1.48 2.28 2.46.82 1.13 1.99 2.1 3.52 1.84l.13-.11a.21.21 0 000-.26l-.77-.38zM45.01 19.2l-.05-.01v.02l-.02.01c-.07.08-.2.1-.28.03l-.02-.02-.01-.03c-.15-.88-.38-1.75-.7-2.59l-.2-.34-.08-.1-.17-.25a.8.8 0 01-.09-.85l.02-.03c.18-.14.41-.18.62-.1l.03.02c.32.26.59.59.77.97.22.56.34 1.17.33 1.78 0 .5-.07 1-.2 1.48l.05.01zm8.15 14.08h-.02c-.43.14-.88.19-1.33.16h-.03l-.09-.04-.1-.06a.21.21 0 01-.07-.24A2.09 2.09 0 0153 31.76h.1l.16.03c.12.03.22.14.23.27.02.1.02.22.02.33.03.34-.1.67-.35.9zm2.61-5.83l-.06.18-.06.19a.42.42 0 01-.3.3.25.25 0 01-.24-.04.26.26 0 01-.1-.22l-.01-.19-.07-.66a1.8 1.8 0 00-.28-.74 33.05 33.05 0 01-.62-.7 1.08 1.08 0 00-.7-.38c-.21.08-.4.2-.54.38l-.22.28-.2.27a.2.2 0 01-.24.05l-.03-.01a.98.98 0 01-.08-.4c0-.19.05-.37.12-.54l.18-.36.2-.41.02-.04c.09-.1.15-.22.18-.34l.06-.14.11-.3a.56.56 0 01.83-.32c.26.15.48.37.62.64l.1.16.12.2.25.32c.7.77 1.03 1.5 1.03 2.25 0 .2-.03.39-.07.57z"
      fill="currentcolor"
    />
    <path
      d="M5.1 36.66a4.32 4.32 0 001.44-1.74 1.44 1.44 0 00-.5-.57.54.54 0 00-.46.02c-.47.39-.96.74-1.47 1.05-.22.15-.13.47-.18.7 0 .22.26.37.39.5.25.1.53.12.79.04m-2.24.06c-.38.17-.66.49-.79.88-.1.68.04 1.32-.49 1.82-.02.13-.15.28-.02.4.48.19.98.32 1.5.4.25-.83.44-1.75.74-2.47v-.22c-.26-.31-.51-.72-.94-.8m32.38-2.3c.43.47.4 1.2.9 1.56.62.07 1.24-.12 1.7-.53.28-.24-.12-.54-.17-.82-.28-.4-.08-1.22-.76-1.23-.68.09-1.37.13-2.06.13l-.19.13c-.13.4.47.4.58.76"
      fill="currentcolor"
    />
    <path d="M204.48 31.72c0 1.8 1.53 3.26 3.43 3.26 1.89 0 3.42-1.46 3.42-3.26V20.89h5.92v11.98c0 4.05-4.2 7.33-9.36 7.33-5.18 0-9.37-3.28-9.37-7.33V20.89h5.96v10.83zm26.21 7.81h6V8.03h-6zm-10.14 0h6V8.03h-6zM110.78 14.64h-3.26v24.89h-6.38V9.48h10.97c5 0 9.04 3.97 9.04 8.87a8.91 8.91 0 01-6.89 8.62l8.82 12.56h-7.52l-6.38-9.84V22.5h1.48c2.36 0 4.27-1.76 4.27-3.93a4 4 0 00-4.15-3.93" />
    <path d="M128.7 27.98a3.67 3.67 0 117.33 0h-7.33zm13.24 3.46c.04-.41.06-.83.05-1.26.1-6.5-4.2-10.06-9.68-10.06a9.98 9.98 0 00-9.91 10.04 9.99 9.99 0 009.91 10.04c4.18 0 7.44-1.89 9.12-4.85l-4.87-2.25a4.1 4.1 0 01-3.76 2.28c-2.33 0-4.06-1.72-4.08-3.74v-.2h13.22zm13.56 3.49c-2.43 0-4.4-2.16-4.4-4.83 0-2.66 1.97-4.82 4.4-4.82 2.44 0 4.4 2.16 4.4 4.82 0 2.67-1.96 4.83-4.4 4.83zm10.32 4.6l-.01-31.5h-5.98v14.9a8.54 8.54 0 00-6.03-2.53c-4.95 0-8.97 4.4-8.97 9.82s4.02 9.82 8.97 9.82c2.34 0 4.46-1 6.06-2.6v2.09h5.96zm20.34-5.22h-5.74V14.64h4c1.76 0 3.18 1.6 3.18 3.37a3.18 3.18 0 01-3.18 3.18h-2.08v5.4h3.82a3.75 3.75 0 013.74 3.85c-.08 2.2-1.43 3.73-3.74 3.87m5.02-11.14a7.98 7.98 0 002.65-5.84c0-2.04-.79-3.92-2.17-5.4-1.43-1.57-3.96-2.45-7.38-2.45h-10.26v30.05h13.25c5.07-.08 9.16-3.92 9.16-8.62 0-3.42-1.2-5.86-5.25-7.74" />
  </Svg>
);

export const LifehackerLogo = () => (
  <Svg viewBox="0 0 180 45" aria-label="Lifehacker logo">
    <path
      fill="currentcolor"
      fillRule="evenodd"
      d="M0 .45l6.9.44v43.6H0V.46zm14.75 3.07a3.98 3.98 0 010 7.94 3.98 3.98 0 010-7.94zM47 12.63c5.23 0 9.46 4.3 9.46 9.56v6.71a3.44 3.44 0 01-3.45 3.47h-8.63v3.02A2.62 2.62 0 0047 38h6.62l.22 5.87-6.23.95c-6.01 1-10.13-4.2-10.13-9.44v-13.2A9.54 9.54 0 0147 12.63zm-35.7.45l6.9.4V44.5h-6.9V13.08zM32.07 0c1.72 0 3.12.5 3.45.73l-.28 6.65h-3.17A2.6 2.6 0 0029.5 10v9.39h5.17v6.93H29.5v18.14h-6.9V10c0-5.25 4.34-10 9.46-10zm68.3 22.75v13.3a8.72 8.72 0 01-8.63 8.78A8.81 8.81 0 0183 36.06v-2.74c0-4.81 3.29-8.44 8.74-8.44 2.06 0 3.12.22 4.29.55v-3.52c0-2.51-1.17-4.53-4.34-4.19h.05c-1.78.06-4.06.28-5.95.4-.06-1.63-.12-2.24-.17-3.47 1.5-.56 3.67-1.12 5.51-1.18 5.57-.11 9.24 4.42 9.24 9.28zM66.82.73v13.3a17.2 17.2 0 014.5-.56c4.74 0 8.42 4.3 8.42 9.17V44.5h-4.35V22.64a4.3 4.3 0 00-4.34-4.3h-4.23V44.5h-4.45V.73h4.45zM47 19.57a2.6 2.6 0 012.55 2.46v3.4h-5.17V22.2A2.62 2.62 0 0147 19.57zm65.85-6.1a8.77 8.77 0 018.74 8.78v.56c-1.73.05-3.12.05-4.4.1v-.66c0-2.35-1.95-4.3-4.34-4.3a4.29 4.29 0 00-4.24 4.3v13.97c0 2.46 1.9 4.3 4.24 4.3a4.28 4.28 0 004.34-4.13c2.17.17 4.23.28 4.4.28a8.8 8.8 0 01-8.74 8.33 8.73 8.73 0 01-8.69-8.78V22.25c0-4.87 3.9-8.78 8.69-8.78zM129.55.84V44.5h-4.45V.84h4.46zM96.04 28.5v7.55c0 2.4-1.9 4.36-4.29 4.36a4.3 4.3 0 01-4.28-4.15V32.8a4.26 4.26 0 014.07-4.3h4.5zm57.68-15.04a8.77 8.77 0 018.69 8.83v6.88c0 1.29-1 2.24-2.23 2.24h-10.74v4.75a4.3 4.3 0 004.28 4.36h5.63c.05 1.45.1 2.46.22 3.46l-5.35.84c-5.45.95-9.24-3.8-9.24-8.66V22.3c0-4.86 3.9-8.83 8.74-8.83zm-10.34.45l-8.41 14.31 9.07 16.27h-4.9l-8.46-14.82c-.83-1.45-.83-1.62.17-3.35l7.46-12.41h5.07zm32.29-.5c1.89.05 3.06.5 4.34 1.11-.06 1.35-.11 2.46-.17 3.47l-4.84-.11c-2.34 0-4.23 2.51-4.23 4.8v21.8h-4.46V22.7c0-4.86 3.79-9.39 9.36-9.27zm-21.95 4.52A4.35 4.35 0 01158 22.3V27h-8.57v-4.7a4.3 4.3 0 014.28-4.36z"
    />
  </Svg>
);

export const ZillowLogo = () => (
  <Svg viewBox="0 0 1911 400">
    <g fill="currentColor">
      <path d="M1460.4 148.6h77.8l22.5 73.7c7.5 24.4 20.1 70.2 20.1 70.2a.6.6 0 0 0 1.1 0s13-46.7 20.5-70.2l23.6-73.7h57.4l23.3 73.7c7.8 25.2 20 70.2 20 70.2a.6.6 0 0 0 1.1 0s12.7-45.6 20-70.2l22.6-73.7h72.3L1764.5 392h-71.1l-19.4-61c-7.5-24-20.6-70.6-20.6-70.6a.6.6 0 0 0-1.1 0s-13.1 45.7-21 70.2l-19.7 61.6h-72.4zM936.8 19.9h78.7v372.2h-78.7zM1073.8 19.9h78.7v372.2h-78.7zM1380.7 271.2c0-36.3-25.9-61-56.5-61-31.3 0-57.2 24.7-57.2 61 0 36.5 25.9 60.9 57.2 60.9 30.6 0 56.5-24.4 56.5-61m-189.2 0c0-74 59.7-128.7 132.7-128.7 72.3 0 132 54.8 132 128.8 0 74.2-59.7 129-132 129-73 0-132.7-54.8-132.7-129M481.5 54.4V126h139c.7 0 .9.5.6 1L481.4 364.5c-3.4 6.2-4.2 7.5-4.2 13.6v14h271v-71.6H597.7a.6.6 0 0 1-.5-1L738.5 79c1.1-2.3 2.3-4 2.3-9.6v-15zM798.4 148.6H877V392h-78.7zm39.3-122c24.6 0 44.8 19.8 44.8 44.2S862.3 115 837.7 115 793 95.2 793 70.8s20.3-44.2 44.8-44.2 "></path>
      <path d="M242.2 106.3c1.8-.4 2.6.2 3.7 1.4 6.1 7 26 31.1 31.4 37.7a2.1 2.1 0 0 1-.5 3.2 714.8 714.8 0 0 0-109.3 107c-.5.6-.1.7.2.5 43.3-18.6 144.7-48.2 190.5-56.6v-57.9L179.2.2.2 141.6V205c55.5-33 183.9-84.1 242-98.6z"></path>
      <path d="M96.6 349.5a3 3 0 0 1-3.8-.6l-33.5-39.8c-.9-1-1-1.6.2-3.4C85.3 268 138 209 171.5 184.1c.7-.5.5-1-.2-.7C136.3 195 37 237.6 0 258.4v135.2h358.2V263.5c-49 8.3-195.1 51.8-261.6 86z"></path>
      <path d="M1895.2 113.9c0-7-4.9-12-11.7-12H1871v34h5.6v-10.1h5.5l6.2 10.2h6.4l-6.7-11c4.3-1.7 7.2-5.8 7.2-11.1zm-12 6.9h-6.6V107h6.6c3.7 0 6.4 3 6.4 7s-2.7 6.8-6.4 6.8z"></path>
      <path d="M1881.8 90.2a29.4 29.4 0 1 0 29.4 29.3 29.4 29.4 0 0 0-29.4-29.3zm0 53a23.7 23.7 0 1 1 23.8-23.7 23.8 23.8 0 0 1-23.8 23.8z"></path>
    </g>
  </Svg>
);

export const KabumLogo = () => (
  <svg
    viewBox="0 0 158 54"
    fill="none"
    xmlns="https://www.w3.org/2000/svg"
    role="img"
    aria-label="KaBuM! Tecnologia e Games"
  >
    <path
      fillRule="evenodd"
      clipRule="evenodd"
      d="M26.5863 41.4307C23.4586 41.9794 19.8674 39.3234 19.3188 36.2321C18.8268 33.4567 18.2074 30.6934 17.4219 27.9827C15.8591 30.0658 14.942 31.8776 14.025 34.4547C12.8771 37.6796 10.8669 40.3497 7.3121 40.953C5.97397 41.1797 4.66015 41.0684 3.33012 40.87L0 40.372L0.947414 37.1411C4.21276 25.9887 8.18461 14.0833 13.7841 3.87832C15.0291 1.60897 17.6021 -0.31622 20.2864 0.760756C22.8412 1.78712 23.3149 4.61114 22.8493 7.02017C22.7784 7.38658 22.7015 7.753 22.6185 8.11536C26.1005 5.10104 29.8699 2.46327 34.113 0.552244C36.1799 -0.378975 38.5849 -0.208928 40.0829 1.65149C41.7794 3.7609 41.2976 6.90275 39.2448 8.58907C38.3136 9.35429 37.4229 10.1053 36.5908 10.8584C35.4754 11.907 37.0929 12.3403 38.3055 11.5771C40.0505 10.6114 41.9352 9.93934 43.4272 9.59519C46.9861 8.77126 50.9397 8.96561 53.8731 11.2289C54.0877 10.579 54.3022 9.93326 54.5168 9.29153C55.3084 6.91895 56.1201 4.55244 56.9299 2.1839L57.6182 0.171658L59.7438 0.197976C63.5577 0.244537 67.3737 0.430777 71.1897 0.384216C75.7689 0.329558 82.3259 0.969264 83.2955 6.56468C83.4777 7.61534 83.5506 8.61336 83.5223 9.56685C84.6701 9.34619 85.8766 9.50612 87.0164 10.2147C88.8727 11.3686 89.5266 13.476 89.229 15.5469C88.8403 17.5389 90.3971 17.4235 90.9639 15.5894C91.6401 14.0165 92.4559 12.5751 93.456 11.6277C95.2354 9.94136 97.8732 8.8401 100.134 10.3584C100.226 10.4191 100.315 10.4839 100.398 10.5507C101.197 8.8988 102.035 7.26714 102.916 5.65573C104.586 2.60497 107.866 -0.249416 111.576 1.08871C114.67 2.20212 115.74 5.50997 115.538 8.52834C115.427 10.1924 115.323 11.8564 115.226 13.5225C117.046 10.577 118.83 7.60724 120.631 4.64961C121.225 3.67588 122.036 2.83373 122.951 2.15961C126.502 -0.461975 130.792 -0.166413 132.533 2.64749C134.585 0.276928 138.529 -0.257511 140.926 1.94503C142.533 3.42081 142.825 5.5707 142.185 7.58295C140.861 11.7491 139.422 16.134 137.642 20.3245C138.94 20.618 140.519 21.3549 142.055 22.2598C142.995 21.2698 144.418 20.948 145.827 20.9844C148.706 21.0593 153.989 24.6728 155.977 26.764C156.965 27.8026 157.534 29.1144 157.402 30.5618C157.064 34.2543 152.785 35.9629 149.928 37.4022C147.434 38.6614 144.857 40.1372 142.256 41.1291C141.614 41.3741 140.972 41.453 140.371 41.3903C141.066 42.3903 141.474 43.6009 141.474 44.9026C141.474 49.7571 137.503 53.7309 132.646 53.7309H30.2808C26.8819 53.7309 24.1024 50.9494 24.1024 47.5525C24.1004 45.1819 25.0498 43.0219 26.5863 41.4307Z"
      fill="white"
    />
    <path
      fillRule="evenodd"
      clipRule="evenodd"
      d="M125.201 31.975C127.073 30.1955 130.162 31.8818 129.413 33.6127C129.274 35.6735 127.915 36.8902 126.136 37.6392C124.919 37.9672 123.654 38.5279 122.812 37.453C122.3 35.5784 123.798 33.4244 125.201 31.975ZM92.8064 38.621C96.3653 27.6671 99.8756 16.7111 105.493 7.06889C108.208 1.77916 112.983 3.04238 112.609 8.33211C112.374 12.0307 112.188 15.7758 111.953 19.4744C111.86 21.5817 113.733 21.3004 114.714 19.8489C117.524 15.2616 120.332 10.7209 123.14 6.18018C125.106 2.90269 131.8 1.4512 130.209 7.11545C128.476 16.8993 125.294 26.169 121.081 35.2039C120.146 37.9651 116.54 38.9955 117.101 35.7646C118.364 30.896 119.676 25.9807 120.986 21.1586C121.688 18.2091 119.769 19.7537 117.99 23.1709C115.743 27.1974 114.058 30.896 111.295 35.0621C107.971 40.0239 104.74 39.8377 104.835 34.4062C105.07 30.9891 105.35 27.5719 105.631 24.1547C105.959 20.4096 105.068 19.8003 103.524 23.8268C99.0334 37.2181 95.8025 39.1372 92.8064 38.621ZM62.3778 23.0798C61.4425 23.9685 60.7401 26.4504 60.2238 30.3818C60.2238 31.6936 60.6915 32.2543 61.5822 32.394C63.0337 32.4406 64.9062 32.5337 66.3112 32.4406C72.9127 32.2057 76.0485 23.6871 69.6818 23.1709C67.0582 23.1263 64.9994 23.1264 62.3778 23.0798ZM67.5278 9.2694C66.4509 9.2694 65.3739 13.0611 65.2808 15.4013C65.0459 17.2738 66.9185 17.039 68.2769 17.0856C72.8641 17.2253 74.925 15.6806 76.3279 13.1056C77.4514 10.484 76.7955 9.22082 73.7994 9.22082C71.694 9.22284 69.6332 9.2694 67.5278 9.2694ZM59.7096 3.13752C56.1528 13.5307 52.5939 24.7195 51.2355 33.801C50.861 38.2485 52.266 38.7162 55.0738 38.7162C57.8351 38.6696 60.6449 38.6231 63.4527 38.6231C67.1979 38.3417 70.7081 36.7971 73.7994 33.2402C74.3136 32.6794 74.7832 32.9123 74.7347 33.3333C74.7347 37.4064 78.2915 41.6657 85.3141 36.5643C86.8587 35.7687 87.2798 35.8618 87.3264 36.7505C87.3729 37.3133 87.1401 37.9672 86.9519 38.4834C90.8367 38.8113 94.8166 30.7583 99.0759 14.9822C99.3108 12.5955 97.7176 11.6116 95.4705 13.7656C92.5675 16.4803 91.3509 27.0618 88.4944 30.6186C84.5611 36.4225 80.7694 33.1005 81.5184 30.4324C83.1561 23.1284 85.0752 21.8652 86.2939 15.2656C86.8567 11.9882 83.4375 11.3808 81.3787 14.5632C80.1155 16.8568 79.1316 19.3387 78.4292 21.8672C77.4939 24.2539 76.1355 24.0211 75.761 22.6628C75.5728 21.4461 74.7772 20.5088 73.7953 19.6667C78.0547 16.6706 81.1925 13.0186 80.3969 7.07294C79.7875 4.21652 76.4169 3.14157 71.2223 3.32782C67.3861 3.27721 63.5479 3.18408 59.7096 3.13752ZM45.1037 26.8249C44.1684 26.497 41.8262 27.4343 40.2816 28.4626C37.5669 30.5214 37.7531 31.5984 38.1276 33.0033C38.737 34.5014 41.7796 34.1269 44.0267 31.7401C46.1786 29.2117 46.3669 27.3857 45.1037 26.8249ZM40.8423 19.8023C40.233 21.1607 35.6923 19.8489 36.1619 17.9763C36.3968 14.4174 47.4904 9.45565 52.687 14.0915C56.2925 18.1646 48.0066 29.3068 48.0998 37.123C48.1463 37.9186 47.5856 38.2931 46.6483 38.3396C45.6644 38.3396 44.6826 38.3396 43.6987 38.3396C42.7635 38.3862 42.061 37.7303 41.4517 36.795C38.8766 39.1352 31.2467 40.1656 30.356 36.046C29.6535 32.5357 29.5604 29.6793 34.3825 25.9807C37.1923 24.0616 40.6561 23.4523 45.1968 22.6101C47.1159 21.8145 48.0532 18.865 46.1806 18.0694C43.9801 17.041 42.3404 18.118 40.8423 19.8023ZM3.76562 37.9672C7.27592 25.9828 11.1627 14.2332 16.3594 5.29148C17.8108 2.48162 20.7138 2.71645 19.9648 6.46157C19.5437 8.70865 18.9344 10.8626 18.1854 12.968C17.7177 14.5591 18.9344 15.6361 21.0883 13.5307C26.2384 8.47381 30.8256 5.5263 35.3198 3.23267C38.1762 2.10913 38.9252 4.96555 37.3806 6.32189C30.9208 11.2837 25.3497 16.8548 27.5502 27.0597C28.0178 30.0093 28.3458 32.9122 28.0178 35.8618C26.9408 40.777 22.5398 37.874 22.2139 35.7221C21.558 32.4912 20.9021 29.2157 19.9203 26.0779C19.1712 23.596 17.4384 23.0818 15.4727 25.7034C13.8349 27.7156 12.3835 29.4951 11.2599 33.475C9.1505 38.3417 6.57548 38.3882 3.76562 37.9672ZM127.355 27.9019C127.262 29.5396 128.666 30.0558 130.49 27.6671C133.861 21.7214 136.764 14.6057 139.386 6.69438C140.509 2.99582 135.64 2.52818 134.424 5.05665C131.942 9.45565 129.648 17.7901 127.355 27.9019Z"
      fill="#175FAD"
    />
    <path
      d="M132.7 50.6253L133.52 47.5968C133.63 47.198 133.771 46.8276 133.943 46.4875C134.113 46.1453 134.308 45.8477 134.526 45.5927C134.747 45.3376 134.976 45.1372 135.221 44.9955C135.464 44.8538 135.713 44.7809 135.966 44.7789C136.037 44.7789 136.097 44.7809 136.15 44.789C136.201 44.793 136.247 44.8011 136.29 44.8072L136.614 43.6472C136.565 43.6412 136.508 43.6331 136.45 43.629C136.391 43.6209 136.332 43.6189 136.275 43.6189C135.968 43.6209 135.676 43.6938 135.407 43.8355C135.136 43.9792 134.883 44.1736 134.654 44.4185C134.423 44.6655 134.221 44.9469 134.043 45.2607H134C134.065 44.9995 134.122 44.7465 134.172 44.5015C134.227 44.2566 134.275 44.0157 134.322 43.7748H133.289C133.243 43.9894 133.192 44.2282 133.138 44.4914C133.083 44.7526 133.022 45.0319 132.955 45.3214C132.889 45.6149 132.814 45.9085 132.733 46.2081L131.526 50.6233H132.7V50.6253ZM126.793 47.2567C126.915 46.8519 127.071 46.4854 127.261 46.1595C127.453 45.8336 127.668 45.5542 127.905 45.3194C128.141 45.0886 128.39 44.9084 128.65 44.7829C128.909 44.6574 129.166 44.5947 129.423 44.5947C129.656 44.5967 129.85 44.6412 130.008 44.7283C130.168 44.8153 130.291 44.9368 130.382 45.0886C130.474 45.2404 130.534 45.4145 130.567 45.6068C130.597 45.8032 130.603 46.0056 130.585 46.2202C130.559 46.53 130.49 46.8498 130.378 47.1859C130.265 47.5199 130.117 47.8458 129.931 48.1616C129.745 48.4774 129.524 48.7629 129.271 49.0179C129.018 49.273 128.737 49.4755 128.427 49.6273C128.119 49.7771 127.787 49.856 127.433 49.8581C127.073 49.8581 126.803 49.771 126.631 49.601C126.459 49.4289 126.386 49.1819 126.413 48.854C126.421 48.6718 126.441 48.5098 126.469 48.3681C126.498 48.2264 126.532 48.0948 126.571 47.9774L126.793 47.2567ZM127.51 40.5762L125.419 47.9491C125.37 48.1151 125.324 48.2932 125.285 48.4815C125.245 48.6698 125.216 48.8519 125.202 49.024C125.172 49.441 125.234 49.7811 125.394 50.0382C125.556 50.2974 125.791 50.4856 126.097 50.6051C126.403 50.7225 126.757 50.7812 127.164 50.7792C127.621 50.7771 128.05 50.7083 128.449 50.5767C128.85 50.4451 129.216 50.2629 129.552 50.0301C129.886 49.7973 130.186 49.5281 130.455 49.2204C130.723 48.9127 130.949 48.5847 131.142 48.2365C131.336 47.8843 131.49 47.526 131.603 47.1616C131.717 46.7952 131.789 46.4348 131.82 46.0805C131.846 45.7708 131.836 45.4753 131.785 45.1817C131.735 44.8922 131.636 44.627 131.494 44.3922C131.348 44.1594 131.152 43.9691 130.899 43.8335C130.648 43.6938 130.336 43.6209 129.961 43.6189C129.652 43.6189 129.35 43.6736 129.052 43.7768C128.753 43.8841 128.467 44.0379 128.192 44.2485C127.921 44.455 127.67 44.7121 127.439 45.0198H127.411L128.69 40.5762H127.51ZM123.224 50.767C123.402 50.765 123.558 50.7225 123.7 50.6415C123.84 50.5585 123.951 50.4472 124.04 50.3075C124.127 50.1678 124.178 50.0099 124.196 49.8338C124.21 49.6718 124.188 49.5261 124.133 49.4006C124.081 49.273 123.998 49.1718 123.884 49.0989C123.773 49.026 123.633 48.9876 123.473 48.9856C123.295 48.9876 123.139 49.0301 122.997 49.1151C122.858 49.2001 122.744 49.3135 122.657 49.4552C122.57 49.5989 122.52 49.7568 122.502 49.933C122.487 50.0909 122.51 50.2326 122.564 50.3581C122.617 50.4836 122.698 50.5828 122.807 50.6557C122.919 50.7286 123.052 50.767 123.208 50.769H123.224V50.767ZM112.969 50.6253L113.894 47.1859C113.995 46.8174 114.135 46.4773 114.315 46.1676C114.495 45.8538 114.698 45.5805 114.924 45.3437C115.149 45.1109 115.382 44.9267 115.619 44.7971C115.857 44.6655 116.088 44.5987 116.305 44.5967C116.59 44.5987 116.801 44.6574 116.938 44.7708C117.076 44.8841 117.165 45.0299 117.2 45.208C117.236 45.3882 117.246 45.5745 117.226 45.7729C117.216 45.9044 117.196 46.0401 117.171 46.1737C117.147 46.3073 117.113 46.4551 117.072 46.6089L115.971 50.6273H117.102L118.048 47.117C118.153 46.7324 118.295 46.3883 118.473 46.0785C118.649 45.7688 118.848 45.5036 119.066 45.283C119.285 45.0603 119.511 44.8943 119.744 44.7748C119.975 44.6574 120.198 44.5947 120.412 44.5947C120.667 44.5947 120.864 44.6432 121.01 44.7424C121.151 44.8396 121.248 44.9752 121.303 45.1534C121.354 45.3295 121.37 45.54 121.348 45.783C121.335 45.9267 121.313 46.0785 121.281 46.2324C121.248 46.3903 121.212 46.536 121.174 46.6737L120.107 50.6233H121.252L122.356 46.5765C122.39 46.447 122.423 46.3154 122.451 46.1757C122.479 46.036 122.502 45.9024 122.524 45.7708C122.544 45.6413 122.558 45.5238 122.568 45.4166C122.593 45.0967 122.566 44.8194 122.489 44.5906C122.412 44.3639 122.297 44.1776 122.147 44.0339C121.999 43.8902 121.827 43.7869 121.639 43.7181C121.447 43.6513 121.25 43.6189 121.05 43.6189C120.538 43.625 120.056 43.7606 119.611 44.0177C119.161 44.2748 118.764 44.6513 118.416 45.1473C118.422 44.8578 118.376 44.5947 118.275 44.3659C118.173 44.1371 118.013 43.9549 117.797 43.8234C117.576 43.6898 117.295 43.6209 116.947 43.6189C116.491 43.6189 116.046 43.7383 115.613 43.9792C115.181 44.2201 114.785 44.5805 114.42 45.0623H114.378L114.669 43.7748H113.637C113.578 44.0582 113.509 44.3639 113.43 44.6979C113.353 45.0299 113.26 45.3882 113.159 45.7708L111.831 50.6253H112.969ZM108.132 49.8479C107.804 49.8459 107.529 49.7609 107.304 49.5969C107.08 49.4309 106.916 49.2062 106.808 48.9167C106.703 48.6293 106.665 48.2952 106.693 47.9207C106.719 47.6049 106.784 47.2871 106.887 46.9672C106.989 46.6494 107.124 46.3437 107.288 46.0563C107.454 45.7668 107.647 45.5097 107.865 45.285C108.084 45.0582 108.327 44.8821 108.588 44.7485C108.851 44.6189 109.13 44.5521 109.426 44.5501C109.732 44.5521 109.985 44.6169 110.179 44.7364C110.377 44.8578 110.525 45.0157 110.633 45.208C110.736 45.4024 110.807 45.6068 110.843 45.8275C110.877 46.0461 110.886 46.2567 110.865 46.4591C110.839 46.783 110.77 47.1029 110.665 47.4247C110.56 47.7486 110.422 48.0523 110.25 48.3418C110.08 48.6293 109.886 48.8864 109.663 49.1131C109.444 49.3378 109.205 49.5139 108.948 49.6435C108.691 49.773 108.424 49.8398 108.147 49.8419H108.132V49.8479ZM107.926 50.7812C108.385 50.7792 108.819 50.6962 109.224 50.5362C109.626 50.3763 109.997 50.1536 110.329 49.8743C110.661 49.5929 110.952 49.269 111.203 48.9025C111.454 48.5361 111.651 48.1454 111.803 47.7304C111.952 47.3154 112.048 46.8923 112.084 46.4652C112.114 46.0988 112.092 45.7506 112.011 45.4105C111.934 45.0724 111.797 44.7687 111.6 44.4995C111.404 44.2303 111.141 44.0177 110.817 43.8598C110.491 43.7039 110.096 43.6209 109.634 43.6189C109.189 43.6209 108.766 43.6999 108.367 43.8517C107.968 44.0076 107.6 44.2201 107.266 44.4955C106.932 44.7688 106.636 45.0906 106.383 45.455C106.128 45.8214 105.926 46.2142 105.77 46.6413C105.614 47.0664 105.517 47.5078 105.476 47.9632C105.444 48.3519 105.472 48.7163 105.561 49.0524C105.651 49.3925 105.798 49.6921 106.005 49.9492C106.209 50.2083 106.474 50.4087 106.794 50.5545C107.112 50.7002 107.485 50.7771 107.914 50.7792H107.926V50.7812ZM104.709 49.4228C104.586 49.4815 104.444 49.5382 104.284 49.5969C104.124 49.6556 103.942 49.7022 103.744 49.7427C103.545 49.7832 103.329 49.8014 103.092 49.8034C102.719 49.8014 102.411 49.7265 102.175 49.5746C101.936 49.4248 101.762 49.2123 101.656 48.937C101.553 48.6617 101.517 48.3378 101.547 47.9632C101.573 47.6373 101.646 47.3154 101.758 46.9936C101.871 46.6717 102.023 46.368 102.211 46.0805C102.401 45.7931 102.622 45.538 102.877 45.3153C103.134 45.0906 103.416 44.9165 103.727 44.789C104.037 44.6615 104.373 44.5967 104.729 44.5926C104.984 44.5947 105.205 44.621 105.393 44.6736C105.582 44.7222 105.74 44.7829 105.869 44.8477L106.286 43.9286C106.217 43.8841 106.112 43.8396 105.974 43.793C105.835 43.7464 105.673 43.7039 105.484 43.6695C105.296 43.6371 105.098 43.6209 104.883 43.6169C104.389 43.6189 103.922 43.7019 103.48 43.8598C103.039 44.0197 102.636 44.2444 102.268 44.5278C101.899 44.8133 101.577 45.1453 101.3 45.5259C101.021 45.9024 100.798 46.3134 100.632 46.7526C100.462 47.194 100.359 47.6495 100.316 48.1191C100.286 48.4876 100.31 48.8297 100.393 49.1475C100.474 49.4653 100.614 49.7467 100.812 49.9897C101.009 50.2306 101.266 50.4209 101.586 50.5585C101.905 50.6941 102.286 50.763 102.727 50.767C103.035 50.765 103.318 50.7407 103.578 50.6982C103.837 50.6537 104.065 50.599 104.262 50.5322C104.46 50.4694 104.622 50.4047 104.746 50.3419L104.709 49.4228ZM98.4194 50.767C98.5975 50.765 98.7534 50.7225 98.8951 50.6415C99.0348 50.5585 99.1482 50.4472 99.2352 50.3075C99.3223 50.1678 99.3729 50.0099 99.3911 49.8338C99.4053 49.6718 99.383 49.5261 99.3283 49.4006C99.2757 49.273 99.1927 49.1718 99.0793 49.0989C98.968 49.026 98.8283 48.9876 98.6684 48.9856C98.4902 48.9876 98.3344 49.0301 98.1926 49.1151C98.053 49.2001 97.9396 49.3135 97.8525 49.4552C97.7655 49.5989 97.7149 49.7568 97.6967 49.933C97.6825 50.0909 97.7048 50.2326 97.7594 50.3581C97.8121 50.4836 97.893 50.5828 98.0044 50.6557C98.1157 50.7286 98.2493 50.767 98.4052 50.769H98.4194V50.767ZM88.4553 50.6253L89.2975 47.5118C89.4189 47.0543 89.5789 46.6535 89.7813 46.3073C89.9817 45.9611 90.2004 45.6858 90.4392 45.4915C90.6781 45.2951 90.915 45.1939 91.1478 45.1919C91.3138 45.1939 91.4393 45.2323 91.5284 45.3052C91.6174 45.3781 91.6761 45.4793 91.7065 45.6068C91.7348 45.7344 91.745 45.8781 91.7288 46.0401C91.7186 46.1595 91.6984 46.287 91.6721 46.4166C91.6437 46.5482 91.6114 46.6838 91.579 46.8174L90.5384 50.6253H92.5061L93.3483 47.4976C93.4799 47.028 93.6438 46.619 93.8422 46.2749C94.0386 45.9307 94.2512 45.6635 94.4819 45.4753C94.7107 45.287 94.9395 45.1918 95.1682 45.1898C95.3241 45.1898 95.4476 45.2242 95.5447 45.2951C95.6379 45.3639 95.7047 45.4611 95.7452 45.5826C95.7816 45.706 95.7937 45.8457 95.7796 46.0097C95.7674 46.1433 95.7472 46.283 95.7168 46.4267C95.6865 46.5684 95.65 46.7081 95.6115 46.8437L94.6014 50.6233H96.5833L97.6703 46.6049C97.6987 46.4834 97.7291 46.3498 97.7574 46.202C97.7858 46.0563 97.8121 45.9125 97.8363 45.7729C97.8606 45.6311 97.8748 45.5137 97.8829 45.4166C97.9153 45.0218 97.8748 44.6878 97.7675 44.4104C97.6582 44.1311 97.4841 43.9205 97.2452 43.7728C97.0084 43.625 96.7128 43.5501 96.3565 43.548C96.0549 43.548 95.7553 43.5946 95.4597 43.6918C95.1662 43.7869 94.8828 43.9327 94.6115 44.125C94.3402 44.3214 94.0892 44.5663 93.8544 44.8639C93.8524 44.71 93.826 44.5542 93.7673 44.4023C93.7086 44.2485 93.6216 44.1068 93.5001 43.9772C93.3786 43.8497 93.2207 43.7464 93.0264 43.6675C92.8321 43.5885 92.5972 43.5501 92.3219 43.546C91.8745 43.544 91.4393 43.6472 91.0202 43.8557C90.5992 44.0663 90.2084 44.3902 89.8501 44.8356H89.8218L90.0445 43.7039H88.2893C88.2225 44.0157 88.1456 44.3578 88.0586 44.7323C87.9695 45.1068 87.8683 45.5158 87.7468 45.953L86.4917 50.6233H88.4553V50.6253ZM85.3459 43.7039L84.4673 46.9166C84.3418 47.3762 84.1758 47.7709 83.9774 48.0989C83.7749 48.4288 83.5563 48.6819 83.3195 48.858C83.0826 49.0321 82.8457 49.1232 82.6129 49.1252C82.4429 49.1232 82.3113 49.0868 82.2162 49.0159C82.121 48.9451 82.0542 48.8499 82.0178 48.7325C81.9834 48.6131 81.9732 48.4795 81.9854 48.3317C81.9955 48.2021 82.0178 48.0584 82.0502 47.8985C82.0826 47.7406 82.119 47.5766 82.1615 47.4126L83.1798 43.7039H81.1412L80.0804 47.5685C80.0116 47.8094 79.9569 48.0361 79.9144 48.2487C79.876 48.4612 79.8476 48.6596 79.8314 48.8438C79.797 49.2831 79.8375 49.6455 79.9549 49.9309C80.0723 50.2184 80.2566 50.431 80.5096 50.5727C80.7647 50.7124 81.0764 50.7832 81.4509 50.7832C81.87 50.7852 82.2911 50.684 82.7121 50.4796C83.1352 50.2751 83.5421 49.9471 83.9369 49.4957L83.9632 49.5099L83.7425 50.6273H85.5402C85.6151 50.3156 85.7001 49.9714 85.7912 49.5989C85.8844 49.2244 85.9896 48.8155 86.1111 48.3762L87.3804 43.7059H85.3459V43.7039ZM75.0093 47.1434C75.1267 46.7405 75.2826 46.3964 75.481 46.1049C75.6774 45.8174 75.896 45.5927 76.1349 45.4388C76.3778 45.2829 76.6208 45.206 76.8697 45.204C77.0762 45.206 77.2422 45.2586 77.3678 45.3619C77.4933 45.4631 77.5803 45.6048 77.6289 45.7809C77.6795 45.9611 77.6937 46.1636 77.6734 46.3923C77.6532 46.6352 77.5985 46.8883 77.5135 47.1494C77.4285 47.4106 77.3171 47.6657 77.1754 47.9147C77.0378 48.1616 76.8738 48.3843 76.6916 48.5827C76.5074 48.7831 76.307 48.941 76.0924 49.0584C75.8758 49.1738 75.647 49.2346 75.4102 49.2386C75.1672 49.2386 74.9871 49.1718 74.8636 49.0422C74.7401 48.9127 74.6854 48.7224 74.6976 48.4734C74.7016 48.3317 74.7178 48.1981 74.7462 48.0705C74.7705 47.943 74.8008 47.8236 74.8332 47.7102L75.0093 47.1434ZM74.8109 40.5762L72.823 47.5827C72.7623 47.7871 72.7076 47.9956 72.661 48.2082C72.6125 48.4187 72.5801 48.6313 72.5618 48.8418C72.5092 49.4613 72.6752 49.939 73.0578 50.2731C73.4404 50.6091 74.0417 50.7751 74.8616 50.7812C75.4851 50.7771 76.0499 50.682 76.558 50.4958C77.0661 50.3095 77.5176 50.0544 77.9103 49.7305C78.301 49.4066 78.635 49.0402 78.9103 48.6293C79.1857 48.2163 79.4023 47.7831 79.5602 47.3276C79.716 46.8721 79.8132 46.4186 79.8517 45.9692C79.878 45.6575 79.8638 45.3578 79.8011 45.0704C79.7424 44.7829 79.6371 44.5258 79.4873 44.2971C79.3334 44.0683 79.133 43.8881 78.88 43.7545C78.6269 43.6209 78.3212 43.5521 77.9609 43.548C77.6775 43.548 77.4001 43.5906 77.1329 43.6715C76.8637 43.7485 76.6147 43.8659 76.3778 44.0116C76.141 44.1594 75.9304 44.3376 75.7422 44.54H75.7138L76.8677 40.5762H74.8109ZM70.0921 46.7466C69.9382 47.3114 69.754 47.7689 69.5394 48.1211C69.3269 48.4734 69.1062 48.7325 68.8754 48.8945C68.6447 49.0605 68.428 49.1394 68.2216 49.1374C68.0333 49.1354 67.8815 49.0888 67.7661 48.9916C67.6487 48.8945 67.5677 48.7629 67.5211 48.5908C67.4766 48.4187 67.4624 48.2203 67.4827 47.9916C67.5049 47.7325 67.5636 47.4652 67.6608 47.194C67.7559 46.9247 67.8815 46.6636 68.0373 46.4126C68.1932 46.1615 68.3714 45.9388 68.5779 45.7405C68.7803 45.54 69.0009 45.3842 69.2398 45.2668C69.4787 45.1514 69.7297 45.0927 69.9909 45.0906C70.0961 45.0906 70.1974 45.0987 70.2945 45.1068C70.3897 45.119 70.4767 45.1331 70.5537 45.1473L70.0921 46.7466ZM71.3654 50.6253C71.3776 50.4067 71.3998 50.1658 71.4363 49.8986C71.4707 49.6354 71.5132 49.3601 71.5638 49.0787C71.6124 48.7973 71.6671 48.522 71.7278 48.2527C71.7885 47.9835 71.8493 47.7385 71.91 47.5118L72.9364 43.8881C72.7461 43.8274 72.5295 43.7707 72.2865 43.7181C72.0416 43.6655 71.7825 43.625 71.5092 43.5946C71.2379 43.5642 70.9626 43.548 70.6873 43.548C70.0071 43.5501 69.3937 43.6452 68.8451 43.8274C68.2944 44.0096 67.8106 44.2566 67.3916 44.5744C66.9725 44.8922 66.6142 45.2566 66.3227 45.6676C66.0291 46.0785 65.8004 46.5138 65.6344 46.9774C65.4704 47.4389 65.3672 47.9045 65.3287 48.3762C65.2902 48.86 65.3449 49.2811 65.4886 49.6394C65.6324 49.9998 65.853 50.2791 66.1486 50.4796C66.4462 50.6779 66.8025 50.7792 67.2195 50.7812C67.4908 50.7832 67.7681 50.7366 68.0495 50.6395C68.3329 50.5423 68.6102 50.3824 68.8876 50.1577C69.1629 49.933 69.422 49.6313 69.669 49.2528H69.6973C69.6629 49.4998 69.6265 49.7407 69.59 49.9694C69.5536 50.2002 69.5212 50.4208 69.4969 50.6253H71.3654ZM60.5977 50.6253L61.2091 48.4025L62.035 47.6656L63.0047 50.6233H65.2842L63.7011 46.5603L66.8855 43.7019H64.3651L62.4197 45.8113C62.3103 45.9308 62.199 46.0583 62.0816 46.1878C61.9662 46.3194 61.8488 46.4551 61.7314 46.5887H61.703L63.3549 40.5742H61.3305L58.5774 50.6233H60.5977V50.6253ZM57.1988 50.767C57.3769 50.765 57.5328 50.7225 57.6745 50.6415C57.8142 50.5585 57.9275 50.4472 58.0146 50.3075C58.1016 50.1678 58.1522 50.0099 58.1705 49.8338C58.1846 49.6718 58.1624 49.5261 58.1077 49.4006C58.0551 49.273 57.9721 49.1718 57.8587 49.0989C57.7474 49.026 57.6077 48.9876 57.4478 48.9856C57.2696 48.9876 57.1137 49.0301 56.972 49.1151C56.8323 49.2001 56.719 49.3135 56.6319 49.4552C56.5449 49.5989 56.4943 49.7568 56.476 49.933C56.4639 50.0909 56.4841 50.2326 56.5388 50.3581C56.5914 50.4836 56.6724 50.5828 56.7817 50.6557C56.8931 50.7286 57.0267 50.767 57.1826 50.769H57.1988V50.767ZM48.834 43.7748L48.8967 50.6253H49.9859L52.2694 46.8599C52.3908 46.6595 52.4981 46.4632 52.5993 46.2749C52.7006 46.0866 52.7977 45.8943 52.8969 45.7C52.9961 45.5036 53.1014 45.2971 53.2107 45.0765H53.2391C53.2127 45.3781 53.1945 45.6797 53.1864 45.9773C53.1763 46.2769 53.1763 46.5867 53.1844 46.9025L53.3241 50.6253H54.4132L58.3709 43.7748H57.1826L54.9962 47.7244C54.8302 48.0523 54.6845 48.36 54.5569 48.6374C54.4314 48.9187 54.312 49.1941 54.2006 49.4653H54.1723C54.1905 49.2386 54.2047 48.9795 54.2067 48.6839C54.2128 48.3884 54.2128 48.0564 54.2087 47.6818L54.1116 43.7748H53.0791L50.7207 47.7527C50.5223 48.0948 50.3462 48.4086 50.1984 48.6981C50.0466 48.9876 49.9231 49.2427 49.828 49.4653H49.7854C49.8057 49.2831 49.8259 49.107 49.8421 48.9329C49.8583 48.7588 49.8725 48.5645 49.8867 48.358C49.8988 48.1495 49.9069 47.9086 49.913 47.6272L49.996 43.7768H48.834V43.7748ZM39.3457 43.7748L39.4084 50.6253H40.4975L42.7811 46.8599C42.9025 46.6595 43.0098 46.4632 43.111 46.2749C43.2122 46.0866 43.3094 45.8943 43.4086 45.7C43.5078 45.5036 43.6131 45.2971 43.7224 45.0765H43.7507C43.7264 45.3781 43.7062 45.6797 43.6981 45.9773C43.688 46.2769 43.688 46.5867 43.6961 46.9025L43.8358 50.6253H44.9249L48.8826 43.7748H47.6942L45.5099 47.7244C45.3439 48.0523 45.1982 48.36 45.0706 48.6374C44.9451 48.9187 44.8257 49.1941 44.7143 49.4653H44.686C44.7042 49.2386 44.7164 48.9795 44.7204 48.6839C44.7265 48.3884 44.7265 48.0564 44.7224 47.6818L44.6253 43.7748H43.5928L41.2344 47.7527C41.036 48.0948 40.8599 48.4086 40.7121 48.6981C40.5603 48.9876 40.4368 49.2427 40.3417 49.4653H40.2992C40.3194 49.2831 40.3396 49.107 40.3558 48.9329C40.372 48.7588 40.3862 48.5645 40.4004 48.358C40.4125 48.1495 40.4206 47.9086 40.4267 47.6272L40.5097 43.7768H39.3457V43.7748ZM29.8594 43.7748L29.9221 50.6253H31.0113L33.2948 46.8599C33.4162 46.6595 33.5235 46.4632 33.6247 46.2749C33.726 46.0866 33.8252 45.8943 33.9223 45.7C34.0215 45.5036 34.1268 45.2971 34.2361 45.0765H34.2644C34.2381 45.3781 34.2199 45.6797 34.2118 45.9773C34.1997 46.2769 34.2017 46.5867 34.2098 46.9025L34.3495 50.6253H35.4386L39.3963 43.7748H38.208L36.0236 47.7244C35.8576 48.0523 35.7119 48.36 35.5843 48.6374C35.4588 48.9187 35.3394 49.1941 35.2281 49.4653H35.1997C35.2179 49.2386 35.2301 48.9795 35.2341 48.6839C35.2402 48.3884 35.2402 48.0564 35.2362 47.6818L35.139 43.7748H34.1065L31.7481 47.7527C31.5497 48.0948 31.3736 48.4086 31.2258 48.6981C31.074 48.9876 30.9505 49.2427 30.8554 49.4653H30.8129C30.8331 49.2831 30.8533 49.107 30.8695 48.9329C30.8857 48.7588 30.8999 48.5645 30.9121 48.358C30.9242 48.1495 30.9343 47.9086 30.9384 47.6272L31.0214 43.7768H29.8594V43.7748Z"
      fill="#175FAD"
    />
    <path
      fillRule="evenodd"
      clipRule="evenodd"
      d="M101.513 26.4963C101.888 25.5125 102.262 24.5306 102.59 23.5468V23.5002C102.871 22.7046 103.246 21.8159 103.667 21.1135C104.088 20.5041 104.697 19.8968 105.493 20.083C106.289 20.2693 106.57 21.1135 106.663 21.8159C106.756 22.6115 106.71 23.4537 106.617 24.2492L106.477 26.308C109.613 26.1218 112.704 25.7473 115.7 25.2776C116.168 24.4355 116.635 23.5448 117.105 22.7026C117.619 21.6722 118.229 20.6438 118.978 19.7996C119.212 19.4717 119.538 19.1437 119.866 18.9109C120.334 18.583 120.85 18.4433 121.364 18.6761C122.395 19.1437 122.16 20.5021 121.974 21.3442V21.3908L121.225 24.2007C122.488 23.8727 123.707 23.5448 124.923 23.1702C126.796 17.8805 128.247 12.4977 129.229 6.92654V6.87998L129.276 6.83342C129.415 6.27266 129.697 5.00742 129.089 4.53978C128.715 4.25839 128.106 4.30496 127.684 4.35354C126.889 4.49322 126.093 4.82117 125.484 5.24225C124.923 5.61676 124.36 6.13095 124.032 6.69374V6.7403C121.176 11.281 118.368 15.8217 115.558 20.3624C114.856 21.4394 113.451 22.4212 112.188 21.8605C111.204 21.4394 110.925 20.409 110.925 19.4251C111.159 15.68 111.392 11.9814 111.627 8.28288C111.674 7.11279 111.487 5.24022 110.175 4.81915C109.613 4.58432 109.005 4.77259 108.489 5.05398C107.554 5.61473 106.851 6.59859 106.382 7.53588H106.335C102.871 13.5281 100.203 19.9879 97.9077 26.5429C99.1264 26.5429 100.343 26.5429 101.513 26.4963ZM64.2502 15.3075C64.2967 14.4654 64.4384 13.5746 64.6247 12.7791C64.9061 11.4207 65.7482 8.2849 67.5277 8.2849C69.6351 8.23834 71.6939 8.23834 73.7547 8.19178H73.8012C77.4532 8.19178 78.7165 10.1575 77.265 13.4815L77.2184 13.5281V13.5746C76.7973 14.3702 76.2346 15.1192 75.5807 15.7751C73.615 17.7408 70.9469 18.2105 68.2301 18.1153C67.9487 18.0688 67.6694 18.0688 67.388 18.0688C66.4993 18.0688 65.6085 17.9757 64.9061 17.3663C64.3433 16.8056 64.2036 16.0565 64.2502 15.3075ZM94.4905 26.4498C94.6302 25.9821 94.8185 25.5145 95.0047 25.0448C96.1748 21.6742 97.1587 18.257 98.0939 14.8399C98.0939 14.5119 98.0939 13.7629 97.8125 13.6232C97.7194 13.5301 97.5311 13.6232 97.438 13.6232C96.9704 13.8115 96.5028 14.184 96.1748 14.5119H96.1282C95.3792 15.2144 94.7699 16.7124 94.3954 17.6477C93.7395 19.334 93.2718 21.0649 92.7576 22.7978C92.3831 23.9679 92.0552 25.1845 91.6341 26.3566C92.5714 26.4032 93.5087 26.4498 94.4905 26.4498ZM81.7571 25.7007C81.8502 25.561 81.8968 25.4193 81.9454 25.2797C82.3664 24.063 82.8806 22.8929 83.3503 21.6742C83.7248 20.739 84.0993 19.7551 84.4273 18.7712C84.8018 17.5546 85.0832 16.3379 85.316 15.0727C85.3625 14.6516 85.4091 13.856 84.9415 13.5746C84.6601 13.3884 84.1924 13.4815 83.8645 13.6212C83.2086 13.856 82.6478 14.4633 82.2268 15.0727C81.0101 17.2732 80.0262 19.6599 79.4169 22.0953V22.1884L79.3703 22.235C78.9027 23.4051 77.8723 24.9962 76.3742 24.6217C75.5321 24.4335 75.0159 23.733 74.8296 22.9354L74.7831 22.8889V22.8423C74.5968 21.8119 73.9409 21.0629 73.1453 20.409L72.1149 19.5668L73.2385 18.8178C77.4047 15.9148 80.1194 12.5908 79.4169 7.20793C78.7144 4.2584 73.5178 4.25839 71.2242 4.35151H71.1776C67.6208 4.30495 64.0153 4.2584 60.4565 4.16527C59.7074 6.41235 58.9584 8.61286 58.2094 10.8134C56.9462 14.7468 55.7275 18.7247 54.6991 22.7046C56.7113 22.9395 58.8187 23.2188 60.8775 23.4537C61.1124 23.0326 61.3917 22.6115 61.6731 22.3301L61.9545 22.0487H62.3756C64.8109 22.0953 67.2442 22.1419 69.6796 22.1884H69.7727C71.4104 22.3281 73.0502 22.984 73.7992 24.6238C73.8458 24.7169 73.8923 24.8586 73.9389 24.9983C76.5625 25.2797 79.1841 25.5125 81.7571 25.7007ZM51.3285 22.3301C51.6099 21.5345 51.8427 20.7855 52.0775 19.9899C52.452 18.6316 52.9662 16.3845 52.1706 15.0747C52.1241 14.9816 52.031 14.8885 51.9824 14.7933C51.6079 14.5119 51.2333 14.2326 50.8588 14.0443C48.9863 13.0604 46.6926 13.0604 44.6804 13.435C42.8544 13.8095 40.8887 14.5585 39.3441 15.5889C38.6416 16.0565 37.2367 17.1335 37.1901 18.0708V18.1639L37.1436 18.257C37.1901 18.6316 38.1274 19.0526 38.4068 19.1458C38.7348 19.2389 39.6235 19.4271 39.9514 19.2854L39.998 19.2389L40.0911 19.0992C41.8705 17.1335 43.9293 15.9148 46.5975 17.1335C47.1582 17.3683 47.6279 17.7894 47.9073 18.3967C48.4701 19.5203 48.1887 20.8786 47.4862 21.907C48.7535 22.0487 50.0187 22.1884 51.3285 22.3301ZM26.1431 21.0649C26.3293 18.6316 27.0783 16.2428 28.4832 13.9957C30.4955 10.5785 33.6333 7.91039 36.7691 5.52161C37.0505 5.24022 37.3319 4.58635 37.0505 4.20981C36.7691 3.78874 36.0666 4.02357 35.7387 4.16325C33.3985 5.37991 31.1514 6.69171 29.044 8.18976C26.4224 9.96919 24.0357 12.028 21.7886 14.2751C21.2258 14.8358 20.5254 15.352 19.7763 15.5869C19.0739 15.8217 18.3249 15.7266 17.7641 15.2589C17.0151 14.6496 16.922 13.5726 17.2013 12.6839V12.5908C17.9503 10.53 18.5597 8.42459 18.9808 6.27064C19.0739 5.803 19.167 5.19366 19.0273 4.72603C18.9808 4.63291 18.8876 4.4912 18.7925 4.44463C18.6528 4.39807 18.418 4.4912 18.2783 4.58432C17.8572 4.81915 17.4827 5.28678 17.2479 5.75442C14.4866 10.53 12.2861 15.68 10.367 20.828C9.80622 22.4192 9.24344 24.0124 8.68066 25.6036C13.27 22.7512 19.2621 21.4394 26.1431 21.0649ZM133.254 19.9413C135.219 15.4938 136.906 10.9065 138.404 6.36579C138.59 5.89815 138.638 5.24225 138.217 4.86774C137.843 4.49323 137.187 4.44666 136.719 4.53978C136.159 4.6329 135.596 4.96086 135.314 5.52364V5.5702C134.612 6.78685 134.051 8.14522 133.535 9.455C132.879 11.1413 132.318 12.8722 131.802 14.6516C131.146 16.8987 130.539 19.1458 129.929 21.3928C131.053 20.9718 132.177 20.4576 133.254 19.9413Z"
      fill="#175FAD"
    />
    <path
      fillRule="evenodd"
      clipRule="evenodd"
      d="M145.331 28.3705C143.833 26.7793 138.683 23.2204 136.578 23.1273C131.1 22.9876 139.246 29.2592 139.902 30.243C141.774 32.1622 130.446 33.895 130.632 38.2009C130.632 38.8568 131.007 39.0431 131.663 38.8102C133.956 37.9215 138.122 35.6745 139.667 34.9254C141.774 33.8485 148.095 31.2734 145.331 28.3705ZM153.852 28.7915C152.447 27.2935 147.671 23.9694 145.752 23.9229C140.697 23.7832 148.234 29.5871 148.842 30.4779C150.528 32.2573 140.088 33.895 140.228 37.875C140.274 38.4378 140.602 38.624 141.212 38.3892C143.319 37.5936 147.204 35.5328 148.609 34.7837C150.574 33.8485 156.427 31.4597 153.852 28.7915Z"
      fill="#F05223"
    />
    <path
      fillRule="evenodd"
      clipRule="evenodd"
      d="M135.454 24.0616C135.454 24.2964 135.829 24.8571 135.968 24.9968C136.389 25.6527 136.999 26.26 137.513 26.8228C138.122 27.4322 138.73 27.9929 139.385 28.6023C139.713 28.8837 140.228 29.3513 140.509 29.7724C140.744 30.0072 140.884 30.3331 140.884 30.6611C140.884 30.7076 140.884 30.7076 140.884 30.7542C141.165 30.6611 141.398 30.6145 141.679 30.5679C142.896 30.2866 144.066 30.0537 145.238 29.8655C145.238 29.491 145.003 29.163 144.77 28.9302C143.459 27.5253 138.404 23.9684 136.578 23.9219C136.389 23.9219 135.687 23.9219 135.454 24.0616Z"
      fill="#F26B21"
    />
    <path
      fillRule="evenodd"
      clipRule="evenodd"
      d="M144.817 24.8106C144.864 25.3714 146.315 26.918 146.69 27.2925C147.253 27.8533 147.813 28.3695 148.376 28.9302C148.516 29.0699 148.704 29.2116 148.939 29.3979C150.437 29.3048 151.889 29.2582 153.245 29.2582C151.982 27.995 147.441 24.764 145.755 24.7175C145.566 24.6709 145.004 24.7175 144.817 24.8106Z"
      fill="#F26B21"
    />
  </svg>
);

export const WelcomeUILogo = () => (
  <Svg viewBox="0 0 31 10">
    <path
      d="M258.937 51.06c1.138 0 4.04 2.904 4.04 5.126 0 .2-.086.313-.26.338l-.08.005h-7.571c4.439 1.937 6.659 5.64 6.659 9.799 0 7.065-5.805 12.307-13.83 12.307-2.505 0-4.611-.285-6.376-.856a3.491 3.491 0 00-.57 1.88c0 1.432 1.326 2.224 3.672 2.277l.255.003h10.474c5.123 0 7.969 1.937 7.969 5.412 0 6.838-14.002 12.649-21.743 12.649-4.497 0-7.742-1.937-7.742-4.9 0-1.767 1.195-3.817 3.586-5.584-2.447-1.025-3.756-2.849-3.756-5.297 0-2.964 2.618-5.756 6.66-6.837-4.952-2.052-6.774-6.154-6.774-10.143 0-6.95 5.976-12.078 14.115-12.078 2.164 0 4.043.285 5.75.742 1.764-2.337 3.53-3.875 4.952-4.673a1.1 1.1 0 01.57-.17zm-20.948 38.685c2.277 5.127 7.457 6.266 11.498 6.266 3.644 0 6.148-1.31 6.148-3.19 0-1.543-1.223-2.34-3.824-2.391l-.274-.003h-8.71c-1.878 0-3.528-.228-4.838-.682zm-71.324-42.902c.342 0 .342.35.171.524-1.259 1.287-2.254 2.791-2.329 5.492l-.004.33v24.686c0 10.83-5.237 15.72-16.621 15.72-.57 0-1.138-.058-1.367-.117-.455-.115-.568-.523-.114-.756 4.57-1.995 7.174-6.163 7.283-11.69l.004-.362V53.19c0-2.911-1.025-4.484-2.333-5.823-.157-.16-.17-.467.091-.517l.078-.007h15.14zm129.67 8.318c6.944 0 11.895 3.533 11.895 8.546 0 5.584-6.204 9.459-15.54 9.459-.796 0-1.422-.058-2.048-.116 1.31 3.933 4.326 6.496 9.107 6.496 5.976 0 8.88-4.044 9.563-5.241.285-.513.74-.343.683.171-.456 3.588-4.782 12.59-15.483 12.59-8.823 0-14.912-6.152-14.912-15.61 0-9.8 6.545-16.295 16.735-16.295zm-99.216 0c.2 0 .31.087.336.262l.005.08v22.96c0 2.451.854 5.014 1.879 7.066.1.202.022.36-.156.393l-.071.006H187.5c-.2 0-.312-.088-.337-.263l-.006-.08v-5.583c-1.821 4.5-5.178 7.065-9.448 7.065-4.977 0-7.812-3.685-7.91-10.244l-.002-.354V64.62c0-3.589-.91-5.014-1.65-5.754-.152-.153-.124-.395.044-.486l.07-.027 10.7-2.963c.569-.17.798-.228.967-.228.2 0 .313.087.337.262l.006.08v20.624c0 3.02 1.08 4.615 3.016 4.615 2.331 0 3.634-2.111 3.698-6.23l.002-.32v-9.574c0-3.588-.91-5.013-1.651-5.753-.151-.153-.123-.395.044-.486l.07-.027 10.7-2.963c.57-.17.798-.228.97-.228zm-65.461 0c6.945 0 11.896 3.533 11.896 8.546 0 5.584-6.204 9.459-15.539 9.459-.797 0-1.422-.058-2.048-.116 1.309 3.933 4.326 6.496 9.107 6.496 5.976 0 8.88-4.044 9.562-5.241.285-.513.74-.343.684.171-.456 3.588-4.782 12.59-15.483 12.59-8.823 0-14.912-6.152-14.912-15.61 0-9.8 6.545-16.295 16.733-16.295zM14.856 48.837c.229 0 .342.114.342.343 0 .44-.215 3.133-.228 6.776v.344h7.856c.204 0 .409.094.365.278l-.024.065-1.138 2.222c-.1.198-.112.31-.267.336l-.076.005H14.97v18.972c0 2.45 1.311 3.817 3.644 3.817 1.8 0 3.319-.884 4.686-2.482-1.249-2.427-1.783-5.199-1.783-7.943 0-9.459 6.83-16.41 16.108-16.41 10.701 0 16.109 6.951 16.109 15.156 0 9.686-6.66 16.75-15.824 16.75-7.06 0-11.414-2.595-13.845-6.249-2.069 3.939-5.837 6.136-10.63 6.136-5.59 0-8.818-2.91-8.934-8.032l-.003-.286V59.206H.342c-.228 0-.342-.114-.342-.284 0-.21.144-.37.607-.702l.134-.095 13.148-8.831c.512-.343.797-.457.967-.457zm59.255 0c.228 0 .341.114.341.343 0 .44-.213 3.133-.226 6.776v.344h7.285c.202 0 .315.091.257.271l-.03.072-.968 2.28c-.048.145-.138.25-.307.276l-.091.007h-6.147v18.972c0 2.85 1.253 4.046 3.642 4.046 1.48 0 2.505-.342 3.132-1.025.17-.172.285-.23.399-.23.284 0 .284.286.17.571-1.31 3.59-4.667 5.413-9.335 5.413-5.533 0-8.376-2.91-8.478-8.032l-.003-.286V59.206h-4.156c-.227 0-.34-.114-.34-.284 0-.21.143-.37.605-.702l.134-.095 13.148-8.831c.514-.343.797-.457.968-.457zm20.662-4.33c.228 0 .343.114.343.342 0 .328-.21 1.645-.228 3.753l-.001.293v12.933c1.879-4.274 5.123-6.667 9.279-6.667 4.976 0 7.811 3.685 7.909 10.244l.003.354v12.704c0 2.451.853 5.014 1.877 7.066.102.202.023.36-.156.393l-.071.006H99.953c-.227 0-.342-.172-.227-.4 1.125-2.198 1.795-4.245 1.87-6.617l.007-.448V66.1c0-3.02-1.08-4.614-3.016-4.614-2.331 0-3.634 2.111-3.698 6.23l-.002.321v10.426c0 2.451.854 5.014 1.879 7.066.1.202.022.36-.156.393l-.072.006H82.763c-.228 0-.341-.172-.228-.4 1.126-2.198 1.797-4.245 1.872-6.617l.007-.448V56.814c0-2.78-.937-5.038-2.464-6.924l-.212-.255-.568-.74c-.152-.153-.124-.395.044-.486l.07-.027 12.523-3.647c.568-.17.797-.228.966-.228zM222.45 55.16c4.977 0 7.812 3.685 7.91 10.244l.002.354v12.704c0 2.451.853 5.014 1.879 7.066.101.202.022.36-.157.393l-.072.006h-13.774c-.227 0-.34-.172-.227-.4 1.125-2.198 1.795-4.245 1.87-6.617l.007-.448V66.1c0-3.02-1.08-4.614-3.017-4.614-2.33 0-3.633 2.111-3.697 6.23l-.003.321v10.426c0 2.451.741 5.071 1.88 7.066.1.202.022.36-.157.393l-.071.006h-13.774c-.23 0-.343-.172-.23-.4 1.237-2.152 1.814-4.254 1.875-6.64l.005-.425V64.618c0-3.588-.968-4.955-1.65-5.753-.152-.153-.125-.395.044-.486l.07-.027 10.7-2.963c.569-.17.796-.228.968-.228.227 0 .34.114.34.343 0 1.14-.113 3.817-.17 6.723 1.822-4.502 5.18-7.066 9.45-7.066zm53.792-10.654c.227 0 .34.114.34.342 0 .328-.207 1.645-.225 3.753l-.001.293v29.568c0 2.451.854 5.014 1.878 7.066.101.202.023.36-.155.393l-.072.006H264.23c-.227 0-.34-.172-.227-.4 1.125-2.198 1.797-4.245 1.872-6.617l.007-.448V56.814c0-2.78-.939-5.038-2.464-6.924l-.212-.255-.57-.74c-.15-.153-.123-.395.045-.486l.07-.027 12.522-3.647c.57-.17.797-.228.968-.228zM37.037 56.924l-.153.004c-3.187.17-4.212 5.128-3.756 14.357.512 9.286 2.049 14.186 5.237 14.014 3.188-.17 4.268-5.183 3.813-14.412-.495-8.989-2.004-13.814-4.99-13.96l-.15-.003zm210.095-.002l-.15.006c-2.447.113-3.528 3.59-3.13 10.083.398 6.837 2.05 9.914 4.44 9.857 2.619-.114 3.53-3.818 3.131-10.142-.383-6.239-1.764-9.693-4.144-9.801l-.147-.003zm48.348.006c-3.927 0-5.578 6.267-5.578 11.167 0 1.367.17 2.677.456 3.874 4.951-1.082 7.74-4.558 7.74-10.141 0-3.305-1.024-4.9-2.618-4.9zm-164.675 0c-3.927 0-5.579 6.267-5.579 11.167 0 1.367.171 2.677.456 3.874 4.951-1.082 7.741-4.558 7.741-10.141 0-3.305-1.024-4.9-2.618-4.9zM83.406 5.384c2.191 3.624 4.197 9.237 1.457 19.186-1.503 5.457-5.114 16.218-17.318 18.037-2.392.357-3.164-.518-4.014-1.696-1.662-2.303-3.683-7.229-2.805-13.532.416-2.985 1.027-4.876 1.91-7.436l-.002.002-.428.794c-3.74 6.942-7.788 14.952-11.658 20.741l-.446.658c-.47.684-.932.767-1.196.62-.246-.139-.2-.601-.04-1.248C53.43 23.077 41.168 8.096 37.407 3.617c-.297-.293-.39-1.077.457-1.15l.134-.006h14.7c.501 0 .542.149.791.286.872.48 6.022 11.518 3.84 21.96 4.868-8.915 9.061-14.888 9.184-15.085.297-.48.611-.502.9-.394.455.172.374.586.334.785-1.68 8.244-.477 16.97 2.194 21.47 2.498 4.21 7.59 5.388 9.439 1.133 4.553-10.474-6.871-23.144-9.086-25.506-1.058-1.144-.707-1.992-.442-2.271 4.761-4.809 11.303-3.18 13.554.545zm94.359 5.27c10.7 0 16.108 6.95 16.108 15.155 0 9.685-6.66 16.75-15.823 16.75-9.36 0-13.966-4.558-15.634-10.101-1.572 4.154-5.919 10.101-14.478 10.101-8.88 0-14.857-6.268-14.857-15.611 0-10.427 7.172-16.294 15.539-16.294 4.953 0 8.937 2.164 11.841 7.235.71 1.313.633 2.363-.483 2.797l-.145.051-8.31 2.451c-.399.114-.626 0-.455-.798 1.138-5.526.227-9.97-2.618-9.97-3.473 0-5.067 6.38-5.067 11.053 0 6.723 3.302 11.565 9.734 11.565 4.815 0 7.632-2.726 8.865-4.364a19.706 19.706 0 01-.326-3.612c0-9.458 6.83-16.408 16.109-16.408zm-74.284 0c6.945 0 11.897 3.532 11.897 8.546 0 5.584-6.205 9.457-15.54 9.457-.796 0-1.422-.056-2.048-.114 1.31 3.931 4.326 6.495 9.106 6.495 5.977 0 8.88-4.044 9.563-5.24.285-.515.74-.343.684.17-.456 3.589-4.782 12.591-15.483 12.591-8.823 0-14.914-6.154-14.914-15.611 0-9.799 6.547-16.294 16.735-16.294zm156.933 0c6.945 0 11.897 3.532 11.897 8.546 0 5.584-6.205 9.457-15.54 9.457a20.88 20.88 0 01-2.048-.114c1.31 3.931 4.326 6.495 9.106 6.495 5.977 0 8.88-4.044 9.564-5.24.285-.515.74-.343.683.17-.456 3.589-4.782 12.591-15.483 12.591-8.822 0-14.914-6.154-14.914-15.611 0-9.799 6.547-16.294 16.735-16.294zm-27.322 0c4.64 0 7.468 3.682 7.568 9.912l.003.343v13.047c0 2.449.625 5.071 1.65 7.064.1.204.022.36-.156.393l-.072.006h-13.32c-.226 0-.341-.17-.226-.399 1.066-2.136 1.583-4.222 1.644-6.587l.006-.477V21.25c0-2.677-1.082-4.272-2.676-4.272-1.995 0-3.288 2.106-3.355 5.899l-.003.311v10.768c0 2.449.74 5.014 1.65 7.064.103.204.023.36-.155.393l-.072.006h-13.32c-.227 0-.34-.17-.227-.399 1.014-2.19 1.577-4.229 1.643-6.588l.007-.476V21.25c0-2.677-1.08-4.272-2.674-4.272-1.996 0-3.29 2.106-3.356 5.899l-.003.311v10.768c0 2.449.626 5.071 1.651 7.064.101.204.023.36-.156.393l-.072.006h-13.547c-.228 0-.341-.17-.228-.399 1.237-2.151 1.814-4.253 1.874-6.64l.005-.424V20.11c0-3.59-.968-4.956-1.651-5.754-.151-.152-.123-.394.045-.486l.07-.026 10.7-2.964c.57-.171.797-.227.968-.227.227 0 .34.113.34.341 0 1.14-.113 3.817-.169 6.723 1.821-4.501 5.179-7.064 9.106-7.064 3.783 0 6.37 2.448 7.23 6.76l.056.304h.115c1.82-4.501 5.18-7.064 9.107-7.064zM129.723 0c.227 0 .34.114.34.341 0 .328-.207 1.645-.225 3.752l-.001.293v29.57c0 2.45.853 5.014 1.878 7.064.101.204.023.36-.156.393l-.072.006h-13.775c-.227 0-.34-.17-.227-.4 1.125-2.197 1.795-4.244 1.87-6.615l.007-.448v-21.65c0-2.78-.937-5.038-2.462-6.924l-.212-.255-.57-.741c-.152-.151-.123-.393.045-.486l.07-.027L128.754.227c.57-.17.797-.227.968-.227zm47.454 12.415l-.153.004c-3.186.171-4.212 5.129-3.756 14.359.512 9.286 2.049 14.186 5.236 14.014 3.188-.171 4.27-5.185 3.814-14.413-.496-8.988-2.004-13.813-4.99-13.96l-.15-.004zm-74.55.004c-3.927 0-5.578 6.268-5.578 11.168 0 1.367.171 2.677.456 3.873 4.952-1.081 7.74-4.557 7.74-10.141 0-3.305-1.023-4.9-2.617-4.9zm156.934 0c-3.927 0-5.579 6.268-5.579 11.168 0 1.367.172 2.677.456 3.873 4.952-1.081 7.741-4.557 7.741-10.141 0-3.305-1.024-4.9-2.618-4.9z"
      fill="currentColor"
      fillRule="evenodd"
    />
  </Svg>
);
