# Contributing to sysi

Thank you for your interest in contributing to sysi! Here are some simple guidelines to help you get started.

## How to Contribute

1. **Fork the Repository**: Fork the repo and create your own copy.
2. **Clone the Repository**: Clone your fork to your local machine.
    ```bash
    git clone https://github.com/stuffbymax/sysi.git
    ```
3. **Create a Branch**: Always create a new branch for your work.
    ```bash
    git checkout -b your-branch-name
    ```
4. **Make Your Changes**: Make your changes in the new branch.
5. **Commit Your Changes**: Commit your changes with a clear and concise commit message.
    ```bash
    git add .
    git commit -m "Brief description of your changes"
    ```
6. **Push Your Changes**: Push your changes to your forked repository.
    ```bash
    git push origin your-branch-name
    ```
7. **Submit a Pull Request**: Create a pull request to the main repository.

## Guidelines for Good Code

- **Write Clean Code**: Ensure your code is readable and maintainable.
- **Follow Existing Styles**: Stick to the existing code style and conventions.
- **Comment When Necessary**: Add comments to explain complex logic.
- **Meaningful Names**: Use clear and descriptive names for variables and functions.
- **Keep It Simple**: Functions should do one thing and do it well.
- **Avoid Duplicates**: Reuse code whenever possible.
- **Test Your Code**: Write tests for new features and bug fixes.

## Reporting Issues

- **Be Clear**: Provide a clear and descriptive title.
- **Detail the Issue**: Describe the issue or suggestion in detail.
- **Steps to Reproduce**: Include steps to reproduce the issue if applicable.
- **Provide Context**: Add any other relevant information, such as screenshots or error messages.

## License

By contributing to [sysi], you will have responsibility and with responsibility comes great power.
do what you want with the code 

## Contact

If you have any questions or need help, feel free to reach out to the project maintainers.
