export default {
  // Navbar
  "navbar.upload": "上傳",
  "navbar.signin": "登入",
  "navbar.home": "首頁",
  "navbar.signup": "登入",
  "navbar.links.shares": "我的分享",
  "navbar.links.reverse": "檔案請求",
  "navbar.avatar.account": "帳號設定",
  "navbar.avatar.admin": "管理",
  "navbar.avatar.signout": "登出",
  // END navbar
  // /
  "home.title": "<h>自建</h> 檔案分享平台！",
  "home.description": "您真的放心把檔案交到第三方檔案平台手中嗎？",
  "home.bullet.a.name": "完全自建",
  "home.bullet.a.description": "輕松使用私有伺服器搭建檔案分享平台",
  "home.bullet.b.name": "完全隱私",
  "home.bullet.b.description": "您的檔案永遠不會被第三方存取",
  "home.bullet.c.name": "完全無限",
  "home.bullet.c.description": "想上傳多大都可以，更需要擔心的是您的存儲空間容量",
  "home.button.start": "開始使用",
  "home.button.source": "原始碼",
  // END /
  // /auth/signin
  "signin.title": "歡迎回來",
  "signin.description": "還沒有帳號嗎？請",
  "signin.button.signup": "註冊",
  "signin.input.email-or-username": "電子郵件或使用者名稱",
  "signin.input.email-or-username.placeholder": "請輸入電子郵件或使用者名稱",
  "signin.input.password": "密碼",
  "signin.input.password.placeholder": "請輸入密碼",
  "signin.button.submit": "登入",
  "signIn.notify.totp-required.title": "請繼續兩步驗證",
  "signIn.notify.totp-required.description": "請輸入一次性驗證碼",
  "signIn.oauth.or": "或",
  "signIn.oauth.signInWith": "登入方式",
  "signIn.oauth.github": "GitHub",
  "signIn.oauth.google": "Google",
  "signIn.oauth.microsoft": "Microsoft",
  "signIn.oauth.discord": "Discord",
  "signIn.oauth.oidc": "OpenID",
  // END /auth/signin
  // /auth/signup
  "signup.title": "建立帳號",
  "signup.description": "已經有帳號了？請",
  "signup.button.signin": "登入",
  "signup.input.username": "使用者名稱",
  "signup.input.username.placeholder": "請輸入使用者名稱",
  "signup.input.email": "電子郵件",
  "signup.input.email.placeholder": "請輸入電子郵件",
  "signup.button.submit": "註冊",
  // END /auth/signup
  // /auth/totp
  "totp.title": "TOTP 驗證",
  "totp.button.signIn": "登入",
  // END /auth/totp
  // /auth/reset-password
  "resetPassword.title": "忘記密碼？",
  "resetPassword.description": "請輸入Email以讓系統寄送重置密碼郵件",
  "resetPassword.notify.success": "重置密碼的連結已傳送到您的信箱",
  "resetPassword.button.back": "返回登入頁面",
  "resetPassword.text.resetPassword": "重置密碼",
  "resetPassword.text.enterNewPassword": "請輸入新密碼",
  "resetPassword.input.password": "新密碼",
  "resetPassword.notify.passwordReset": "您已重新設定密碼。",
  // /account
  "account.title": "我的帳號",
  "account.card.info.title": "帳號資訊",
  "account.card.info.username": "使用者名稱",
  "account.card.info.email": "Email",
  "account.notify.info.success": "帳號資訊更新成功！",
  "account.card.password.title": "密碼",
  "account.card.password.old": "舊密碼",
  "account.card.password.new": "新密碼",
  "account.card.password.noPasswordSet": "並未設定密碼，若希望使用E-mail與密碼進行登入則必須要設定密碼。",
  "account.notify.password.success": "密碼更改成功！",
  "account.card.oauth.title": "第三方登入",
  "account.card.oauth.github": "GitHub",
  "account.card.oauth.google": "Google",
  "account.card.oauth.microsoft": "Microsoft",
  "account.card.oauth.discord": "Discord",
  "account.card.oauth.oidc": "OpenID",
  "account.card.oauth.link": "聯結",
  "account.card.oauth.unlink": "取消聯結",
  "account.card.oauth.unlinked": "已取消聯結",
  "account.modal.unlink.title": "取消聯結第三方登入",
  "account.modal.unlink.description": "若不記得使用者名稱與密碼，取消聯結第三方登入可能會使您無法登入。",
  "account.notify.oauth.unlinked.success": "已完成取消聯結",
  "account.card.security.title": "安控",
  "account.card.security.totp.enable.description": "請輸入當前密碼開啟兩步驗證",
  "account.card.security.totp.disable.description": "請輸入當前密碼關閉兩步驗證",
  "account.card.security.totp.button.start": "開啟",
  "account.modal.totp.title": "開啟兩步驗證",
  "account.modal.totp.step1": "第一步：添加驗證應用程式 Authenticator",
  "account.modal.totp.step2": "第二步：輸入一次性驗證碼",
  "account.modal.totp.enterManually": "手動輸入",
  "account.modal.totp.code": "驗證碼",
  "common.button.clickToCopy": "複製",
  "account.modal.totp.verify": "確認",
  "account.notify.totp.disable": "成功關閉兩步驗證！",
  "account.notify.totp.enable": "成功開啟兩步驗證！",
  "account.card.language.title": "語言",
  "account.card.language.description": "此專案由社群進行翻譯，部分語言可能尚未完成翻譯。",
  "account.card.color.title": "顏色外觀",
  // ThemeSwitcher.tsx
  "account.theme.dark": "深色模式",
  "account.theme.light": "淺色模式",
  "account.theme.system": "比照系統",
  "account.button.delete": "刪除帳號",
  "account.modal.delete.title": "刪除帳號",
  "account.modal.delete.description": "您真的想刪除您的帳號，並刪除所有的分享嗎？",
  // END /account
  // /account/shares
  "account.shares.title": "我的分享",
  "account.shares.title.empty": "這裡空空如也 👀",
  "account.shares.description.empty": "您沒有建立任何分享",
  "account.shares.button.create": "建立分享",
  "account.shares.info.title": "分享資訊",
  "account.shares.table.id": "ID",
  "account.shares.table.name": "分享代號",
  "account.shares.table.description": "描述",
  "account.shares.table.visitors": "造訪次數",
  "account.shares.table.expiresAt": "失效於",
  "account.shares.table.createdAt": "創建於",
  "account.shares.table.size": "檔案大小",
  "account.shares.table.password-protected": "Password protected",
  "account.shares.table.visitor-count": "{count} of {max}",
  "account.shares.table.expiry-never": "Never",
  "account.shares.modal.share-informations": "分享資訊",
  "account.shares.modal.share-link": "分享連結",
  "account.shares.modal.delete.title": "刪除： {share}",
  "account.shares.modal.delete.description": "您真的想刪除這個分享嗎？",
  // END /account/shares
  // /account/reverseShares
  "account.reverseShares.title": "檔案請求",
  "account.reverseShares.description": "檔案請求允許您建立一個特定的上傳畫面，以便外部使用者與您分享檔案",
  "account.reverseShares.title.empty": "這里空空如也 👀",
  "account.reverseShares.description.empty": "您沒有建立任何檔案請求",
  // showCreateReverseShareModal.tsx
  "account.reverseShares.modal.title": "建立檔案請求",
  "account.reverseShares.modal.expiration.label": "過期時間",
  "account.reverseShares.modal.expiration.minute-singular": "分鐘",
  "account.reverseShares.modal.expiration.minute-plural": "分鐘",
  "account.reverseShares.modal.expiration.hour-singular": "小時",
  "account.reverseShares.modal.expiration.hour-plural": "小時",
  "account.reverseShares.modal.expiration.day-singular": "天",
  "account.reverseShares.modal.expiration.day-plural": "天",
  "account.reverseShares.modal.expiration.week-singular": "周",
  "account.reverseShares.modal.expiration.week-plural": "周",
  "account.reverseShares.modal.expiration.month-singular": "月",
  "account.reverseShares.modal.expiration.month-plural": "月",
  "account.reverseShares.modal.expiration.year-singular": "年",
  "account.reverseShares.modal.expiration.year-plural": "年",
  "account.reverseShares.modal.max-size.label": "上傳大小上限",
  "account.reverseShares.modal.send-email": "發送電子郵件通知",
  "account.reverseShares.modal.send-email.description": "當這個檔案請求連結被用於分享時，發送Email提醒",
  "account.reverseShares.modal.simplified": "簡單模式",
  "account.reverseShares.modal.simplified.description": "讓人們輕鬆地上傳檔案給您。他們將只能自定義檔案名稱與描述。",
  "account.reverseShares.modal.public-access": "公開存取",
  "account.reverseShares.modal.public-access.description": "公開此檔案請求。若停用此設定將只有您與上傳者可以存取檔案。",
  "account.reverseShares.modal.max-use.label": "最大使用次數",
  "account.reverseShares.modal.max-use.description": "這個檔案請求連結可被用於建立分享的最大使用次數",
  "account.reverseShare.never-expires": "這個檔案請求永不過期",
  "account.reverseShare.expires-on": "這個檔案請求將過期於 {expiration}",
  "account.reverseShares.table.no-shares": "當前沒有建立任何分享",
  "account.reverseShares.table.count.singular": "分享",
  "account.reverseShares.table.count.plural": "分享",
  "account.reverseShares.table.shares": "分享",
  "account.reverseShares.table.remaining": "剩餘使用次數",
  "account.reverseShares.table.max-size": "上傳大小上限",
  "account.reverseShares.table.expires": "過期時間",
  "account.reverseShares.modal.reverse-share-link": "檔案請求連結",
  "account.reverseShares.modal.delete.title": "刪除檔案請求連結",
  "account.reverseShares.modal.delete.description": "您真的想刪除此檔案請求連結嗎？聯結下所有關聯的檔案都將被刪除",
  // END /account/reverseShares
  // /admin
  "admin.title": "管理",
  "admin.button.users": "使用者管理",
  "admin.button.shares": "檔案管理",
  "admin.button.config": "配置管理",
  "admin.version": "版本",
  // END /admin
  // /admin/users
  "admin.users.title": "使用者管理",
  "admin.users.table.username": "使用者名稱",
  "admin.users.table.email": "Email",
  "admin.users.table.admin": "管理員",
  "admin.users.edit.update.title": "編輯使用者： {username}",
  "admin.users.edit.update.admin-privileges": "管理員",
  "admin.users.edit.update.change-password.title": "更改密碼",
  "admin.users.edit.update.change-password.field": "新密碼",
  "admin.users.edit.update.change-password.button": "保存新密碼",
  "admin.users.edit.update.notify.password.success": "密碼更新成功！",
  "admin.users.edit.delete.title": "刪除使用者 {username} ?",
  "admin.users.edit.delete.description": "您真的想刪除這個帳號，並刪除該使用者所有的檔案嗎？",
  // showCreateUserModal.tsx
  "admin.users.modal.create.title": "建立使用者",
  "admin.users.modal.create.username": "使用者名稱",
  "admin.users.modal.create.email": "Email",
  "admin.users.modal.create.password": "密碼",
  "admin.users.modal.create.manual-password": "手動設置密碼",
  "admin.users.modal.create.manual-password.description": "如果不勾選，使用者將會收到一封Email來設置他們的密碼",
  "admin.users.modal.create.admin": "管理員",
  "admin.users.modal.create.admin.description": "如果勾選，使用者將能查看管理員面板",
  // END /admin/users
  // /admin/shares
  "admin.shares.title": "檔案管理",
  "admin.shares.table.id": "分享 ID",
  "admin.shares.table.username": "建立者",
  "admin.shares.table.visitors": "造訪次數",
  "admin.shares.table.expires": "失效於",
  "admin.shares.edit.delete.title": "刪除： {id}",
  "admin.shares.edit.delete.description": "您真的想刪除這個檔案嗎？",
  // END /admin/shares
  // /upload
  "upload.title": "上傳",
  "upload.notify.confirm-leave": "您真的想離開這個網頁嗎？您的上傳會被中止。",
  "upload.notify.generic-error": "建立分享的過程中發生了錯誤",
  "upload.notify.count-failed": "{count} 檔案上傳失敗，請重試",
  "upload.reverse-share.error.invalid.title": "無效的檔案請求連結",
  "upload.reverse-share.error.invalid.description": "此檔案請求連結已過期/失效。",
  // Dropzone.tsx
  "upload.dropzone.title": "上傳檔案",
  "upload.dropzone.description": "將檔案拖曳至此以上傳，檔案大小不能超過 {maxSize}",
  "upload.dropzone.notify.file-too-big": "您的檔案超過了最大上傳限制 {maxSize}",
  // FileList.tsx
  "upload.filelist.name": "檔案名稱",
  "upload.filelist.size": "檔案大小",
  // showCreateUploadModal.tsx
  "upload.modal.title": "建立分享",
  "upload.modal.link.error.invalid": "只能包括字母，數字，下劃線(_)，和橫線(-)",
  "upload.modal.link.error.taken": "這個分享代號已經存在了",
  "upload.modal.not-signed-in": "當前沒有登入",
  "upload.modal.not-signed-in-description": "您將不能刪除您的分享或查看查看次數",
  "upload.modal.expires.never": "永不",
  "upload.modal.expires.never-long": "永久分享",
  "upload.modal.expires.error.too-long": "過期時間最大限制為 {max}",
  "upload.modal.link.label": "分享連結",
  "upload.modal.expires.label": "過期時間",
  "upload.modal.expires.minute-singular": "分鐘",
  "upload.modal.expires.minute-plural": "分鐘",
  "upload.modal.expires.hour-singular": "小時",
  "upload.modal.expires.hour-plural": "小時",
  "upload.modal.expires.day-singular": "天",
  "upload.modal.expires.day-plural": "天",
  "upload.modal.expires.week-singular": "周",
  "upload.modal.expires.week-plural": "周",
  "upload.modal.expires.month-singular": "月",
  "upload.modal.expires.month-plural": "月",
  "upload.modal.expires.year-singular": "年",
  "upload.modal.expires.year-plural": "年",
  "upload.modal.accordion.name-and-description.title": "名稱與說明",
  "upload.modal.accordion.name-and-description.name.placeholder": "檔案名稱",
  "upload.modal.accordion.name-and-description.description.placeholder": "檔案備註",
  "upload.modal.accordion.email.title": "Email提醒",
  "upload.modal.accordion.email.placeholder": "收件人Email地址",
  "upload.modal.accordion.email.invalid-email": "Email地址不可用",
  "upload.modal.accordion.security.title": "安全性選項",
  "upload.modal.accordion.security.password.label": "密碼保護",
  "upload.modal.accordion.security.password.placeholder": "無密碼",
  "upload.modal.accordion.security.max-views.label": "最大查看次數",
  "upload.modal.accordion.security.max-views.placeholder": "無限",
  // showCompletedUploadModal.tsx
  "upload.modal.completed.never-expires": "這個分享永不過期",
  "upload.modal.completed.expires-on": "這個分享將過期於 {expiration}。",
  "upload.modal.completed.share-ready": "分享建立完畢",
  "upload.modal.completed.notified-reverse-share-creator": "我們已經通知檔案請求連結的擁有者，你也可以手動分享此連結給他們。",
  // END /upload
  // /share/[id]
  "share.title": "分享 {shareId}",
  "share.description": "瞧瞧我給您分享了些什麽！",
  "share.error.visitor-limit-exceeded.title": "查看次數達到上限",
  "share.error.visitor-limit-exceeded.description": "查看次數達到上限",
  "share.error.removed.title": "分享已刪除",
  "share.error.not-found.title": "分享未找到",
  "share.error.not-found.description": "分享檔案遺失了",
  "share.error.access-denied.title": "私人分享",
  "share.error.access-denied.description": "您沒有權限存取此檔案",
  "share.modal.password.title": "需要密碼",
  "share.modal.password.description": "請輸入密碼來存取此檔案",
  "share.modal.password": "密碼",
  "share.modal.error.invalid-password": "密碼錯誤",
  "share.button.download-all": "全部下載",
  "share.notify.download-all-preparing": "正在處理中，請稍等片刻",
  "share.modal.file-link": "檔案連結",
  "share.table.name": "檔案名稱",
  "share.table.size": "檔案大小",
  "share.modal.file-preview.error.not-supported.title": "該檔案類型不支持預覽",
  "share.modal.file-preview.error.not-supported.description": "該檔案類型不支援預覽，請下載後再瀏覽。",
  // END /share/[id]
  // /share/[id]/edit
  "share.edit.title": "編輯 {shareId}",
  "share.edit.append-upload": "追加檔案",
  "share.edit.notify.generic-error": "保存分享的過程中發生了錯誤",
  "share.edit.notify.save-success": "分享已更新成功",
  // END /share/[id]/edit
  // /imprint
  "imprint.title": "Imprint",
  // END /imprint
  // /privacy
  "privacy.title": "Privacy Policy",
  // END /privacy
  // /admin/config
  "admin.config.title": "配置管理",
  "admin.config.category.general": "通用",
  "admin.config.category.share": "分享",
  "admin.config.category.email": "Email",
  "admin.config.category.smtp": "SMTP",
  "admin.config.category.oauth": "第三方登入",
  "admin.config.general.app-name": "App 名稱",
  "admin.config.general.app-name.description": "這個 App 的名稱",
  "admin.config.general.app-url": "App 網址",
  "admin.config.general.app-url.description": "Pingvin Share 的 URL",
  "admin.config.general.secure-cookies": "安全 cookies",
  "admin.config.general.secure-cookies.description": "是否要在cookies中設定安全標籤。若啟用，這個網站將無法透過HTTP瀏覽。",
  "admin.config.general.show-home-page": "顯示首頁",
  "admin.config.general.show-home-page.description": "是否顯示首頁",
  "admin.config.general.session-duration": "工作階段持續時間",
  "admin.config.general.session-duration.description": "使用者需要必須要重新登入的最長時間 (預設： 3 個月)",
  "admin.config.general.logo": "Logo",
  "admin.config.general.logo.description": "上傳個性化 Logo，圖片必須是長寬比 1:1 的 PNG 格式",
  "admin.config.general.logo.placeholder": "選擇圖片",
  "admin.config.email.enable-share-email-recipients": "啟用電子郵件收件者分享",
  "admin.config.email.enable-share-email-recipients.description": "是否允許與收件者分享電子郵件。僅當 SMTP 已啟用時才啟用此功能。",
  "admin.config.email.share-recipients-subject": "分享Email通知主題",
  "admin.config.email.share-recipients-subject.description": "發送分享Email通知的主題",
  "admin.config.email.share-recipients-message": "分享Email通知內容",
  "admin.config.email.share-recipients-message.description": "發送到接收者的分享Email通知具體內容。可使用的參數有：\n {creator} - 分享建立者\n {creatorEmail} - 分享建立者的電子郵件\n {shareUrl} - 分享連結\n {desc} - 分享描述\n {expires} - 分享過期時間\n 這些參數會被實際的值所替代",
  "admin.config.email.reverse-share-subject": "檔案請求Email通知主題",
  "admin.config.email.reverse-share-subject.description": "當有人使用了您的檔案請求連結時，發送的檔案請求通知的標題",
  "admin.config.email.reverse-share-message": "檔案請求Email通知內容",
  "admin.config.email.reverse-share-message.description": "當有人使用了您的檔案請求連結時，發送的通知內容。{shareUrl} 會被建立者的使用者名稱和分享連結代替",
  "admin.config.email.reset-password-subject": "重置密碼Email通知主題",
  "admin.config.email.reset-password-subject.description": "當使用者請求重置密碼時，發送的重置密碼通知的標題",
  "admin.config.email.reset-password-message": "重置密碼Email通知內容",
  "admin.config.email.reset-password-message.description": "當使用者發動重置密碼時，重置密碼通知內容。{url} 會被重置密碼聯結代替",
  "admin.config.email.invite-subject": "邀請Email通知主題",
  "admin.config.email.invite-subject.description": "當管理員邀請使用者時，發送的邀請通知的標題",
  "admin.config.email.invite-message": "邀請Email通知內容",
  "admin.config.email.invite-message.description": "當管理員邀請使用者時，發送的邀請通知內容。{url} 會被邀請連結代替，{email} 會被Email代替，{password} 會被密碼代替",
  "admin.config.share.allow-registration": "允許註冊",
  "admin.config.share.allow-registration.description": "是否允許註冊",
  "admin.config.share.allow-unauthenticated-shares": "是否允許未登入進行分享",
  "admin.config.share.allow-unauthenticated-shares.description": "是否允許未登入的使用者建立分享",
  "admin.config.share.max-expiration": "最大過期時間",
  "admin.config.share.max-expiration.description": "Maximum share expiration. Set to 0 to allow unlimited expiration.",
  "admin.config.share.share-id-length": "預設分享ID長度",
  "admin.config.share.share-id-length.description": "預設的自動生成分享ID長度。這個設定同時用於生成檔案請求連結。小於 8 被認為是不安全的。",
  "admin.config.share.max-size": "最大檔案上限",
  "admin.config.share.max-size.description": "最大檔案上限",
  "admin.config.share.zip-compression-level": "Zip 壓縮等級",
  "admin.config.share.zip-compression-level.description": "調整壓縮等級以平衡檔案大小和壓縮速度。 有效值範圍從 0 到 9，其中 0 表示無壓縮，9 表示最大壓縮",
  "admin.config.share.chunk-size": "分塊大小",
  "admin.config.share.chunk-size.description": "調整分塊大小 以平衡上傳的效率與可靠度。更小的分塊大小在不穩定的網路環境中可以提升成功率，更大的分塊大小可以在穩定的網路環境中提高上傳速度。",
  "admin.config.share.auto-open-share-modal": "自動開啟分享設定",
  "admin.config.share.auto-open-share-modal.description": "分享設定會在使用者選擇檔案後自動開啟而無須手動點擊。",
  "admin.config.smtp.enabled": "啟用",
  "admin.config.smtp.enabled.description": "是否開啟 SMTP，需輸入Host、Port、發送郵箱、使用者名稱和密碼後才有作用",
  "admin.config.smtp.host": "主機",
  "admin.config.smtp.host.description": "SMTP 主機地址",
  "admin.config.smtp.port": "通訊埠",
  "admin.config.smtp.port.description": "SMTP 通訊埠",
  "admin.config.smtp.email": "發送郵箱",
  "admin.config.smtp.email.description": "發送的郵箱地址",
  "admin.config.smtp.username": "使用者名稱",
  "admin.config.smtp.username.description": "SMTP 主機使用者名稱",
  "admin.config.smtp.password": "密碼",
  "admin.config.smtp.password.description": "SMTP 主機密碼",
  "admin.config.smtp.button.test": "發送測試Email",
  "admin.config.smtp.allow-unauthorized-certificates": "信任未經認證的 SMTP 伺服器證書",
  "admin.config.smtp.allow-unauthorized-certificates.description": "僅在你信任此自簽章證書時啟用此設定",
  "admin.config.oauth.allow-registration": "允許註冊",
  "admin.config.oauth.allow-registration.description": "允許使用者以第三方登入註冊",
  "admin.config.oauth.ignore-totp": "略過 TOTP",
  "admin.config.oauth.ignore-totp.description": "當使用者使用第三方登入時，略過 TOTP 驗證",
  "admin.config.oauth.disable-password": "停用密碼登入",
  "admin.config.oauth.disable-password.description": "當你停用密碼登入時，確保你有啟用任意 OAuth 服務以避免無法存取",
  "admin.config.oauth.github-enabled": "GitHub",
  "admin.config.oauth.github-enabled.description": "啟用 Github 登入",
  "admin.config.oauth.github-client-id": "Github 的客戶端 ID",
  "admin.config.oauth.github-client-id.description": "GitHub OAuth 的客戶端 ID",
  "admin.config.oauth.github-client-secret": "Github 客戶端權杖",
  "admin.config.oauth.github-client-secret.description": "GitHub OAuth 的客戶端權杖",
  "admin.config.oauth.google-enabled": "Google",
  "admin.config.oauth.google-enabled.description": "啟用 Google 登入",
  "admin.config.oauth.google-client-id": "Google 的客戶端 ID",
  "admin.config.oauth.google-client-id.description": "Google OAuth 的客戶端 ID",
  "admin.config.oauth.google-client-secret": "Google 的客戶端權杖",
  "admin.config.oauth.google-client-secret.description": "Google OAuth 的客戶端權杖",
  "admin.config.oauth.microsoft-enabled": "Microsoft",
  "admin.config.oauth.microsoft-enabled.description": "啟用 Microsoft 登入",
  "admin.config.oauth.microsoft-tenant": "Microsoft Tenant",
  "admin.config.oauth.microsoft-tenant.description": "Microsoft OAuth 的 Tenant ID\ncommon: 擁有 Microsoft Entra ID 的個人 Microsoft 帳號和工作或學校帳號的使用者可以登入該應用程式。\norganizations: 擁有 Microsoft Entra ID 的工作或學校帳號的使用者才能登入應用程式。\nconsumers: 只有擁有個人 Microsoft 帳號的使用者才能登入該應用程式。\ndomain name of the Microsoft Entra tenant or the tenant ID in GUID format: 只有來自特定 Microsoft Entra 租戶的使用者（具有工作或學校帳號的目錄成員或具有個人 Microsoft 帳號的目錄成員）才能登入應用程式。",
  "admin.config.oauth.microsoft-client-id": "Microsoft 的客戶端 ID",
  "admin.config.oauth.microsoft-client-id.description": "Microsoft OAuth 的客戶端 ID",
  "admin.config.oauth.microsoft-client-secret": "Microsoft 的客戶端權杖",
  "admin.config.oauth.microsoft-client-secret.description": "Microsoft OAuth 的客戶端權杖",
  "admin.config.oauth.discord-enabled": "Discord",
  "admin.config.oauth.discord-enabled.description": "啟用 Discord 登入",
  "admin.config.oauth.discord-limited-users": "Discord limited users",
  "admin.config.oauth.discord-limited-users.description": "Limit signing in to specific users by their Discord ID. Leave it blank to disable.",
  "admin.config.oauth.discord-limited-guild": "Discord limited server ID",
  "admin.config.oauth.discord-limited-guild.description": "Limit signing in to users in a specific server. Leave it blank to disable.",
  "admin.config.oauth.discord-client-id": "Discord Client ID",
  "admin.config.oauth.discord-client-id.description": "Discord OAuth 的 Client ID",
  "admin.config.oauth.discord-client-secret": "Discord Client secret",
  "admin.config.oauth.discord-client-secret.description": "Discord OAuth 的 Client secret",
  "admin.config.oauth.oidc-enabled": "OpenID Connect",
  "admin.config.oauth.oidc-enabled.description": "Whether OpenID Connect login is enabled",
  "admin.config.oauth.oidc-discovery-uri": "OpenID Connect Discovery URI",
  "admin.config.oauth.oidc-discovery-uri.description": "Discovery URI of the OpenID Connect OAuth app",
  "admin.config.oauth.oidc-sign-out": "Sign out from OpenID Connect",
  "admin.config.oauth.oidc-sign-out.description": "Whether the “Sign out” button will sign out from the OpenID Connect provider",
  "admin.config.oauth.oidc-scope": "OpenID Connect scope",
  "admin.config.oauth.oidc-scope.description": "Scopes which should be requested from the OpenID Connect provider.",
  "admin.config.oauth.oidc-username-claim": "OpenID Connect username claim",
  "admin.config.oauth.oidc-username-claim.description": "Username claim in OpenID Connect ID token. Leave it blank if you don't know what this config is.",
  "admin.config.oauth.oidc-role-path": "Path to roles in OpenID Connect token",
  "admin.config.oauth.oidc-role-path.description": "Must be a valid JMES path referencing an array of roles. " + "Managing access rights using OpenID Connect roles is only recommended if no other identity provider is configured and password login is disabled. " + "Leave it blank if you don't know what this config is.",
  "admin.config.oauth.oidc-role-general-access": "OpenID Connect role for general access",
  "admin.config.oauth.oidc-role-general-access.description": "Role required for general access. Must be present in a user’s roles for them to log in. " + "Leave it blank if you don't know what this config is.",
  "admin.config.oauth.oidc-role-admin-access": "OpenID Connect role for admin access",
  "admin.config.oauth.oidc-role-admin-access.description": "Role required for administrative access. Must be present in a user’s roles for them to access the admin panel. " + "Leave it blank if you don't know what this config is.",
  "admin.config.oauth.oidc-client-id": "OpenID Connect Client ID",
  "admin.config.oauth.oidc-client-id.description": "Client ID of the OpenID Connect OAuth app",
  "admin.config.oauth.oidc-client-secret": "OpenID Connect Client secret",
  "admin.config.oauth.oidc-client-secret.description": "Client secret of the OpenID Connect OAuth app",
  "admin.config.category.ldap": "LDAP",
  "admin.config.ldap.enabled": "Enable LDAP",
  "admin.config.ldap.enabled.description": "Use LDAP authentication for user login",
  "admin.config.ldap.url": "Server URL",
  "admin.config.ldap.url.description": "URL of the LDAP server",
  "admin.config.ldap.bind-dn": "Bind DN",
  "admin.config.ldap.bind-dn.description": "Default user used to perform the user search",
  "admin.config.ldap.bind-password": "Bind password",
  "admin.config.ldap.bind-password.description": "Password used to perform the user search",
  "admin.config.ldap.search-base": "User base",
  "admin.config.ldap.search-base.description": "Base location, where the user search will be performed",
  "admin.config.ldap.search-query": "User query",
  "admin.config.ldap.search-query.description": "The user query will be used to search the 'User base' for the LDAP user. %username% can be used as the placeholder for the user given input.",
  "admin.config.ldap.admin-groups": "Admin group",
  "admin.config.ldap.admin-groups.description": "Group required for administrative access.",
  "admin.config.ldap.field-name-member-of": "User groups attribute name",
  "admin.config.ldap.field-name-member-of.description": "LDAP attribute name for the groups, an user is a member of. This is used when checking for the admin group.",
  "admin.config.ldap.field-name-email": "User email attribute name",
  "admin.config.ldap.field-name-email.description": "LDAP attribute name for the email of an user.",
  "admin.config.notify.success": "Configuration updated successfully.",
  "admin.config.notify.logo-success": "Logo updated successfully. It may take a few minutes to update on the website.",
  "admin.config.notify.no-changes": "No changes to save.",
  "admin.config.category.s3": "S3",
  "admin.config.s3.enabled": "Enabled",
  "admin.config.s3.enabled.description": "Whether S3 should be used to store the shared files instead of the local file system.",
  "admin.config.s3.endpoint": "Endpoint",
  "admin.config.s3.endpoint.description": "The URL of the S3 bucket.",
  "admin.config.s3.region": "Region",
  "admin.config.s3.region.description": "The region of the S3 bucket.",
  "admin.config.s3.bucket-name": "Bucket name",
  "admin.config.s3.bucket-name.description": "The name of the S3 bucket.",
  "admin.config.s3.bucket-path": "Path",
  "admin.config.s3.bucket-path.description": "The default path which should be used to store the files in the S3 bucket.",
  "admin.config.s3.key": "Key",
  "admin.config.s3.key.description": "The key which allows you to access the S3 bucket.",
  "admin.config.s3.secret": "Secret",
  "admin.config.s3.secret.description": "The secret which allows you to access the S3 bucket.",
  "admin.config.category.legal": "Legal",
  "admin.config.legal.enabled": "Enable legal notices",
  "admin.config.legal.enabled.description": "Whether to show a link to imprint and privacy policy in the footer.",
  "admin.config.legal.imprint-text": "Imprint text",
  "admin.config.legal.imprint-text.description": "The text which should be shown in the imprint. Supports Markdown. Leave blank to link to an external imprint page.",
  "admin.config.legal.imprint-url": "Imprint URL",
  "admin.config.legal.imprint-url.description": "If you already have an imprint page you can link it here instead of using the text field.",
  "admin.config.legal.privacy-policy-text": "Privacy policy text",
  "admin.config.legal.privacy-policy-text.description": "The text which should be shown in the privacy policy. Supports Markdown. Leave blank to link to an external privacy policy page.",
  "admin.config.legal.privacy-policy-url": "Privacy policy URL",
  "admin.config.legal.privacy-policy-url.description": "If you already have a privacy policy page you can link it here instead of using the text field.",
  // 404
  "404.description": "查無此頁",
  "404.button.home": "返回主頁",
  // error
  "error.title": "錯誤",
  "error.description": "哎呀！",
  "error.button.back": "返回上一頁",
  "error.msg.default": "發生預期外的問題。",
  "error.msg.access_denied": "您取消了身分驗證，請重試。",
  "error.msg.expired_token": "身分驗證過程逾時，請重試。",
  "error.msg.invalid_token": "內部錯誤",
  "error.msg.no_user": "與此帳號 {0} 關聯的使用者不存在。",
  "error.msg.no_email": "無法從此帳號 {0} 取得Email地址。",
  "error.msg.already_linked": "此帳號 {0} 已與另一個帳號關聯。",
  "error.msg.not_linked": "此帳號 {0} 尚未關聯到任何帳號。",
  "error.msg.unverified_account": "此帳號 {0} 並未驗證，請驗證後再嘗試。",
  "error.msg.user_not_allowed": "您不被允許登入。",
  "error.msg.cannot_get_user_info": "無法從此帳號 {0} 取得使用者資料。",
  "error.param.provider_github": "GitHub",
  "error.param.provider_google": "Google",
  "error.param.provider_microsoft": "Microsoft",
  "error.param.provider_discord": "Discord",
  "error.param.provider_oidc": "OpenID Connect",
  // Common translations
  "common.button.save": "儲存",
  "common.button.create": "建立",
  "common.button.submit": "送出",
  "common.button.delete": "刪除",
  "common.button.cancel": "取消",
  "common.button.confirm": "確認",
  "common.button.disable": "關閉",
  "common.button.share": "分享",
  "common.button.generate": "自動產生",
  "common.button.done": "完成",
  "common.text.link": "聯結",
  "common.text.navigate-to-link": "瀏覽連結",
  "common.text.or": "或",
  "common.text.redirecting": "正在跳轉中...",
  "common.button.go-back": "返回",
  "common.button.go-home": "返回首頁",
  "common.notify.copied": "已複製到剪貼簿",
  "common.notify.copied-link": "已複製到剪貼簿",
  "common.success": "成功",
  "common.error": "錯誤",
  "common.error.unknown": "發生預期外錯誤",
  "common.error.invalid-email": "Email地址不可用",
  "common.error.too-short": "必須不少於 {length} 個字元",
  "common.error.too-long": "必須不超過 {length} 個字元",
  "common.error.number-too-small": "必須大於 {min}",
  "common.error.number-too-large": "必須小於 {max}",
  "common.error.exact-length": "必須為 {length} 個字元",
  "common.error.invalid-number": "必須為數字",
  "common.error.field-required": "必填"
};