export default {
  // Navbar
  "navbar.upload": "Завантажити",
  "navbar.signin": "Вхід",
  "navbar.home": "Головна",
  "navbar.signup": "Реєстрація",
  "navbar.links.shares": "Мої завантаження",
  "navbar.links.reverse": "Зворотні завантаження",
  "navbar.avatar.account": "Мій аккаунт",
  "navbar.avatar.admin": "Адміністрування",
  "navbar.avatar.signout": "Вийти",
  // END navbar
  // /
  "home.title": "Платформа для обміну файлами із <h>власного хостингу</h>.",
  "home.description": "Ви дійсно ви хочете передати свої особисті файли в руки третіх осіб, таких як WeTransfer?",
  "home.bullet.a.name": "На власному сервері",
  "home.bullet.a.description": "Pingvin Share працює на вашій машині.",
  "home.bullet.b.name": "Конфіденційність",
  "home.bullet.b.description": "Ваші файли є вашими, і вони ніколи не будуть доступні третім особам.",
  "home.bullet.c.name": "Без дратівливого обмеження розміру файлу",
  "home.bullet.c.description": "Завантажуйте файли будь-якого розміру. Лише жорсткий диск буде вашим обмеженням.",
  "home.button.start": "Почнемо",
  "home.button.source": "Вихідний код",
  // END /
  // /auth/signin
  "signin.title": "З поверненням",
  "signin.description": "У вас ще немає облікового запису?",
  "signin.button.signup": "Зареєструватися",
  "signin.input.email-or-username": "Email або логін",
  "signin.input.email-or-username.placeholder": "Ел. пошта або логін",
  "signin.input.password": "Пароль",
  "signin.input.password.placeholder": "Ваш пароль",
  "signin.button.submit": "Вхід",
  "signIn.notify.totp-required.title": "Потрібна двофакторна аутентифікація",
  "signIn.notify.totp-required.description": "Будь ласка, введіть код Вашої 2-х факторної аутентифікації",
  "signIn.oauth.or": "АБО",
  "signIn.oauth.signInWith": "Увійти з",
  "signIn.oauth.github": "GitHub",
  "signIn.oauth.google": "Google",
  "signIn.oauth.microsoft": "Microsoft",
  "signIn.oauth.discord": "Discord",
  "signIn.oauth.oidc": "OpenID",
  // END /auth/signin
  // /auth/signup
  "signup.title": "Створити акаунт",
  "signup.description": "Уже є обліковий запис?",
  "signup.button.signin": "Вхід",
  "signup.input.username": "Логін",
  "signup.input.username.placeholder": "Ваш логін (ім'я користувача)",
  "signup.input.email": "Електронна пошта",
  "signup.input.email.placeholder": "Адреса ел. пошти",
  "signup.button.submit": "Давайте почнемо",
  // END /auth/signup
  // /auth/totp
  "totp.title": "Авторизація TOTP",
  "totp.button.signIn": "Увійти",
  // END /auth/totp
  // /auth/reset-password
  "resetPassword.title": "Забули пароль?",
  "resetPassword.description": "Введіть ваш email для відновлення пароля.",
  "resetPassword.notify.success": "Повідомлення з посиланням для скидання пароля було надіслано, якщо вказана електронна пошта існує.",
  "resetPassword.button.back": "Повернутися на сторінку входу",
  "resetPassword.text.resetPassword": "Скинути пароль",
  "resetPassword.text.enterNewPassword": "Введіть новий пароль",
  "resetPassword.input.password": "Новий пароль",
  "resetPassword.notify.passwordReset": "Ваш пароль успішно скинуто.",
  // /account
  "account.title": "Мій акаунт",
  "account.card.info.title": "Інформація про акаунт",
  "account.card.info.username": "Логін",
  "account.card.info.email": "Електронна пошта",
  "account.notify.info.success": "Налаштування облікового запису успішно оновлено",
  "account.card.password.title": "Пароль",
  "account.card.password.old": "Старий пароль",
  "account.card.password.new": "Новий пароль",
  "account.card.password.noPasswordSet": "У вас не встановлено пароль. Щоб увійти за допомогою електронної пошти та пароля, потрібно створити пароль.",
  "account.notify.password.success": "Пароль успішно змінено",
  "account.card.oauth.title": "Вхід через соцмережі",
  "account.card.oauth.github": "GitHub",
  "account.card.oauth.google": "Google",
  "account.card.oauth.microsoft": "Microsoft",
  "account.card.oauth.discord": "Discord",
  "account.card.oauth.oidc": "OpenID",
  "account.card.oauth.link": "Підключити",
  "account.card.oauth.unlink": "Відключити",
  "account.card.oauth.unlinked": "Відключено",
  "account.modal.unlink.title": "Відключити зв'язок з обліковим записом",
  "account.modal.unlink.description": "Відв'язка ваших соціальних акаунтів може призвести до втрати доступу до акаунту, якщо ви не пам'ятаєте свої облікові дані для входу",
  "account.notify.oauth.unlinked.success": "Відключення пройшло успішно",
  "account.card.security.title": "Безпека",
  "account.card.security.totp.enable.description": "Введіть ваш поточний пароль для початку увімкнення TOTP",
  "account.card.security.totp.disable.description": "Введіть ваш поточний пароль, щоб відключити TOTP",
  "account.card.security.totp.button.start": "Почати",
  "account.modal.totp.title": "Увімкнути TOTP",
  "account.modal.totp.step1": "Крок 1: Додайте свій аутентифікатор",
  "account.modal.totp.step2": "Крок 2: Перевірка коду",
  "account.modal.totp.enterManually": "Ввести вручну",
  "account.modal.totp.code": "Код",
  "common.button.clickToCopy": "Натисніть, щоб скопіювати",
  "account.modal.totp.verify": "Підтвердити",
  "account.notify.totp.disable": "TOTP успішно відключено",
  "account.notify.totp.enable": "TOTP успішно увімкнено",
  "account.card.language.title": "Мова",
  "account.card.language.description": "Проєкт перекладено спільнотою. Деякі мови можуть бути неповними.",
  "account.card.color.title": "Колірна схема",
  // ThemeSwitcher.tsx
  "account.theme.dark": "Темна",
  "account.theme.light": "Світла",
  "account.theme.system": "Системна",
  "account.button.delete": "Видалити акаунт",
  "account.modal.delete.title": "Видалити акаунт",
  "account.modal.delete.description": "Ви дійсно хочете видалити свій обліковий запис, включно з усіма вашими завантаженнями?",
  // END /account
  // /account/shares
  "account.shares.title": "Мої завантаження",
  "account.shares.title.empty": "Тут порожньо 👀",
  "account.shares.description.empty": "У вас немає завантажень.",
  "account.shares.button.create": "Створити одну",
  "account.shares.info.title": "Відомості",
  "account.shares.table.id": "ID",
  "account.shares.table.name": "Назва",
  "account.shares.table.description": "Опис",
  "account.shares.table.visitors": "Відвідувачів",
  "account.shares.table.expiresAt": "Діє до",
  "account.shares.table.createdAt": "Створено",
  "account.shares.table.size": "Розмір",
  "account.shares.table.password-protected": "Password protected",
  "account.shares.table.visitor-count": "{count} of {max}",
  "account.shares.table.expiry-never": "Ніколи",
  "account.shares.modal.share-informations": "Відомості",
  "account.shares.modal.share-link": "Поділитися посиланням",
  "account.shares.modal.delete.title": "Видалити завантаження: {share}",
  "account.shares.modal.delete.description": "Ви дійсно хочете видалити це завантаження?",
  // END /account/shares
  // /account/reverseShares
  "account.reverseShares.title": "Зворотні завантаження",
  "account.reverseShares.description": "Зворотне завантаження дає змогу генерувати унікальний URL, що дозволяє зовнішнім користувачам завантажувати файли.",
  "account.reverseShares.title.empty": "Тут порожньо 👀",
  "account.reverseShares.description.empty": "У вас поки що немає зворотних завантажень.",
  // showCreateReverseShareModal.tsx
  "account.reverseShares.modal.title": "Створити зворотне посилання на файл",
  "account.reverseShares.modal.expiration.label": "Закінчується",
  "account.reverseShares.modal.expiration.minute-singular": "Хвилина",
  "account.reverseShares.modal.expiration.minute-plural": "Хвилин(и)",
  "account.reverseShares.modal.expiration.hour-singular": "Година",
  "account.reverseShares.modal.expiration.hour-plural": "Годин",
  "account.reverseShares.modal.expiration.day-singular": "День",
  "account.reverseShares.modal.expiration.day-plural": "Днів",
  "account.reverseShares.modal.expiration.week-singular": "Тиждень",
  "account.reverseShares.modal.expiration.week-plural": "Тиждень",
  "account.reverseShares.modal.expiration.month-singular": "Місяць",
  "account.reverseShares.modal.expiration.month-plural": "Місяця(-ів)",
  "account.reverseShares.modal.expiration.year-singular": "Рік",
  "account.reverseShares.modal.expiration.year-plural": "Роки (роки)",
  "account.reverseShares.modal.max-size.label": "Макс. розмір завантаження",
  "account.reverseShares.modal.send-email": "Надсилати сповіщення ел. поштою",
  "account.reverseShares.modal.send-email.description": "Надсилає вам сповіщення на ел. пошту, коли створюється завантаження за цим зворотнім посиланням.",
  "account.reverseShares.modal.simplified": "Простий режим",
  "account.reverseShares.modal.simplified.description": "Полегште людині, яка завантажує файл, поділитися ним з вами. Вони зможуть лише налаштувати назву та опис завантаження.",
  "account.reverseShares.modal.public-access": "Публічний доступ",
  "account.reverseShares.modal.public-access.description": "Зробіть процес завантаження файлу легшим для користувача, який буде з вами ділитися. Вони зможуть налаштувати лише назву та опис завантаження.",
  "account.reverseShares.modal.max-use.label": "Максимум використань",
  "account.reverseShares.modal.max-use.description": "Максимальна кількість разів, коли URL може бути використаний для створення завантаження.",
  "account.reverseShare.never-expires": "Це зворотне завантаження ніколи не застаріє.",
  "account.reverseShare.expires-on": "Це зворотне завантаження застаріє {expiration}.",
  "account.reverseShares.table.no-shares": "Немає створених завантажень",
  "account.reverseShares.table.count.singular": "завантаження",
  "account.reverseShares.table.count.plural": "завантаження",
  "account.reverseShares.table.shares": "Завантаження",
  "account.reverseShares.table.remaining": "Залишилося використань",
  "account.reverseShares.table.max-size": "Макс. розмір завантаження",
  "account.reverseShares.table.expires": "Дійсно до",
  "account.reverseShares.modal.reverse-share-link": "Посилання зворотного завантаження",
  "account.reverseShares.modal.delete.title": "Видалити зворотне завантаження",
  "account.reverseShares.modal.delete.description": "Ви дійсно хочете видалити це зворотне завантаження? Якщо ви це зробите, то всі пов'язані зворотні завантаження будуть також видалені.",
  // END /account/reverseShares
  // /admin
  "admin.title": "Адміністрування",
  "admin.button.users": "Управління користувачами",
  "admin.button.shares": "Управління поширенням",
  "admin.button.config": "Конфігурація",
  "admin.version": "Версія",
  // END /admin
  // /admin/users
  "admin.users.title": "Управління користувачами",
  "admin.users.table.username": "Логін",
  "admin.users.table.email": "Електронна пошта",
  "admin.users.table.admin": "Адміністратор",
  "admin.users.edit.update.title": "Редагувати користувача: {username}",
  "admin.users.edit.update.admin-privileges": "Права адміністратора",
  "admin.users.edit.update.change-password.title": "Змінити пароль",
  "admin.users.edit.update.change-password.field": "Новий пароль",
  "admin.users.edit.update.change-password.button": "Зберегти новий пароль",
  "admin.users.edit.update.notify.password.success": "Пароль успішно змінено",
  "admin.users.edit.delete.title": "Видалити користувача: {username}?",
  "admin.users.edit.delete.description": "Ви дійсно хочете видалити цього користувача та всі його поширення?",
  // showCreateUserModal.tsx
  "admin.users.modal.create.title": "Створити користувача",
  "admin.users.modal.create.username": "Логін",
  "admin.users.modal.create.email": "Електронна пошта",
  "admin.users.modal.create.password": "Пароль",
  "admin.users.modal.create.manual-password": "Встановити пароль вручну",
  "admin.users.modal.create.manual-password.description": "Якщо прапорець не встановлено, користувач отримає лист із посиланням для встановлення пароля.",
  "admin.users.modal.create.admin": "Права адміністратора",
  "admin.users.modal.create.admin.description": "Якщо зазначено, користувач матиме доступ до панелі адміністратора.",
  // END /admin/users
  // /admin/shares
  "admin.shares.title": "Керування завантаженнями",
  "admin.shares.table.id": "ID Завантаження",
  "admin.shares.table.username": "Автор",
  "admin.shares.table.visitors": "Відвідувачі",
  "admin.shares.table.expires": "Діє до",
  "admin.shares.edit.delete.title": "Видалити завантаження: {id}",
  "admin.shares.edit.delete.description": "Ви дійсно хочете видалити це завантаження?",
  // END /admin/shares
  // /upload
  "upload.title": "Завантажити",
  "upload.notify.confirm-leave": "Ви впевнені, що хочете залишити цю сторінку? Ваше завантаження буде скасовано.",
  "upload.notify.generic-error": "Сталася помилка під час завершення вашого завантаження.",
  "upload.notify.count-failed": "Не вдалося завантажити файли {count}. Повтор спроби.",
  "upload.reverse-share.error.invalid.title": "Недійсне посилання на завантаження",
  "upload.reverse-share.error.invalid.description": "Зворотне завантаження вже закінчилося або недійсне.",
  // Dropzone.tsx
  "upload.dropzone.title": "Завантажити файли",
  "upload.dropzone.description": "Перетягніть файли сюди, щоб розпочати завантаження. Ми приймаємо лише файли до {maxSize} загалом.",
  "upload.dropzone.notify.file-too-big": "Ваші файли перевищують максимальний розмір у {maxSize}.",
  // FileList.tsx
  "upload.filelist.name": "Назва",
  "upload.filelist.size": "Розмір",
  // showCreateUploadModal.tsx
  "upload.modal.title": "Завантажити",
  "upload.modal.link.error.invalid": "Ім'я користувача повинно складатися тільки з букв, цифр, підкреслень і дефісів",
  "upload.modal.link.error.taken": "Це посилання вже використовується",
  "upload.modal.not-signed-in": "Ви не авторизовані",
  "upload.modal.not-signed-in-description": "Ви не зможете видалити свої файли вручну і переглянути кількість відвідувачів.",
  "upload.modal.expires.never": "ніколи",
  "upload.modal.expires.never-long": "Постійне завантаження",
  "upload.modal.expires.error.too-long": "Термін дії перевищує ліміт по {max}.",
  "upload.modal.link.label": "Посилання",
  "upload.modal.expires.label": "Закінчується",
  "upload.modal.expires.minute-singular": "Хвилина",
  "upload.modal.expires.minute-plural": "Хвилин(и)",
  "upload.modal.expires.hour-singular": "Година",
  "upload.modal.expires.hour-plural": "Годин",
  "upload.modal.expires.day-singular": "День",
  "upload.modal.expires.day-plural": "Днів",
  "upload.modal.expires.week-singular": "Тиждень",
  "upload.modal.expires.week-plural": "Тижнів",
  "upload.modal.expires.month-singular": "Місяць",
  "upload.modal.expires.month-plural": "Місяця(-ів)",
  "upload.modal.expires.year-singular": "Рік",
  "upload.modal.expires.year-plural": "Роки (роки)",
  "upload.modal.accordion.name-and-description.title": "Назва та опис",
  "upload.modal.accordion.name-and-description.name.placeholder": "Назва",
  "upload.modal.accordion.name-and-description.description.placeholder": "Примітка для отримувачів цього завантаження",
  "upload.modal.accordion.email.title": "Одержувачі листа",
  "upload.modal.accordion.email.placeholder": "Одержувачі e-mail",
  "upload.modal.accordion.email.invalid-email": "Неприпустима адреса електронної пошти",
  "upload.modal.accordion.security.title": "Параметри безпеки",
  "upload.modal.accordion.security.password.label": "Захист паролем",
  "upload.modal.accordion.security.password.placeholder": "Без пароля",
  "upload.modal.accordion.security.max-views.label": "Максимум переглядів",
  "upload.modal.accordion.security.max-views.placeholder": "Без обмеження",
  // showCompletedUploadModal.tsx
  "upload.modal.completed.never-expires": "Це завантаження ніколи не застаріє.",
  "upload.modal.completed.expires-on": "Це завантаження застаріє {expiration}.",
  "upload.modal.completed.share-ready": "Готово",
  "upload.modal.completed.notified-reverse-share-creator": "Ми сповістили створювача зворотного завантаження. Ви також можете вручну поділитися цим посиланням з ними іншим способом.",
  // END /upload
  // /share/[id]
  "share.title": "Завантаження {shareId}",
  "share.description": "Подивіться, чим я поділився з вами!",
  "share.error.visitor-limit-exceeded.title": "Перевищено ліміт відвідувачів",
  "share.error.visitor-limit-exceeded.description": "Перевищено ліміт відвідувачів.",
  "share.error.removed.title": "Завантаження видалено",
  "share.error.not-found.title": "Завантаження не знайдено",
  "share.error.not-found.description": "Сторінка, яку ви шукаєте, не існує.",
  "share.error.access-denied.title": "Приватне завантаження",
  "share.error.access-denied.description": "Поточний акаунт не має дозволу на доступ до цього завантаження",
  "share.modal.password.title": "Потрібен пароль",
  "share.modal.password.description": "Будь ласка, введіть пароль для доступу до цього завантаження.",
  "share.modal.password": "Пароль",
  "share.modal.error.invalid-password": "Невірний пароль",
  "share.button.download-all": "Завантажити все",
  "share.notify.download-all-preparing": "Завантаження готується. Будь ласка, спробуйте знову через кілька хвилин.",
  "share.modal.file-link": "Посилання на файл",
  "share.table.name": "Назва",
  "share.table.size": "Розмір",
  "share.modal.file-preview.error.not-supported.title": "Попередній перегляд не підтримується",
  "share.modal.file-preview.error.not-supported.description": "Попередні перегляди не підтримуються для цього типу файлів. Будь ласка, завантажте файл, щоб переглянути його.",
  // END /share/[id]
  // /share/[id]/edit
  "share.edit.title": "Редагувати {shareId}",
  "share.edit.append-upload": "Додати файл",
  "share.edit.notify.generic-error": "Сталася помилка під час завершення вашого завантаження.",
  "share.edit.notify.save-success": "Посилання на ресурс успішно оновлено",
  // END /share/[id]/edit
  // /imprint
  "imprint.title": "Imprint",
  // END /imprint
  // /privacy
  "privacy.title": "Privacy Policy",
  // END /privacy
  // /admin/config
  "admin.config.title": "Конфігурація",
  "admin.config.category.general": "Загальне",
  "admin.config.category.share": "Завантаження",
  "admin.config.category.email": "Електронна пошта",
  "admin.config.category.smtp": "SMTP",
  "admin.config.category.oauth": "Вхід через соцмережі",
  "admin.config.general.app-name": "Назва програми",
  "admin.config.general.app-name.description": "Видима назва додатка",
  "admin.config.general.app-url": "URL-адреса програми",
  "admin.config.general.app-url.description": "Адреса, на якій доступний Pingvin Share",
  "admin.config.general.secure-cookies": "Безпечні cookies",
  "admin.config.general.secure-cookies.description": "Чи встановлювати прапор безпеки для cookies. Якщо увімкнено, сайт не працюватиме при доступі через HTTP.",
  "admin.config.general.show-home-page": "Показувати домашню сторінку",
  "admin.config.general.show-home-page.description": "Показувати домашню сторінку чи ні",
  "admin.config.general.session-duration": "Тривалість сеансу",
  "admin.config.general.session-duration.description": "Час у годинах, після якого користувач повинен знову увійти в систему (за замовчуванням: 3 місяці).",
  "admin.config.general.logo": "Логотип",
  "admin.config.general.logo.description": "Змініть свій логотип, завантаживши нове зображення. Зображення має бути PNG і повинно мати формат 1:1.",
  "admin.config.general.logo.placeholder": "Виберіть зображення",
  "admin.config.email.enable-share-email-recipients": "Увімкнути спільний доступ для отримувачів через ел. пошту",
  "admin.config.email.enable-share-email-recipients.description": "Чи дозволяти спільний доступ через ел. пошту для отримувачів. Увімкніть це тільки, якщо SMTP активовано.",
  "admin.config.email.share-recipients-subject": "Заголовок листа (завантаження)",
  "admin.config.email.share-recipients-subject.description": "Тема листа, який надсилається одержувачам акції.",
  "admin.config.email.share-recipients-message": "Повідомлення листа завантаження",
  "admin.config.email.share-recipients-message.description": "Повідомлення, яке надсилається отримувачам спільного доступу. Доступні змінні:\n {creator} - Ім'я користувача, який створив спільний доступ \n {creatorEmail} - Ел. пошта користувача, який створив спільний доступ \n {shareUrl} - URL спільного доступу \n {desc} - Опис спільного доступу \n {expires} - Дата закінчення терміну дії спільного доступу \nЦі змінні будуть замінені на фактичні значення.",
  "admin.config.email.reverse-share-subject": "Заголовок листа (зворотне завантаження)",
  "admin.config.email.reverse-share-subject.description": "Тема надісланого електронного листа, коли хтось створює спільний доступ за вашим зворотнім посиланням.",
  "admin.config.email.reverse-share-message": "Повідомлення листа зворотного завантаження",
  "admin.config.email.reverse-share-message.description": "Повідомлення, яке надсилається, коли хтось створив завантаження з вашим зворотним посиланням. {shareUrl} буде замінено ім'ям творця та URL-адресою загального доступу.",
  "admin.config.email.reset-password-subject": "Тема скидання пароля",
  "admin.config.email.reset-password-subject.description": "Тема надісланого ел. листа, коли користувач запитує скидання пароля.",
  "admin.config.email.reset-password-message": "Повідомлення про скидання пароля",
  "admin.config.email.reset-password-message.description": "Повідомлення, яке надсилається при запиті скидання пароля. {url} буде замінено посиланням.",
  "admin.config.email.invite-subject": "Тема запрошення",
  "admin.config.email.invite-subject.description": "Тема надісланого ел. листа, коли адміністратор запрошує користувача.",
  "admin.config.email.invite-message": "Повідомлення із запрошенням",
  "admin.config.email.invite-message.description": "Повідомлення, яке надсилається, коли адміністратор запрошує користувача. {url} буде замінено на URL запрошення, {email} на ел. пошту, а {password} на пароль користувача.",
  "admin.config.share.allow-registration": "Дозволити реєстрацію",
  "admin.config.share.allow-registration.description": "Чи дозволена реєстрація",
  "admin.config.share.allow-unauthenticated-shares": "Дозволити неавторизовані завантаження",
  "admin.config.share.allow-unauthenticated-shares.description": "Чи можуть неавторизовані користувачі створювати завантаження",
  "admin.config.share.max-expiration": "Максимальний термін дії",
  "admin.config.share.max-expiration.description": "Maximum share expiration. Set to 0 to allow unlimited expiration.",
  "admin.config.share.share-id-length": "Стандартна довжина ID завантаження",
  "admin.config.share.share-id-length.description": "Стандартна довжина для згенерованого ID завантаження. Це значення також використовується для створення посилань для зворотних завантажень. Значення менше 8 не вважається безпечним.",
  "admin.config.share.max-size": "Максимальний розмір",
  "admin.config.share.max-size.description": "Максимальний розмір файлу",
  "admin.config.share.zip-compression-level": "Рівень стиснення Zip",
  "admin.config.share.zip-compression-level.description": "Регулювання рівня балансу між розміром файлу і швидкістю стиснення. Допустимі значення від 0 до 9, з 0 без стиснення, а 9 - максимальне стиснення. ",
  "admin.config.share.chunk-size": "Розмір блоку",
  "admin.config.share.chunk-size.description": "Налаштуйте розмір блоку для ваших завантажень, щоб збалансувати ефективність та надійність відповідно до вашого інтернет-з'єднання. Менші частини можуть підвищити ймовірність успішного завантаження для нестабільних з'єднань, тоді як більші частини прискорюють завантаження для стабільних з'єднань.",
  "admin.config.share.auto-open-share-modal": "Автоматично відкривати модальне вікно для завантаження",
  "admin.config.share.auto-open-share-modal.description": "Модальне вікно для створення завантаження автоматично з'являється, коли користувач вибирає файли, що усуває необхідність вручну натискати кнопку.",
  "admin.config.smtp.enabled": "Увімкнути",
  "admin.config.smtp.enabled.description": "Чи увімкнено SMTP. Встановіть значення true тільки якщо ви ввели хост, порт, email, користувач і пароль вашого SMTP-сервера.",
  "admin.config.smtp.host": "Хост",
  "admin.config.smtp.host.description": "Сервер SMTP-сервера",
  "admin.config.smtp.port": "Порт",
  "admin.config.smtp.port.description": "Порт SMTP сервера",
  "admin.config.smtp.email": "Електронна пошта",
  "admin.config.smtp.email.description": "Ел. пошта, з якої надсилаються листи",
  "admin.config.smtp.username": "Логін",
  "admin.config.smtp.username.description": "Ім'я користувача SMTP-сервера",
  "admin.config.smtp.password": "Пароль",
  "admin.config.smtp.password.description": "Пароль SMTP-сервера",
  "admin.config.smtp.button.test": "Відправити тестовий лист",
  "admin.config.smtp.allow-unauthorized-certificates": "Довіряти сертифікатам SMTP серверів без авторизації",
  "admin.config.smtp.allow-unauthorized-certificates.description": "Увімкніть це тільки тоді, якщо потрібно довіряти самопідписаним сертифікатам.",
  "admin.config.oauth.allow-registration": "Дозволити реєстрацію",
  "admin.config.oauth.allow-registration.description": "Дозволити користувачам реєструватися, використовуючи облікові записи соціальних мереж",
  "admin.config.oauth.ignore-totp": "Ігнорувати TOTP",
  "admin.config.oauth.ignore-totp.description": "Ігнорувати TOTP при використанні соціальної авторизації",
  "admin.config.oauth.disable-password": "Вимкнути вхід за паролем",
  "admin.config.oauth.disable-password.description": "Чи вимкнути вхід за паролем. \nПереконайтеся, що постачальник OAuth налаштований правильно, перед активацією цієї конфігурації, щоб уникнути блокування доступу.",
  "admin.config.oauth.github-enabled": "GitHub",
  "admin.config.oauth.github-enabled.description": "Чи ввімкнено логін на GitHub",
  "admin.config.oauth.github-client-id": "ID клієнта GitHub",
  "admin.config.oauth.github-client-id.description": "ID клієнта в додатку GitHub OAuth",
  "admin.config.oauth.github-client-secret": "Секретний ключ клієнта GitHub",
  "admin.config.oauth.github-client-secret.description": "Секретний ключ клієнта в додатку GitHub OAuth",
  "admin.config.oauth.google-enabled": "Google",
  "admin.config.oauth.google-enabled.description": "Чи увімкнено логін Google на GitHub",
  "admin.config.oauth.google-client-id": "ID клієнта Google",
  "admin.config.oauth.google-client-id.description": "ID клієнта в додатку Google OAuth",
  "admin.config.oauth.google-client-secret": "Секретний ключ клієнта Google",
  "admin.config.oauth.google-client-secret.description": "Секретний ключ клієнта в додатку Google OAuth",
  "admin.config.oauth.microsoft-enabled": "Microsoft",
  "admin.config.oauth.microsoft-enabled.description": "Чи ввімкнено логін Microsoft",
  "admin.config.oauth.microsoft-tenant": "Корпоративний акаунт Microsoft",
  "admin.config.oauth.microsoft-tenant.description": "Ідентифікатор орендаря додатка Microsoft OAuth\ncommon: Користувачі з особистим обліковим записом Microsoft і робочим або навчальним обліковим записом від Microsoft Entra ID можуть увійти в додаток. organizations: Тільки користувачі з робочим або навчальним обліковим записом від Microsoft Entra ID можуть увійти в застосунок.\nconsumers: Тільки користувачі з особистим обліковим записом Microsoft можуть увійти в застосунок.ім'я домену орендаря Microsoft Entra або ідентифікатор орендаря у форматі GUID: Тільки користувачі з певного орендаря Microsoft Entra (учасники каталогу з робочим або навчальним обліковим записом або гості каталогу з особистим обліковим записом Microsoft) можуть увійти в застосунок.",
  "admin.config.oauth.microsoft-client-id": "Ідентифікатор клієнта Microsoft",
  "admin.config.oauth.microsoft-client-id.description": "ID клієнта в додатку Microsoft OAuth",
  "admin.config.oauth.microsoft-client-secret": "Секретний ключ клієнта Microsoft",
  "admin.config.oauth.microsoft-client-secret.description": "Секретний ключ клієнта в додатку Microsoft OAuth",
  "admin.config.oauth.discord-enabled": "Discord",
  "admin.config.oauth.discord-enabled.description": "Чи увімкнено логін Discord",
  "admin.config.oauth.discord-limited-users": "Обмежені користувачі Discord",
  "admin.config.oauth.discord-limited-users.description": "Обмежити вхід для конкретних користувачів за їх Discord ID. Залиште поле порожнім, щоб вимкнути.",
  "admin.config.oauth.discord-limited-guild": "ID обмеженого сервера Discord",
  "admin.config.oauth.discord-limited-guild.description": "Обмеження входу для користувачів певного сервера. Залиште порожнім, щоб відключити.",
  "admin.config.oauth.discord-client-id": "ID клієнта Discord",
  "admin.config.oauth.discord-client-id.description": "ID клієнта в додатку Discord OAuth",
  "admin.config.oauth.discord-client-secret": "Секретний ключ клієнта Discord",
  "admin.config.oauth.discord-client-secret.description": "Секретний ключ клієнта в додатку Discord OAuth",
  "admin.config.oauth.oidc-enabled": "OpenID підключення",
  "admin.config.oauth.oidc-enabled.description": "Чи ввімкнено логін OpenID Connect",
  "admin.config.oauth.oidc-discovery-uri": "OpenID Connect Discovery URI",
  "admin.config.oauth.oidc-discovery-uri.description": "URI Discovery URI додатка OpenID Connect OAuth",
  "admin.config.oauth.oidc-sign-out": "Вийти з OpenID Connect",
  "admin.config.oauth.oidc-sign-out.description": "Чи буде кнопка \"Вийти\" виводити користувача з постачальника OpenID Connect",
  "admin.config.oauth.oidc-scope": "Область OpenID Connect",
  "admin.config.oauth.oidc-scope.description": "Області (scopes), які слід запитати у постачальника OpenID Connect.",
  "admin.config.oauth.oidc-username-claim": "Заява на ім'я користувача OpenID Connect",
  "admin.config.oauth.oidc-username-claim.description": "Заява про ім'я користувача в токені OpenID Connect ID. Залиште порожнім, якщо не знаєте, що це за конфіг.",
  "admin.config.oauth.oidc-role-path": "Шлях до ролей у токені OpenID Connect",
  "admin.config.oauth.oidc-role-path.description": "Повинен бути дійсним шляхом JMES, який посилається на масив ролей. " + "Управління правами доступу за допомогою ролей OpenID Connect рекомендується лише в тому випадку, якщо не налаштований інший постачальник ідентифікації та вхід за паролем вимкнено. " + "Залиште це поле порожнім, якщо ви не знаєте, для чого призначена ця конфігурація.",
  "admin.config.oauth.oidc-role-general-access": "Роль OpenID Connect для загального доступу",
  "admin.config.oauth.oidc-role-general-access.description": "Роль, необхідна для загального доступу. Має бути присутня в ролях користувача, щоб він міг увійти в систему. " + "Залиште це поле порожнім, якщо ви не знаєте, для чого призначена ця конфігурація.",
  "admin.config.oauth.oidc-role-admin-access": "Роль OpenID Connect для адміністративного доступу",
  "admin.config.oauth.oidc-role-admin-access.description": "Роль, необхідна для адміністративного доступу. Має бути присутня в ролях користувача, щоб він міг отримати доступ до адміністративної панелі. " + "Залиште це поле порожнім, якщо ви не знаєте, для чого призначена ця конфігурація.",
  "admin.config.oauth.oidc-client-id": "Client ID для OpenID Connect",
  "admin.config.oauth.oidc-client-id.description": "Клієнтський ідентифікатор додатка OpenID Connect OAuth",
  "admin.config.oauth.oidc-client-secret": "Секрет клієнта OpenID Connect",
  "admin.config.oauth.oidc-client-secret.description": "Клієнтський секрет програми OpenID Connect OAuth",
  "admin.config.category.ldap": "LDAP",
  "admin.config.ldap.enabled": "Увімкнути LDAP",
  "admin.config.ldap.enabled.description": "Використовувати LDAP автентифікацію для входу користувача",
  "admin.config.ldap.url": "URL сервера",
  "admin.config.ldap.url.description": "URL сервера LDAP",
  "admin.config.ldap.bind-dn": "Прив'язати DN",
  "admin.config.ldap.bind-dn.description": "Користувач за замовчуванням, який використовується для пошуку користувачів",
  "admin.config.ldap.bind-password": "Прив'язати пароль",
  "admin.config.ldap.bind-password.description": "Пароль, що використовується для пошуку користувача",
  "admin.config.ldap.search-base": "База користувачів",
  "admin.config.ldap.search-base.description": "Базове розташування, де буде виконано пошук користувача",
  "admin.config.ldap.search-query": "Запит користувача",
  "admin.config.ldap.search-query.description": "Запит користувача буде використовуватися для пошуку користувача LDAP в \"Базі користувачів\". %username% можна використовувати як заповнювач для введених користувачем даних.",
  "admin.config.ldap.admin-groups": "Адмін-група",
  "admin.config.ldap.admin-groups.description": "Група, необхідна для адміністративного доступу.",
  "admin.config.ldap.field-name-member-of": "Назва атрибута груп користувачів",
  "admin.config.ldap.field-name-member-of.description": "Назва атрибута LDAP для груп, до яких належить користувач. Це використовується при перевірці адміністративної групи.",
  "admin.config.ldap.field-name-email": "Назва атрибута ел. пошти користувача",
  "admin.config.ldap.field-name-email.description": "Назва атрибута LDAP для ел. пошти користувача.",
  "admin.config.notify.success": "Конфігурацію оновлено успішно.",
  "admin.config.notify.logo-success": "Логотип успішно оновлено. Це може зайняти кілька хвилин, щоб оновлення відобразилось на вебсайті.",
  "admin.config.notify.no-changes": "Змін не потрібно зберігати.",
  "admin.config.category.s3": "S3",
  "admin.config.s3.enabled": "Увімкнено",
  "admin.config.s3.enabled.description": "Чи S3 буде використовуватися для зберігання спільних файлів замість локальної файлової системи.",
  "admin.config.s3.endpoint": "Точка підключення",
  "admin.config.s3.endpoint.description": "URL сховища S3.",
  "admin.config.s3.region": "Область",
  "admin.config.s3.region.description": "Регион облачного хранилища S3.",
  "admin.config.s3.bucket-name": "Ім'я бакета",
  "admin.config.s3.bucket-name.description": "Назва S3 бакета.",
  "admin.config.s3.bucket-path": "Шлях",
  "admin.config.s3.bucket-path.description": "Шлях за замовчуванням, який має використовуватися для зберігання файлів у S3 бакеті.",
  "admin.config.s3.key": "Ключ",
  "admin.config.s3.key.description": "Ключ, який дозволяє отримати доступ до S3 бакету.",
  "admin.config.s3.secret": "Секрет",
  "admin.config.s3.secret.description": "Секрет, який дозволяє отримати доступ до S3 бакету.",
  "admin.config.category.legal": "Legal",
  "admin.config.legal.enabled": "Enable legal notices",
  "admin.config.legal.enabled.description": "Whether to show a link to imprint and privacy policy in the footer.",
  "admin.config.legal.imprint-text": "Imprint text",
  "admin.config.legal.imprint-text.description": "The text which should be shown in the imprint. Supports Markdown. Leave blank to link to an external imprint page.",
  "admin.config.legal.imprint-url": "Imprint URL",
  "admin.config.legal.imprint-url.description": "If you already have an imprint page you can link it here instead of using the text field.",
  "admin.config.legal.privacy-policy-text": "Privacy policy text",
  "admin.config.legal.privacy-policy-text.description": "The text which should be shown in the privacy policy. Supports Markdown. Leave blank to link to an external privacy policy page.",
  "admin.config.legal.privacy-policy-url": "Privacy policy URL",
  "admin.config.legal.privacy-policy-url.description": "If you already have a privacy policy page you can link it here instead of using the text field.",
  // 404
  "404.description": "Бляха, цієї строрінки не існує.",
  "404.button.home": "Поверни мене додому",
  // error
  "error.title": "Помилка",
  "error.description": "Щось пішло не так!",
  "error.button.back": "Назад",
  "error.msg.default": "Щось пішло не так.",
  "error.msg.access_denied": "Ви скасували процес аутентифікації, будь ласка, спробуйте ще раз.",
  "error.msg.expired_token": "Процес аутентифікації зайняв занадто багато часу, будь ласка, спробуйте ще раз.",
  "error.msg.invalid_token": "Внутрішня помилка",
  "error.msg.no_user": "Користувач, пов'язаний з обліковим записом {0}, не існує.",
  "error.msg.no_email": "Не вдається отримати адресу електронної пошти від облікового запису {0}.",
  "error.msg.already_linked": "Цей обліковий запис {0} уже прив'язано до іншого акаунта.",
  "error.msg.not_linked": "Цей акаунт {0} ще не пов'язаний з жодним акаунтом.",
  "error.msg.unverified_account": "Цей обліковий запис {0} не підтверджено, повторіть спробу після підтвердження.",
  "error.msg.user_not_allowed": "У вас немає дозволу на вхід.",
  "error.msg.cannot_get_user_info": "Неможливо отримати інформацію про користувача з цього акаунта {0}.",
  "error.param.provider_github": "GitHub",
  "error.param.provider_google": "Google",
  "error.param.provider_microsoft": "Microsoft",
  "error.param.provider_discord": "Discord",
  "error.param.provider_oidc": "OpenID підключення",
  // Common translations
  "common.button.save": "Зберегти",
  "common.button.create": "Створити",
  "common.button.submit": "Відправити",
  "common.button.delete": "Видалити",
  "common.button.cancel": "Скасувати",
  "common.button.confirm": "Підтвердити",
  "common.button.disable": "Відключити",
  "common.button.share": "Поділитися",
  "common.button.generate": "Згенерувати",
  "common.button.done": "Готово",
  "common.text.link": "Посилання",
  "common.text.navigate-to-link": "Відкрити посилання",
  "common.text.or": "або",
  "common.text.redirecting": "Перенаправлення...",
  "common.button.go-back": "Назад",
  "common.button.go-home": "Перейти додому",
  "common.notify.copied": "Ваше посилання скопійовано в буфер обміну",
  "common.notify.copied-link": "Ваше посилання скопійовано в буфер обміну",
  "common.success": "Успішно",
  "common.error": "Помилка",
  "common.error.unknown": "Сталася невідома помилка",
  "common.error.invalid-email": "Неприпустима адреса електронної пошти",
  "common.error.too-short": "Повинно бути не менше {length} символів",
  "common.error.too-long": "Повинно бути не більше {length} символів",
  "common.error.number-too-small": "Повинно бути щонайменше {min}",
  "common.error.number-too-large": "Повинно бути не більше ніж {max}",
  "common.error.exact-length": "Повинно бути рівно {length} символів",
  "common.error.invalid-number": "Повинно бути числом",
  "common.error.field-required": "Поле обов'язкове для заповнення"
};