export default {
  // Navbar
  "navbar.upload": "อัพโหลด",
  "navbar.signin": "เข้าสู่ระบบ",
  "navbar.home": "หน้าหลัก",
  "navbar.signup": "ลงทะเบียน",
  "navbar.links.shares": "แชร์ของฉัน",
  "navbar.links.reverse": "รีเวิร์สแชร์",
  "navbar.avatar.account": "บัญชีของฉัน",
  "navbar.avatar.admin": "แผงควบคุมระบบ",
  "navbar.avatar.signout": "ออกจากระบบ",
  // END navbar
  // /
  "home.title": "แพลตฟอร์มสำหรับแชร์ไฟล์ที่คุณสามารถโฮสต์ด้วยตนเอง.",
  "home.description": "คุณอยากให้บริษัทภายนอกเช่น WeTransfer เข้าถึงไฟล์ส่วนตัวของคุณหรือเปล่า?",
  "home.bullet.a.name": "Self-Hosted",
  "home.bullet.a.description": "โฮสต์ Pingvin Share บนเครื่องของคุณเอง.",
  "home.bullet.b.name": "ความเป็นส่วนตัว",
  "home.bullet.b.description": "Your files are yours and will never be accessed by third parties.",
  "home.bullet.c.name": "ไม่มีการจำกัดขนาดไฟล์ที่น่ารำคาญ",
  "home.bullet.c.description": "Upload files as big as you want. Only your hard drive will be your limit.",
  "home.button.start": "เริ่มต้น",
  "home.button.source": "ซอร์สโค้ด",
  // END /
  // /auth/signin
  "signin.title": "ยินดีต้อนรับกลับ",
  "signin.description": "ยังไม่มีบัญชี?",
  "signin.button.signup": "สมัครบัญชี",
  "signin.input.email-or-username": "อีเมลหรือชื่อผู้ใช้",
  "signin.input.email-or-username.placeholder": "อีเมลหรือชื่อผู้ใช้ของคุณ",
  "signin.input.password": "รหัสผ่าน",
  "signin.input.password.placeholder": "รหัสผ่านของคุณ",
  "signin.button.submit": "เข้าสู่ระบบ",
  "signIn.notify.totp-required.title": "ยืนยันตรวจสอบสิทธิ์สองปัจจัย",
  "signIn.notify.totp-required.description": "กรุณาใส่รหัสยืนยันตัวตนสองปัจจัย",
  "signIn.oauth.or": "OR",
  "signIn.oauth.signInWith": "Sign in with",
  "signIn.oauth.github": "GitHub",
  "signIn.oauth.google": "Google",
  "signIn.oauth.microsoft": "Microsoft",
  "signIn.oauth.discord": "Discord",
  "signIn.oauth.oidc": "OpenID",
  // END /auth/signin
  // /auth/signup
  "signup.title": "สมัครบัญชี",
  "signup.description": "มีบัญชีแล้ว?",
  "signup.button.signin": "เข้าสู่ระบบ",
  "signup.input.username": "ชื่อผู้ใช้",
  "signup.input.username.placeholder": "ชื่อผู้ใช้ของคุณ",
  "signup.input.email": "อีเมล",
  "signup.input.email.placeholder": "อีเมลของคุณ",
  "signup.button.submit": "เริ่มต้นกัน",
  // END /auth/signup
  // /auth/totp
  "totp.title": "TOTP Authentication",
  "totp.button.signIn": "Sign in",
  // END /auth/totp
  // /auth/reset-password
  "resetPassword.title": "ลืมรหัสผ่าน?",
  "resetPassword.description": "กรุณาใส่อีเมลของคุณเพื่อรีเซ็ตรหัสผ่าน",
  "resetPassword.notify.success": "A message with a link to reset your password has been sent if the provided email exists.",
  "resetPassword.button.back": "กลับไปที่หน้าลงชื่อเข้าใช้",
  "resetPassword.text.resetPassword": "รีเซ็ตรหัสผ่าน",
  "resetPassword.text.enterNewPassword": "ป้อนรหัสผ่านใหม่ของคุณ",
  "resetPassword.input.password": "รหัสผ่านใหม่",
  "resetPassword.notify.passwordReset": "Your password has been successfully reset.",
  // /account
  "account.title": "บัญชีของฉัน",
  "account.card.info.title": "ข้อมูลบัญชี",
  "account.card.info.username": "ชื่อผู้ใช้",
  "account.card.info.email": "อีเมล",
  "account.notify.info.success": "อัปเดตบัญชีเรียบร้อยแล้ว",
  "account.card.password.title": "รหัสผ่าน",
  "account.card.password.old": "รหัสผ่านเก่า",
  "account.card.password.new": "รหัสผ่านใหม่",
  "account.card.password.noPasswordSet": "You do not have a password set. To sign in using your email and password, you need to create a password.",
  "account.notify.password.success": "อัปเดตรหัสผ่านเรียบร้อยแล้ว",
  "account.card.oauth.title": "Social login",
  "account.card.oauth.github": "GitHub",
  "account.card.oauth.google": "Google",
  "account.card.oauth.microsoft": "Microsoft",
  "account.card.oauth.discord": "Discord",
  "account.card.oauth.oidc": "OpenID",
  "account.card.oauth.link": "Link",
  "account.card.oauth.unlink": "Unlink",
  "account.card.oauth.unlinked": "Unlinked",
  "account.modal.unlink.title": "Unlink account",
  "account.modal.unlink.description": "Unlinking your social accounts may cause you to lose your account if you don't remember your login credentials",
  "account.notify.oauth.unlinked.success": "Unlinked successfully",
  "account.card.security.title": "ความปลอดภัย",
  "account.card.security.totp.enable.description": "ใส่รหัสผ่านปัจจุบันของคุณเพื่อเริ่มต้นการเปิดใช้งาน TOTP",
  "account.card.security.totp.disable.description": "ใส่รหัสผ่านปัจจุบันของคุณเพื่อปิดใช้งาน TOTP",
  "account.card.security.totp.button.start": "เริ่มต้น",
  "account.modal.totp.title": "เปิดใช้งาน TOTP",
  "account.modal.totp.step1": "ขั้นตอนที่ 1: สแกนรหัส QR",
  "account.modal.totp.step2": "ขั้นตอนที่ 2: ป้อนรหัสยืนยันตัวตน",
  "account.modal.totp.enterManually": "ป้อนด้วยตนเอง",
  "account.modal.totp.code": "รหัส",
  "common.button.clickToCopy": "คลิกเพื่อคัดลอก",
  "account.modal.totp.verify": "ยืนยัน",
  "account.notify.totp.disable": "TOTP ถูกปิดใช้งานเรียบร้อยแล้ว",
  "account.notify.totp.enable": "TOTP ถูกเปิดใช้งานเรียบร้อยแล้ว",
  "account.card.language.title": "ภาษา",
  "account.card.language.description": "โปรเจคนี้ถูกแปลโดยชุมชน บางภาษาอาจยังไม่สมบูรณ์",
  "account.card.color.title": "ธีมสี",
  // ThemeSwitcher.tsx
  "account.theme.dark": "มืด",
  "account.theme.light": "สว่าง",
  "account.theme.system": "ตามระบบ",
  "account.button.delete": "ลบบัญชี",
  "account.modal.delete.title": "ลบบัญชีของคุณ",
  "account.modal.delete.description": "คุณต้องการลบบัญชีของคุณหรือไม่ รวมถึงแชร์ที่คุณสร้างไว้ทั้งหมด?",
  // END /account
  // /account/shares
  "account.shares.title": "แชร์ของฉัน",
  "account.shares.title.empty": "มันว่างเปล่าที่นี่ 👀",
  "account.shares.description.empty": "คุณยังไม่ได้สร้างแชร์ใดๆ",
  "account.shares.button.create": "สร้างแชร์",
  "account.shares.info.title": "ข้อมูลแชร์",
  "account.shares.table.id": "ID",
  "account.shares.table.name": "ชื่อ",
  "account.shares.table.description": "คำอธิบาย",
  "account.shares.table.visitors": "ผู้เข้าชม",
  "account.shares.table.expiresAt": "Expires on",
  "account.shares.table.createdAt": "Created on",
  "account.shares.table.size": "ขนาด",
  "account.shares.table.password-protected": "Password protected",
  "account.shares.table.visitor-count": "{count} of {max}",
  "account.shares.table.expiry-never": "Never",
  "account.shares.modal.share-informations": "ข้อมูลแชร์",
  "account.shares.modal.share-link": "แชร์ลิงค์",
  "account.shares.modal.delete.title": "Delete share: {share}",
  "account.shares.modal.delete.description": "คุณต้องการลบแชร์นี้หรือไม่?",
  // END /account/shares
  // /account/reverseShares
  "account.reverseShares.title": "รีเวิร์สแชร์ของฉัน",
  "account.reverseShares.description": "รีเวิร์สแชร์สร้างลิงค์สำหรับคนภายนอกเพื่อที่จะแชร์ไฟล์ให้คุณ",
  "account.reverseShares.title.empty": "มันว่างเปล่าที่นี่ 👀",
  "account.reverseShares.description.empty": "คุณยังไม่ได้สร้างรีเวิร์สแชร์ใดๆ",
  // showCreateReverseShareModal.tsx
  "account.reverseShares.modal.title": "Create reverse share",
  "account.reverseShares.modal.expiration.label": "ลิงค์หมดอายุใน",
  "account.reverseShares.modal.expiration.minute-singular": "นาที",
  "account.reverseShares.modal.expiration.minute-plural": "นาที",
  "account.reverseShares.modal.expiration.hour-singular": "ชั่วโมง",
  "account.reverseShares.modal.expiration.hour-plural": "ชั่วโมง",
  "account.reverseShares.modal.expiration.day-singular": "วัน",
  "account.reverseShares.modal.expiration.day-plural": "วัน",
  "account.reverseShares.modal.expiration.week-singular": "สัปดาห์",
  "account.reverseShares.modal.expiration.week-plural": "สัปดาห์",
  "account.reverseShares.modal.expiration.month-singular": "เดือน",
  "account.reverseShares.modal.expiration.month-plural": "เดือน",
  "account.reverseShares.modal.expiration.year-singular": "ปี",
  "account.reverseShares.modal.expiration.year-plural": "ปี",
  "account.reverseShares.modal.max-size.label": "ขนาดสูงสุดของแชร์",
  "account.reverseShares.modal.send-email": "Send email notifications",
  "account.reverseShares.modal.send-email.description": "Sends you an email notification when a share is created with this reverse share link.",
  "account.reverseShares.modal.simplified": "Simple mode",
  "account.reverseShares.modal.simplified.description": "Make it easy for the person uploading the file to share it with you. They will only be able to customize the name and description of the share.",
  "account.reverseShares.modal.public-access": "Public access",
  "account.reverseShares.modal.public-access.description": "Make the shares created with this reverse share public. If disabled, only you and the share creator will have access to view it.",
  "account.reverseShares.modal.max-use.label": "จำนวนการใช้งานสูงสุด",
  "account.reverseShares.modal.max-use.description": "จำนวนครั้งสูงสุดที่ลิงค์นี้สามารถใช้งานได้",
  "account.reverseShare.never-expires": "ลิงค์นี้ไม่มีวันหมดอายุ",
  "account.reverseShare.expires-on": "ลิงค์นี้จะหมดอายุใน {expiration}.",
  "account.reverseShares.table.no-shares": "ยังไม่มีการสร้างแชร์",
  "account.reverseShares.table.count.singular": "แชร์",
  "account.reverseShares.table.count.plural": "แชร์",
  "account.reverseShares.table.shares": "แชร์",
  "account.reverseShares.table.remaining": "เหลืออีก {count} ครั้ง",
  "account.reverseShares.table.max-size": "ขนาดสูงสุดของแชร์",
  "account.reverseShares.table.expires": "หมดอายุ",
  "account.reverseShares.modal.reverse-share-link": "ลิงค์รีเวิร์สแชร์",
  "account.reverseShares.modal.delete.title": "ลบลิงค์รีเวิร์สแชร์",
  "account.reverseShares.modal.delete.description": "คุณต้องการลบลิงค์รีเวิร์สแชร์นี้หรือไม่? หากคุณทำเช่นนั้นแชร์ที่เกี่ยวข้องจะถูกลบด้วย",
  // END /account/reverseShares
  // /admin
  "admin.title": "แผงควบคุมระบบ",
  "admin.button.users": "การจัดการผู้ใช้",
  "admin.button.shares": "Share management",
  "admin.button.config": "การตั้งค่า",
  "admin.version": "เวอร์ชัน",
  // END /admin
  // /admin/users
  "admin.users.title": "การจัดการผู้ใช้",
  "admin.users.table.username": "ชื่อผู้ใช้",
  "admin.users.table.email": "อีเมล",
  "admin.users.table.admin": "ผู้ดูแลระบบ",
  "admin.users.edit.update.title": "Edit user: {username}",
  "admin.users.edit.update.admin-privileges": "สิทธิ์ของผู้ดูแลระบบ",
  "admin.users.edit.update.change-password.title": "เปลี่ยนรหัสผ่าน",
  "admin.users.edit.update.change-password.field": "รหัสผ่านใหม่",
  "admin.users.edit.update.change-password.button": "บันทึกรหัสผ่านใหม่",
  "admin.users.edit.update.notify.password.success": "รหัสผ่านเปลี่ยนเรียบร้อยแล้ว",
  "admin.users.edit.delete.title": "Delete user: {username} ?",
  "admin.users.edit.delete.description": "Do you really want to delete this user and all their shares?",
  // showCreateUserModal.tsx
  "admin.users.modal.create.title": "สร้างผู้ใช้",
  "admin.users.modal.create.username": "ชื่อผู้ใช้",
  "admin.users.modal.create.email": "อีเมล",
  "admin.users.modal.create.password": "รหัสผ่าน",
  "admin.users.modal.create.manual-password": "ตั้งรหัสผ่านด้วยตนเอง",
  "admin.users.modal.create.manual-password.description": "หากไม่ติ๊กเลือก ผู้ใช้จะได้รับอีเมลพร้อมลิงก์เพื่อตั้งรหัสผ่านด้วยตนเอง",
  "admin.users.modal.create.admin": "สิทธิ์ของผู้ดูแลระบบ",
  "admin.users.modal.create.admin.description": "หากติ๊กเลือก ผู้ใช้จะสามารถเข้าถึงแผงควบคุมระบบได้",
  // END /admin/users
  // /admin/shares
  "admin.shares.title": "Share management",
  "admin.shares.table.id": "Share ID",
  "admin.shares.table.username": "Creator",
  "admin.shares.table.visitors": "Visitors",
  "admin.shares.table.expires": "Expires on",
  "admin.shares.edit.delete.title": "Delete share: {id}",
  "admin.shares.edit.delete.description": "Do you really want to delete this share?",
  // END /admin/shares
  // /upload
  "upload.title": "อัปโหลด",
  "upload.notify.confirm-leave": "Are you sure you want to leave this page? Your upload will be canceled.",
  "upload.notify.generic-error": "เกิดข้อผิดพลาดขณะที่กำลังจัดการการแชร์ของคุณ",
  "upload.notify.count-failed": "มีไฟล์จำนวน {count} ไฟล์ที่ไม่สามารถอัปโหลดได้ กำลังลองอีกครั้ง",
  "upload.reverse-share.error.invalid.title": "Invalid reverse share link",
  "upload.reverse-share.error.invalid.description": "This reverse share has expired or is invalid.",
  // Dropzone.tsx
  "upload.dropzone.title": "อัปโหลดไฟล์",
  "upload.dropzone.description": "Drag'n'drop files here to start your share. We only accept files up to {maxSize} in total.",
  "upload.dropzone.notify.file-too-big": "ไฟล์ของคุณเกินขนาดสูงสุดของการแชร์ {maxSize}",
  // FileList.tsx
  "upload.filelist.name": "ชื่อ",
  "upload.filelist.size": "ขนาด",
  // showCreateUploadModal.tsx
  "upload.modal.title": "สร้างการแชร์",
  "upload.modal.link.error.invalid": "สามารถใช้ได้เฉพาะตัวอักษร ตัวเลข ขีดล่าง และขีดเส้น",
  "upload.modal.link.error.taken": "ลิงก์นี้ถูกใช้งานแล้ว",
  "upload.modal.not-signed-in": "คุณยังไม่ได้เข้าสู่ระบบ",
  "upload.modal.not-signed-in-description": "คุณจะไม่สามารถลบการแชร์ของคุณด้วยตนเองและดูจำนวนผู้เข้าชมได้",
  "upload.modal.expires.never": "ไม่มีกำหนด",
  "upload.modal.expires.never-long": "Permanent share",
  "upload.modal.expires.error.too-long": "Expiration date exceeds the maximum of {max}.",
  "upload.modal.link.label": "ลิงค์",
  "upload.modal.expires.label": "หมดอายุ",
  "upload.modal.expires.minute-singular": "นาที",
  "upload.modal.expires.minute-plural": "นาที",
  "upload.modal.expires.hour-singular": "ชั่วโมง",
  "upload.modal.expires.hour-plural": "ชั่วโมง",
  "upload.modal.expires.day-singular": "วัน",
  "upload.modal.expires.day-plural": "วัน",
  "upload.modal.expires.week-singular": "สัปดาห์",
  "upload.modal.expires.week-plural": "สัปดาห์",
  "upload.modal.expires.month-singular": "เดือน",
  "upload.modal.expires.month-plural": "เดือน",
  "upload.modal.expires.year-singular": "ปี",
  "upload.modal.expires.year-plural": "ปี",
  "upload.modal.accordion.name-and-description.title": "Name and description",
  "upload.modal.accordion.name-and-description.name.placeholder": "Name",
  "upload.modal.accordion.name-and-description.description.placeholder": "Note for the recipients of this share",
  "upload.modal.accordion.email.title": "ผู้รับอีเมล",
  "upload.modal.accordion.email.placeholder": "ป้อนผู้รับอีเมล",
  "upload.modal.accordion.email.invalid-email": "ที่อยู่อีเมลไม่ถูกต้อง",
  "upload.modal.accordion.security.title": "ตัวเลือกความปลอดภัย",
  "upload.modal.accordion.security.password.label": "การป้องกันรหัสผ่าน",
  "upload.modal.accordion.security.password.placeholder": "ไม่มีรหัสผ่าน",
  "upload.modal.accordion.security.max-views.label": "จำนวนการเข้าชมสูงสุด",
  "upload.modal.accordion.security.max-views.placeholder": "ไม่จำกัด",
  // showCompletedUploadModal.tsx
  "upload.modal.completed.never-expires": "การแชร์นี้จะไม่มีวันหมดอายุ",
  "upload.modal.completed.expires-on": "การแชร์นี้จะหมดอายุเมื่อวันที่ {expiration}",
  "upload.modal.completed.share-ready": "แชร์พร้อมใช้งาน",
  "upload.modal.completed.notified-reverse-share-creator": "We have notified the creator of the reverse share. You can also manually share this link with them through other means.",
  // END /upload
  // /share/[id]
  "share.title": "แชร์ {shareId}",
  "share.description": "ดูสิ่งที่ฉันแชร์กับคุณ!",
  "share.error.visitor-limit-exceeded.title": "เกินขีดจำกัดผู้เข้าชม",
  "share.error.visitor-limit-exceeded.description": "การแชร์นี้ได้เกินขีดจำกัดผู้เข้าชมแล้ว",
  "share.error.removed.title": "การแชร์ถูกลบ",
  "share.error.not-found.title": "ไม่พบการแชร์นี้",
  "share.error.not-found.description": "การแชร์ที่คุณกำลังมองหาไม่มีอยู่จริง",
  "share.error.access-denied.title": "Private share",
  "share.error.access-denied.description": "The current account does not have permission to access this share",
  "share.modal.password.title": "ต้องการรหัสผ่าน",
  "share.modal.password.description": "Please enter the password to acces this share.",
  "share.modal.password": "รหัสผ่าน",
  "share.modal.error.invalid-password": "รหัสผ่านไม่ถูกต้อง",
  "share.button.download-all": "ดาวน์โหลดทั้งหมด",
  "share.notify.download-all-preparing": "The share is being prepared. Please try again in a few minutes.",
  "share.modal.file-link": "ลิงค์ไฟล์",
  "share.table.name": "ชื่อ",
  "share.table.size": "ขนาด",
  "share.modal.file-preview.error.not-supported.title": "ไม่รองรับการแสดงตัวอย่าง",
  "share.modal.file-preview.error.not-supported.description": "Previews are not supported for this type of files. Please download the file to view it.",
  // END /share/[id]
  // /share/[id]/edit
  "share.edit.title": "Edit {shareId}",
  "share.edit.append-upload": "Append file",
  "share.edit.notify.generic-error": "An error occurred while finishing your share.",
  "share.edit.notify.save-success": "Share updated successfully",
  // END /share/[id]/edit
  // /imprint
  "imprint.title": "Imprint",
  // END /imprint
  // /privacy
  "privacy.title": "Privacy Policy",
  // END /privacy
  // /admin/config
  "admin.config.title": "การตั้งค่า",
  "admin.config.category.general": "ทั่วไป",
  "admin.config.category.share": "การแชร์",
  "admin.config.category.email": "อีเมล",
  "admin.config.category.smtp": "SMTP",
  "admin.config.category.oauth": "Social Login",
  "admin.config.general.app-name": "ชื่อแอพ",
  "admin.config.general.app-name.description": "ชื่อแอพพลิเคชัน",
  "admin.config.general.app-url": "URL ของแอพ",
  "admin.config.general.app-url.description": "URL ที่สามารถเข้าถึงแอพพลิเคชัน Pingvin Share ได้",
  "admin.config.general.secure-cookies": "Secure cookies",
  "admin.config.general.secure-cookies.description": "Whether to set the secure flag on cookies. If enabled, the site will not function when accessed over HTTP.",
  "admin.config.general.show-home-page": "แสดงหน้าแรก",
  "admin.config.general.show-home-page.description": "หากติ๊ก เว็บไซต์จะแสดงหน้าหลักเวลาเข้าถึง URL หลัก",
  "admin.config.general.session-duration": "Session Duration",
  "admin.config.general.session-duration.description": "Time in hours after which a user must log in again (default: 3 months).",
  "admin.config.general.logo": "โลโก้",
  "admin.config.general.logo.description": "เปลี่ยนโลโก้โดยอัปโหลดรูปภาพใหม่ รูปภาพต้องเป็น PNG และควรมีขนาดอัตราส่วน 1:1",
  "admin.config.general.logo.placeholder": "คลิกที่นี่หรือลากไฟล์มา",
  "admin.config.email.enable-share-email-recipients": "Enable email recipient sharing",
  "admin.config.email.enable-share-email-recipients.description": "Whether to allow email sharing with recipients. Only enable this if SMTP is activated.",
  "admin.config.email.share-recipients-subject": "หัวเรื่องผู้รับอีเมลของการแชร์",
  "admin.config.email.share-recipients-subject.description": "หัวเรื่องของอีเมลที่ส่งไปยังผู้รับอีเมลของการแชร์",
  "admin.config.email.share-recipients-message": "ข้อความผู้รับอีเมลของการแชร์",
  "admin.config.email.share-recipients-message.description": "Message which gets sent to the share recipients. Available variables:\n {creator} - The username of the creator of the share\n {creatorEmail} - The email of the creator of the share\n {shareUrl} - The URL of the share\n {desc} - The description of the share\n {expires} - The expiration date of the share\n These variables will be replaced with the actual value.",
  "admin.config.email.reverse-share-subject": "หัวเรื่องการแชร์รีเวิร์ส",
  "admin.config.email.reverse-share-subject.description": "Subject of the sent email when someone created a share with your reverse share link.",
  "admin.config.email.reverse-share-message": "ข้อความการแชร์รีเวิร์ส",
  "admin.config.email.reverse-share-message.description": "ข้อความที่ส่งไปยังผู้สร้างการแชร์รีเวิร์ส ตัวแปรที่ใช้ได้:\n {shareUrl} - ชื่อผู้สร้างแชร์รีเวิร์สและ URL ของการแชร์\n ตัวแปรจะถูกแทนที่ด้วยค่าจริง",
  "admin.config.email.reset-password-subject": "หัวเรื่องการรีเซ็ตรหัสผ่าน",
  "admin.config.email.reset-password-subject.description": "Subject of the sent email when a user requests a password reset.",
  "admin.config.email.reset-password-message": "ข้อความการรีเซ็ตรหัสผ่าน",
  "admin.config.email.reset-password-message.description": "ข้อความที่ส่งไปยังผู้ใช้เมื่อขอรีเซ็ตรหัสผ่าน ตัวแปรที่ใช้ได้:\n {url} - URL สำหรับรีเซ็ตรหัสผ่าน\n ตัวแปรจะถูกแทนที่ด้วยค่าจริง",
  "admin.config.email.invite-subject": "หัวเรื่องการเชิญ",
  "admin.config.email.invite-subject.description": "Subject of the sent email when an admin invites a user.",
  "admin.config.email.invite-message": "ข้อความการเชิญ",
  "admin.config.email.invite-message.description": "Message which gets sent when an admin invites a user. {url} will be replaced with the invite URL, {email} with the email and {password} with the users password.",
  "admin.config.share.allow-registration": "อนุญาตให้ลงทะเบียนด้วยตัวเอง",
  "admin.config.share.allow-registration.description": "อนุญาตให้ผู้ใช้ลงทะเบียนด้วยตัวเองเพื่อสร้างแชร์",
  "admin.config.share.allow-unauthenticated-shares": "อนุญาตให้แชร์โดยไม่ต้องเข้าสู่ระบบ",
  "admin.config.share.allow-unauthenticated-shares.description": "อนุญาตให้ผู้ใช้ที่ไม่ได้เข้าสู่ระบบสร้างแชร์",
  "admin.config.share.max-expiration": "Max expiration",
  "admin.config.share.max-expiration.description": "Maximum share expiration. Set to 0 to allow unlimited expiration.",
  "admin.config.share.share-id-length": "Default share ID length",
  "admin.config.share.share-id-length.description": "Default length for the generated ID of a share. This value is also used to generate links for reverse shares. A value below 8 is not considered secure.",
  "admin.config.share.max-size": "ขนาดสูงสุด",
  "admin.config.share.max-size.description": "ขนาดสูงสุดของแชร์",
  "admin.config.share.zip-compression-level": "ระดับการบีบอัดไฟล์ Zip",
  "admin.config.share.zip-compression-level.description": "ปรับระดับเพื่อปรับความสมดุลระหว่างขนาดไฟล์และความเร็วในการบีบอัด ค่าอยู่ระหว่าง 0-9 โดย 0 คือไม่มีการบีบอัดและ 9 คือการบีบอัดสูงสุด",
  "admin.config.share.chunk-size": "Chunk size",
  "admin.config.share.chunk-size.description": "Adjust the chunk size for your uploads to balance efficiency and reliability according to your internet connection. Smaller chunks can enhance success rates for unstable connections, while larger chunks make uploads faster for stable connections.",
  "admin.config.share.auto-open-share-modal": "Auto open create share modal",
  "admin.config.share.auto-open-share-modal.description": "The share creation modal automatically appears when a user selects files, eliminating the need to manually click the button.",
  "admin.config.smtp.enabled": "Enable",
  "admin.config.smtp.enabled.description": "เปิดใช้งาน SMTP สำหรับการส่งอีเมล เปิดได้เท่านั้นต่อเมื่อคุณใส่ข้อมูลโฮสต์ พอร์ต อีเมล ผู้ใช้ และรหัสผ่านของเซิร์ฟเวอร์ SMTP ของค",
  "admin.config.smtp.host": "โฮสต์",
  "admin.config.smtp.host.description": "โฮสต์ของเซิร์ฟเวอร์ SMTP",
  "admin.config.smtp.port": "พอร์ต",
  "admin.config.smtp.port.description": "พอร์ตของเซิร์ฟเวอร์ SMTP",
  "admin.config.smtp.email": "อีเมล",
  "admin.config.smtp.email.description": "Email address from wich the emails get sent",
  "admin.config.smtp.username": "ชื่อผู้ใช้",
  "admin.config.smtp.username.description": "ชื่อผู้ใช้ของเซิร์ฟเวอร์ SMTP",
  "admin.config.smtp.password": "รหัสผ่าน",
  "admin.config.smtp.password.description": "รหัสผ่านของเซิร์ฟเวอร์ SMTP",
  "admin.config.smtp.button.test": "ส่งอีเมล์์์์์์ทดสอบ",
  "admin.config.smtp.allow-unauthorized-certificates": "Trust unauthorized SMTP server certificates",
  "admin.config.smtp.allow-unauthorized-certificates.description": "Only set this to true if you need to trust self signed certificates.",
  "admin.config.oauth.allow-registration": "Allow registration",
  "admin.config.oauth.allow-registration.description": "Allow users to register via social login",
  "admin.config.oauth.ignore-totp": "Ignore TOTP",
  "admin.config.oauth.ignore-totp.description": "Whether to ignore TOTP when user using social login",
  "admin.config.oauth.disable-password": "Disable password login",
  "admin.config.oauth.disable-password.description": "Whether to disable password login\nMake sure that an OAuth provider is properly configured before activating this configuration to avoid being locked out.",
  "admin.config.oauth.github-enabled": "GitHub",
  "admin.config.oauth.github-enabled.description": "Whether GitHub login is enabled",
  "admin.config.oauth.github-client-id": "GitHub Client ID",
  "admin.config.oauth.github-client-id.description": "Client ID of the GitHub OAuth app",
  "admin.config.oauth.github-client-secret": "GitHub Client secret",
  "admin.config.oauth.github-client-secret.description": "Client secret of the GitHub OAuth app",
  "admin.config.oauth.google-enabled": "Google",
  "admin.config.oauth.google-enabled.description": "Whether Google login is enabled",
  "admin.config.oauth.google-client-id": "Google Client ID",
  "admin.config.oauth.google-client-id.description": "Client ID of the Google OAuth app",
  "admin.config.oauth.google-client-secret": "Google Client secret",
  "admin.config.oauth.google-client-secret.description": "Client secret of the Google OAuth app",
  "admin.config.oauth.microsoft-enabled": "Microsoft",
  "admin.config.oauth.microsoft-enabled.description": "Whether Microsoft login is enabled",
  "admin.config.oauth.microsoft-tenant": "Microsoft Tenant",
  "admin.config.oauth.microsoft-tenant.description": "Tenant ID of the Microsoft OAuth app\ncommon: Users with both a personal Microsoft account and a work or school account from Microsoft Entra ID can sign in to the application. organizations: Only users with work or school accounts from Microsoft Entra ID can sign in to the application.\nconsumers: Only users with a personal Microsoft account can sign in to the application.\ndomain name of the Microsoft Entra tenant or the tenant ID in GUID format: Only users from a specific Microsoft Entra tenant (directory members with a work or school account or directory guests with a personal Microsoft account) can sign in to the application.",
  "admin.config.oauth.microsoft-client-id": "Microsoft Client ID",
  "admin.config.oauth.microsoft-client-id.description": "Client ID of the Microsoft OAuth app",
  "admin.config.oauth.microsoft-client-secret": "Microsoft Client secret",
  "admin.config.oauth.microsoft-client-secret.description": "Client secret of the Microsoft OAuth app",
  "admin.config.oauth.discord-enabled": "Discord",
  "admin.config.oauth.discord-enabled.description": "Whether Discord login is enabled",
  "admin.config.oauth.discord-limited-users": "Discord limited users",
  "admin.config.oauth.discord-limited-users.description": "Limit signing in to specific users by their Discord ID. Leave it blank to disable.",
  "admin.config.oauth.discord-limited-guild": "Discord limited server ID",
  "admin.config.oauth.discord-limited-guild.description": "Limit signing in to users in a specific server. Leave it blank to disable.",
  "admin.config.oauth.discord-client-id": "Discord Client ID",
  "admin.config.oauth.discord-client-id.description": "Client ID of the Discord OAuth app",
  "admin.config.oauth.discord-client-secret": "Discord Client secret",
  "admin.config.oauth.discord-client-secret.description": "Client secret of the Discord OAuth app",
  "admin.config.oauth.oidc-enabled": "OpenID Connect",
  "admin.config.oauth.oidc-enabled.description": "Whether OpenID Connect login is enabled",
  "admin.config.oauth.oidc-discovery-uri": "OpenID Connect Discovery URI",
  "admin.config.oauth.oidc-discovery-uri.description": "Discovery URI of the OpenID Connect OAuth app",
  "admin.config.oauth.oidc-sign-out": "Sign out from OpenID Connect",
  "admin.config.oauth.oidc-sign-out.description": "Whether the “Sign out” button will sign out from the OpenID Connect provider",
  "admin.config.oauth.oidc-scope": "OpenID Connect scope",
  "admin.config.oauth.oidc-scope.description": "Scopes which should be requested from the OpenID Connect provider.",
  "admin.config.oauth.oidc-username-claim": "OpenID Connect username claim",
  "admin.config.oauth.oidc-username-claim.description": "Username claim in OpenID Connect ID token. Leave it blank if you don't know what this config is.",
  "admin.config.oauth.oidc-role-path": "Path to roles in OpenID Connect token",
  "admin.config.oauth.oidc-role-path.description": "Must be a valid JMES path referencing an array of roles. " + "Managing access rights using OpenID Connect roles is only recommended if no other identity provider is configured and password login is disabled. " + "Leave it blank if you don't know what this config is.",
  "admin.config.oauth.oidc-role-general-access": "OpenID Connect role for general access",
  "admin.config.oauth.oidc-role-general-access.description": "Role required for general access. Must be present in a user’s roles for them to log in. " + "Leave it blank if you don't know what this config is.",
  "admin.config.oauth.oidc-role-admin-access": "OpenID Connect role for admin access",
  "admin.config.oauth.oidc-role-admin-access.description": "Role required for administrative access. Must be present in a user’s roles for them to access the admin panel. " + "Leave it blank if you don't know what this config is.",
  "admin.config.oauth.oidc-client-id": "OpenID Connect Client ID",
  "admin.config.oauth.oidc-client-id.description": "Client ID of the OpenID Connect OAuth app",
  "admin.config.oauth.oidc-client-secret": "OpenID Connect Client secret",
  "admin.config.oauth.oidc-client-secret.description": "Client secret of the OpenID Connect OAuth app",
  "admin.config.category.ldap": "LDAP",
  "admin.config.ldap.enabled": "Enable LDAP",
  "admin.config.ldap.enabled.description": "Use LDAP authentication for user login",
  "admin.config.ldap.url": "Server URL",
  "admin.config.ldap.url.description": "URL of the LDAP server",
  "admin.config.ldap.bind-dn": "Bind DN",
  "admin.config.ldap.bind-dn.description": "Default user used to perform the user search",
  "admin.config.ldap.bind-password": "Bind password",
  "admin.config.ldap.bind-password.description": "Password used to perform the user search",
  "admin.config.ldap.search-base": "User base",
  "admin.config.ldap.search-base.description": "Base location, where the user search will be performed",
  "admin.config.ldap.search-query": "User query",
  "admin.config.ldap.search-query.description": "The user query will be used to search the 'User base' for the LDAP user. %username% can be used as the placeholder for the user given input.",
  "admin.config.ldap.admin-groups": "Admin group",
  "admin.config.ldap.admin-groups.description": "Group required for administrative access.",
  "admin.config.ldap.field-name-member-of": "User groups attribute name",
  "admin.config.ldap.field-name-member-of.description": "LDAP attribute name for the groups, an user is a member of. This is used when checking for the admin group.",
  "admin.config.ldap.field-name-email": "User email attribute name",
  "admin.config.ldap.field-name-email.description": "LDAP attribute name for the email of an user.",
  "admin.config.notify.success": "Configuration updated successfully.",
  "admin.config.notify.logo-success": "Logo updated successfully. It may take a few minutes to update on the website.",
  "admin.config.notify.no-changes": "No changes to save.",
  "admin.config.category.s3": "S3",
  "admin.config.s3.enabled": "Enabled",
  "admin.config.s3.enabled.description": "Whether S3 should be used to store the shared files instead of the local file system.",
  "admin.config.s3.endpoint": "Endpoint",
  "admin.config.s3.endpoint.description": "The URL of the S3 bucket.",
  "admin.config.s3.region": "Region",
  "admin.config.s3.region.description": "The region of the S3 bucket.",
  "admin.config.s3.bucket-name": "Bucket name",
  "admin.config.s3.bucket-name.description": "The name of the S3 bucket.",
  "admin.config.s3.bucket-path": "Path",
  "admin.config.s3.bucket-path.description": "The default path which should be used to store the files in the S3 bucket.",
  "admin.config.s3.key": "Key",
  "admin.config.s3.key.description": "The key which allows you to access the S3 bucket.",
  "admin.config.s3.secret": "Secret",
  "admin.config.s3.secret.description": "The secret which allows you to access the S3 bucket.",
  "admin.config.category.legal": "Legal",
  "admin.config.legal.enabled": "Enable legal notices",
  "admin.config.legal.enabled.description": "Whether to show a link to imprint and privacy policy in the footer.",
  "admin.config.legal.imprint-text": "Imprint text",
  "admin.config.legal.imprint-text.description": "The text which should be shown in the imprint. Supports Markdown. Leave blank to link to an external imprint page.",
  "admin.config.legal.imprint-url": "Imprint URL",
  "admin.config.legal.imprint-url.description": "If you already have an imprint page you can link it here instead of using the text field.",
  "admin.config.legal.privacy-policy-text": "Privacy policy text",
  "admin.config.legal.privacy-policy-text.description": "The text which should be shown in the privacy policy. Supports Markdown. Leave blank to link to an external privacy policy page.",
  "admin.config.legal.privacy-policy-url": "Privacy policy URL",
  "admin.config.legal.privacy-policy-url.description": "If you already have a privacy policy page you can link it here instead of using the text field.",
  // 404
  "404.description": "ไม่พบหน้าที่คุณกำลังมองหา",
  "404.button.home": "หน้าแรก",
  // error
  "error.title": "Error",
  "error.description": "Oops!",
  "error.button.back": "Go back",
  "error.msg.default": "Something went wrong.",
  "error.msg.access_denied": "You canceled the authentication process, please try again.",
  "error.msg.expired_token": "The authentication process took too long, please try again.",
  "error.msg.invalid_token": "Internal Error",
  "error.msg.no_user": "User linked to this {0} account doesn't exist.",
  "error.msg.no_email": "Can't get email address from this {0} account.",
  "error.msg.already_linked": "This {0} account is already linked to another account.",
  "error.msg.not_linked": "This {0} account hasn't been linked to any account yet.",
  "error.msg.unverified_account": "This {0} account is unverified, please try again after verification.",
  "error.msg.user_not_allowed": "You are not allowed to sign in.",
  "error.msg.cannot_get_user_info": "Cannot get your user info from this {0} account.",
  "error.param.provider_github": "GitHub",
  "error.param.provider_google": "Google",
  "error.param.provider_microsoft": "Microsoft",
  "error.param.provider_discord": "Discord",
  "error.param.provider_oidc": "OpenID Connect",
  // Common translations
  "common.button.save": "บันทึก",
  "common.button.create": "สร้าง",
  "common.button.submit": "ส่ง",
  "common.button.delete": "ลบ",
  "common.button.cancel": "ยกเลิก",
  "common.button.confirm": "ยืนยัน",
  "common.button.disable": "ปิดการใช้งาน",
  "common.button.share": "แชร์",
  "common.button.generate": "สุ่ม",
  "common.button.done": "เสร็จสิ้น",
  "common.text.link": "ลิงค์",
  "common.text.navigate-to-link": "Visit link",
  "common.text.or": "หรือ",
  "common.text.redirecting": "Redirecting...",
  "common.button.go-back": "ย้อนกลับ",
  "common.button.go-home": "Go home",
  "common.notify.copied": "คัดลอกไปยังคลิปบอร์ดแล้ว",
  "common.notify.copied-link": "คัดลอกไปยังคลิปบอร์ดแล้ว",
  "common.success": "สำเร็จ",
  "common.error": "เกิดข้อผิดพลาด",
  "common.error.unknown": "เกิดข้อผิดพลาดที่ไม่รู้จัก",
  "common.error.invalid-email": "ที่อยู่อีเมล์ไม่ถูกต้อง",
  "common.error.too-short": "ต้องมีอย่างน้อย {length} ตัวอักษร",
  "common.error.too-long": "ต้องมีไม่เกิน {length} ตัวอักษร",
  "common.error.number-too-small": "Must be at least {min}",
  "common.error.number-too-large": "Must be at most {max}",
  "common.error.exact-length": "ต้องมีความยาว {length} ตัวอักษร",
  "common.error.invalid-number": "ต้องเป็นตัวเลข",
  "common.error.field-required": "ต้องกรอกข้อมูลนี้"
};