export default {
  // Navbar
  "navbar.upload": "Отпреми",
  "navbar.signin": "Пријава",
  "navbar.home": "Почетна",
  "navbar.signup": "Регистрација",
  "navbar.links.shares": "Моја дељења",
  "navbar.links.reverse": "Обрнуто дељење",
  "navbar.avatar.account": "Мој налог",
  "navbar.avatar.admin": "Администрација",
  "navbar.avatar.signout": "Одјави се",
  // END navbar
  // /
  "home.title": "<h>Само-хостована</h> платформа за дељење фајлова.",
  "home.description": "Да ли заиста желите да дате своје личне датотеке у руке трећих страна као што је WeTransfer?",
  "home.bullet.a.name": "Само-хостовано",
  "home.bullet.a.description": "Хостујте Pingvin Share на својој машини.",
  "home.bullet.b.name": "Privatnost",
  "home.bullet.b.description": "Ваше датотеке су ваше и никада неће бити доступне трећим странама.",
  "home.bullet.c.name": "Нема досадног ограничења величине датотеке",
  "home.bullet.c.description": "Отпремите онолико великих датотека колико желите. Само ваш чврсти диск је граница.",
  "home.button.start": "Започни",
  "home.button.source": "Изворни код",
  // END /
  // /auth/signin
  "signin.title": "Добродошли назад",
  "signin.description": "Још увек немате налог?",
  "signin.button.signup": "Региструј се",
  "signin.input.email-or-username": "Имејл или корисничко име",
  "signin.input.email-or-username.placeholder": "Ваш имејл или корисничко име",
  "signin.input.password": "Лозинка",
  "signin.input.password.placeholder": "Ваша лозинка",
  "signin.button.submit": "Пријавите се",
  "signIn.notify.totp-required.title": "Потребна је двофакторска аутентификација",
  "signIn.notify.totp-required.description": "Унесите свој двофакторски код за аутентификацију",
  "signIn.oauth.or": "Или",
  "signIn.oauth.signInWith": "Пријавите се са",
  "signIn.oauth.github": "GitHub",
  "signIn.oauth.google": "Google",
  "signIn.oauth.microsoft": "Microsoft",
  "signIn.oauth.discord": "Discord",
  "signIn.oauth.oidc": "OpenID",
  // END /auth/signin
  // /auth/signup
  "signup.title": "Направи налог",
  "signup.description": "Већ имате налог?",
  "signup.button.signin": "Пријавите се",
  "signup.input.username": "Корисничко име",
  "signup.input.username.placeholder": "Ваше корисничко име",
  "signup.input.email": "Имејл",
  "signup.input.email.placeholder": "Ваш имејл",
  "signup.button.submit": "Хајде да почнемо",
  // END /auth/signup
  // /auth/totp
  "totp.title": "ТОТП аутентификација",
  "totp.button.signIn": "Пријавите се",
  // END /auth/totp
  // /auth/reset-password
  "resetPassword.title": "Заборавили сте лозинку?",
  "resetPassword.description": "Унесите свој имејл да бисте ресетовали лозинку.",
  "resetPassword.notify.success": "Порука са линком за ресетовање лозинке је послата ако унета и-мејл адреса постоји.",
  "resetPassword.button.back": "Назад на страницу за пријаву",
  "resetPassword.text.resetPassword": "Обнови лозинку",
  "resetPassword.text.enterNewPassword": "Унесите вашу нову лозинку",
  "resetPassword.input.password": "Нова лозинка",
  "resetPassword.notify.passwordReset": "Ваша лозинка је успешно ресетована.",
  // /account
  "account.title": "Мој налог",
  "account.card.info.title": "Подаци о налогу",
  "account.card.info.username": "Корисничко име",
  "account.card.info.email": "Имејл",
  "account.notify.info.success": "Налог је успешно ажуриран",
  "account.card.password.title": "Лозинка",
  "account.card.password.old": "Стара лозинка",
  "account.card.password.new": "Нова лозинка",
  "account.card.password.noPasswordSet": "Немате постављену лозинку. Да бисте се пријавили користећи и-мејл и лозинку, потребно је да направите лозинку.",
  "account.notify.password.success": "Лозинка је успешно промењена",
  "account.card.oauth.title": "Социал логин",
  "account.card.oauth.github": "GitHub",
  "account.card.oauth.google": "Google",
  "account.card.oauth.microsoft": "Microsoft",
  "account.card.oauth.discord": "Discord",
  "account.card.oauth.oidc": "OpenID",
  "account.card.oauth.link": "Link",
  "account.card.oauth.unlink": "Прекини везу",
  "account.card.oauth.unlinked": "Веза је прекинута",
  "account.modal.unlink.title": "Прекини везу са налогом",
  "account.modal.unlink.description": "Уклањање везе са вашим друштвеним налозима може довести до губитка вашег налога ако се не сећате својих приступних података",
  "account.notify.oauth.unlinked.success": "Веза је прекинута",
  "account.card.security.title": "Безбедност",
  "account.card.security.totp.enable.description": "Унесите своју тренутну лозинку да бисте почели да омогућавате ТОТП",
  "account.card.security.totp.disable.description": "Унесите своју тренутну лозинку да бисте онемогућили ТОТП",
  "account.card.security.totp.button.start": "Започни",
  "account.modal.totp.title": "Омогући ТОТП",
  "account.modal.totp.step1": "Корак 1: Додајте свој аутентификатор",
  "account.modal.totp.step2": "Корак 2: Потврдите свој код",
  "account.modal.totp.enterManually": "Унесите ручно",
  "account.modal.totp.code": "Код",
  "common.button.clickToCopy": "Кликните за копирање",
  "account.modal.totp.verify": "Верификуј",
  "account.notify.totp.disable": "ТОТП је успешно онемогућен",
  "account.notify.totp.enable": "ТОТП је успешно омогућен",
  "account.card.language.title": "Језик",
  "account.card.language.description": "Пројекат је преведен од стране заједнице. Неки језици могу бити непотпуни.",
  "account.card.color.title": "Шема боја",
  // ThemeSwitcher.tsx
  "account.theme.dark": "Тамно",
  "account.theme.light": "Светло",
  "account.theme.system": "Систем",
  "account.button.delete": "Избриши Налог",
  "account.modal.delete.title": "Избриши Налог",
  "account.modal.delete.description": "Да ли заиста желите да избришете свој налог укључујући све ваше активне дељења?",
  // END /account
  // /account/shares
  "account.shares.title": "Моја дељења",
  "account.shares.title.empty": "Овде је празно 👀",
  "account.shares.description.empty": "Немате никаква дељења.",
  "account.shares.button.create": "Направите",
  "account.shares.info.title": "Делите информације",
  "account.shares.table.id": "ID",
  "account.shares.table.name": "Назив",
  "account.shares.table.description": "Опис",
  "account.shares.table.visitors": "Посетиоци",
  "account.shares.table.expiresAt": "Истиче",
  "account.shares.table.createdAt": "Направљено",
  "account.shares.table.size": "Величина",
  "account.shares.table.password-protected": "Password protected",
  "account.shares.table.visitor-count": "{count} of {max}",
  "account.shares.table.expiry-never": "Never",
  "account.shares.modal.share-informations": "Делите информације",
  "account.shares.modal.share-link": "Дели везу",
  "account.shares.modal.delete.title": "Избриши дељење {share}",
  "account.shares.modal.delete.description": "Да ли заиста желите да избришете ово дељење?",
  // END /account/shares
  // /account/reverseShares
  "account.reverseShares.title": "Обрнуто дељење",
  "account.reverseShares.description": "Обрнуто дељење вам омогућава да генеришете јединствени URL који омогућава спољним корисницима да креирају дељење.",
  "account.reverseShares.title.empty": "Овде је празно 👀",
  "account.reverseShares.description.empty": "Немате обрнутих дељења.",
  // showCreateReverseShareModal.tsx
  "account.reverseShares.modal.title": "Креирајте обрнуто дељење",
  "account.reverseShares.modal.expiration.label": "Истиче",
  "account.reverseShares.modal.expiration.minute-singular": "Минут",
  "account.reverseShares.modal.expiration.minute-plural": "Минуте",
  "account.reverseShares.modal.expiration.hour-singular": "Сат",
  "account.reverseShares.modal.expiration.hour-plural": "Сати",
  "account.reverseShares.modal.expiration.day-singular": "Дан",
  "account.reverseShares.modal.expiration.day-plural": "Дани",
  "account.reverseShares.modal.expiration.week-singular": "Седмица",
  "account.reverseShares.modal.expiration.week-plural": "Седмице",
  "account.reverseShares.modal.expiration.month-singular": "Месец",
  "account.reverseShares.modal.expiration.month-plural": "Месеци",
  "account.reverseShares.modal.expiration.year-singular": "Година",
  "account.reverseShares.modal.expiration.year-plural": "Године",
  "account.reverseShares.modal.max-size.label": "Максимална величина дељења",
  "account.reverseShares.modal.send-email": "Пошаљи обавештења и-мејлом",
  "account.reverseShares.modal.send-email.description": "Пошаљи обавештење имејлом када се креира дељење помоћу ове обрнуте везе за дељење.",
  "account.reverseShares.modal.simplified": "Једноставан режим",
  "account.reverseShares.modal.simplified.description": "Олакшајте особи која отпрема фајл да га подели са вама. Они ће моћи да прилагоде само име и опис дељења.",
  "account.reverseShares.modal.public-access": "Јавни приступ",
  "account.reverseShares.modal.public-access.description": "Учини да дељења креирана овим реверзним линком за дељење буду јавна. Ако је онемогућено, само ви и креатор дељења ћете имати приступ за преглед.",
  "account.reverseShares.modal.max-use.label": "Максималан број коришћења",
  "account.reverseShares.modal.max-use.description": "Максималан број пута који овај URL може да се користи за прављење дељења.",
  "account.reverseShare.never-expires": "Ово обрнуто дељење никада неће истећи.",
  "account.reverseShare.expires-on": "Ово обрнуто дељење ће истећи {expiration}.",
  "account.reverseShares.table.no-shares": "Још нема креираних дељења",
  "account.reverseShares.table.count.singular": "дељење",
  "account.reverseShares.table.count.plural": "дељења",
  "account.reverseShares.table.shares": "Дељења",
  "account.reverseShares.table.remaining": "Преостала употреба",
  "account.reverseShares.table.max-size": "Максимална величина дељења",
  "account.reverseShares.table.expires": "Истиче у",
  "account.reverseShares.modal.reverse-share-link": "Линк за обрнуто дељење",
  "account.reverseShares.modal.delete.title": "Обришите обрнуто дељење",
  "account.reverseShares.modal.delete.description": "Да ли заиста желите да избришете ово обрнуто дељење? Ако то учините, придружена дељења ће такође бити избрисана.",
  // END /account/reverseShares
  // /admin
  "admin.title": "Администрација",
  "admin.button.users": "Управљање корисницима",
  "admin.button.shares": "Управљање дељењем",
  "admin.button.config": "Конфигурација",
  "admin.version": "Верзија",
  // END /admin
  // /admin/users
  "admin.users.title": "Управљање корисницима",
  "admin.users.table.username": "Корисничко име",
  "admin.users.table.email": "Имејл",
  "admin.users.table.admin": "Админ",
  "admin.users.edit.update.title": "Уредите корисника: {username}",
  "admin.users.edit.update.admin-privileges": "Администраторске привилегије",
  "admin.users.edit.update.change-password.title": "Промените лозинку",
  "admin.users.edit.update.change-password.field": "Нова лозинка",
  "admin.users.edit.update.change-password.button": "Снимите нову лозинку",
  "admin.users.edit.update.notify.password.success": "Лозинка је успешно промењена",
  "admin.users.edit.delete.title": "Обришите корисника: {username} ?",
  "admin.users.edit.delete.description": "Да ли заиста желите да обришете овог корисника и сва његова дељења?",
  // showCreateUserModal.tsx
  "admin.users.modal.create.title": "Креирај корисника",
  "admin.users.modal.create.username": "Корисничко име",
  "admin.users.modal.create.email": "Имејл",
  "admin.users.modal.create.password": "Лозинка",
  "admin.users.modal.create.manual-password": "Поставите лозинку ручно",
  "admin.users.modal.create.manual-password.description": "Ако није означено, корисник ће добити имејл са везом за постављање лозинке.",
  "admin.users.modal.create.admin": "Администраторске привилегије",
  "admin.users.modal.create.admin.description": "Ако је означено, корисник ће моћи да приступи административном панелу.",
  // END /admin/users
  // /admin/shares
  "admin.shares.title": "Управљање дељењем",
  "admin.shares.table.id": "ID дељења",
  "admin.shares.table.username": "Креатор",
  "admin.shares.table.visitors": "Посетиоци",
  "admin.shares.table.expires": "Истиче",
  "admin.shares.edit.delete.title": "Обриши дељење: {id}",
  "admin.shares.edit.delete.description": "Да ли заиста желите да обришете ово дељење?",
  // END /admin/shares
  // /upload
  "upload.title": "Пошаљи",
  "upload.notify.confirm-leave": "Да ли сте сигурни да желите да напустите ову страницу? Ваше отпремање ће бити отказано.",
  "upload.notify.generic-error": "Дошло је до грешке при довршавању дељења.",
  "upload.notify.count-failed": "Отпремање {count} датотека није успело. Покушавам поново.",
  "upload.reverse-share.error.invalid.title": "Неправилан линк за обрнуто дељење",
  "upload.reverse-share.error.invalid.description": "Ово обрнуто дељење је истекло или је неважеће.",
  // Dropzone.tsx
  "upload.dropzone.title": "Пошаљи датотеке",
  "upload.dropzone.description": "Превуците и отпустите датотеке овде да бисте започели дељење. Прихватамо само фајлове укупне величине до {maxSize}.",
  "upload.dropzone.notify.file-too-big": "Ваше датотеке премашују максималну величину дељења од {maxSize}.",
  // FileList.tsx
  "upload.filelist.name": "Назив",
  "upload.filelist.size": "Величина",
  // showCreateUploadModal.tsx
  "upload.modal.title": "Направи дељење",
  "upload.modal.link.error.invalid": "Може да садржи само слова, бројеве, доње црте и цртице",
  "upload.modal.link.error.taken": "Овај линк је већ у употреби",
  "upload.modal.not-signed-in": "Нисте пријављени",
  "upload.modal.not-signed-in-description": "Нећете моћи ручно да избришете своје дељење и видите број посетилаца.",
  "upload.modal.expires.never": "никад",
  "upload.modal.expires.never-long": "Трајно дељење",
  "upload.modal.expires.error.too-long": "Датум истека превазилази максималну вредност од {max}.",
  "upload.modal.link.label": "Линк",
  "upload.modal.expires.label": "Истиче",
  "upload.modal.expires.minute-singular": "Минут",
  "upload.modal.expires.minute-plural": "Минуте",
  "upload.modal.expires.hour-singular": "Сат",
  "upload.modal.expires.hour-plural": "Сати",
  "upload.modal.expires.day-singular": "Дан",
  "upload.modal.expires.day-plural": "Дани",
  "upload.modal.expires.week-singular": "Седмица",
  "upload.modal.expires.week-plural": "Седмице",
  "upload.modal.expires.month-singular": "Месец",
  "upload.modal.expires.month-plural": "Месеци",
  "upload.modal.expires.year-singular": "Година",
  "upload.modal.expires.year-plural": "Године",
  "upload.modal.accordion.name-and-description.title": "Име и опис",
  "upload.modal.accordion.name-and-description.name.placeholder": "Име",
  "upload.modal.accordion.name-and-description.description.placeholder": "Напомена за примаоце овог дељења",
  "upload.modal.accordion.email.title": "Примаоци имејла",
  "upload.modal.accordion.email.placeholder": "Унесите примаоце имејла",
  "upload.modal.accordion.email.invalid-email": "Неисправна адреса имејла",
  "upload.modal.accordion.security.title": "Сигурносна подешавања",
  "upload.modal.accordion.security.password.label": "Заштита лозинком",
  "upload.modal.accordion.security.password.placeholder": "Нема лозинке",
  "upload.modal.accordion.security.max-views.label": "Максималан број прегледа",
  "upload.modal.accordion.security.max-views.placeholder": "Без лимита",
  // showCompletedUploadModal.tsx
  "upload.modal.completed.never-expires": "Ово дељење никада неће истећи.",
  "upload.modal.completed.expires-on": "Ово дељење ће истећи {expiration}.",
  "upload.modal.completed.share-ready": "Дељење је спремно",
  "upload.modal.completed.notified-reverse-share-creator": "Обавестили смо креатора реверзног дељења. Такође можете ручно поделити овај линк са њима на друге начине.",
  // END /upload
  // /share/[id]
  "share.title": "Дељење {shareId}",
  "share.description": "Погледајте шта сам поделио са вама!",
  "share.error.visitor-limit-exceeded.title": "Прекорачено је ограничење посетилаца",
  "share.error.visitor-limit-exceeded.description": "Ограничење посетилаца из овог дељења је премашено.",
  "share.error.removed.title": "Дељење је уклоњено",
  "share.error.not-found.title": "Дељење није пронађено",
  "share.error.not-found.description": "Удео који тражите не постоји.",
  "share.error.access-denied.title": "Приватно дељење",
  "share.error.access-denied.description": "Тренутни налог нема дозволу за приступ овом дељењу",
  "share.modal.password.title": "Обавезна лозинка",
  "share.modal.password.description": "Молимо унесите лозинку за приступ овом дељењу.",
  "share.modal.password": "Лозинка",
  "share.modal.error.invalid-password": "Неисправна лозинка",
  "share.button.download-all": "Преузми све",
  "share.notify.download-all-preparing": "Дељење се припрема. Молимо покушајте поново за неколико минута.",
  "share.modal.file-link": "Веза датотеке",
  "share.table.name": "Назив",
  "share.table.size": "Величина",
  "share.modal.file-preview.error.not-supported.title": "Преглед није подржан",
  "share.modal.file-preview.error.not-supported.description": "Прегледи нису подржани за овај тип датотека. Молимо преузмите фајл да бисте га прегледали.",
  // END /share/[id]
  // /share/[id]/edit
  "share.edit.title": "Уреди {shareId}",
  "share.edit.append-upload": "Надодај фајл",
  "share.edit.notify.generic-error": "Дошло је до грешке приликом завршетка вашег дељења.",
  "share.edit.notify.save-success": "Дељење је успешно ажурирано",
  // END /share/[id]/edit
  // /imprint
  "imprint.title": "Imprint",
  // END /imprint
  // /privacy
  "privacy.title": "Privacy Policy",
  // END /privacy
  // /admin/config
  "admin.config.title": "Конфигурација",
  "admin.config.category.general": "Опште",
  "admin.config.category.share": "Дељење",
  "admin.config.category.email": "Имејл",
  "admin.config.category.smtp": "SMTP",
  "admin.config.category.oauth": "Social Login",
  "admin.config.general.app-name": "Назив апликације",
  "admin.config.general.app-name.description": "Назив апликације",
  "admin.config.general.app-url": "URL апликације",
  "admin.config.general.app-url.description": "На којој URL адреси је доступан Pingvin Share",
  "admin.config.general.secure-cookies": "Безбедни колачићи",
  "admin.config.general.secure-cookies.description": "Да ли желите да поставите заставицу за безбедност на колачиће? Ако је омогућено, сајт неће функционисати када му приступате преко HTTP-а.",
  "admin.config.general.show-home-page": "Прикажи почетну страницу",
  "admin.config.general.show-home-page.description": "Да ли да се прикаже почетна страница",
  "admin.config.general.session-duration": "Трајање сесије",
  "admin.config.general.session-duration.description": "Време у сатима након којег корисник мора поново да се пријави (подразумевано: 3 месеца).",
  "admin.config.general.logo": "Лого",
  "admin.config.general.logo.description": "Промените свој логотип тако што ћете отпремити нову слику. Слика мора да буде PNG и треба да има формат 1:1.",
  "admin.config.general.logo.placeholder": "Изабери слику",
  "admin.config.email.enable-share-email-recipients": "Омогући дељење са примаоцима имејлом",
  "admin.config.email.enable-share-email-recipients.description": "Да ли дозволити дељење са примаоцима путем имејла. Омогућите ово само ако је SMTP активиран.",
  "admin.config.email.share-recipients-subject": "Поделите наслов примаоца",
  "admin.config.email.share-recipients-subject.description": "Тема имејла која се шаље примаоцима дељења.",
  "admin.config.email.share-recipients-message": "Делите поруку примаоца",
  "admin.config.email.share-recipients-message.description": "Порука која се шаље примаоцима дељења. Доступне променљиве:\n{creator} - Корисничко име креатора дељења\n{creatorEmail} - Имејл креатора дељења\n{shareUrl} - URL дељења\n{desc} - Опис дељења\n{expires} - Датум истека дељења\nОве променљиве ће бити замењене стварним вредностима.",
  "admin.config.email.reverse-share-subject": "Тема обрнутог дељења",
  "admin.config.email.reverse-share-subject.description": "Наслов имејла који се шаље када неко креира дељење са вашим реверзним линком за дељење.",
  "admin.config.email.reverse-share-message": "Обрнуто дељење порука",
  "admin.config.email.reverse-share-message.description": "Порука која се шаље када је неко направио дељење са вашом обрнутом везом за дељење. {shareUrl} ће бити замењен именом креатора и URL-ом за дељење.",
  "admin.config.email.reset-password-subject": "Ресетујте тему лозинке",
  "admin.config.email.reset-password-subject.description": "Наслов имејла који се шаље када корисник затражи ресетовање лозинке.",
  "admin.config.email.reset-password-message": "Порука за ресетовање лозинке",
  "admin.config.email.reset-password-message.description": "Порука која се шаље када корисник затражи ресетовање лозинке. {url} ће бити замењен линком за ресетовање лозинке.",
  "admin.config.email.invite-subject": "Позивна тема",
  "admin.config.email.invite-subject.description": "Наслов е-поште која се шаље када администратор позове корисника.",
  "admin.config.email.invite-message": "Позивна порука",
  "admin.config.email.invite-message.description": "Порука која се шаље када администратор позове корисника. {url} ће бити замењен линком за позив, {email} имејлом, а {password} лозинком корисника.",
  "admin.config.share.allow-registration": "Дозволи регистрацију",
  "admin.config.share.allow-registration.description": "Да ли је регистрација дозвољена",
  "admin.config.share.allow-unauthenticated-shares": "Дозволи дељење без аутентификације",
  "admin.config.share.allow-unauthenticated-shares.description": "Да ли корисници без аутентификације могу да креирају дељења",
  "admin.config.share.max-expiration": "Максимални рок трајања",
  "admin.config.share.max-expiration.description": "Maximum share expiration. Set to 0 to allow unlimited expiration.",
  "admin.config.share.share-id-length": "Дужина подразумеваног ID-а за дељење",
  "admin.config.share.share-id-length.description": "Подразумевана дужина генерисаног ID-а за дељење. Ова вредност се такође користи за генерисање линкова за обрнуто дељење. Вредност испод 8 се не сматра безбедном.",
  "admin.config.share.max-size": "Максимална величина",
  "admin.config.share.max-size.description": "Максимална величина дељења",
  "admin.config.share.zip-compression-level": "Ниво Zip компресије",
  "admin.config.share.zip-compression-level.description": "Подесите ниво да бисте балансирали између величине датотеке и брзине компресије. Важеће вредности се крећу од 0 до 9, при чему је 0 без компресије, а 9 је максимална компресија. ",
  "admin.config.share.chunk-size": "Величина комада",
  "admin.config.share.chunk-size.description": "Подесите величину дела за ваша отпремање како бисте уравнотежили ефикасност и поузданост у складу са вашом интернет везом. Мањи делови могу побољшати стопу успеха за нестабилне везе, док већи делови омогућавају брже отпремање за стабилне везе.",
  "admin.config.share.auto-open-share-modal": "",
  "admin.config.share.auto-open-share-modal.description": "Модал за креирање дељења аутоматски се појављује када корисник изабере датотеке, елиминишући потребу за ручним кликом на дугме.",
  "admin.config.smtp.enabled": "Омогући",
  "admin.config.smtp.enabled.description": "Да ли је SMTP омогућен. Поставите ово на тачно само ако сте унели хост, порт, имејл, корисника и лозинку вашег SMTP сервера.",
  "admin.config.smtp.host": "Домаћин",
  "admin.config.smtp.host.description": "Домаћин SMTP сервера",
  "admin.config.smtp.port": "Порт",
  "admin.config.smtp.port.description": "Порт домаћина SMTP сервера",
  "admin.config.smtp.email": "Имејл",
  "admin.config.smtp.email.description": "Адреса имејла са којег се поруке шаљу",
  "admin.config.smtp.username": "Корисничко име",
  "admin.config.smtp.username.description": "Корисничко име SMTP сервера",
  "admin.config.smtp.password": "Лозинка",
  "admin.config.smtp.password.description": "Лозинка SMTP сервера",
  "admin.config.smtp.button.test": "Пошаљи тестни имејл",
  "admin.config.smtp.allow-unauthorized-certificates": "Веровање неауторизованим SMTP серверским сертификатима",
  "admin.config.smtp.allow-unauthorized-certificates.description": "Ово поставите на \"истина\" само ако је потребно веровати само-потписаним сертификатима.",
  "admin.config.oauth.allow-registration": "Дозволи регистрацију",
  "admin.config.oauth.allow-registration.description": "Дозволите корисницима да се региструју путем друштвене пријаве",
  "admin.config.oauth.ignore-totp": "Занемари ТОТП",
  "admin.config.oauth.ignore-totp.description": "Да ли да игноришете ТОТП када корисник користи пријаву на друштвеним мрежама",
  "admin.config.oauth.disable-password": "Онемогућите пријаву лозинком",
  "admin.config.oauth.disable-password.description": "Омогућити пријаву лозинком или не\nУверите се да је провајдер за OAuth правилно конфигурисан пре активирања ове конфигурације како бисте избегли закључавање налога.",
  "admin.config.oauth.github-enabled": "GitHub",
  "admin.config.oauth.github-enabled.description": "Да ли је пријављивање на GitHub омогућено",
  "admin.config.oauth.github-client-id": "GitHub ID клијента",
  "admin.config.oauth.github-client-id.description": "ID клијента GitHub OAuth апликације",
  "admin.config.oauth.github-client-secret": "Тајна GitHub клијента",
  "admin.config.oauth.github-client-secret.description": "Тајна клијента GitHub OAuth апликације",
  "admin.config.oauth.google-enabled": "Google",
  "admin.config.oauth.google-enabled.description": "Да ли је пријављивање на Google омогућено",
  "admin.config.oauth.google-client-id": "ID Google клијента",
  "admin.config.oauth.google-client-id.description": "ID клијента Google OAuth апликације",
  "admin.config.oauth.google-client-secret": "Тајна Google клијента",
  "admin.config.oauth.google-client-secret.description": "Тајна клијента Google OAuth апликације",
  "admin.config.oauth.microsoft-enabled": "Microsoft",
  "admin.config.oauth.microsoft-enabled.description": "Да ли је пријављивање на Microsoft омогућено",
  "admin.config.oauth.microsoft-tenant": "Microsoft Tenant",
  "admin.config.oauth.microsoft-tenant.description": "ID закупца за Microsoft OAuth апликацију\nуобичајено: Корисници са личним Microsoft налогом и пословним или школским налогом са Microsoft Entra ID-а могу да се пријаве у апликацију. организације: Само корисници са пословним или школским налозима са Microsoft Entra ID-а могу да се пријаве у апликацију.\nпотрошачи: Само корисници са личним Microsoft налогом могу да се пријаве у апликацију.\nиме домена закупца Microsoft Entra ID или ИД закупца у ГУИД формату: Само корисници из одређеног Microsoft Entra ID станара (чланови директоријума са пословним или школским налогом или гости директоријума са личним Microsoft налогом) могу да се пријаве у апликацију.",
  "admin.config.oauth.microsoft-client-id": "Microsoft ID клијента",
  "admin.config.oauth.microsoft-client-id.description": "ID клијента Microsoft OAuth апликације",
  "admin.config.oauth.microsoft-client-secret": "Тајна Microsoft клијента",
  "admin.config.oauth.microsoft-client-secret.description": "Тајна клијента за Microsot OAuth апликацију",
  "admin.config.oauth.discord-enabled": "Discord",
  "admin.config.oauth.discord-enabled.description": "Да ли је пријављивање на Discord омогућено",
  "admin.config.oauth.discord-limited-users": "Ограничење по Discord корисницима",
  "admin.config.oauth.discord-limited-users.description": "Ограничите пријављивање на одређене кориснике помоћу њиховог Discord ID-а. Оставите празно да бисте онемогућили.",
  "admin.config.oauth.discord-limited-guild": "Ограничење по Discord серверу",
  "admin.config.oauth.discord-limited-guild.description": "Ограничите пријављивање на кориснике одређеног сервера. Оставите празно да бисте онемогућили.",
  "admin.config.oauth.discord-client-id": "Discord ID клијента",
  "admin.config.oauth.discord-client-id.description": "ID клијента Discord OAuth апликације",
  "admin.config.oauth.discord-client-secret": "Discord клијент тајна",
  "admin.config.oauth.discord-client-secret.description": "Тајна клијента Discord OAuth апликације",
  "admin.config.oauth.oidc-enabled": "OpenID Connect",
  "admin.config.oauth.oidc-enabled.description": "Омогућити пријаву OpenID Connect-ом или не",
  "admin.config.oauth.oidc-discovery-uri": "URI за OpenID Connect Discovery",
  "admin.config.oauth.oidc-discovery-uri.description": "Discovery URI за откривање OpenID Connect OAuth апликације",
  "admin.config.oauth.oidc-sign-out": "Одјављивање са OpenID Connect-a",
  "admin.config.oauth.oidc-sign-out.description": "Да ли ће дугме „Одјави се“ одјавити корисника и са OpenID Connect провајдера",
  "admin.config.oauth.oidc-scope": "Опсег OpenID Connect-а",
  "admin.config.oauth.oidc-scope.description": "Опсези који би требало да буду затражени од OpenID Connect провајдера.",
  "admin.config.oauth.oidc-username-claim": "Потраживање корисничког имена у OpenID Connect",
  "admin.config.oauth.oidc-username-claim.description": "Потраживање корисничког имена у OpenID Connect ID токену. Оставите празно ако не знате шта је ова конфигурација.",
  "admin.config.oauth.oidc-role-path": "Путања до улога у OpenID Connect токену",
  "admin.config.oauth.oidc-role-path.description": "Мора бити валидна JMES путања која референцира низ улога. " + "Управљање правима приступа помоћу улога у OpenID Connect-у се препоручује само ако ниједан други провајдер идентитета није конфигурисан и ако је пријава лозинком онемогућена. " + "Оставите празно ако не знате шта је ова конфигурација.",
  "admin.config.oauth.oidc-role-general-access": "Улога у OpenID Connect-у за општи приступ",
  "admin.config.oauth.oidc-role-general-access.description": "Улога потребна за општи приступ. Мора бити присутна у улогама корисника како би се могао пријавити. " + "Оставите празно ако не знате шта је ова конфигурација.",
  "admin.config.oauth.oidc-role-admin-access": "Улога у OpenID Connect-у за администраторски приступ",
  "admin.config.oauth.oidc-role-admin-access.description": "Улога потребна за администраторски приступ. Мора бити присутна у улогама корисника како би могли приступити администраторском панелу. " + "Оставите празно ако не знате шта је ова конфигурација.",
  "admin.config.oauth.oidc-client-id": "OpenID Connect ID клијента",
  "admin.config.oauth.oidc-client-id.description": "ID клијента OpenID Connect OAuth апликације",
  "admin.config.oauth.oidc-client-secret": "OpenID Connect тајна клијента",
  "admin.config.oauth.oidc-client-secret.description": "Тајна клијента OpenID Connect OAuth апликације",
  "admin.config.category.ldap": "LDAP",
  "admin.config.ldap.enabled": "Омогући LDAP",
  "admin.config.ldap.enabled.description": "Користи LDAP аутентификацију за пријаву корисника",
  "admin.config.ldap.url": "URL сервера",
  "admin.config.ldap.url.description": "URL LDAP сервера",
  "admin.config.ldap.bind-dn": "DN везивање",
  "admin.config.ldap.bind-dn.description": "Подразумевани корисник који се користи за претрагу корисника",
  "admin.config.ldap.bind-password": "Лозинка за везивање",
  "admin.config.ldap.bind-password.description": "Лозинка која се користи за извршавање претраге корисника",
  "admin.config.ldap.search-base": "База корисника",
  "admin.config.ldap.search-base.description": "Локација базе, место где ће се извршити претрага корисника",
  "admin.config.ldap.search-query": "Упит за корисника",
  "admin.config.ldap.search-query.description": "Упит за корисника који ће се користити за претрагу „Базе корисника“ за LDAP корисника. %username% се може користити као ознака за унос корисника.",
  "admin.config.ldap.admin-groups": "Администраторска група",
  "admin.config.ldap.admin-groups.description": "Група која је потребна за администраторски приступ.",
  "admin.config.ldap.field-name-member-of": "Назив атрибута корисничких група",
  "admin.config.ldap.field-name-member-of.description": "LDAP назив атрибута за групе чији је корисник члан. Ово се користи при провери администраторске групе.",
  "admin.config.ldap.field-name-email": "Назив атрибута за имејл корисника",
  "admin.config.ldap.field-name-email.description": "LDAP назив атрибута за имејл корисника.",
  "admin.config.notify.success": "Конфигурација је успешно ажурирана.",
  "admin.config.notify.logo-success": "Лого је успешно ажуриран. Може бити потребно неколико минута да се ажурира на вебсајту.",
  "admin.config.notify.no-changes": "Нема промена за чување.",
  "admin.config.category.s3": "S3",
  "admin.config.s3.enabled": "Enabled",
  "admin.config.s3.enabled.description": "Whether S3 should be used to store the shared files instead of the local file system.",
  "admin.config.s3.endpoint": "Endpoint",
  "admin.config.s3.endpoint.description": "The URL of the S3 bucket.",
  "admin.config.s3.region": "Region",
  "admin.config.s3.region.description": "The region of the S3 bucket.",
  "admin.config.s3.bucket-name": "Bucket name",
  "admin.config.s3.bucket-name.description": "The name of the S3 bucket.",
  "admin.config.s3.bucket-path": "Path",
  "admin.config.s3.bucket-path.description": "The default path which should be used to store the files in the S3 bucket.",
  "admin.config.s3.key": "Key",
  "admin.config.s3.key.description": "The key which allows you to access the S3 bucket.",
  "admin.config.s3.secret": "Secret",
  "admin.config.s3.secret.description": "The secret which allows you to access the S3 bucket.",
  "admin.config.category.legal": "Legal",
  "admin.config.legal.enabled": "Enable legal notices",
  "admin.config.legal.enabled.description": "Whether to show a link to imprint and privacy policy in the footer.",
  "admin.config.legal.imprint-text": "Imprint text",
  "admin.config.legal.imprint-text.description": "The text which should be shown in the imprint. Supports Markdown. Leave blank to link to an external imprint page.",
  "admin.config.legal.imprint-url": "Imprint URL",
  "admin.config.legal.imprint-url.description": "If you already have an imprint page you can link it here instead of using the text field.",
  "admin.config.legal.privacy-policy-text": "Privacy policy text",
  "admin.config.legal.privacy-policy-text.description": "The text which should be shown in the privacy policy. Supports Markdown. Leave blank to link to an external privacy policy page.",
  "admin.config.legal.privacy-policy-url": "Privacy policy URL",
  "admin.config.legal.privacy-policy-url.description": "If you already have a privacy policy page you can link it here instead of using the text field.",
  // 404
  "404.description": "Опа - Ова страна не постоји.",
  "404.button.home": "Врати ме на почетак",
  // error
  "error.title": "Грешка",
  "error.description": "Упс!",
  "error.button.back": "Иди назад",
  "error.msg.default": "Нешто је пошло наопако.",
  "error.msg.access_denied": "Отказали сте процес аутентификације, покушајте поново.",
  "error.msg.expired_token": "Процес аутентификације је трајао предуго, покушајте поново.",
  "error.msg.invalid_token": "Интерна грешка",
  "error.msg.no_user": "Корисник повезан са овим {0} налогом не постоји.",
  "error.msg.no_email": "Не могу да добијем адресу имејла са овог {0} налога.",
  "error.msg.already_linked": "Овај {0} налог је већ повезан са другим налогом.",
  "error.msg.not_linked": "Овај {0} налог још увек није повезан ни са једним налогом.",
  "error.msg.unverified_account": "Овај {0} налог је непотврђен, молимо покушајте поново након верификације.",
  "error.msg.user_not_allowed": "Није вам дозвољено да се пријавите.",
  "error.msg.cannot_get_user_info": "Не могу да добијем ваше корисничке информације са овог {0} налога.",
  "error.param.provider_github": "GitHub",
  "error.param.provider_google": "Google",
  "error.param.provider_microsoft": "Microsoft",
  "error.param.provider_discord": "Discord",
  "error.param.provider_oidc": "OpenID Connect",
  // Common translations
  "common.button.save": "Сачувај",
  "common.button.create": "Направи",
  "common.button.submit": "Пошаљи",
  "common.button.delete": "Обриши",
  "common.button.cancel": "Откажи",
  "common.button.confirm": "Потврди",
  "common.button.disable": "Онемогући",
  "common.button.share": "Дељење",
  "common.button.generate": "Генериши",
  "common.button.done": "Готово",
  "common.text.link": "Линк",
  "common.text.navigate-to-link": "Посетите линк",
  "common.text.or": "или",
  "common.text.redirecting": "Преусмеравање...",
  "common.button.go-back": "Иди назад",
  "common.button.go-home": "Почетна страница",
  "common.notify.copied": "Ваша веза је копирана у међуспремник",
  "common.notify.copied-link": "Ваша веза је копирана у међуспремник",
  "common.success": "Успешно",
  "common.error": "Грешка",
  "common.error.unknown": "Дошло је до непознате грешке",
  "common.error.invalid-email": "Неисправна адреса имејла",
  "common.error.too-short": "Мора да има најмање {length} знакова",
  "common.error.too-long": "Мора да има највише {length} знакова",
  "common.error.number-too-small": "Мора бити најмање {min}",
  "common.error.number-too-large": "Мора бити највише {max}",
  "common.error.exact-length": "Мора да има тачно {length} знакова",
  "common.error.invalid-number": "Мора бити број",
  "common.error.field-required": "Поље је обавезно"
};