export default {
  // Navbar
  "navbar.upload": "Otpremi",
  "navbar.signin": "Prijava",
  "navbar.home": "Početna",
  "navbar.signup": "Registracija",
  "navbar.links.shares": "Moja deljenja",
  "navbar.links.reverse": "Obrnuto deljenje",
  "navbar.avatar.account": "Moj nalog",
  "navbar.avatar.admin": "Administracija",
  "navbar.avatar.signout": "Odjavi se",
  // END navbar
  // /
  "home.title": "<h>Samo-hostovana</h> platforma za deljenje fajlova.",
  "home.description": "Da li zaista želite da date svoje lične datoteke u ruke trećih strana kao što je WeTransfer?",
  "home.bullet.a.name": "Samo-hostovano",
  "home.bullet.a.description": "Hostujte Pingvin Share na svojoj mašini.",
  "home.bullet.b.name": "Privatnost",
  "home.bullet.b.description": "Vaše datoteke su vaše i nikada neće biti dostupne trećim stranama.",
  "home.bullet.c.name": "Nema dosadnog ograničenja veličine datoteke",
  "home.bullet.c.description": "Otpremite onoliko velikih datoteka koliko želite. Samo vaš čvrsti disk je granica.",
  "home.button.start": "Započni",
  "home.button.source": "Izvorni kod",
  // END /
  // /auth/signin
  "signin.title": "Dobrodošli nazad",
  "signin.description": "Još uvek nemate nalog?",
  "signin.button.signup": "Registruj se",
  "signin.input.email-or-username": "Imejl ili korisničko ime",
  "signin.input.email-or-username.placeholder": "Vaš imejl ili korisničko ime",
  "signin.input.password": "Lozinka",
  "signin.input.password.placeholder": "Vaša lozinka",
  "signin.button.submit": "Prijavite se",
  "signIn.notify.totp-required.title": "Potrebna je dvofaktorska autentifikacija",
  "signIn.notify.totp-required.description": "Unesite svoj dvofaktorski kod za autentifikaciju",
  "signIn.oauth.or": "Ili",
  "signIn.oauth.signInWith": "Prijavite se sa",
  "signIn.oauth.github": "GitHub",
  "signIn.oauth.google": "Google",
  "signIn.oauth.microsoft": "Microsoft",
  "signIn.oauth.discord": "Discord",
  "signIn.oauth.oidc": "OpenID",
  // END /auth/signin
  // /auth/signup
  "signup.title": "Napravi nalog",
  "signup.description": "Već imate nalog?",
  "signup.button.signin": "Prijavite se",
  "signup.input.username": "Korisničko ime",
  "signup.input.username.placeholder": "Vaše korisničko ime",
  "signup.input.email": "Imejl",
  "signup.input.email.placeholder": "Vaš imejl",
  "signup.button.submit": "Hajde da počnemo",
  // END /auth/signup
  // /auth/totp
  "totp.title": "TOTP autentifikacija",
  "totp.button.signIn": "Prijavite se",
  // END /auth/totp
  // /auth/reset-password
  "resetPassword.title": "Zaboravili ste lozinku?",
  "resetPassword.description": "Unesite svoj imejl da biste resetovali lozinku.",
  "resetPassword.notify.success": "Poruka sa linkom za resetovanje lozinke je poslata ako uneta i-mejl adresa postoji.",
  "resetPassword.button.back": "Nazad na stranicu za prijavu",
  "resetPassword.text.resetPassword": "Obnovi lozinku",
  "resetPassword.text.enterNewPassword": "Unesite vašu novu lozinku",
  "resetPassword.input.password": "Nova lozinka",
  "resetPassword.notify.passwordReset": "Vaša lozinka je uspešno resetovana.",
  // /account
  "account.title": "Moj nalog",
  "account.card.info.title": "Podaci o nalogu",
  "account.card.info.username": "Korisničko ime",
  "account.card.info.email": "Imejl",
  "account.notify.info.success": "Nalog je uspešno ažuriran",
  "account.card.password.title": "Lozinka",
  "account.card.password.old": "Stara lozinka",
  "account.card.password.new": "Nova lozinka",
  "account.card.password.noPasswordSet": "Nemate postavljenu lozinku. Da biste se prijavili koristeći i-mejl i lozinku, potrebno je da napravite lozinku.",
  "account.notify.password.success": "Lozinka je uspešno promenjena",
  "account.card.oauth.title": "Social login",
  "account.card.oauth.github": "GitHub",
  "account.card.oauth.google": "Google",
  "account.card.oauth.microsoft": "Microsoft",
  "account.card.oauth.discord": "Discord",
  "account.card.oauth.oidc": "OpenID",
  "account.card.oauth.link": "Link",
  "account.card.oauth.unlink": "Prekini vezu",
  "account.card.oauth.unlinked": "Veza je prekinuta",
  "account.modal.unlink.title": "Prekini vezu sa nalogom",
  "account.modal.unlink.description": "Uklanjanje veze sa vašim društvenim nalozima može dovesti do gubitka vašeg naloga ako se ne sećate svojih pristupnih podataka",
  "account.notify.oauth.unlinked.success": "Veza je prekinuta",
  "account.card.security.title": "Bezbednost",
  "account.card.security.totp.enable.description": "Unesite svoju trenutnu lozinku da biste počeli da omogućavate TOTP",
  "account.card.security.totp.disable.description": "Unesite svoju trenutnu lozinku da biste onemogućili TOTP",
  "account.card.security.totp.button.start": "Započni",
  "account.modal.totp.title": "Omogući TOTP",
  "account.modal.totp.step1": "Korak 1: Dodajte svoj autentifikator",
  "account.modal.totp.step2": "Korak 2: Potvrdite svoj kod",
  "account.modal.totp.enterManually": "Unesite ručno",
  "account.modal.totp.code": "Kod",
  "common.button.clickToCopy": "Kliknite za kopiranje",
  "account.modal.totp.verify": "Verifikuj",
  "account.notify.totp.disable": "TOTP je uspešno onemogućen",
  "account.notify.totp.enable": "TOTP je uspešno omogućen",
  "account.card.language.title": "Jezik",
  "account.card.language.description": "Projekat je preveden od strane zajednice. Neki jezici mogu biti nepotpuni.",
  "account.card.color.title": "Šema boja",
  // ThemeSwitcher.tsx
  "account.theme.dark": "Tamno",
  "account.theme.light": "Svetlo",
  "account.theme.system": "Sistem",
  "account.button.delete": "Izbriši Nalog",
  "account.modal.delete.title": "Izbriši Nalog",
  "account.modal.delete.description": "Da li zaista želite da izbrišete svoj nalog uključujući sve vaše aktivne deljenja?",
  // END /account
  // /account/shares
  "account.shares.title": "Moja deljenja",
  "account.shares.title.empty": "Ovde je prazno 👀",
  "account.shares.description.empty": "Nemate nikakva deljenja.",
  "account.shares.button.create": "Napravite",
  "account.shares.info.title": "Delite informacije",
  "account.shares.table.id": "ID",
  "account.shares.table.name": "Naziv",
  "account.shares.table.description": "Opis",
  "account.shares.table.visitors": "Posetioci",
  "account.shares.table.expiresAt": "Ističe",
  "account.shares.table.createdAt": "Napravljeno",
  "account.shares.table.size": "Veličina",
  "account.shares.table.password-protected": "Password protected",
  "account.shares.table.visitor-count": "{count} of {max}",
  "account.shares.table.expiry-never": "Never",
  "account.shares.modal.share-informations": "Delite informacije",
  "account.shares.modal.share-link": "Deli vezu",
  "account.shares.modal.delete.title": "Izbriši deljenje {share}",
  "account.shares.modal.delete.description": "Da li zaista želite da izbrišete ovo deljenje?",
  // END /account/shares
  // /account/reverseShares
  "account.reverseShares.title": "Obrnuto deljenje",
  "account.reverseShares.description": "Obrnuto deljenje vam omogućava da generišete jedinstveni URL koji omogućava spoljnim korisnicima da kreiraju deljenje.",
  "account.reverseShares.title.empty": "Ovde je prazno 👀",
  "account.reverseShares.description.empty": "Nemate obrnutih deljenja.",
  // showCreateReverseShareModal.tsx
  "account.reverseShares.modal.title": "Kreirajte obrnuto deljenje",
  "account.reverseShares.modal.expiration.label": "Ističe",
  "account.reverseShares.modal.expiration.minute-singular": "Minut",
  "account.reverseShares.modal.expiration.minute-plural": "Minute",
  "account.reverseShares.modal.expiration.hour-singular": "Sat",
  "account.reverseShares.modal.expiration.hour-plural": "Sati",
  "account.reverseShares.modal.expiration.day-singular": "Dan",
  "account.reverseShares.modal.expiration.day-plural": "Dani",
  "account.reverseShares.modal.expiration.week-singular": "Sedmica",
  "account.reverseShares.modal.expiration.week-plural": "Sedmice",
  "account.reverseShares.modal.expiration.month-singular": "Mesec",
  "account.reverseShares.modal.expiration.month-plural": "Meseci",
  "account.reverseShares.modal.expiration.year-singular": "Godina",
  "account.reverseShares.modal.expiration.year-plural": "Godine",
  "account.reverseShares.modal.max-size.label": "Maksimalna veličina deljenja",
  "account.reverseShares.modal.send-email": "Pošalji obaveštenja i-mejlom",
  "account.reverseShares.modal.send-email.description": "Pošalji obaveštenje imejlom kada se kreira deljenje pomoću ove obrnute veze za deljenje.",
  "account.reverseShares.modal.simplified": "Jednostavan režim",
  "account.reverseShares.modal.simplified.description": "Olakšajte osobi koja otprema fajl da ga podeli sa vama. Oni će moći da prilagode samo ime i opis deljenja.",
  "account.reverseShares.modal.public-access": "Javni pristup",
  "account.reverseShares.modal.public-access.description": "Učini da deljenja kreirana ovim reverznim linkom za deljenje budu javna. Ako je onemogućeno, samo vi i kreator deljenja ćete imati pristup za pregled.",
  "account.reverseShares.modal.max-use.label": "Maksimalan broj korišćenja",
  "account.reverseShares.modal.max-use.description": "Maksimalan broj puta koji ovaj URL može da se koristi za pravljenje deljenja.",
  "account.reverseShare.never-expires": "Ovo obrnuto deljenje nikada neće isteći.",
  "account.reverseShare.expires-on": "Ovo obrnuto deljenje će isteći {expiration}.",
  "account.reverseShares.table.no-shares": "Još nema kreiranih deljenja",
  "account.reverseShares.table.count.singular": "deljenje",
  "account.reverseShares.table.count.plural": "deljenja",
  "account.reverseShares.table.shares": "Deljenja",
  "account.reverseShares.table.remaining": "Preostala upotreba",
  "account.reverseShares.table.max-size": "Maksimalna veličina deljenja",
  "account.reverseShares.table.expires": "Ističe u",
  "account.reverseShares.modal.reverse-share-link": "Link za obrnuto deljenje",
  "account.reverseShares.modal.delete.title": "Obrišite obrnuto deljenje",
  "account.reverseShares.modal.delete.description": "Da li zaista želite da izbrišete ovo obrnuto deljenje? Ako to učinite, pridružena deljenja će takođe biti izbrisana.",
  // END /account/reverseShares
  // /admin
  "admin.title": "Administracija",
  "admin.button.users": "Upravljanje korisnicima",
  "admin.button.shares": "Upravljanje deljenjem",
  "admin.button.config": "Konfiguracija",
  "admin.version": "Verzija",
  // END /admin
  // /admin/users
  "admin.users.title": "Upravljanje korisnicima",
  "admin.users.table.username": "Korisničko ime",
  "admin.users.table.email": "Imejl",
  "admin.users.table.admin": "Admin",
  "admin.users.edit.update.title": "Uredite korisnika: {username}",
  "admin.users.edit.update.admin-privileges": "Administratorske privilegije",
  "admin.users.edit.update.change-password.title": "Promenite lozinku",
  "admin.users.edit.update.change-password.field": "Nova lozinka",
  "admin.users.edit.update.change-password.button": "Snimite novu lozinku",
  "admin.users.edit.update.notify.password.success": "Lozinka je uspešno promenjena",
  "admin.users.edit.delete.title": "Obrišite korisnika: {username} ?",
  "admin.users.edit.delete.description": "Da li zaista želite da obrišete ovog korisnika i sva njegova deljenja?",
  // showCreateUserModal.tsx
  "admin.users.modal.create.title": "Kreiraj korisnika",
  "admin.users.modal.create.username": "Korisničko ime",
  "admin.users.modal.create.email": "Imejl",
  "admin.users.modal.create.password": "Lozinka",
  "admin.users.modal.create.manual-password": "Postavite lozinku ručno",
  "admin.users.modal.create.manual-password.description": "Ako nije označeno, korisnik će dobiti imejl sa vezom za postavljanje lozinke.",
  "admin.users.modal.create.admin": "Administratorske privilegije",
  "admin.users.modal.create.admin.description": "Ako je označeno, korisnik će moći da pristupi administrativnom panelu.",
  // END /admin/users
  // /admin/shares
  "admin.shares.title": "Upravljanje deljenjem",
  "admin.shares.table.id": "ID deljenja",
  "admin.shares.table.username": "Kreator",
  "admin.shares.table.visitors": "Posetioci",
  "admin.shares.table.expires": "Ističe",
  "admin.shares.edit.delete.title": "Obriši deljenje: {id}",
  "admin.shares.edit.delete.description": "Da li zaista želite da obrišete ovo deljenje?",
  // END /admin/shares
  // /upload
  "upload.title": "Pošalji",
  "upload.notify.confirm-leave": "Da li ste sigurni da želite da napustite ovu stranicu? Vaše otpremanje će biti otkazano.",
  "upload.notify.generic-error": "Došlo je do greške pri dovršavanju deljenja.",
  "upload.notify.count-failed": "Otpremanje {count} datoteka nije uspelo. Pokušavam ponovo.",
  "upload.reverse-share.error.invalid.title": "Nepravilan link za obrnuto deljenje",
  "upload.reverse-share.error.invalid.description": "Ovo obrnuto deljenje je isteklo ili je nevažeće.",
  // Dropzone.tsx
  "upload.dropzone.title": "Pošalji datoteke",
  "upload.dropzone.description": "Prevucite i otpustite datoteke ovde da biste započeli deljenje. Prihvatamo samo fajlove ukupne veličine do {maxSize}.",
  "upload.dropzone.notify.file-too-big": "Vaše datoteke premašuju maksimalnu veličinu deljenja od {maxSize}.",
  // FileList.tsx
  "upload.filelist.name": "Naziv",
  "upload.filelist.size": "Veličina",
  // showCreateUploadModal.tsx
  "upload.modal.title": "Napravi deljenje",
  "upload.modal.link.error.invalid": "Može da sadrži samo slova, brojeve, donje crte i crtice",
  "upload.modal.link.error.taken": "Ovaj link je već u upotrebi",
  "upload.modal.not-signed-in": "Niste prijavljeni",
  "upload.modal.not-signed-in-description": "Nećete moći ručno da izbrišete svoje deljenje i vidite broj posetilaca.",
  "upload.modal.expires.never": "nikad",
  "upload.modal.expires.never-long": "Trajno deljenje",
  "upload.modal.expires.error.too-long": "Datum isteka prevazilazi maksimalnu vrednost od {max}.",
  "upload.modal.link.label": "Link",
  "upload.modal.expires.label": "Ističe",
  "upload.modal.expires.minute-singular": "Minut",
  "upload.modal.expires.minute-plural": "Minute",
  "upload.modal.expires.hour-singular": "Sat",
  "upload.modal.expires.hour-plural": "Sati",
  "upload.modal.expires.day-singular": "Dan",
  "upload.modal.expires.day-plural": "Dani",
  "upload.modal.expires.week-singular": "Sedmica",
  "upload.modal.expires.week-plural": "Sedmice",
  "upload.modal.expires.month-singular": "Mesec",
  "upload.modal.expires.month-plural": "Meseci",
  "upload.modal.expires.year-singular": "Godina",
  "upload.modal.expires.year-plural": "Godine",
  "upload.modal.accordion.name-and-description.title": "Ime i opis",
  "upload.modal.accordion.name-and-description.name.placeholder": "Ime",
  "upload.modal.accordion.name-and-description.description.placeholder": "Napomena za primaoce ovog deljenja",
  "upload.modal.accordion.email.title": "Primaoci imejla",
  "upload.modal.accordion.email.placeholder": "Unesite primaoce imejla",
  "upload.modal.accordion.email.invalid-email": "Neispravna adresa imejla",
  "upload.modal.accordion.security.title": "Sigurnosna podešavanja",
  "upload.modal.accordion.security.password.label": "Zaštita lozinkom",
  "upload.modal.accordion.security.password.placeholder": "Nema lozinke",
  "upload.modal.accordion.security.max-views.label": "Maksimalan broj pregleda",
  "upload.modal.accordion.security.max-views.placeholder": "Bez limita",
  // showCompletedUploadModal.tsx
  "upload.modal.completed.never-expires": "Ovo deljenje nikada neće isteći.",
  "upload.modal.completed.expires-on": "Ovo deljenje će isteći {expiration}.",
  "upload.modal.completed.share-ready": "Deljenje je spremno",
  "upload.modal.completed.notified-reverse-share-creator": "Obavestili smo kreatora reverznog deljenja. Takođe možete ručno podeliti ovaj link sa njima na druge načine.",
  // END /upload
  // /share/[id]
  "share.title": "Deljenje {shareId}",
  "share.description": "Pogledajte šta sam podelio sa vama!",
  "share.error.visitor-limit-exceeded.title": "Prekoračeno je ograničenje posetilaca",
  "share.error.visitor-limit-exceeded.description": "Ograničenje posetilaca iz ovog deljenja je premašeno.",
  "share.error.removed.title": "Deljenje je uklonjeno",
  "share.error.not-found.title": "Deljenje nije pronađeno",
  "share.error.not-found.description": "Udeo koji tražite ne postoji.",
  "share.error.access-denied.title": "Privatno deljenje",
  "share.error.access-denied.description": "Trenutni nalog nema dozvolu za pristup ovom deljenju",
  "share.modal.password.title": "Obavezna lozinka",
  "share.modal.password.description": "Molimo unesite lozinku za pristup ovom deljenju.",
  "share.modal.password": "Lozinka",
  "share.modal.error.invalid-password": "Neispravna lozinka",
  "share.button.download-all": "Preuzmi sve",
  "share.notify.download-all-preparing": "Deljenje se priprema. Molimo pokušajte ponovo za nekoliko minuta.",
  "share.modal.file-link": "Veza datoteke",
  "share.table.name": "Naziv",
  "share.table.size": "Veličina",
  "share.modal.file-preview.error.not-supported.title": "Pregled nije podržan",
  "share.modal.file-preview.error.not-supported.description": "Pregledi nisu podržani za ovaj tip datoteka. Molimo preuzmite fajl da biste ga pregledali.",
  // END /share/[id]
  // /share/[id]/edit
  "share.edit.title": "Uredi {shareId}",
  "share.edit.append-upload": "Nadodaj fajl",
  "share.edit.notify.generic-error": "Došlo je do greške prilikom završetka vašeg deljenja.",
  "share.edit.notify.save-success": "Deljenje je uspešno ažurirano",
  // END /share/[id]/edit
  // /imprint
  "imprint.title": "Imprint",
  // END /imprint
  // /privacy
  "privacy.title": "Privacy Policy",
  // END /privacy
  // /admin/config
  "admin.config.title": "Konfiguracija",
  "admin.config.category.general": "Opšte",
  "admin.config.category.share": "Deljenje",
  "admin.config.category.email": "Imejl",
  "admin.config.category.smtp": "SMTP",
  "admin.config.category.oauth": "Social login",
  "admin.config.general.app-name": "Naziv aplikacije",
  "admin.config.general.app-name.description": "Naziv aplikacije",
  "admin.config.general.app-url": "URL aplikacije",
  "admin.config.general.app-url.description": "Na kojoj URL adresi je dostupan Pingvin Share",
  "admin.config.general.secure-cookies": "Bezbedni kolačići",
  "admin.config.general.secure-cookies.description": "Da li želite da postavite zastavicu za bezbednost na kolačiće? Ako je omogućeno, sajt neće funkcionisati kada mu pristupate preko HTTP-a.",
  "admin.config.general.show-home-page": "Prikaži početnu stranicu",
  "admin.config.general.show-home-page.description": "Da li da se prikaže početna stranica",
  "admin.config.general.session-duration": "Trajanje sesije",
  "admin.config.general.session-duration.description": "Vreme u satima nakon kojeg korisnik mora ponovo da se prijavi (podrazumevano: 3 meseca).",
  "admin.config.general.logo": "Logo",
  "admin.config.general.logo.description": "Promenite svoj logotip tako što ćete otpremiti novu sliku. Slika mora da bude PNG i treba da ima format 1:1.",
  "admin.config.general.logo.placeholder": "Izaberi sliku",
  "admin.config.email.enable-share-email-recipients": "Omogući deljenje sa primaocima imejlom",
  "admin.config.email.enable-share-email-recipients.description": "Da li dozvoliti deljenje sa primaocima putem imejla. Omogućite ovo samo ako je SMTP aktiviran.",
  "admin.config.email.share-recipients-subject": "Podelite naslov primaoca",
  "admin.config.email.share-recipients-subject.description": "Tema imejla koja se šalje primaocima deljenja.",
  "admin.config.email.share-recipients-message": "Delite poruku primaoca",
  "admin.config.email.share-recipients-message.description": "Poruka koja se šalje primaocima deljenja. Dostupne promenljive:\n{creator} - Korisničko ime kreatora deljenja\n{creatorEmail} - Imejl kreatora deljenja\n{shareUrl} - URL deljenja\n{desc} - Opis deljenja\n{expires} - Datum isteka deljenja\nOve promenljive će biti zamenjene stvarnim vrednostima.",
  "admin.config.email.reverse-share-subject": "Tema obrnutog deljenja",
  "admin.config.email.reverse-share-subject.description": "Naslov imejla koji se šalje kada neko kreira deljenje sa vašim reverznim linkom za deljenje.",
  "admin.config.email.reverse-share-message": "Obrnuto deljenje poruka",
  "admin.config.email.reverse-share-message.description": "Poruka koja se šalje kada je neko napravio deljenje sa vašom obrnutom vezom za deljenje. {shareUrl} će biti zamenjen imenom kreatora i URL-om za deljenje.",
  "admin.config.email.reset-password-subject": "Resetujte temu lozinke",
  "admin.config.email.reset-password-subject.description": "Naslov imejla koji se šalje kada korisnik zatraži resetovanje lozinke.",
  "admin.config.email.reset-password-message": "Poruka za resetovanje lozinke",
  "admin.config.email.reset-password-message.description": "Poruka koja se šalje kada korisnik zatraži resetovanje lozinke. {url} će biti zamenjen linkom za resetovanje lozinke.",
  "admin.config.email.invite-subject": "Pozivna tema",
  "admin.config.email.invite-subject.description": "Naslov e-pošte koja se šalje kada administrator pozove korisnika.",
  "admin.config.email.invite-message": "Pozivna poruka",
  "admin.config.email.invite-message.description": "Poruka koja se šalje kada administrator pozove korisnika. {url} će biti zamenjen linkom za poziv, {email} imejlom, a {password} lozinkom korisnika.",
  "admin.config.share.allow-registration": "Dozvoli registraciju",
  "admin.config.share.allow-registration.description": "Da li je registracija dozvoljena",
  "admin.config.share.allow-unauthenticated-shares": "Dozvoli deljenje bez autentifikacije",
  "admin.config.share.allow-unauthenticated-shares.description": "Da li korisnici bez autentifikacije mogu da kreiraju deljenja",
  "admin.config.share.max-expiration": "Maksimalni rok trajanja",
  "admin.config.share.max-expiration.description": "Maximum share expiration. Set to 0 to allow unlimited expiration.",
  "admin.config.share.share-id-length": "Dužina podrazumevanog ID-a za deljenje",
  "admin.config.share.share-id-length.description": "Podrazumevana dužina generisanog ID-a za deljenje. Ova vrednost se takođe koristi za generisanje linkova za obrnuto deljenje. Vrednost ispod 8 se ne smatra bezbednom.",
  "admin.config.share.max-size": "Maksimalna veličina",
  "admin.config.share.max-size.description": "Maksimalna veličina deljenja",
  "admin.config.share.zip-compression-level": "Nivo Zip kompresije",
  "admin.config.share.zip-compression-level.description": "Podesite nivo da biste balansirali između veličine datoteke i brzine kompresije. Važeće vrednosti se kreću od 0 do 9, pri čemu je 0 bez kompresije, a 9 je maksimalna kompresija. ",
  "admin.config.share.chunk-size": "Veličina komada",
  "admin.config.share.chunk-size.description": "Podesite veličinu dela za vaša otpremanje kako biste uravnotežili efikasnost i pouzdanost u skladu sa vašom internet vezom. Manji delovi mogu poboljšati stopu uspeha za nestabilne veze, dok veći delovi omogućavaju brže otpremanje za stabilne veze.",
  "admin.config.share.auto-open-share-modal": "Automatski otvori stvaranje modala deljenja",
  "admin.config.share.auto-open-share-modal.description": "Modal za kreiranje deljenja automatski se pojavljuje kada korisnik izabere datoteke, eliminišući potrebu za ručnim klikom na dugme.",
  "admin.config.smtp.enabled": "Omogući",
  "admin.config.smtp.enabled.description": "Da li je SMTP omogućen. Postavite ovo na tačno samo ako ste uneli host, port, imejl, korisnika i lozinku vašeg SMTP servera.",
  "admin.config.smtp.host": "Domaćin",
  "admin.config.smtp.host.description": "Domaćin SMTP servera",
  "admin.config.smtp.port": "Port",
  "admin.config.smtp.port.description": "Port domaćina SMTP servera",
  "admin.config.smtp.email": "Imejl",
  "admin.config.smtp.email.description": "Adresa imejla sa kojeg se poruke šalju",
  "admin.config.smtp.username": "Korisničko ime",
  "admin.config.smtp.username.description": "Korisničko ime SMTP servera",
  "admin.config.smtp.password": "Lozinka",
  "admin.config.smtp.password.description": "Lozinka SMTP servera",
  "admin.config.smtp.button.test": "Pošalji testni imejl",
  "admin.config.smtp.allow-unauthorized-certificates": "Verovanje neautorizovanim SMTP serverskim sertifikatima",
  "admin.config.smtp.allow-unauthorized-certificates.description": "Ovo postavite na \"istina\" samo ako je potrebno verovati samo-potpisanim sertifikatima.",
  "admin.config.oauth.allow-registration": "Dozvoli registraciju",
  "admin.config.oauth.allow-registration.description": "Dozvolite korisnicima da se registruju putem društvene prijave",
  "admin.config.oauth.ignore-totp": "Zanemari TOTP",
  "admin.config.oauth.ignore-totp.description": "Da li da ignorišete TOTP kada korisnik koristi prijavu na društvenim mrežama",
  "admin.config.oauth.disable-password": "Onemogućite prijavu lozinkom",
  "admin.config.oauth.disable-password.description": "Omogućiti prijavu lozinkom ili ne\nUverite se da je provajder za OAuth pravilno konfigurisan pre aktiviranja ove konfiguracije kako biste izbegli zaključavanje naloga.",
  "admin.config.oauth.github-enabled": "GitHub",
  "admin.config.oauth.github-enabled.description": "Da li je prijavljivanje na GitHub omogućeno",
  "admin.config.oauth.github-client-id": "GitHub ID klijenta",
  "admin.config.oauth.github-client-id.description": "ID klijenta GitHub OAuth aplikacije",
  "admin.config.oauth.github-client-secret": "Tajna GitHub klijenta",
  "admin.config.oauth.github-client-secret.description": "Tajna klijenta GitHub OAuth aplikacije",
  "admin.config.oauth.google-enabled": "Google",
  "admin.config.oauth.google-enabled.description": "Da li je prijavljivanje na Google omogućeno",
  "admin.config.oauth.google-client-id": "ID Google klijenta",
  "admin.config.oauth.google-client-id.description": "ID klijenta Google OAuth aplikacije",
  "admin.config.oauth.google-client-secret": "Tajna Google klijenta",
  "admin.config.oauth.google-client-secret.description": "Tajna klijenta Google OAuth aplikacije",
  "admin.config.oauth.microsoft-enabled": "Microsoft",
  "admin.config.oauth.microsoft-enabled.description": "Da li je prijavljivanje na Microsoft omogućeno",
  "admin.config.oauth.microsoft-tenant": "Microsoft Tenant",
  "admin.config.oauth.microsoft-tenant.description": "ID zakupca za Microsoft OAuth aplikaciju\nuobičajeno: Korisnici sa ličnim Microsoft nalogom i poslovnim ili školskim nalogom sa Microsoft Entra ID-a mogu da se prijave u aplikaciju. organizacije: Samo korisnici sa poslovnim ili školskim nalozima sa Microsoft Entra ID-a mogu da se prijave u aplikaciju.\npotrošači: Samo korisnici sa ličnim Microsoft nalogom mogu da se prijave u aplikaciju.\nime domena zakupca Microsoft Entra ID ili ID zakupca u GUID formatu: Samo korisnici iz određenog Microsoft Entra ID stanara (članovi direktorijuma sa poslovnim ili školskim nalogom ili gosti direktorijuma sa ličnim Microsoft nalogom) mogu da se prijave u aplikaciju.",
  "admin.config.oauth.microsoft-client-id": "Microsoft ID klijenta",
  "admin.config.oauth.microsoft-client-id.description": "ID klijenta Microsoft OAuth aplikacije",
  "admin.config.oauth.microsoft-client-secret": "Tajna Microsoft klijenta",
  "admin.config.oauth.microsoft-client-secret.description": "Tajna klijenta za Microsot OAuth aplikaciju",
  "admin.config.oauth.discord-enabled": "Discord",
  "admin.config.oauth.discord-enabled.description": "Da li je prijavljivanje na Discord omogućeno",
  "admin.config.oauth.discord-limited-users": "Ograničenje po Discord korisnicima",
  "admin.config.oauth.discord-limited-users.description": "Ograničite prijavljivanje na određene korisnike pomoću njihovog Discord ID-a. Ostavite prazno da biste onemogućili.",
  "admin.config.oauth.discord-limited-guild": "Ograničenje po Discord serveru",
  "admin.config.oauth.discord-limited-guild.description": "Ograničite prijavljivanje na korisnike određenog servera. Ostavite prazno da biste onemogućili.",
  "admin.config.oauth.discord-client-id": "Discord ID klijenta",
  "admin.config.oauth.discord-client-id.description": "ID klijenta Discord OAuth aplikacije",
  "admin.config.oauth.discord-client-secret": "Discord klijent tajna",
  "admin.config.oauth.discord-client-secret.description": "Tajna klijenta Discord OAuth aplikacije",
  "admin.config.oauth.oidc-enabled": "OpenId Connect",
  "admin.config.oauth.oidc-enabled.description": "Omogućiti prijavu OpenID Connect-om ili ne",
  "admin.config.oauth.oidc-discovery-uri": "URI za OpenID Connect Discovery",
  "admin.config.oauth.oidc-discovery-uri.description": "Discovery URI za otkrivanje OpenID Connect OAuth aplikacije",
  "admin.config.oauth.oidc-sign-out": "Odjavljivanje sa OpenID Connect-a",
  "admin.config.oauth.oidc-sign-out.description": "Da li će dugme „Odjavi se“ odjaviti korisnika i sa OpenID Connect provajdera",
  "admin.config.oauth.oidc-scope": "Opseg OpenID Connect-a",
  "admin.config.oauth.oidc-scope.description": "Opsezi koji bi trebalo da budu zatraženi od OpenID Connect provajdera.",
  "admin.config.oauth.oidc-username-claim": "Potraživanje korisničkog imena u OpenID Connect",
  "admin.config.oauth.oidc-username-claim.description": "Potraživanje korisničkog imena u OpenID Connect ID tokenu. Ostavite prazno ako ne znate šta je ova konfiguracija.",
  "admin.config.oauth.oidc-role-path": "Putanja do uloga u OpenID Connect tokenu",
  "admin.config.oauth.oidc-role-path.description": "Mora biti validna JMES putanja koja referencira niz uloga. " + "Upravljanje pravima pristupa pomoću uloga u OpenID Connect-u se preporučuje samo ako nijedan drugi provajder identiteta nije konfigurisan i ako je prijava lozinkom onemogućena. " + "Ostavite prazno ako ne znate šta je ova konfiguracija.",
  "admin.config.oauth.oidc-role-general-access": "Uloga u OpenID Connect-u za opšti pristup",
  "admin.config.oauth.oidc-role-general-access.description": "Uloga potrebna za opšti pristup. Mora biti prisutna u ulogama korisnika kako bi se mogao prijaviti. " + "Ostavite prazno ako ne znate šta je ova konfiguracija.",
  "admin.config.oauth.oidc-role-admin-access": "Uloga u OpenID Connect-u za administratorski pristup",
  "admin.config.oauth.oidc-role-admin-access.description": "Uloga potrebna za administratorski pristup. Mora biti prisutna u ulogama korisnika kako bi mogli pristupiti administratorskom panelu. " + "Ostavite prazno ako ne znate šta je ova konfiguracija.",
  "admin.config.oauth.oidc-client-id": "OpenID Connect ID klijenta",
  "admin.config.oauth.oidc-client-id.description": "ID klijenta OpenID Connect OAuth aplikacije",
  "admin.config.oauth.oidc-client-secret": "OpenID Connect tajna klijenta",
  "admin.config.oauth.oidc-client-secret.description": "Tajna klijenta OpenID Connect OAuth aplikacije",
  "admin.config.category.ldap": "LDAP",
  "admin.config.ldap.enabled": "Omogući LDAP",
  "admin.config.ldap.enabled.description": "Koristi LDAP autentifikaciju za prijavu korisnika",
  "admin.config.ldap.url": "URL servera",
  "admin.config.ldap.url.description": "URL LDAP servera",
  "admin.config.ldap.bind-dn": "DN vezivanje",
  "admin.config.ldap.bind-dn.description": "Podrazumevani korisnik koji se koristi za pretragu korisnika",
  "admin.config.ldap.bind-password": "Lozinka za vezivanje",
  "admin.config.ldap.bind-password.description": "Lozinka koja se koristi za izvršavanje pretrage korisnika",
  "admin.config.ldap.search-base": "Baza korisnika",
  "admin.config.ldap.search-base.description": "Lokacija baze, mesto gde će se izvršiti pretraga korisnika",
  "admin.config.ldap.search-query": "Upit za korisnika",
  "admin.config.ldap.search-query.description": "Upit za korisnika koji će se koristiti za pretragu „Baze korisnika“ za LDAP korisnika. %username% se može koristiti kao oznaka za unos korisnika.",
  "admin.config.ldap.admin-groups": "Administratorska grupa",
  "admin.config.ldap.admin-groups.description": "Grupa koja je potrebna za administratorski pristup.",
  "admin.config.ldap.field-name-member-of": "Naziv atributa korisničkih grupa",
  "admin.config.ldap.field-name-member-of.description": "LDAP naziv atributa za grupe čiji je korisnik član. Ovo se koristi pri proveri administratorske grupe.",
  "admin.config.ldap.field-name-email": "Naziv atributa za imejl korisnika",
  "admin.config.ldap.field-name-email.description": "LDAP naziv atributa za imejl korisnika.",
  "admin.config.notify.success": "Konfiguracija je uspešno ažurirana.",
  "admin.config.notify.logo-success": "Logo je uspešno ažuriran. Može biti potrebno nekoliko minuta da se ažurira na vebsajtu.",
  "admin.config.notify.no-changes": "Nema promena za čuvanje.",
  "admin.config.category.s3": "S3",
  "admin.config.s3.enabled": "Enabled",
  "admin.config.s3.enabled.description": "Whether S3 should be used to store the shared files instead of the local file system.",
  "admin.config.s3.endpoint": "Endpoint",
  "admin.config.s3.endpoint.description": "The URL of the S3 bucket.",
  "admin.config.s3.region": "Region",
  "admin.config.s3.region.description": "The region of the S3 bucket.",
  "admin.config.s3.bucket-name": "Bucket name",
  "admin.config.s3.bucket-name.description": "The name of the S3 bucket.",
  "admin.config.s3.bucket-path": "Path",
  "admin.config.s3.bucket-path.description": "The default path which should be used to store the files in the S3 bucket.",
  "admin.config.s3.key": "Key",
  "admin.config.s3.key.description": "The key which allows you to access the S3 bucket.",
  "admin.config.s3.secret": "Secret",
  "admin.config.s3.secret.description": "The secret which allows you to access the S3 bucket.",
  "admin.config.category.legal": "Legal",
  "admin.config.legal.enabled": "Enable legal notices",
  "admin.config.legal.enabled.description": "Whether to show a link to imprint and privacy policy in the footer.",
  "admin.config.legal.imprint-text": "Imprint text",
  "admin.config.legal.imprint-text.description": "The text which should be shown in the imprint. Supports Markdown. Leave blank to link to an external imprint page.",
  "admin.config.legal.imprint-url": "Imprint URL",
  "admin.config.legal.imprint-url.description": "If you already have an imprint page you can link it here instead of using the text field.",
  "admin.config.legal.privacy-policy-text": "Privacy policy text",
  "admin.config.legal.privacy-policy-text.description": "The text which should be shown in the privacy policy. Supports Markdown. Leave blank to link to an external privacy policy page.",
  "admin.config.legal.privacy-policy-url": "Privacy policy URL",
  "admin.config.legal.privacy-policy-url.description": "If you already have a privacy policy page you can link it here instead of using the text field.",
  // 404
  "404.description": "Opa - Ova strana ne postoji.",
  "404.button.home": "Vrati me na početak",
  // error
  "error.title": "Greška",
  "error.description": "Ups!",
  "error.button.back": "Idi nazad",
  "error.msg.default": "Nešto je pošlo naopako.",
  "error.msg.access_denied": "Otkazali ste proces autentifikacije, pokušajte ponovo.",
  "error.msg.expired_token": "Proces autentifikacije je trajao predugo, pokušajte ponovo.",
  "error.msg.invalid_token": "Interna greška",
  "error.msg.no_user": "Korisnik povezan sa ovim {0} nalogom ne postoji.",
  "error.msg.no_email": "Ne mogu da dobijem adresu imejla sa ovog {0} naloga.",
  "error.msg.already_linked": "Ovaj {0} nalog je već povezan sa drugim nalogom.",
  "error.msg.not_linked": "Ovaj {0} nalog još uvek nije povezan ni sa jednim nalogom.",
  "error.msg.unverified_account": "Ovaj {0} nalog je nepotvrđen, molimo pokušajte ponovo nakon verifikacije.",
  "error.msg.user_not_allowed": "Nije vam dozvoljeno da se prijavite.",
  "error.msg.cannot_get_user_info": "Ne mogu da dobijem vaše korisničke informacije sa ovog {0} naloga.",
  "error.param.provider_github": "GitHub",
  "error.param.provider_google": "Google",
  "error.param.provider_microsoft": "Microsoft",
  "error.param.provider_discord": "Discord",
  "error.param.provider_oidc": "OpenId Connect",
  // Common translations
  "common.button.save": "Sačuvaj",
  "common.button.create": "Napravi",
  "common.button.submit": "Pošalji",
  "common.button.delete": "Obriši",
  "common.button.cancel": "Otkaži",
  "common.button.confirm": "Potvrdi",
  "common.button.disable": "Onemogući",
  "common.button.share": "Deljenje",
  "common.button.generate": "Generiši",
  "common.button.done": "Gotovo",
  "common.text.link": "Link",
  "common.text.navigate-to-link": "Posetite link",
  "common.text.or": "ili",
  "common.text.redirecting": "Preusmeravanje...",
  "common.button.go-back": "Idi nazad",
  "common.button.go-home": "Početna stranica",
  "common.notify.copied": "Vaša veza je kopirana u međuspremnik",
  "common.notify.copied-link": "Vaša veza je kopirana u međuspremnik",
  "common.success": "Uspešno",
  "common.error": "Greška",
  "common.error.unknown": "Došlo je do nepoznate greške",
  "common.error.invalid-email": "Neispravna adresa imejla",
  "common.error.too-short": "Mora da ima najmanje {length} znakova",
  "common.error.too-long": "Mora da ima najviše {length} znakova",
  "common.error.number-too-small": "Mora biti najmanje {min}",
  "common.error.number-too-large": "Mora biti najviše {max}",
  "common.error.exact-length": "Mora da ima tačno {length} znakova",
  "common.error.invalid-number": "Mora biti broj",
  "common.error.field-required": "Polje je obavezno"
};