export default {
  // Navbar
  "navbar.upload": "Загрузить",
  "navbar.signin": "Вход",
  "navbar.home": "Главная",
  "navbar.signup": "Sign up",
  "navbar.links.shares": "Мои загрузки",
  "navbar.links.reverse": "Обратные загрузки",
  "navbar.avatar.account": "Мой аккаунт",
  "navbar.avatar.admin": "Администрирование",
  "navbar.avatar.signout": "Выйти",
  // END navbar
  // /
  "home.title": "Платформа для обмена файлами с <h>собственного хостинга</h>.",
  "home.description": "Вы действительно хотите предоставить свои личные файлы в руки третьих лиц, таких как WeTransfer?",
  "home.bullet.a.name": "На собственном сервере",
  "home.bullet.a.description": "Pingvin Share работает на вашей машине.",
  "home.bullet.b.name": "Конфиденциальность",
  "home.bullet.b.description": "Ваши файлы принадлежат защищены от действия третьих лиц.",
  "home.bullet.c.name": "Без раздражающего ограничения размера файла",
  "home.bullet.c.description": "Загружайте файлы любого размера. Ваш жёсткий диск - это ваше ограничение.",
  "home.button.start": "Начнем",
  "home.button.source": "Исходный код",
  // END /
  // /auth/signin
  "signin.title": "С возвращением",
  "signin.description": "У вас еще нет учетной записи?",
  "signin.button.signup": "Зарегистрироваться",
  "signin.input.email-or-username": "Email или логин",
  "signin.input.email-or-username.placeholder": "Эл. почта или логин",
  "signin.input.password": "Пароль",
  "signin.input.password.placeholder": "Ваш пароль",
  "signin.button.submit": "Вход",
  "signIn.notify.totp-required.title": "Требуется двухфакторная аутентификация",
  "signIn.notify.totp-required.description": "Пожалуйста, введите код Вашей 2-х факторной аутентификации",
  "signIn.oauth.or": "ИЛИ",
  "signIn.oauth.signInWith": "Войдите с помощью",
  "signIn.oauth.github": "GitHub",
  "signIn.oauth.google": "Google",
  "signIn.oauth.microsoft": "Microsoft",
  "signIn.oauth.discord": "Discord",
  "signIn.oauth.oidc": "OpenID",
  // END /auth/signin
  // /auth/signup
  "signup.title": "Создать аккаунт",
  "signup.description": "Уже есть учётная запись?",
  "signup.button.signin": "Вход",
  "signup.input.username": "Логин",
  "signup.input.username.placeholder": "Ваш логин (имя пользователя)",
  "signup.input.email": "Электронная почта",
  "signup.input.email.placeholder": "Адрес эл. почты",
  "signup.button.submit": "Давайте начнём",
  // END /auth/signup
  // /auth/totp
  "totp.title": "Авторизация TOTP",
  "totp.button.signIn": "Войти",
  // END /auth/totp
  // /auth/reset-password
  "resetPassword.title": "Забыли пароль?",
  "resetPassword.description": "Введите ваш email для восстановления пароля.",
  "resetPassword.notify.success": "На указанный адрес электронной почты, будет направлено письмо для сброса пароля.",
  "resetPassword.button.back": "Вернуться на страницу входа",
  "resetPassword.text.resetPassword": "Сбросить пароль",
  "resetPassword.text.enterNewPassword": "Введите новый пароль",
  "resetPassword.input.password": "Новый пароль",
  "resetPassword.notify.passwordReset": "Ваш пароль успешно изменён.",
  // /account
  "account.title": "Мой аккаунт",
  "account.card.info.title": "Информация об аккаунте",
  "account.card.info.username": "Логин",
  "account.card.info.email": "Электронная почта",
  "account.notify.info.success": "Настройки учетной записи успешно обновлены",
  "account.card.password.title": "Пароль",
  "account.card.password.old": "Старый пароль",
  "account.card.password.new": "Новый пароль",
  "account.card.password.noPasswordSet": "У вас не установлен пароль. Чтобы войти в систему, используя свой адрес электронной почты и пароль, вам необходимо создать пароль.",
  "account.notify.password.success": "Пароль успешно изменён",
  "account.card.oauth.title": "Авторизация через социальные сети",
  "account.card.oauth.github": "GitHub",
  "account.card.oauth.google": "Google",
  "account.card.oauth.microsoft": "Microsoft",
  "account.card.oauth.discord": "Discord",
  "account.card.oauth.oidc": "OpenID",
  "account.card.oauth.link": "Подключить",
  "account.card.oauth.unlink": "Отключить",
  "account.card.oauth.unlinked": "Отключен",
  "account.modal.unlink.title": "Отключить связь с учетной записью",
  "account.modal.unlink.description": "Отключение связи с вашими аккаунтами в социальных сетях может привести к потере вашей учетной записи, если вы не помните свои учетные данные для входа",
  "account.notify.oauth.unlinked.success": "Отключение прошло успешно",
  "account.card.security.title": "Безопасность",
  "account.card.security.totp.enable.description": "Введите ваш текущий пароль для начала включения TOTP",
  "account.card.security.totp.disable.description": "Введите ваш текущий пароль, чтобы отключить TOTP",
  "account.card.security.totp.button.start": "Начать",
  "account.modal.totp.title": "Включить TOTP",
  "account.modal.totp.step1": "Шаг 1: Добавьте свой аутентификатор",
  "account.modal.totp.step2": "Шаг 2: Проверка кода",
  "account.modal.totp.enterManually": "Ввести вручную",
  "account.modal.totp.code": "Код",
  "common.button.clickToCopy": "Нажмите, чтобы скопировать",
  "account.modal.totp.verify": "Подтвердить",
  "account.notify.totp.disable": "TOTP успешно отключен",
  "account.notify.totp.enable": "TOTP успешно включен",
  "account.card.language.title": "Язык",
  "account.card.language.description": "Проект переведен сообществом. Некоторые языки могут быть неполными.",
  "account.card.color.title": "Цветовая схема",
  // ThemeSwitcher.tsx
  "account.theme.dark": "Тёмная",
  "account.theme.light": "Светлая",
  "account.theme.system": "Системная",
  "account.button.delete": "Удалить аккаунт",
  "account.modal.delete.title": "Удалить аккаунт",
  "account.modal.delete.description": "Вы действительно хотите удалить свою учетную запись, включая все ваши загрузки?",
  // END /account
  // /account/shares
  "account.shares.title": "Мои загрузки",
  "account.shares.title.empty": "Тут пусто 👀",
  "account.shares.description.empty": "У вас нет загрузок.",
  "account.shares.button.create": "Создать одну",
  "account.shares.info.title": "Сведения",
  "account.shares.table.id": "ID",
  "account.shares.table.name": "Название",
  "account.shares.table.description": "Описание",
  "account.shares.table.visitors": "Посетителей",
  "account.shares.table.expiresAt": "Expires on",
  "account.shares.table.createdAt": "Created on",
  "account.shares.table.size": "Размер",
  "account.shares.table.password-protected": "Password protected",
  "account.shares.table.visitor-count": "{count} of {max}",
  "account.shares.table.expiry-never": "Never",
  "account.shares.modal.share-informations": "Сведения",
  "account.shares.modal.share-link": "Поделиться ссылкой",
  "account.shares.modal.delete.title": "Delete share: {share}",
  "account.shares.modal.delete.description": "Вы действительно хотите удалить эту загрузку?",
  // END /account/shares
  // /account/reverseShares
  "account.reverseShares.title": "Обратные загрузки",
  "account.reverseShares.description": "Обратная загрузка позволяет генерировать уникальный URL, позволяющий внешним пользователям загружать файлы.",
  "account.reverseShares.title.empty": "Тут пусто 👀",
  "account.reverseShares.description.empty": "У вас пока нет обратных загрузок.",
  // showCreateReverseShareModal.tsx
  "account.reverseShares.modal.title": "Создать обратную ссылку на файл",
  "account.reverseShares.modal.expiration.label": "Истекает",
  "account.reverseShares.modal.expiration.minute-singular": "Минута",
  "account.reverseShares.modal.expiration.minute-plural": "Минут(ы)",
  "account.reverseShares.modal.expiration.hour-singular": "Час",
  "account.reverseShares.modal.expiration.hour-plural": "Часов",
  "account.reverseShares.modal.expiration.day-singular": "День",
  "account.reverseShares.modal.expiration.day-plural": "Дней",
  "account.reverseShares.modal.expiration.week-singular": "Неделя",
  "account.reverseShares.modal.expiration.week-plural": "Недель",
  "account.reverseShares.modal.expiration.month-singular": "Месяц",
  "account.reverseShares.modal.expiration.month-plural": "Месяца(-ев)",
  "account.reverseShares.modal.expiration.year-singular": "Год",
  "account.reverseShares.modal.expiration.year-plural": "Года (лет)",
  "account.reverseShares.modal.max-size.label": "Макс. размер загрузки",
  "account.reverseShares.modal.send-email": "Отправлять уведомления по эл. почте",
  "account.reverseShares.modal.send-email.description": "Отправлять уведомление по электронной почте, когда загрузка создается с помощью этой обратной ссылки.",
  "account.reverseShares.modal.simplified": "Упрощенный режим",
  "account.reverseShares.modal.simplified.description": "Получатель приглашения легко сможет загружать файл для того, чтобы поделиться им с Вами. Они смогут только настроить имя и описание доли.",
  "account.reverseShares.modal.public-access": "Публичный доступ",
  "account.reverseShares.modal.public-access.description": "Сделать файлы общедоступными, созданные с этим обратным общим публичным доступом. Если отключено, только вы и создатель ресурса будут иметь доступ к ним для просмотра.",
  "account.reverseShares.modal.max-use.label": "Максимум использований",
  "account.reverseShares.modal.max-use.description": "Максимальное количество раз, когда URL может быть использован для создания загрузки.",
  "account.reverseShare.never-expires": "Эта обратная загрузка никогда не устареет.",
  "account.reverseShare.expires-on": "Эта обратная загрузка устареет {expiration}.",
  "account.reverseShares.table.no-shares": "Нет созданных загрузок",
  "account.reverseShares.table.count.singular": "загрузка",
  "account.reverseShares.table.count.plural": "загрузки",
  "account.reverseShares.table.shares": "Загрузки",
  "account.reverseShares.table.remaining": "Осталось использований",
  "account.reverseShares.table.max-size": "Макс. размер загрузки",
  "account.reverseShares.table.expires": "Действительно до",
  "account.reverseShares.modal.reverse-share-link": "Ссылка обратной загрузки",
  "account.reverseShares.modal.delete.title": "Удалить обратную загрузку",
  "account.reverseShares.modal.delete.description": "Вы действительно хотите удалить эту обратную загрузку? Если вы это сделаете, то все связанные обратные загрузки будут также удалены.",
  // END /account/reverseShares
  // /admin
  "admin.title": "Администрирование",
  "admin.button.users": "Управление пользователями",
  "admin.button.shares": "Share management",
  "admin.button.config": "Конфигурация",
  "admin.version": "Версия",
  // END /admin
  // /admin/users
  "admin.users.title": "Управление пользователями",
  "admin.users.table.username": "Логин",
  "admin.users.table.email": "Электронная почта",
  "admin.users.table.admin": "Администратор",
  "admin.users.edit.update.title": "Редактировать пользователя: {username}",
  "admin.users.edit.update.admin-privileges": "Права администратора",
  "admin.users.edit.update.change-password.title": "Изменить пароль",
  "admin.users.edit.update.change-password.field": "Новый пароль",
  "admin.users.edit.update.change-password.button": "Сохранить новый пароль",
  "admin.users.edit.update.notify.password.success": "Пароль успешно изменён",
  "admin.users.edit.delete.title": "Удалить пользователя {username} ?",
  "admin.users.edit.delete.description": "Вы действительно хотите удалить этого пользователя и все его загрузки?",
  // showCreateUserModal.tsx
  "admin.users.modal.create.title": "Создать пользователя",
  "admin.users.modal.create.username": "Логин",
  "admin.users.modal.create.email": "Электронная почта",
  "admin.users.modal.create.password": "Пароль",
  "admin.users.modal.create.manual-password": "Установить пароль вручную",
  "admin.users.modal.create.manual-password.description": "Если флажок не установлен, пользователь получит письмо со ссылкой для установки пароля.",
  "admin.users.modal.create.admin": "Права администратора",
  "admin.users.modal.create.admin.description": "Если отмечено, пользователь будет иметь доступ к панели администратора.",
  // END /admin/users
  // /admin/shares
  "admin.shares.title": "Управление Share",
  "admin.shares.table.id": "Share ID",
  "admin.shares.table.username": "Автор",
  "admin.shares.table.visitors": "Посетители",
  "admin.shares.table.expires": "Срок действия до",
  "admin.shares.edit.delete.title": "Delete share: {id}",
  "admin.shares.edit.delete.description": "Вы действительно хотите удалить эту загрузку?",
  // END /admin/shares
  // /upload
  "upload.title": "Загрузить",
  "upload.notify.confirm-leave": "Вы уверены, что хотите покинуть эту страницу? Загрузка будет отменена.",
  "upload.notify.generic-error": "Произошла ошибка при завершении вашей загрузки.",
  "upload.notify.count-failed": "Не удалось загрузить файлы {count}. Повтор попытки.",
  "upload.reverse-share.error.invalid.title": "Неверная обратная ссылка",
  "upload.reverse-share.error.invalid.description": "Эта обратная доля устарела или является недействительной.",
  // Dropzone.tsx
  "upload.dropzone.title": "Загрузить файлы",
  "upload.dropzone.description": "Перетащите сюда файлы для начала загрузки. Размер всех файлов не должен превышать {maxSize}.",
  "upload.dropzone.notify.file-too-big": "Ваши файлы превышают максимальный размер {maxSize}.",
  // FileList.tsx
  "upload.filelist.name": "Название",
  "upload.filelist.size": "Размер",
  // showCreateUploadModal.tsx
  "upload.modal.title": "Загрузить",
  "upload.modal.link.error.invalid": "Имя пользователя должно состоять только из букв, цифр, подчёркиваний и дефисов",
  "upload.modal.link.error.taken": "Эта ссылка уже используется",
  "upload.modal.not-signed-in": "Вы не авторизованы",
  "upload.modal.not-signed-in-description": "Вы не сможете удалить свои файлы вручную и просмотреть количество посетителей.",
  "upload.modal.expires.never": "никогда",
  "upload.modal.expires.never-long": "Постоянный доступ",
  "upload.modal.expires.error.too-long": "Срок действия превышает максимальный предел {max}.",
  "upload.modal.link.label": "Ссылка",
  "upload.modal.expires.label": "Истекает",
  "upload.modal.expires.minute-singular": "Минута",
  "upload.modal.expires.minute-plural": "Минут(ы)",
  "upload.modal.expires.hour-singular": "Час",
  "upload.modal.expires.hour-plural": "Часов",
  "upload.modal.expires.day-singular": "День",
  "upload.modal.expires.day-plural": "Дней",
  "upload.modal.expires.week-singular": "Неделя",
  "upload.modal.expires.week-plural": "Недель",
  "upload.modal.expires.month-singular": "Месяц",
  "upload.modal.expires.month-plural": "Месяца(-ев)",
  "upload.modal.expires.year-singular": "Год",
  "upload.modal.expires.year-plural": "Года (лет)",
  "upload.modal.accordion.name-and-description.title": "Имя и описание",
  "upload.modal.accordion.name-and-description.name.placeholder": "Имя",
  "upload.modal.accordion.name-and-description.description.placeholder": "Примечание для получателей этой загрузки",
  "upload.modal.accordion.email.title": "Получатели письма",
  "upload.modal.accordion.email.placeholder": "Получатели e-mail",
  "upload.modal.accordion.email.invalid-email": "Недопустимый адрес электронной почты",
  "upload.modal.accordion.security.title": "Параметры безопасности",
  "upload.modal.accordion.security.password.label": "Защита паролем",
  "upload.modal.accordion.security.password.placeholder": "Без пароля",
  "upload.modal.accordion.security.max-views.label": "Максимум просмотров",
  "upload.modal.accordion.security.max-views.placeholder": "Без ограничения",
  // showCompletedUploadModal.tsx
  "upload.modal.completed.never-expires": "Эта загрузка никогда не устареет.",
  "upload.modal.completed.expires-on": "Эта загрузка устареет {expiration}.",
  "upload.modal.completed.share-ready": "Готово",
  "upload.modal.completed.notified-reverse-share-creator": "Мы уведомили создателя обратного ресурса. Вы также можете вручную поделиться этой ссылкой с ними другими средствами.",
  // END /upload
  // /share/[id]
  "share.title": "Загрузка {shareId}",
  "share.description": "Посмотрите, чем я поделился с вами!",
  "share.error.visitor-limit-exceeded.title": "Превышен лимит посетителей",
  "share.error.visitor-limit-exceeded.description": "Превышен лимит посетителей.",
  "share.error.removed.title": "Загрузка удалена",
  "share.error.not-found.title": "Загрузка не найдена",
  "share.error.not-found.description": "Страница, которую вы ищете, не существует.",
  "share.error.access-denied.title": "Приватное доступ",
  "share.error.access-denied.description": "У текущей учетной записи нет разрешения на доступ к этому ресурсу",
  "share.modal.password.title": "Требуется пароль",
  "share.modal.password.description": "Пожалуйста, введите пароль, чтобы получить доступ.",
  "share.modal.password": "Пароль",
  "share.modal.error.invalid-password": "Неверный пароль",
  "share.button.download-all": "Скачать все",
  "share.notify.download-all-preparing": "Загрузка готовится. Повторите попытку через несколько минут.",
  "share.modal.file-link": "Ссылка на файл",
  "share.table.name": "Название",
  "share.table.size": "Размер",
  "share.modal.file-preview.error.not-supported.title": "Предпросмотр не поддерживается",
  "share.modal.file-preview.error.not-supported.description": "Предпросмотр не поддерживается для этого типа файлов. Пожалуйста, скачайте файл для просмотра.",
  // END /share/[id]
  // /share/[id]/edit
  "share.edit.title": "Редактировать {shareId}",
  "share.edit.append-upload": "Добавить файл",
  "share.edit.notify.generic-error": "Произошла ошибка при завершении вашей загрузки.",
  "share.edit.notify.save-success": "Ссылка на ресурс успешна обновлена",
  // END /share/[id]/edit
  // /imprint
  "imprint.title": "Imprint",
  // END /imprint
  // /privacy
  "privacy.title": "Privacy Policy",
  // END /privacy
  // /admin/config
  "admin.config.title": "Конфигурация",
  "admin.config.category.general": "Общее",
  "admin.config.category.share": "Загрузки",
  "admin.config.category.email": "Электронная почта",
  "admin.config.category.smtp": "SMTP",
  "admin.config.category.oauth": "Авторизация через социальные сети",
  "admin.config.general.app-name": "Название приложения",
  "admin.config.general.app-name.description": "Видимое название приложения",
  "admin.config.general.app-url": "URL-адрес приложения",
  "admin.config.general.app-url.description": "Адрес на котором доступен Pingvin Share",
  "admin.config.general.secure-cookies": "Безопасные куки",
  "admin.config.general.secure-cookies.description": "Установите флаг безопасности на cookies. Если включено, сайт не будет работать при доступе по HTTP.",
  "admin.config.general.show-home-page": "Показывать домашнюю страницу",
  "admin.config.general.show-home-page.description": "Показывать ли домашнюю страницу или нет",
  "admin.config.general.session-duration": "Длительность сессии",
  "admin.config.general.session-duration.description": "Время в часах, после которого пользователь должен снова войти (по умолчанию: 3 месяца).",
  "admin.config.general.logo": "Логотип",
  "admin.config.general.logo.description": "Измените свой логотип, загрузив новое изображение. Изображение должно быть PNG и должно иметь формат 1:1.",
  "admin.config.general.logo.placeholder": "Выберите изображение",
  "admin.config.email.enable-share-email-recipients": "Включить отправку email получателю",
  "admin.config.email.enable-share-email-recipients.description": "Разрешить ли обмен электронной почтой с получателями. Включите, только если включен SMTP.",
  "admin.config.email.share-recipients-subject": "Заголовок письма (загрузка)",
  "admin.config.email.share-recipients-subject.description": "Тема письма, которое отправляется получателям акции.",
  "admin.config.email.share-recipients-message": "Сообщение письма загрузки",
  "admin.config.email.share-recipients-message.description": "Message which gets sent to the share recipients. Available variables:\n {creator} - The username of the creator of the share\n {creatorEmail} - The email of the creator of the share\n {shareUrl} - The URL of the share\n {desc} - The description of the share\n {expires} - The expiration date of the share\n These variables will be replaced with the actual value.",
  "admin.config.email.reverse-share-subject": "Заголовок письма (обратная загрузка)",
  "admin.config.email.reverse-share-subject.description": "Тема письма, которое отправляется, когда кто-то создал загрузку с вашей обратной ссылкой.",
  "admin.config.email.reverse-share-message": "Сообщение письма обратной загрузки",
  "admin.config.email.reverse-share-message.description": "Сообщение, которое отправляется, когда кто-то создал загрузку с вашей обратной ссылкой. {shareUrl} будет заменен именем создателя и URL-адресом общего доступа.",
  "admin.config.email.reset-password-subject": "Тема сброса пароля",
  "admin.config.email.reset-password-subject.description": "Тема письма, которое отправляется, когда пользователь запрашивает сброс пароля.",
  "admin.config.email.reset-password-message": "Сообщение о сбросе пароля",
  "admin.config.email.reset-password-message.description": "Сообщение, которое отправляется при запросе сброса пароля. {url} будет заменён ссылкой.",
  "admin.config.email.invite-subject": "Тема приглашения",
  "admin.config.email.invite-subject.description": "Тема письма, которое отправляется, когда администратор приглашает пользователя.",
  "admin.config.email.invite-message": "Сообщение с приглашением",
  "admin.config.email.invite-message.description": "Сообщение приглашения. {url} будет заменён ссылкой приглашения, а {password} паролем.",
  "admin.config.share.allow-registration": "Разрешить регистрацию",
  "admin.config.share.allow-registration.description": "Разрешена ли регистрация",
  "admin.config.share.allow-unauthenticated-shares": "Разрешить неавторизованные загрузки",
  "admin.config.share.allow-unauthenticated-shares.description": "Могут ли неавторизованные пользователи создавать загрузки",
  "admin.config.share.max-expiration": "Максимальная срок действия",
  "admin.config.share.max-expiration.description": "Maximum share expiration. Set to 0 to allow unlimited expiration.",
  "admin.config.share.share-id-length": "Длина идентификатора по умолчанию",
  "admin.config.share.share-id-length.description": "Длина по умолчанию для сгенерированного ID ресурса. Это значение также используется для генерации ссылок для обратных акций. Значение ниже 8 не считается безопасным.",
  "admin.config.share.max-size": "Максимальный размер",
  "admin.config.share.max-size.description": "Максимальный размер файла",
  "admin.config.share.zip-compression-level": "Уровень сжатия Zip",
  "admin.config.share.zip-compression-level.description": "Регулировка уровня баланса между размером файла и скоростью сжатия. Допустимые значения от 0 до 9, с 0 без сжатия, а 9 - максимальное сжатие. ",
  "admin.config.share.chunk-size": "Размер чанка",
  "admin.config.share.chunk-size.description": "Отрегулируйте размер чанка для ваших загрузок, чтобы сбалансировать эффективность и надежность в соответствии с вашим интернет-соединением. Меньшие чанки могут повысить успешность нестабильных соединений, а большие чанки ускоряют загрузку для стабильных соединений.",
  "admin.config.share.auto-open-share-modal": "Автоматически открыть общий доступ",
  "admin.config.share.auto-open-share-modal.description": "Модуль создания общего доступа автоматически появляется, когда пользователь выбирает файлы, устраняя необходимость вручную нажать кнопку.",
  "admin.config.smtp.enabled": "Включено",
  "admin.config.smtp.enabled.description": "Включено ли SMTP. Установите значение true только если вы ввели хост, порт, email, пользователь и пароль вашего SMTP-сервера.",
  "admin.config.smtp.host": "Хост",
  "admin.config.smtp.host.description": "Сервер SMTP сервера",
  "admin.config.smtp.port": "Порт",
  "admin.config.smtp.port.description": "Порт SMTP сервера",
  "admin.config.smtp.email": "Электронная почта",
  "admin.config.smtp.email.description": "Email address from wich the emails get sent",
  "admin.config.smtp.username": "Логин",
  "admin.config.smtp.username.description": "Имя пользователя SMTP сервера",
  "admin.config.smtp.password": "Пароль",
  "admin.config.smtp.password.description": "Пароль SMTP-сервера",
  "admin.config.smtp.button.test": "Отправить тестовое письмо",
  "admin.config.smtp.allow-unauthorized-certificates": "Доверять несанкционированным сертификатам SMTP-сервера",
  "admin.config.smtp.allow-unauthorized-certificates.description": "Установите это значение только в том случае, если вам нужно доверять самоподписанным сертификатам.",
  "admin.config.oauth.allow-registration": "Разрешить регистрацию",
  "admin.config.oauth.allow-registration.description": "Разрешить пользователям регистрироваться используя учетные записи социальных сетей",
  "admin.config.oauth.ignore-totp": "Игнорировать TOTP",
  "admin.config.oauth.ignore-totp.description": "Игнорировать TOTP при использовании социальной авторизации",
  "admin.config.oauth.disable-password": "Отключить логин и пароль",
  "admin.config.oauth.disable-password.description": "Следует ли отключать вход по паролю? \nПеред активацией этой конфигурации убедитесь, что поставщик OAuth настроен должным образом, чтобы избежать блокировки.",
  "admin.config.oauth.github-enabled": "GitHub",
  "admin.config.oauth.github-enabled.description": "Включен ли логин на GitHub",
  "admin.config.oauth.github-client-id": "ID клиента GitHub",
  "admin.config.oauth.github-client-id.description": "ID клиента в приложении GitHub OAuth",
  "admin.config.oauth.github-client-secret": "Секретный ключ клиента GitHub",
  "admin.config.oauth.github-client-secret.description": "Секретный ключ клиента в приложении GitHub OAuth",
  "admin.config.oauth.google-enabled": "Google",
  "admin.config.oauth.google-enabled.description": "Включен ли логин Google на GitHub",
  "admin.config.oauth.google-client-id": "ID клиента Google",
  "admin.config.oauth.google-client-id.description": "ID клиента в приложении Google OAuth",
  "admin.config.oauth.google-client-secret": "Секретный ключ клиента Google",
  "admin.config.oauth.google-client-secret.description": "Секретный ключ клиента в приложении Google OAuth",
  "admin.config.oauth.microsoft-enabled": "Microsoft",
  "admin.config.oauth.microsoft-enabled.description": "Включен ли логин Microsoft",
  "admin.config.oauth.microsoft-tenant": "Корпоративный аккаунт Microsoft",
  "admin.config.oauth.microsoft-tenant.description": "Идентификатор арендатора приложения Microsoft OAuth\ncommon: Пользователи с личным аккаунтом Microsoft и рабочим или учебным аккаунтом от Microsoft Entra ID могут войти в приложение. organizations: Только пользователи с рабочим или учебным аккаунтом от Microsoft Entra ID могут войти в приложение.\nconsumers: Только пользователи с личным аккаунтом Microsoft могут войти в приложение.\nимя домена арендатора Microsoft Entra или идентификатор арендатора в формате GUID: Только пользователи из определенного арендатора Microsoft Entra (участники каталога с рабочим или учебным аккаунтом или гости каталога с личным аккаунтом Microsoft) могут войти в приложение.",
  "admin.config.oauth.microsoft-client-id": "Идентификатор клиента Microsoft",
  "admin.config.oauth.microsoft-client-id.description": "ID клиента в приложении Microsoft OAuth",
  "admin.config.oauth.microsoft-client-secret": "Секретный ключ клиента Microsoft",
  "admin.config.oauth.microsoft-client-secret.description": "Секретный ключ клиента в приложении Microsoft OAuth",
  "admin.config.oauth.discord-enabled": "Discord",
  "admin.config.oauth.discord-enabled.description": "Включен ли логин Discord",
  "admin.config.oauth.discord-limited-users": "Discord limited users",
  "admin.config.oauth.discord-limited-users.description": "Limit signing in to specific users by their Discord ID. Leave it blank to disable.",
  "admin.config.oauth.discord-limited-guild": "ID ограниченного сервера Discord",
  "admin.config.oauth.discord-limited-guild.description": "Ограничение входа для пользователей определенного сервера. Оставьте пустым, чтобы отключить.",
  "admin.config.oauth.discord-client-id": "ID клиента Discord",
  "admin.config.oauth.discord-client-id.description": "ID клиента в приложении Discord OAuth",
  "admin.config.oauth.discord-client-secret": "Секретный ключ клиента Discord",
  "admin.config.oauth.discord-client-secret.description": "Секретный ключ клиента в приложении Discord OAuth",
  "admin.config.oauth.oidc-enabled": "OpenID Connect",
  "admin.config.oauth.oidc-enabled.description": "Whether OpenID Connect login is enabled",
  "admin.config.oauth.oidc-discovery-uri": "OpenID Connect Discovery URI",
  "admin.config.oauth.oidc-discovery-uri.description": "Discovery URI of the OpenID Connect OAuth app",
  "admin.config.oauth.oidc-sign-out": "Sign out from OpenID Connect",
  "admin.config.oauth.oidc-sign-out.description": "Whether the “Sign out” button will sign out from the OpenID Connect provider",
  "admin.config.oauth.oidc-scope": "OpenID Connect scope",
  "admin.config.oauth.oidc-scope.description": "Scopes which should be requested from the OpenID Connect provider.",
  "admin.config.oauth.oidc-username-claim": "OpenID Connect username claim",
  "admin.config.oauth.oidc-username-claim.description": "Username claim in OpenID Connect ID token. Leave it blank if you don't know what this config is.",
  "admin.config.oauth.oidc-role-path": "Path to roles in OpenID Connect token",
  "admin.config.oauth.oidc-role-path.description": "Must be a valid JMES path referencing an array of roles. " + "Managing access rights using OpenID Connect roles is only recommended if no other identity provider is configured and password login is disabled. " + "Leave it blank if you don't know what this config is.",
  "admin.config.oauth.oidc-role-general-access": "OpenID Connect role for general access",
  "admin.config.oauth.oidc-role-general-access.description": "Role required for general access. Must be present in a user’s roles for them to log in. " + "Leave it blank if you don't know what this config is.",
  "admin.config.oauth.oidc-role-admin-access": "OpenID Connect role for admin access",
  "admin.config.oauth.oidc-role-admin-access.description": "Role required for administrative access. Must be present in a user’s roles for them to access the admin panel. " + "Leave it blank if you don't know what this config is.",
  "admin.config.oauth.oidc-client-id": "OpenID Connect Client ID",
  "admin.config.oauth.oidc-client-id.description": "Client ID of the OpenID Connect OAuth app",
  "admin.config.oauth.oidc-client-secret": "OpenID Connect Client secret",
  "admin.config.oauth.oidc-client-secret.description": "Client secret of the OpenID Connect OAuth app",
  "admin.config.category.ldap": "LDAP",
  "admin.config.ldap.enabled": "Enable LDAP",
  "admin.config.ldap.enabled.description": "Use LDAP authentication for user login",
  "admin.config.ldap.url": "Server URL",
  "admin.config.ldap.url.description": "URL of the LDAP server",
  "admin.config.ldap.bind-dn": "Bind DN",
  "admin.config.ldap.bind-dn.description": "Default user used to perform the user search",
  "admin.config.ldap.bind-password": "Bind password",
  "admin.config.ldap.bind-password.description": "Password used to perform the user search",
  "admin.config.ldap.search-base": "User base",
  "admin.config.ldap.search-base.description": "Base location, where the user search will be performed",
  "admin.config.ldap.search-query": "User query",
  "admin.config.ldap.search-query.description": "The user query will be used to search the 'User base' for the LDAP user. %username% can be used as the placeholder for the user given input.",
  "admin.config.ldap.admin-groups": "Admin group",
  "admin.config.ldap.admin-groups.description": "Group required for administrative access.",
  "admin.config.ldap.field-name-member-of": "User groups attribute name",
  "admin.config.ldap.field-name-member-of.description": "LDAP attribute name for the groups, an user is a member of. This is used when checking for the admin group.",
  "admin.config.ldap.field-name-email": "User email attribute name",
  "admin.config.ldap.field-name-email.description": "LDAP attribute name for the email of an user.",
  "admin.config.notify.success": "Configuration updated successfully.",
  "admin.config.notify.logo-success": "Logo updated successfully. It may take a few minutes to update on the website.",
  "admin.config.notify.no-changes": "No changes to save.",
  "admin.config.category.s3": "S3",
  "admin.config.s3.enabled": "Enabled",
  "admin.config.s3.enabled.description": "Whether S3 should be used to store the shared files instead of the local file system.",
  "admin.config.s3.endpoint": "Endpoint",
  "admin.config.s3.endpoint.description": "The URL of the S3 bucket.",
  "admin.config.s3.region": "Region",
  "admin.config.s3.region.description": "The region of the S3 bucket.",
  "admin.config.s3.bucket-name": "Bucket name",
  "admin.config.s3.bucket-name.description": "The name of the S3 bucket.",
  "admin.config.s3.bucket-path": "Path",
  "admin.config.s3.bucket-path.description": "The default path which should be used to store the files in the S3 bucket.",
  "admin.config.s3.key": "Key",
  "admin.config.s3.key.description": "The key which allows you to access the S3 bucket.",
  "admin.config.s3.secret": "Secret",
  "admin.config.s3.secret.description": "The secret which allows you to access the S3 bucket.",
  "admin.config.category.legal": "Legal",
  "admin.config.legal.enabled": "Enable legal notices",
  "admin.config.legal.enabled.description": "Whether to show a link to imprint and privacy policy in the footer.",
  "admin.config.legal.imprint-text": "Imprint text",
  "admin.config.legal.imprint-text.description": "The text which should be shown in the imprint. Supports Markdown. Leave blank to link to an external imprint page.",
  "admin.config.legal.imprint-url": "Imprint URL",
  "admin.config.legal.imprint-url.description": "If you already have an imprint page you can link it here instead of using the text field.",
  "admin.config.legal.privacy-policy-text": "Privacy policy text",
  "admin.config.legal.privacy-policy-text.description": "The text which should be shown in the privacy policy. Supports Markdown. Leave blank to link to an external privacy policy page.",
  "admin.config.legal.privacy-policy-url": "Privacy policy URL",
  "admin.config.legal.privacy-policy-url.description": "If you already have a privacy policy page you can link it here instead of using the text field.",
  // 404
  "404.description": "Упс, этой страницы не существует.",
  "404.button.home": "Верните меня домой",
  // error
  "error.title": "Ошибка",
  "error.description": "Что-то пошло не так!",
  "error.button.back": "Назад",
  "error.msg.default": "Что-то пошло не так.",
  "error.msg.access_denied": "Вы отменили процесс аутентификации, пожалуйста, попробуйте еще раз.",
  "error.msg.expired_token": "Процесс аутентификации занял слишком много времени, пожалуйста, попробуйте еще раз.",
  "error.msg.invalid_token": "Внутренняя ошибка",
  "error.msg.no_user": "Пользователь связанный с учетной записью {0} не существует.",
  "error.msg.no_email": "Не удается получить адрес электронной почты от учетной записи {0}.",
  "error.msg.already_linked": "Эта учетная запись {0} уже привязана к другому аккаунту.",
  "error.msg.not_linked": "This {0} account hasn't been linked to any account yet.",
  "error.msg.unverified_account": "Эта учетная запись {0} не подтверждена, повторите попытку после подтверждения.",
  "error.msg.user_not_allowed": "У вас нет разрешения на вход.",
  "error.msg.cannot_get_user_info": "Cannot get your user info from this {0} account.",
  "error.param.provider_github": "GitHub",
  "error.param.provider_google": "Google",
  "error.param.provider_microsoft": "Microsoft",
  "error.param.provider_discord": "Discord",
  "error.param.provider_oidc": "OpenID Connect",
  // Common translations
  "common.button.save": "Сохранить",
  "common.button.create": "Создать",
  "common.button.submit": "Отправить",
  "common.button.delete": "Удалить",
  "common.button.cancel": "Отмена",
  "common.button.confirm": "Подтвердить",
  "common.button.disable": "Отключить",
  "common.button.share": "Поделиться",
  "common.button.generate": "Сгенерировать",
  "common.button.done": "Готово",
  "common.text.link": "Ссылка",
  "common.text.navigate-to-link": "Перейти по ссылке",
  "common.text.or": "или",
  "common.text.redirecting": "Идет перенаправление...",
  "common.button.go-back": "Назад",
  "common.button.go-home": "Домой",
  "common.notify.copied": "Ваша ссылка скопирована в буфер обмена",
  "common.notify.copied-link": "Ваша ссылка скопирована в буфер обмена",
  "common.success": "Успех",
  "common.error": "Ошибочка",
  "common.error.unknown": "Произошла неизвестная ошибка",
  "common.error.invalid-email": "Недопустимый адрес электронной почты",
  "common.error.too-short": "Должно быть не менее {length} символов",
  "common.error.too-long": "Должно быть не больше {length} символов",
  "common.error.number-too-small": "Должно быть не меньше {min}",
  "common.error.number-too-large": "Должно быть не больше {max}",
  "common.error.exact-length": "Должно быть ровно {length} символов",
  "common.error.invalid-number": "Должно быть числом",
  "common.error.field-required": "Поле обязательно для заполнения"
};