export default {
  // Navbar
  "navbar.upload": "Carregar",
  "navbar.signin": "Iniciar sessão",
  "navbar.home": "Início",
  "navbar.signup": "Cadastre-se",
  "navbar.links.shares": "Meus compartilhamentos",
  "navbar.links.reverse": "Compartilhamentos reversos",
  "navbar.avatar.account": "Minha conta",
  "navbar.avatar.admin": "Administração",
  "navbar.avatar.signout": "Terminar sessão",
  // END navbar
  // /
  "home.title": "Uma plataforma de compartilhamento de arquivos <h>auto-hospedada</h>.",
  "home.description": "Deseja realmente dar os seus arquivos pessoais na mão de terceiros como o WeTransfer?",
  "home.bullet.a.name": "Auto-Hospedado",
  "home.bullet.a.description": "Hospede o Pingvin Share em sua própria máquina.",
  "home.bullet.b.name": "Privacidade",
  "home.bullet.b.description": "Seus arquivos são seus e nunca serão acessados por terceiros.",
  "home.bullet.c.name": "Sem limite de tamanho de arquivo irritante",
  "home.bullet.c.description": "Carregue arquivos tão grandes quanto quiser. Apenas o seu disco rígido será o seu limite.",
  "home.button.start": "Começar",
  "home.button.source": "Código-fonte",
  // END /
  // /auth/signin
  "signin.title": "Bem-vindo de volta",
  "signin.description": "Ainda não tem uma conta?",
  "signin.button.signup": "Registo",
  "signin.input.email-or-username": "E-mail ou nome de usuário",
  "signin.input.email-or-username.placeholder": "Seu e-mail ou nome de usuário",
  "signin.input.password": "Senha",
  "signin.input.password.placeholder": "A sua senha",
  "signin.button.submit": "Iniciar sessão",
  "signIn.notify.totp-required.title": "Autenticação de dois fatores necessária",
  "signIn.notify.totp-required.description": "Insira seu código de autenticação de dois fatores",
  "signIn.oauth.or": "OU",
  "signIn.oauth.signInWith": "Iniciar sessão com",
  "signIn.oauth.github": "GitHub",
  "signIn.oauth.google": "Google",
  "signIn.oauth.microsoft": "Microsoft",
  "signIn.oauth.discord": "Discord",
  "signIn.oauth.oidc": "OpenID",
  // END /auth/signin
  // /auth/signup
  "signup.title": "Criar uma conta",
  "signup.description": "Já tem uma conta?",
  "signup.button.signin": "Iniciar sessão",
  "signup.input.username": "Nome de usuário",
  "signup.input.username.placeholder": "Seu nome de usuário",
  "signup.input.email": "E-mail",
  "signup.input.email.placeholder": "Seu e-mail",
  "signup.button.submit": "Vamos começar",
  // END /auth/signup
  // /auth/totp
  "totp.title": "Autenticação TOTP",
  "totp.button.signIn": "Iniciar sessão",
  // END /auth/totp
  // /auth/reset-password
  "resetPassword.title": "Esqueceu a sua senha?",
  "resetPassword.description": "Insira o seu e-mail para redefinir a sua senha.",
  "resetPassword.notify.success": "Uma mensagem com um link para redefinir sua senha foi enviada se o e-mail fornecido existir.",
  "resetPassword.button.back": "Voltar para a página inicial",
  "resetPassword.text.resetPassword": "Redefinir senha",
  "resetPassword.text.enterNewPassword": "Digite uma nova senha",
  "resetPassword.input.password": "Nova senha",
  "resetPassword.notify.passwordReset": "A sua senha foi redefinida com sucesso.",
  // /account
  "account.title": "A minha conta",
  "account.card.info.title": "Informação sobre a conta",
  "account.card.info.username": "Nome de usuário",
  "account.card.info.email": "E-mail",
  "account.notify.info.success": "A conta foi atualizada com sucesso",
  "account.card.password.title": "Senha",
  "account.card.password.old": "Senha antiga",
  "account.card.password.new": "Nova senha",
  "account.card.password.noPasswordSet": "Você não tem uma senha definida. Para entrar utilizando seu e-mail e senha, você precisa criar uma senha.",
  "account.notify.password.success": "Senha alterada com sucesso",
  "account.card.oauth.title": "Login com Redes Sociais",
  "account.card.oauth.github": "GitHub",
  "account.card.oauth.google": "Google",
  "account.card.oauth.microsoft": "Microsoft",
  "account.card.oauth.discord": "Discord",
  "account.card.oauth.oidc": "OpenID",
  "account.card.oauth.link": "Vincular",
  "account.card.oauth.unlink": "Desvincular",
  "account.card.oauth.unlinked": "Desvinculado",
  "account.modal.unlink.title": "Desvincular conta",
  "account.modal.unlink.description": "Desvincular suas redes sociais pode fazer com que você perca sua conta se não se lembrar de seu nome de usuário e senha",
  "account.notify.oauth.unlinked.success": "Desvinculado com sucesso",
  "account.card.security.title": "Segurança",
  "account.card.security.totp.enable.description": "Digite a sua senha atual para começar a habilitar o TOTP",
  "account.card.security.totp.disable.description": "Digite a sua senha atual para desabilitar o TOTP",
  "account.card.security.totp.button.start": "Iniciar",
  "account.modal.totp.title": "Habilitar TOTP",
  "account.modal.totp.step1": "Passo 1: Adicionar o seu autenticador",
  "account.modal.totp.step2": "Passo 2: Valide o seu código",
  "account.modal.totp.enterManually": "Inserir manualmente",
  "account.modal.totp.code": "Código",
  "common.button.clickToCopy": "Clique para copiar",
  "account.modal.totp.verify": "Verificar",
  "account.notify.totp.disable": "TOTP desabilitado com sucesso",
  "account.notify.totp.enable": "TOTP habilitado com sucesso",
  "account.card.language.title": "Idioma",
  "account.card.language.description": "O projeto é traduzido pela comunidade. Alguns idiomas podem estar incompletos.",
  "account.card.color.title": "Esquema de cores",
  // ThemeSwitcher.tsx
  "account.theme.dark": "Escuro",
  "account.theme.light": "Claro",
  "account.theme.system": "Sistema",
  "account.button.delete": "Excluir conta",
  "account.modal.delete.title": "Excluir conta",
  "account.modal.delete.description": "Você realmente deseja excluir a sua conta, incluindo todos os seus compartilhamentos ativos?",
  // END /account
  // /account/shares
  "account.shares.title": "Meus compartilhamentos",
  "account.shares.title.empty": "Está vazio aqui 👀",
  "account.shares.description.empty": "Você não tem nenhum compartilhamento.",
  "account.shares.button.create": "Crie um",
  "account.shares.info.title": "Informações do compartilhamento",
  "account.shares.table.id": "ID",
  "account.shares.table.name": "Nome",
  "account.shares.table.description": "Descrição",
  "account.shares.table.visitors": "Visitantes",
  "account.shares.table.expiresAt": "Expira em",
  "account.shares.table.createdAt": "Criada em",
  "account.shares.table.size": "Tamanho",
  "account.shares.table.password-protected": "Password protected",
  "account.shares.table.visitor-count": "{count} of {max}",
  "account.shares.table.expiry-never": "Nunca",
  "account.shares.modal.share-informations": "Informações do compartilhamento",
  "account.shares.modal.share-link": "Link do compartilhamento",
  "account.shares.modal.delete.title": "Excluir o compartilhamento {share}",
  "account.shares.modal.delete.description": "Tem certeza que deseja excluir este compartilhamento?",
  // END /account/shares
  // /account/reverseShares
  "account.reverseShares.title": "Compartilhamentos reversos",
  "account.reverseShares.description": "Um compartilhamento reverso permite gerar uma URL única que autoriza usuários externos criarem um compartilhamento.",
  "account.reverseShares.title.empty": "Está vazio aqui 👀",
  "account.reverseShares.description.empty": "Você não tem nenhum compartilhamento reverso.",
  // showCreateReverseShareModal.tsx
  "account.reverseShares.modal.title": "Criar compartilhamento reverso",
  "account.reverseShares.modal.expiration.label": "Expiração",
  "account.reverseShares.modal.expiration.minute-singular": "Minuto",
  "account.reverseShares.modal.expiration.minute-plural": "Minutos",
  "account.reverseShares.modal.expiration.hour-singular": "Hora",
  "account.reverseShares.modal.expiration.hour-plural": "Horas",
  "account.reverseShares.modal.expiration.day-singular": "Dia",
  "account.reverseShares.modal.expiration.day-plural": "Dias",
  "account.reverseShares.modal.expiration.week-singular": "Semana",
  "account.reverseShares.modal.expiration.week-plural": "Semanas",
  "account.reverseShares.modal.expiration.month-singular": "Mês",
  "account.reverseShares.modal.expiration.month-plural": "Meses",
  "account.reverseShares.modal.expiration.year-singular": "Ano",
  "account.reverseShares.modal.expiration.year-plural": "Anos",
  "account.reverseShares.modal.max-size.label": "Tamanho máximo do compartilhamento",
  "account.reverseShares.modal.send-email": "Enviar notificações por email",
  "account.reverseShares.modal.send-email.description": "Enviar uma notificação por e-mail quando um compartilhamento for criado com este link reverso.",
  "account.reverseShares.modal.simplified": "Modo simples",
  "account.reverseShares.modal.simplified.description": "Facilite o upload da pessoa para compartilhar o arquivo com você. Eles serão capazes de personalizar somente o nome e a descrição do compartilhamento.",
  "account.reverseShares.modal.public-access": "Acesso público",
  "account.reverseShares.modal.public-access.description": "Faça os compartilhamentos criados com este compartilhamento reverso público. Se desativado, somente você e o criador do compartilhamento poderão visualizá-lo.",
  "account.reverseShares.modal.max-use.label": "Limite de uso",
  "account.reverseShares.modal.max-use.description": "A quantidade máxima de vezes que esta URL pode ser usada para criar um compartilhamento.",
  "account.reverseShare.never-expires": "Este compartilhamento reverso nunca irá expirar.",
  "account.reverseShare.expires-on": "Este compartilhamento reverso irá expirar em {expiration}.",
  "account.reverseShares.table.no-shares": "Nenhum compartilhamento criado ainda",
  "account.reverseShares.table.count.singular": "compartilhar",
  "account.reverseShares.table.count.plural": "compartilhamentos",
  "account.reverseShares.table.shares": "Compartilhamentos",
  "account.reverseShares.table.remaining": "Usos restantes",
  "account.reverseShares.table.max-size": "Tamanho máximo do compartilhamento",
  "account.reverseShares.table.expires": "Expira em",
  "account.reverseShares.modal.reverse-share-link": "Link do compartilhamento reverso",
  "account.reverseShares.modal.delete.title": "Excluir o compartilhamento reverso",
  "account.reverseShares.modal.delete.description": "Você realmente deseja excluir este compartilhamento reverso? Se você o fizer, os compartilhamentos associados também serão excluídos.",
  // END /account/reverseShares
  // /admin
  "admin.title": "Administração",
  "admin.button.users": "Gerenciamento de usuários",
  "admin.button.shares": "Gerenciamento de compartilhamentos",
  "admin.button.config": "Configuração",
  "admin.version": "Versão",
  // END /admin
  // /admin/users
  "admin.users.title": "Gerenciamento de usuários",
  "admin.users.table.username": "Nome de usuário",
  "admin.users.table.email": "E-mail",
  "admin.users.table.admin": "Admin",
  "admin.users.edit.update.title": "Editar usuário: {username}",
  "admin.users.edit.update.admin-privileges": "Privilégios de administrador",
  "admin.users.edit.update.change-password.title": "Alterar senha",
  "admin.users.edit.update.change-password.field": "Nova senha",
  "admin.users.edit.update.change-password.button": "Salvar nova senha",
  "admin.users.edit.update.notify.password.success": "Senha alterada com sucesso",
  "admin.users.edit.delete.title": "Excluir usuário {username} ?",
  "admin.users.edit.delete.description": "Você realmente quer excluir este usuário e todos os seus compartilhamentos?",
  // showCreateUserModal.tsx
  "admin.users.modal.create.title": "Criar usuário",
  "admin.users.modal.create.username": "Nome de usuário",
  "admin.users.modal.create.email": "E-mail",
  "admin.users.modal.create.password": "Senha",
  "admin.users.modal.create.manual-password": "Definir senha manualmente",
  "admin.users.modal.create.manual-password.description": "Se não estiver marcado, o usuário receberá um e-mail com um link para definir sua senha.",
  "admin.users.modal.create.admin": "Privilégios de administrador",
  "admin.users.modal.create.admin.description": "Se marcado, o usuário poderá acessar o painel de administração.",
  // END /admin/users
  // /admin/shares
  "admin.shares.title": "Gerenciamento de compartilhamentos",
  "admin.shares.table.id": "ID do Compartilhamento",
  "admin.shares.table.username": "Criador",
  "admin.shares.table.visitors": "Visitantes",
  "admin.shares.table.expires": "Expira em",
  "admin.shares.edit.delete.title": "Excluir o compartilhamento {id}",
  "admin.shares.edit.delete.description": "Tem certeza que deseja excluir este compartilhamento?",
  // END /admin/shares
  // /upload
  "upload.title": "Carregar",
  "upload.notify.confirm-leave": "Você tem certeza que deseja sair desta página? Seu envio será cancelado.",
  "upload.notify.generic-error": "Ocorreu um erro ao terminar seu compartilhamento.",
  "upload.notify.count-failed": "Falha ao enviar {count} arquivos. Tentando novamente.",
  "upload.reverse-share.error.invalid.title": "Link de compartilhamento reverso inválido",
  "upload.reverse-share.error.invalid.description": "Este compartilhamento reverso expirou ou é inválido.",
  // Dropzone.tsx
  "upload.dropzone.title": "Carregar arquivos",
  "upload.dropzone.description": "Arraste os arquivos aqui para iniciar o seu compartilhamento. Aceitamos apenas arquivos até {maxSize} no total.",
  "upload.dropzone.notify.file-too-big": "Seus arquivos excedem o tamanho máximo do compartilhamento {maxSize}.",
  // FileList.tsx
  "upload.filelist.name": "Nome",
  "upload.filelist.size": "Tamanho",
  // showCreateUploadModal.tsx
  "upload.modal.title": "Criar Compartilhamento",
  "upload.modal.link.error.invalid": "Pode conter apenas letras, números, sublinhados e hífens",
  "upload.modal.link.error.taken": "Este link já está em uso",
  "upload.modal.not-signed-in": "Você não está conectado",
  "upload.modal.not-signed-in-description": "Você não poderá excluir seu compartilhamento manualmente e visualizar a contagem de visitantes.",
  "upload.modal.expires.never": "nunca",
  "upload.modal.expires.never-long": "Compartilhamento permanente",
  "upload.modal.expires.error.too-long": "Data de expiração excede o máximo de {max}.",
  "upload.modal.link.label": "Link",
  "upload.modal.expires.label": "Expiração",
  "upload.modal.expires.minute-singular": "Minuto",
  "upload.modal.expires.minute-plural": "Minutos",
  "upload.modal.expires.hour-singular": "Hora",
  "upload.modal.expires.hour-plural": "Horas",
  "upload.modal.expires.day-singular": "Dia",
  "upload.modal.expires.day-plural": "Dias",
  "upload.modal.expires.week-singular": "Semana",
  "upload.modal.expires.week-plural": "Semanas",
  "upload.modal.expires.month-singular": "Mês",
  "upload.modal.expires.month-plural": "Meses",
  "upload.modal.expires.year-singular": "Ano",
  "upload.modal.expires.year-plural": "Anos",
  "upload.modal.accordion.name-and-description.title": "Nome e descrição",
  "upload.modal.accordion.name-and-description.name.placeholder": "Nome",
  "upload.modal.accordion.name-and-description.description.placeholder": "Nota para os destinatários deste compartilhamento",
  "upload.modal.accordion.email.title": "Destinatários de e-mail",
  "upload.modal.accordion.email.placeholder": "Insira os destinatários do e-mail",
  "upload.modal.accordion.email.invalid-email": "Endereço de e-mail inválido",
  "upload.modal.accordion.security.title": "Opções de segurança",
  "upload.modal.accordion.security.password.label": "Proteção por senha",
  "upload.modal.accordion.security.password.placeholder": "Sem senha",
  "upload.modal.accordion.security.max-views.label": "Máximo de visualizações",
  "upload.modal.accordion.security.max-views.placeholder": "Sem limite",
  // showCompletedUploadModal.tsx
  "upload.modal.completed.never-expires": "Este compartilhamento reverso nunca irá expirar.",
  "upload.modal.completed.expires-on": "Este compartilhamento reverso irá expirar em {expiration}.",
  "upload.modal.completed.share-ready": "Compartilhamento pronto",
  "upload.modal.completed.notified-reverse-share-creator": "Nós notificamos o criador do compartilhamento reverso. Você também pode compartilhar este link manualmente com ele por outros meios.",
  // END /upload
  // /share/[id]
  "share.title": "Compartilhar {shareId}",
  "share.description": "Veja o que eu compartilhei com você!",
  "share.error.visitor-limit-exceeded.title": "Limite de visitantes excedido",
  "share.error.visitor-limit-exceeded.description": "O limite de visitantes deste compartilhamento foi excedido.",
  "share.error.removed.title": "Compartilhamento removido",
  "share.error.not-found.title": "Compartilhamento não encontrado",
  "share.error.not-found.description": "O compartilhamento que você procura não existe.",
  "share.error.access-denied.title": "Compartilhamento privado",
  "share.error.access-denied.description": "A conta atual não tem permissão para acessar este compartilhamento",
  "share.modal.password.title": "Senha necessária",
  "share.modal.password.description": "Por favor, digite a senha para acessar este compartilhamento.",
  "share.modal.password": "Senha",
  "share.modal.error.invalid-password": "Senha inválida",
  "share.button.download-all": "Transferir tudo",
  "share.notify.download-all-preparing": "O compartilhamento está sendo preparado. Tente novamente em alguns minutos.",
  "share.modal.file-link": "Link do arquivo",
  "share.table.name": "Nome",
  "share.table.size": "Tamanho",
  "share.modal.file-preview.error.not-supported.title": "Visualização não suportada",
  "share.modal.file-preview.error.not-supported.description": "Pré-visualizações não são suportadas para este tipo de arquivos. Por favor, baixe o arquivo para visualizá-lo.",
  // END /share/[id]
  // /share/[id]/edit
  "share.edit.title": "Editar {shareId}",
  "share.edit.append-upload": "Anexar arquivo",
  "share.edit.notify.generic-error": "Ocorreu um erro ao terminar seu compartilhamento.",
  "share.edit.notify.save-success": "Compartilhamento atualizado com sucesso",
  // END /share/[id]/edit
  // /imprint
  "imprint.title": "Imprint",
  // END /imprint
  // /privacy
  "privacy.title": "Privacy Policy",
  // END /privacy
  // /admin/config
  "admin.config.title": "Configuração",
  "admin.config.category.general": "Geral",
  "admin.config.category.share": "Compartilhamento",
  "admin.config.category.email": "E-mail",
  "admin.config.category.smtp": "SMTP",
  "admin.config.category.oauth": "Login com Redes Sociais",
  "admin.config.general.app-name": "Nome da aplicação",
  "admin.config.general.app-name.description": "Nome da aplicação",
  "admin.config.general.app-url": "URL do Aplicativo",
  "admin.config.general.app-url.description": "Em qual URL o Pingvin Share está disponível",
  "admin.config.general.secure-cookies": "Cookies seguros",
  "admin.config.general.secure-cookies.description": "Se definir a bandeira segura nos cookies. Se habilitado, o site não funcionará quando acessado por HTTP.",
  "admin.config.general.show-home-page": "Mostrar a página inicial",
  "admin.config.general.show-home-page.description": "Mostrar ou não a página inicial",
  "admin.config.general.session-duration": "Duração de sessão",
  "admin.config.general.session-duration.description": "Tempo em horas após o qual um usuário deve iniciar a sessão novamente (padrão: 3 meses).",
  "admin.config.general.logo": "Logo",
  "admin.config.general.logo.description": "Alterar o seu logo carregando uma nova imagem. A imagem deve ser PNG e deve ter o formato 1:1.",
  "admin.config.general.logo.placeholder": "Escolhe uma imagem",
  "admin.config.email.enable-share-email-recipients": "Ativar compartilhamento por email",
  "admin.config.email.enable-share-email-recipients.description": "Se deseja permitir o compartilhamento por e-mail com destinatários. Só ative isto se o SMTP estiver ativado.",
  "admin.config.email.share-recipients-subject": "Assunto dos destinatários do compartilhamento",
  "admin.config.email.share-recipients-subject.description": "Assunto do e-mail enviado para os destinatários do compartilhamento.",
  "admin.config.email.share-recipients-message": "Assunto dos destinatários do compartilhamento",
  "admin.config.email.share-recipients-message.description": "Mensagem que é enviada para os destinatários do compartilhamento. Variáveis disponíveis:\n {creator} - O nome de usuário do criador do compartilhamento\n {creatorEmail} - O e-mail do criador do compartilhamento\n {shareUrl} - A URL do compartilhamento\n {desc} - A descrição do compartilhamento\n {expires} - A data de expiração do compartilhamento\n Essas variáveis serão substituídas pelo valor real.",
  "admin.config.email.reverse-share-subject": "Assunto do compartilhamento reverso",
  "admin.config.email.reverse-share-subject.description": "Assunto do e-mail enviado quando alguém criou um compartilhamento com o seu link reverso.",
  "admin.config.email.reverse-share-message": "Mensagem do compartilhamento reverso",
  "admin.config.email.reverse-share-message.description": "Mensagem enviada quando alguém criou um compartilhamento com o link reverso. {shareUrl} será substituído pelo nome do criador e pela URL de compartilhamento.",
  "admin.config.email.reset-password-subject": "Redefinir assunto da senha",
  "admin.config.email.reset-password-subject.description": "Assunto do e-mail enviado quando um usuário solicita uma redefinição de senha.",
  "admin.config.email.reset-password-message": "Mensagem de redefinição de senha",
  "admin.config.email.reset-password-message.description": "Mensagem enviada quando um usuário solicita uma redefinição de senha. {url} será substituído pela URL de redefinição de senha.",
  "admin.config.email.invite-subject": "Assunto do convite",
  "admin.config.email.invite-subject.description": "Assunto do e-mail enviado quando um administrador convida um usuário.",
  "admin.config.email.invite-message": "Mensagem de convite",
  "admin.config.email.invite-message.description": "Mensagem que é enviada quando um administrador convida um usuário. {url} será substituído pelo URL de convite, {email} com o e-mail e {password} com a senha do usuário.",
  "admin.config.share.allow-registration": "Permitir novos registos",
  "admin.config.share.allow-registration.description": "Se o registro é permitido",
  "admin.config.share.allow-unauthenticated-shares": "Permitir compartilhamentos sem autenticação",
  "admin.config.share.allow-unauthenticated-shares.description": "Se usuários não autenticados podem criar compartilhamentos",
  "admin.config.share.max-expiration": "Expiração máxima",
  "admin.config.share.max-expiration.description": "Maximum share expiration. Set to 0 to allow unlimited expiration.",
  "admin.config.share.share-id-length": "Comprimento da ID do compartilhamento padrão",
  "admin.config.share.share-id-length.description": "Comprimento padrão para a ID gerada de um compartilhamento. Este valor também é usado para gerar links para ações reversas. Um valor abaixo de 8 não é considerado seguro.",
  "admin.config.share.max-size": "Tamanho máximo",
  "admin.config.share.max-size.description": "Tamanho máximo do compartilhamento",
  "admin.config.share.zip-compression-level": "Nível de compressão",
  "admin.config.share.zip-compression-level.description": "Ajuste o nível para equilibrar entre o tamanho do arquivo e a velocidade de compressão. Valores válidos vão de 0 a 9, com 0 sendo sem compressão e 9 sendo compressão máxima. ",
  "admin.config.share.chunk-size": "Tamanho do pedaço",
  "admin.config.share.chunk-size.description": "Ajuste o tamanho do pedaço para seus uploads equilibrarem eficiência e confiabilidade de acordo com sua conexão com a internet. Pedaços menores podem aumentar as taxas de sucesso para conexões instáveis, enquanto partes maiores aceleram uploads para conexões estáveis.",
  "admin.config.share.auto-open-share-modal": "Abertura automática do modal de criação de compartilhamento",
  "admin.config.share.auto-open-share-modal.description": "O modal de criação de compartilhamento aparece automaticamente quando um usuário seleciona arquivos, eliminando a necessidade de clicar manualmente no botão.",
  "admin.config.smtp.enabled": "Habilitar",
  "admin.config.smtp.enabled.description": "Se o SMTP está habilitado. Apenas defina como verdadeiro se você digitou o servidor, porta, e-mail, usuário e senha do seu servidor SMTP.",
  "admin.config.smtp.host": "Servidor",
  "admin.config.smtp.host.description": "Nome do Servidor SMTP",
  "admin.config.smtp.port": "Porta",
  "admin.config.smtp.port.description": "Porta do Servidor SMTP",
  "admin.config.smtp.email": "E-mail",
  "admin.config.smtp.email.description": "Endereço de e-mail do qual os e-mails são enviados",
  "admin.config.smtp.username": "Nome de usuário",
  "admin.config.smtp.username.description": "Nome de usuário do servidor SMTP",
  "admin.config.smtp.password": "Senha",
  "admin.config.smtp.password.description": "Senha do servidor SMTP",
  "admin.config.smtp.button.test": "Enviar email de teste",
  "admin.config.smtp.allow-unauthorized-certificates": "Confiar em certificados de servidor SMTP não autorizados",
  "admin.config.smtp.allow-unauthorized-certificates.description": "Apenas defina isso como verdadeiro se você precisar confiar nos certificados auto-assinados.",
  "admin.config.oauth.allow-registration": "Permitir registro",
  "admin.config.oauth.allow-registration.description": "Permitir que os usuários se registrem através do login de redes sociais",
  "admin.config.oauth.ignore-totp": "Ignorar TOTP",
  "admin.config.oauth.ignore-totp.description": "Ignorar o TOTP quando usuário usando login social",
  "admin.config.oauth.disable-password": "Desativar login por senha",
  "admin.config.oauth.disable-password.description": "Se deseja desativar o login por senha\nCertifique-se de que um provedor OAuth está configurado corretamente antes de ativar essa configuração para evitar ser bloqueado.",
  "admin.config.oauth.github-enabled": "GitHub",
  "admin.config.oauth.github-enabled.description": "Se o login GitHub está habilitado",
  "admin.config.oauth.github-client-id": "Client ID do GitHub",
  "admin.config.oauth.github-client-id.description": "ID do cliente do aplicativo GitHub OAuth",
  "admin.config.oauth.github-client-secret": "Client Secret do GitHub",
  "admin.config.oauth.github-client-secret.description": "ID do cliente do aplicativo GitHub OAuth",
  "admin.config.oauth.google-enabled": "Google",
  "admin.config.oauth.google-enabled.description": "Se o login GitHub está habilitado",
  "admin.config.oauth.google-client-id": "Client ID do Google",
  "admin.config.oauth.google-client-id.description": "ID do cliente do aplicativo GitHub OAuth",
  "admin.config.oauth.google-client-secret": "Client Secret do Google",
  "admin.config.oauth.google-client-secret.description": "Client secret do aplicativo GitHub OAuth",
  "admin.config.oauth.microsoft-enabled": "Microsoft",
  "admin.config.oauth.microsoft-enabled.description": "Se o Microsoft login está habilitado",
  "admin.config.oauth.microsoft-tenant": "Microsoft Tenant",
  "admin.config.oauth.microsoft-tenant.description": "O ID do Tenant do app Microsoft OAuth\ncomum: Usuários com uma conta pessoal da Microsoft e uma conta de trabalho ou escola do Microsoft Entra podem entrar no aplicativo. organizações: somente usuários com contas de trabalho ou de escola do Microsoft Entra ID podem entrar no aplicativo.\nconsumidores: Somente usuários com uma conta pessoal da Microsoft podem acessar o aplicativo.\nnome de domínio do tenant Microsoft Entra ou do ID do inquilino no formato GUID: Somente usuários de um tenant Microsoft Entra específico (membros do diretório com uma conta de trabalho ou de diretório com uma conta pessoal da Microsoft) podem entrar no aplicativo.",
  "admin.config.oauth.microsoft-client-id": "ID do Cliente Microsoft",
  "admin.config.oauth.microsoft-client-id.description": "ID do cliente do aplicativo Microsoft OAuth",
  "admin.config.oauth.microsoft-client-secret": "Segredo do Cliente Microsoft",
  "admin.config.oauth.microsoft-client-secret.description": "Client secret do aplicativo Microsoft OAuth",
  "admin.config.oauth.discord-enabled": "Discord",
  "admin.config.oauth.discord-enabled.description": "Se o login do Discord está habilitado",
  "admin.config.oauth.discord-limited-users": "Usuários limitados do Discord",
  "admin.config.oauth.discord-limited-users.description": "Limite de login em usuários específicos por sua ID do Discord. Deixe em branco para desativar.",
  "admin.config.oauth.discord-limited-guild": "ID do servidor limitado do Discord",
  "admin.config.oauth.discord-limited-guild.description": "Limite de login para usuários em um servidor específico. Deixe em branco para desativar.",
  "admin.config.oauth.discord-client-id": "ID do Cliente Discord",
  "admin.config.oauth.discord-client-id.description": "ID do cliente do aplicativo Discord OAuth",
  "admin.config.oauth.discord-client-secret": "Segredo do Cliente Discord",
  "admin.config.oauth.discord-client-secret.description": "ID do cliente do aplicativo Discord OAuth",
  "admin.config.oauth.oidc-enabled": "Conectar o OpenID",
  "admin.config.oauth.oidc-enabled.description": "Se o login do OpenID Connect está ativado",
  "admin.config.oauth.oidc-discovery-uri": "URI de descoberta do OpenID Connect",
  "admin.config.oauth.oidc-discovery-uri.description": "URI da descoberta do aplicativo OpenID Connect OAuth",
  "admin.config.oauth.oidc-sign-out": "Sair do OpenID Connect",
  "admin.config.oauth.oidc-sign-out.description": "Se o botão “Sair” fará o logout do provedor OpenID Connect",
  "admin.config.oauth.oidc-scope": "Escopo OpenID Connect",
  "admin.config.oauth.oidc-scope.description": "Escopos que devem ser solicitados a partir do provedor OpenID Connect.",
  "admin.config.oauth.oidc-username-claim": "Reivindicação de nome de usuário OpenID Connect",
  "admin.config.oauth.oidc-username-claim.description": "Nome de usuário no token de ID OpenID Connect. Deixe em branco se você não sabe o que é esta configuração.",
  "admin.config.oauth.oidc-role-path": "Caminho para as funções no token OpenID Connect",
  "admin.config.oauth.oidc-role-path.description": "Deve ser um caminho JMES válido, fazendo referência a uma matriz de funções. " + "Gerenciar direitos de acesso usando as funções OpenID Connect só é recomendado se nenhum outro provedor de identidade for configurado e o login por senha for desativado. " + "Deixe em branco se você não sabe o que é esta configuração.",
  "admin.config.oauth.oidc-role-general-access": "Função OpenID Connect para acesso geral",
  "admin.config.oauth.oidc-role-general-access.description": "Função necessária para acesso geral. Deve estar presente nas funções de um usuário para que ele faça o login. " + "Deixe em branco se você não sabe o que é esta configuração.",
  "admin.config.oauth.oidc-role-admin-access": "Função OpenID Connect para acesso de administrador",
  "admin.config.oauth.oidc-role-admin-access.description": "Função necessária para acesso administrativo. Deve estar presente nos papéis de um usuário para ele acessar o painel de administração. " + "Deixe em branco se você não sabe o que é esta configuração.",
  "admin.config.oauth.oidc-client-id": "ID do cliente OpenID Connect",
  "admin.config.oauth.oidc-client-id.description": "ID do cliente do aplicativo OpenID OAuth",
  "admin.config.oauth.oidc-client-secret": "Segredo do cliente OpenID Connect",
  "admin.config.oauth.oidc-client-secret.description": "ID do cliente do aplicativo OpenID OAuth",
  "admin.config.category.ldap": "LDAP",
  "admin.config.ldap.enabled": "Habilitar LDAP",
  "admin.config.ldap.enabled.description": "Usar autenticação LDAP para login de usuário",
  "admin.config.ldap.url": "URL do Servidor",
  "admin.config.ldap.url.description": "URL do Servidor LDAP",
  "admin.config.ldap.bind-dn": "Bind DN",
  "admin.config.ldap.bind-dn.description": "Usuário padrão usado para realizar a pesquisa de usuário",
  "admin.config.ldap.bind-password": "Bind Password",
  "admin.config.ldap.bind-password.description": "Senha usada para realizar a busca de usuários",
  "admin.config.ldap.search-base": "Base de Usuários",
  "admin.config.ldap.search-base.description": "Localização base, onde a pesquisa do usuário será realizada",
  "admin.config.ldap.search-query": "Consulta de usuário",
  "admin.config.ldap.search-query.description": "A consulta do usuário será usada para pesquisar a 'base de usuários' para o usuário LDAP. %username% pode ser usado como espaço reservado para o usuário fornecido na entrada.",
  "admin.config.ldap.admin-groups": "Grupo de administração",
  "admin.config.ldap.admin-groups.description": "Grupo necessário para acesso administrativo.",
  "admin.config.ldap.field-name-member-of": "Nome do atributo do grupo de usuários",
  "admin.config.ldap.field-name-member-of.description": "Nome do atributo LDAP para os grupos, de um usuário é membro. Isto é usado ao verificar para o grupo de administração.",
  "admin.config.ldap.field-name-email": "Nome do atributo do grupo de usuários",
  "admin.config.ldap.field-name-email.description": "Nome do atributo LDAP para o email de um usuário.",
  "admin.config.notify.success": "Configuração atualizada com sucesso.",
  "admin.config.notify.logo-success": "Logo atualizado com sucesso. Pode levar alguns minutos para ser atualizado no site.",
  "admin.config.notify.no-changes": "Nenhuma alteração para salvar.",
  "admin.config.category.s3": "S3",
  "admin.config.s3.enabled": "Habilitado",
  "admin.config.s3.enabled.description": "Se o S3 deve ser usado para armazenar os arquivos compartilhados em vez do sistema de arquivo local.",
  "admin.config.s3.endpoint": "Endpoint",
  "admin.config.s3.endpoint.description": "A URL do bucket S3.",
  "admin.config.s3.region": "Região",
  "admin.config.s3.region.description": "A região do bucket S3.",
  "admin.config.s3.bucket-name": "Nome do Bucket",
  "admin.config.s3.bucket-name.description": "O nome do bucket S3.",
  "admin.config.s3.bucket-path": "Caminho",
  "admin.config.s3.bucket-path.description": "O caminho padrão que deve ser usado para armazenar os arquivos no bucket S3.",
  "admin.config.s3.key": "Chave",
  "admin.config.s3.key.description": "A chave que permite a você acessar o bucket S3.",
  "admin.config.s3.secret": "Segredo",
  "admin.config.s3.secret.description": "O segredo que permite a você acessar o bucket S3.",
  "admin.config.category.legal": "Legal",
  "admin.config.legal.enabled": "Enable legal notices",
  "admin.config.legal.enabled.description": "Whether to show a link to imprint and privacy policy in the footer.",
  "admin.config.legal.imprint-text": "Imprint text",
  "admin.config.legal.imprint-text.description": "The text which should be shown in the imprint. Supports Markdown. Leave blank to link to an external imprint page.",
  "admin.config.legal.imprint-url": "Imprint URL",
  "admin.config.legal.imprint-url.description": "If you already have an imprint page you can link it here instead of using the text field.",
  "admin.config.legal.privacy-policy-text": "Privacy policy text",
  "admin.config.legal.privacy-policy-text.description": "The text which should be shown in the privacy policy. Supports Markdown. Leave blank to link to an external privacy policy page.",
  "admin.config.legal.privacy-policy-url": "Privacy policy URL",
  "admin.config.legal.privacy-policy-url.description": "If you already have a privacy policy page you can link it here instead of using the text field.",
  // 404
  "404.description": "Ops, esta página não existe.",
  "404.button.home": "Me traga de volta para casa",
  // error
  "error.title": "Erro",
  "error.description": "Oops!",
  "error.button.back": "Voltar",
  "error.msg.default": "Algo deu errado.",
  "error.msg.access_denied": "Você cancelou o processo de autenticação, por favor, tente novamente.",
  "error.msg.expired_token": "O processo de autenticação demorou muito. Por favor, tente novamente.",
  "error.msg.invalid_token": "Erro interno",
  "error.msg.no_user": "O usuário vinculado a esta conta {0} não existe.",
  "error.msg.no_email": "Não é possível obter o endereço de e-mail desta conta {0}.",
  "error.msg.already_linked": "Esta conta {0} já está vinculada a outra conta.",
  "error.msg.not_linked": "Esta conta {0} ainda não foi vinculada a nenhuma conta.",
  "error.msg.unverified_account": "Esta conta {0} não foi verificada, tente novamente após a verificação.",
  "error.msg.user_not_allowed": "Você não tem permissão para acessar.",
  "error.msg.cannot_get_user_info": "Não é possível obter suas informações de usuário desta conta {0}.",
  "error.param.provider_github": "GitHub",
  "error.param.provider_google": "Google",
  "error.param.provider_microsoft": "Microsoft",
  "error.param.provider_discord": "Discord",
  "error.param.provider_oidc": "OpenID Connect",
  // Common translations
  "common.button.save": "Salvar",
  "common.button.create": "Criar",
  "common.button.submit": "Submeter",
  "common.button.delete": "Excluir",
  "common.button.cancel": "Cancelar",
  "common.button.confirm": "Confirmar",
  "common.button.disable": "Desativar",
  "common.button.share": "Compartilhamento",
  "common.button.generate": "Gerar",
  "common.button.done": "Concluído",
  "common.text.link": "Link",
  "common.text.navigate-to-link": "Visitar Link",
  "common.text.or": "ou",
  "common.text.redirecting": "Redirecionando...",
  "common.button.go-back": "Voltar",
  "common.button.go-home": "Voltar para o Início",
  "common.notify.copied": "O seu link foi copiado para a área de transferência",
  "common.notify.copied-link": "O seu link foi copiado para a área de transferência",
  "common.success": "Sucesso",
  "common.error": "Erro",
  "common.error.unknown": "Ocorreu um erro desconhecido",
  "common.error.invalid-email": "Endereço de e-mail inválido",
  "common.error.too-short": "Deve ter no mínimo {length} caracteres",
  "common.error.too-long": "Deve ter no máximo {length} caracteres",
  "common.error.number-too-small": "Deve ser pelo menos {min}",
  "common.error.number-too-large": "Deve ser no máximo {max}",
  "common.error.exact-length": "Deve ter exatamente {length} caracteres",
  "common.error.invalid-number": "Tem que ser um número",
  "common.error.field-required": "Este campo é obrigatório"
};