export default {
  // Navbar
  "navbar.upload": "Téléverser",
  "navbar.signin": "Se connecter",
  "navbar.home": "Accueil",
  "navbar.signup": "S’inscrire",
  "navbar.links.shares": "Mes partages",
  "navbar.links.reverse": "Partages inversés",
  "navbar.avatar.account": "Mon compte",
  "navbar.avatar.admin": "Administration",
  "navbar.avatar.signout": "Se déconnecter",
  // END navbar
  // /
  "home.title": "Une plateforme de partage de fichiers <h>autohébergée</h>.",
  "home.description": "Voulez-vous vraiment remettre vos fichiers personnels dans les mains de tiers comme WeTransfer ?",
  "home.bullet.a.name": "Auto-hébergé",
  "home.bullet.a.description": "Hébergez Pingvin Share sur votre propre machine.",
  "home.bullet.b.name": "Confidentialité",
  "home.bullet.b.description": "Vos fichiers sont les vôtres et ne seront jamais consultés par des tiers.",
  "home.bullet.c.name": "Aucune rébarbative limite de taille",
  "home.bullet.c.description": "Téléchargez des fichiers aussi volumineux que vous le souhaitez. Votre disque dur est votre limite.",
  "home.button.start": "Commencer",
  "home.button.source": "Code source",
  // END /
  // /auth/signin
  "signin.title": "Content de vous revoir",
  "signin.description": "Vous n'avez pas encore de compte ?",
  "signin.button.signup": "S’inscrire",
  "signin.input.email-or-username": "Courriel ou nom d'utilisateur",
  "signin.input.email-or-username.placeholder": "Votre courriel ou nom d'utilisateur",
  "signin.input.password": "Mot de passe",
  "signin.input.password.placeholder": "Votre mot de passe",
  "signin.button.submit": "Se connecter",
  "signIn.notify.totp-required.title": "Une authentification à deux facteurs est requise",
  "signIn.notify.totp-required.description": "Veuillez entrer votre code d'authentification à deux facteurs",
  "signIn.oauth.or": "OU",
  "signIn.oauth.signInWith": "Se connecter avec",
  "signIn.oauth.github": "GitHub",
  "signIn.oauth.google": "Google",
  "signIn.oauth.microsoft": "Microsoft",
  "signIn.oauth.discord": "Discord",
  "signIn.oauth.oidc": "OpenID",
  // END /auth/signin
  // /auth/signup
  "signup.title": "Créer un compte",
  "signup.description": "Vous avez déjà un compte ?",
  "signup.button.signin": "Se connecter",
  "signup.input.username": "Nom d'utilisateur",
  "signup.input.username.placeholder": "Votre nom d'utilisateur",
  "signup.input.email": "Adresse email",
  "signup.input.email.placeholder": "Votre courriel",
  "signup.button.submit": "Commençons",
  // END /auth/signup
  // /auth/totp
  "totp.title": "Authentification TOTP",
  "totp.button.signIn": "Se connecter",
  // END /auth/totp
  // /auth/reset-password
  "resetPassword.title": "Mot de passe oublié ?",
  "resetPassword.description": "Saisissez votre courriel pour réinitialiser votre mot de passe.",
  "resetPassword.notify.success": "Un message avec un lien pour réinitialiser votre mot de passe a été envoyé si le courriel fourni existe.",
  "resetPassword.button.back": "Retour à la page de connexion",
  "resetPassword.text.resetPassword": "Réinitialiser le mot de passe",
  "resetPassword.text.enterNewPassword": "Saisissez votre nouveau mot de passe",
  "resetPassword.input.password": "Nouveau mot de passe",
  "resetPassword.notify.passwordReset": "Votre mot de passe a été réinitialisé avec succès.",
  // /account
  "account.title": "Mon compte",
  "account.card.info.title": "Détails du compte",
  "account.card.info.username": "Surnom",
  "account.card.info.email": "Adresse email",
  "account.notify.info.success": "Compte mis à jour avec succès",
  "account.card.password.title": "Mot de passe",
  "account.card.password.old": "Ancien mot de passe",
  "account.card.password.new": "Nouveau mot de passe",
  "account.card.password.noPasswordSet": "Vous n’avez pas de mot de passe défini. Si vous voulez vous connecter avec un courriel et un mot de passe, vous devez définir un mot de passe.",
  "account.notify.password.success": "Le mot de passe a été modifié avec succès",
  "account.card.oauth.title": "Identifiant social",
  "account.card.oauth.github": "GitHub",
  "account.card.oauth.google": "Google",
  "account.card.oauth.microsoft": "Microsoft",
  "account.card.oauth.discord": "Discord",
  "account.card.oauth.oidc": "OpenID",
  "account.card.oauth.link": "Associer",
  "account.card.oauth.unlink": "Dissocier",
  "account.card.oauth.unlinked": "Dissocié",
  "account.modal.unlink.title": "Dissocier le compte",
  "account.modal.unlink.description": "Délier vos réseaux sociaux peut vous faire perdre votre compte si vous ne vous souvenez pas de vos identifiants de connexion",
  "account.notify.oauth.unlinked.success": "Dissocié avec succès",
  "account.card.security.title": "Sécurité",
  "account.card.security.totp.enable.description": "Entrez votre mot de passe actuel pour activer TOTP",
  "account.card.security.totp.disable.description": "Entrez votre mot de passe actuel pour désactiver TOTP",
  "account.card.security.totp.button.start": "Démarrer",
  "account.modal.totp.title": "Activer la double authentification",
  "account.modal.totp.step1": "Étape 1 : Ajouter votre authentification",
  "account.modal.totp.step2": "Étape 2 : Valider votre code",
  "account.modal.totp.enterManually": "Saisir manuellement",
  "account.modal.totp.code": "Code",
  "common.button.clickToCopy": "Cliquez pour copier",
  "account.modal.totp.verify": "Vérifier",
  "account.notify.totp.disable": "Double authentification (TOTP) désactivé avec succès",
  "account.notify.totp.enable": "TOTP activé avec succès",
  "account.card.language.title": "Langue",
  "account.card.language.description": "Le projet est traduit par la communauté. Certaines traductions peuvent être incomplètes.",
  "account.card.color.title": "Thème de couleurs",
  // ThemeSwitcher.tsx
  "account.theme.dark": "Sombre",
  "account.theme.light": "Clair",
  "account.theme.system": "Système",
  "account.button.delete": "Supprimer le compte",
  "account.modal.delete.title": "Supprimer le compte",
  "account.modal.delete.description": "Voulez-vous vraiment supprimer votre compte, y compris tous vos partages actifs ?",
  // END /account
  // /account/shares
  "account.shares.title": "Mes partages",
  "account.shares.title.empty": "Il n'y a rien ici 👀",
  "account.shares.description.empty": "Vous n’avez aucun partage.",
  "account.shares.button.create": "Créez-en un",
  "account.shares.info.title": "Détails du partage",
  "account.shares.table.id": "ID",
  "account.shares.table.name": "Nom",
  "account.shares.table.description": "Description",
  "account.shares.table.visitors": "Visiteurs",
  "account.shares.table.expiresAt": "Expire le",
  "account.shares.table.createdAt": "Créé le",
  "account.shares.table.size": "Taille",
  "account.shares.table.password-protected": "Protégé par un mot de passe",
  "account.shares.table.visitor-count": "{count} sur {max}",
  "account.shares.table.expiry-never": "Jamais",
  "account.shares.modal.share-informations": "Détails du partage",
  "account.shares.modal.share-link": "Lien de partage",
  "account.shares.modal.delete.title": "Supprimer le partage : {share}",
  "account.shares.modal.delete.description": "Voulez-vous vraiment supprimer ce partage ?",
  // END /account/shares
  // /account/reverseShares
  "account.reverseShares.title": "Partages inversés",
  "account.reverseShares.description": "Un partage inversé vous permet de générer une URL unique qui permet à des utilisateurs externes de créer un partage.",
  "account.reverseShares.title.empty": "C’est plutôt vide 👀",
  "account.reverseShares.description.empty": "Vous n’avez aucun partage inversé.",
  // showCreateReverseShareModal.tsx
  "account.reverseShares.modal.title": "Créer un partage inversé",
  "account.reverseShares.modal.expiration.label": "Expiration",
  "account.reverseShares.modal.expiration.minute-singular": "Minute",
  "account.reverseShares.modal.expiration.minute-plural": "Minutes",
  "account.reverseShares.modal.expiration.hour-singular": "Heure",
  "account.reverseShares.modal.expiration.hour-plural": "Heures",
  "account.reverseShares.modal.expiration.day-singular": "Jour",
  "account.reverseShares.modal.expiration.day-plural": "Jours",
  "account.reverseShares.modal.expiration.week-singular": "Semaine",
  "account.reverseShares.modal.expiration.week-plural": "Semaines",
  "account.reverseShares.modal.expiration.month-singular": "Mois",
  "account.reverseShares.modal.expiration.month-plural": "Mois",
  "account.reverseShares.modal.expiration.year-singular": "An",
  "account.reverseShares.modal.expiration.year-plural": "Ans",
  "account.reverseShares.modal.max-size.label": "Taille maximale du partage",
  "account.reverseShares.modal.send-email": "Envoyer des notifications par courriel",
  "account.reverseShares.modal.send-email.description": "Vous envoi une notification par courriel lorsqu'un partage est créé avec ce lien de partage inversé.",
  "account.reverseShares.modal.simplified": "Mode simple",
  "account.reverseShares.modal.simplified.description": "Simplifiez la tâche à la personne qui vous partage un fichier. Ils ne pourront que personnaliser le nom et la description du partage.",
  "account.reverseShares.modal.public-access": "Accès public",
  "account.reverseShares.modal.public-access.description": "Rendre les partages créés avec ce partage inversé public. Si désactivé, seul vous et le créateur du partage pourrez le voir.",
  "account.reverseShares.modal.max-use.label": "Nombre d'utilisations max",
  "account.reverseShares.modal.max-use.description": "Le nombre maximal de fois que cette URL peut être utilisée pour créer un partage.",
  "account.reverseShare.never-expires": "Ce partage inversé n'expirera jamais.",
  "account.reverseShare.expires-on": "Ce partage inversé expirera le {expiration}.",
  "account.reverseShares.table.no-shares": "Aucun partage créé pour le moment",
  "account.reverseShares.table.count.singular": "partage",
  "account.reverseShares.table.count.plural": "partages",
  "account.reverseShares.table.shares": "Partages",
  "account.reverseShares.table.remaining": "Utilisations restantes",
  "account.reverseShares.table.max-size": "Taille maximale du partage",
  "account.reverseShares.table.expires": "Expire le",
  "account.reverseShares.modal.reverse-share-link": "Lien du partage inversé",
  "account.reverseShares.modal.delete.title": "Supprimer le partage inversé",
  "account.reverseShares.modal.delete.description": "Voulez-vous vraiment supprimer ce partage inversé ? Si vous le faites, les partages qu’il contient seront également supprimés.",
  // END /account/reverseShares
  // /admin
  "admin.title": "Administration",
  "admin.button.users": "Gestion des utilisateurs",
  "admin.button.shares": "Gestion des partages",
  "admin.button.config": "Paramètres",
  "admin.version": "Version",
  // END /admin
  // /admin/users
  "admin.users.title": "Gestion des utilisateurs",
  "admin.users.table.username": "Surnom",
  "admin.users.table.email": "Courriel",
  "admin.users.table.admin": "Admin",
  "admin.users.edit.update.title": "Modifier l'utilisateur : {username}",
  "admin.users.edit.update.admin-privileges": "Privilèges d’admin",
  "admin.users.edit.update.change-password.title": "Changer le mot de passe",
  "admin.users.edit.update.change-password.field": "Nouveau mot de passe",
  "admin.users.edit.update.change-password.button": "Enregistrer le nouveau mot de passe",
  "admin.users.edit.update.notify.password.success": "Le mot de passe a été modifié",
  "admin.users.edit.delete.title": "Supprimer l'utilisateur : {username} ?",
  "admin.users.edit.delete.description": "Souhaitez-vous vraiment supprimer cet utilisateur et tous ses partages ?",
  // showCreateUserModal.tsx
  "admin.users.modal.create.title": "Créer un utilisateur",
  "admin.users.modal.create.username": "Surnom",
  "admin.users.modal.create.email": "Courriel",
  "admin.users.modal.create.password": "Mot de passe",
  "admin.users.modal.create.manual-password": "Définir le mot de passe manuellement",
  "admin.users.modal.create.manual-password.description": "S’il n'est pas coché, l’utilisateur recevra un email avec un lien pour définir son mot de passe.",
  "admin.users.modal.create.admin": "Privilèges d’admin",
  "admin.users.modal.create.admin.description": "Si coché, l’utilisateur pourra accéder au panneau d'administration.",
  // END /admin/users
  // /admin/shares
  "admin.shares.title": "Gestion des partages",
  "admin.shares.table.id": "ID de partage",
  "admin.shares.table.username": "Créateur",
  "admin.shares.table.visitors": "Visiteurs",
  "admin.shares.table.expires": "Expire le",
  "admin.shares.edit.delete.title": "Supprimer le partage : {id}",
  "admin.shares.edit.delete.description": "Voulez-vous vraiment supprimer ce partage ?",
  // END /admin/shares
  // /upload
  "upload.title": "Envoyer",
  "upload.notify.confirm-leave": "Êtes-vous sûr de vouloir quitter cette page ? Votre envoi sera annulé.",
  "upload.notify.generic-error": "Une erreur est survenue durant le traitement de votre partage.",
  "upload.notify.count-failed": "{count} fichier(s) n’a(ont) pas pu être envoyé(s). Veuillez réessayer.",
  "upload.reverse-share.error.invalid.title": "Lien de partage inversé invalide",
  "upload.reverse-share.error.invalid.description": "Ce partage inversé a expiré ou n'est pas valide.",
  // Dropzone.tsx
  "upload.dropzone.title": "Téléverser des fichiers",
  "upload.dropzone.description": "Glisser-déposer les fichiers ici pour commencer votre partage. Nous n'acceptons que les fichiers jusqu'à {maxSize} au total.",
  "upload.dropzone.notify.file-too-big": "Vos fichiers dépassent la taille maximale de {maxSize}.",
  // FileList.tsx
  "upload.filelist.name": "Nom",
  "upload.filelist.size": "Taille",
  // showCreateUploadModal.tsx
  "upload.modal.title": "Créer un partage",
  "upload.modal.link.error.invalid": "Ne peut contenir que des lettres, des chiffres, des tirets bas et des traits d'union",
  "upload.modal.link.error.taken": "Ce lien est déjà utilisé",
  "upload.modal.not-signed-in": "Vous n'êtes pas connecté",
  "upload.modal.not-signed-in-description": "Vous ne pourrez pas supprimer votre partage manuellement et afficher le nombre de visiteurs.",
  "upload.modal.expires.never": "jamais",
  "upload.modal.expires.never-long": "Partage permanent",
  "upload.modal.expires.error.too-long": "La date d'expiration dépasse le maximum de {max}.",
  "upload.modal.link.label": "Lien",
  "upload.modal.expires.label": "Expiration",
  "upload.modal.expires.minute-singular": "Minute",
  "upload.modal.expires.minute-plural": "Minutes",
  "upload.modal.expires.hour-singular": "Heure",
  "upload.modal.expires.hour-plural": "Heures",
  "upload.modal.expires.day-singular": "Jour",
  "upload.modal.expires.day-plural": "Jours",
  "upload.modal.expires.week-singular": "Semaine",
  "upload.modal.expires.week-plural": "Semaines",
  "upload.modal.expires.month-singular": "Mois",
  "upload.modal.expires.month-plural": "Mois",
  "upload.modal.expires.year-singular": "An",
  "upload.modal.expires.year-plural": "Ans",
  "upload.modal.accordion.name-and-description.title": "Nom et description",
  "upload.modal.accordion.name-and-description.name.placeholder": "Nom",
  "upload.modal.accordion.name-and-description.description.placeholder": "Note pour les destinataires de ce partage",
  "upload.modal.accordion.email.title": "Adresse courriel des destinataires",
  "upload.modal.accordion.email.placeholder": "Saisir les destinataires de ce partage",
  "upload.modal.accordion.email.invalid-email": "Courriel invalide",
  "upload.modal.accordion.security.title": "Options de sécurité",
  "upload.modal.accordion.security.password.label": "Protection par mot de passe",
  "upload.modal.accordion.security.password.placeholder": "Aucun mot de passe",
  "upload.modal.accordion.security.max-views.label": "Nombre de vues maximum",
  "upload.modal.accordion.security.max-views.placeholder": "Aucune limite",
  // showCompletedUploadModal.tsx
  "upload.modal.completed.never-expires": "Ce partage n’expirera jamais.",
  "upload.modal.completed.expires-on": "Ce partage expirera le {expiration}.",
  "upload.modal.completed.share-ready": "Partage prêt",
  "upload.modal.completed.notified-reverse-share-creator": "Nous avons notifié le créateur du partage inverse. Vous pouvez également partager manuellement ce lien avec eux par d'autres moyens.",
  // END /upload
  // /share/[id]
  "share.title": "Partage {shareId}",
  "share.description": "Regardez ce que j’ai partagé !",
  "share.error.visitor-limit-exceeded.title": "Limite de visiteurs dépassée",
  "share.error.visitor-limit-exceeded.description": "La limite de visiteurs de ce partage a été dépassée.",
  "share.error.removed.title": "Partage supprimé",
  "share.error.not-found.title": "Partage introuvable",
  "share.error.not-found.description": "Le partage que vous cherchez n’existe pas.",
  "share.error.access-denied.title": "Partage privé",
  "share.error.access-denied.description": "Le compte actuel n'a pas la permission d'accéder à ce partage",
  "share.modal.password.title": "Mot de passe requis",
  "share.modal.password.description": "Veuillez entrer le mot de passe d'accès à ce partage.",
  "share.modal.password": "Mot de passe",
  "share.modal.error.invalid-password": "Mot de passe incorrect",
  "share.button.download-all": "Télécharger tout",
  "share.notify.download-all-preparing": "Le partage est en préparation. Réessayez dans quelques minutes.",
  "share.modal.file-link": "Lien du fichier",
  "share.table.name": "Nom",
  "share.table.size": "Taille",
  "share.modal.file-preview.error.not-supported.title": "Aperçu non supporté",
  "share.modal.file-preview.error.not-supported.description": "Les aperçus ne sont pas pris en charge pour ce type de fichiers. Veuillez télécharger le fichier pour le voir.",
  // END /share/[id]
  // /share/[id]/edit
  "share.edit.title": "Modifier {shareId}",
  "share.edit.append-upload": "Ajouter un fichier",
  "share.edit.notify.generic-error": "Une erreur est survenue durant le traitement de votre partage.",
  "share.edit.notify.save-success": "Partage mis à jour avec succès",
  // END /share/[id]/edit
  // /imprint
  "imprint.title": "Imprint",
  // END /imprint
  // /privacy
  "privacy.title": "Privacy Policy",
  // END /privacy
  // /admin/config
  "admin.config.title": "Paramètres",
  "admin.config.category.general": "Général",
  "admin.config.category.share": "Partage",
  "admin.config.category.email": "Courriel",
  "admin.config.category.smtp": "SMTP",
  "admin.config.category.oauth": "Identifiant social",
  "admin.config.general.app-name": "Nom de l’appli",
  "admin.config.general.app-name.description": "Le nom de l’application",
  "admin.config.general.app-url": "URL de l’appli",
  "admin.config.general.app-url.description": "Depuis quel URL le partage Pingvin est disponible",
  "admin.config.general.secure-cookies": "Cookies sécurisés",
  "admin.config.general.secure-cookies.description": "Définir ou non le marquage sécurisé sur les cookies. Si activé, le site ne fonctionnera pas lorsqu'il est accédé via HTTP.",
  "admin.config.general.show-home-page": "Afficher la page d’accueil",
  "admin.config.general.show-home-page.description": "Afficher ou non la page d’accueil",
  "admin.config.general.session-duration": "Durée de la session",
  "admin.config.general.session-duration.description": "Nombre d’heures après lesquelles un utilisateur doit se reconnecter (par défaut : 3 mois).",
  "admin.config.general.logo": "Logo",
  "admin.config.general.logo.description": "Changez de logo en envoyant une nouvelle image. L’image doit être au format PNG et doit avoir un ratio 1:1.",
  "admin.config.general.logo.placeholder": "Sélectionner une image",
  "admin.config.email.enable-share-email-recipients": "Activer le partage par courriel",
  "admin.config.email.enable-share-email-recipients.description": "Autoriser ou non le partage de courriels avec les destinataires. N'activer cette option que si SMTP est activé.",
  "admin.config.email.share-recipients-subject": "Sujet d’un partage",
  "admin.config.email.share-recipients-subject.description": "Intitulé du courriel envoyé aux destinataires d’un partage.",
  "admin.config.email.share-recipients-message": "Message d’un partage",
  "admin.config.email.share-recipients-message.description": "Contenu du courriel qui est envoyé aux destinataires du partage. Variables possibles :\n {creator} - Le nom d'utilisateur du créateur du partage\n {creatorEmail} - L'adresse mail du créateur du partage\n {shareUrl} - L'URL du partage\n {desc} - La description du partage\n {expires} - La date d'expiration du partage.\n Ces variables seront remplacées par leur valeur effective.",
  "admin.config.email.reverse-share-subject": "Sujet d’un partage inversé",
  "admin.config.email.reverse-share-subject.description": "Intitulé du courriel envoyé lorsque quelqu’un a partagé des fichiers depuis votre partage inversé.",
  "admin.config.email.reverse-share-message": "Message d’un partage inversé",
  "admin.config.email.reverse-share-message.description": "Contenu du courriel envoyé lorsque quelqu’un partage des fichiers depuis votre partage inversé. {shareUrl} sera remplacé par le nom du créateur et l’URL de partage.",
  "admin.config.email.reset-password-subject": "Sujet d’une réinitialisation du mot de passe",
  "admin.config.email.reset-password-subject.description": "Intitulé du courriel envoyé lorsqu’un utilisateur demande une réinitialisation de son mot de passe.",
  "admin.config.email.reset-password-message": "Message de réinitialisation du mot de passe",
  "admin.config.email.reset-password-message.description": "Contenu du courriel envoyé lorsqu’un utilisateur demande à réinitialiser son mot de passe. {url} sera remplacé par l’URL de réinitialisation du mot de passe.",
  "admin.config.email.invite-subject": "Sujet d’une invitation",
  "admin.config.email.invite-subject.description": "Intitulé du courriel envoyé lorsqu’un administrateur invite un utilisateur.",
  "admin.config.email.invite-message": "Message d’une invitation",
  "admin.config.email.invite-message.description": "Message qui est envoyé lorsqu'un administrateur invite un utilisateur. {url} sera remplacé avec l'URL d'invitation, {email} avec le courriel et {password} avec le mot de passe de l'utilisateur.",
  "admin.config.share.allow-registration": "Autoriser les inscriptions",
  "admin.config.share.allow-registration.description": "Permet aux visiteurs de créer un compte",
  "admin.config.share.allow-unauthenticated-shares": "Autoriser les partages anonymes",
  "admin.config.share.allow-unauthenticated-shares.description": "Permet aux visiteurs de créer des partages",
  "admin.config.share.max-expiration": "Échéance",
  "admin.config.share.max-expiration.description": "Maximum share expiration. Set to 0 to allow unlimited expiration.",
  "admin.config.share.share-id-length": "Taille de l'identifiant généré",
  "admin.config.share.share-id-length.description": "Taille par défaut de l'identifiant généré pour un partage. Cette valeur est aussi utilisée pour générer les liens des partages inverses. Une valeur inférieure à 8 n'est pas considérée sûre.",
  "admin.config.share.max-size": "Taille max",
  "admin.config.share.max-size.description": "Taille maximale du partage",
  "admin.config.share.zip-compression-level": "Niveau de compression",
  "admin.config.share.zip-compression-level.description": "Ajustez le niveau pour trouver l'équilibre entre la taille du fichier et la vitesse de compression. Les valeurs valides vont de 0 à 9, 0 étant sans compression et 9 étant la compression maximale. ",
  "admin.config.share.chunk-size": "Taille des tronçons",
  "admin.config.share.chunk-size.description": "Ajustez la taille des tronçons pour que vos téléchargements équilibrent efficacité et fiabilité en fonction de votre connexion Internet. Les petits tronçons peuvent améliorer les taux de succès sur les connexions instables, tandis que les tronçons plus importants accélèrent les téléchargements sur les connexions stables.",
  "admin.config.share.auto-open-share-modal": "Ouvrir automatiquement la modale de partage",
  "admin.config.share.auto-open-share-modal.description": "La modale de création de partage apparaît automatiquement lorsqu’un utilisateur sélectionne des fichiers, ce qui élimine le besoin de cliquer manuellement sur le bouton.",
  "admin.config.smtp.enabled": "Activer",
  "admin.config.smtp.enabled.description": "Active SMTP. Activez ceci uniquement si vous avez saisi l’hôte, le port, le courriel, l’utilisateur et son mot de passe, de votre serveur SMTP.",
  "admin.config.smtp.host": "Hôte",
  "admin.config.smtp.host.description": "Nom du serveur SMTP",
  "admin.config.smtp.port": "Port",
  "admin.config.smtp.port.description": "Port du serveur SMTP",
  "admin.config.smtp.email": "Courriel",
  "admin.config.smtp.email.description": "Adresse à partir de laquelle les courriels sont envoyés",
  "admin.config.smtp.username": "Nom d’utilisateur",
  "admin.config.smtp.username.description": "Nom d’utilisateur du serveur SMTP",
  "admin.config.smtp.password": "Mot de passe",
  "admin.config.smtp.password.description": "Mot de passe du serveur SMTP",
  "admin.config.smtp.button.test": "Envoyer un courriel de test",
  "admin.config.smtp.allow-unauthorized-certificates": "Faire confiance aux certificats de serveurs SMTP non autorisés",
  "admin.config.smtp.allow-unauthorized-certificates.description": "Ne permettez ceci que si vous avez besoin de faire confiance aux certificats autosignés.",
  "admin.config.oauth.allow-registration": "Autoriser l’inscription",
  "admin.config.oauth.allow-registration.description": "Permettre aux utilisateurs de s’inscrire via leur identifiant social",
  "admin.config.oauth.ignore-totp": "Ignorer double authentification TOTP",
  "admin.config.oauth.ignore-totp.description": "Ignorer la double-authentification (TOTP) lorsque l’utilisateur utilise un identifiant social",
  "admin.config.oauth.disable-password": "Désactiver la connexion par mot de passe",
  "admin.config.oauth.disable-password.description": "Désactive la connexion par mot de passe\nAssurez-vous qu’un fournisseur OAuth soit correctement configuré avant d’activer cette configuration pour éviter d'être enfermé.",
  "admin.config.oauth.github-enabled": "GitHub",
  "admin.config.oauth.github-enabled.description": "Permettre la connexion via GitHub.",
  "admin.config.oauth.github-client-id": "ID client de GitHub",
  "admin.config.oauth.github-client-id.description": "L’ID du client de l’application OAuth GitHub",
  "admin.config.oauth.github-client-secret": "Secret du client GitHub",
  "admin.config.oauth.github-client-secret.description": "Le secret du client de l’application OAuth GitHub",
  "admin.config.oauth.google-enabled": "Google",
  "admin.config.oauth.google-enabled.description": "Permettre la connexion via Google.",
  "admin.config.oauth.google-client-id": "ID du client Google",
  "admin.config.oauth.google-client-id.description": "L’ID du client de l’application OAuth Google",
  "admin.config.oauth.google-client-secret": "Secret client de Google",
  "admin.config.oauth.google-client-secret.description": "Le secret du client de l’application OAuth Google",
  "admin.config.oauth.microsoft-enabled": "Microsoft",
  "admin.config.oauth.microsoft-enabled.description": "Permettre la connexion via Microsoft.",
  "admin.config.oauth.microsoft-tenant": "Locataire Microsoft",
  "admin.config.oauth.microsoft-tenant.description": "ID locataire de l'application OAuth Microsoft\nCommun : les utilisateurs ayant au choix un compte personnel ou d’entreprise issue de Microsoft Entra.\nOrganisations : limité aux utilisateurs ayant un compte d’entreprise ou d’université issue de Microsoft Entra.\nPersonnel : limité aux utilisateurs ayant un compte personnel\nDomanial : limité aux utilisateurs d'un domaine Microsoft Entra spécifié ou d’un ID locataire (au format GUID), qu’ils soient membres d’un registre d’entreprise ou d’université ou bien enregistrés en tant qu’invités avec un compte personnel.",
  "admin.config.oauth.microsoft-client-id": "ID du client Microsoft",
  "admin.config.oauth.microsoft-client-id.description": "L’ID du client de l’application Microsoft OAuth",
  "admin.config.oauth.microsoft-client-secret": "Secret du client Microsoft",
  "admin.config.oauth.microsoft-client-secret.description": "Le secret du client de l’application Microsoft OAuth",
  "admin.config.oauth.discord-enabled": "Discord",
  "admin.config.oauth.discord-enabled.description": "Permettre la connexion via Discord",
  "admin.config.oauth.discord-limited-users": "Utilisateurs limités sur Discord",
  "admin.config.oauth.discord-limited-users.description": "Limiter la connexion à des utilisateurs spécifiques par leur identifiant Discord. Laissez vide pour désactiver.",
  "admin.config.oauth.discord-limited-guild": "ID de serveur restreint Discord",
  "admin.config.oauth.discord-limited-guild.description": "Limiter la connexion aux utilisateurs sur un serveur spécifique. Laissez vide pour désactiver.",
  "admin.config.oauth.discord-client-id": "ID du client Discord",
  "admin.config.oauth.discord-client-id.description": "L’ID du client de l’application OAuth Discord",
  "admin.config.oauth.discord-client-secret": "Secret du client Discord",
  "admin.config.oauth.discord-client-secret.description": "Le secret du client de l’application OAuth Discord",
  "admin.config.oauth.oidc-enabled": "Connexion OpenID",
  "admin.config.oauth.oidc-enabled.description": "Permettre la connexion via OpenID",
  "admin.config.oauth.oidc-discovery-uri": "URI de découverte OpenID",
  "admin.config.oauth.oidc-discovery-uri.description": "L’URI de découverte de la connexion à l'application OpenID OAuth",
  "admin.config.oauth.oidc-sign-out": "Déconnexion du fournisseur OpenID Connect",
  "admin.config.oauth.oidc-sign-out.description": "Si activé, le bouton \"Déconnexion\" vous déconnectera également du fournisseur d'identité OpenID Connect",
  "admin.config.oauth.oidc-scope": "Paramètres de connexion OpenID",
  "admin.config.oauth.oidc-scope.description": "Paramètres fournis par votre fournisseur OpenID.",
  "admin.config.oauth.oidc-username-claim": "Revendication du nom d’utilisateur OpenID",
  "admin.config.oauth.oidc-username-claim.description": "Le champ contenant la revendication du nom d’utilisateur dans le jeton OpenID Connect. Laissez vide si vous ne savez pas quoi indiquer.",
  "admin.config.oauth.oidc-role-path": "Chemin vers les rôles dans le jeton OpenID Connect",
  "admin.config.oauth.oidc-role-path.description": "Doit être un chemin JMES valide référençant un tableau de rôles. " + "La gestion des droits d'accès en utilisant les rôles OpenID Connect n'est recommandée que si aucun autre fournisseur d'identité n'est configuré et que la connexion par mot de passe est désactivée. " + "Laissez vide si vous ne savez pas ce qu'est cette configuration.",
  "admin.config.oauth.oidc-role-general-access": "Rôle OpenID Connect pour un accès général",
  "admin.config.oauth.oidc-role-general-access.description": "Rôle requis pour un accès général. Doit être présent dans les rôles d'un utilisateur pour qu'il se connecte. " + "Laissez vide si vous ne savez pas ce qu'est cette configuration.",
  "admin.config.oauth.oidc-role-admin-access": "Rôle OpenID Connect pour l'accès admin",
  "admin.config.oauth.oidc-role-admin-access.description": "Rôle requis pour l'accès administratif. Doit être présent dans les rôles d'un utilisateur pour accéder au panneau d'administration. " + "Laissez vide si vous ne savez pas ce qu'est cette configuration.",
  "admin.config.oauth.oidc-client-id": "ID du client OpenID",
  "admin.config.oauth.oidc-client-id.description": "L’ID du client de l’application OAuth OpenID Connect",
  "admin.config.oauth.oidc-client-secret": "Secret du client OpenID",
  "admin.config.oauth.oidc-client-secret.description": "Le secret du client de l’application OAuth OpenID Connect",
  "admin.config.category.ldap": "LDAP",
  "admin.config.ldap.enabled": "Activer LDAP",
  "admin.config.ldap.enabled.description": "Utiliser l'authentification LDAP pour la connexion de l'utilisateur",
  "admin.config.ldap.url": "URL du serveur",
  "admin.config.ldap.url.description": "URL du serveur LDAP",
  "admin.config.ldap.bind-dn": "DN de liaison",
  "admin.config.ldap.bind-dn.description": "Utilisateur par défaut utilisé pour effectuer la recherche de l'utilisateur",
  "admin.config.ldap.bind-password": "Mot de passe de liaison",
  "admin.config.ldap.bind-password.description": "Mot de passe utilisé pour effectuer la recherche de l'utilisateur",
  "admin.config.ldap.search-base": "Base d'utilisateurs",
  "admin.config.ldap.search-base.description": "Emplacement de base, où la recherche de l'utilisateur sera effectuée",
  "admin.config.ldap.search-query": "Requête utilisateur",
  "admin.config.ldap.search-query.description": "La requête utilisateur sera utilisée pour rechercher dans la ‘base d'utilisateurs’ de l'utilisateur LDAP. %username% peut être utilisé comme espace réservé pour les entrées données par l'utilisateur.",
  "admin.config.ldap.admin-groups": "Groupe administrateur",
  "admin.config.ldap.admin-groups.description": "Un groupe est nécessaire pour un accès administratif.",
  "admin.config.ldap.field-name-member-of": "Nom de l'attribut des groupes d'utilisateurs",
  "admin.config.ldap.field-name-member-of.description": "Nom d'attribut LDAP pour les groupes dont un utilisateur est membre. Il est utilisé lors de la vérification du groupe d'administrateurs.",
  "admin.config.ldap.field-name-email": "Nom d'attribut de l'e-mail de l'utilisateur",
  "admin.config.ldap.field-name-email.description": "Nom d'attribut LDAP pour l'e-mail d'un utilisateur.",
  "admin.config.notify.success": "Configuration mise à jour avec succès.",
  "admin.config.notify.logo-success": "Logo mis à jour avec succès. La mise à jour sur le site peut prendre quelques minutes.",
  "admin.config.notify.no-changes": "Aucune modification à enregistrer.",
  "admin.config.category.s3": "S3",
  "admin.config.s3.enabled": "Activé",
  "admin.config.s3.enabled.description": "Si S3 doit être utilisé pour stocker les fichiers partagés au lieu du système de fichiers local.",
  "admin.config.s3.endpoint": "Point de terminaison",
  "admin.config.s3.endpoint.description": "L'URL du bucket S3.",
  "admin.config.s3.region": "Région",
  "admin.config.s3.region.description": "La région du bucket S3.",
  "admin.config.s3.bucket-name": "Nom du bucket",
  "admin.config.s3.bucket-name.description": "Le nom du bucket S3.",
  "admin.config.s3.bucket-path": "Chemin",
  "admin.config.s3.bucket-path.description": "Le chemin par défaut qui doit être utilisé pour stocker les fichiers dans le bucket S3.",
  "admin.config.s3.key": "Clé",
  "admin.config.s3.key.description": "La clé qui vous permet d'accéder au bucket S3.",
  "admin.config.s3.secret": "Secret",
  "admin.config.s3.secret.description": "Le secret qui vous permet d'accéder au bucket S3.",
  "admin.config.category.legal": "Legal",
  "admin.config.legal.enabled": "Enable legal notices",
  "admin.config.legal.enabled.description": "Whether to show a link to imprint and privacy policy in the footer.",
  "admin.config.legal.imprint-text": "Imprint text",
  "admin.config.legal.imprint-text.description": "The text which should be shown in the imprint. Supports Markdown. Leave blank to link to an external imprint page.",
  "admin.config.legal.imprint-url": "Imprint URL",
  "admin.config.legal.imprint-url.description": "If you already have an imprint page you can link it here instead of using the text field.",
  "admin.config.legal.privacy-policy-text": "Privacy policy text",
  "admin.config.legal.privacy-policy-text.description": "The text which should be shown in the privacy policy. Supports Markdown. Leave blank to link to an external privacy policy page.",
  "admin.config.legal.privacy-policy-url": "Privacy policy URL",
  "admin.config.legal.privacy-policy-url.description": "If you already have a privacy policy page you can link it here instead of using the text field.",
  // 404
  "404.description": "Désolé, mais cette page n’existe pas.",
  "404.button.home": "Retour à l’accueil",
  // error
  "error.title": "Erreur",
  "error.description": "Oups !",
  "error.button.back": "Retour",
  "error.msg.default": "Quelque chose a mal tourné.",
  "error.msg.access_denied": "Vous avez annulé le processus d’authentification, veuillez réessayer.",
  "error.msg.expired_token": "Le processus d’authentification a pris trop de temps, veuillez réessayer.",
  "error.msg.invalid_token": "Erreur Interne",
  "error.msg.no_user": "L’utilisateur associé au compte {0} n’existe pas.",
  "error.msg.no_email": "Impossible d’obtenir le courriel du compte {0}.",
  "error.msg.already_linked": "Le compte {0} est déjà associé à un autre compte.",
  "error.msg.not_linked": "Le compte {0} n’est pas encore associé à compte.",
  "error.msg.unverified_account": "Le compte {0} n'est pas vérifié, veuillez réessayer après vérification.",
  "error.msg.user_not_allowed": "Vous n’êtes pas autorisé à vous authentifier.",
  "error.msg.cannot_get_user_info": "Impossible d’obtenir vos informations utilisateur à partir du compte {0}.",
  "error.param.provider_github": "GitHub",
  "error.param.provider_google": "Google",
  "error.param.provider_microsoft": "Microsoft",
  "error.param.provider_discord": "Discord",
  "error.param.provider_oidc": "Connexion OpenID",
  // Common translations
  "common.button.save": "Sauvegarder",
  "common.button.create": "Créer",
  "common.button.submit": "Envoyer",
  "common.button.delete": "Supprimer",
  "common.button.cancel": "Annuler",
  "common.button.confirm": "Confirmer",
  "common.button.disable": "Désactiver",
  "common.button.share": "Partager",
  "common.button.generate": "Générer",
  "common.button.done": "Terminer",
  "common.text.link": "Lien",
  "common.text.navigate-to-link": "Visiter le lien",
  "common.text.or": "ou",
  "common.text.redirecting": "Redirection...",
  "common.button.go-back": "Précédent",
  "common.button.go-home": "Accueil",
  "common.notify.copied": "Votre lien a été copié dans le presse-papiers",
  "common.notify.copied-link": "Votre lien a été copié dans le presse-papiers",
  "common.success": "Opération réussie",
  "common.error": "Erreur",
  "common.error.unknown": "Une erreur inconnue est survenue",
  "common.error.invalid-email": "Adresse courriel invalide",
  "common.error.too-short": "Doit comporter au moins {length} caractères",
  "common.error.too-long": "Doit comporter au plus {length} caractères",
  "common.error.number-too-small": "Doit être au moins {min}",
  "common.error.number-too-large": "Doit être au plus {max}",
  "common.error.exact-length": "Doit comporter exactement {length} caractères",
  "common.error.invalid-number": "Doit être un nombre",
  "common.error.field-required": "Ce champ est obligatoire"
};