export default {
  // Navbar
  "navbar.upload": "Hochladen",
  "navbar.signin": "Anmelden",
  "navbar.home": "Startseite",
  "navbar.signup": "Registrieren",
  "navbar.links.shares": "Meine Freigaben",
  "navbar.links.reverse": "Externe Freigaben",
  "navbar.avatar.account": "Mein Konto",
  "navbar.avatar.admin": "Verwaltung",
  "navbar.avatar.signout": "Abmelden",
  // END navbar
  // /
  "home.title": "Eine <h>selbst gehostete</h> Dateifreigabe-Plattform.",
  "home.description": "Möchtest du wirklich deine persönlichen Dateien an Drittanbieter wie WeTransfer weitergeben?",
  "home.bullet.a.name": "Selbst gehostet",
  "home.bullet.a.description": "Betreibe Pingvin Share auf deinem eigenen Server.",
  "home.bullet.b.name": "Privatsphäre",
  "home.bullet.b.description": "Deine Dateien gehören dir und sind niemals durch Dritte zugänglich.",
  "home.bullet.c.name": "Keine lästige Dateigrößenbegrenzung",
  "home.bullet.c.description": "Lade so große Dateien hoch, wie du willst. Nur deine Festplatte ist dein Limit.",
  "home.button.start": "Lege los",
  "home.button.source": "Quellcode",
  // END /
  // /auth/signin
  "signin.title": "Willkommen zurück",
  "signin.description": "Du hast noch kein Konto?",
  "signin.button.signup": "Registrieren",
  "signin.input.email-or-username": "E-Mail oder Benutzername",
  "signin.input.email-or-username.placeholder": "Deine E-Mail-Adresse oder Benutzername",
  "signin.input.password": "Passwort",
  "signin.input.password.placeholder": "Dein Passwort",
  "signin.button.submit": "Anmelden",
  "signIn.notify.totp-required.title": "Zwei-Faktor-Authentifizierung benötigt",
  "signIn.notify.totp-required.description": "Bitte gib deinen Zwei-Faktor-Authentifizierungscode ein",
  "signIn.oauth.or": "ODER",
  "signIn.oauth.signInWith": "Anmelden mit",
  "signIn.oauth.github": "GitHub",
  "signIn.oauth.google": "Google",
  "signIn.oauth.microsoft": "Microsoft",
  "signIn.oauth.discord": "Discord",
  "signIn.oauth.oidc": "OpenID",
  // END /auth/signin
  // /auth/signup
  "signup.title": "Erstelle ein Konto",
  "signup.description": "Besitzt du bereits ein Konto?",
  "signup.button.signin": "Anmelden",
  "signup.input.username": "Benutzername",
  "signup.input.username.placeholder": "Dein Benutzername",
  "signup.input.email": "E-Mail",
  "signup.input.email.placeholder": "Deine E-Mail-Adresse",
  "signup.button.submit": "Lass uns loslegen",
  // END /auth/signup
  // /auth/totp
  "totp.title": "TOTP Authentifizierung",
  "totp.button.signIn": "Anmelden",
  // END /auth/totp
  // /auth/reset-password
  "resetPassword.title": "Passwort vergessen?",
  "resetPassword.description": "Gib deine E-Mail-Adresse ein, um dein Passwort zurückzusetzen.",
  "resetPassword.notify.success": "Wir haben dir einen Link gesendet, unter dem du dein Passwort zurücksetzen kannst.",
  "resetPassword.button.back": "Zurück zur Anmeldeseite",
  "resetPassword.text.resetPassword": "Passwort zurücksetzen",
  "resetPassword.text.enterNewPassword": "Gib dein neues Passwort ein",
  "resetPassword.input.password": "Neues Passwort",
  "resetPassword.notify.passwordReset": "Dein Passwort wurde erfolgreich zurückgesetzt.",
  // /account
  "account.title": "Mein Konto",
  "account.card.info.title": "Kontoinformationen",
  "account.card.info.username": "Benutzername",
  "account.card.info.email": "E-Mail",
  "account.notify.info.success": "Konto erfolgreich aktualisiert",
  "account.card.password.title": "Passwort",
  "account.card.password.old": "Altes Passwort",
  "account.card.password.new": "Neues Passwort",
  "account.card.password.noPasswordSet": "Du hast kein Passwort erstellt. Wenn du dich mit E-Mail und Passwort anmelden möchtest, musst du ein Passwort festlegen.",
  "account.notify.password.success": "Passwort erfolgreich geändert",
  "account.card.oauth.title": "Anmeldung über soziale Netzwerke",
  "account.card.oauth.github": "GitHub",
  "account.card.oauth.google": "Google",
  "account.card.oauth.microsoft": "Microsoft",
  "account.card.oauth.discord": "Discord",
  "account.card.oauth.oidc": "OpenID",
  "account.card.oauth.link": "Verknüpfen",
  "account.card.oauth.unlink": "Verknüpfung aufheben",
  "account.card.oauth.unlinked": "Verknüpfung aufgehoben",
  "account.modal.unlink.title": "Kontoverknüpfung aufheben",
  "account.modal.unlink.description": "Die Aufhebung der Verknüpfung mit deinen sozialen Konten kann dazu führen, dass du dein Konto verlierst, wenn du dich nicht an deine Anmeldedaten erinnerst",
  "account.notify.oauth.unlinked.success": "Verknüpfung erfolgreich aufgehoben",
  "account.card.security.title": "Sicherheit",
  "account.card.security.totp.enable.description": "Gib dein aktuelles Passwort ein, um TOTP zu aktivieren",
  "account.card.security.totp.disable.description": "Gib dein aktuelles Passwort ein, um TOTP zu deaktivieren",
  "account.card.security.totp.button.start": "Starten",
  "account.modal.totp.title": "TOTP aktivieren",
  "account.modal.totp.step1": "Schritt 1: Füge deinen Authenticator hinzu",
  "account.modal.totp.step2": "Schritt 2: Bestätige deinen Code",
  "account.modal.totp.enterManually": "Manuell eingeben",
  "account.modal.totp.code": "Code",
  "common.button.clickToCopy": "Klicken zum Kopieren",
  "account.modal.totp.verify": "Überprüfen",
  "account.notify.totp.disable": "TOTP erfolgreich deaktiviert",
  "account.notify.totp.enable": "TOTP erfolgreich aktiviert",
  "account.card.language.title": "Sprache",
  "account.card.language.description": "Das Projekt wird von der Community übersetzt. Einige Sprachen könnten unvollständig sein.",
  "account.card.color.title": "Farbschema",
  // ThemeSwitcher.tsx
  "account.theme.dark": "Dunkel",
  "account.theme.light": "Hell",
  "account.theme.system": "System",
  "account.button.delete": "Konto löschen",
  "account.modal.delete.title": "Konto löschen",
  "account.modal.delete.description": "Möchtest du wirklich dein Konto inklusive aller aktiven Freigaben löschen?",
  // END /account
  // /account/shares
  "account.shares.title": "Meine Freigaben",
  "account.shares.title.empty": "Es ist so leer hier 👀",
  "account.shares.description.empty": "Du hast keine Freigaben erstellt.",
  "account.shares.button.create": "Erstelle eine",
  "account.shares.info.title": "Freigabe Informationen",
  "account.shares.table.id": "ID",
  "account.shares.table.name": "Name",
  "account.shares.table.description": "Beschreibung",
  "account.shares.table.visitors": "Besucher",
  "account.shares.table.expiresAt": "Läuft ab am",
  "account.shares.table.createdAt": "Angelegt am",
  "account.shares.table.size": "Größe",
  "account.shares.table.password-protected": "Passwortgeschützt",
  "account.shares.table.visitor-count": "{count} von {max}",
  "account.shares.table.expiry-never": "nie",
  "account.shares.modal.share-informations": "Teile deine Information",
  "account.shares.modal.share-link": "Freigabe teilen",
  "account.shares.modal.delete.title": "Freigabe löschen: {share}",
  "account.shares.modal.delete.description": "Möchtest du diese Freigabe wirklich löschen?",
  // END /account/shares
  // /account/reverseShares
  "account.reverseShares.title": "Externe Freigaben",
  "account.reverseShares.description": "Eine externe Freigabe erlaubt dir eine einzigartige URL zu erstellen, die externen Benutzern erlaubt, Dateien hochzuladen.",
  "account.reverseShares.title.empty": "Es ist leer hier 👀",
  "account.reverseShares.description.empty": "Du hast keine externen Freigaben.",
  // showCreateReverseShareModal.tsx
  "account.reverseShares.modal.title": "Externe Freigabe erstellen",
  "account.reverseShares.modal.expiration.label": "Gültig bis",
  "account.reverseShares.modal.expiration.minute-singular": "Minute",
  "account.reverseShares.modal.expiration.minute-plural": "Minuten",
  "account.reverseShares.modal.expiration.hour-singular": "Stunde",
  "account.reverseShares.modal.expiration.hour-plural": "Stunden",
  "account.reverseShares.modal.expiration.day-singular": "Tag",
  "account.reverseShares.modal.expiration.day-plural": "Tage",
  "account.reverseShares.modal.expiration.week-singular": "Woche",
  "account.reverseShares.modal.expiration.week-plural": "Wochen",
  "account.reverseShares.modal.expiration.month-singular": "Monat",
  "account.reverseShares.modal.expiration.month-plural": "Monate",
  "account.reverseShares.modal.expiration.year-singular": "Jahr",
  "account.reverseShares.modal.expiration.year-plural": "Jahre",
  "account.reverseShares.modal.max-size.label": "Maximale Freigabegröße",
  "account.reverseShares.modal.send-email": "E-Mail Benachrichtigungen senden",
  "account.reverseShares.modal.send-email.description": "Sendet eine E-Mail Benachrichtigung, wenn eine Datei auf Ihrer externen Freigabe hochgeladen wurde.",
  "account.reverseShares.modal.simplified": "Einfacher Modus",
  "account.reverseShares.modal.simplified.description": "Mache es der Person, die die Datei hochlädt, einfach, sie mit dir zu teilen. Sie werden nur den Namen und die Beschreibung der Freigabe ändern können.",
  "account.reverseShares.modal.public-access": "Öffentlicher Zugriff",
  "account.reverseShares.modal.public-access.description": "Mache die Freigaben die mit dieser externen Freigabe erstellt werden öffentlich. Wenn dies deaktiviert ist, haben nur du und der Ersteller der Freigabe Zugriff darauf.",
  "account.reverseShares.modal.max-use.label": "Maximale Nutzungen",
  "account.reverseShares.modal.max-use.description": "Die maximale Anzahl von Verwendungen der URL, um Dateien hochzuladen.",
  "account.reverseShare.never-expires": "Diese externe Freigabe wird nicht ablaufen.",
  "account.reverseShare.expires-on": "Diese externe Freigabe wird am {expiration} ablaufen.",
  "account.reverseShares.table.no-shares": "Noch keine Freigaben erstellt",
  "account.reverseShares.table.count.singular": "Freigabe",
  "account.reverseShares.table.count.plural": "Freigaben",
  "account.reverseShares.table.shares": "Freigaben",
  "account.reverseShares.table.remaining": "Verbleibende Verwendungen",
  "account.reverseShares.table.max-size": "Maximale Freigabegröße",
  "account.reverseShares.table.expires": "Läuft ab am",
  "account.reverseShares.modal.reverse-share-link": "Link zu externer Freigabe",
  "account.reverseShares.modal.delete.title": "Externe Freigabe löschen",
  "account.reverseShares.modal.delete.description": "Möchtest du diese externe Freigabe wirklich löschen? In diesem Fall werden auch hiermit verbundene Freigaben gelöscht.",
  // END /account/reverseShares
  // /admin
  "admin.title": "Verwaltung",
  "admin.button.users": "Benutzerverwaltung",
  "admin.button.shares": "Freigaben Verwaltung",
  "admin.button.config": "Konfiguration",
  "admin.version": "Version",
  // END /admin
  // /admin/users
  "admin.users.title": "Benutzerverwaltung",
  "admin.users.table.username": "Benutzername",
  "admin.users.table.email": "E-Mail",
  "admin.users.table.admin": "Administrator",
  "admin.users.edit.update.title": "Benutzer bearbeiten: {username}",
  "admin.users.edit.update.admin-privileges": "Administratorrechte",
  "admin.users.edit.update.change-password.title": "Passwort ändern",
  "admin.users.edit.update.change-password.field": "Neues Passwort",
  "admin.users.edit.update.change-password.button": "Neues Passwort speichern",
  "admin.users.edit.update.notify.password.success": "Passwort erfolgreich geändert",
  "admin.users.edit.delete.title": "Benutzer löschen: {username}?",
  "admin.users.edit.delete.description": "Möchtest du wirklich diesen Benutzer und all seine Freigaben löschen?",
  // showCreateUserModal.tsx
  "admin.users.modal.create.title": "Benutzer erstellen",
  "admin.users.modal.create.username": "Benutzername",
  "admin.users.modal.create.email": "E-Mail",
  "admin.users.modal.create.password": "Passwort",
  "admin.users.modal.create.manual-password": "Passwort manuell festlegen",
  "admin.users.modal.create.manual-password.description": "Wenn nicht aktiviert, erhält der Benutzer eine E-Mail mit einem Link, um sein Passwort festzulegen.",
  "admin.users.modal.create.admin": "Administratorrechte",
  "admin.users.modal.create.admin.description": "Wenn aktiviert, kann der Benutzer auf das Administrator-Panel zugreifen.",
  // END /admin/users
  // /admin/shares
  "admin.shares.title": "Freigaben Verwaltung",
  "admin.shares.table.id": "Freigabe ID",
  "admin.shares.table.username": "Ersteller",
  "admin.shares.table.visitors": "Besucher",
  "admin.shares.table.expires": "Läuft ab am",
  "admin.shares.edit.delete.title": "Freigabe löschen: {id}",
  "admin.shares.edit.delete.description": "Möchtest du diese Freigabe wirklich löschen?",
  // END /admin/shares
  // /upload
  "upload.title": "Upload",
  "upload.notify.confirm-leave": "Bist du sicher, dass du diese Seite verlassen willst? Dein Upload wird abgebrochen.",
  "upload.notify.generic-error": "Während der Erstellung der Freigabe ist ein Fehler aufgetreten.",
  "upload.notify.count-failed": "{count} Dateien konnten nicht hochgeladen werden. Wird erneut versucht.",
  "upload.reverse-share.error.invalid.title": "Ungültiger Link zu externer Freigabe",
  "upload.reverse-share.error.invalid.description": "Diese externe Freigabe ist abgelaufen oder ungültig.",
  // Dropzone.tsx
  "upload.dropzone.title": "Dateien hochladen",
  "upload.dropzone.description": "Ziehe Dateien per Drag'n'Drop hierher, um deine Freigabe zu starten. Wir akzeptieren nur Dateien mit einer Gesamtgröße von bis zu {maxSize}.",
  "upload.dropzone.notify.file-too-big": "Ihre Dateien überschreiten die maximale Freigabegröße von {maxSize}.",
  // FileList.tsx
  "upload.filelist.name": "Name",
  "upload.filelist.size": "Größe",
  // showCreateUploadModal.tsx
  "upload.modal.title": "Erstelle Freigabe",
  "upload.modal.link.error.invalid": "Darf nur Buchstaben, Zahlen, Unterstriche und Bindestriche enthalten",
  "upload.modal.link.error.taken": "Dieser Link wird bereits verwendet",
  "upload.modal.not-signed-in": "Du bist nicht angemeldet",
  "upload.modal.not-signed-in-description": "Du wirst deine Freigabe nicht löschen können oder die Besucheranzahl sehen.",
  "upload.modal.expires.never": "nie",
  "upload.modal.expires.never-long": "Permanente Freigabe",
  "upload.modal.expires.error.too-long": "Das Ablaufdatum überschreitet das Maximum von {max}.",
  "upload.modal.link.label": "Link",
  "upload.modal.expires.label": "Gültig bis",
  "upload.modal.expires.minute-singular": "Minute",
  "upload.modal.expires.minute-plural": "Minuten",
  "upload.modal.expires.hour-singular": "Stunde",
  "upload.modal.expires.hour-plural": "Stunden",
  "upload.modal.expires.day-singular": "Tag",
  "upload.modal.expires.day-plural": "Tage",
  "upload.modal.expires.week-singular": "Woche",
  "upload.modal.expires.week-plural": "Wochen",
  "upload.modal.expires.month-singular": "Monat",
  "upload.modal.expires.month-plural": "Monate",
  "upload.modal.expires.year-singular": "Jahr",
  "upload.modal.expires.year-plural": "Jahre",
  "upload.modal.accordion.name-and-description.title": "Name und Beschreibung",
  "upload.modal.accordion.name-and-description.name.placeholder": "Name",
  "upload.modal.accordion.name-and-description.description.placeholder": "Hinweis für die Empfänger dieser Freigabe",
  "upload.modal.accordion.email.title": "E-Mail-Empfänger",
  "upload.modal.accordion.email.placeholder": "E-Mail der Empfänger eingeben",
  "upload.modal.accordion.email.invalid-email": "Ungültige E-Mail-Adresse",
  "upload.modal.accordion.security.title": "Sicherheitseinstellungen",
  "upload.modal.accordion.security.password.label": "Passwortschutz",
  "upload.modal.accordion.security.password.placeholder": "Kein Passwort",
  "upload.modal.accordion.security.max-views.label": "Maximale Aufrufe",
  "upload.modal.accordion.security.max-views.placeholder": "Unbegrenzt",
  // showCompletedUploadModal.tsx
  "upload.modal.completed.never-expires": "Diese Freigabe läuft niemals ab.",
  "upload.modal.completed.expires-on": "Diese Freigabe wird am {expiration} ablaufen.",
  "upload.modal.completed.share-ready": "Freigabe bereit",
  "upload.modal.completed.notified-reverse-share-creator": "Wir haben den Ersteller der externen Freigabe benachrichtigt. Du kannst den Link auch auf andere Wege teilen.",
  // END /upload
  // /share/[id]
  "share.title": "Freigabe {shareId}",
  "share.description": "Schau, was ich mit dir geteilt habe!",
  "share.error.visitor-limit-exceeded.title": "Besucher Limit erreicht",
  "share.error.visitor-limit-exceeded.description": "Die maximale Besucheranzahl für diese Freigabe ist überschritten.",
  "share.error.removed.title": "Freigabe entfernt",
  "share.error.not-found.title": "Freigabe nicht gefunden",
  "share.error.not-found.description": "Die gesuchte Freigabe existiert nicht.",
  "share.error.access-denied.title": "Private Freigabe",
  "share.error.access-denied.description": "Das aktuelle Konto hat keine Berechtigung, um auf diese Freigabe zuzugreifen",
  "share.modal.password.title": "Passwort erforderlich",
  "share.modal.password.description": "Bitte gib das Passwort ein, um auf diese Freigabe zuzugreifen.",
  "share.modal.password": "Passwort",
  "share.modal.error.invalid-password": "Ungültiges Passwort",
  "share.button.download-all": "Alles herunterladen",
  "share.notify.download-all-preparing": "Die Freigabe wird vorbereitet. Bitte versuche es in ein paar Minuten erneut.",
  "share.modal.file-link": "Dateilink",
  "share.table.name": "Name",
  "share.table.size": "Größe",
  "share.modal.file-preview.error.not-supported.title": "Vorschau wird nicht unterstützt",
  "share.modal.file-preview.error.not-supported.description": "Vorschaubilder werden für diesen Dateityp nicht unterstützt. Bitte lade die Datei herunter, um sie anzuzeigen.",
  // END /share/[id]
  // /share/[id]/edit
  "share.edit.title": "{shareId} bearbeiten",
  "share.edit.append-upload": "Datei anfügen",
  "share.edit.notify.generic-error": "Während der Erstellung der Freigabe ist ein Fehler aufgetreten.",
  "share.edit.notify.save-success": "Freigabe erfolgreich aktualisiert",
  // END /share/[id]/edit
  // /imprint
  "imprint.title": "Imprint",
  // END /imprint
  // /privacy
  "privacy.title": "Privacy Policy",
  // END /privacy
  // /admin/config
  "admin.config.title": "Einstellungen",
  "admin.config.category.general": "Allgemein",
  "admin.config.category.share": "Freigabe",
  "admin.config.category.email": "E-Mail",
  "admin.config.category.smtp": "SMTP",
  "admin.config.category.oauth": "Anmeldung über soziale Netzwerke",
  "admin.config.general.app-name": "App-Name",
  "admin.config.general.app-name.description": "Name der Applikation",
  "admin.config.general.app-url": "App-URL",
  "admin.config.general.app-url.description": "Auf welcher URL Pingvin Share verfügbar ist",
  "admin.config.general.secure-cookies": "Sichere Cookies",
  "admin.config.general.secure-cookies.description": "Gibt an, ob die secure flag bei Cookies gesetzt werden soll. Falls aktiviert, wird die Seite nicht funktionieren, wenn sie über HTTP aufgerufen wird.",
  "admin.config.general.show-home-page": "Startseite anzeigen",
  "admin.config.general.show-home-page.description": "Ob die Startseite angezeigt werden soll",
  "admin.config.general.session-duration": "Session-Dauer",
  "admin.config.general.session-duration.description": "Zeit in Stunden, nach der ein Benutzer sich erneut anmelden muss (Voreinstellung: 3 Monate).",
  "admin.config.general.logo": "Logo",
  "admin.config.general.logo.description": "Ändere dein Logo durch Hochladen eines Bildes. Das Bild muss im PNG-Format vorliegen und sollte mit Seitenverhältnis 1:1 sein.",
  "admin.config.general.logo.placeholder": "Bild auswählen",
  "admin.config.email.enable-share-email-recipients": "Erlaube das Teilen der Freigabe via E-Mail",
  "admin.config.email.enable-share-email-recipients.description": "Gibt an, ob das Teilen von E-Mails mit Empfängern erlaubt werden soll. Aktiviere dies nur, wenn SMTP aktiviert ist.",
  "admin.config.email.share-recipients-subject": "Betreff für Freigabe-Empfänger",
  "admin.config.email.share-recipients-subject.description": "Betreff der E-Mail, die an die Freigabe-Empfänger gesendet wird.",
  "admin.config.email.share-recipients-message": "Nachricht für Freigabe-Empfänger",
  "admin.config.email.share-recipients-message.description": "Nachricht, die an die Freigabe-Empfänger gesendet wird. Verfügbare Variablen:\n- {creator} - Der Benutzername des Erstellers der Freigabe\n- {creatorEmail} - E-Mail-Adresse des Erstellers der Freigabe\n- {shareUrl} - Die URL der Freigabe\n- {desc} - Die Beschreibung der Freigabe\n- {expires} - Das Ablaufdatum der Freigabe\nVariablen werden durch die tatsächlichen Werte ersetzt.",
  "admin.config.email.reverse-share-subject": "Name der externen Freigabe",
  "admin.config.email.reverse-share-subject.description": "Betreff der gesendeten E-Mail, wenn jemand eine Freigabe mit Ihrem externen Freigabe-Link erstellt hat.",
  "admin.config.email.reverse-share-message": "Nachricht für externe Freigabe",
  "admin.config.email.reverse-share-message.description": "Nachricht, die gesendet wird, wenn jemand eine Freigabe mit deinem externen Freigabe-Link erstellt. {shareUrl} wird durch den Namen des Erstellers und die Freigabe-URL ersetzt.",
  "admin.config.email.reset-password-subject": "Betreff für Passwortzurücksetzung",
  "admin.config.email.reset-password-subject.description": "Betreff der gesendeten E-Mail, wenn ein Benutzer ein Passwort zurücksetzen möchte.",
  "admin.config.email.reset-password-message": "Nachricht für Passwortzurücksetzung",
  "admin.config.email.reset-password-message.description": "Nachricht, die gesendet wird, wenn ein Benutzer eine Passwortzurücksetzung anfordert. {url} wird durch die URL für das Zurücksetzen des Passworts ersetzt.",
  "admin.config.email.invite-subject": "Betreff für Einladung",
  "admin.config.email.invite-subject.description": "Betreff der gesendeten E-Mail, wenn ein Administrator einen Benutzer einlädt.",
  "admin.config.email.invite-message": "Nachricht für Einladung",
  "admin.config.email.invite-message.description": "Nachricht, die gesendet wird, wenn ein Administrator einen Benutzer einlädt. {url} wird durch die Einladung-URL ersetzt und {password} durch das Passwort ersetzt.",
  "admin.config.share.allow-registration": "Registrierung erlauben",
  "admin.config.share.allow-registration.description": "Gibt an, ob eine Registrierung erlaubt ist",
  "admin.config.share.allow-unauthenticated-shares": "Nicht authentifizierte Freigaben erlauben",
  "admin.config.share.allow-unauthenticated-shares.description": "Gibt an, ob nicht authentifizierte Benutzer Freigaben erstellen können",
  "admin.config.share.max-expiration": "Max. Ablaufdatum",
  "admin.config.share.max-expiration.description": "Maximale Ablaufzeit. Auf 0 setzen, um kein Ablaufdatum zu definieren.",
  "admin.config.share.share-id-length": "Default share ID length",
  "admin.config.share.share-id-length.description": "Default length for the generated ID of a share. This value is also used to generate links for reverse shares. A value below 8 is not considered secure.",
  "admin.config.share.max-size": "Maximale Größe",
  "admin.config.share.max-size.description": "Maximale Größe einer Freigabe",
  "admin.config.share.zip-compression-level": "ZIP-Kompressionslevel",
  "admin.config.share.zip-compression-level.description": "Passe den Wert an, um ein Gleichgewicht zwischen Dateigröße und Kompressionsgeschwindigkeit herzustellen. Gültige Werte liegen zwischen 0 und 9, wobei 0 für keine Komprimierung und 9 für maximale Komprimierung steht. ",
  "admin.config.share.chunk-size": "Chunk Größe",
  "admin.config.share.chunk-size.description": "Passe die Chunk-Größe für deine Uploads an, um Effizienz und Zuverlässigkeit entsprechend deiner Internetverbindung auszubalancieren. Kleinere Chunks können die Erfolgsraten bei instabilen Verbindungen erhöhen, während größere Chunks Uploads bei stabilen Verbindungen beschleunigen.",
  "admin.config.share.auto-open-share-modal": "Freigabe-Fenster automatisch öffnen",
  "admin.config.share.auto-open-share-modal.description": "Das Freigabe-Fenster erscheint automatisch, sobald ein Benutzer Dateien ausgewählt hat, ohne extra auf den Button klicken zu müssen.",
  "admin.config.smtp.enabled": "Aktivieren",
  "admin.config.smtp.enabled.description": "Gibt an, ob SMTP aktiviert ist. Aktiviere dies nur, wenn du den Host, den Port, die E-Mail, den Benutzernamen und das Passwort deines SMTP-Servers eingegeben hast.",
  "admin.config.smtp.host": "Host",
  "admin.config.smtp.host.description": "Host des SMTP-Servers",
  "admin.config.smtp.port": "Port",
  "admin.config.smtp.port.description": "Port des SMTP-Servers",
  "admin.config.smtp.email": "E-Mail",
  "admin.config.smtp.email.description": "E-Mail-Adresse, von der die E-Mails gesendet werden",
  "admin.config.smtp.username": "Benutzername",
  "admin.config.smtp.username.description": "Benutzername des SMTP-Servers",
  "admin.config.smtp.password": "Passwort",
  "admin.config.smtp.password.description": "Passwort des SMTP-Servers",
  "admin.config.smtp.button.test": "Test-E-Mail senden",
  "admin.config.smtp.allow-unauthorized-certificates": "Vertrauen von nicht authentifizierten SMTP-Server-Zertifikaten",
  "admin.config.smtp.allow-unauthorized-certificates.description": "Verwende diese Option nur, wenn du selbst signierten Zertifikaten vertrauen musst.",
  "admin.config.oauth.allow-registration": "Registrierung erlauben",
  "admin.config.oauth.allow-registration.description": "Benutzern erlauben, sich über soziale Netzwerke zu registrieren",
  "admin.config.oauth.ignore-totp": "TOTP ignorieren",
  "admin.config.oauth.ignore-totp.description": "Gibt an, ob TOTP ignoriert werden soll, wenn sich der Benutzer über soziale Netzwerke anmeldet",
  "admin.config.oauth.disable-password": "Anmelden mit Passwort deaktivieren",
  "admin.config.oauth.disable-password.description": "Deaktiviert das Anmelden mit Passwort\nStelle vor Aktivierung dieser Konfiguration sicher, dass ein OAuth-Provider korrekt konfiguriert ist, um nicht ausgesperrt zu werden.",
  "admin.config.oauth.github-enabled": "GitHub",
  "admin.config.oauth.github-enabled.description": "GitHub Anmeldung erlaubt",
  "admin.config.oauth.github-client-id": "GitHub Client-ID",
  "admin.config.oauth.github-client-id.description": "Client-ID der GitHub OAuth-App",
  "admin.config.oauth.github-client-secret": "GitHub Client Secret",
  "admin.config.oauth.github-client-secret.description": "Client Secret der GitHub OAuth App",
  "admin.config.oauth.google-enabled": "Google",
  "admin.config.oauth.google-enabled.description": "Google Anmeldung erlaubt",
  "admin.config.oauth.google-client-id": "Google Client-ID",
  "admin.config.oauth.google-client-id.description": "Client-ID der Google OAuth-App",
  "admin.config.oauth.google-client-secret": "Google Client Secret",
  "admin.config.oauth.google-client-secret.description": "Client Secret der Google OAuth App",
  "admin.config.oauth.microsoft-enabled": "Microsoft",
  "admin.config.oauth.microsoft-enabled.description": "Microsoft Anmeldung erlaubt",
  "admin.config.oauth.microsoft-tenant": "Microsoft Mandant",
  "admin.config.oauth.microsoft-tenant.description": "Mandant-ID der Microsoft OAuth App\ncommon: Benutzer mit einem persönlichen Microsoft-Konto und einem Arbeits- oder Schulkonto von Microsoft Entra ID können sich in der Anwendung anmelden.\norganizations: Nur Benutzer mit Arbeits- oder Schulkonten von Microsoft Entra ID können sich in der Anwendung anmelden.\nconsumers: Nur Benutzer mit einem persönlichen Microsoft-Konto können sich in der Anwendung anmelden.\nDomänenname des Microsoft Entra Mandanten oder die Mandanten-ID im GUID-Format: Nur Benutzer eines bestimmten Microsoft Entra Mandanten (Verzeichnismitglieder mit einem Arbeits- oder Schulkonto oder Verzeichnis Gäste mit einem persönlichen Microsoft-Konto) können sich anmelden.",
  "admin.config.oauth.microsoft-client-id": "Microsoft Client-ID",
  "admin.config.oauth.microsoft-client-id.description": "Client-ID der Microsoft OAuth-App",
  "admin.config.oauth.microsoft-client-secret": "Microsoft Client Secret",
  "admin.config.oauth.microsoft-client-secret.description": "Client Secret der Microsoft OAuth App",
  "admin.config.oauth.discord-enabled": "Discord",
  "admin.config.oauth.discord-enabled.description": "Discord Anmeldung erlaubt",
  "admin.config.oauth.discord-limited-users": "Discord limitierte Benutzer",
  "admin.config.oauth.discord-limited-users.description": "Limitiere die Anmeldung für spezifische Benutzer anhand ihrer Discord ID. Lasse dieses Feld leer, um es zu deaktivieren.",
  "admin.config.oauth.discord-limited-guild": "Discord Server-ID",
  "admin.config.oauth.discord-limited-guild.description": "Die Anmeldung auf Benutzer in einem bestimmten Server beschränken. Leer lassen, um zu deaktivieren.",
  "admin.config.oauth.discord-client-id": "Discord Client-ID",
  "admin.config.oauth.discord-client-id.description": "Client-ID der Discord OAuth-App",
  "admin.config.oauth.discord-client-secret": "Discord Client Secret",
  "admin.config.oauth.discord-client-secret.description": "Client Secret der Discord OAuth App",
  "admin.config.oauth.oidc-enabled": "OpenID Connect",
  "admin.config.oauth.oidc-enabled.description": "OpenID Connect Anmeldung erlaubt",
  "admin.config.oauth.oidc-discovery-uri": "OpenID Verbindung Discovery URL",
  "admin.config.oauth.oidc-discovery-uri.description": "Discovery-URL der OpenID OAuth App",
  "admin.config.oauth.oidc-sign-out": "Abmelden von OpenID Connect",
  "admin.config.oauth.oidc-sign-out.description": "Wenn aktiviert, wird der Benutzer mit der „Abmelden“-Schaltfläche vom OpenID-Connect-Provider abgemeldet.",
  "admin.config.oauth.oidc-scope": "OpenID Connect scope",
  "admin.config.oauth.oidc-scope.description": "Scopes which should be requested from the OpenID Connect provider.",
  "admin.config.oauth.oidc-username-claim": "OpenID Connect Benutzername anfordern",
  "admin.config.oauth.oidc-username-claim.description": "Benutzername im OpenID Token. Leer lassen, wenn du nicht weißt, was diese Konfiguration bedeutet.",
  "admin.config.oauth.oidc-role-path": "Pfad zu den Rollen im OpenID Verbindungs-Token",
  "admin.config.oauth.oidc-role-path.description": "Muss ein valider JMES-Pfad sein, der zu einem Array an Rollen führt. " + "Die Zugangsverwaltung über Rollen in OpenID Connect ist nur empfohlen, wenn kein anderer Identitätsprovider konfiguriert und die Anmeldung per Password deaktiviert ist. " + "Leer lassen, wenn du nicht weißt, was diese Konfiguration bedeutet.",
  "admin.config.oauth.oidc-role-general-access": "OpenID Connect Rolle für allgemeinen Zugriff",
  "admin.config.oauth.oidc-role-general-access.description": "Rolle für generellen Zugriff. Muss Teil der Rollen eines Benutzers sein, damit dieser sich anmelden kann. " + "Leer lassen, wenn du nicht weißt, was diese Konfiguration bedeutet.",
  "admin.config.oauth.oidc-role-admin-access": "OpenID Connect Rolle für Admin-Zugriff",
  "admin.config.oauth.oidc-role-admin-access.description": "Rolle für administrativen Zugriff. Muss Teil der Rollen eines Benutzers sein, damit dieser auf das Administrator-Panel zugreifen kann. " + "Leer lassen, wenn du nicht weißt, was diese Konfiguration bedeutet.",
  "admin.config.oauth.oidc-client-id": "OpenID Connect Client-ID",
  "admin.config.oauth.oidc-client-id.description": "Client-ID der OpenID Connect OAuth-App",
  "admin.config.oauth.oidc-client-secret": "OpenID Connect Client-Secret",
  "admin.config.oauth.oidc-client-secret.description": "Client-Secret der OpenID Connect OAuth-App",
  "admin.config.category.ldap": "LDAP",
  "admin.config.ldap.enabled": "LDAP aktivieren",
  "admin.config.ldap.enabled.description": "LDAP-Authentifizierung für die Benutzeranmeldung verwenden",
  "admin.config.ldap.url": "Server-URL",
  "admin.config.ldap.url.description": "URL des LDAP-Servers",
  "admin.config.ldap.bind-dn": "Binde DN",
  "admin.config.ldap.bind-dn.description": "Standard-Benutzer, der zur Benutzersuche verwendet wird",
  "admin.config.ldap.bind-password": "Binde Passwort",
  "admin.config.ldap.bind-password.description": "Passwort der zur Benutzersuche verwendet wird",
  "admin.config.ldap.search-base": "Benutzerbasis",
  "admin.config.ldap.search-base.description": "Basisstandort, an dem die Benutzersuche durchgeführt wird",
  "admin.config.ldap.search-query": "Benutzerabfrage",
  "admin.config.ldap.search-query.description": "Die Benutzer Abfrage wird in der \"Benutzerdatenbank\" gesucht für den LDAP Benutzer. %username% kann als Platzhalter für den Benutzer eingegeben werden.",
  "admin.config.ldap.admin-groups": "Admin-Gruppe",
  "admin.config.ldap.admin-groups.description": "Gruppe benötigt für den Administrationszugang.",
  "admin.config.ldap.field-name-member-of": "Benutzergruppen-Attributname",
  "admin.config.ldap.field-name-member-of.description": "LDAP-Attributname für die Gruppen, in denen ein Benutzer Mitglied ist. Dies wird bei der Überprüfung der Admin-Gruppe verwendet.",
  "admin.config.ldap.field-name-email": "Attributname für die E-Mail-Adresse des Benutzers",
  "admin.config.ldap.field-name-email.description": "LDAP-Attributname für die E-Mail-Adresse eines Benutzers.",
  "admin.config.notify.success": "Configuration updated successfully.",
  "admin.config.notify.logo-success": "Logo updated successfully. It may take a few minutes to update on the website.",
  "admin.config.notify.no-changes": "No changes to save.",
  "admin.config.category.s3": "S3",
  "admin.config.s3.enabled": "Aktiviert",
  "admin.config.s3.enabled.description": "Ob S3 verwendet werden soll, um die freigegebenen Dateien anstelle des lokalen Dateisystems zu speichern.",
  "admin.config.s3.endpoint": "Endpunkt",
  "admin.config.s3.endpoint.description": "Die URL des S3-Buckets.",
  "admin.config.s3.region": "Region",
  "admin.config.s3.region.description": "Die Region des S3-Buckets.",
  "admin.config.s3.bucket-name": "Bucket-Name",
  "admin.config.s3.bucket-name.description": "Der Name des S3-Buckets.",
  "admin.config.s3.bucket-path": "Pfad",
  "admin.config.s3.bucket-path.description": "Der Standardpfad, der zum Speichern der Dateien im S3-Bucket verwendet werden soll.",
  "admin.config.s3.key": "Schlüssel",
  "admin.config.s3.key.description": "Der Schlüssel, der den Zugriff auf den S3-Bucket ermöglicht.",
  "admin.config.s3.secret": "Geheimnis",
  "admin.config.s3.secret.description": "Das Geheimnis, das den Zugriff auf den S3-Bucket ermöglicht.",
  "admin.config.category.legal": "Rechtliches",
  "admin.config.legal.enabled": "Impressum und Datenschutz aktivieren",
  "admin.config.legal.enabled.description": "Gibt an, ob die Links zum Impressum und zur Datenschutzerklärung im Footer angezeigt werden sollen.",
  "admin.config.legal.imprint-text": "Impressum-Text",
  "admin.config.legal.imprint-text.description": "Der Text, der im Impressum angezeigt wird. Unterstützt Markdown. Leer lassen, um auf eine externe Impressumsseite zu verlinken.",
  "admin.config.legal.imprint-url": "Impressum-URL",
  "admin.config.legal.imprint-url.description": "Wenn bereits eine Impressumsseite vorhanden ist, kann sie hier verlinkt werden, anstatt den Text einzugeben.",
  "admin.config.legal.privacy-policy-text": "Datenschutzerklärungstext",
  "admin.config.legal.privacy-policy-text.description": "Der Text, der in der Datenschutzerklärung angezeigt wird. Unterstützt Markdown. Leer lassen, um auf eine externe Datenschutzerklärungsseite zu verlinken.",
  "admin.config.legal.privacy-policy-url": "Datenschutzerklärungs-URL",
  "admin.config.legal.privacy-policy-url.description": "Wenn bereits eine Datenschutzerklärungsseite vorhanden ist, kann sie hier verlinkt werden, anstatt den Text einzugeben.",
  // 404
  "404.description": "Ups, diese Seite existiert nicht.",
  "404.button.home": "Zurück zur Startseite",
  // error
  "error.title": "Fehler",
  "error.description": "Ups!",
  "error.button.back": "Zurück",
  "error.msg.default": "Etwas ist schiefgelaufen.",
  "error.msg.access_denied": "Du hast den Authentifizierungsprozess abgebrochen, bitte versuche es erneut.",
  "error.msg.expired_token": "Der Authentifizierungsprozess hat zu lange gedauert, bitte versuche es erneut.",
  "error.msg.invalid_token": "Interner Fehler",
  "error.msg.no_user": "Der mit diesem {0} Konto verknüpfte Benutzer existiert nicht.",
  "error.msg.no_email": "Kann die E-Mail-Adresse von dem Konto {0} nicht abrufen.",
  "error.msg.already_linked": "Das Konto {0} ist bereits mit einem anderen Konto verknüpft.",
  "error.msg.not_linked": "Das Konto {0} wurde noch nicht mit einem Konto verknüpft.",
  "error.msg.unverified_account": "Dieses Konto {0} wurde noch nicht verifiziert, bitte versuche es nach der Verifikation erneut.",
  "error.msg.user_not_allowed": "Du bist nicht berechtigt, dich anzumelden.",
  "error.msg.cannot_get_user_info": "Ihre Benutzerinformationen können von diesem {0} Konto nicht abgerufen werden.",
  "error.param.provider_github": "GitHub",
  "error.param.provider_google": "Google",
  "error.param.provider_microsoft": "Microsoft",
  "error.param.provider_discord": "Discord",
  "error.param.provider_oidc": "OpenID Connect",
  // Common translations
  "common.button.save": "Speichern",
  "common.button.create": "Erstellen",
  "common.button.submit": "Bestätigen",
  "common.button.delete": "Löschen",
  "common.button.cancel": "Abbrechen",
  "common.button.confirm": "Bestätigen",
  "common.button.disable": "Deaktivieren",
  "common.button.share": "Teilen",
  "common.button.generate": "Generieren",
  "common.button.done": "Fertig",
  "common.text.link": "Link",
  "common.text.navigate-to-link": "Link öffnen",
  "common.text.or": "oder",
  "common.text.redirecting": "Umleitung...",
  "common.button.go-back": "Zurück",
  "common.button.go-home": "Zur Startseite",
  "common.notify.copied": "Dein Link wurde in die Zwischenablage kopiert",
  "common.notify.copied-link": "Dein Link wurde in die Zwischenablage kopiert",
  "common.success": "Erfolg",
  "common.error": "Fehler",
  "common.error.unknown": "Ein unbekannter Fehler ist aufgetreten",
  "common.error.invalid-email": "Ungültige E-Mail-Adresse",
  "common.error.too-short": "Muss mindestens {length} Zeichen enthalten",
  "common.error.too-long": "Muss maximal {length} Zeichen enthalten",
  "common.error.number-too-small": "Darf mindestens {min} sein",
  "common.error.number-too-large": "Darf höchstens {max} sein",
  "common.error.exact-length": "Muss genau {length} Zeichen lang sein",
  "common.error.invalid-number": "Muss eine Zahl sein",
  "common.error.field-required": "Dieses Feld ist erforderlich"
};