import arabic from "./translations/ar-EG";
import czech from "./translations/cs-CZ";
import danish from "./translations/da-DK";
import german from "./translations/de-DE";
import greek from "./translations/el-GR";
import english from "./translations/en-US";
import spanish from "./translations/es-ES";
import finnish from "./translations/fi-FI";
import french from "./translations/fr-FR";
import croatian from "./translations/hr-HR";
import hungarian from "./translations/hu-HU";
import italian from "./translations/it-IT";
import japanese from "./translations/ja-JP";
import korean from "./translations/ko-KR";
import dutch from "./translations/nl-BE";
import polish from "./translations/pl-PL";
import portuguese from "./translations/pt-BR";
import russian from "./translations/ru-RU";
import slovenian from "./translations/sl-SI";
import serbianLatin from "./translations/sr-CS";
import serbianCyrillic from "./translations/sr-SP";
import swedish from "./translations/sv-SE";
import thai from "./translations/th-TH";
import turkish from "./translations/tr-TR";
import ukrainian from "./translations/uk-UA";
import viatnamese from "./translations/vi-VN";
import chineseSimplified from "./translations/zh-CN";
import chineseTraditional from "./translations/zh-TW";

export const LOCALES = {
  ENGLISH: {
    name: "English",
    code: "en-US",
    messages: english,
  },
  GERMAN: {
    name: "Deutsch",
    code: "de-DE",
    messages: german,
  },
  FRENCH: {
    name: "Français",
    code: "fr-FR",
    messages: french,
  },
  PORTUGUESE_BRAZIL: {
    name: "Português (Brasil)",
    code: "pt-BR",
    messages: portuguese,
  },
  DANISH: {
    name: "Dansk",
    code: "da-DK",
    messages: danish,
  },
  SPANISH: {
    name: "Español",
    code: "es-ES",
    messages: spanish,
  },
  CHINESE_SIMPLIFIED: {
    name: "简体中文",
    code: "zh-CN",
    messages: chineseSimplified,
  },
  CHINESE_TRADITIONAL: {
    name: "正體中文",
    code: "zh-TW",
    messages: chineseTraditional,
  },
  FINNISH: {
    name: "Suomi",
    code: "fi-FI",
    messages: finnish,
  },
  RUSSIAN: {
    name: "Русский",
    code: "ru-RU",
    messages: russian,
  },
  UKRAINIAN: {
    name: "Українська",
    code: "uk-UA",
    messages: ukrainian,
  },
  THAI: {
    name: "ไทย",
    code: "th-TH",
    messages: thai,
  },
  SERBIAN: {
    name: "Српски",
    code: "sr-SP",
    messages: serbianCyrillic,
  },
  SERBIAN_LATIN: {
    name: "Srpski",
    code: "sr-CS",
    messages: serbianLatin,
  },
  DUTCH: {
    name: "Nederlands",
    code: "nl-BE",
    messages: dutch,
  },
  JAPANESE: {
    name: "日本語",
    code: "ja-JP",
    messages: japanese,
  },
  POLISH: {
    name: "Polski",
    code: "pl-PL",
    messages: polish,
  },
  SWEDISH: {
    name: "Svenska",
    code: "sv-SE",
    messages: swedish,
  },
  ITALIAN: {
    name: "Italiano",
    code: "it-IT",
    messages: italian,
  },
  GREEK: {
    name: "Ελληνικά",
    code: "el-GR",
    messages: greek,
  },
  SLOVENIAN: {
    name: "Slovenščina",
    code: "sl-SI",
    messages: slovenian,
  },
  ARABIC: {
    name: "العربية",
    code: "ar-EG",
    messages: arabic,
  },
  HUNGARIAN: {
    name: "Hungarian",
    code: "hu-HU",
    messages: hungarian,
  },
  KOREAN: {
    name: "한국어",
    code: "ko-KR",
    messages: korean,
  },
  TURKISH: {
    name: "Türkçe",
    code: "tr-TR",
    messages: turkish,
  },
  CZECH: {
    name: "Čeština",
    code: "cs-CZ",
    messages: czech,
  },
  VIATNAMESE: {
    name: "Tiếng Việt",
    code: "vi-VN",
    messages: viatnamese,
  },
  CROATIAN: {
    name: "Hrvatski",
    code: "hr-HR",
    messages: croatian,
  },
};
