---
id: s3
---

# S3

You are able to add your preferred S3 provider, like AWS, DigitalOcean, Exoscale or Infomaniak. However, if you don't
want to store your files on a S3 bucket, you don't have to. Consider that this feature is `DISABLED` per default.

## Configuration

You can configure your S3 provider and bucket by going to the configuration page in your admin dashboard `/admin/config/s3`.

| Key        | Description                                                                                                                          | Value                                         |
|:-----------|:-------------------------------------------------------------------------------------------------------------------------------------|:----------------------------------------------|
| enabled    | This property enables the storage location on your configured S3 bucket.                                                             | `true`                                        |
| endpoint   | The host for your S3 bucket. Endpoint formats vary by provider and some may include the bucket name in the FQDN. Ensure this is configured correctly, as an incorrect value may break some features.                                                                                       | `sos-ch-dk-2.exo.io`                                 |
| region     | This property is the region where the bucket is located.                                                                             | `sos-ch-dk-2`                          |
| bucketName | This property is the name of your S3 bucket.                                                                                         | `my-bucket`                                   |
| bucketPath | This property defines the folder where you want to store your files which are uploaded. Hint: Don't put a slash in the start or end. | `my/custom/path` (or leave it empty for root) |
| key        | This is the access key you need to access to your bucket.                                                                            | `key-asdf`                                    |
| secret     | This is the secret you need to access to your bucket.                                                                                | `secret-asdf`                                 |

Don't forget to save the configuration. :)

## ClamAV

Consider that ClamAV scans are not available at the moment if you store your files in a S3 bucket. 

## ZIP 

Creating ZIP archives is not currently supported if you store your files in an S3 bucket.
