﻿using Stimulsoft.Base.Localization;
using Stimulsoft.Report;
using System;
using Windows.UI.Xaml;
using Windows.UI.Xaml.Controls;

namespace Variables
{
    public sealed partial class MainPage : Page
    {
        public MainPage()
        {
            this.InitializeComponent();

            StiOptions.Viewer.Elements.ReportOpenButtonVisibility = Visibility.Collapsed;
            this.Loaded += BlankPage_Loaded;
        }

        #region Fields
        private const string reportStr = "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";
        #endregion

        #region Handlers
        async private void BlankPage_Loaded(object sender, RoutedEventArgs e)
        {
            viewerCotnrol.ShowProgressBar(StiLocalization.Get("DesignerFx", "LoadingReport"));

            byte[] buffer = Convert.FromBase64String(reportStr);
            StiReport report = new StiReport();
            await report.LoadAsync(buffer);
            await report.RenderAsync();

            viewerCotnrol.Report = report;

            viewerCotnrol.HideProgressBar();
        }

        async private void btPreview_Click(object sender, RoutedEventArgs e)
        {
            viewerCotnrol.ShowProgressBar(StiLocalization.Get("DesignerFx", "LoadingReport"));

            StiReport report = viewerCotnrol.Report;
            if (report == null) return;

            viewerCotnrol.Report = null;

            //Set Variables
            report["Name"] = tbName.Text;
            report["Surname"] = tbSurname.Text;
            report["Email"] = tbEmail.Text;
            report["Address"] = tbAddress.Text;
            report["Sex"] = rbMale.IsChecked.Value;

            await report.RenderAsync();
            viewerCotnrol.Report = report;

            viewerCotnrol.HideProgressBar();
        }
        #endregion
    }
}
