﻿using Stimulsoft.Report;
using Stimulsoft.Report.Chart;
using Stimulsoft.Report.Components;
using System;
using Windows.UI.Xaml;
using Windows.UI.Xaml.Controls;

namespace RealtimePreview
{
    public sealed partial class MainPage : Page
    {
        public MainPage()
        {
            this.InitializeComponent();
            StiOptions.Viewer.Elements.ReportOpenButtonVisibility = Visibility.Collapsed;

            #region Init
            timer = new DispatcherTimer();
            timer.Interval = TimeSpan.FromMilliseconds(70);
            timer.Tick += timer_Tick;
            #endregion

            this.Loaded += BlankPage_Loaded;
        }

        #region Fields
        private const string reportStr = "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";
        private Stimulsoft.Report.StiReport stiReport1;

        private StiChart chart = null;
        private DispatcherTimer timer;
        private float angle = 0;
        #endregion

        #region Handlers
        async private void BlankPage_Loaded(object sender, RoutedEventArgs e)
        {
            byte[] buffer = Convert.FromBase64String(reportStr);
            stiReport1 = new StiReport();
            await stiReport1.LoadAsync(buffer);
            await stiReport1.RenderAsync();

            StiComponentsCollection comps = stiReport1.RenderedPages[0].GetComponents();
            chart = comps["Chart1"] as StiChart;

            viewerCotnrol.Report = stiReport1;
            timer.Start();
        }

        private void timer_Tick(object sender, object e)
        {
            //Rotate text
            angle -= 1f;
            if (angle < 0) angle = 359;

            //Rotate series 1
            angle = ((StiDoughnutSeries)chart.Series[0]).StartAngle;
            angle -= 1f;
            if (angle < 0) angle = 359;
            ((StiDoughnutSeries)chart.Series[0]).StartAngle = angle;

            //Rotate series 2
            angle = ((StiDoughnutSeries)chart.Series[1]).StartAngle;
            angle += 1f;
            if (angle > 359) angle = 0;
            ((StiDoughnutSeries)chart.Series[1]).StartAngle = angle;

            viewerCotnrol.UpdateCurrentVisualPageContent();
        }
        #endregion
    }
}
