---
name: "\U0001F4A5 v7 Regression"
about: Report an unexpected behavior in v7 from v6 (Check the upgrade guide first
  ✌️)
title: ''
labels: 'i: bug, 7.x: regression, i: needs triage'
assignees: ''

---

# v7 Regression

> First check out: https://babeljs.io/docs/en/v7-migration
> Also a partial upgrade tool: https://github.com/babel/babel-upgrade

**Potential Commit/PR that introduced the regression**
If you have time to investigate, what PR/date introduced this issue.

**Describe the regression**
A clear and concise description of what the regression is.

**Input Code**
<!--- If you have link to our REPL or a standalone repo please link that! -->

```js
var your => (code) => here;
```

**Babel Configuration (.babelrc, package.json, cli command)**

```js
{
  "your": { "config": "here" }
}
```

**Expected behavior/code**
A clear and concise description of what you expected to happen (or code).

**Environment**
- Babel version(s): [e.g. v6.0.0, v7.0.0-beta.34]
- Node/npm version: [e.g. Node 8/npm 5]
- OS: [e.g. OSX 10.13.4, Windows 10]
- Monorepo [e.g. yes/no/Lerna]
- How you are using Babel: [e.g. `cli`, `register`, `loader`]
