# Be sure to restart your server when you modify this file.
#
# This file contains migration options to ease your Rails 6.0 upgrade.
#
# Once upgraded flip defaults one by one to migrate to the new default.
#
# Read the Guide for Upgrading Ruby on Rails for more info on each option.

# Don't force requests from old versions of IE to be UTF-8 encoded.
Rails.application.config.action_view.default_enforce_utf8 = false

# Embed purpose and expiry metadata inside signed and encrypted
# cookies for increased security.
#
# This option is not backwards compatible with earlier Rails versions.
# It's best enabled when your entire app is migrated and stable on 6.0.
# TODO DURING SUMMER HIATUS:
# Rails.application.config.action_dispatch.use_cookies_with_metadata = true

# Return false instead of self when enqueuing is aborted from a callback.
Rails.application.config.active_job.return_false_on_aborted_enqueue = true

# Send Active Storage analysis and purge jobs to dedicated queues.
Rails.application.config.active_storage.queues.analysis = :active_storage_analysis
Rails.application.config.active_storage.queues.purge    = :active_storage_purge

# Use ActionMailer::MailDeliveryJob for sending parameterized and normal mail.
#
# The default delivery jobs (ActionMailer::Parameterized::DeliveryJob, ActionMailer::DeliveryJob),
# will be removed in Rails 6.1. This setting is not backwards compatible with earlier Rails versions.
# If you send mail in the background, job workers need to have a copy of
# MailDeliveryJob to ensure all delivery jobs are processed properly.
# Make sure your entire app is migrated and stable on 6.0 before using this setting.
Rails.application.config.action_mailer.delivery_job = "ActionMailer::MailDeliveryJob"
