<!--

@license CC-BY-SA-4.0

-->

# Application

> Google Summer of Code organization application for 2024.

**Note**: do not use any markup in this document in order to make it easier to copy and paste answers into the official application document.

Each answer must **not** exceed 1000 characters.

## Questionnaire

### Why does your organization want to participate in Google Summer of Code (GSoC)?

First and foremost, we want to leverage GSoC as an opportunity to grow our community and introduce new contributors to open source. While we realize that many contributors will move on to other endeavors after GSoC is over, our hope is that some GSoC contributors will find a home in the stdlib community, continue contributing to the project, and eventually join the stdlib core development team where they'll have a direct hand in shaping the future of open source.

Second, GSoC gives new contributors an opportunity to be paid to work on stdlib--an opportunity that most core stdlib developers do not have--and gives stdlib the opportunity to pursue projects which are of fundamental importance but lack sufficient people power to bring to completion.

### What would your organization consider to be a successful GSoC program?

We want contributors to take on projects which are important to stdlib and to implement them successfully, thus improving stdlib. A successful program is thus one in which (a) GSoC contributors are having fun, learning, and feeling excited about their work, (b) GSoC contributors have, on average, at least one merged pull request every week, (c) GSoC contributors continue interacting with our community outside of their project and continue contributing after the program is over, and (d) the stdlib community benefits from the conversations, new perspectives, and unique talents that each GSoC contributor will bring while working on projects of fundamental importance.

### How will you keep mentors engaged with their GSoC contributors?

Most stdlib mentors have either mentored as part of GSoC or elsewhere or were GSoC contributors in the past. We require that mentors be existing contributors to stdlib and be familiar with both the code and the project area. We further require that mentors and contributors interact and communicate publicly in order to encourage participation from the greater stdlib community. And lastly, we require that mentors and contributors meet at least once a week to discuss their project, preferably via video conferencing, and we strongly encourage that mentors pair program with contributors at least once every two weeks.

Each project will have one or more backup or co-mentors, and no mentor is allowed to be a primary mentor for more than one project, or a backup or co-mentor for more than two projects. This may require taking fewer slots than we would like, but we believe this is better than stretching our mentoring capacity too thin and risking mentor burn out.

### How will you help your GSoC contributors stay on schedule to complete their projects?

By holding weekly 1-on-1s and bi-weekly pair programming sessions, one of our primary goals will be to notice, as early as possible, when a contributor is struggling. Early identification of problems or potential slippages will allow us to quickly provide the support and resources a contributor needs to succeed and overcome encountered problems. We anticipate that, in most cases, if a contributor is struggling, a project's timeline will be found to be unrealistic or require modification due to, e.g., unforeseen technical challenges.

If a contributor continues to struggle despite increased mentor support, we'll give a contributor a reasonable, mutually agreed upon set of goals to achieve in 1-2 weeks. If the contributor begins making sufficient progress (with our help), we will pass the contributor. Otherwise, we will fail the contributor.

### How will you get your GSoC contributors involved in your community during GSoC?

Establishing a habit of open communication is vital for open source participation. We strongly encourage that all mentor-contributor interactions happen on a public channel, such as our public Element channel or on GitHub. For all weekly mentor-contributor meetings, we require that meeting minutes be posted to a public wiki. By encouraging public participation and communication, members of the greater stdlib community have opportunities to take part in project discussions, engage in community review, and provide feedback.

GSoC contributors will be required to blog about their progress at least once every two weeks. These blogs will be aggregated on a public wiki. We will further encourage GSoC contributors to help triage issues and review other pull requests, which is an excellent way to get involved in the stdlib community.

### Anything else we should know? (optional)

N/A

### Is your organization part of any government? (yes or no)

No.

### GSoC Reference Contact? (optional)

> If you are an organization that has not been accepted into GSoC before, is there a Google employee or a veteran GSoC organization who will vouch for you? If so, please enter their name, contact email, relationship to your organization, and their role (Google employee, org admin of XX org, etc.)

SymPy (veteran organization); Aaron Meurer: asmeurer@gmail.com; Aaron is a colleague and collaborator of Athan Reines at Quansight and a long time GSoC participant and mentor; org admin of SymPy org.

Lee Richardson: leerich@google.com; Lee is a Senior Data Scientist and Tech Lead at Google and former colleague of Philipp Burckhardt during their PhD studies at Carnegie Mellon University, where they collaborated on converting a Shiny R tool to a Next.js web app; Google employee.

* * *

## Organization Application

### Ideas List

> Provide the URL for your organization's curated Ideas List for 2024. This is very important: Prospective GSoC Contributors will view this link to understand the kinds of projects available in your organization. A clean and simple presentation is best. Avoid links to unfiltered bug trackers or other specialized tools.

https://github.com/stdlib-js/google-summer-of-code/blob/main/ideas.md

### Mentors (number)

> How many Mentors does your Organization have available to participate in this program? (This is the number of people listed in our mentor document: <https://github.com/stdlib-js/google-summer-of-code/blob/main/mentors.md>.)

7

### Program Retention Survey

> The last program your organization participated in was:

N/A

#### Number of accepted students/GSoC contributors? (number)

N/A

#### Number of participants who are still active today? (number)

N/A

### Is your organization part of any government? (yes or no)

> This will not affect your selection into the program. However, as stated in the Program Rules, we can not issue org stipends to orgs that are part of any government. This includes public universities, government research institutions, etc.

No.

### Anything else we should know? (optional)

> Must be less than or equal to 500 characters.

N/A

* * *

## Profile Information

> Information for the GSoC profile.

### Name

stdlib

### Website URL

https://stdlib.io

### Upload logo

> 24-bit PNG, minimum height of 256 pixels.

https://github.com/stdlib-js/google-summer-of-code/blob/main/organization/applications/logo.png

### Tagline

> A very short description of your organization. Must be less than or equal to 50 characters.

The fundamental numerical library for JavaScript

### Primary open source license

> The open source license that your organization uses.

Apache-2.0

### What year was your project started?

2016

### Link to your source code location

https://github.com/stdlib-js/stdlib

### Organization categories

> Select which categories fit your organization best. You may select up to 2 categories. This helps GSoC contributors filter the large list of organizations by their interests.

- [ ] Artificial intelligence
- [x] Data (databases, analytics, visualization, AI/ML, etc)
- [ ] Development tools (version control systems, CICD tools, text editors, issue managers, q/a tools, etc)
- [ ] End user applications
- [ ] Infrastructure and cloud (hardware, software defined infrastructure, cloud native tooling, orchestration and automation, etc)
- [ ] Media (graphics, video, audio, VR, streaming, gaming, content management, etc)
- [ ] Operating systems
- [ ] Programming languages (libraries, package managers, testing tools, etc)
- [x] Science and medicine (healthcare, biotech, life sciences, academic research, etc)
- [ ] Security (tools and frameworks)
- [ ] Social and communications (Blog, chat, forums, wikis, etc)
- [ ] Web (tools and frameworks)
- [ ] Other

### Organization technologies

> Enter up to 5 keywords for the primary specific technologies your organization uses. Examples: Python, Javascript, MySQL, Hadoop, OpenGL, Arduino.

JavaScript, Node.js, C, TypeScript

### Organization topics

> Enter keywords for general topics that describe your organization. Examples: Robotics, Cloud, Graphics, Web, etc. Select up to 5.

Scientific Computing, Mathematics, Statistics, Numerical Computing, Web

### Organization description

> Describe what it is your organization does. This information will also be included in the archive once the program has ended.

stdlib is a standard library for JavaScript and Node.js with an emphasis on numerical and scientific computing applications. The project aims to provide functionality similar to NumPy and SciPy for use in JavaScript environments with special consideration for the unique constraints and opportunities afforded by the Web. stdlib is primarily written in JavaScript, C, and Fortran.

### Contributor guidance

> Provide your potential contributors with a page containing tips on how to write a successful proposal for your organization. Let them know what you want included, how you want it structured, and how to best get in touch.

https://github.com/stdlib-js/google-summer-of-code

### Direct Communication methods

> How do you want potential contributors to interact with your organization and mentors? Chat clients such as IRC, Zulip or Rocket Chat are very well suited to Google Summer of Code collaboration and are recommended. But email or other methods are also acceptable. Choose communications options from the dropdown below. One email or chat method required.

chat; https://gitter.im/stdlib-js/stdlib

### Social Communication Methods

> Social platforms for bi-directional communications can be useful in getting input from potential contributors. Choose social channel options from the dropdown below.

Twitter; https://twitter.com/stdlibjs
