<!--

@license CC-BY-SA-4.0

-->

# Mentors

> Potential mentors.

If you are willing to mentor,

1. read the [GSoC mentor guide](https://google.github.io/gsocguides/mentor/).
1. register at <https://summerofcode.withgoogle.com/>. 
1. submit a pull request adding yourself to the list below, making sure (1) to include any project ideas that you'd be willing to mentor by linking to the relevant issue(s), (2) to provide your GitHub handle, and (3) to include the e-mail that you used to register at <https://summerofcode.withgoogle.com/>.

## Mentor List

- Athan Reines

    - e-mail: [kgryte@gmail.com](mailto:kgryte@gmail.com)
    - GitHub: [kgryte](https://github.com/kgryte)
    - projects: all
    
- Philipp Burckhardt

    - e-mail: [philipp.burckhardttc@gmail.com](mailto:philipp.burckhardttc@gmail.com)
    - GitHub: [planeshifter](https://github.com/planeshifter)
    - projects: all

- Gagandeep Singh

    - e-mail: [gdp.1807@gmail.com](mailto:gdp.1807@gmail.com)
    - GitHub: [czgdp1807](https://github.com/czgdp1807)
    - projects: anything involving implementation of mathematical functions or array programming

- Ricky Reusser

    - e-mail: [rsreusser@gmail.com](mailto:rsreusser@gmail.com)
    - GitHub: [rreusser](https://github.com/rreusser)
    - projects: most, with particular interest in those involving numerics

- Pranav Goswami

    - e-mail: [goswami.4@iitj.ac.in](mailto:goswami.4@iitj.ac.in)
    - GitHub: [pranavchiku](https://github.com/pranavchiku)
    - projects: most, particularly implementation of BLAS and mathematical functions

- Stephannie Jimenez Gacha
    
    - e-mail: [steff456@hotmail.com](steff456@hotmail.com)
    - GitHub: [steff456](https://github.com/steff456)
    - projects: implementation of mathematical functions and Google Sheets APIs 
    
- Robert Gislason

    - e-mail: [gztown2216@yahoo.com](mailto:gztown2216@yahoo.com)
    - GitHub: [rgizz](https://github.com/rgizz)
    - projects: all

## Time Commitment

For primary mentors, we expect between a 3-10 hour a week commitment, where the requisite time decreases over the course of the program. Mentors can expect to spend more time the first few weeks prior to the contributor start date, where you'll be helping flesh out the project ideas, discussing projects with potential contributors, and selecting contributors based on their submitted proposals. Once contributors are selected and the program kicks off, your commitment should decrease to 2-4 hours a week and be comprised of a weekly 1 hour 1-on-1 where you'll establish rapport and discuss project progress and of some additional time to perform code review and answer questions as they arise. Ideally, a mentor will pair program with a contributor for 1 hour every two weeks throughout the duration of the program.

## Required Knowledge

In general, **successful mentors are those who are already developers and community members of stdlib**. If you're new to stdlib, expect to take time to learn the ropes yourself so that you are in a position to help GSoC contributors.

Mentors do not have to be be experts in all things stdlib. Much of what mentors do is keeping contributors on track and helping them get unstuck when they encounter unexpected obstacles. Sometimes that means just knowing who and what to ask and where to look rather than knowing the answer yourself. In an ideal world, a mentor can answer basic architectural questions and knows how to get code accepted upstream (e.g., is deeply familiar with project conventions, practices, and development workflows).

## Contributor Evaluations

Mentors must perform multiple evaluations on each GSoC contributor, two mid-terms and one at the end. Evaluations typically consist of a few questions about how the GSoC contributor is doing and then a pass/fail that determines if the GSoC contributor is paid and continues in the program.
