<!--

@license CC-BY-SA-4.0

-->

# FAQ

> Frequently asked questions.

## Why do you strongly suggest that I submit my application to a public issue tracker?

The application process follows a similar process to how open source software communities normally operate. Namely, someone has a proposal, engages in discussion with the community and key stakeholders, and opens an RFC to formalize and finalize discussion before actually engaging in the proposed work. Accordingly, having a public application process is an extension of the open source process and ethos. For GSoC, we believe that all members of the stdlib community should have a chance to weigh in on possible proposals, not just core developers, in order to ensure that the project goals align with stakeholder interests. The only way to ensure community review is through a public process.

We understand, however, the feeling of wanting to be protective of one's idea, especially in what is perceived as a competitive environment, for fear that someone else could swoop in and copy the idea. Setting aside how likely such a threat is, our application process requires that an applicant provide their usernames/handles/name along with their application so that we can associate a particular proposal with a single individual. If individual X proposes A and then individual Y comes along, copies A with some small modifications, and proposes A', we have a public record of who was first and can give priority accordingly.

In short, given that the intent of GSoC is offering new contributors a pathway into open source, we believe that it's conceptually consistent to embrace a culture of public discussion from the outset, as engaging in public discussion and with the community is something that will have to be done throughout the GSoC program and hopefully beyond.

## How can I reach out privately if I need to ask something confidential?

In general, we prefer open and public communication. However, we recognize that you may have legitimate concerns regarding the sharing of personal information, especially in public forums. If you need to communicate privately, you can e-mail one of the [mentors](https://github.com/stdlib-js/google-summer-of-code/blob/main/mentors.md) directly.

If you do reach out directly to a mentor, please be **respectful** of their time. If your e-mail is not for confidential purposes (e.g., you're e-mailing to ask if you can do idea X or something similar), mentors are likely to refer you to our public [Element](https://gitter.im/stdlib-js/stdlib) channel.

## Why are idea issues locked?

Idea issues are **not** our desired forum for initial project inquiries and are intended to be a lightweight means for core stdlib developers to write down potential GSoC project ideas. Our aim is to keep idea issues as clear and succinct as possible and to avoid long drawn out discussions which are better suited for chat.

If you have questions or are interested in pursuing a particular idea, you should reach out in our [Element](https://gitter.im/stdlib-js/stdlib) channel. 
