<!DOCTYPE html>
<html lang="en">
<head>
<!-- Global site tag (gtag.js) - Google Analytics -->
<script async src="https://www.googletagmanager.com/gtag/js?id=G-KT70WCFP83"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());

  gtag('config', 'G-KT70WCFP83');
</script>
<script async src="https://www.googletagmanager.com/gtag/js?id=UA-179945536-1"></script>
<script>
	$(document).ready(testAlert);
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());

  gtag('config', 'UA-179945536-1');
</script>

	<meta charset="UTF-8" />
	<meta content="width=device-width,initial-scale=1.0,maximum-scale=1.0" name="viewport">
	<meta name="twitter:widgets:theme" content="light">
	<meta property="og:title" content="Your-Title-Here" />
	<meta property="og:type" content="website" />
	<meta property="og:image" content="Your-Image-Url" />
	<meta property="og:description" content="Your-Page-Description" />
	<title>NVIDIA DGX A100 프로모션</title>
	<link rel="shortcut icon" type="image/x-icon" href="">

	<!-- Font -->
	
	<!-- Css -->
	<link rel="stylesheet" href="css/core.min.css" />
	<link rel="stylesheet" href="css/skin-architecture-one-page.css" />

	<!--[if lt IE 9]>
    	<script type="text/javascript" src="http://html5shiv.googlecode.com/svn/trunk/html5.js"></script>
    <![endif]-->

</head>
<body class="shop home-page">

	<div class="wrapper reveal-side-navigation">
		<div class="wrapper-inner">

			<!-- Header -->
			<header class="header header-fixed header-fixed-on-mobile header-transparent" data-bkg-threshold="100">
				<div class="header-inner">
					<div class="row nav-bar">
						<div class="column width-12 nav-bar-inner">
							<div class="logo">
								<div class="logo-inner">
									<a href="http://www.krinfra.co.kr/" target="_blank"><img src="images/main_logo_bl.png" alt="Sartre Logo" /></a>
									<a href="http://www.krinfra.co.kr/" target="_blank"><img src="images/main_logo_wh.png" alt="Sartre Logo" /></a>
								</div>
							</div>
							<nav class="navigation nav-block secondary-navigation nav-right">
								<ul>
									<li class="aux-navigation hide">
										<!-- Aux Navigation -->
										<a href="#" class="navigation-show side-nav-show nav-icon">
											<span class="icon-menu"></span>
										</a>
									</li>
								</ul>
							</nav>
							<nav class="navigation nav-block primary-navigation nav-right">
								<ul>
									<li class="current">
										<a href="#home" data-offset="0" class="scroll-link">Home</a>
									</li>
									<li>
										<a href="#a100" data-offset="-60" class="scroll-link">DGX A100</a>
									</li>
									<li>
										<a href="#a100s" data-offset="-60" class="scroll-link">DGX STATION</a>
									</li>
									<li>
										<a href="#lease" data-offset="-60" class="scroll-link">리스 프로그램</a>
									</li>
									<li>
										<a href="#inception" data-offset="-60" class="scroll-link">인셉션 프로그램</a>
									</li>
									<li>
										<a href="#cs" data-offset="-60" class="scroll-link">문의하기</a>
									</li>
								</ul>
							</nav>
						</div>
					</div>
				</div>
			</header>
			<!-- Header End -->

			<!-- Content -->
			<div class="content clearfix">

				<!-- Fullscreen Slider Section -->
				<section id="home" class="section-block featured-media tm-slider-parallax-container">
					<div class="tm-slider-container full-width-slider" data-featured-slider data-parallax data-animation="slide" data-scale-under="960">
						<ul class="tms-slides">
							<li class="tms-slide" data-image data-as-bkg-image data-force-fit data-overlay-bkg-color="#000000" data-overlay-bkg-opacity="0.3" data-animation="scaleOut">
								<div class="tms-content">
									<div class="tms-content-inner center v-align-middle">
										<div class="row">
											<div class="column width-8 aLeft">
												<div class="tms-caption" data-animate-in="preset:signSwingBottom;duration:600ms;easing:easeFastSlow;" data-no-scale>
													<p class="title-medium color-white">오직 한국인프라 고객에게만 제공되는</p>
													<h1 class="title-large color-white lspacing-small mb-10 text-uppercase aLeft">
														NVIDIA DGX A100 프로모션
													</h1>
													<p class="title-medium color-black no-margin-bottom aLeft">
														DGX A100을 구매하시면 LG그램 i5와 렉스마크 복합기를<br>
														DGX STATION A100을 구매하시면 LG그램 i5를 드립니다.
													</p>
												</div>
											</div>
										</div>
									</div>
								</div>
								<img data-src="images/data-center-dgx-systems-header-bb300-d@2x.jpg" data-retina src="images/blank.png" height="460px" alt=""/>
							</li>
						</ul>
					</div>
				</section>
				<!-- Fullscreen Slider Section End -->

				<div id="getting-started" class="section-block no-padding feature-column-group">
					<div class="row full-width collapse flex">
						<div class="column width-6" style="background:url(images/nvidia-corporation-about-us-banner-2560-ud.jpg);background-position:50% 50%;background-repeat:no-repeat">
							<div class="feature-column small pt-80 pb-50 horizon" data-animate-in="preset:slideInLeftShort;duration:1000ms;delay:600ms;" data-threshold="0.5">
								<div class="feature-text box">
									<p class="title-m-medium color-white">실속은 늘리고 부담은 줄이고</p>
									<h4 class="title-s-large color-white">리스 프로그램</h4>
									<a href="#lease">자세히 보기</a>
								</div>
							</div>
						</div> 
						<div class="column width-6" style="background:url(images/inception-banner-background-image-spec2-bb460_420-d.jpg);background-position:50% 50%;background-repeat:no-repeat">
							<div class="feature-column small pt-80 pb-50 horizon" data-animate-in="preset:slideInLeftShort;duration:1000ms;delay:800ms;" data-threshold="0.5">
								<div class="feature-text box">
									<p class="title-m-medium color-white">교육기관, 스타트업 대상 30% 할인</p>
									<h4 class="title-s-large color-white">인셉션 프로그램</h4>
									<a href="#inception">자세히 보기</a>
								</div>
							</div>
						</div>
					</div>
				</div>
				<!-- a100 -->
				<div id="a100" class="section-block replicable-content p-120" style="background:url(images/data-center-dgx-a100-hero-2560-ud.jpg);background-position:50% 50%;background-repeat:no-repeat;background-size:cover;">
					<div class="row">
						<div class="column width-5 horizon" data-animate-in="preset:slideInRightShort;duration:1000ms;" data-threshold="0.5">
							<h1 class="title-large color-white lspacing-small mb-10 text-uppercase aLeft">NVIDIA DGX A100</h1>
							<p class="title-medium color-black text-uppercase no-margin-bottom aLeft">AI 인프라를 위한 유니버설 시스템</p>
						</div>
					</div>
				</div>
				<div class="section-block replicable-content">
					<div class="row p-t-60 p-b-40">
						<div class="column">
							<div class="row flex boxes">

								<div class="content-grid-1 w-100">
									<div class="column grid-item horizon" data-animate-in="preset:slideInUpShort;duration:1000ms;" data-threshold="0.3">
										<div class="team-content-info bkg-white">
											<p class="title-m-large color-green a-center w-100">NVIDIA A100 기반의 세계 최초 AI 시스템</p>
										</div>
									</div>
								</div>
							</div>
						</div>
						<div class="column">
							<div class="row flex boxes">

								<div class="row content-grid-1">
									<div class="column grid-item horizon" data-animate-in="preset:slideInUpShort;duration:1000ms;delay:200ms;" data-threshold="0.3">
										<div class="team-content-info bkg-white">
											<p class="title-m-medium"><span class="color-green">NVIDIA DGX™ A100</span>은 모든 AI 워크로드를 위한 유니버설 시스템으로, 세계 최초의 5페타플롭스 AI 시스템을 통해 유례없는 컴퓨팅 밀도,<br>성능 및 유연성을 제공합니다. NVIDIA DGX A100은 세계에서 가장 최첨단의 가속기인 NVIDIA A100 Tensor 코어 GPU를 탑재하여 엔터프라이즈 기업들이 NVIDIA AI 전문가의 직접적인 지원과 함께 트레이닝에서 추론, 분석에 이르기까지 배포하기 쉬운 통합 AI 인프라를 구축할 수 있게 합니다.</p>
										</div>
									</div>
								</div>
							</div>
						</div>

						<div class="column">
							<div class="row content-grid-4">
								<div class="column grid-item horizon" data-animate-in="preset:slideInUpShort;duration:1000ms;delay:400ms;" data-threshold="0.3">
									<div class="team-content-info bkg-white min-height-360">
										<h4 class="occupation"><img src="images/data-center-dgx-a100-benefits-icon_universal-system.svg" alt=""/></h4>
										<dl class="social-list list-horizontal">
											<dt class="color-green p-10 title-m-medium a-center">모든 AI 워크로드를 위한<br>유니버설 시스템</dt>
											<dd class="title-s-medium">분석에서 트레이닝과 추론에 이르기까지 NVIDIA DGX A100은 모든 AI 인프라를 위한 유니버설 시스템입니다. 컴퓨팅 밀도에 새로운 기준을 제시합니다. 6U 폼 팩터에 5페타플롭스의 AI 성능을 갖추고, 레거시 인프라 사일로를 모든 AI 워크로드에 사용 가능한 단일 플랫폼으로 대체합니다.</dd>
										</dl>
									</div>
								</div>
								<div class="column grid-item horizon" data-animate-in="preset:slideInUpShort;duration:1000ms;delay:600ms;" data-threshold="0.3">
									<div class="team-content-info bkg-white min-height-360">
										<h4 class="occupation"><img src="images/data-center-dgx-a100-benefits-icon_dgxperts.svg" alt=""/></h4>
										<dl class="social-list list-horizontal">
											<dt class="color-green p-10 title-m-medium a-center">DGXperts: AI 전문가의 지원</dt>
											<dd class="title-s-medium">NVIDIA DGXperts는 지난 10년간 쌓은 풍부한 경험으로 고객이 DGX 투자 가치를 극대화하도록 지원하는 16,000명 이상의 AI 전문가로 구성된 글로벌 팀입니다.</dd>
										</dl>
									</div>
								</div>
								<div class="column grid-item horizon" data-animate-in="preset:slideInUpShort;duration:1000ms;delay:800ms;" data-threshold="0.3">
									<div class="team-content-info bkg-white min-height-360">
										<h4 class="occupation"><img src="images/data-center-dgx-a100-benefits-icon_fastest-time.svg" alt=""/></h4>
										<dl class="social-list list-horizontal">
											<dt class="color-green p-10 title-m-medium a-center">가장 빠른 솔루션 구축</dt>
											<dd class="title-s-medium">NVIDIA DGX A100은 NVIDIA A100 Tensor 코어 GPU를 탑재한 세계 최초의 시스템입니다. 8개의 A100 GPU와 최대 640GB의 GPU 메모리 통합 를 탑재한 이 시스템은 전례없는 가속을 제공하며 NVIDIA CUDA-X™ 소프트웨어와 엔드 투 엔드 NVIDIA 데이터센터  솔루션 스택에 모두 완전히 최적화되어 있습니다.</dd>
										</dl>
									</div>
								</div>
								<div class="column grid-item horizon" data-animate-in="preset:slideInUpShort;duration:1000ms;delay:1000ms;" data-threshold="0.3">
									<div class="team-content-info bkg-white min-height-360">
										<h4 class="occupation"><img src="images/data-center-dgx-a100-benefits-icon_unmatched-data.svg" alt=""/></h4>
										<dl class="social-list list-horizontal">
											<dt class="color-green p-10 title-m-medium a-center">전례없는 데이터 센터 확장성</dt>
											<dd class="title-s-medium">NVIDIA DGX A100은 최대 500GB/s의 양방향 대역폭으로 작동하는 내장형 Mellanox 네트워킹을 탑재합니다. 이는 DGX A100을 엔터프라이즈의 확장 가능한 AI 인프라 청사진인 NVIDIA DGX SuperPOD™와 같은 대규모 AI 클러스터의 기초 빌딩 블록으로 만드는 많은 기능 중 하나입니다.</dd>
										</dl>
									</div>
								</div>
							</div>
						</div>

					</div>
				</div>
				<!-- a100 End -->
				<!-- a100 s -->
				<div id="a100s" class="section-block replicable-content p-120" style="background:url(images/dgx-station-hero-bb460_420-d.jpg);background-position:50% 50%;background-repeat:no-repeat;background-size:cover;">
					<div class="row">
						<div class="column width-8 horizon" data-animate-in="preset:slideInRightShort;duration:1000ms;" data-threshold="0.5">
							<h1 class="title-large color-white lspacing-small mb-10 text-uppercase aLeft">NVIDIA DGX STATION A100</h1>
							<p class="title-medium color-black text-uppercase no-margin-bottom aLeft">데이터 사이언스 팀을 위한 AI 슈퍼컴퓨팅</p>
						</div>
					</div>
				</div>
				<div class="section-block replicable-content">
					<div class="row p-t-60 p-b-40">
						<div class="column">
							<div class="row flex boxes">

								<div class="content-grid-1 w-100">
									<div class="column grid-item horizon" data-animate-in="preset:slideInUpShort;duration:1000ms;" data-threshold="0.3">
										<div class="team-content-info bkg-white">
											<p class="title-m-large color-green a-center w-100">데스크톱에서 구현하는 AI 슈퍼컴퓨터</p>
										</div>
									</div>
								</div>
							</div>
						</div>
						<div class="column">
							<div class="row flex boxes">

								<div class="row content-grid-1">
									<div class="column grid-item horizon" data-animate-in="preset:slideInUpShort;duration:1000ms;delay:200ms;" data-threshold="0.3">
										<div class="team-content-info bkg-white">
											<p class="title-m-medium">데이터 사이언스 팀은 최첨단 혁신을 주도하고 있지만, 프로젝트를 완료하는 데 사용할 AI 컴퓨팅 사이클을 찾아 헤매는 경우가 많습니다. 이들에게 필요한 것은 여러 명의 동시 사용자에게 최대의 성능을 제공할 전용 리소스입니다. NVIDIA DGX Station™ A100이 제공하는 AI<br>슈퍼컴퓨팅을 통해 데이터 사이언스 팀은 데이터센터나 별도의 IT 투자 없이도 데이터센터 기술을 활용할 수 있습니다. 강력한 성능, 완전히 최적화된 소프트웨어 스택 및 NVIDIA <span class="color-green">DGXperts</span>에 대한 직접적인 액세스를 통해 인사이트를 더 빨리 확보할 수 있습니다.</p>
										</div>
									</div>
								</div>
							</div>
						</div>

						<div class="column">
							<div class="row content-grid-4">
								<div class="column grid-item horizon" data-animate-in="preset:slideInUpShort;duration:1000ms;delay:400ms;" data-threshold="0.3">
									<div class="team-content-info bkg-white min-height-360">
										<h4 class="occupation"><img src="images/dgx-station-icons-ol_dgx-station-workgroup-icon.svg" alt=""/></h4>
										<dl class="social-list list-horizontal">
											<dt class="color-green p-10 title-m-medium a-center">AI 시대의 워크그룹 서버</dt>
											<dd class="title-s-medium">조직에서는 DGX Station A100을 통해 기타 NVIDIA DGX™ 기반 인프라와 원활하게 통합되는 시스템을 사용하여 트레이닝, 추론, 데이터 분석 등 모든 워크로드를 처리할 중앙 집중화된 AI 리소스를 여러 사용자에게 제공할 수 있습니다. 그리고 MIG(Multi-Instance GPU)를 사용하면 개인 사용자에게 최대 28개의 별도 GPU를 할당하는 것이 가능합니다.</dd>
										</dl>
									</div>
								</div>
								<div class="column grid-item horizon" data-animate-in="preset:slideInUpShort;duration:1000ms;delay:600ms;" data-threshold="0.3">
									<div class="team-content-info bkg-white min-height-360">
										<h4 class="occupation"><img src="images/dgx-station-icons-ol_dgx-station-data-center-icon.svg" alt=""/></h4>
										<dl class="social-list list-horizontal">
											<dt class="color-green p-10 title-m-medium a-center">데이터센터 없이도<br>이용 가능한 데이터센터 성능</dt>
											<dd class="title-s-medium">DGX Station A100은 데이터센터 성능이나 냉각이 필요 없는 서버급 AI 시스템입니다. 4개의 NVIDIA A100 Tensor 코어 GPU, 최첨단 서버급 CPU, 초고속 NVMe 스토리지, 첨단 PCIe Gen4 버스와 함께 원격 관리가 포함되어 있어 서버처럼 관리할 수 있습니다.</dd>
										</dl>
									</div>
								</div>
								<div class="column grid-item horizon" data-animate-in="preset:slideInUpShort;duration:1000ms;delay:800ms;" data-threshold="0.3">
									<div class="team-content-info bkg-white min-height-360">
										<h4 class="occupation"><img src="images/dgx-station-icons-ol_dgx-station-ai-appliance-icon.svg" alt=""/></h4>
										<dl class="social-list list-horizontal">
											<dt class="color-green p-10 title-m-medium a-center">어디에든 배치할 수 있는<br>AI 어플라이언스</dt>
											<dd class="title-s-medium">기업 사무실, 실험실, 연구 시설, 심지어는 집에서도 근무하는 오늘날의 민첩한 데이터 사이언스 팀을 위해 고안된 DGX Station A100의 경우 복잡한 설치나 큰 IT 투자가 필요하지 않습니다. 표준 벽콘센트와 전원을 연결하기만 하면 몇 분 안에 어디서든 일을 시작할 수 있습니다.</dd>
										</dl>
									</div>
								</div>
								<div class="column grid-item horizon" data-animate-in="preset:slideInUpShort;duration:1000ms;delay:600ms;" data-threshold="0.3">
									<div class="team-content-info bkg-white min-height-360">
										<h4 class="occupation"><img src="images/dgx-station-icons-ol_dgx-station-models-icon.svg" alt=""/></h4>
										<dl class="social-list list-horizontal">
											<dt class="color-green p-10 title-m-medium a-center">더 커진 모델, 더 빨라진 응답</dt>
											<dd class="title-s-medium">NVIDIA DGX Station A100은 전 세계에서 유일한 워크스테이션형 시스템으로, 완전히 인터커넥트되고 MIG가 지원되는 4개의 NVIDIA A100 GPU가 있으며 여러 사용자와 함께 병렬 작업을 실행하기 위해 NVIDIA® NVLink®를 활용합니다. 물론 시스템 성능에 영향을 주는 일 없이 말입니다. GPU가 완전하게 최적화된 소프트웨어 스택 및 최대 320GB(기가바이트)의 GPU 메모리를 사용하여 대형 모델을 트레이닝하세요.</dd>
										</dl>
									</div>
								</div>
							</div>
						</div>

					</div>
				</div>
				<!-- a100 s End -->
				<!-- lease -->
				<div id="lease" class="section-block replicable-content p-120" style="background:url(images/nvidia-corporation-about-us-banner-2560-ud.jpg);background-position:50% 50%;background-repeat:no-repeat;background-size:cover;">
					<div class="row">
						<div class="column width-5 horizon" data-animate-in="preset:slideInRightShort;duration:1000ms;" data-threshold="0.5">
							<h1 class="title-m-large color-white lspacing-small mb-10 text-uppercase aLeft">리스 프로그램</h1>
							<p class="title-medium color-white text-uppercase aLeft mb-10">월 납입금으로 부담없이 DGX 시스템을<br>경험해 보세요.</p>
						</div>
					</div>
				</div>
				<div class="section-block replicable-content">
					<div class="row p-t-60 p-b-40">
						<div class="column">
							<div class="row flex boxes">

								<div class="row content-grid-1">
									<div class="column grid-item horizon" data-animate-in="preset:slideInUpShort;duration:1000ms;" data-threshold="0.3">
										<div class="team-content-info bkg-white">
											<table border="0" cellspacing="0" cellpadding="0" class="tb-con">
												<tr>
													<th>구분</th>
													<th colspan="3" class="rLineNone">금융리스</th>
												</tr>
												<tr>
													<th>리스 대상 물건</th>
													<td colspan="3">DGX-A100 / DGX-A100 Station</td>
												</tr>
												<tr>
													<th>리스 취득 원가(원)</th>
													<td colspan="3"></td>
												</tr>
												<tr>
													<th width="40%">리스기간(월)</th>
													<td width="20%" class="rLine">12</td>
													<td width="20%" class="rLine">24</td>
													<td width="20%">36</td>
												</tr>
												<tr>
													<th>선수금</th>
													<td colspan="3">0%</td>
												</tr>
												<tr>
													<th>리스료 지불방식</th>
													<td colspan="3">월 후불</td>
												</tr>
												<tr>
													<th>월리스료(원)</th>
													<td></td>
													<td></td>
													<td></td>
												</tr>
												<tr>
													<th>리스기간 종료 후 처리</th>
													<td colspan="3">소유권 무상 양도</td>
												</tr>
												<tr>
													<th>담보조건</th>
													<td colspan="3">신용</td>
												</tr>
												<tr>
													<th rowspan="4">기타사항</th>
													<td colspan="3" class="aLeft">1. 부가세 별도</td>
												</tr>
												<tr>
													<td colspan="2" class="aLeft">2. 동산종합보험료 포함</td>
													<td></td>
												</tr>
												<tr>
													<td colspan="3" class="aLeft">3. 위의 거래조건은 당사 Credit Team의 승인을 전제로 합니다.</td>
												</tr>
												<tr>
													<td colspan="3" class="aLeft">4. 월 리스료는 금리 변동에 따라 변경될 수있습니다.</td>
												</tr>
											</table>
										</div>
									</div>
								</div>
							</div>
						</div>

					</div>
				</div>
				<!-- lease End -->
				<!-- inception -->
				<div id="inception" class="section-block replicable-content p-120" style="background:url(images/inception-banner-background-image-spec2-bb460_420-d.jpg);background-position:50% 50%;background-repeat:no-repeat;background-size:cover;">
					<div class="row">
						<div class="column width-5 horizon" data-animate-in="preset:slideInRightShort;duration:1000ms;delay:400ms;" data-threshold="0.5">
							<h1 class="title-m-large color-white lspacing-small mb-10 text-uppercase aLeft">인셉션 프로그램</h1>
							<p class="title-medium color-white text-uppercase mb-10">교육기관, 스타트업 대상 30% 할인</p>
						</div>
					</div>
				</div>
				<div class="section-block replicable-content">
					<div class="row p-t-60 p-b-40">
						<div class="column">
							<div class="row flex boxes">

								<div class="content-grid-1 w-100">
									<div class="column grid-item horizon" data-animate-in="preset:slideInUpShort;duration:1000ms;delay:600ms;" data-threshold="0.3">
										<div class="team-content-info bkg-white">
											<p class="title-s-large a-center w-100">Inception Program<br><span class="color-green title-m-large">당신의 AI 스타트업을 가속화 하세요.</span></p>
										</div>
									</div>
								</div>
							</div>
						</div>
						<div class="column">
							<div class="row flex boxes">

								<div class="row content-grid-1">
									<div class="column grid-item horizon" data-animate-in="preset:slideInUpShort;duration:1000ms;delay:800ms;" data-threshold="0.3">
										<div class="team-content-info bkg-white">
											<p class="title-m-medium"><span class="color-green">NVIDIA Inception</span>은 해당 산업에 혁명을 가져오는 뛰어난 역량의 AI 스타트 업을 양성합니다. 최고의 버추얼 엑셀러레이터로써 비즈니스가 성숙함의 단계를 이룰 때까지 go-to-market support, expertise, technology를 맞춤형으로 지원합니다. 현재 5천명이 넘는 멤버들과<br>함께, NVIDIA Inception은 선택되어진 민첩, 강력하며, 혁신적이고, 산업이 AI를 활용하여 핵심 문제에 접근하는 방식을 새롭게 정의할 수 있는 스타트업들을 배양합니다.<br><br>당신의 스타트업의 자금이나 AI 전문지식과 관계없이, NVNDIA Inception은 당신의 성장을 지원할 것입니다. 멤버로서 당신이 받을 수 있는 혜택은 아래와 같습니다.</p>
										</div>
									</div>
								</div>
							</div>
						</div>

						<div class="column">
							<div class="row content-grid-3">
								<div class="column grid-item horizon" data-animate-in="preset:slideInUpShort;duration:1000ms;delay:1000ms;" data-threshold="0.3">
									<div class="team-content-info bkg-white min-height-360">
										<h4 class="occupation"><img src="images/dgx-station-icons-ol_dgx-station-workgroup-icon.svg" alt=""/></h4>
										<dl class="social-list list-horizontal">
											<dt class="color-green p-10 title-m-medium a-center">Go-to-market support</dt>
											<dd class="title-s-medium">조직에서는 DGX Station A100을 통해 기타 NVIDIA DGX™ 기반 인프라와 원활하게 통합되는 시스템을<br>사용하여 트레이닝, 추론, 데이터 분석 등 모든 워크로드를 처리할 중앙 집중화된 AI 리소스를 여러 사용자에게 제공할 수 있습니다. 그리고 MIG(Multi-Instance GPU)를 사용하면 개인 사용자에게 최대 28개의 별도 GPU를 할당하는 것이 가능합니다.</dd>
										</dl>
									</div>
								</div>
								<div class="column grid-item horizon" data-animate-in="preset:slideInUpShort;duration:1000ms;delay:1200ms;" data-threshold="0.3">
									<div class="team-content-info bkg-white min-height-360">
										<h4 class="occupation"><img src="images/dgx-station-icons-ol_dgx-station-data-center-icon.svg" alt=""/></h4>
										<dl class="social-list list-horizontal">
											<dt class="color-green p-10 title-m-medium a-center">데이터센터 없이도<br>이용 가능한 데이터센터 성능</dt>
											<dd class="title-s-medium">DGX Station A100은 데이터센터 성능이나 냉각이 필요 없는 서버급 AI 시스템입니다. 4개의 NVIDIA A100 Tensor 코어 GPU, 최첨단 서버급 CPU, 초고속 NVMe 스토리지, 첨단 PCIe Gen4 버스와 함께 원격 관리가<br>포함되어 있어 서버처럼 관리할 수 있습니다.</dd>
										</dl>
									</div>
								</div>
								<div class="column grid-item horizon" data-animate-in="preset:slideInUpShort;duration:1000ms;delay:1400ms;" data-threshold="0.3">
									<div class="team-content-info bkg-white min-height-360">
										<h4 class="occupation"><img src="images/dgx-station-icons-ol_dgx-station-ai-appliance-icon.svg" alt=""/></h4>
										<dl class="social-list list-horizontal">
											<dt class="color-green p-10 title-m-medium a-center">어디에든 배치할 수 있는<br>AI 어플라이언스</dt>
											<dd class="title-s-medium">기업 사무실, 실험실, 연구 시설, 심지어는 집에서도<br>근무하는 오늘날의 민첩한 데이터 사이언스 팀을 위해 고안된 DGX Station A100의 경우 복잡한 설치나 큰 IT 투자가 필요하지 않습니다. 표준 벽콘센트와 전원을<br>연결하기만 하면 몇 분 안에 어디서든 일을 시작할 수 있습니다.</dd>
										</dl>
									</div>
								</div>
							</div>
						</div>

					</div>
				</div>
				<!-- lease End -->
				<div id="cs" class="section-block replicable-content bkg-charcoal color-white p-120">
					<div class="row tmh-perspective">
						<div class="column width-6 horizon" data-animate-in="preset:slideInRightShort;duration:1000ms;delay:200ms;" data-threshold="0.5" style="backface-visibility: hidden; transition: -webkit-transform 1000ms cubic-bezier(0.11, 0.69, 0.66, 1.01) 200ms, opacity; transform: translate3d(0px, 0px, 0px) rotateX(0deg) rotateY(0deg) rotateZ(0deg) scale3d(1, 1, 1); opacity: 1; visibility: visible; transform-origin: 50% 50% 0px;">
							<div class="hero-content split-hero-content">
								<div class="hero-content-inner left horizon" data-animate-in="preset:slideInLeftShort;duration:1000ms;" data-threshold="0.5">
									<p class="lead color-white">당신의 성공적인 비즈니스를 위해<br>한국인프라가 함께 합니다.</p>
									<p class="text-medium color-white">
										(주)한국인프라<br>
										서지열 전무<br>
										Tel: 02-6204-5024<br>
										Email: <a href="mailto:jysuh@krinfra.co.kr">jysuh@krinfra.co.kr</a>
									</p>
								</div>
							</div>
						</div>



<%
Dim arrProDuctNivia(1)

arrProDuctNivia(0) = "NVIDIA"
arrProDuctNivia(1) = "A100"
%>


						<div class="column width-4 horizon" data-animate-in="preset:slideInRightShort;duration:1000ms;delay:400ms;easing:easeFastSlow;" data-threshold="0.5" style="backface-visibility: hidden; transition: -webkit-transform 1000ms cubic-bezier(0.11, 0.69, 0.66, 1.01) 400ms, opacity; transform: translate3d(0px, 0px, 0px) rotateX(0deg) rotateY(0deg) rotateZ(0deg) scale3d(1, 1, 1); opacity: 1; visibility: visible; transform-origin: 50% 50% 0px;">
							<div class="stats-1 left tmh-perspective">

								<FORM method="POST"  name="frmMain" >


									<input name="ProductMajorName" type="hidden" value="NVIDIA_A100">
									<input name="ProductMajorIdx" type="hidden" value="22">
									<input name="strPro1" type="hidden" value="<%=arrProDuctNivia(1)%>">

									<input type="hidden" name="ProductTypeName" value = "New"> 
									<input type="hidden" name="ncount" value = "1"> 
									<input type="hidden" name="quantity0" value = "1"> 
									<input type="hidden" name="product0" value = "A100"> 

									<div class="row">
										<div class="column width-10 offset-1">
											<div class="field-wrapper">
												<input type="text" name="uname" class="form-email form-element large" placeholder="담당자 *" tabindex="2" required="" >
											</div>
										</div>
										<div class="column width-10 offset-1">
											<div class="field-wrapper">
												<input type="text" name="company" class="form-email form-element large" placeholder="회사명 *" tabindex="2" required="" >
											</div>
										</div>
										<div class="column width-10 offset-1">
											<div class="field-wrapper">
												<input type="text" name="hp" class="form-email form-element large" placeholder="연락처 *" tabindex="2" required="" >
											</div>
										</div>
										<div class="column width-10 offset-1">
											<div class="field-wrapper">
												<input type="text" name="uemail" class="form-email form-element large" placeholder="이메일 *" tabindex="2" required="" >
											</div>
										</div>
										<div class="column width-6 offset-3 center">
											<a href="javascript:A100_send(document.frmMain);" class="form-submit button text-uppercase bkg-theme bkg-hover-charcoal color-white color-hover-white text-medium">보내기</a>					
										</div>
									</div>
									<input type="text" name="honeypot" class="form-honeypot form-element">
								</form>
								<div class="form-response"></div>
							</div>
						</div>
					</div>
				</div>
				<!-- Contact End -->

			</div>
			<!-- Content End -->

			<!-- Footer -->
			<footer class="footer">
				<div class="footer-top">
					<div class="row flex">
						<div class="column width-3">
							<div class="widget">
								<h4 class="widget-title"><img src="images/bot_logo_wh.png" alt=""/></h4>
							</div>
						</div>
						<div class="column width-9">
							<div class="widget">
								<p>06288) 서울특별시 강남구 삼성로 150(대치동,극동교회빌딩 3층)<br>Tel. 02-6204-5000 | Fax. 02-6204-5099</p>
							</div>
						</div>
					</div>
				</div>
				<div class="footer-bottom">
					<div class="row">
						<div class="column width-12">
							<p class="copyright">
								&copy; Copyrightⓒ Infra Information Technology Co.,Ltd. All rights reserved.
							</p>
						</div>
					</div>
				</div>
			</footer>
			<!-- Footer End -->

		</div>
	</div>

	<!-- Js -->
	<script Language='JavaScript' src='/js/comm.js'></script>
	<script Language='JavaScript' src='/js/estimate.js'></script>
	<script src="https://ajax.googleapis.com/ajax/libs/jquery/1.12.4/jquery.min.js"></script>
	<script src="http://maps.googleapis.com/maps/api/js?v=3"></script>
	<script src="js/timber.master.min.js"></script>
</body>
</html>
