# ASP.NET Core Photo Pavilion
ASP.NET Core application for the course IBT 2020 @Technical University of Sofia

[![Build Status](https://dev.azure.com/slavkata99/Photo%20Pavilion/_apis/build/status/stanislavstoyanov99.PhotoPavilion%20(3)?branchName=master)](https://dev.azure.com/slavkata99/Photo%20Pavilion/_build/latest?definitionId=4&branchName=master)
[![GitHub license](https://img.shields.io/github/license/stanislavstoyanov99/PhotoPavilion?color=brightgreen)](https://github.com/stanislavstoyanov99/PhotoPavilion/blob/master/LICENSE)

## :point_right: Project Introduction :point_left:

**PhotoPavilion** is my project for IBT course of Technical University of Sofia as individual assignment. It is a ready-to-use ASP.NET Core application.

## :pencil: Project Description - EN
The web application provides a modern graphical interface for use. The app combines a lot of functionality, which can be useful for users. In the header like many web applications there is a navigational panel with the following menus: “Products”, “Brands”, “Categories” – dropping menu, “Privacy”. Next to this panel there is a search bar which can find requested information from the user after full searching in the system. Each page has a footer where you can find references to other pages of the system – “FAQ”, “Contact us”, “Privacy Policy”, different product categories and links to social networks. The app gives opportunity for real product purchases with two ways of payment – in place and online. Moreover, there is a rating system, system for writing comments and reviews of products.

## :pencil: Project Description - BG
Уеб приложението предоставя модерен графичен интерфейс за работа. Приложението комбинира в себе си много функционалност, която може да бъде полезна за потребителите. В горната му част като повечето уеб приложения има удобен навигационен панел със следните менюта: “Products”, “Brands”, “Categories” – с падащо меню на категориите, “Privacy”. До този панел има търсачка, която може да намира заявена информация от потребителя като резултатите, които се връщат са след претърсване на цялата система. В дъното на всяка страница има footer или мястото, където може да намерите препратка към останалите страници от системата – “FAQ”, “Contact us”, “Privacy Policy”, различните категории продукти както и връзки към социалните мрежи. Приложението дава възможност за реално закупуване на продукти чрез два начина на плащане - на място в магазина и онлайн. Също така има изградена рейтинг система, система за писане на коментари и ревюта на продуктите.

## Unit tests Code coverage

![Code coverage](https://github.com/stanislavstoyanov99/PhotoPavilion/blob/master/tests-code-coverage.png)

## :hammer: Used technologies
- ASP.NET [CORE 8](https://dotnet.microsoft.com/en-us/download/dotnet/8.0) MVC
    * Current master branch version
- ASP.NET [CORE 3.1](https://dotnet.microsoft.com/download/dotnet-core/3.1 "CORE 3.1") MVC
    * Older version located in branch older-version-net3.1
- ASP.NET [CORE 6](https://dotnet.microsoft.com/en-us/download/dotnet/6.0) MVC
    * Older version located in branch migrate-to-net6
- ASP.NET Core areas
- Entity Framework [CORE 8](https://learn.microsoft.com/en-us/ef/core/what-is-new/ef-core-8.0/whatsnew "CORE 8")
    * Current master branch version
- Entity Framework [CORE 3.1](https://docs.microsoft.com/en-us/ef/core/ "CORE 3.1")
    * Older version located in branch older-version-net3.1
- Entity Framework [CORE 6](https://learn.microsoft.com/en-us/ef/core/what-is-new/ef-core-6.0/whatsnew "CORE 6")
    * Older version located in branch migrate-to-net6
- [Newtonsoft.Json](https://www.nuget.org/packages/Newtonsoft.Json/ "Newtonsoft.Json")
- SendGrid
- Cloudinary
- TinyMCE
- Bootstrap
- [Moment.js](https://www.nuget.org/packages/Moment.js/ "Moment.js")
- AJAX real-time Requests
- jQuery and any kind of jQuery plugins
- JavaScript and JS animations
- Facebook for developers
- [Stripe](https://stripe.com/en-bg)
- GoogleReCaptcha

## :floppy_disk: Database Diagram
![](https://res.cloudinary.com/photopavilion/image/upload/v1592300820/db_zufkpr.jpg)

# Link
https://photopavilion.azurewebsites.net/

## Author

[Stanislav Stoyanov](https://github.com/stanislavstoyanov99)
- Facebook: [@Станислав Стоянов](https://www.facebook.com/profile.php?id=100000714808058)
- LinkedIn: [@stanislavstoyanov99](https://www.linkedin.com/in/stanislavstoyanov99/)

## MVC Template authors

- [Nikolay Kostov](https://github.com/NikolayIT)
- [Vladislav Karamfilov](https://github.com/vladislav-karamfilov)

## :v: Show your opinion

Give a :star: if you like this project!

## License

This project is licensed under the MIT License - see the [LICENSE](LICENSE) file for details
