/*
 * Decompiled with CFR 0.152.
 */
package org.junit.contrib.theories.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.javaruntype.type.Type;
import org.javaruntype.type.Types;
import org.junit.contrib.theories.ParameterSignature;
import org.junit.contrib.theories.ParameterSupplier;
import org.junit.contrib.theories.ParametersSuppliedBy;
import org.junit.contrib.theories.PotentialAssignment;
import org.junit.contrib.theories.internal.AllMembersSupplier;
import org.junit.contrib.theories.internal.BooleanSupplier;
import org.junit.contrib.theories.internal.EnumSupplier;
import org.junit.runners.model.TestClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Assignments {
    private final List<PotentialAssignment> fAssigned;
    private final List<ParameterSignature> fUnassigned;
    private final TestClass fClass;

    private Assignments(List<PotentialAssignment> assigned, List<ParameterSignature> unassigned, TestClass testClass) {
        this.fUnassigned = unassigned;
        this.fAssigned = assigned;
        this.fClass = testClass;
    }

    public static Assignments allUnassigned(Method testMethod, TestClass testClass) throws Exception {
        List<ParameterSignature> signatures = ParameterSignature.signatures(testClass.getOnlyConstructor());
        signatures.addAll(ParameterSignature.signatures(testMethod));
        return new Assignments(new ArrayList<PotentialAssignment>(), signatures, testClass);
    }

    public boolean isComplete() {
        return this.fUnassigned.size() == 0;
    }

    public ParameterSignature nextUnassigned() {
        return this.fUnassigned.get(0);
    }

    public Assignments assignNext(PotentialAssignment source) {
        ArrayList<PotentialAssignment> assigned = new ArrayList<PotentialAssignment>(this.fAssigned);
        assigned.add(source);
        return new Assignments(assigned, this.fUnassigned.subList(1, this.fUnassigned.size()), this.fClass);
    }

    public Object[] getActualValues(int start, int stop) throws PotentialAssignment.CouldNotGenerateValueException {
        Object[] values = new Object[stop - start];
        for (int i = start; i < stop; ++i) {
            values[i - start] = this.fAssigned.get(i).getValue();
        }
        return values;
    }

    public List<PotentialAssignment> potentialsForNextUnassigned() throws Throwable {
        ParameterSignature unassigned = this.nextUnassigned();
        List<PotentialAssignment> assignments = this.getSupplier(unassigned).getValueSources(unassigned);
        if (assignments.size() == 0) {
            assignments = this.generateAssignmentsFromTypeAlone(unassigned);
        }
        return assignments;
    }

    private List<PotentialAssignment> generateAssignmentsFromTypeAlone(ParameterSignature unassigned) {
        Type paramType = Types.forJavaLangReflectType((java.lang.reflect.Type)unassigned.getType());
        Class klass = paramType.getRawClass();
        if (klass.isEnum()) {
            return new EnumSupplier(klass).getValueSources(unassigned);
        }
        if (Boolean.class.equals((Object)klass) || Boolean.TYPE.equals(klass)) {
            return new BooleanSupplier().getValueSources(unassigned);
        }
        return Collections.emptyList();
    }

    private ParameterSupplier getSupplier(ParameterSignature unassigned) throws Exception {
        ParametersSuppliedBy annotation = unassigned.findDeepAnnotation(ParametersSuppliedBy.class);
        return annotation != null ? this.buildParameterSupplierFromClass(annotation.value()) : new AllMembersSupplier(this.fClass);
    }

    private ParameterSupplier buildParameterSupplierFromClass(Class<? extends ParameterSupplier> supplierClass) throws Exception {
        for (Constructor<?> each : supplierClass.getConstructors()) {
            Class<?>[] parameterTypes = each.getParameterTypes();
            if (parameterTypes.length != 1 || !TestClass.class.equals(parameterTypes[0])) continue;
            return (ParameterSupplier)each.newInstance(this.fClass);
        }
        return supplierClass.newInstance();
    }

    public Object[] getConstructorArguments() throws PotentialAssignment.CouldNotGenerateValueException {
        return this.getActualValues(0, this.getConstructorParameterCount());
    }

    public Object[] getMethodArguments() throws PotentialAssignment.CouldNotGenerateValueException {
        return this.getActualValues(this.getConstructorParameterCount(), this.fAssigned.size());
    }

    private int getConstructorParameterCount() {
        List<ParameterSignature> signatures = ParameterSignature.signatures(this.fClass.getOnlyConstructor());
        return signatures.size();
    }

    public Object[] getArgumentStrings() throws PotentialAssignment.CouldNotGenerateValueException {
        Object[] strings = new Object[this.fAssigned.size()];
        for (int i = 0; i < strings.length; ++i) {
            strings[i] = this.fAssigned.get(i).getDescription();
        }
        return strings;
    }
}

