/*
 * Decompiled with CFR 0.152.
 */
package org.javacc.parser;

import java.io.File;
import java.io.IOException;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.javacc.parser.CodeGenerator;
import org.javacc.parser.Options;
import org.javacc.parser.TokenManagerCodeGenerator;
import org.javacc.parser.TokenizerData;

public class TableDrivenJavaCodeGenerator
implements TokenManagerCodeGenerator {
    private static final String TokenManagerTemplate = "/templates/TableDrivenTokenManager.template";
    private final CodeGenerator codeGenerator = new CodeGenerator();

    @Override
    public void generateCode(TokenizerData tokenizerData) {
        block2: {
            String superClass = (String)Options.getOptions().get("TOKEN_MANAGER_SUPER_CLASS");
            Map<String, Object> options = Options.getOptions();
            options.put("maxOrdinal", tokenizerData.allMatches.size());
            options.put("maxLexStates", tokenizerData.lexStateNames.length);
            options.put("stateSetSize", tokenizerData.nfa.size());
            options.put("parserName", tokenizerData.parserName);
            options.put("maxLongs", tokenizerData.allMatches.size() / 64 + 1);
            options.put("parserName", tokenizerData.parserName);
            options.put("charStreamName", CodeGenerator.getCharStreamName());
            options.put("defaultLexState", tokenizerData.defaultLexState);
            options.put("decls", tokenizerData.decls);
            options.put("superClass", superClass == null || superClass.equals("") ? "" : "extends " + superClass);
            options.put("noDfa", Options.getNoDfa());
            options.put("generatedStates", tokenizerData.nfa.size());
            try {
                this.codeGenerator.writeTemplate(TokenManagerTemplate, options, new Object[0]);
                this.dumpDfaTables(this.codeGenerator, tokenizerData);
                this.dumpNfaTables(this.codeGenerator, tokenizerData);
                this.dumpMatchInfo(this.codeGenerator, tokenizerData);
            }
            catch (IOException ioe) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }

    @Override
    public void finish(TokenizerData tokenizerData) {
        this.codeGenerator.genCodeLine("\n}");
        if (!Options.getBuildParser()) {
            return;
        }
        String fileName = Options.getOutputDirectory() + File.separator + tokenizerData.parserName + "TokenManager.java";
        this.codeGenerator.saveOutput(fileName);
    }

    private void dumpDfaTables(CodeGenerator codeGenerator, TokenizerData tokenizerData) {
        int[] arr;
        HashMap<Integer, int[]> startAndSize = new HashMap<Integer, int[]>();
        int i = 0;
        codeGenerator.genCodeLine("private static final int[] stringLiterals = {");
        for (int key : tokenizerData.literalSequence.keySet()) {
            arr = new int[2];
            List<String> l = tokenizerData.literalSequence.get(key);
            List<Integer> kinds = tokenizerData.literalKinds.get(key);
            arr[0] = i;
            arr[1] = l.size();
            int j = 0;
            if (i > 0) {
                codeGenerator.genCodeLine(", ");
            }
            for (String s : l) {
                if (j > 0) {
                    codeGenerator.genCodeLine(", ");
                }
                codeGenerator.genCode(s.length());
                for (int k = 0; k < s.length(); ++k) {
                    codeGenerator.genCode(", ");
                    codeGenerator.genCode(s.charAt(k));
                    ++i;
                }
                int kind = kinds.get(j);
                codeGenerator.genCode(", " + kind);
                codeGenerator.genCode(", " + tokenizerData.kindToNfaStartState.get(kind));
                i += 3;
                ++j;
            }
            startAndSize.put(key, arr);
        }
        codeGenerator.genCodeLine("};");
        codeGenerator.genCodeLine("private static final java.util.Map<Integer, int[]> startAndSize =\n    new java.util.HashMap<Integer, int[]>();");
        codeGenerator.genCodeLine("static {");
        for (int key : tokenizerData.literalSequence.keySet()) {
            arr = (int[])startAndSize.get(key);
            codeGenerator.genCodeLine("startAndSize.put(" + key + ", new int[]{" + arr[0] + ", " + arr[1] + "});");
        }
        codeGenerator.genCodeLine("}");
    }

    private void dumpNfaTables(CodeGenerator codeGenerator, TokenizerData tokenizerData) {
        Iterator<Comparable<Character>> iterator;
        Object tmp;
        int i;
        codeGenerator.genCodeLine("private static final long[][] jjCharData = {");
        Map<Integer, TokenizerData.NfaState> nfa = tokenizerData.nfa;
        for (i = 0; i < nfa.size(); ++i) {
            tmp = nfa.get(i);
            if (i > 0) {
                codeGenerator.genCodeLine(",");
            }
            if (tmp == null) {
                codeGenerator.genCode("{}");
                continue;
            }
            codeGenerator.genCode("{");
            BitSet bits = new BitSet();
            iterator = ((TokenizerData.NfaState)tmp).characters.iterator();
            while (iterator.hasNext()) {
                char c = iterator.next().charValue();
                bits.set(c);
            }
            long[] longs = bits.toLongArray();
            for (int k = 0; k < longs.length; ++k) {
                int rep = 1;
                while (k + rep < longs.length && longs[k + rep] == longs[k]) {
                    ++rep;
                }
                if (k > 0) {
                    codeGenerator.genCode(", ");
                }
                codeGenerator.genCode(rep + ", ");
                codeGenerator.genCode("0x" + Long.toHexString(longs[k]) + "L");
                k += rep - 1;
            }
            codeGenerator.genCode("}");
        }
        codeGenerator.genCodeLine("};");
        codeGenerator.genCodeLine("private static final long[][] jjChars = ");
        codeGenerator.genCodeLine("    new long[" + tokenizerData.nfa.size() + "][(Character.MAX_VALUE >> 6) + 1]; ");
        codeGenerator.genCodeLine("static { ");
        codeGenerator.genCodeLine("  for (int i = 0; i < " + tokenizerData.nfa.size() + "; i++) { ");
        codeGenerator.genCodeLine("    int ind = 0; ");
        codeGenerator.genCodeLine("    for (int j = 0; j < jjCharData[i].length; j += 2) { ");
        codeGenerator.genCodeLine("      for (int k = 0; k < (int)jjCharData[i][j]; k++) { ");
        codeGenerator.genCodeLine("        jjChars[i][ind++] = jjCharData[i][j + 1]; ");
        codeGenerator.genCodeLine("      } ");
        codeGenerator.genCodeLine("    } ");
        codeGenerator.genCodeLine("  } ");
        codeGenerator.genCodeLine("} ");
        codeGenerator.genCodeLine("private static final int[][] jjcompositeState = {");
        for (i = 0; i < nfa.size(); ++i) {
            tmp = nfa.get(i);
            if (i > 0) {
                codeGenerator.genCodeLine(", ");
            }
            if (tmp == null) {
                codeGenerator.genCode("{}");
                continue;
            }
            codeGenerator.genCode("{");
            int k = 0;
            iterator = ((TokenizerData.NfaState)tmp).compositeStates.iterator();
            while (iterator.hasNext()) {
                int st = (Integer)iterator.next();
                if (k++ > 0) {
                    codeGenerator.genCode(", ");
                }
                codeGenerator.genCode(st);
            }
            codeGenerator.genCode("}");
        }
        codeGenerator.genCodeLine("};");
        codeGenerator.genCodeLine("private static final int[] jjmatchKinds = {");
        for (i = 0; i < nfa.size(); ++i) {
            tmp = nfa.get(i);
            if (i > 0) {
                codeGenerator.genCodeLine(", ");
            }
            if (tmp == null) {
                codeGenerator.genCode(Integer.MAX_VALUE);
                continue;
            }
            codeGenerator.genCode(((TokenizerData.NfaState)tmp).kind);
        }
        codeGenerator.genCodeLine("};");
        codeGenerator.genCodeLine("private static final int[][]  jjnextStateSet = {");
        for (i = 0; i < nfa.size(); ++i) {
            tmp = nfa.get(i);
            if (i > 0) {
                codeGenerator.genCodeLine(", ");
            }
            if (tmp == null) {
                codeGenerator.genCode("{}");
                continue;
            }
            int k = 0;
            codeGenerator.genCode("{");
            iterator = ((TokenizerData.NfaState)tmp).nextStates.iterator();
            while (iterator.hasNext()) {
                int s = (Integer)iterator.next();
                if (k++ > 0) {
                    codeGenerator.genCode(", ");
                }
                codeGenerator.genCode(s);
            }
            codeGenerator.genCode("}");
        }
        codeGenerator.genCodeLine("};");
        codeGenerator.genCodeLine("private static final int[] jjInitStates  = {");
        int k = 0;
        tmp = tokenizerData.initialStates.keySet().iterator();
        while (tmp.hasNext()) {
            int i2 = (Integer)tmp.next();
            if (k++ > 0) {
                codeGenerator.genCode(", ");
            }
            codeGenerator.genCode(tokenizerData.initialStates.get(i2));
        }
        codeGenerator.genCodeLine("};");
        codeGenerator.genCodeLine("private static final int[] canMatchAnyChar = {");
        k = 0;
        for (int i3 = 0; i3 < tokenizerData.wildcardKind.size(); ++i3) {
            if (k++ > 0) {
                codeGenerator.genCode(", ");
            }
            codeGenerator.genCode(tokenizerData.wildcardKind.get(i3));
        }
        codeGenerator.genCodeLine("};");
    }

    private void dumpMatchInfo(CodeGenerator codeGenerator, TokenizerData tokenizerData) {
        Map<Integer, TokenizerData.MatchInfo> allMatches = tokenizerData.allMatches;
        BitSet toSkip = new BitSet(allMatches.size());
        BitSet toSpecial = new BitSet(allMatches.size());
        BitSet toMore = new BitSet(allMatches.size());
        BitSet toToken = new BitSet(allMatches.size());
        int[] newStates = new int[allMatches.size()];
        toSkip.set(allMatches.size() + 1, true);
        toToken.set(allMatches.size() + 1, true);
        toMore.set(allMatches.size() + 1, true);
        toSpecial.set(allMatches.size() + 1, true);
        codeGenerator.genCodeLine("public static final String[] jjstrLiteralImages = {");
        int k = 0;
        for (int i : allMatches.keySet()) {
            TokenizerData.MatchInfo matchInfo = allMatches.get(i);
            switch (matchInfo.matchType) {
                case SKIP: {
                    toSkip.set(i);
                    break;
                }
                case SPECIAL_TOKEN: {
                    toSpecial.set(i);
                    break;
                }
                case MORE: {
                    toMore.set(i);
                    break;
                }
                case TOKEN: {
                    toToken.set(i);
                }
            }
            newStates[i] = matchInfo.newLexState;
            String image = matchInfo.image;
            if (k++ > 0) {
                codeGenerator.genCodeLine(", ");
            }
            if (image != null) {
                codeGenerator.genCode("\"");
                for (int j = 0; j < image.length(); ++j) {
                    if (image.charAt(j) <= '\u00ff') {
                        codeGenerator.genCode("\\" + Integer.toOctalString(image.charAt(j)));
                        continue;
                    }
                    String hexVal = Integer.toHexString(image.charAt(j));
                    if (hexVal.length() == 3) {
                        hexVal = "0" + hexVal;
                    }
                    codeGenerator.genCode("\\u" + hexVal);
                }
                codeGenerator.genCode("\"");
                continue;
            }
            codeGenerator.genCodeLine("null");
        }
        codeGenerator.genCodeLine("};");
        TableDrivenJavaCodeGenerator.generateBitVector("jjtoSkip", toSkip, codeGenerator);
        TableDrivenJavaCodeGenerator.generateBitVector("jjtoSpecial", toSpecial, codeGenerator);
        TableDrivenJavaCodeGenerator.generateBitVector("jjtoMore", toMore, codeGenerator);
        TableDrivenJavaCodeGenerator.generateBitVector("jjtoToken", toToken, codeGenerator);
        codeGenerator.genCodeLine("private static final int[] jjnewLexState = {");
        for (int i = 0; i < newStates.length; ++i) {
            if (i > 0) {
                codeGenerator.genCode(", ");
            }
            codeGenerator.genCode("0x" + Integer.toHexString(newStates[i]));
        }
        codeGenerator.genCodeLine("};");
        String staticString = Options.getStatic() ? "static " : "";
        codeGenerator.genCodeLine(staticString + "void TokenLexicalActions(Token matchedToken) {");
        this.dumpLexicalActions(allMatches, TokenizerData.MatchType.TOKEN, "matchedToken.kind", codeGenerator);
        codeGenerator.genCodeLine("}");
        codeGenerator.genCodeLine(staticString + "void SkipLexicalActions(Token matchedToken) {");
        this.dumpLexicalActions(allMatches, TokenizerData.MatchType.SKIP, "jjmatchedKind", codeGenerator);
        this.dumpLexicalActions(allMatches, TokenizerData.MatchType.SPECIAL_TOKEN, "jjmatchedKind", codeGenerator);
        codeGenerator.genCodeLine("}");
        codeGenerator.genCodeLine(staticString + "void MoreLexicalActions() {");
        codeGenerator.genCodeLine("jjimageLen += (lengthOfMatch = jjmatchedPos + 1);");
        this.dumpLexicalActions(allMatches, TokenizerData.MatchType.MORE, "jjmatchedKind", codeGenerator);
        codeGenerator.genCodeLine("}");
        codeGenerator.genCodeLine("public String[] lexStateNames = {");
        for (int i = 0; i < tokenizerData.lexStateNames.length; ++i) {
            if (i > 0) {
                codeGenerator.genCode(", ");
            }
            codeGenerator.genCode("\"" + tokenizerData.lexStateNames[i] + "\"");
        }
        codeGenerator.genCodeLine("};");
    }

    private void dumpLexicalActions(Map<Integer, TokenizerData.MatchInfo> allMatches, TokenizerData.MatchType matchType, String kindString, CodeGenerator codeGenerator) {
        codeGenerator.genCodeLine("  switch(" + kindString + ") {");
        for (int i : allMatches.keySet()) {
            TokenizerData.MatchInfo matchInfo = allMatches.get(i);
            if (matchInfo.action == null || matchInfo.matchType != matchType) continue;
            codeGenerator.genCodeLine("    case " + i + ": {\n");
            codeGenerator.genCodeLine("      " + matchInfo.action);
            codeGenerator.genCodeLine("      break;");
            codeGenerator.genCodeLine("    }");
        }
        codeGenerator.genCodeLine("    default: break;");
        codeGenerator.genCodeLine("  }");
    }

    private static void generateBitVector(String name, BitSet bits, CodeGenerator codeGenerator) {
        codeGenerator.genCodeLine("private static final long[] " + name + " = {");
        long[] longs = bits.toLongArray();
        for (int i = 0; i < longs.length; ++i) {
            if (i > 0) {
                codeGenerator.genCode(", ");
            }
            codeGenerator.genCode("0x" + Long.toHexString(longs[i]) + "L");
        }
        codeGenerator.genCodeLine("};");
    }
}

