﻿using System.Linq;

using Microsoft.VisualStudio.TestTools.UnitTesting;

using Renci.SshNet.Messages.Transport;
using Renci.SshNet.Tests.Common;

namespace Renci.SshNet.Tests.Classes.Messages.Transport
{
    /// <summary>
    /// Represents SSH_MSG_KEX_DH_GEX_REPLY message.
    /// </summary>
    [TestClass]
    public class KeyExchangeDhGroupExchangeReplyTest : TestBase
    {
        [TestMethod]
        [TestCategory("KeyExchangeInitMessage")]
        [Owner("olegkap")]
        [Description("Validates KeyExchangeInitMessage message serialization.")]
        public void Test_KeyExchangeDhGroupExchangeReply_Load()
        {
            var m = new KeyExchangeDhGroupExchangeReply();
            var input = new byte[] { 0x00, 0x00, 0x01, 0x17, 0x00, 0x00, 0x00, 0x07, 0x73, 0x73, 0x68, 0x2d, 0x72, 0x73, 0x61, 0x00, 0x00, 0x00, 0x03, 0x01, 0x00, 0x01, 0x00, 0x00, 0x01, 0x01, 0x00, 0xce, 0x38, 0xdf, 0x0d, 0x04, 0x2c, 0x10, 0x45, 0x8f, 0x5e, 0xeb, 0xc2, 0x35, 0x01, 0xd5, 0x4d, 0x09, 0xa3, 0xee, 0x74, 0x3d, 0x75, 0xcf, 0xf4, 0xf3, 0x4f, 0xc9, 0xf9, 0x2e, 0x59, 0xd6, 0xb8, 0x69, 0x85, 0x16, 0xac, 0x33, 0x5b, 0x2a, 0x2a, 0xf8, 0x9c, 0xc4, 0xc3, 0x87, 0xd6, 0xb8, 0x50, 0x6c, 0xed, 0x60, 0x9c, 0x0f, 0x83, 0x37, 0xb3, 0xa2, 0x25, 0xbe, 0x07, 0xde, 0xb6, 0x1f, 0x28, 0xab, 0x05, 0x21, 0xc0, 0x23, 0xf7, 0xd6, 0xca, 0xcb, 0x03, 0x42, 0x69, 0x31, 0x93, 0x2b, 0x3b, 0x94, 0xb8, 0x3b, 0x90, 0xe6, 0x25, 0x7c, 0x23, 0xc5, 0x24, 0x89, 0x65, 0x37, 0x7b, 0x56, 0x54, 0xa2, 0x23, 0xcb, 0xeb, 0xf0, 0xe9, 0xd1, 0x07, 0x88, 0x36, 0x8f, 0xef, 0x65, 0x71, 0xac, 0x80, 0x5c, 0x81, 0x0a, 0x95, 0x1c, 0xf5, 0xc0, 0x5d, 0xd3, 0xd4, 0x10, 0x0e, 0x4f, 0xcf, 0x87, 0x80, 0xa5, 0xde, 0x6e, 0xff, 0x89, 0x9c, 0xfc, 0x2f, 0x85, 0xf5, 0x93, 0xff, 0x70, 0x8e, 0x48, 0xb6, 0x6e, 0x6e, 0x0a, 0x18, 0xa3, 0xbb, 0x1c, 0x56, 0x60, 0xf1, 0x9d, 0x2a, 0xca, 0xbf, 0xa0, 0x84, 0x73, 0xb1, 0x6d, 0x10, 0x75, 0xcc, 0xa3, 0x20, 0xed, 0x00, 0x52, 0xd0, 0x84, 0x5a, 0xc9, 0xbb, 0x17, 0x84, 0x96, 0x40, 0x48, 0xe2, 0x8e, 0x84, 0x30, 0x82, 0x3b, 0x87, 0xa4, 0x54, 0x55, 0x8c, 0xb5, 0x62, 0x97, 0xd7, 0xf1, 0xa3, 0x8b, 0x44, 0xaa, 0x34, 0xfd, 0xe9, 0xad, 0xda, 0xeb, 0x45, 0x27, 0xfb, 0xad, 0xea, 0x9a, 0x0c, 0x38, 0x30, 0x27, 0x6a, 0x82, 0xc2, 0xc2, 0x0a, 0xa0, 0xed, 0x30, 0x2f, 0x50, 0x9f, 0xdb, 0x1a, 0xfb, 0x29, 0x1c, 0x8a, 0x28, 0x3f, 0xd6, 0xf6, 0xa9, 0xeb, 0x76, 0x60, 0xa2, 0x56, 0xa2, 0x90, 0x32, 0xcd, 0x25, 0x41, 0xb7, 0xc0, 0x9e, 0x13, 0x97, 0xaf, 0x00, 0x00, 0x00, 0x81, 0x00, 0xc6, 0x58, 0xb9, 0xa8, 0x11, 0xfd, 0xb6, 0xd6, 0xe9, 0x0c, 0x51, 0x45, 0xac, 0x51, 0x8a, 0x25, 0x6e, 0x1d, 0x9e, 0xbb, 0x7f, 0x98, 0xe3, 0x94, 0xd5, 0xac, 0x97, 0xd6, 0x35, 0x2e, 0xcc, 0x34, 0x85, 0xe2, 0x29, 0x2c, 0xba, 0x45, 0x6b, 0x39, 0xce, 0xd2, 0xae, 0x2e, 0x9a, 0x30, 0x43, 0x45, 0x09, 0xd2, 0xeb, 0x21, 0x46, 0x95, 0xa8, 0xb9, 0xbc, 0xb4, 0x21, 0xcd, 0x65, 0xeb, 0x0f, 0x48, 0x3c, 0x82, 0xdb, 0x52, 0x0e, 0xa5, 0xa8, 0xca, 0x29, 0x2d, 0xf8, 0x54, 0x38, 0xe4, 0x8f, 0x2c, 0x2d, 0x45, 0x2d, 0x2c, 0xf7, 0x1a, 0x41, 0xef, 0xd4, 0xec, 0x0f, 0xa5, 0xa8, 0xa7, 0x64, 0xb3, 0xe8, 0x7b, 0xa1, 0x40, 0x41, 0x69, 0x70, 0x4d, 0x95, 0x91, 0x8b, 0x5f, 0x28, 0xa2, 0xfc, 0xa7, 0x12, 0x2b, 0x94, 0xf0, 0x0a, 0x82, 0x92, 0x65, 0xdf, 0x8a, 0x35, 0xfb, 0xcc, 0xbe, 0xbd, 0x2d, 0x00, 0x00, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x07, 0x73, 0x73, 0x68, 0x2d, 0x72, 0x73, 0x61, 0x00, 0x00, 0x01, 0x00, 0x0d, 0x67, 0x83, 0xa1, 0xb8, 0x0c, 0x65, 0xb8, 0xd3, 0x76, 0x5f, 0x5f, 0x05, 0x51, 0x8c, 0xb3, 0x2d, 0x1e, 0x95, 0x67, 0xd6, 0xe2, 0xe4, 0x86, 0x49, 0x11, 0xca, 0x83, 0xab, 0xdb, 0x80, 0x75, 0x4e, 0x89, 0xa7, 0x3d, 0xb6, 0xc2, 0x92, 0xbb, 0x40, 0x00, 0xb9, 0xb3, 0x03, 0x86, 0x19, 0x9d, 0x67, 0x29, 0x2b, 0x5a, 0xc9, 0x0a, 0x6c, 0xa3, 0x21, 0xaf, 0xd8, 0xd4, 0xa7, 0x84, 0x6a, 0xe5, 0x36, 0x3e, 0xa5, 0x58, 0xd6, 0x36, 0x33, 0x12, 0x2e, 0xf9, 0x22, 0x10, 0xff, 0xae, 0x0e, 0xee, 0xfa, 0xdf, 0x1f, 0xf8, 0x70, 0xfe, 0xc0, 0x30, 0x1d, 0x23, 0xbf, 0x99, 0x20, 0x22, 0x18, 0x78, 0xab, 0x5f, 0xd5, 0xfa, 0x5f, 0xf1, 0x18, 0xc2, 0x20, 0xc5, 0x58, 0x90, 0x63, 0x4b, 0x12, 0xf3, 0xa4, 0xe9, 0x20, 0x03, 0x8f, 0x5a, 0x2d, 0x17, 0xbd, 0x75, 0x0a, 0xaf, 0x6d, 0xc5, 0x15, 0x8a, 0x14, 0x74, 0x7f, 0xa0, 0xd2, 0x0f, 0x6f, 0x96, 0xa5, 0x60, 0xb1, 0xb7, 0x65, 0x0f, 0x48, 0x67, 0x5d, 0x32, 0x0a, 0xcb, 0x8e, 0xdf, 0x0c, 0xa9, 0xd5, 0x14, 0x0b, 0x6d, 0xfb, 0x8b, 0xef, 0xa3, 0x79, 0xaf, 0xdb, 0xa3, 0xb4, 0x6d, 0xbb, 0x40, 0x9e, 0xb3, 0x45, 0x04, 0x7f, 0xd1, 0x84, 0xad, 0x90, 0x8b, 0x2d, 0xb6, 0x13, 0xfb, 0x7a, 0xf5, 0xad, 0xbf, 0xa6, 0x74, 0x75, 0xfa, 0x70, 0x59, 0xae, 0x22, 0xbb, 0xfb, 0x09, 0x68, 0xae, 0xe5, 0x26, 0x5c, 0xbd, 0xe0, 0xae, 0x39, 0xbb, 0xaa, 0x59, 0x4c, 0x73, 0x11, 0x01, 0x64, 0x6d, 0xc1, 0x95, 0x1b, 0x93, 0x6b, 0x14, 0x83, 0x4a, 0xdc, 0x16, 0x67, 0x7b, 0x85, 0xd0, 0x89, 0x2e, 0x3c, 0xa1, 0x05, 0x34, 0xf0, 0xd2, 0xb9, 0x3b, 0x83, 0xf4, 0x02, 0xd4, 0x7f, 0x73, 0x76, 0x5d, 0xc2, 0x67, 0xb9, 0xac, 0x8a, 0xd1, 0xab, 0xd4, 0x82 };
            m.Load(input);

            Assert.IsTrue(m.HostKey.SequenceEqual(new byte[] { 0x00, 0x00, 0x00, 0x07, 0x73, 0x73, 0x68, 0x2d, 0x72, 0x73, 0x61, 0x00, 0x00, 0x00, 0x03, 0x01, 0x00, 0x01, 0x00, 0x00, 0x01, 0x01, 0x00, 0xce, 0x38, 0xdf, 0x0d, 0x04, 0x2c, 0x10, 0x45, 0x8f, 0x5e, 0xeb, 0xc2, 0x35, 0x01, 0xd5, 0x4d, 0x09, 0xa3, 0xee, 0x74, 0x3d, 0x75, 0xcf, 0xf4, 0xf3, 0x4f, 0xc9, 0xf9, 0x2e, 0x59, 0xd6, 0xb8, 0x69, 0x85, 0x16, 0xac, 0x33, 0x5b, 0x2a, 0x2a, 0xf8, 0x9c, 0xc4, 0xc3, 0x87, 0xd6, 0xb8, 0x50, 0x6c, 0xed, 0x60, 0x9c, 0x0f, 0x83, 0x37, 0xb3, 0xa2, 0x25, 0xbe, 0x07, 0xde, 0xb6, 0x1f, 0x28, 0xab, 0x05, 0x21, 0xc0, 0x23, 0xf7, 0xd6, 0xca, 0xcb, 0x03, 0x42, 0x69, 0x31, 0x93, 0x2b, 0x3b, 0x94, 0xb8, 0x3b, 0x90, 0xe6, 0x25, 0x7c, 0x23, 0xc5, 0x24, 0x89, 0x65, 0x37, 0x7b, 0x56, 0x54, 0xa2, 0x23, 0xcb, 0xeb, 0xf0, 0xe9, 0xd1, 0x07, 0x88, 0x36, 0x8f, 0xef, 0x65, 0x71, 0xac, 0x80, 0x5c, 0x81, 0x0a, 0x95, 0x1c, 0xf5, 0xc0, 0x5d, 0xd3, 0xd4, 0x10, 0x0e, 0x4f, 0xcf, 0x87, 0x80, 0xa5, 0xde, 0x6e, 0xff, 0x89, 0x9c, 0xfc, 0x2f, 0x85, 0xf5, 0x93, 0xff, 0x70, 0x8e, 0x48, 0xb6, 0x6e, 0x6e, 0x0a, 0x18, 0xa3, 0xbb, 0x1c, 0x56, 0x60, 0xf1, 0x9d, 0x2a, 0xca, 0xbf, 0xa0, 0x84, 0x73, 0xb1, 0x6d, 0x10, 0x75, 0xcc, 0xa3, 0x20, 0xed, 0x00, 0x52, 0xd0, 0x84, 0x5a, 0xc9, 0xbb, 0x17, 0x84, 0x96, 0x40, 0x48, 0xe2, 0x8e, 0x84, 0x30, 0x82, 0x3b, 0x87, 0xa4, 0x54, 0x55, 0x8c, 0xb5, 0x62, 0x97, 0xd7, 0xf1, 0xa3, 0x8b, 0x44, 0xaa, 0x34, 0xfd, 0xe9, 0xad, 0xda, 0xeb, 0x45, 0x27, 0xfb, 0xad, 0xea, 0x9a, 0x0c, 0x38, 0x30, 0x27, 0x6a, 0x82, 0xc2, 0xc2, 0x0a, 0xa0, 0xed, 0x30, 0x2f, 0x50, 0x9f, 0xdb, 0x1a, 0xfb, 0x29, 0x1c, 0x8a, 0x28, 0x3f, 0xd6, 0xf6, 0xa9, 0xeb, 0x76, 0x60, 0xa2, 0x56, 0xa2, 0x90, 0x32, 0xcd, 0x25, 0x41, 0xb7, 0xc0, 0x9e, 0x13, 0x97, 0xaf }));
            Assert.IsTrue(m.Signature.SequenceEqual(new byte[] { 0x00, 0x00, 0x00, 0x07, 0x73, 0x73, 0x68, 0x2d, 0x72, 0x73, 0x61, 0x00, 0x00, 0x01, 0x00, 0x0d, 0x67, 0x83, 0xa1, 0xb8, 0x0c, 0x65, 0xb8, 0xd3, 0x76, 0x5f, 0x5f, 0x05, 0x51, 0x8c, 0xb3, 0x2d, 0x1e, 0x95, 0x67, 0xd6, 0xe2, 0xe4, 0x86, 0x49, 0x11, 0xca, 0x83, 0xab, 0xdb, 0x80, 0x75, 0x4e, 0x89, 0xa7, 0x3d, 0xb6, 0xc2, 0x92, 0xbb, 0x40, 0x00, 0xb9, 0xb3, 0x03, 0x86, 0x19, 0x9d, 0x67, 0x29, 0x2b, 0x5a, 0xc9, 0x0a, 0x6c, 0xa3, 0x21, 0xaf, 0xd8, 0xd4, 0xa7, 0x84, 0x6a, 0xe5, 0x36, 0x3e, 0xa5, 0x58, 0xd6, 0x36, 0x33, 0x12, 0x2e, 0xf9, 0x22, 0x10, 0xff, 0xae, 0x0e, 0xee, 0xfa, 0xdf, 0x1f, 0xf8, 0x70, 0xfe, 0xc0, 0x30, 0x1d, 0x23, 0xbf, 0x99, 0x20, 0x22, 0x18, 0x78, 0xab, 0x5f, 0xd5, 0xfa, 0x5f, 0xf1, 0x18, 0xc2, 0x20, 0xc5, 0x58, 0x90, 0x63, 0x4b, 0x12, 0xf3, 0xa4, 0xe9, 0x20, 0x03, 0x8f, 0x5a, 0x2d, 0x17, 0xbd, 0x75, 0x0a, 0xaf, 0x6d, 0xc5, 0x15, 0x8a, 0x14, 0x74, 0x7f, 0xa0, 0xd2, 0x0f, 0x6f, 0x96, 0xa5, 0x60, 0xb1, 0xb7, 0x65, 0x0f, 0x48, 0x67, 0x5d, 0x32, 0x0a, 0xcb, 0x8e, 0xdf, 0x0c, 0xa9, 0xd5, 0x14, 0x0b, 0x6d, 0xfb, 0x8b, 0xef, 0xa3, 0x79, 0xaf, 0xdb, 0xa3, 0xb4, 0x6d, 0xbb, 0x40, 0x9e, 0xb3, 0x45, 0x04, 0x7f, 0xd1, 0x84, 0xad, 0x90, 0x8b, 0x2d, 0xb6, 0x13, 0xfb, 0x7a, 0xf5, 0xad, 0xbf, 0xa6, 0x74, 0x75, 0xfa, 0x70, 0x59, 0xae, 0x22, 0xbb, 0xfb, 0x09, 0x68, 0xae, 0xe5, 0x26, 0x5c, 0xbd, 0xe0, 0xae, 0x39, 0xbb, 0xaa, 0x59, 0x4c, 0x73, 0x11, 0x01, 0x64, 0x6d, 0xc1, 0x95, 0x1b, 0x93, 0x6b, 0x14, 0x83, 0x4a, 0xdc, 0x16, 0x67, 0x7b, 0x85, 0xd0, 0x89, 0x2e, 0x3c, 0xa1, 0x05, 0x34, 0xf0, 0xd2, 0xb9, 0x3b, 0x83, 0xf4, 0x02, 0xd4, 0x7f, 0x73, 0x76, 0x5d, 0xc2, 0x67, 0xb9, 0xac, 0x8a, 0xd1, 0xab, 0xd4, 0x82 }));
            Assert.IsTrue(m.F.SequenceEqual(new byte[] { 0x00, 0xc6, 0x58, 0xb9, 0xa8, 0x11, 0xfd, 0xb6, 0xd6, 0xe9, 0x0c, 0x51, 0x45, 0xac, 0x51, 0x8a, 0x25, 0x6e, 0x1d, 0x9e, 0xbb, 0x7f, 0x98, 0xe3, 0x94, 0xd5, 0xac, 0x97, 0xd6, 0x35, 0x2e, 0xcc, 0x34, 0x85, 0xe2, 0x29, 0x2c, 0xba, 0x45, 0x6b, 0x39, 0xce, 0xd2, 0xae, 0x2e, 0x9a, 0x30, 0x43, 0x45, 0x09, 0xd2, 0xeb, 0x21, 0x46, 0x95, 0xa8, 0xb9, 0xbc, 0xb4, 0x21, 0xcd, 0x65, 0xeb, 0x0f, 0x48, 0x3c, 0x82, 0xdb, 0x52, 0x0e, 0xa5, 0xa8, 0xca, 0x29, 0x2d, 0xf8, 0x54, 0x38, 0xe4, 0x8f, 0x2c, 0x2d, 0x45, 0x2d, 0x2c, 0xf7, 0x1a, 0x41, 0xef, 0xd4, 0xec, 0x0f, 0xa5, 0xa8, 0xa7, 0x64, 0xb3, 0xe8, 0x7b, 0xa1, 0x40, 0x41, 0x69, 0x70, 0x4d, 0x95, 0x91, 0x8b, 0x5f, 0x28, 0xa2, 0xfc, 0xa7, 0x12, 0x2b, 0x94, 0xf0, 0x0a, 0x82, 0x92, 0x65, 0xdf, 0x8a, 0x35, 0xfb, 0xcc, 0xbe, 0xbd, 0x2d }));
        }
    }
}
