﻿using System.Linq;

using Microsoft.VisualStudio.TestTools.UnitTesting;

using Renci.SshNet.Common;
using Renci.SshNet.Security;
using Renci.SshNet.Tests.Common;

namespace Renci.SshNet.Tests.Classes.Common
{
    /// <summary>
    ///This is a test class for HostKeyEventArgsTest and is intended
    ///to contain all HostKeyEventArgsTest Unit Tests
    ///</summary>
    [TestClass]
    public class HostKeyEventArgsTest : TestBase
    {
        /// <summary>
        ///A test for HostKeyEventArgs Constructor
        ///</summary>
        [TestMethod]
        public void HostKeyEventArgsConstructorTest()
        {
            HostKeyEventArgs target = new HostKeyEventArgs(GetKeyHostAlgorithm());
            Assert.IsTrue(target.CanTrust);
            Assert.IsTrue(new byte[] {
                0x00, 0x00, 0x00, 0x07, 0x73, 0x73, 0x68, 0x2d, 0x72, 0x73, 0x61, 0x00, 0x00, 0x00, 0x01, 0x23,
                0x00, 0x00, 0x01, 0x01, 0x00, 0xb9, 0x3b, 0x57, 0x9f, 0xe0, 0x5a, 0xb5, 0x7d, 0x68, 0x26, 0xeb,
                0xe1, 0xa9, 0xf2, 0x59, 0xc3, 0x98, 0xdc, 0xfe, 0x97, 0x08, 0xc4, 0x95, 0x0f, 0x9a, 0xea, 0x05,
                0x08, 0x7d, 0xfe, 0x6d, 0x77, 0xca, 0x04, 0x9f, 0xfd, 0xe2, 0x2c, 0x4d, 0x11, 0x3c, 0xd9, 0x05,
                0xab, 0x32, 0xbd, 0x3f, 0xe8, 0xcd, 0xba, 0x00, 0x6c, 0x21, 0xb7, 0xa9, 0xc2, 0x4e, 0x63, 0x17,
                0xf6, 0x04, 0x47, 0x93, 0x00, 0x85, 0xde, 0xd6, 0x32, 0xc0, 0xa1, 0x37, 0x75, 0x18, 0xa0, 0xb0,
                0x32, 0xf6, 0x4e, 0xca, 0x39, 0xec, 0x3c, 0xdf, 0x79, 0xfe, 0x50, 0xa1, 0xc1, 0xf7, 0x67, 0x05,
                0xb3, 0x33, 0xa5, 0x96, 0x13, 0x19, 0xfa, 0x14, 0xca, 0x55, 0xe6, 0x7b, 0xf9, 0xb3, 0x8e, 0x32,
                0xee, 0xfc, 0x9d, 0x2a, 0x5e, 0x04, 0x79, 0x97, 0x29, 0x3d, 0x1c, 0x54, 0xfe, 0xc7, 0x96, 0x04,
                0xb5, 0x19, 0x7c, 0x55, 0x21, 0xe2, 0x0e, 0x42, 0xca, 0x4d, 0x9d, 0xfb, 0x77, 0x08, 0x6c, 0xaa,
                0x07, 0x2c, 0xf8, 0xf9, 0x1f, 0xbd, 0x83, 0x14, 0x2b, 0xe0, 0xbc, 0x7a, 0xf9, 0xdf, 0x13, 0x4b,
                0x60, 0x5a, 0x02, 0x99, 0x93, 0x41, 0x1a, 0xb6, 0x5f, 0x3b, 0x9c, 0xb5, 0xb2, 0x55, 0x70, 0x78,
                0x2f, 0x38, 0x52, 0x0e, 0xd1, 0x8a, 0x2c, 0x23, 0xc0, 0x3a, 0x0a, 0xd7, 0xed, 0xf6, 0x1f, 0xa6,
                0x50, 0xf0, 0x27, 0x65, 0x8a, 0xd4, 0xde, 0xa7, 0x1b, 0x41, 0x67, 0xc5, 0x6d, 0x47, 0x84, 0x37,
                0x92, 0x2b, 0xb7, 0xb6, 0x4d, 0xb0, 0x1a, 0xda, 0xf6, 0x50, 0x82, 0xf1, 0x57, 0x31, 0x69, 0xce,
                0xe0, 0xef, 0xcd, 0x64, 0xaa, 0x78, 0x08, 0xea, 0x4e, 0x45, 0xec, 0xa5, 0x89, 0x68, 0x5d, 0xb4,
                0xa0, 0x23, 0xaf, 0xff, 0x9c, 0x0f, 0x8c, 0x83, 0x7c, 0xf8, 0xe1, 0x8e, 0x32, 0x8e, 0x61, 0xfc,
                0x5b, 0xbd, 0xd4, 0x46, 0xe1
            }.SequenceEqual(target.HostKey));
            Assert.AreEqual("rsa-sha2-512", target.HostKeyName);
            Assert.AreEqual(2048, target.KeyLength);
        }

        /// <summary>
        ///A test for MD5 calculation in HostKeyEventArgs Constructor
        ///</summary>
        [TestMethod]
        public void HostKeyEventArgsConstructorTest_VerifyMD5()
        {
            HostKeyEventArgs target = new HostKeyEventArgs(GetKeyHostAlgorithm());
            Assert.IsTrue(new byte[] {
                0x92, 0xea, 0x54, 0xa1, 0x01, 0xf9, 0x95, 0x9c, 0x71, 0xd9, 0xbb, 0x51, 0xb2, 0x55, 0xf8, 0xd9
            }.SequenceEqual(target.FingerPrint));
            Assert.AreEqual("92:ea:54:a1:01:f9:95:9c:71:d9:bb:51:b2:55:f8:d9", target.FingerPrintMD5);

        }

        /// <summary>
        ///A test for SHA256 calculation in HostKeyEventArgs Constructor
        ///</summary>
        [TestMethod]
        public void HostKeyEventArgsConstructorTest_VerifySHA256()
        {
            HostKeyEventArgs target = new HostKeyEventArgs(GetKeyHostAlgorithm());
            Assert.AreEqual("93LkmoWksp9ytNVZIPXi9KJU1uvlC9clZ/CkUHf6uEE", target.FingerPrintSHA256);
        }

        /// <summary>
        ///A test for CanTrust
        ///</summary>
        [TestMethod]
        public void CanTrustTest()
        {
            HostKeyEventArgs target = new HostKeyEventArgs(GetKeyHostAlgorithm());
            bool expected = false;
            bool actual;
            target.CanTrust = expected;
            actual = target.CanTrust;
            Assert.AreEqual(expected, actual);
        }

        private static KeyHostAlgorithm GetKeyHostAlgorithm()
        {
            using (var s = GetData("Key.RSA.txt"))
            {
                var privateKey = new PrivateKeyFile(s);
                return (KeyHostAlgorithm)privateKey.HostKeyAlgorithms.Single(x => x.Name == "rsa-sha2-512");
            }
        }

    }
}
