# JSON export

The metadata of all content ([[markdown]] and [[orgmode]]), along with their link relationships, can be retrieved as `JSON` using one of the following means:

1. `emanote export`: a CLI command that dumps the JSON export to stdout.
2. [-/export.json](-/export.json): an URL to retrieve the JSON via live server or from the statically generated site.

Option (1) might be useful for text editor plugins, though option (2) is bound to be faster on larger notebooks when requested via the live server (`emanote run`).

## CLI examples

Here are some examples of running `emanote export`. These commands are run on the `./docs` directory of the Emanote source repository.

```sh
git clone https://github.com/srid/emanote.git
cd ./emanote/docs
```

### Get the list of files

```sh
$ emanote export | jq .files | jq keys
[
  "architecture.md",
  "demo.md",
  "demo/custom-style.md",
  "demo/embed.md",
  "demo/file-links.md",
  [..]
]
```

### Get a single file

```sh
$ emanote export | jq '.files | .[] | select(.filePath=="architecture.md")'   
{
  "filePath": "architecture.md",
  "links": [],
  "meta": {
    "order": 99,
    "page": {
      "description": "Emanote is a Haskell program that, at its essense, transforms a bunch of source files (Markdown, static files, etc.) into a target website. It does that in a reactive manner such that as the source files change the resultant website updates in real-time (thanks to Ema's hot-reload via websocket)."
    },
    "tags": [
      "emanote/dev"
    ]
  },
  "parentNote": "index.md",
  "title": "Architecture",
  "url": "architecture"
}
```

### Get all link targets from a note

```sh
$ emanote export | jq '.files | .[] | select(.filePath=="start/neuron.md") | .links | .[] | .resolvedRelTarget.contents'
"demo/neuron-layout"
"demo/yaml-config"
"demo/yaml-config"
"demo/file-links"
"demo"
```

### Get the list of tags

```sh
$ emanote export | jq '.files | .[] | .meta.tags' | jq -s 'flatten(1)'
[
  "emanote/dev",
  "emanote/syntax/demo",
  "emanote/syntax/demo",
  "emanote/syntax/demo",
  "emanote/yaml/demo",
  "external"
]
```

### Get all files associated with a tag

```sh
$ emanote export | jq '.files | .[] | select( any( .meta.tags[]; . == "external" ))'   
{
  "filePath": "examples.md",
  "links": [],
  "meta": {
    "order": 10,
    "page": {
      "description": "Here is an assorted collection of websites generated by Emanote, sorted alphabetically:"
    },
    "tags": [
      "external"
    ]
  },
  "parentNote": "index.md",
  "title": "Examples",
  "url": "examples"
}
```