# Spirograph Drawing

## Overview

The Spirograph Drawing project is a Python program that simulates the creation of intricate and beautiful geometric patterns reminiscent of a Spirograph toy. Users can generate mesmerizing designs by selecting various parameters like pen size, inner circle radius, outer circle radius, and the number of steps.

## Features

- **Parameter Customization:**
  - Users can customize parameters such as pen size, inner circle radius, outer circle radius, and the number of steps to create unique patterns.

- **Pattern Generation:**
  - The program uses mathematical equations to generate spirograph-like patterns based on the provided parameters.

- **SVG Export:**
  - Users can export the generated pattern as an SVG (Scalable Vector Graphics) file for further use or printing.

## How to Use

1. Run the Spirograph Drawing program on your device.
2. Input the desired parameters for pen size, inner circle radius, outer circle radius, and the number of steps.
3. Generate the spirograph pattern based on the specified parameters.
4. View and appreciate the intricate pattern created.
5. Optionally, export the pattern as an SVG file for further use or printing.

## How to Run

1. Clone the repository:
   ```bash
   git clone <repository_url>
   cd spirograph-drawing
   ```

2. Run the program:
   ```bash
   python spirograph_drawing.py
   ```

## Contribution Guidelines

Contributions to the Spirograph Drawing project are welcome! If you'd like to contribute, please follow these guidelines:

1. Fork the repository.
2. Create a new branch for your feature/fix: `git checkout -b feature/your-feature`.
3. Make your changes and commit them: `git commit -m 'Add feature/fix'`.
4. Push to the branch: `git push origin feature/your-feature`.
5. Create a pull request, explaining the changes made.



Replace `<repository_url>` with the actual URL of your repository. Customize the content to match your specific Spirograph drawing project and requirements.