/*Given an undirected graph, return true if and only if it is bipartite.

Recall that a graph is bipartite if we can split it's set of nodes into two independent subsets A and B such that every edge in the graph has one node in A and another node in B.

The graph is given in the following form: graph[i] is a list of indexes j for which the edge between nodes i and j exists.  Each node is an integer between 0 and graph.length - 1.  There are no self edges or parallel edges: graph[i] does not contain i, and it doesn't contain any element twice.

Example 1:
Input: [[1,3], [0,2], [1,3], [0,2]]
Output: true
Explanation: 
The graph looks like this:
0----1
|    |
|    |
3----2
We can divide the vertices into two groups: {0, 2} and {1, 3}.

Example 2:
Input: [[1,2,3], [0,2], [0,1,3], [0,2]]
Output: false
Explanation: 
The graph looks like this:
0----1
| \  |
|  \ |
3----2
We cannot find a way to divide the set of nodes into two independent subsets.
*/
class Solution {
public:
    bool dfs(vector<vector<int>>& g, int k,vector<int>& vis,int c){
        if(vis[k]!=-1 && vis[k]!=c) return 0;
        vis[k] = c;
        bool ans=1;
        for(int i=0;i<g[k].size();i++){
            if(vis[g[k][i]]==-1){
                ans = dfs(g,g[k][i],vis, 1-c);
                if(!ans) return 0;
                }
            if(vis[g[k][i]]==c) return 0;
        }
        return 1;
    }
    bool isBipartite(vector<vector<int>>& g) {
        vector<int> vs(g.size(),-1);
        bool a =1;
        for(int i =0;i<g.size();i++){
            if(vs[i]==-1){
                a &= dfs(g,i,vs,1);
            }
        }
        return a;
    }
    
};