SparkFun Qwiic Single Relay
========================================

![SparkFun Qwiic Single Relay](https://cdn.sparkfun.com/assets/parts/1/3/4/5/1/15093-SparkFun_Qwiic_Single_Relay-01.jpg)

[*SparkFun Qwiic Single Relay (COM-15093)*](https://www.sparkfun.com/products/15093)
Have you ever wanted to control something powerful? Have you ever needed to turn on/off a high voltage device from your Arduino? Now you can with the Qwiic Relay! This device allows you to control large power loads with simple I<sup>2</sup>C commands. The Qwiic Relay can handle 10 Amps at 120 Volts AC, perfect for large inductive loads like DC motors or blenders.

The Qwiic Relay comes with a default I<sup>2</sup>C address but can be changed with a simple command allowing you to control over 100 Qwiic Relays on a single bus!<sup>[1](#powerWarning)</sup>

The Qwiic Relay comes fully assembled and uses the simple [Qwiic](https://www.sparkfun.com/qwiic) interface. No soldering, no voltage translation, no figuring out which pin is SDA or SCL, just plug and go!

<div class="alert alert-warning"><b>Note:</b> Controlling high voltage (110/220VAC) requires certain precautions. A beginner can do it but if you're unsure then please consider the pre-made <a href="https://www.sparkfun.com/products/14236">IoT Power Relay</a>. It's not I<sup>2</sup>C but the IoT Power Relay contains shielding to prevent accidental shock.</div>

<a name="powerWarning"></a>Footnote 1: Toggling lots of relays on a 3.3V bus can cause voltage spikes. An external power supply will be required.

Repository Contents
-------------------

* **/Documents** - Datasheets
* **/Firmware** - Latest firmware and examples. 
* **/Hardware** - Eagle design files (.brd, .sch)

Documentation
--------------
* **[Hookup Guide](https://learn.sparkfun.com/tutorials/qwiic-single-relay-hookup-guide)** - Basic hookup guide

Arduino Library
--------------
* **[SparkFun Qwiic Relay Arduino Library](https://github.com/sparkfun/SparkFun_Qwiic_Relay_Arduino_Library)** - SparkFun Arduino Library for controlloing the Qwiic Single and Quad Relay

License Information
-------------------

This product is _**open source**_! 

Please review the LICENSE.md file for license information. 

If you have any questions or concerns on licensing, please contact techsupport@sparkfun.com.

Please use, reuse, and modify these files as you see fit. Please maintain attribution to SparkFun Electronics and release under the same license.

Distributed as-is; no warranty is given.

- Your friends at SparkFun.
