<h1 align="center">Learn Git With Me</h1>
<p align="center">
Learn Git with Me is a free, open-source platform for learning Git and GitHub.
</p>
<div align="center">
  <a href="https://github.com/spaciousejar/learn-git-with-me/stargazers"><img alt="GitHub Repo stars" src="https://img.shields.io/github/stars/spaciousejar/learn-git-with-me"></a>
  <a href="https://twitter.com/spaciousejar"><img alt="Twitter Follow" src="https://img.shields.io/twitter/follow/spaciousejar"></a>
  <a href="[https://github.com/spaciousejar/learn-git-with-me/blob/main/LICENSE]"><img alt="License" src="https://img.shields.io/badge/License-MIT-yellow.svg"></a>
</div>
<video alt="Git ME" src="https://github.com/user-attachments/assets/ea2661ad-59dc-4427-87cd-ceb3b09f78c1" width="100%"></video>

## ⚡ Live 

Try it out for yourself!

Visit: <https://www.gitme.live>


## ⭐ Features

### 🐭 Frameworks

- **[Next.js](https://nextjs.org/)** - The React Framework for the Web (with **App Directory**)

### 🐮 Platforms

- **[Vercel](https://vercel.com/)** – Deploy your Next.js app with ease


### 🐒 UI

- **[Tailwind CSS](https://tailwindcss.com/)** – Utility-first CSS framework for rapid UI development
- **[Shadcn/ui](https://ui.shadcn.com/)** – Re-usable components built using Radix UI and Tailwind CSS
- **[next/font](https://nextjs.org/docs/basic-features/font-optimization)** – Optimize custom fonts and remove external network requests for improved performance
- **[MDX](https://mdxjs.com/docs)** – Markdown for the components
  
### 🐴 Code Quality

- **[TypeScript](https://www.typescriptlang.org/)** – Static type checker for end-to-end type safety
- **[Prettier](https://prettier.io/)** – Opinionated code formatted for consistent code style
- **[ESLint](https://eslint.org/)** – Pluggable linter for Next.js and TypeScript


### 🐑 Performance

- **[Vercel Analytics](https://vercel.com/analytics)** – Real-time performance metrics for your Next.js app



## 📦 Apps and Packages

- `web`: The main Next.js application
- `UI`: Shared UI components


## Contributing

Visit our [contributing guide](https://github.com/spaciousejar/learn-git-with-me/blob/main/CONTRIBUTING.md) to learn how to contribute.
- your feedback and contributions are welcome!


## 📜 License

This project is licensed under the MIT License. For more information, see the [LICENSE](./LICENSE) file.

You can check out [the Next.js GitHub repository](https://github.com/vercel/next.js/) 

