package sootup.codepropertygraph.propertygraph.edges;

/*-
* #%L
* Soot - a J*va Optimization Framework
* %%
Copyright (C) 2024 Michael Youkeim, Stefan Schott and others
* %%
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation, either version 2.1 of the
* License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Lesser Public License for more details.
*
* You should have received a copy of the GNU General Lesser Public
* License along with this program.  If not, see
* <http://www.gnu.org/licenses/lgpl-2.1.html>.
* #L%
*/

import java.util.Objects;
import sootup.codepropertygraph.propertygraph.nodes.PropertyGraphNode;

public abstract class PropertyGraphEdge {
  private final PropertyGraphNode source;
  private final PropertyGraphNode destination;

  public PropertyGraphEdge(PropertyGraphNode source, PropertyGraphNode destination) {
    this.source = source;
    this.destination = destination;
  }

  public PropertyGraphNode getSource() {
    return source;
  }

  public PropertyGraphNode getDestination() {
    return destination;
  }

  public abstract String getLabel();

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    PropertyGraphEdge that = (PropertyGraphEdge) o;
    return source.equals(that.source)
        && destination.equals(that.destination)
        && getLabel().equals(that.getLabel());
  }

  @Override
  public int hashCode() {
    return Objects.hash(source, destination, getLabel());
  }
}
