package sootup.apk.frontend.instruction;

/*-
 * #%L
 * SootUp
 * %%
 * Copyright (C) 2022 - 2024 Kadiray Karakaya, Markus Schmidt, Jonas Klauke, Stefan Schott, Palaniappan Muthuraman, Marcus Hüwe and others
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 2.1 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-2.1.html>.
 * #L%
 */

import org.jf.dexlib2.Opcode;
import org.jf.dexlib2.iface.instruction.Instruction;
import org.jf.dexlib2.iface.instruction.NarrowLiteralInstruction;
import org.jf.dexlib2.iface.instruction.OneRegisterInstruction;
import org.jf.dexlib2.iface.instruction.WideLiteralInstruction;
import sootup.apk.frontend.main.DexBody;
import sootup.core.jimple.Jimple;
import sootup.core.jimple.basic.StmtPositionInfo;
import sootup.core.jimple.common.constant.Constant;
import sootup.core.jimple.common.constant.IntConstant;
import sootup.core.jimple.common.constant.LongConstant;
import sootup.core.jimple.common.stmt.JAssignStmt;

public class ConstInstruction extends DexLibAbstractInstruction {

  public ConstInstruction(Instruction instruction, int codeAdress) {
    super(instruction, codeAdress);
  }

  @Override
  public void jimplify(DexBody body) {
    int dest = ((OneRegisterInstruction) instruction).getRegisterA();
    Constant cst = getConstant();
    JAssignStmt assign =
        Jimple.newAssignStmt(
            body.getRegisterLocal(dest), cst, StmtPositionInfo.getNoStmtPositionInfo());
    setStmt(assign);
    body.add(assign);
  }

  /** Return the literal constant for this instruction. */
  private Constant getConstant() {
    long literal = 0;
    if (instruction instanceof WideLiteralInstruction) {
      literal = ((WideLiteralInstruction) instruction).getWideLiteral();
    } else if (instruction instanceof NarrowLiteralInstruction) {
      literal = ((NarrowLiteralInstruction) instruction).getNarrowLiteral();
    } else {
      throw new RuntimeException("literal error: expected narrow or wide literal.");
    }

    Opcode opcode = instruction.getOpcode();
    switch (opcode) {
      case CONST:
      case CONST_4:
      case CONST_HIGH16:
      case CONST_16:
        return IntConstant.getInstance((int) literal);

      case CONST_WIDE_HIGH16:
      case CONST_WIDE:
      case CONST_WIDE_16:
      case CONST_WIDE_32:
        return LongConstant.getInstance(literal);
      default:
        throw new IllegalArgumentException(
            "Expected a const or a const-wide instruction, got neither.");
    }
  }
}
