/*
 * Decompiled with CFR 0.152.
 */
package pkgmain;

import java.io.File;
import java.lang.module.Configuration;
import java.lang.module.ModuleFinder;
import java.lang.module.ModuleReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.Set;
import pkgcommon.IdGen;
import pkgcommon.LayerPrinter;

public class Main {
    private String id = IdGen.createID();

    public static void main(String[] stringArray) throws Exception {
        new Main();
    }

    public Main() throws Exception {
        LayerPrinter.printRuntimeInfos((ModuleLayer)this.getClass().getModule().getLayer());
        System.out.println("\nCreate a new 'foo layer #1' as a child of the current layer...");
        ModuleLayer moduleLayer = this.createFooLayer();
        System.out.println("Reflective call to pkgfoo.Foo in modfoo in 'foo layer #1'...");
        this.callFoo(moduleLayer);
        System.out.println("\nCreate a new 'bar layer #1' as a child of the current layer...");
        moduleLayer = this.createBarLayer(false);
        System.out.println("Reflective call to pkgbar.Bar in modbar in 'bar layer #1'...");
        this.callBar(moduleLayer);
        System.out.println("\nCreate a new 'bar layer #2' as a child of the current layer...");
        moduleLayer = this.createBarLayer(true);
        System.out.println("Reflective call to pkgbar.Bar in modbar in 'bar layer #2'...");
        this.callBar(moduleLayer);
    }

    public String toString() {
        return this.getClass().getName() + ", id=" + this.id;
    }

    private void callFoo(ModuleLayer moduleLayer) throws Exception {
        this.call(moduleLayer, "modfoo", "pkgfoo.Foo", "toString");
    }

    private void callBar(ModuleLayer moduleLayer) throws Exception {
        this.call(moduleLayer, "modbar", "pkgbar.Bar", "toString");
    }

    private void call(ModuleLayer moduleLayer, String string, String string2, String string3) throws Exception {
        Class<?> clazz = moduleLayer.findLoader(string).loadClass(string2);
        Constructor<?> constructor = clazz.getDeclaredConstructor(new Class[0]);
        constructor.setAccessible(true);
        Object obj = constructor.newInstance(new Object[0]);
        Method method = obj.getClass().getMethod(string3, new Class[0]);
        method.setAccessible(true);
        System.out.println(method.invoke(obj, new Object[0]));
    }

    private ModuleLayer createFooLayer() {
        return this.createLayer(Main.class.getModule().getLayer(), Main.class.getModule().getClassLoader(), "modfoo", "./foomlib");
    }

    private ModuleLayer createBarLayer(boolean bl) {
        return this.createLayer(Main.class.getModule().getLayer(), Main.class.getModule().getClassLoader(), "modbar", "./barmlib", bl);
    }

    private ModuleLayer createLayer(ModuleLayer moduleLayer, ClassLoader classLoader, String string, String string2) {
        return this.createLayer(moduleLayer, classLoader, string, string2, false);
    }

    private ModuleLayer createLayer(ModuleLayer moduleLayer, ClassLoader classLoader, String string, String string3, boolean bl) {
        String string4 = new File(System.getProperty("user.dir")).getAbsolutePath() + string3;
        ModuleFinder moduleFinder = ModuleFinder.of(Paths.get(string4, new String[0]).toAbsolutePath().normalize());
        Set<ModuleReference> set = moduleFinder.findAll();
        HashSet<String> hashSet = new HashSet<String>();
        set.stream().map(moduleReference -> moduleReference.descriptor().name()).filter(string2 -> string.contains(string)).forEach(string2 -> hashSet.add(string));
        if (hashSet.isEmpty()) {
            throw new RuntimeException("No observable module " + string + " found on the module paths. Terminating ...");
        }
        Configuration configuration = moduleLayer.configuration().resolve(bl ? moduleFinder : ModuleFinder.of(new Path[0]), bl ? ModuleFinder.of(new Path[0]) : moduleFinder, hashSet);
        ModuleLayer moduleLayer2 = moduleLayer.defineModulesWithOneLoader(configuration, classLoader);
        return moduleLayer2;
    }
}

